<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id('id');
            $table->unsignedBigInteger('user_id')->nullable();
            $table->json('skill_set')->nullable();
            $table->float('monthly_rate' , 8,2)->nullable();
            $table->float('hourly_rateINR')->nullable();
            $table->float('hourly_rateUSD')->nullable();
            $table->string('experience', 255)->nullable();
            $table->enum('status', ['available', 'occupied'])->default('available')->nullable();
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employees');
    }
};
