<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id('project_id');
            $table->string('project_name');
            $table->unsignedBigInteger('project_manager_id');
            $table->unsignedBigInteger('project_TL_id');
            $table->unsignedBigInteger('project_type');
            $table->string('project_type_note')->nullable();
            $table->string('client_name');
            $table->text('description')->nullable();
            $table->json('technology');
            $table->json('assigned_employee');
            $table->dateTime('start_date');
            $table->dateTime('end_date');
            $table->enum('status', ['initiated', 'inprogress', 'completed', 'onhold'])->default('initiated');
            $table->float('total_resource_cost');
            $table->float('infra_cost')->nullable();
            $table->float('pm_cost');
            $table->float('travel_cost')->nullable();
            $table->float('comission')->nullable();
            $table->float('accomodation_cost')->nullable();
            $table->float('profit_margin')->nullable();
            $table->float('marketing_cost')->nullable();
            $table->float('sales_cost')->nullable();
            $table->float('total_project_cost');
            $table->string('billing_type');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
