<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('project_resource_mappings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('project_id');
            $table->unsignedBigInteger('resource_id');
            $table->string('name', 255);
            $table->integer('cost_per_hour');
            $table->integer('duration');
            $table->integer('total_cost');
            $table->enum('status', ['active', 'inactive', 'pending'])->default('active');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('modified_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('project_resource_mappings');
    }
};
