@extends('master.authMaster')

@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            @if (session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            @if (session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
            <!-- Bootstrap Table with Header - Light -->
            <div class="card">
                <h5 class="card-header">Users</h5>
                <div>
                    <a href="{{ route('employee.add.view') }}"><button class="btn btn-success">ADD USER</button></a>
                </div>
                <div class="table-responsive text-nowrap">

                    <table class="table" id="employee-table">
                        <thead class="table-light">
                            <tr>
                                <th>id</th>
                                <th>name</th>
                                <th>Employee Code</th>
                                {{-- <th>Experience</th> --}}
                                {{-- <th>Monthly Rate</th> --}}
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- Bootstrap Table with Header - Light -->

        </div>
    @endsection
    @section('scripts')
        <!-- jQuery first -->
        <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

        <!-- DataTables CSS & JS -->
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

        <script>
            $(document).ready(function() {
                // setInterval(function() {
                //     location.reload();
                // }, 5000);
                $('#employee-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('employees.data') }}",
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'employee_code',
                            name: 'employee_code'
                        },
                        // {
                        //     data: 'experience',
                        //     name: 'experience'
                        // },
                        // {
                        //     data: 'monthly_rate',
                        //     name: 'monthly_rate'
                        // },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ]
                });
            });

            $(document).on('click', '.delete-btn', function() {
                let id = $(this).data('id');
                let url = "{{ route('employees.destroy', ':id') }}".replace(':id', id);

                if (confirm('Are you sure to delete this employee?')) {
                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        data: {
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            $('#employee-table').DataTable().ajax.reload();
                        }
                    });
                }
            });
        </script>
    @endsection
