@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row mb-6 gy-6">
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">Add Project</h5>
                            <small class="text-body-secondary float-end">Project Entry</small>
                        </div>

                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="card-body">
                            <form method="POST" action="{{ route('project.submit') }}">
                                @csrf

                                <div class="firstPage">
                                    {{-- Project Name --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Name <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="text" name="project_name" class="form-control"
                                                value="{{ old('project_name') }}" placeholder="Project Alpha">
                                            @error('project_name')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    {{-- Project Manager --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Review Project Manager<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select name="project_manager_id" class="form-select">
                                                <option value="">-- Select Project Manager --</option>
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 2)
                                                        <option value="{{ $user->id }}"
                                                            {{ old('project_manager_id') == $user->id ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('project_manager_id')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Team Lead --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Assign Team Lead <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select name="project_TL_id" class="form-select">
                                                <option value="">-- Select Team Lead --</option>
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 4)
                                                        <option value="{{ $user->id }}"
                                                            {{ old('project_TL_id') == $user->id ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('project_TL_id')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Project Type --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Type <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-5">
                                            <select name="project_type" class="form-select">
                                                <option value="">-- Select Type --</option>
                                                <option value="1" {{ old('project_type') == 1 ? 'selected' : '' }}>
                                                    Website
                                                </option>
                                                <option value="1" {{ old('project_type') == 1 ? 'selected' : '' }}>
                                                    Admin
                                                    Dashboard
                                                </option>
                                                <option value="1" {{ old('project_type') == 1 ? 'selected' : '' }}>
                                                    Website
                                                    + Admin Dashboard
                                                </option>
                                                <option value="2" {{ old('project_type') == 2 ? 'selected' : '' }}>
                                                    Website
                                                    + Mobile App (iOS + Android)</option>
                                                <option value="3" {{ old('project_type') == 3 ? 'selected' : '' }}>
                                                    Website
                                                    + Mobile App (iOS + Android) + Playstore assistance</option>
                                                <option value="4" {{ old('project_type') == 4 ? 'selected' : '' }}>apk
                                                </option>
                                            </select>
                                            @error('project_type')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-sm-5">
                                            <input type="text" name="project_type_note" class="form-control"
                                                placeholder="One-line description. e.g lms/cms"
                                                value="{{ old('project_type_note') }}">
                                            @error('project_type_note')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>


                                    {{-- Client Name --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Client Name <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="text" name="client_name" class="form-control"
                                                value="{{ old('client_name') }}"
                                                placeholder="Enter the Project Manager Cost">
                                            @error('client_name')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Technology --}}
                                    <div class="row mb-6">
                                        <label class="col-sm-2 col-form-label" for="technology">Technology
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            <select id="technology" name="technology[]" multiple
                                                class="form-select select2 @error('technology') is-invalid @enderror">
                                                <option value="PHP"
                                                    {{ in_array('PHP', old('technology', [])) ? 'selected' : '' }}>PHP
                                                </option>
                                                <option value="Laravel"
                                                    {{ in_array('Laravel', old('technology', [])) ? 'selected' : '' }}>
                                                    Laravel
                                                </option>
                                                <option value="JavaScript"
                                                    {{ in_array('JavaScript', old('technology', [])) ? 'selected' : '' }}>
                                                    JavaScript</option>
                                                <option value="VueJS"
                                                    {{ in_array('VueJS', old('technology', [])) ? 'selected' : '' }}>VueJS
                                                </option>
                                                <option value="React"
                                                    {{ in_array('React', old('technology', [])) ? 'selected' : '' }}>React
                                                </option>
                                                <option value="MySQL"
                                                    {{ in_array('MySQL', old('technology', [])) ? 'selected' : '' }}>MySQL
                                                </option>
                                            </select>
                                            @error('technology')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Description --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Description in Brief</label>
                                        <div class="col-sm-10">
                                            <textarea name="description" id="description" class="form-control" rows="4" placeholder="Project description...">{{ old('description') }}</textarea>
                                            @error('description')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Start Date && End Date --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Start Date <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-4">
                                            <input type="date" name="start_date" class="form-control"
                                                value="{{ old('start_date') }}">
                                            @error('start_date')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <label class="col-sm-2 col-form-label">End Date <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-4">
                                            <input type="date" name="end_date" class="form-control"
                                                value="{{ old('end_date') }}">
                                            @error('end_date')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Status --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Status</label>
                                        <div class="col-sm-10">
                                            <select name="status" class="form-select">
                                                <option value="initiated"
                                                    {{ old('status') == 'initiated' ? 'selected' : '' }}>
                                                    Initiated</option>
                                                <option value="inprogress"
                                                    {{ old('status') == 'inprogress' ? 'selected' : '' }}>In Progress
                                                </option>
                                                <option value="completed"
                                                    {{ old('status') == 'completed' ? 'selected' : '' }}>
                                                    Completed</option>
                                                <option value="onhold" {{ old('status') == 'onhold' ? 'selected' : '' }}>
                                                    On
                                                    Hold</option>
                                            </select>
                                            @error('status')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="secondPage" style=" display:none;">

                                    {{-- Assign Resources --}}
                                    <div class="row mb-6">
                                        <label class="col-sm-2 col-form-label" for="assigned_employee">Assign Resources
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            <select id="assigned_employee" name="assigned_employee[]" multiple
                                                class="form-select select2 @error('assigned_employee') is-invalid @enderror">
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 3)
                                                        <option value="{{ $user->id }}"
                                                            data-name="{{ $user->name }}"
                                                            data-rate="{{ $user->employee->monthly_rate ?? 0 }}"
                                                            {{ in_array($user->id, old('assigned_employee', [])) ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('assigned_employee')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Display Selected Resources and Monthly Rates --}}
                                    <div class="row mb-4">
                                        <hr>
                                        <label class="col-sm-12 col-form-label fw-bold rounded p-2 mb-2 text-primary"
                                            style="font-size: 16px;">Resources Name and Cost (INR)
                                        </label>
                                        <hr>
                                        <div id="resource-body" class="mt-4">
                                            <table class="excel-table">
                                                <thead>
                                                    <tr>
                                                        <th><b>Resource Name</b></th>
                                                        <th><b>Rate per Hour</b></th>
                                                        <th><b>Duration(Hourly)</b></th>
                                                        <th><b>Total Cost per Resource</b></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="selected-resources">
                                                    <!-- Rows will be appended here -->
                                                </tbody>
                                            </table>
                                        </div>

                                        {{-- Total Resource Cost --}}
                                        <div class="row mt-3 mb-6">
                                            <label class="col-sm-2 col-form-label">Total Resource Cost (INR)<span
                                                    class="text-danger">*</span></label>
                                            <div class="col-sm-10">
                                                <input type="decimal" id="total_resource_cost" name="total_resource_cost"
                                                    class="form-control" readonly
                                                    value="{{ old('total_resource_cost') }}">
                                                @error('total_resource_cost')
                                                    <div class="text-danger mt-1">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <hr>
                                    </div>

                                    {{-- operational cost --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Operational Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="decimal" name="infra_cost" class="form-control"
                                                value="{{ old('infra_cost') }}" placeholder="Enter the Operational Cost">
                                            @error('infra_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Manager(PM) Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="decimal" name="pm_cost" class="form-control"
                                                value="{{ old('pm_cost') }}"
                                                placeholder="Enter the Project Manager Cost">
                                            @error('pm_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>



                                    <hr>
                                    {{-- <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Travelling Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="travel_cost" class="form-control"
                                                value="{{ old('travel_cost') }}" placeholder="Enter the Travelling Cost">
                                            @error('travel_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Comission<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="comission" class="form-control"
                                                value="{{ old('comission') }}" placeholder="Enter the Comission">
                                            @error('comission')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Accomodation Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="accomodation_cost" class="form-control"
                                                value="{{ old('accomodation_cost') }}"
                                                placeholder="Enter the Accomodation Cost">
                                            @error('accomodation_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        <hr>
                                    </div> --}}

                                    <label class="col-sm-12 col-form-label fw-bold rounded p-2 mb-2 text-primary"
                                        style="font-size: 16px;">Other Costs:</label>
                                    <hr>

                                    <div class="row mb-3">
                                        <label class="col-sm-2 col-form-label">Select Cost Type</label>
                                        <div class="col-sm-10" id="cost-checkboxes">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input cost-toggle" type="checkbox"
                                                    value="travel_cost" id="travel_cost">
                                                <label class="form-check-label" for="travel_cost">Travelling Cost</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input cost-toggle" type="checkbox"
                                                    value="comission" id="comission">
                                                <label class="form-check-label" for="comission">Comission</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input cost-toggle" type="checkbox"
                                                    value="accomodation_cost" id="accomodation_cost">
                                                <label class="form-check-label" for="accomodation_cost">Accomodation
                                                    Cost</label>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input cost-toggle" type="checkbox"
                                                    value="other" id="other">
                                                <label class="form-check-label" for="other">Other (Custom)</label>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Container to append input fields -->
                                    <div id="cost-inputs-container"></div>

                                    <!-- Custom Other Costs -->
                                    <div id="other-costs-group" style="display: none;">
                                        <label class="col-sm-12 col-form-label text-primary fw-semibold">Other Custom
                                            Costs:</label>
                                        <div id="other-costs-container"></div>
                                        <div class="text-end">
                                            <button type="button" id="add-other-cost"
                                                class="btn btn-sm btn-outline-primary mt-2">+ Add More</button>
                                        </div>
                                    </div>


                                    <hr>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Profit Margin</label>
                                        <div class="col-sm-10">
                                            <input type="decimal" name="profit_margin" class="form-control"
                                                value="{{ old('profit_margin') }}"
                                                placeholder="Enter the Project Margin">
                                            @error('profit_margin')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Marketing Cost</label>
                                        <div class="col-sm-10">
                                            <input type="decimal" name="marketing_cost" class="form-control"
                                                value="{{ old('marketing_cost') }}"
                                                placeholder="Enter the Marketing Cost">
                                            @error('marketing_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Sales Cost</label>
                                        <div class="col-sm-10">
                                            <input type="decimal" name="sales_cost" class="form-control"
                                                value="{{ old('sales_cost') }}" placeholder="Enter the Sales Cost">
                                            @error('sales_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label fw-bold text-primary">Total Project Cost
                                            (INR)
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            <input type="decimal" id="total_project_cost" name="total_project_cost"
                                                class="form-control bg-light border-primary" readonly>
                                        </div>
                                    </div>

                                    <div class="row mb-4" style="display: none">
                                        <label class="col-sm-2 col-form-label">Billing Type <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select class="form-select" id="billing_type" name="billing_type"
                                                onchange="handleBillingTypeChange(this.value)">
                                                {{-- <option value="">-- Select Billing Type --</option> --}}
                                                <option value="module_wise" selected>Module-wise Billing</option>
                                            </select>
                                        </div>
                                    </div>

                                    {{-- FOR DYNAMIC BILLING FIELDS --}}

                                    <!-- Normal Billing Section -->
                                    <div id="normal_billing_fields" style="display: none;">
                                        @php
                                            $normalBillingStages = [
                                                'advance' => 'Advance Payment',
                                                'uat' => 'UAT Payment',
                                                'golive' => 'Go-Live Payment',
                                            ];
                                        @endphp

                                        @foreach ($normalBillingStages as $key => $label)
                                            <div class="row mb-3">
                                                <label class="col-sm-3 col-form-label">{{ $label }} (%)</label>
                                                <div class="col-sm-2">
                                                    <input type="decimal" name="{{ $key }}_payment"
                                                        class="form-control" placeholder="e.g. 30">
                                                </div>
                                                <div class="col-sm-3">
                                                    <input type="text" name="{{ $key }}_description"
                                                        class="form-control" placeholder="Description">
                                                </div>
                                                <div class="col-sm-2">
                                                    <input type="date" name="{{ $key }}_start_date"
                                                        class="form-control">
                                                </div>
                                                <div class="col-sm-2">
                                                    <input type="date" name="{{ $key }}_end_date"
                                                        class="form-control">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                    <!-- Module-Wise Billing Section -->
                                    <div id="module_wise_billing_fields" style="display: none;">

                                        <button type="button" class="btn btn-outline-primary btn-sm mb-3"
                                            onclick="addModuleRow()">+ Add Billing Milestones</button>
                                        <div id="module-wise-container"></div>
                                    </div>

                                    <!-- One Time Billing -->
                                    <div id="single_field_billing" style="display: none;">
                                        <div class="row mb-3">
                                            <label class="col-sm-3 col-form-label" id="single_field_label">Billing
                                                Detail</label>
                                            <div class="col-sm-3">
                                                <input type="decimal" name="billing_note" class="form-control"
                                                    placeholder="Enter note or percentage">
                                            </div>
                                            <div class="col-sm-3">
                                                <input type="text" name="billing_description" class="form-control"
                                                    placeholder="Billing Description">
                                            </div>
                                            <div class="col-sm-1">
                                                <input type="date" name="billing_start_date" class="form-control">
                                            </div>
                                            <div class="col-sm-2">
                                                <input type="date" name="billing_end_date" class="form-control">
                                            </div>
                                        </div>
                                    </div>

                                    {{-- END DYNAMIC BILLING FIELDS --}}


                                </div>

                                {{-- Submit Button --}}
                                <div class="row justify-content-between mt-4">
                                    <div class="col-sm-6">
                                        {{-- only on second page --}}
                                        <button id="backButton" type="button" class="btn btn-secondary"
                                            style="display: none;">Back</button>
                                    </div>
                                    <div class="col-sm-6 text-end">
                                        {{-- only on first page --}}
                                        <button id="nextButton" type="button" class="btn btn-secondary">Next</button>

                                        {{-- only on second page --}}
                                        <button id="submitButton" type="submit" class="btn btn-primary"
                                            style="display: none;">Add Project</button>
                                    </div>
                                </div>


                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            function handleBillingTypeChange(value) {
                document.getElementById('normal_billing_fields').style.display = 'none';
                document.getElementById('module_wise_billing_fields').style.display = 'none';
                document.getElementById('single_field_billing').style.display = 'none';

                if (value === 'normal') {
                    document.getElementById('normal_billing_fields').style.display = 'block';
                } else if (value === 'module_wise') {
                    document.getElementById('module_wise_billing_fields').style.display = 'block';
                } else if (value === 'advance' || value === 'postpayment') {
                    document.getElementById('single_field_billing').style.display = 'block';
                    document.getElementById('single_field_label').textContent =
                        value === 'advance' ? 'Advance Billing Detail' : 'Post Live Billing Detail';
                }
            }

            function addModuleRow() {
                const container = document.getElementById('module-wise-container');
                const index = container.children.length;

                const html = `
                        <div class="row mb-3 module-row border p-2 rounded">
                            <div class="col-sm-2">
                                <input type="text" name="modules[${index}][title]" class="form-control" placeholder="Module Title">
                            </div>
                            <div class="col-sm-2">
                                <input type="decimal"  name="modules[${index}][amount]" class="form-control" placeholder="Amount (INR)">
                            </div>
                            <div class="col-sm-2">
                                <input type="text" name="modules[${index}][description]" class="form-control" placeholder="Description">
                            </div>
                            <div class="col-sm-2">
                                <input type="date" name="modules[${index}][start_date]" class="form-control">
                            </div>
                            <div class="col-sm-2">
                                <input type="date" name="modules[${index}][end_date]" class="form-control">
                            </div>
                            <div class="col-sm-2 d-flex align-items-center">
                                <button type="button" class="btn btn-danger btn-sm" onclick="this.closest('.module-row').remove()">Remove</button>
                            </div>
                        </div>
                    `;
                container.insertAdjacentHTML('beforeend', html);
            }


            // CKEDITOR.replace('description');
            $(document).ready(function() {

                $('#technology').select2({
                    placeholder: "Select Technology",
                    allowClear: true,
                    width: '100%'
                });
                $('#assigned_employee').select2({
                    placeholder: "Select Employee",
                    allowClear: true,
                    width: '100%'
                });
                $('#nextButton').on('click', function(e) {
                    e.preventDefault();
                    $('.firstPage').hide();
                    $('.secondPage').show();
                    $('#nextButton').hide();
                    $('#submitButton').show();
                    $('#backButton').show();
                });
                $('#backButton').on('click', function(e) {
                    e.preventDefault();
                    $('.firstPage').show();
                    $('.secondPage').hide();
                    $('#nextButton').show();
                    $('#submitButton').hide();
                    $('#backButton').hide();
                });

                $('#assigned_employee').on('change', updateSelectedResources);

                function updateSelectedResources() {
                    const selectedOptions = $('#assigned_employee').find('option:selected');
                    const selectedIds = selectedOptions.map(function() {
                        return String($(this).val());
                    }).get();

                    const $container = $('#selected-resources');

                    const toNum = v => {
                        const n = parseFloat(v);
                        return Number.isFinite(n) ? n : null;
                    };

                    // 1) Snapshot existing values
                    const snapshot = {};
                    $container.find('tr').each(function() {
                        const id = String($(this).data('id'));
                        snapshot[id] = {
                            rate: $(this).find('.rate').val(),
                            duration: $(this).find('.duration').val(),
                            total: $(this).find('.total-cost').val()
                        };
                    });

                    // 2) Remove rows no longer selected
                    $container.find('tr').each(function() {
                        const id = String($(this).data('id'));
                        if (!selectedIds.includes(id)) {
                            $(this).remove();
                        }
                    });

                    // 3) Add rows for newly selected resources
                    selectedOptions.each(function() {
                        const id = String($(this).val());
                        const name = $(this).data('name');
                        const defaultRate = $(this).data(
                            'rate'); // leave as string; we’ll parse later if needed

                        if ($container.find(`tr[data-id="${id}"]`).length) return; // already exists

                        const rate = snapshot[id]?.rate ?? (defaultRate !== undefined ? defaultRate : '');
                        const duration = snapshot[id]?.duration ?? '';
                        const r = toNum(rate);
                        const d = toNum(duration);
                        const total = (r !== null && d !== null) ? (r * d).toFixed(2) : '';

                        const row = `
                                <tr data-id="${id}">
                                    <td>
                                        <input type="hidden" name="resources[${id}][user_id]" value="${id}">
                                        <input type="hidden" name="resources[${id}][name]" value="${name}">
                                        <input type="text" class="form-control" value="${name}" readonly>
                                    </td>
                                    <td><input type="decimal" step="0.01" class="form-control rate" name="resources[${id}][rate]" value="${rate ?? ''}"></td>
                                    <td><input type="decimal" step="0.01" class="form-control duration" name="resources[${id}][duration]" value="${duration ?? ''}"></td>
                                    <td><input type="decimal" step="0.01" class="form-control total-cost" name="resources[${id}][total]" value="${total}" readonly></td>
                                </tr>
                            `;
                        $container.append(row);
                    });

                    // 4) Recalculate totals
                    calculateTotalResourceCost();
                    calculateTotalProjectCost();
                }


                updateSelectedResources();

                $('input[name="infra_cost"], input[name="pm_cost"], input[name="travel_cost"], input[name="comission"], input[name="accomodation_cost"], input[name="profit_margin"], input[name="marketing_cost"], input[name="sales_cost"], #total_resource_cost')
                    .on('input', calculateTotalProjectCost);
                $(document).on('input', '#cost-inputs-container input, #other-costs-container input',
                    calculateTotalProjectCost);
                calculateTotalProjectCost();



                function calculateTotalProjectCost() {
                    const toNumber = val => parseFloat(val) || 0;

                    const totalResourceCost = toNumber($('#total_resource_cost').val());
                    const infraCost = toNumber($('input[name="infra_cost"]').val());
                    const pmCost = toNumber($('input[name="pm_cost"]').val());
                    const travelCost = toNumber($('input[name="travel_cost"]').val());
                    const comission = toNumber($('input[name="comission"]').val());
                    const accomodation = toNumber($('input[name="accomodation_cost"]').val());
                    const margin = toNumber($('input[name="profit_margin"]').val());
                    const marketing = toNumber($('input[name="marketing_cost"]').val());
                    const sales = toNumber($('input[name="sales_cost"]').val());
                    let dynamicOtherCostsTotal = 0;
                    $('#cost-inputs-container input[type="decimal"]').each(function() {
                        dynamicOtherCostsTotal += toNumber($(this).val());
                    });
                    let customOtherCostsTotal = 0;
                    $('#other-costs-container input[name^="other_costs[custom]"][name$="[amount]"]').each(function() {
                        customOtherCostsTotal += toNumber($(this).val());
                    });

                    const total = totalResourceCost + infraCost + pmCost + travelCost +
                        comission + accomodation + margin + marketing + sales +
                        dynamicOtherCostsTotal + customOtherCostsTotal;

                    $('#total_project_cost').val(total.toFixed(2));
                }


                const initialBillingType = $('#billing_type').val();
                if (initialBillingType) {
                    handleBillingTypeChange(initialBillingType);
                }

                $(document).on('input', '.rate, .duration', function() {
                    const $row = $(this).closest('tr');

                    const toNum = v => {
                        const n = parseFloat(v);
                        return Number.isFinite(n) ? n : null;
                    };

                    const r = toNum($row.find('.rate').val());
                    const d = toNum($row.find('.duration').val());
                    const total = (r !== null && d !== null) ? (r * d).toFixed(2) : '';

                    $row.find('.total-cost').val(total);

                    calculateTotalResourceCost();
                    calculateTotalProjectCost();
                });

                function calculateTotalResourceCost() {
                    let total = 0;

                    $('.total-cost').each(function() {
                        total += parseFloat($(this).val()) || 0;
                    });

                    $('#total_resource_cost').val(total.toFixed(2));
                }

                //this js is for the other costs checkbox:

                const $container = $('#cost-inputs-container');
                const $otherGroup = $('#other-costs-group');
                const $otherContainer = $('#other-costs-container');

                const labelMap = {
                    travel_cost: 'Travelling Cost',
                    comission: 'Comission',
                    accomodation_cost: 'Accomodation Cost'
                };

                $('.cost-toggle').on('change', function() {
                    const selectedValue = $(this).val();

                    if (selectedValue === 'other') {
                        if ($(this).is(':checked')) {
                            $otherGroup.show();
                            if ($otherContainer.children('.row').length === 0) {
                                addOtherCostRow();
                            }
                        } else {
                            $otherGroup.hide();
                            $otherContainer.empty();
                        }
                        return;
                    }

                    const exists = $container.find(`[data-type="${selectedValue}"]`).length > 0;

                    if ($(this).is(':checked') && !exists) {
                        const row = `
                            <div class="row mb-2 cost-row" data-type="${selectedValue}">
                                <div class="col-sm-5">
                                    <label class="form-label">${labelMap[selectedValue]}</label>
                                </div>
                                <div class="col-sm-5">
                                    <input type="decimal" name="other_costs[${selectedValue}]" class="form-control" placeholder="Enter amount">
                                </div>
                                <div class="col-sm-2 text-end">
                                    <button type="button" class="btn btn-sm btn-danger remove-cost">×</button>
                                </div>
                            </div>
                        `;
                        $container.append(row);
                    } else if (!$(this).is(':checked') && exists) {
                        $container.find(`[data-type="${selectedValue}"]`).remove();
                    }
                });

                $('#add-other-cost').on('click', function() {
                    addOtherCostRow();
                });

                function addOtherCostRow() {
                    const index = $otherContainer.children('.row').length;
                    const row = `
                        <div class="row mb-2">
                            <div class="col-sm-5">
                                <input type="text" name="other_costs[custom][${index}][title]" class="form-control" placeholder="Other Cost Title">
                            </div>
                            <div class="col-sm-5">
                                <input type="decimal" name="other_costs[custom][${index}][amount]" class="form-control" placeholder="Amount">
                            </div>
                            <div class="col-sm-2 text-end">
                                <button type="button" class="btn btn-sm btn-danger remove-cost">×</button>
                            </div>
                        </div>
                    `;
                    $otherContainer.append(row);
                }

                $(document).on('click', '.remove-cost', function() {
                    const $row = $(this).closest('.row');
                    const type = $row.data('type');

                    if (type) {
                        $(`#${type}`).prop('checked', false); // Uncheck the checkbox
                    }

                    $row.remove();
                });

                // end this js is for the other costs checkbox:


                $(document).on('input', 'input[type="decimal"]', function() {
                    // Remove negative sign and plus sign
                    this.value = this.value.replace(/[+\-]/g, '');
                });
            });
        </script>
    @endsection
