@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row mb-6 gy-6">
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">Project Details :</h5>

                            {{-- pdf Button --}}
                            <small class="text-body-secondary float-end">
                                <a href="{{ route('project.details.download', $project->project_id) }}"
                                    class="btn btn-primary">PDF Export</a>
                            </small>
                        </div>

                        <div class="card-body">
                            {{-- Project Name --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Project Name <span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->project_name }}
                                </div>
                            </div>
                            {{-- Project Manager --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Review Project Manager<span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->projectManager->name }}
                                </div>
                            </div>

                            {{-- Team Lead --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Assign Team Lead <span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->teamLead->name }}
                                </div>
                            </div>

                            {{-- Project Type --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Project Type <span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-5">
                                    {{ $project->project_type }}
                                </div>

                                <div class="col-sm-5">

                                </div>
                            </div>


                            {{-- Client Name --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Client Name <span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->client_name }}
                                </div>
                            </div>

                            {{-- Technology --}}
                            <div class="row mb-6">
                                <label class="col-sm-2 col-form-label" for="technology">Technology
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="col-sm-10">
                                    <?php $technology = json_decode($project->technology); ?>
                                    @foreach ($technology as $tech)
                                        <a href="#"> {{ $tech }}</a> |
                                    @endforeach
                                </div>
                            </div>

                            {{-- Description --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Project Description in Brief<span
                                        class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    <?php
                                    echo $project->description;
                                    ?>
                                </div>
                            </div>

                            {{-- Start Date --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Start Date <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->start_date }}
                                </div>
                            </div>

                            {{-- End Date --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">End Date <span class="text-danger">*</span></label>
                                <div class="col-sm-10">
                                    {{ $project->end_date }}
                                </div>
                            </div>

                            {{-- Assign Employees/resources --}}
                            <div class="row mb-6">
                                <label class="col-sm-2 col-form-label" for="assigned_employee">Assign Employees
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="col-sm-10">
                                    @php
                                        $employees = json_decode($project->assigned_employee);
                                    @endphp

                                    @if (is_array($employees) || is_object($employees))
                                        @foreach ($employees as $employee)
                                            @foreach ($users as $user)
                                                @if ($employee == $user->id)
                                                    {{ $user->name }} |
                                                @endif
                                            @endforeach
                                        @endforeach
                                    @else
                                        No employees assigned.
                                    @endif


                                </div>
                            </div>

                            {{-- Status --}}
                            <div class="row mb-4">
                                <label class="col-sm-2 col-form-label">Status</label>
                                <div class="col-sm-10">
                                    {{ $project->status }}
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- / Content -->
    @endsection
