@extends('master.authMaster')
@section('content')
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <div class="row mb-6 gy-6">
                <div class="col-xxl">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h5 class="mb-0">Edit Project</h5>
                            <small class="text-body-secondary float-end">Edit Project Entry</small>
                        </div>

                        @if (session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif

                        <div class="card-body">
                            <form method="POST" action="{{ route('project.edit.submit', $project->project_id) }}">
                                @csrf
                                <div class="firstPage">

                                    <input type="hidden" name="billing_type" value="{{ $project->billing_type }}">

                                    {{-- Project Name --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Name <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="text" name="project_name" class="form-control"
                                                value="{{ $project->project_name }}">
                                            @error('project_name')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    {{-- Project Manager --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Review Project Manager<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select name="project_manager_id" class="form-select">
                                                <option value="">-- Select Project Manager --</option>
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 2)
                                                        <option value="{{ $user->id }}"
                                                            {{ $project->project_manager_id == $user->id ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('project_manager_id')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Team Lead --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Assign Team Lead <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select name="project_TL_id" class="form-select">
                                                <option value="">-- Select Team Lead --</option>
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 4)
                                                        <option value="{{ $user->id }}"
                                                            {{ $project->project_TL_id == $user->id ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('project_TL_id')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Project Type --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Type <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-5">
                                            <select name="project_type" class="form-select">
                                                <option value="">-- Select Type --</option>
                                                <option value="1" {{ $project->project_type == 1 ? 'selected' : '' }}>
                                                    Website
                                                </option>
                                                <option value="1" {{ $project->project_type == 1 ? 'selected' : '' }}>
                                                    Admin
                                                    Dashboard
                                                </option>
                                                <option value="1" {{ $project->project_type == 1 ? 'selected' : '' }}>
                                                    Website
                                                    + Admin Dashboard
                                                </option>
                                                <option value="2" {{ $project->project_type == 2 ? 'selected' : '' }}>
                                                    Website
                                                    + Mobile App (iOS + Android)</option>
                                                <option value="3" {{ $project->project_type == 3 ? 'selected' : '' }}>
                                                    Website
                                                    + Mobile App (iOS + Android) + Playstore assistance</option>
                                                <option value="4" {{ $project->project_type == 4 ? 'selected' : '' }}>
                                                    apk
                                                </option>
                                            </select>
                                            @error('project_type')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="col-sm-5">
                                            <input type="text" name="project_type_note" class="form-control"
                                                placeholder="One-line description. e.g lms/cms"
                                                value="{{ $project->project_type_note }}">
                                            @error('project_type_note')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>


                                    {{-- Client Name --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Client Name <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="text" name="client_name" class="form-control"
                                                value="{{ $project->client_name }}" placeholder="ABC Corp.">
                                            @error('client_name')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Technology --}}
                                    <div class="row mb-6">
                                        <label class="col-sm-2 col-form-label" for="technology">Technology
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            @php
                                                $selectedTechnology =
                                                    old('technology') ??
                                                    json_decode($project->technology ?? '[]', true);
                                            @endphp
                                            <select id="technology" name="technology[]" multiple
                                                class="form-select select2 @error('technology') is-invalid @enderror">
                                                <option value="PHP"
                                                    {{ in_array('PHP', $selectedTechnology ?? []) ? 'selected' : '' }}>PHP
                                                </option>
                                                <option value="Laravel"
                                                    {{ in_array('Laravel', $selectedTechnology ?? []) ? 'selected' : '' }}>
                                                    Laravel
                                                </option>
                                                <option value="JavaScript"
                                                    {{ in_array('JavaScript', $selectedTechnology ?? []) ? 'selected' : '' }}>
                                                    JavaScript</option>
                                                <option value="VueJS"
                                                    {{ in_array('VueJS', $selectedTechnology ?? []) ? 'selected' : '' }}>
                                                    VueJS
                                                </option>
                                                <option value="React"
                                                    {{ in_array('React', $selectedTechnology ?? []) ? 'selected' : '' }}>
                                                    React
                                                </option>
                                                <option value="MySQL"
                                                    {{ in_array('MySQL', $selectedTechnology ?? []) ? 'selected' : '' }}>
                                                    MySQL
                                                </option>
                                            </select>
                                            @error('technology')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Description --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Description in Brief<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <textarea name="description" id="description" class="form-control" rows="4"
                                                placeholder="Project description...">{{ $project->description }}</textarea>
                                            @error('description')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- Start Date --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Start Date <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="date" name="start_date" class="form-control"
                                                value="{{ $project->start_date }}">
                                            @error('start_date')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    {{-- End Date --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">End Date <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="date" name="end_date" class="form-control"
                                                value="{{ $project->end_date }}">
                                            @error('end_date')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>



                                    {{-- Status --}}
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Status</label>
                                        <div class="col-sm-10">
                                            <select name="status" class="form-select">
                                                <option value="initiated"
                                                    {{ $project->status == 'initiated' ? 'selected' : '' }}>
                                                    Initiated</option>
                                                <option value="inprogress"
                                                    {{ $project->status == 'inprogress' ? 'selected' : '' }}>In Progress
                                                </option>
                                                <option value="completed"
                                                    {{ $project->status == 'completed' ? 'selected' : '' }}>
                                                    Completed</option>
                                                <option value="onhold"
                                                    {{ $project->status == 'onhold' ? 'selected' : '' }}>On
                                                    Hold</option>
                                            </select>
                                            @error('status')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="secondPage" style="display:none;">

                                    {{-- Assign Employees/resources --}}
                                    <div class="row mb-6">
                                        <label class="col-sm-2 col-form-label" for="assigned_employee">Assign Employees
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            @php
                                                $assignedEmployees =
                                                    (array) (old('assigned_employee') ??
                                                        (json_decode($project->assigned_employee ?? '[]', true) ?? []));
                                            @endphp

                                            <select id="assigned_employee" name="assigned_employee[]" multiple
                                                class="form-select select2 @error('assigned_employee') is-invalid @enderror">
                                                @foreach ($users as $user)
                                                    @if ($user->role_id == 3 && in_array($user->id, $assignedEmployees ?? []))
                                                        <option value="{{ $user->id }}"
                                                            data-name="{{ $user->name }}"
                                                            data-rate="{{ $user->resource?->cost_per_hour ?? 0 }}"
                                                            data-duration="{{ $user->resource?->cost_per_hour ?? 0 }}"
                                                            data-total="{{ $user->resource?->cost_per_hour ?? 0 }}"
                                                            data-project="{{ $user->resource?->project_id ?? 0 }}"
                                                            {{ in_array($user->id, $assignedEmployees) ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                        </option>
                                                    @elseif ($user->role_id == 3 && !in_array($user->id, $assignedEmployees ?? []))
                                                        <option value="{{ $user->id }}"
                                                            data-name="{{ $user->name }}">
                                                            {{ $user->name }}
                                                        </option>
                                                    @endif
                                                @endforeach
                                            </select>
                                            @error('assigned_employee')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    {{-- Display Selected Resources and Monthly Rates --}}
                                    <div class="row mb-4">
                                        <hr>
                                        <label class="col-sm-12 col-form-label fw-bold rounded p-2 mb-2 text-primary"
                                            style="font-size: 16px;">Resources Name and Cost (INR)
                                        </label>
                                        <hr>
                                        <div id="resource-body" class="mt-4">
                                            <table class="excel-table">
                                                <thead>
                                                    <tr>
                                                        <th><b>Resource Name</b></th>
                                                        <th><b>Rate per Hour</b></th>
                                                        <th><b>Duration(Hourly)</b></th>
                                                        <th><b>Total Cost per Resource</b></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="selected-resources">
                                                    <!-- Rows will be appended here -->
                                                </tbody>
                                            </table>
                                        </div>

                                        {{-- Total Resource Cost --}}
                                        <div class="row mt-3 mb-6">
                                            <label class="col-sm-2 col-form-label">Total Resource Cost (INR)<span
                                                    class="text-danger">*</span></label>
                                            <div class="col-sm-10">
                                                <input type="text" id="total_resource_cost" name="total_resource_cost"
                                                    class="form-control" readonly
                                                    value="{{ $project->total_resource_cost }}">
                                                @error('total_resource_cost')
                                                    <div class="text-danger mt-1">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>
                                        <hr>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Operational Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="infra_cost" class="form-control"
                                                value="{{ $project->operational_cost }}"
                                                placeholder="Enter the Operational Cost">
                                            @error('infra_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Project Manager(PM) Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="pm_cost" class="form-control"
                                                value="{{ $project->pm_cost }}"
                                                placeholder="Enter the Project Manager Cost">
                                            @error('pm_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <hr>
                                    <label class="col-sm-12 col-form-label fw-bold rounded p-2 mb-2 text-primary"
                                        style="font-size: 16px;">Other Costs:</label>
                                    <hr>

                                    <div id="cost-inputs-container">
                                        @foreach ($otherCosts as $key => $otherCost)
                                            <div class="row mb-4">
                                                <label class="col-sm-2 col-form-label">{{ $key }}<span
                                                        class="text-danger">*</span></label>
                                                <div class="col-sm-10">
                                                    <input type="number" name="{{ $key }}"
                                                        class="form-control"
                                                        value="{{ is_array($otherCost)
                                                            ? implode(', ', array_map(fn($v) => is_array($v) ? $v['amount'] ?? '' : $v, $otherCost))
                                                            : $otherCost }}"
                                                        placeholder="Enter the Project Margin">
                                                    @error('profit_margin')
                                                        <div class="text-danger mt-1">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        @endforeach

                                    </div>


                                    <!-- Container to append input fields -->
                                    <div id="cost-inputs-container"></div>

                                    <!-- Custom Other Costs -->
                                    <div id="other-costs-group" style="display: block;">
                                        <label class="col-sm-12 col-form-label text-primary fw-semibold">Other Custom
                                            Costs:</label>
                                        <div id="other-costs-container"></div>
                                        <div class="text-end">
                                            <button type="button" id="add-other-cost"
                                                class="btn btn-sm btn-outline-primary mt-2">+ Add More</button>
                                        </div>
                                    </div>

                                    <hr>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Profit Margin<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="profit_margin" class="form-control"
                                                value="{{ $project->profit_margin }}"
                                                placeholder="Enter the Project Margin">
                                            @error('profit_margin')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Marketing Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="marketing_cost" class="form-control"
                                                value="{{ $project->marketing_cost }}"
                                                placeholder="Enter the Marketing Cost">
                                            @error('marketing_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label">Sales Cost<span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <input type="number" name="sales_cost" class="form-control"
                                                value="{{ $project->sales_cost }}" placeholder="Enter the Sales Cost">
                                            @error('sales_cost')
                                                <div class="text-danger mt-1">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row mb-4">
                                        <label class="col-sm-2 col-form-label fw-bold text-primary">Total Project Cost
                                            (INR)
                                            <span class="text-danger">*</span>
                                        </label>
                                        <div class="col-sm-10">
                                            <input type="text" id="total_project_cost" name="total_project_cost"
                                                value="{{ $project->total_project_cost }}"
                                                class="form-control bg-light border-primary" readonly>
                                        </div>
                                    </div>

                                    <div class="row mb-4" style="display: none;">
                                        <label class="col-sm-2 col-form-label">Billing Type <span
                                                class="text-danger">*</span></label>
                                        <div class="col-sm-10">
                                            <select class="form-select" id="billing_type" name="billing_type" disabled>
                                                {{-- onchange="handleBillingTypeChange(this.value)" --}}
                                                <option value="module_wise" selected>
                                                    Module-wise Billing</option>
                                            </select>
                                        </div>
                                    </div>

                                    {{-- FOR DYNAMIC BILLING FIELDS --}}

                                    <!-- Normal Billing Section -->
                                    @if ($project->billing_type == 'normal')
                                        @php
                                            $normalBillingStages = [
                                                'advance' => 'Advance Payment',
                                                'uat' => 'UAT Payment',
                                                'golive' => 'Go-Live Payment',
                                            ];

                                            $billingMap = $project->billingModules->keyBy('title');
                                        @endphp

                                        @foreach ($normalBillingStages as $key => $label)
                                            @php
                                                $billing = $billingMap[$label] ?? null;
                                            @endphp
                                            <div class="row mb-3">
                                                <label class="col-sm-3 col-form-label">{{ $label }} (%)</label>
                                                <div class="col-sm-2">
                                                    <input type="number" name="{{ $key }}_payment"
                                                        value="{{ old($key . '_payment', $billing->amount ?? '') }}"
                                                        class="form-control" placeholder="e.g. 30">
                                                </div>
                                                <div class="col-sm-3">
                                                    <input type="text" name="{{ $key }}_description"
                                                        value="{{ old($key . '_description', $billing->description ?? '') }}"
                                                        class="form-control" placeholder="Description">
                                                </div>
                                                <div class="col-sm-2">
                                                    <input type="date" name="{{ $key }}_start_date"
                                                        value="{{ old($key . '_start_date', $billing->start_date ?? '') }}"
                                                        class="form-control">
                                                </div>
                                                <div class="col-sm-2">
                                                    <input type="date" name="{{ $key }}_end_date"
                                                        value="{{ old($key . '_end_date', $billing->end_date ?? '') }}"
                                                        class="form-control">
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif

                                    <!-- Module-Wise Billing Section -->
                                    <div id="module_wise_billing_fields">
                                        <div id="module-wise-container">
                                            @foreach ($project->billingModules as $index => $module)
                                                <div class="row mb-2 module-row">
                                                    <div class="col-sm-3">
                                                        <input type="text" name="modules[{{ $index }}][title]"
                                                            class="form-control"
                                                            value="{{ old("modules.$index.title", $module->title) }}"
                                                            placeholder="Module Title">
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <input type="number" name="modules[{{ $index }}][amount]"
                                                            class="form-control"
                                                            value="{{ old("modules.$index.amount", $module->amount) }}"
                                                            placeholder="Amount">
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <input type="text"
                                                            name="modules[{{ $index }}][description]"
                                                            class="form-control"
                                                            value="{{ old("modules.$index.description", $module->description) }}"
                                                            placeholder="Description">
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <input type="date"
                                                            name="modules[{{ $index }}][start_date]"
                                                            class="form-control"
                                                            value="{{ old("modules.$index.start_date", $module->start_date) }}">
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <input type="date"
                                                            name="modules[{{ $index }}][end_date]"
                                                            class="form-control"
                                                            value="{{ old("modules.$index.end_date", $module->end_date) }}">
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                        <button type="button" class="btn btn-outline-primary btn-sm mb-3"
                                            onclick="addModuleRow()">+ Add Module</button>
                                    </div>

                                    <!-- One Time Billing -->
                                    @php
                                        $singleBilling = $project->billingModules->first();
                                    @endphp

                                    @if ($project->billing_type == 'advance' || $project->billing_type == 'postpayment')
                                        <div id="single_field_billing">
                                            <div class="row mb-3">
                                                <label class="col-sm-3 col-form-label" id="single_field_label">Billing
                                                    Detail</label>
                                                <div class="col-sm-3">
                                                    <input type="number" name="billing_note" class="form-control"
                                                        value="{{ old('billing_note', $singleBilling->amount ?? '') }}">
                                                </div>
                                                <div class="col-sm-3">
                                                    <input type="text" name="billing_description" class="form-control"
                                                        value="{{ old('billing_description', $singleBilling->description ?? '') }}">
                                                </div>
                                                <div class="col-sm-1">
                                                    <input type="date" name="billing_start_date" class="form-control"
                                                        value="{{ old('billing_start_date', $singleBilling->start_date ?? '') }}">
                                                </div>
                                                <div class="col-sm-2">
                                                    <input type="date" name="billing_end_date" class="form-control"
                                                        value="{{ old('billing_end_date', $singleBilling->end_date ?? '') }}">
                                                </div>
                                            </div>
                                        </div>
                                    @endif

                                    {{-- END DYNAMIC BILLING FIELDS --}}


                                </div>

                                {{-- Submit Button --}}
                                <div class="row justify-content-between mt-4">
                                    <div class="col-sm-6">
                                        {{-- only on second page --}}
                                        <button id="backButton" type="button" class="btn btn-secondary"
                                            style="display: none;">Back</button>
                                    </div>
                                    <div class="col-sm-6 text-end">
                                        {{-- only on first page --}}
                                        <button id="nextButton" type="button" class="btn btn-secondary">Next</button>

                                        {{-- only on second page --}}
                                        <button id="submitButton" type="submit" class="btn btn-primary"
                                            style="display: none;">Add Project</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- / Content -->
    @endsection
    @section('scripts')
        <script>
            let moduleIndex = {{ $project->billingModules->count() ?? 0 }};

            function addModuleRow() {
                const container = document.getElementById('module-wise-container');
                const row = document.createElement('div');
                row.classList.add('row', 'mb-2', 'module-row');
                row.innerHTML = `
                    <div class="col-sm-3">
                        <input type="text" name="modules[${moduleIndex}][title]" class="form-control" placeholder="Module Title">
                    </div>
                    <div class="col-sm-2">
                        <input type="number" name="modules[${moduleIndex}][amount]" class="form-control" placeholder="Amount">
                    </div>
                    <div class="col-sm-3">
                        <input type="text" name="modules[${moduleIndex}][description]" class="form-control" placeholder="Description">
                    </div>
                    <div class="col-sm-2">
                        <input type="date" name="modules[${moduleIndex}][start_date]" class="form-control">
                    </div>
                    <div class="col-sm-2">
                        <input type="date" name="modules[${moduleIndex}][end_date]" class="form-control">
                    </div>
                `;
                container.appendChild(row);
                moduleIndex++;
            }



            // CKEDITOR.replace('description');
            $(document).ready(function() {
                $('#technology').select2({
                    placeholder: "Select Technology",
                    allowClear: true,
                    width: '100%'
                });
                $('#assigned_employee').select2({
                    placeholder: "Select Employee",
                    allowClear: true,
                    width: '100%'
                });

                $('#nextButton').on('click', function(e) {
                    e.preventDefault();
                    $('.firstPage').hide();
                    $('.secondPage').show();
                    $('#nextButton').hide();
                    $('#submitButton').show();
                    $('#backButton').show();
                });
                $('#backButton').on('click', function(e) {
                    e.preventDefault();
                    $('.firstPage').show();
                    $('.secondPage').hide();
                    $('#nextButton').show();
                    $('#submitButton').hide();
                    $('#backButton').hide();
                });

                $('#assigned_employee').on('change', updateSelectedResources);


                function updateSelectedResources() {
                    const selectedOptions = $('#assigned_employee').find('option:selected');
                    const selectedIds = selectedOptions.map(function() {
                        return String($(this).val());
                    }).get();

                    const $container = $('#selected-resources');

                    const toNum = v => {
                        const n = parseFloat(v);
                        return Number.isFinite(n) ? n : null;
                    };

                    // 1) Snapshot existing values
                    const snapshot = {};
                    $container.find('tr').each(function() {
                        const id = String($(this).data('id'));
                        snapshot[id] = {
                            rate: $(this).find('.rate').val(),
                            duration: $(this).find('.duration').val(),
                            total: $(this).find('.total-cost').val()
                        };
                    });

                    // 2) Remove rows no longer selected
                    $container.find('tr').each(function() {
                        const id = String($(this).data('id'));
                        if (!selectedIds.includes(id)) {
                            $(this).remove();
                        }
                    });

                    // 3) Add rows for newly selected resources
                    selectedOptions.each(function() {
                        const id = String($(this).val());
                        const name = $(this).data('name');
                        const defaultRate = $(this).data(
                            'rate');
                        const defaultDuration = $(this).data(
                            'duration');
                        // leave as string; we’ll parse later if needed

                        if ($container.find(`tr[data-id="${id}"]`).length) return; // already exists

                        const rate = snapshot[id]?.rate ?? (defaultRate !== undefined ? defaultRate : '');
                        const duration = snapshot[id]?.duration ?? (defaultDuration !== undefined ?
                            defaultDuration : '');
                        const r = toNum(rate);
                        const d = toNum(duration);
                        const total = (r !== null && d !== null) ? (r * d).toFixed(2) : '';

                        const row = `
                                <tr data-id="${id}">
                                    <td>
                                        <input type="hidden" name="resources[${id}][user_id]" value="${id}">
                                        <input type="hidden" name="resources[${id}][name]" value="${name}">
                                        <input type="text" class="form-control" value="${name}" readonly>
                                    </td>
                                    <td><input type="decimal" step="0.01" class="form-control rate" name="resources[${id}][rate]" value="${rate ?? ''}"></td>
                                    <td><input type="decimal" step="0.01" class="form-control duration" name="resources[${id}][duration]" value="${duration ?? ''}"></td>
                                    <td><input type="decimal" step="0.01" class="form-control total-cost" name="resources[${id}][total]" value="${total}" readonly></td>
                                </tr>
                            `;
                        $container.append(row);
                    });

                    // 4) Recalculate totals
                    calculateTotalResourceCost();
                    calculateTotalProjectCost();
                }



                updateSelectedResources();

                $('input[name="infra_cost"], input[name="pm_cost"], input[name="travel_cost"], input[name="comission"], input[name="accomodation_cost"], input[name="profit_margin"], input[name="marketing_cost"], input[name="sales_cost"], #total_resource_cost')
                    .on('input', calculateTotalProjectCost);

                const costInputs =
                    'input[name="infra_cost"], input[name="pm_cost"], input[name="travel_cost"], input[name="comission"], input[name="accomodation_cost"], input[name="profit_margin"], input[name="marketing_cost"], input[name="sales_cost"]';

                $(document).on('input change keyup', costInputs, calculateTotalProjectCost);

                // when resource rows change
                $(document).on('input change keyup', '#selected-resources .rate, #selected-resources .duration',
                    function() {
                        calculateTotalResourceCost(); // recompute resources
                        calculateTotalProjectCost(); // then recompute project total
                    });
                calculateTotalProjectCost();

                function calculateTotalProjectCost() {
                    const toNumber = val => parseFloat(val) || 0;

                    const totalResourceCost = toNumber($('#total_resource_cost').val());
                    const infraCost = toNumber($('input[name="infra_cost"]').val());
                    const pmCost = toNumber($('input[name="pm_cost"]').val());
                    const travelCost = toNumber($('input[name="travel_cost"]').val());
                    const comission = toNumber($('input[name="comission"]').val());
                    const accomodation = toNumber($('input[name="accomodation_cost"]').val());
                    const margin = toNumber($('input[name="profit_margin"]').val());
                    const marketing = toNumber($('input[name="marketing_cost"]').val());
                    const sales = toNumber($('input[name="sales_cost"]').val());

                    const total = totalResourceCost + infraCost + pmCost + travelCost +
                        comission + accomodation + margin + marketing + sales;

                    $('#total_project_cost').val(total.toFixed(2));
                }








            });


            $('#add-other-cost').on('click', function() {
                addOtherCostRow();
            });
            const $otherContainer = $('#other-costs-container');

            function addOtherCostRow() {
                const index = $otherContainer.children('.row').length;
                const row = `
                        <div class="row mb-2">
                            <div class="col-sm-5">
                                <input type="text" name="other_costs[custom][${index}][title]" class="form-control" placeholder="Other Cost Title">
                            </div>
                            <div class="col-sm-5">
                                <input type="decimal" name="other_costs[custom][${index}][amount]" class="form-control" placeholder="Amount">
                            </div>
                            <div class="col-sm-2 text-end">
                                <button type="button" class="btn btn-sm btn-danger remove-cost">×</button>
                            </div>
                        </div>
                    `;
                $otherContainer.append(row);
            }

            $(document).on('click', '.remove-cost', function() {
                const $row = $(this).closest('.row');
                const type = $row.data('type');

                if (type) {
                    $(`#${type}`).prop('checked', false); // Uncheck the checkbox
                }

                $row.remove();
            });

            function toNum(v) {
                const n = parseFloat(v);
                return Number.isFinite(n) ? n : 0;
            }

            function calculateRowTotal($row) {
                const rate = toNum($row.find('.rate').val());
                const duration = toNum($row.find('.duration').val());
                const total = rate * duration;
                $row.find('.total-cost').val(total ? total.toFixed(2) : '');
                return total;
            }

            function calculateTotalResourceCost() {
                let sum = 0;
                $('#selected-resources tr').each(function() {
                    sum += calculateRowTotal($(this));
                });
                $('#total_resource_cost').val(sum.toFixed(2));
            }


            $(document).on('input', '#selected-resources .rate, #selected-resources .duration', function() {
                const $row = $(this).closest('tr');
                calculateRowTotal($row);
                calculateTotalResourceCost();
                calculateTotalProjectCost();
            });
        </script>
    @endsection
