<?php

use App\Http\Controllers\Auth\EmployeeController;
use App\Http\Controllers\Auth\ProjectController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::middleware('auth')->group(function () {
    Route::get('/employee', [EmployeeController::class, 'addView'])->name('employee.add.view');
    Route::post('/employee/submit', [EmployeeController::class, 'addEmployee'])->name('employee.add.submit');
    Route::get('/manage-employees', [EmployeeController::class, 'manageView'])->name('employee.manage.view');
    Route::get('/manage-employees/data', [EmployeeController::class, 'getEmployees'])->name('employees.data');
    Route::get('/employees/{employee}/edit', [EmployeeController::class, 'edit'])->name('employees.edit');
    Route::post('/employees/{employee}/edit/submit', [EmployeeController::class, 'editSubmit'])->name('employees.edit.submit');
    Route::delete('/employees/{employee}', [EmployeeController::class, 'destroy'])->name('employees.destroy');

    Route::controller(ProjectController::class)->group(function () {
        Route::get('/project', 'index')->name('project.index');
        Route::any('/project/submit', 'submit')->name('project.submit');
        Route::get('/manage/project', 'manageView')->name('project.manage.view');
        Route::get('/manage/project/data', 'getProjectData')->name('project.data');

        Route::get('/project/{project}/edit', 'edit')->name('project.edit');
        Route::post('/project/{project}/edit/submit', 'editSubmit')->name('project.edit.submit');
        Route::delete('/project/{project}', 'destroy')->name('project.destroy');

        Route::get('/project/{project}/details', 'detailsView')->name('project.details');
        Route::get('/project/{project}/details/download', 'downloadDetails')->name('project.details.download');

        Route::get('/project/billing', 'billingView')->name('billing.view');
        Route::get('/project/{id}/billing-modules', 'loadBillingModules')->name('billing.modules');

        Route::post('/statuschange/{projectid}/{moduleid}', 'changeStatus')->name('statuschange');
    });
});


require __DIR__ . '/auth.php';
