<?php

namespace App\Http\Controllers;

use App\Models\AccountingYear;
use App\Models\Income;
use App\Models\IncomeHead;
use App\Models\IncomeHeadGroup;
use App\Models\Menu;
use App\Models\Organisation;
use App\Services\PermissionService;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class LedgerIncomeController extends Controller
{

    protected $permissionService;
    protected $menuId;
    protected $currentYear;
    protected $currentOrgId;

    public function __construct(PermissionService $permissionService)
    {
        $this->permissionService = $permissionService;
        $this->menuId = Menu::where('route', 'ledger.income.index')->value('id');
        $this->currentYear = AccountingYear::current();
        $this->currentOrgId = Organisation::current();
    }

    public function index()
    {
        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Income Records.');
        }
        $ledgerIncomeHeads = DB::table('incomes')
            ->where('financial_year_id', $this->currentYear->accounting_year_id)
            ->where('organisation_id', $this->currentOrgId->organisation_id)
            // ->whereNull('deleted_at')
            ->select('income_head', DB::raw('SUM(transaction_amount) as total_amount'))
            ->groupBy('income_head')
            ->get()
            ->keyBy('income_head');

        $ledgerIncomeHeadIds = $ledgerIncomeHeads->keys()->toArray();

        $incomeHeads = IncomeHead::with('incomeHeadGroup')
            ->where('status', 'active')
            ->whereIn('income_head_id', $ledgerIncomeHeadIds)
            ->get();

        $incomeHeadsByGroup = $incomeHeads->filter(fn($h) => $h->incomeHeadGroup)
            ->groupBy(fn($h) => $h->incomeHeadGroup->income_head_group_ID);

        $incomeHeadsWithoutGroup = $incomeHeads->filter(fn($h) => !$h->incomeHeadGroup);

        $incomeHeadGroups = IncomeHeadGroup::where('status', 'active')->get();


        /* New CODE */







        return view('auth.ledgers.income.index', compact(
            'ledgerIncomeHeads',
            'incomeHeadsByGroup',
            'incomeHeadsWithoutGroup',
            'incomeHeadGroups'
        ));
    }


    public function getIncomeHeadDetails($id)
    {
        if (!$this->permissionService->hasPermission($this->menuId, 'r')) {
            abort(403, 'You do not have read access to Ledger Income Records.');
        }
        $incomes = Income::with('incomeHead.incomeHeadGroup', 'purpose')
            ->where('income_head', $id)
            ->where('financial_year_id', $this->currentYear->accounting_year_id)
            ->where('organisation_id', $this->currentOrgId->organisation_id)
            ->orderBy('transaction_date', 'desc')
            ->get();
        $incomeHeadName = $incomes->first()?->incomeHead?->income_head_name ?? 'N/A';
        $incomeHeadGroupName = $incomes->first()?->incomeHead?->incomeHeadGroup?->income_head_group_Name ?? 'Ungrouped';

        return view('auth.ledgers.income.detail', compact('incomes', 'incomeHeadName', 'incomeHeadGroupName'));
    }
}
