<?php

namespace App\Http\Controllers;

use App\Models\Purpose;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PurposeController extends Controller
{
   
    public function index()
    {
        //
    }

    
    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'purpose' => 'required|string|max:255',
            'purpose_for' => 'required|in:income,expense',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first(),
            ], 422);
        }

        $exists = Purpose::where('name', $request->purpose)
            ->where('purpose_for', $request->purpose_for)
            ->exists();

        if ($exists) {
            return response()->json([
                'success' => false,
                'message' => "The purpose '{$request->purpose}' already exists for {$request->purpose_for}.",
            ], 422);
        }
        $purpose = Purpose::create([
            'name' => $request->purpose,
            'purpose_for' => $request->purpose_for,
        ]);

        return response()->json([
            'success' => true,
            'purpose' => [
                'id' => $purpose->id,
                'name' => $purpose->name,
                'purpose_for' => $purpose->purpose_for,
            ]
        ]);
    }


    public function show(string $id)
    {
        //
    }

    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
