<?php

namespace App\Http\Controllers;

use App\Models\AccountingYear;
use App\Models\AccountType;
use App\Models\Organisation;
use App\Models\Vendor;
use Illuminate\Http\Request;

class VendorController extends Controller
{

    public function index()
    {
        $financialYears = AccountingYear::where('status', 'active')->get();
        $accountTypes = AccountType::where('status', 'active')->get();
        $organisations = Organisation::where('status', 'active')->get();
        return view('auth.vendors.index', compact('organisations', 'accountTypes', 'financialYears'));
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'vendor_type' => 'required|in:internal,external',
                'vendor_name' => 'required|string|max:255',
                'vendor_contact_person' => 'nullable|string|max:255',
                'vendor_phone_number' => 'nullable|string|max:20',
                'vendor_email' => 'nullable|email|max:255',
                'vendor_address' => 'nullable|string',
                'vendor_gst_number' => 'nullable|string|max:255',
                'vendor_pan_number' => 'nullable|string|max:255',
                'vendor_payment_terms' => 'nullable|string|max:255',
                'vendor_bank_account_number' => 'nullable|string|max:255',
                'vendor_bank_ifsc' => 'nullable|string|max:255',
                'vendor_preferred_payment_mode' => 'nullable|in:neft,rtgs,cheque,cash',
            ]);

            $vendor = Vendor::create($validated);

            return response()->json([
                'success' => true,
                'message' => 'Vendor created successfully',
                'vendor' => $vendor
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to create vendor',
                'error'   => $e->getMessage(),
            ], 500);
        }
    }


    public function show(string $id)
    {
        //
    }


    public function edit(string $id)
    {
        //
    }


    public function update(Request $request, string $id)
    {
        //
    }


    public function destroy(string $id)
    {
        //
    }

    public function search(Request $request)
    {
        try {
            $search = $request->input('search', '');
            $type = $request->input('type', 'all'); // 'vendor', 'staff', or 'all'

            $query = Vendor::where('vendor_status', 'active');

            // Filter by type if specified
            if ($type === 'vendor') {
                $query->where('vendor_type', 'external');
            } elseif ($type === 'staff') {
                $query->where('vendor_type', 'internal');
            }

            // Search by name
            if (!empty($search)) {
                $query->where('vendor_name', 'like', "%{$search}%");
            }

            $vendors = $query->select('vendor_id', 'vendor_name', 'vendor_type')
                ->orderBy('vendor_name', 'asc')
                ->limit(50)
                ->get();

            return response()->json([
                'success' => true,
                'data' => $vendors
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to search vendors',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
