<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AccountBroughtForward extends Model
{
    use HasFactory;

    protected $table = 'account_brought_forwards';

    protected $fillable = [
        'financial_year_id',
        'cash_in_hand',
        'cash_at_bank',
        'user_id',
        'dated_as_on',
        'organisation_id',
        'account_type_id'
    ];

    public function financialYear()
    {
        return $this->belongsTo(AccountingYear::class, 'financial_year_id');
    }

    
}
