<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Donor extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'donors';
    protected $primaryKey = 'donor_id';


    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'donor_name',
        'donor_contact_person',
        'donor_phone_number',
        'donor_email',
        'donor_address',
        'donor_pan_number',
        'donor_aadhar_number',
        'donor_type',
        'donor_status',
        'donor_opening_balance',
        'donor_current_balance',
        'donor_folio_no'
    ];

    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id');
    }
    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id');
    }
}
