<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\CommonTrait;

class DonorRecord extends Model
{
    use HasFactory, CommonTrait;

    protected $table;
    protected $casts = [
        'flag' => 'array',
    ];

    protected $fillable = [
        'asset_id',
        'liability_id',
        'donor_id',
        'journal_id',
        'paid_amount',
        'income_expense',
        'dr_cr',
        'flag'
    ];
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->table = $this->getYearPrefixedTables()['donor_transaction_record'];
    }
    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function liability()
    {
        return $this->belongsTo(Liability::class);
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function income()
    {
        return $this->belongsTo(Income::class, 'journal_id', 'income_id');
    }
}
