<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Expense extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'expenses';
    protected $primaryKey = 'expense_id';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'payment_type_id',
        'purpose_id',
        'financial_year_id',
        'expense_head',
        'user_id',
        'transaction_reference',
        'transaction_amount',
        'transaction_date',
        'transaction_narration',
        'expense_type',
        'asset_id',
        'liability_id',
        'pay_to',
        'staff_id',
        'vendor_id',
        'receipt_no',
        'file_path'
    ];

    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id', 'organisation_id');
    }

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id', 'account_type_id');
    }

    public function expenseHead()
    {
        return $this->belongsTo(ExpenseHead::class, 'expense_head', 'expense_head_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
    public function paymentType()
    {
        return $this->belongsTo(PaymentType::class, 'payment_type_id', 'id');
    }
    public function purpose()
    {
        return $this->belongsTo(Purpose::class, 'purpose_id', 'id');
    }
    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id', 'vendor_id');
    }

    public function staffVendor()
    {
        return $this->belongsTo(Vendor::class, 'staff_id', 'vendor_id');
    }
}
