<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExpenseHeadGroup extends Model
{
    use HasFactory;

    protected $table = 'expense_head_groups';
    protected $primaryKey = 'expense_head_group_ID';

    protected $fillable = [
        'expense_head_group_Name',
        'status',
    ];
    public function heads()
    {
        return $this->hasMany(ExpenseHead::class, 'expense_head_group_id', 'expense_head_group_ID');
    }
}
