<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Organisation extends Model
{
    use HasFactory;

    protected $table = 'organisations';
    protected $primaryKey = 'organisation_id';

    protected $fillable = [
        'accounting_year_id',
        'organisation_name',
        'organisation_address',
        'organisation_contact_number',
        'organisation_email',
        'organisation_gstin',
        'organisation_pan',
        'organisation_reg_no',
        'status',
        'is_current',
    ];

    public static function current()
    {
        return static::where('is_current', 1)->first();
    }
    public function incomes()
    {
        return $this->hasMany(Income::class, 'organisation_id', 'organisation_id');
    }
    public function accountTypes()
    {
        return $this->hasMany(AccountType::class, 'organisation_id', 'organisation_id');
    }
}
