<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentType extends Model
{
    use HasFactory;

    protected $fillable = [
        'parent_id',
        'name',
        'status',
    ];

    public function parent()
    {
        return $this->belongsTo(PaymentType::class, 'parent_id');
    }

    public function children()
    {
        return $this->hasMany(PaymentType::class, 'parent_id');
    }
 
}
