<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'transactions';
    protected $primaryKey = 'transaction_id';

    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'user_id',
        'transaction_reference',
        'transaction_type',
        'transaction_amount',
        'transaction_date',
        'dr_cr',
        'transaction_narration',
    ];

    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id', 'organisation_ID');
    }

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id', 'account_type_ID');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
