<?php

namespace App\Services;

use App\Models\UserMenuPermission;
use Illuminate\Support\Facades\Auth;

class PermissionService
{
    public function hasPermission(int $menuId, string $code): bool
    {
        $user = Auth::user();

        if (!$user) return false;

        // Superadmin bypass
        if ($user->role_id == 1) {
            return true;
        }

        // Fetch stored permission level (1,2,3)
        $permission = UserMenuPermission::where('user_id', $user->id)
            ->where('menu_id', $menuId)
            ->value('permissions');

        if (!$permission) return false;

        switch ($permission) {
            case 1:
                return $code === 'r';

            case 2:
                return in_array($code, ['r', 'w']);

            case 3:
                return in_array($code, ['r', 'w', 'x']);

            default:
                return false;
        }
    }
}
