<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('organisations', function (Blueprint $table) {
            $table->id('organisation_ID');
            $table->unsignedBigInteger('accounting_year_ID')->nullable();

            $table->string('organisation_Name');
            $table->text('organisation_Address')->nullable();
            $table->string('organisation_ContactNumber', 255)->nullable();
            $table->string('organisation_Email')->nullable();
            $table->string('organisation_GSTIN', 50)->nullable();
            $table->string('organisation_PAN', 20)->nullable();
            $table->string('organisation_reg_no', 50)->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');

            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('organisations');
    }
};
