<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_income_heads', function (Blueprint $table) {
            $table->id('income_head_ID');
            $table->unsignedBigInteger('account_type_ID');
            $table->unsignedBigInteger('income_head_group_ID');
            $table->string('income_head_Name');
            $table->decimal('income_head_group_Opening_Balance', 15, 2)->default(0);
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('income_heads');
    }
};
