php artisan make:model Vendor
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vendors', function (Blueprint $table) {
            $table->bigIncrements('vendor_id');
            $table->string('vendor_name');
            $table->string('vendor_contact_person')->nullable();
            $table->string('vendor_phone_number', 20)->nullable();
            $table->string('vendor_email')->nullable();
            $table->text('vendor_address')->nullable();
            $table->string('vendor_gst_number')->nullable();
            $table->string('vendor_pan_number')->nullable();
            $table->string('vendor_payment_terms')->nullable();
            $table->string('vendor_bank_account_number')->nullable();
            $table->string('vendor_bank_ifsc')->nullable();
            $table->enum('vendor_preferred_payment_mode', ['neft', 'rtgs', 'cheque', 'cash'])->nullable();
            $table->decimal('vendor_opening_balance', 15, 2)->default(0.00);
            $table->decimal('vendor_current_balance', 15, 2)->default(0.00);
            $table->enum('vendor_status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendors');
    }
};
