<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::rename('tbl_income_heads', 'income_heads');

        Schema::table('income_heads', function (Blueprint $table) {
            $table->integer('income_head_id', true)->change(); 
            $table->renameColumn('account_type_ID', 'account_type_id');
            $table->renameColumn('income_head_group_ID', 'income_head_group_id');
            $table->renameColumn('income_head_Name', 'income_head_name');
            $table->renameColumn('income_head_group_Opening_Balance', 'income_head_group_opening_balance');
       
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::rename('income_heads', 'tbl_income_heads');

        Schema::table('tbl_income_heads', function (Blueprint $table) {
            $table->bigIncrements('income_head_ID')->change();
            $table->renameColumn('account_type_id', 'account_type_ID');
            $table->renameColumn('income_head_group_id', 'income_head_group_ID');
            $table->renameColumn('income_head_name', 'income_head_Name');
            $table->renameColumn('income_head_group_opening_balance', 'income_head_group_Opening_Balance');
          
        });
    }
};
