<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            if (!Schema::hasColumn('accounting_years', 'is_current')) {
                $table->boolean('is_current')->default(0)->after('accounting_year_financial');
            }
        });
    }

    public function down(): void
    {
        Schema::table('accounting_years', function (Blueprint $table) {
            if (Schema::hasColumn('accounting_years', 'is_current')) {
                $table->dropColumn('is_current');
            }
        });
    }
};
