<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expense_heads', function (Blueprint $table) {
            
            $table->renameColumn('expense_head_ID', 'expense_head_id');
            $table->integer('expense_head_id', true)->change();
            $table->renameColumn('account_type_ID', 'account_type_id');
            $table->renameColumn('expense_head_group_ID', 'expense_head_group_id');
            $table->renameColumn('expense_head_Name', 'expense_head_name');
            $table->renameColumn('expense_head_group_Opening_Balance', 'expense_head_group_opening_balance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expense_heads', function (Blueprint $table) {
            $table->renameColumn('expense_head_id', 'expense_head_ID');
            $table->integer('expense_head_ID', false)->change();
            $table->renameColumn('account_type_id', 'account_type_ID');
            $table->renameColumn('expense_head_group_id', 'expense_head_group_ID');
            $table->renameColumn('expense_head_name', 'expense_head_Name');
            $table->renameColumn('expense_head_group_opening_balance', 'expense_head_group_Opening_Balance');
        });
    }
};
