<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('account_brought_forwards', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('financial_year_id');
            $table->decimal('cash_in_hand', 15, 2)->default(0);
            $table->decimal('cash_at_bank', 15, 2)->default(0);
            $table->decimal('total_capital', 15, 2)->default(0);
            $table->integer('user_id');
            $table->date('dated_as_on');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('account_brought_forwards');
    }
};
