<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->string('asset_type')->nullable()->after('asset_name');
            $table->float('depreciation')->default(0)->after('asset_type');
        });
    }


    public function down(): void
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->dropColumn(['asset_type', 'depreciation']);
        });
    }
};
