<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('liabilities', function (Blueprint $table) {
            $table->increments('liability_id');

            $table->integer('organisation_id');
            $table->integer('account_type_id')->nullable();
            $table->integer('financial_year_id')->nullable();

            $table->string('liability_name');
            $table->string('liability_type')->nullable();
            $table->date('liability_date')->nullable();

            $table->decimal('liability_opening_balance', 15, 2)->default(0.00);
            $table->decimal('liability_amount', 15, 2)->default(0.00);

            $table->date('liability_due_date')->nullable();

            $table->enum('liability_status', ['active', 'closed', 'inactive'])->default('active');

            $table->timestamps();
            $table->softDeletes();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('liabilities');
    }
};
