<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->enum('expense_type', ['asset', 'liability', 'expense'])->nullable()->after('expense_id');
            $table->integer('asset_id')->nullable()->after('expense_type');
            $table->integer('liability_id')->nullable()->after('asset_id');
            $table->enum('pay_to', ['internal', 'external'])->nullable()->after('liability_id');
            $table->integer('staff_id')->nullable()->after('pay_to');
            $table->integer('vendor_id')->nullable()->after('staff_id');
        });
    }

    public function down(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->dropColumn(['expense_type', 'asset_id', 'liability_id', 'pay_to', 'staff_id', 'vendor_id']);
        });
    }
};
