<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('donor_records', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('asset_id')->nullable();
            $table->integer('liability_id')->nullable();
            $table->integer('donor_id')->nullable();
            $table->integer('journal_id')->nullable();

            $table->decimal('paid_amount', 15, 2)->default(0);

            $table->enum('income_expense', ['income', 'expense']);
            $table->enum('dr_cr', ['dr', 'cr']);

            $table->timestamps(); 
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('donor_records');
    }
};
