<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('incomes', function (Blueprint $table) {
            $table->string('money_receipt_no')->nullable()->after('income_id');
            $table->enum('income_type', ['asset', 'liability', 'income','member_subscription'])->nullable()->after('money_receipt_no');
            $table->integer('asset_id')->nullable()->after('income_type');
            $table->integer('liability_id')->nullable()->after('asset_id');
            $table->enum('pay_to', ['donor', ''])->nullable()->after('liability_id');
            $table->integer('donor_id')->nullable()->after('pay_to');
            $table->string('file_path')->nullable()->after('donor_id');
        });
    }


    public function down(): void
    {
        Schema::table('incomes', function (Blueprint $table) {
            $table->dropColumn(['money_receipt_no', 'income_type', 'asset_id', 'liability_id', 'pay_to', 'donor_id', 'file_path']);
        });
    }
};
