<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            $table->integer('account_type_id')->nullable()->change();

            $table->integer('income_head_group_id')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            $table->bigInteger('account_type_id')->unsigned()->nullable(false)->change();
            $table->bigInteger('income_head_group_id')->unsigned()->nullable(false)->change();
        });
    }
};
