<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('organisations', function (Blueprint $table) {
            if (!Schema::hasColumn('organisations', 'is_current')) {
                $table->boolean('is_current')->default(0)->after('organisation_reg_no');
            }
        });
    }


    public function down(): void
    {
        Schema::table('organisations', function (Blueprint $table) {
            if (Schema::hasColumn('organisations', 'is_current')) {
                $table->dropColumn('is_current');
            }
        });
    }
};
