<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            if (!Schema::hasColumn('income_heads', 'organisation_id')) {
                $table->integer('organisation_id')->after('income_head_id');
            }
        });
    }


    public function down(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            $table->dropColumn('organisation_id');
        });
    }
};
