<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expense_heads', function (Blueprint $table) {
            $table->string('asset_type')->nullable()->after('expense_head_name');
            $table->string('depriciation_rate')->nullable()->after('asset_type');
            $table->string('depriciation_tenure')->nullable()->after('depriciation_rate');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expense_heads', function (Blueprint $table) {
             $table->dropColumn(['asset_type', 'depriciation_rate','depriciation_tenure']);
        });
    }
};
