<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
         Schema::table('liabilities', function (Blueprint $table) {
            // Remove old column
            $table->dropColumn('income_head_id');

            // Add new columns
            $table->unsignedBigInteger('head_id')->nullable()->after('financial_year_id');
            $table->unsignedBigInteger('group_head_id')->nullable()->after('head_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('liabilities', function (Blueprint $table) {
            // Rollback: remove new columns
            $table->dropColumn(['head_id', 'group_head_id']);

            // Add the old column back
            $table->unsignedBigInteger('income_head_id')->default(0);
        });
    }
};
