<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('assets', function (Blueprint $table) {
            $table->unsignedBigInteger('head_id')->nullable()->after('account_type_id');
            $table->unsignedBigInteger('head_group_id')->nullable()->after('head_id');
        });
    }

    /**
     * Reverse the migrations.
     */
        public function down(): void
        {
            Schema::table('assets', function (Blueprint $table) {
                $table->dropColumn(['head_id', 'head_group_id']);
            });
        }
};
