<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('asset_brought_forwards', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('organisation_id');
            $table->integer('account_type_id')->nullable();
            $table->integer('financial_year_id');
            $table->decimal('total_asset_amount', 15, 2)->default(0);
            $table->integer('user_id');
            $table->date('dated_as_on');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('asset_brought_forwards');
    }
};
