<?php

namespace Database\Seeders;

use App\Models\ExpenseHeadGroup;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ExpenseHeadGroupSeeder extends Seeder
{
  
    public function run(): void
    {
        $groups = [
            'Staff Payment',
            'Staff Bonus',
            'Motorvan Charge',
            'Electric Bill',
            'Furniture',
            'Sports Spent',
        ];

        foreach ($groups as $group) {
            ExpenseHeadGroup::create([
                'expense_head_group_Name' => $group,
                'status' => 'active',
            ]);
        }
    }
}
