/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/@babel/runtime/regenerator/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@babel/runtime/regenerator/index.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(/*! regenerator-runtime */ "./node_modules/regenerator-runtime/runtime.js");


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/token/token.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor-cloud-services-core/src/token/token.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module cloud-services-core/token
 */

/* globals XMLHttpRequest, setInterval, clearInterval */





const DEFAULT_OPTIONS = { refreshInterval: 3600000, autoRefresh: true };

/**
 * Class representing the token used for communication with CKEditor Cloud Services.
 * Value of the token is retrieving from the specified URL and is refreshed every 1 hour by default.
 *
 * @mixes ObservableMixin
 */
class Token {
	/**
	 * Creates `Token` instance.
	 * Method `init` should be called after using the constructor or use `create` method instead.
	 *
	 * @param {String|Function} tokenUrlOrRefreshToken Endpoint address to download the token or a callback that provides the token. If the
	 * value is a function it has to match the {@link module:cloud-services-core/token~refreshToken} interface.
	 * @param {Object} options
	 * @param {String} [options.initValue] Initial value of the token.
	 * @param {Number} [options.refreshInterval=3600000] Delay between refreshes. Default 1 hour.
	 * @param {Boolean} [options.autoRefresh=true] Specifies whether to start the refresh automatically.
	 */
	constructor( tokenUrlOrRefreshToken, options = DEFAULT_OPTIONS ) {
		if ( !tokenUrlOrRefreshToken ) {
			/**
			 * A `tokenUrl` must be provided as the first constructor argument.
			 *
			 * @error token-missing-token-url
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'token-missing-token-url: A `tokenUrl` must be provided as the first constructor argument.',
				this
			);
		}

		/**
		 * Value of the token.
		 * The value of the token is null if `initValue` is not provided or `init` method was not called.
		 * `create` method creates token with initialized value from url.
		 *
		 * @name value
		 * @member {String} #value
		 * @observable
		 * @readonly
		 */
		this.set( 'value', options.initValue );

		/**
		 * Base refreshing function.
		 *
		 * @private
		 * @member {String|Function} #_refresh
		 */
		if ( typeof tokenUrlOrRefreshToken === 'function' ) {
			this._refresh = tokenUrlOrRefreshToken;
		} else {
			this._refresh = () => defaultRefreshToken( tokenUrlOrRefreshToken );
		}

		/**
		 * @type {Object}
		 * @private
		 */
		this._options = Object.assign( {}, DEFAULT_OPTIONS, options );
	}

	/**
	 * Initializes the token.
	 *
	 * @returns {Promise.<module:cloud-services-core/token~Token>}
	 */
	init() {
		return new Promise( ( resolve, reject ) => {
			if ( this._options.autoRefresh ) {
				this._startRefreshing();
			}

			if ( !this.value ) {
				this.refreshToken()
					.then( resolve )
					.catch( reject );

				return;
			}

			resolve( this );
		} );
	}

	/**
	 * Refresh token method. Useful in a method form as it can be override in tests.
	 * @returns {Promise.<String>}
	 */
	refreshToken() {
		return this._refresh()
			.then( value => this.set( 'value', value ) )
			.then( () => this );
	}

	/**
	 * Destroys token instance. Stops refreshing.
	 */
	destroy() {
		this._stopRefreshing();
	}

	/**
	 * Starts value refreshing every `refreshInterval` time.
	 *
	 * @protected
	 */
	_startRefreshing() {
		this._refreshInterval = setInterval( () => this.refreshToken(), this._options.refreshInterval );
	}

	/**
	 * Stops value refreshing.
	 *
	 * @protected
	 */
	_stopRefreshing() {
		clearInterval( this._refreshInterval );
	}

	/**
	 * Creates a initialized {@link module:cloud-services-core/token~Token} instance.
	 *
	 * @param {String|Function} tokenUrlOrRefreshToken Endpoint address to download the token or a callback that provides the token. If the
	 * value is a function it has to match the {@link module:cloud-services-core/token~refreshToken} interface.
	 * @param {Object} options
	 * @param {String} [options.initValue] Initial value of the token.
	 * @param {Number} [options.refreshInterval=3600000] Delay between refreshes. Default 1 hour.
	 * @param {Boolean} [options.autoRefresh=true] Specifies whether to start the refresh automatically.
	 * @returns {Promise.<module:cloud-services-core/token~Token>}
	 */
	static create( tokenUrlOrRefreshToken, options = DEFAULT_OPTIONS ) {
		const token = new Token( tokenUrlOrRefreshToken, options );

		return token.init();
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( Token, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * This function is called in a defined interval by the {@link ~Token} class. It also can be invoked manually.
 * It should return a promise, which resolves with the new token value.
 * If any error occurs it should return a rejected promise with an error message.
 *
 * @function refreshToken
 * @returns {Promise.<String>}
 */

/**
 * @private
 * @param {String} tokenUrl
 */
function defaultRefreshToken( tokenUrl ) {
	return new Promise( ( resolve, reject ) => {
		const xhr = new XMLHttpRequest();

		xhr.open( 'GET', tokenUrl );

		xhr.addEventListener( 'load', () => {
			const statusCode = xhr.status;
			const xhrResponse = xhr.response;

			if ( statusCode < 200 || statusCode > 299 ) {
				/**
				 * Cannot download new token from the provided url.
				 *
				 * @error token-cannot-download-new-token
				 */
				return reject(
					new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'token-cannot-download-new-token: Cannot download new token from the provided url.', null )
				);
			}

			return resolve( xhrResponse );
		} );

		xhr.addEventListener( 'error', () => reject( new Error( 'Network Error' ) ) );
		xhr.addEventListener( 'abort', () => reject( new Error( 'Abort' ) ) );

		xhr.send();
	} );
}

/* harmony default export */ __webpack_exports__["default"] = (Token);


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/fileuploader.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/fileuploader.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return FileUploader; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module cloud-services-core/uploadgateway/fileuploader
 */

/* globals XMLHttpRequest, FormData, Blob, atob */





const BASE64_HEADER_REG_EXP = /^data:(\S*?);base64,/;

/**
 * FileUploader class used to upload single file.
 */
class FileUploader {
	/**
	 * Creates `FileUploader` instance.
	 *
	 * @param {Blob|String} fileOrData A blob object or a data string encoded with Base64.
	 * @param {module:cloud-services-core/token~Token} token Token used for authentication.
	 * @param {String} apiAddress API address.
	 */
	constructor( fileOrData, token, apiAddress ) {
		if ( !fileOrData ) {
			/**
			 * File must be provided as the first argument.
			 *
			 * @error fileuploader-missing-file
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'fileuploader-missing-file: File must be provided as the first argument', null );
		}

		if ( !token ) {
			/**
			 * Token must be provided as the second argument.
			 *
			 * @error fileuploader-missing-token
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'fileuploader-missing-token: Token must be provided as the second argument.', null );
		}

		if ( !apiAddress ) {
			/**
			 * Api address must be provided as the third argument.
			 *
			 * @error fileuploader-missing-api-address
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'fileuploader-missing-api-address: Api address must be provided as the third argument.', null );
		}

		/**
		 * A file that is being uploaded.
		 *
		 * @type {Blob}
		 */
		this.file = _isBase64( fileOrData ) ? _base64ToBlob( fileOrData ) : fileOrData;

		/**
		 * CKEditor Cloud Services access token.
		 *
		 * @type {module:cloud-services-core/token~Token}
		 * @private
		 */
		this._token = token;

		/**
		 * CKEditor Cloud Services API address.
		 *
		 * @type {String}
		 * @private
		 */
		this._apiAddress = apiAddress;
	}

	/**
	 * Registers callback on `progress` event.
	 *
	 * @chainable
	 * @param {Function} callback
	 * @returns {module:cloud-services-core/uploadgateway/fileuploader~FileUploader}
	 */
	onProgress( callback ) {
		this.on( 'progress', ( event, data ) => callback( data ) );

		return this;
	}

	/**
	 * Registers callback on `error` event. Event is called once when error occurs.
	 *
	 * @chainable
	 * @param {Function} callback
	 * @returns {module:cloud-services-core/uploadgateway/fileuploader~FileUploader}
	 */
	onError( callback ) {
		this.once( 'error', ( event, data ) => callback( data ) );

		return this;
	}

	/**
	 * Aborts upload process.
	 */
	abort() {
		this.xhr.abort();
	}

	/**
	 * Sends XHR request to API.
	 *
	 * @chainable
	 * @returns {Promise.<Object>}
	 */
	send() {
		this._prepareRequest();
		this._attachXHRListeners();

		return this._sendRequest();
	}

	/**
	 * Prepares XHR request.
	 *
	 * @private
	 */
	_prepareRequest() {
		const xhr = new XMLHttpRequest();

		xhr.open( 'POST', this._apiAddress );
		xhr.setRequestHeader( 'Authorization', this._token.value );
		xhr.responseType = 'json';

		this.xhr = xhr;
	}

	/**
	 * Attaches listeners to the XHR.
	 *
	 * @private
	 */
	_attachXHRListeners() {
		const that = this;
		const xhr = this.xhr;

		xhr.addEventListener( 'error', onError( 'Network Error' ) );
		xhr.addEventListener( 'abort', onError( 'Abort' ) );

		/* istanbul ignore else */
		if ( xhr.upload ) {
			xhr.upload.addEventListener( 'progress', event => {
				if ( event.lengthComputable ) {
					this.fire( 'progress', {
						total: event.total,
						uploaded: event.loaded
					} );
				}
			} );
		}

		xhr.addEventListener( 'load', () => {
			const statusCode = xhr.status;
			const xhrResponse = xhr.response;

			if ( statusCode < 200 || statusCode > 299 ) {
				return this.fire( 'error', xhrResponse.message || xhrResponse.error );
			}
		} );

		function onError( message ) {
			return () => that.fire( 'error', message );
		}
	}

	/**
	 * Sends XHR request.
	 *
	 * @private
	 */
	_sendRequest() {
		const formData = new FormData();
		const xhr = this.xhr;

		formData.append( 'file', this.file );

		return new Promise( ( resolve, reject ) => {
			xhr.addEventListener( 'load', () => {
				const statusCode = xhr.status;
				const xhrResponse = xhr.response;

				if ( statusCode < 200 || statusCode > 299 ) {
					if ( xhrResponse.message ) {
						/**
						 * Uploading file failed.
						 *
						 * @error fileuploader-uploading-data-failed
						 */
						return reject( new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
							'fileuploader-uploading-data-failed: Uploading file failed.',
							this,
							{ message: xhrResponse.message }
						) );
					}

					return reject( xhrResponse.error );
				}

				return resolve( xhrResponse );
			} );

			xhr.addEventListener( 'error', () => reject( new Error( 'Network Error' ) ) );
			xhr.addEventListener( 'abort', () => reject( new Error( 'Abort' ) ) );

			xhr.send( formData );
		} );
	}

	/**
	 * Fired when error occurs.
	 *
	 * @event error
	 * @param {String} error Error message
	 */

	/**
	 * Fired on upload progress.
	 *
	 * @event progress
	 * @param {Object} status Total and uploaded status
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( FileUploader, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Transforms Base64 string data into file.
 *
 * @param {String} base64 String data.
 * @param {Number} [sliceSize=512]
 * @returns {Blob}
 * @private
 */
function _base64ToBlob( base64, sliceSize = 512 ) {
	try {
		const contentType = base64.match( BASE64_HEADER_REG_EXP )[ 1 ];
		const base64Data = atob( base64.replace( BASE64_HEADER_REG_EXP, '' ) );

		const byteArrays = [];

		for ( let offset = 0; offset < base64Data.length; offset += sliceSize ) {
			const slice = base64Data.slice( offset, offset + sliceSize );
			const byteNumbers = new Array( slice.length );

			for ( let i = 0; i < slice.length; i++ ) {
				byteNumbers[ i ] = slice.charCodeAt( i );
			}

			byteArrays.push( new Uint8Array( byteNumbers ) );
		}

		return new Blob( byteArrays, { type: contentType } );
	} catch ( error ) {
		/**
		 * Problem with decoding Base64 image data.
		 *
		 * @error fileuploader-decoding-image-data-error
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'fileuploader-decoding-image-data-error: Problem with decoding Base64 image data.', null );
	}
}

/**
 * Checks that string is Base64.
 *
 * @param {String} string
 * @returns {Boolean}
 * @private
 */
function _isBase64( string ) {
	if ( typeof string !== 'string' ) {
		return false;
	}

	const match = string.match( BASE64_HEADER_REG_EXP );
	return !!( match && match.length );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/uploadgateway.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/uploadgateway.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UploadGateway; });
/* harmony import */ var _fileuploader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./fileuploader */ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/fileuploader.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module cloud-services-core/uploadgateway/uploadgateway
 */




/**
 * UploadGateway abstracts file uploads to CKEditor Cloud Services.
 */
class UploadGateway {
	/**
	 * Creates `UploadGateway` instance.
	 *
	 * @param {module:cloud-services-core/token~Token} token Token used for authentication.
	 * @param {String} apiAddress API address.
	 */
	constructor( token, apiAddress ) {
		if ( !token ) {
			/**
			 * Token must be provided.
			 *
			 * @error uploadgateway-missing-token
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'uploadgateway-missing-token: Token must be provided.', null );
		}

		if ( !apiAddress ) {
			/**
			 * Api address must be provided.
			 *
			 * @error uploadgateway-missing-api-address
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'uploadgateway-missing-api-address: Api address must be provided.', null );
		}

		/**
		 * CKEditor Cloud Services access token.
		 *
		 * @type {module:cloud-services-core/token~Token}
		 * @private
		 */
		this._token = token;

		/**
		 * CKEditor Cloud Services API address.
		 *
		 * @type {String}
		 * @private
		 */
		this._apiAddress = apiAddress;
	}

	/**
	 * Creates a {@link module:cloud-services-core/uploadgateway/fileuploader~FileUploader} instance that wraps
	 * file upload process. The file is being sent at a time when the
	 * {@link module:cloud-services-core/uploadgateway/fileuploader~FileUploader#send} method is called.
	 *
	 *     const token = await Token.create( 'https://token-endpoint' );
	 *     new UploadGateway( token, 'https://example.org' )
	 *        .upload( 'FILE' )
	 *        .onProgress( ( data ) => console.log( data ) )
	 *        .send()
	 *        .then( ( response ) => console.log( response ) );
	 *
	 * @param {Blob|String} fileOrData A blob object or a data string encoded with Base64.
	 * @returns {module:cloud-services-core/uploadgateway/fileuploader~FileUploader} Returns `FileUploader` instance.
	 */
	upload( fileOrData ) {
		return new _fileuploader__WEBPACK_IMPORTED_MODULE_0__["default"]( fileOrData, this._token, this._apiAddress );
	}
}



/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return AttributeCommand; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_command__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/command */ "./node_modules/@ckeditor/ckeditor5-core/src/command.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/attributecommand
 */



/**
 * An extension of the base {@link module:core/command~Command} class, which provides utilities for a command
 * that toggles a single attribute on a text or an element.
 *
 * `AttributeCommand` uses {@link module:engine/model/document~Document#selection}
 * to decide which nodes (if any) should be changed, and applies or removes the attribute from them.
 *
 * The command checks the {@link module:engine/model/model~Model#schema} to decide if it can be enabled
 * for the current selection and to which nodes the attribute can be applied.
 *
 * @extends module:core/command~Command
 */
class AttributeCommand extends _ckeditor_ckeditor5_core_src_command__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @param {module:core/editor/editor~Editor} editor
	 * @param {String} attributeKey Attribute that will be set by the command.
	 */
	constructor( editor, attributeKey ) {
		super( editor );

		/**
		 * The attribute that will be set by the command.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.attributeKey = attributeKey;

		/**
		 * Flag indicating whether the command is active. The command is active when the
		 * {@link module:engine/model/selection~Selection#hasAttribute selection has the attribute} which means that:
		 *
		 * * If the selection is not empty &ndash; That the attribute is set on the first node in the selection that allows this attribute.
		 * * If the selection is empty &ndash; That the selection has the attribute itself (which means that newly typed
		 * text will have this attribute, too).
		 *
		 * @observable
		 * @readonly
		 * @member {Boolean} #value
		 */
	}

	/**
	 * Updates the command's {@link #value} and {@link #isEnabled} based on the current selection.
	 */
	refresh() {
		const model = this.editor.model;
		const doc = model.document;

		this.value = this._getValueFromFirstAllowedNode();
		this.isEnabled = model.schema.checkAttributeInSelection( doc.selection, this.attributeKey );
	}

	/**
	 * Executes the command &mdash; applies the attribute to the selection or removes it from the selection.
	 *
	 * If the command is active (`value == true`), it will remove attributes. Otherwise, it will set attributes.
	 *
	 * The execution result differs, depending on the {@link module:engine/model/document~Document#selection}:
	 *
	 * * If the selection is on a range, the command applies the attribute to all nodes in that range
	 * (if they are allowed to have this attribute by the {@link module:engine/model/schema~Schema schema}).
	 * * If the selection is collapsed in a non-empty node, the command applies the attribute to the
	 * {@link module:engine/model/document~Document#selection} itself (note that typed characters copy attributes from the selection).
	 * * If the selection is collapsed in an empty node, the command applies the attribute to the parent node of the selection (note
	 * that the selection inherits all attributes from a node if it is in an empty node).
	 *
	 * @fires execute
	 * @param {Object} [options] Command options.
	 * @param {Boolean} [options.forceValue] If set, it will force the command behavior. If `true`, the command will apply the attribute,
	 * otherwise the command will remove the attribute.
	 * If not set, the command will look for its current value to decide what it should do.
	 */
	execute( options = {} ) {
		const model = this.editor.model;
		const doc = model.document;
		const selection = doc.selection;
		const value = ( options.forceValue === undefined ) ? !this.value : options.forceValue;

		model.change( writer => {
			if ( selection.isCollapsed ) {
				if ( value ) {
					writer.setSelectionAttribute( this.attributeKey, true );
				} else {
					writer.removeSelectionAttribute( this.attributeKey );
				}
			} else {
				const ranges = model.schema.getValidRanges( selection.getRanges(), this.attributeKey );

				for ( const range of ranges ) {
					if ( value ) {
						writer.setAttribute( this.attributeKey, value, range );
					} else {
						writer.removeAttribute( this.attributeKey, range );
					}
				}
			}
		} );
	}

	/**
	 * Checks the attribute value of the first node in the selection that allows the attribute.
	 * For the collapsed selection returns the selection attribute.
	 *
	 * @private
	 * @returns {Boolean} The attribute value.
	 */
	_getValueFromFirstAllowedNode() {
		const model = this.editor.model;
		const schema = model.schema;
		const selection = model.document.selection;

		if ( selection.isCollapsed ) {
			return selection.hasAttribute( this.attributeKey );
		}

		for ( const range of selection.getRanges() ) {
			for ( const item of range.getItems() ) {
				if ( schema.checkAttribute( item, this.attributeKey ) ) {
					return item.hasAttribute( this.attributeKey );
				}
			}
		}

		return false;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Bold; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _bold_boldediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bold/boldediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldediting.js");
/* harmony import */ var _bold_boldui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./bold/boldui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/bold
 */





/**
 * The bold feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature documentation}
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/bold/boldediting~BoldEditing bold editing feature}
 * and {@link module:basic-styles/bold/boldui~BoldUI bold UI feature}.
 *
 * @extends module:core/plugin~Plugin
 */
class Bold extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _bold_boldediting__WEBPACK_IMPORTED_MODULE_1__["default"], _bold_boldui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Bold';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldediting.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldediting.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BoldEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/bold/boldediting
 */




const BOLD = 'bold';

/**
 * The bold editing feature.
 *
 * It registers the `'bold'` command and introduces the `bold` attribute in the model which renders to the view
 * as a `<strong>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class BoldEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'BoldEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		// Allow bold attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: BOLD } );
		editor.model.schema.setAttributeProperties( BOLD, {
			isFormatting: true,
			copyOnEnter: true
		} );

		// Build converter from model to view for data and editing pipelines.
		editor.conversion.attributeToElement( {
			model: BOLD,
			view: 'strong',
			upcastAlso: [
				'b',
				viewElement => {
					const fontWeight = viewElement.getStyle( 'font-weight' );

					if ( !fontWeight ) {
						return null;
					}

					// Value of the `font-weight` attribute can be defined as a string or a number.
					if ( fontWeight == 'bold' || Number( fontWeight ) >= 600 ) {
						return {
							name: true,
							styles: [ 'font-weight' ]
						};
					}
				}
			]
		} );

		// Create bold command.
		editor.commands.add( BOLD, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, BOLD ) );

		// Set the Ctrl+B keystroke.
		editor.keystrokes.set( 'CTRL+B', BOLD );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldui.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/bold/boldui.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BoldUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_bold_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/bold.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/bold.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/bold/boldui
 */






const BOLD = 'bold';

/**
 * The bold UI feature. It introduces the Bold button.
 *
 * @extends module:core/plugin~Plugin
 */
class BoldUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add bold button to feature components.
		editor.ui.componentFactory.add( BOLD, locale => {
			const command = editor.commands.get( BOLD );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Bold' ),
				icon: _theme_icons_bold_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				keystroke: 'CTRL+B',
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( BOLD );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/code.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/code.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Code; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _code_codeediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./code/codeediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeediting.js");
/* harmony import */ var _code_codeui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./code/codeui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeui.js");
/* harmony import */ var _theme_code_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../theme/code.css */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/code.css");
/* harmony import */ var _theme_code_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_theme_code_css__WEBPACK_IMPORTED_MODULE_3__);
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/code
 */







/**
 * The code feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature documentation}
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/code/codeediting~CodeEditing code editing feature}
 * and {@link module:basic-styles/code/codeui~CodeUI code UI feature}.
 *
 * @extends module:core/plugin~Plugin
 */
class Code extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _code_codeediting__WEBPACK_IMPORTED_MODULE_1__["default"], _code_codeui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Code';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeediting.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeediting.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CodeEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/* harmony import */ var _ckeditor_ckeditor5_typing_src_twostepcaretmovement__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-typing/src/twostepcaretmovement */ "./node_modules/@ckeditor/ckeditor5-typing/src/twostepcaretmovement.js");
/* harmony import */ var _ckeditor_ckeditor5_typing_src_utils_inlinehighlight__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-typing/src/utils/inlinehighlight */ "./node_modules/@ckeditor/ckeditor5-typing/src/utils/inlinehighlight.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/code/codeediting
 */






const CODE = 'code';
const HIGHLIGHT_CLASS = 'ck-code_selected';

/**
 * The code editing feature.
 *
 * It registers the `'code'` command and introduces the `code` attribute in the model which renders to the view
 * as a `<code>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class CodeEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'CodeEditing';
	}

	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _ckeditor_ckeditor5_typing_src_twostepcaretmovement__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;

		// Allow code attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: CODE } );
		editor.model.schema.setAttributeProperties( CODE, {
			isFormatting: true,
			copyOnEnter: true
		} );

		editor.conversion.attributeToElement( {
			model: CODE,
			view: 'code',
			upcastAlso: {
				styles: {
					'word-wrap': 'break-word'
				}
			}
		} );

		// Create code command.
		editor.commands.add( CODE, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, CODE ) );

		// Enable two-step caret movement for `code` attribute.
		editor.plugins.get( _ckeditor_ckeditor5_typing_src_twostepcaretmovement__WEBPACK_IMPORTED_MODULE_2__["default"] ).registerAttribute( CODE );

		// Setup highlight over selected element.
		Object(_ckeditor_ckeditor5_typing_src_utils_inlinehighlight__WEBPACK_IMPORTED_MODULE_3__["default"])( editor, CODE, 'code', HIGHLIGHT_CLASS );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeui.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/code/codeui.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CodeUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_code_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/code.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/code.svg");
/* harmony import */ var _theme_code_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../theme/code.css */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/code.css");
/* harmony import */ var _theme_code_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_theme_code_css__WEBPACK_IMPORTED_MODULE_3__);
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/code/codeui
 */








const CODE = 'code';

/**
 * The code UI feature. It introduces the Code button.
 *
 * @extends module:core/plugin~Plugin
 */
class CodeUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add code button to feature components.
		editor.ui.componentFactory.add( CODE, locale => {
			const command = editor.commands.get( CODE );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Code' ),
				icon: _theme_icons_code_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( CODE );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Italic; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _italic_italicediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./italic/italicediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicediting.js");
/* harmony import */ var _italic_italicui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./italic/italicui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/italic
 */





/**
 * The italic feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature documentation}
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/italic/italicediting~ItalicEditing} and
 * {@link module:basic-styles/italic/italicui~ItalicUI} plugins.
 *
 * @extends module:core/plugin~Plugin
 */
class Italic extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _italic_italicediting__WEBPACK_IMPORTED_MODULE_1__["default"], _italic_italicui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Italic';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicediting.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicediting.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ItalicEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/italic/italicediting
 */




const ITALIC = 'italic';

/**
 * The italic editing feature.
 *
 * It registers the `'italic'` command, the <kbd>Ctrl+I</kbd> keystroke and introduces the `italic` attribute in the model
 * which renders to the view as an `<i>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class ItalicEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'ItalicEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;

		// Allow italic attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: ITALIC } );
		editor.model.schema.setAttributeProperties( ITALIC, {
			isFormatting: true,
			copyOnEnter: true
		} );

		editor.conversion.attributeToElement( {
			model: ITALIC,
			view: 'i',
			upcastAlso: [
				'em',
				{
					styles: {
						'font-style': 'italic'
					}
				}
			]
		} );

		// Create italic command.
		editor.commands.add( ITALIC, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, ITALIC ) );

		// Set the Ctrl+I keystroke.
		editor.keystrokes.set( 'CTRL+I', ITALIC );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicui.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/italic/italicui.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ItalicUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_italic_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/italic.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/italic.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/italic/italicui
 */






const ITALIC = 'italic';

/**
 * The italic UI feature. It introduces the Italic button.
 *
 * @extends module:core/plugin~Plugin
 */
class ItalicUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add bold button to feature components.
		editor.ui.componentFactory.add( ITALIC, locale => {
			const command = editor.commands.get( ITALIC );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Italic' ),
				icon: _theme_icons_italic_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				keystroke: 'CTRL+I',
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( ITALIC );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Strikethrough; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _strikethrough_strikethroughediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./strikethrough/strikethroughediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughediting.js");
/* harmony import */ var _strikethrough_strikethroughui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./strikethrough/strikethroughui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/strikethrough
 */





/**
 * The strikethrough feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature documentation}
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/strikethrough/strikethroughediting~StrikethroughEditing} and
 * {@link module:basic-styles/strikethrough/strikethroughui~StrikethroughUI} plugins.
 *
 * @extends module:core/plugin~Plugin
 */
class Strikethrough extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _strikethrough_strikethroughediting__WEBPACK_IMPORTED_MODULE_1__["default"], _strikethrough_strikethroughui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Strikethrough';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughediting.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughediting.js ***!
  \*************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return StrikethroughEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/strikethrough/strikethroughediting
 */




const STRIKETHROUGH = 'strikethrough';

/**
 * The strikethrough editing feature.
 *
 * It registers the `'strikethrough'` command, the <kbd>Ctrl+Shift+X</kbd> keystroke and introduces the
 * `strikethroughsthrough` attribute in the model which renders to the view
 * as a `<s>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class StrikethroughEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'StrikethroughEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;

		// Allow strikethrough attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: STRIKETHROUGH } );
		editor.model.schema.setAttributeProperties( STRIKETHROUGH, {
			isFormatting: true,
			copyOnEnter: true
		} );

		editor.conversion.attributeToElement( {
			model: STRIKETHROUGH,
			view: 's',
			upcastAlso: [
				'del',
				'strike',
				{
					styles: {
						'text-decoration': 'line-through'
					}
				}
			]
		} );

		// Create strikethrough command.
		editor.commands.add( STRIKETHROUGH, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, STRIKETHROUGH ) );

		// Set the Ctrl+Shift+X keystroke.
		editor.keystrokes.set( 'CTRL+SHIFT+X', 'strikethrough' );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughui.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/strikethrough/strikethroughui.js ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return StrikethroughUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/strikethrough.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/strikethrough.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/strikethrough/strikethroughui
 */






const STRIKETHROUGH = 'strikethrough';

/**
 * The strikethrough UI feature. It introduces the Strikethrough button.
 *
 * @extends module:core/plugin~Plugin
 */
class StrikethroughUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add strikethrough button to feature components.
		editor.ui.componentFactory.add( STRIKETHROUGH, locale => {
			const command = editor.commands.get( STRIKETHROUGH );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Strikethrough' ),
				icon: _theme_icons_strikethrough_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				keystroke: 'CTRL+SHIFT+X',
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( STRIKETHROUGH );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Subscript; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _subscript_subscriptediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./subscript/subscriptediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptediting.js");
/* harmony import */ var _subscript_subscriptui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./subscript/subscriptui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/subscript
 */





/**
 * The subscript feature.
 *
 * It loads the {@link module:basic-styles/subscript/subscriptediting~SubscriptEditing} and
 * {@link module:basic-styles/subscript/subscriptui~SubscriptUI} plugins.
 *
 * @extends module:core/plugin~Plugin
 */
class Subscript extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _subscript_subscriptediting__WEBPACK_IMPORTED_MODULE_1__["default"], _subscript_subscriptui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Subscript';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptediting.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptediting.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SubscriptEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/subscript/subscriptediting
 */




const SUBSCRIPT = 'subscript';

/**
 * The subscript editing feature.
 *
 * It registers the `sub` command and introduces the `sub` attribute in the model which renders to the view
 * as a `<sub>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class SubscriptEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'SubscriptEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		// Allow sub attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: SUBSCRIPT } );
		editor.model.schema.setAttributeProperties( SUBSCRIPT, {
			isFormatting: true,
			copyOnEnter: true
		} );

		// Build converter from model to view for data and editing pipelines.

		editor.conversion.attributeToElement( {
			model: SUBSCRIPT,
			view: 'sub',
			upcastAlso: [
				{
					styles: {
						'vertical-align': 'sub'
					}
				}
			]
		} );

		// Create sub command.
		editor.commands.add( SUBSCRIPT, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, SUBSCRIPT ) );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptui.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/subscript/subscriptui.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SubscriptUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_subscript_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/subscript.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/subscript.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/subscript/subscriptui
 */






const SUBSCRIPT = 'subscript';

/**
 * The subscript UI feature. It introduces the Subscript button.
 *
 * @extends module:core/plugin~Plugin
 */
class SubscriptUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add subscript button to feature components.
		editor.ui.componentFactory.add( SUBSCRIPT, locale => {
			const command = editor.commands.get( SUBSCRIPT );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Subscript' ),
				icon: _theme_icons_subscript_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( SUBSCRIPT );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Superscript; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _superscript_superscriptediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./superscript/superscriptediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptediting.js");
/* harmony import */ var _superscript_superscriptui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./superscript/superscriptui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/superscript
 */





/**
 * The superscript feature.
 *
 * It loads the {@link module:basic-styles/superscript/superscriptediting~SuperscriptEditing} and
 * {@link module:basic-styles/superscript/superscriptui~SuperscriptUI} plugins.
 *
 * @extends module:core/plugin~Plugin
 */
class Superscript extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _superscript_superscriptediting__WEBPACK_IMPORTED_MODULE_1__["default"], _superscript_superscriptui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Superscript';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptediting.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptediting.js ***!
  \*********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SuperscriptEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/superscript/superscriptediting
 */




const SUPERSCRIPT = 'superscript';

/**
 * The superscript editing feature.
 *
 * It registers the `super` command and introduces the `super` attribute in the model which renders to the view
 * as a `<super>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class SuperscriptEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'SuperscriptEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		// Allow super attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: SUPERSCRIPT } );
		editor.model.schema.setAttributeProperties( SUPERSCRIPT, {
			isFormatting: true,
			copyOnEnter: true
		} );

		// Build converter from model to view for data and editing pipelines.

		editor.conversion.attributeToElement( {
			model: SUPERSCRIPT,
			view: 'sup',
			upcastAlso: [
				{
					styles: {
						'vertical-align': 'super'
					}
				}
			]
		} );

		// Create super command.
		editor.commands.add( SUPERSCRIPT, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, SUPERSCRIPT ) );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptui.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/superscript/superscriptui.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SuperscriptUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_superscript_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/superscript.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/superscript.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/superscript/superscriptui
 */






const SUPERSCRIPT = 'superscript';

/**
 * The superscript UI feature. It introduces the Superscript button.
 *
 * @extends module:core/plugin~Plugin
 */
class SuperscriptUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add superscript button to feature components.
		editor.ui.componentFactory.add( SUPERSCRIPT, locale => {
			const command = editor.commands.get( SUPERSCRIPT );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Superscript' ),
				icon: _theme_icons_superscript_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( SUPERSCRIPT );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Underline; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _underline_underlineediting__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./underline/underlineediting */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineediting.js");
/* harmony import */ var _underline_underlineui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./underline/underlineui */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineui.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/underline
 */





/**
 * The underline feature.
 *
 * For a detailed overview check the {@glink features/basic-styles Basic styles feature documentation}
 * and the {@glink api/basic-styles package page}.
 *
 * This is a "glue" plugin which loads the {@link module:basic-styles/underline/underlineediting~UnderlineEditing} and
 * {@link module:basic-styles/underline/underlineui~UnderlineUI} plugins.
 *
 * @extends module:core/plugin~Plugin
 */
class Underline extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _underline_underlineediting__WEBPACK_IMPORTED_MODULE_1__["default"], _underline_underlineui__WEBPACK_IMPORTED_MODULE_2__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Underline';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineediting.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineediting.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UnderlineEditing; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _attributecommand__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../attributecommand */ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/attributecommand.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/underline/underlineediting
 */




const UNDERLINE = 'underline';

/**
 * The underline editing feature.
 *
 * It registers the `'underline'` command, the <kbd>Ctrl+U</kbd> keystroke
 * and introduces the `underline` attribute in the model which renders to the view as an `<u>` element.
 *
 * @extends module:core/plugin~Plugin
 */
class UnderlineEditing extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'UnderlineEditing';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;

		// Allow strikethrough attribute on text nodes.
		editor.model.schema.extend( '$text', { allowAttributes: UNDERLINE } );
		editor.model.schema.setAttributeProperties( UNDERLINE, {
			isFormatting: true,
			copyOnEnter: true
		} );

		editor.conversion.attributeToElement( {
			model: UNDERLINE,
			view: 'u',
			upcastAlso: {
				styles: {
					'text-decoration': 'underline'
				}
			}
		} );

		// Create underline command.
		editor.commands.add( UNDERLINE, new _attributecommand__WEBPACK_IMPORTED_MODULE_1__["default"]( editor, UNDERLINE ) );

		// Set the Ctrl+U keystroke.
		editor.keystrokes.set( 'CTRL+U', 'underline' );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineui.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/src/underline/underlineui.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UnderlineUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/button/buttonview */ "./node_modules/@ckeditor/ckeditor5-ui/src/button/buttonview.js");
/* harmony import */ var _theme_icons_underline_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../theme/icons/underline.svg */ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/underline.svg");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module basic-styles/underline/underlineui
 */






const UNDERLINE = 'underline';

/**
 * The underline UI feature. It introduces the Underline button.
 *
 * @extends module:core/plugin~Plugin
 */
class UnderlineUI extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const t = editor.t;

		// Add bold button to feature components.
		editor.ui.componentFactory.add( UNDERLINE, locale => {
			const command = editor.commands.get( UNDERLINE );
			const view = new _ckeditor_ckeditor5_ui_src_button_buttonview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale );

			view.set( {
				label: t( 'Underline' ),
				icon: _theme_icons_underline_svg__WEBPACK_IMPORTED_MODULE_2__["default"],
				keystroke: 'CTRL+U',
				tooltip: true,
				isToggleable: true
			} );

			view.bind( 'isOn', 'isEnabled' ).to( command, 'value', 'isEnabled' );

			// Execute command.
			this.listenTo( view, 'execute', () => {
				editor.execute( UNDERLINE );
				editor.editing.view.focus();
			} );

			return view;
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/code.css":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/code.css ***!
  \**********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../../postcss-loader/src??ref--12-1!./code.css */ "./node_modules/postcss-loader/src/index.js?!./node_modules/@ckeditor/ckeditor5-basic-styles/theme/code.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {"injectType":"singletonStyleTag","attributes":{"data-cke":true}};

options.insert = "head";
options.singleton = true;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/bold.svg":
/*!****************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/bold.svg ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M10.187 17H5.773c-.637 0-1.092-.138-1.364-.415-.273-.277-.409-.718-.409-1.323V4.738c0-.617.14-1.062.419-1.332.279-.27.73-.406 1.354-.406h4.68c.69 0 1.288.041 1.793.124.506.083.96.242 1.36.478.341.197.644.447.906.75a3.262 3.262 0 0 1 .808 2.162c0 1.401-.722 2.426-2.167 3.075C15.05 10.175 16 11.315 16 13.01a3.756 3.756 0 0 1-2.296 3.504 6.1 6.1 0 0 1-1.517.377c-.571.073-1.238.11-2 .11zm-.217-6.217H7v4.087h3.069c1.977 0 2.965-.69 2.965-2.072 0-.707-.256-1.22-.768-1.537-.512-.319-1.277-.478-2.296-.478zM7 5.13v3.619h2.606c.729 0 1.292-.067 1.69-.2a1.6 1.6 0 0 0 .91-.765c.165-.267.247-.566.247-.897 0-.707-.26-1.176-.778-1.409-.519-.232-1.31-.348-2.375-.348H7z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/code.svg":
/*!****************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/code.svg ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M12.5 5.7l5.2 3.9v1.3l-5.6 4c-.1.2-.3.2-.5.2-.3-.1-.6-.7-.6-1l.3-.4 4.7-3.5L11.5 7l-.2-.2c-.1-.3-.1-.6 0-.8.2-.2.5-.4.8-.4a.8.8 0 0 1 .4.1zm-5.2 0L2 9.6v1.3l5.6 4c.1.2.3.2.5.2.3-.1.7-.7.6-1 0-.1 0-.3-.2-.4l-5-3.5L8.2 7l.2-.2c.1-.3.1-.6 0-.8-.2-.2-.5-.4-.8-.4a.8.8 0 0 0-.3.1z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/italic.svg":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/italic.svg ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M9.586 14.633l.021.004c-.036.335.095.655.393.962.082.083.173.15.274.201h1.474a.6.6 0 1 1 0 1.2H5.304a.6.6 0 0 1 0-1.2h1.15c.474-.07.809-.182 1.005-.334.157-.122.291-.32.404-.597l2.416-9.55a1.053 1.053 0 0 0-.281-.823 1.12 1.12 0 0 0-.442-.296H8.15a.6.6 0 0 1 0-1.2h6.443a.6.6 0 1 1 0 1.2h-1.195c-.376.056-.65.155-.823.296-.215.175-.423.439-.623.79l-2.366 9.347z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/strikethrough.svg":
/*!*************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/strikethrough.svg ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7 16.4c-.8-.4-1.5-.9-2.2-1.5a.6.6 0 0 1-.2-.5l.3-.6h1c1 1.2 2.1 1.7 3.7 1.7 1 0 1.8-.3 2.3-.6.6-.4.6-1.2.6-1.3.2-1.2-.9-2.1-.9-2.1h2.1c.3.7.4 1.2.4 1.7v.8l-.6 1.2c-.6.8-1.1 1-1.6 1.2a6 6 0 0 1-2.4.6c-1 0-1.8-.3-2.5-.6zM6.8 9L6 8.3c-.4-.5-.5-.8-.5-1.6 0-.7.1-1.3.5-1.8.4-.6 1-1 1.6-1.3a6.3 6.3 0 0 1 4.7 0 4 4 0 0 1 1.7 1l.3.7c0 .1.2.4-.2.7-.4.2-.9.1-1 0a3 3 0 0 0-1.2-1c-.4-.2-1-.3-2-.4-.7 0-1.4.2-2 .6-.8.6-1 .8-1 1.5 0 .8.5 1 1.2 1.5.6.4 1.1.7 1.9 1H6.8z\"/><path d=\"M3 10.5V9h14v1.5z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/subscript.svg":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/subscript.svg ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7.03 10.349l3.818-3.819a.8.8 0 1 1 1.132 1.132L8.16 11.48l3.819 3.818a.8.8 0 1 1-1.132 1.132L7.03 12.61l-3.818 3.82a.8.8 0 1 1-1.132-1.132L5.9 11.48 2.08 7.662A.8.8 0 1 1 3.212 6.53l3.818 3.82zm8.147 7.829h2.549c.254 0 .447.05.58.152a.49.49 0 0 1 .201.413.54.54 0 0 1-.159.393c-.105.108-.266.162-.48.162h-3.594c-.245 0-.435-.066-.572-.197a.621.621 0 0 1-.205-.463c0-.114.044-.265.132-.453a1.62 1.62 0 0 1 .288-.444c.433-.436.824-.81 1.172-1.122.348-.312.597-.517.747-.615.267-.183.49-.368.667-.553.177-.185.312-.375.405-.57.093-.194.139-.384.139-.57a1.008 1.008 0 0 0-.554-.917 1.197 1.197 0 0 0-.56-.133c-.426 0-.761.182-1.005.546a2.332 2.332 0 0 0-.164.39 1.609 1.609 0 0 1-.258.488c-.096.114-.237.17-.423.17a.558.558 0 0 1-.405-.156.568.568 0 0 1-.161-.427c0-.218.05-.446.151-.683.101-.238.252-.453.452-.646s.454-.349.762-.467a2.998 2.998 0 0 1 1.081-.178c.498 0 .923.076 1.274.228a1.916 1.916 0 0 1 1.004 1.032 1.984 1.984 0 0 1-.156 1.794c-.2.32-.405.572-.613.754-.208.182-.558.468-1.048.857-.49.39-.826.691-1.008.906a2.703 2.703 0 0 0-.24.309z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/superscript.svg":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/superscript.svg ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M15.677 8.678h2.549c.254 0 .447.05.58.152a.49.49 0 0 1 .201.413.54.54 0 0 1-.159.393c-.105.108-.266.162-.48.162h-3.594c-.245 0-.435-.066-.572-.197a.621.621 0 0 1-.205-.463c0-.114.044-.265.132-.453a1.62 1.62 0 0 1 .288-.444c.433-.436.824-.81 1.172-1.122.348-.312.597-.517.747-.615.267-.183.49-.368.667-.553.177-.185.312-.375.405-.57.093-.194.139-.384.139-.57a1.008 1.008 0 0 0-.554-.917 1.197 1.197 0 0 0-.56-.133c-.426 0-.761.182-1.005.546a2.332 2.332 0 0 0-.164.39 1.609 1.609 0 0 1-.258.488c-.096.114-.237.17-.423.17a.558.558 0 0 1-.405-.156.568.568 0 0 1-.161-.427c0-.218.05-.446.151-.683.101-.238.252-.453.452-.646s.454-.349.762-.467a2.998 2.998 0 0 1 1.081-.178c.498 0 .923.076 1.274.228a1.916 1.916 0 0 1 1.004 1.032 1.984 1.984 0 0 1-.156 1.794c-.2.32-.405.572-.613.754-.208.182-.558.468-1.048.857-.49.39-.826.691-1.008.906a2.703 2.703 0 0 0-.24.309zM7.03 10.349l3.818-3.819a.8.8 0 1 1 1.132 1.132L8.16 11.48l3.819 3.818a.8.8 0 1 1-1.132 1.132L7.03 12.61l-3.818 3.82a.8.8 0 1 1-1.132-1.132L5.9 11.48 2.08 7.662A.8.8 0 1 1 3.212 6.53l3.818 3.82z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/underline.svg":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-basic-styles/theme/icons/underline.svg ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M3 18v-1.5h14V18zm2.2-8V3.6c0-.4.4-.6.8-.6.3 0 .7.2.7.6v6.2c0 2 1.3 2.8 3.2 2.8 1.9 0 3.4-.9 3.4-2.9V3.6c0-.3.4-.5.8-.5.3 0 .7.2.7.5V10c0 2.7-2.2 4-4.9 4-2.6 0-4.7-1.2-4.7-4z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/clipboard.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/clipboard.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Clipboard; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _clipboardobserver__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./clipboardobserver */ "./node_modules/@ckeditor/ckeditor5-clipboard/src/clipboardobserver.js");
/* harmony import */ var _utils_plaintexttohtml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/plaintexttohtml */ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/plaintexttohtml.js");
/* harmony import */ var _utils_normalizeclipboarddata__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/normalizeclipboarddata */ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/normalizeclipboarddata.js");
/* harmony import */ var _utils_viewtoplaintext_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/viewtoplaintext.js */ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/viewtoplaintext.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_eventinfo__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/eventinfo */ "./node_modules/@ckeditor/ckeditor5-utils/src/eventinfo.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/clipboard
 */












/**
 * The clipboard feature. It is responsible for intercepting the `paste` and `drop` events and
 * passing the pasted content through the clipboard pipeline in order to insert it into the editor's content.
 * It also handles the `cut` and `copy` events to fill the native clipboard with serialized editor's data.
 *
 * Read more about the clipboard integration in {@glink framework/guides/deep-dive/clipboard "Clipboard" deep dive} guide.
 *
 * @extends module:core/plugin~Plugin
 */
class Clipboard extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'Clipboard';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;
		const modelDocument = editor.model.document;
		const view = editor.editing.view;
		const viewDocument = view.document;

		/**
		 * Data processor used to convert pasted HTML to a view structure.
		 *
		 * @private
		 * @member {module:engine/dataprocessor/htmldataprocessor~HtmlDataProcessor} #_htmlDataProcessor
		 */
		this._htmlDataProcessor = new _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_5__["default"]( viewDocument );

		view.addObserver( _clipboardobserver__WEBPACK_IMPORTED_MODULE_1__["default"] );

		// The clipboard paste pipeline.

		// Pasting and dropping is disabled when editor is read-only.
		// See: https://github.com/ckeditor/ckeditor5-clipboard/issues/26.
		this.listenTo( viewDocument, 'clipboardInput', evt => {
			if ( editor.isReadOnly ) {
				evt.stop();
			}
		}, { priority: 'highest' } );

		this.listenTo( viewDocument, 'clipboardInput', ( evt, data ) => {
			const dataTransfer = data.dataTransfer;
			let content = '';

			if ( dataTransfer.getData( 'text/html' ) ) {
				content = Object(_utils_normalizeclipboarddata__WEBPACK_IMPORTED_MODULE_3__["default"])( dataTransfer.getData( 'text/html' ) );
			} else if ( dataTransfer.getData( 'text/plain' ) ) {
				content = Object(_utils_plaintexttohtml__WEBPACK_IMPORTED_MODULE_2__["default"])( dataTransfer.getData( 'text/plain' ) );
			}

			content = this._htmlDataProcessor.toView( content );

			const eventInfo = new _ckeditor_ckeditor5_utils_src_eventinfo__WEBPACK_IMPORTED_MODULE_6__["default"]( this, 'inputTransformation' );
			this.fire( eventInfo, { content, dataTransfer } );

			// If CKEditor handled the input, do not bubble the original event any further.
			// This helps external integrations recognize that fact and act accordingly.
			// https://github.com/ckeditor/ckeditor5-upload/issues/92
			if ( eventInfo.stop.called ) {
				evt.stop();
			}

			view.scrollToTheSelection();
		}, { priority: 'low' } );

		this.listenTo( this, 'inputTransformation', ( evt, data ) => {
			if ( !data.content.isEmpty ) {
				const dataController = this.editor.data;
				const model = this.editor.model;

				// Convert the pasted content to a model document fragment.
				// Conversion is contextual, but in this case we need an "all allowed" context and for that
				// we use the $clipboardHolder item.
				const modelFragment = dataController.toModel( data.content, '$clipboardHolder' );

				if ( modelFragment.childCount == 0 ) {
					return;
				}

				model.insertContent( modelFragment );
				evt.stop();
			}
		}, { priority: 'low' } );

		// The clipboard copy/cut pipeline.

		function onCopyCut( evt, data ) {
			const dataTransfer = data.dataTransfer;

			data.preventDefault();

			const content = editor.data.toView( editor.model.getSelectedContent( modelDocument.selection ) );

			viewDocument.fire( 'clipboardOutput', { dataTransfer, content, method: evt.name } );
		}

		this.listenTo( viewDocument, 'copy', onCopyCut, { priority: 'low' } );
		this.listenTo( viewDocument, 'cut', ( evt, data ) => {
			// Cutting is disabled when editor is read-only.
			// See: https://github.com/ckeditor/ckeditor5-clipboard/issues/26.
			if ( editor.isReadOnly ) {
				data.preventDefault();
			} else {
				onCopyCut( evt, data );
			}
		}, { priority: 'low' } );

		this.listenTo( viewDocument, 'clipboardOutput', ( evt, data ) => {
			if ( !data.content.isEmpty ) {
				data.dataTransfer.setData( 'text/html', this._htmlDataProcessor.toData( data.content ) );
				data.dataTransfer.setData( 'text/plain', Object(_utils_viewtoplaintext_js__WEBPACK_IMPORTED_MODULE_4__["default"])( data.content ) );
			}

			if ( data.method == 'cut' ) {
				editor.model.deleteContent( modelDocument.selection );
			}
		}, { priority: 'low' } );
	}
}

/**
 * Fired with a `content` and `dataTransfer` objects. The `content` which comes from the clipboard (was pasted or dropped)
 * should be processed in order to be inserted into the editor. The `dataTransfer` object is available
 * in case the transformation functions needs access to a raw clipboard data.
 *
 * It is a part of the {@glink framework/guides/deep-dive/clipboard#input-pipeline "clipboard input pipeline"}.
 *
 * @see module:clipboard/clipboardobserver~ClipboardObserver
 * @see module:clipboard/clipboard~Clipboard
 * @event module:clipboard/clipboard~Clipboard#event:inputTransformation
 * @param {Object} data Event data.
 * @param {module:engine/view/documentfragment~DocumentFragment} data.content Event data. Content to be inserted into the editor.
 * It can be modified by the event listeners. Read more about the clipboard pipelines in
 * {@glink framework/guides/deep-dive/clipboard "Clipboard" deep dive}.
 * @param {module:clipboard/datatransfer~DataTransfer} data.dataTransfer Data transfer instance.
 */

/**
 * Fired on {@link module:engine/view/document~Document#event:copy} and {@link module:engine/view/document~Document#event:cut}
 * with a copy of selected content. The content can be processed before it ends up in the clipboard.
 *
 * It is a part of the {@glink framework/guides/deep-dive/clipboard#output-pipeline "clipboard output pipeline"}.
 *
 * @see module:clipboard/clipboardobserver~ClipboardObserver
 * @see module:clipboard/clipboard~Clipboard
 * @event module:engine/view/document~Document#event:clipboardOutput
 * @param {module:clipboard/clipboard~ClipboardOutputEventData} data Event data.
 */

/**
 * The value of the {@link module:engine/view/document~Document#event:clipboardOutput} event.
 *
 * @class module:clipboard/clipboard~ClipboardOutputEventData
 */

/**
 * Data transfer instance.
 *
 * @readonly
 * @member {module:clipboard/datatransfer~DataTransfer} module:clipboard/clipboard~ClipboardOutputEventData#dataTransfer
 */

/**
 * Content to be put into the clipboard. It can be modified by the event listeners.
 * Read more about the clipboard pipelines in {@glink framework/guides/deep-dive/clipboard "Clipboard" deep dive}.
 *
 * @member {module:engine/view/documentfragment~DocumentFragment} module:clipboard/clipboard~ClipboardOutputEventData#content
 */

/**
 * Whether the event was triggered by copy or cut operation.
 *
 * @member {'copy'|'cut'} module:clipboard/clipboard~ClipboardOutputEventData#method
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/clipboardobserver.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/clipboardobserver.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ClipboardObserver; });
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_observer_domeventobserver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/observer/domeventobserver */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/observer/domeventobserver.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_eventinfo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/eventinfo */ "./node_modules/@ckeditor/ckeditor5-utils/src/eventinfo.js");
/* harmony import */ var _datatransfer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./datatransfer */ "./node_modules/@ckeditor/ckeditor5-clipboard/src/datatransfer.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/clipboardobserver
 */





/**
 * Clipboard events observer.
 *
 * Fires the following events:
 *
 * * {@link module:engine/view/document~Document#event:clipboardInput}
 * * {@link module:engine/view/document~Document#event:dragover}
 * * {@link module:engine/view/document~Document#event:drop}
 * * {@link module:engine/view/document~Document#event:paste}
 * * {@link module:engine/view/document~Document#event:copy}
 * * {@link module:engine/view/document~Document#event:cut}
 *
 * Note that this observer is not available by default (it is not added by the engine).
 * To make it available it needs to be added to {@link module:engine/view/document~Document} by
 * the {@link module:engine/view/view~View#addObserver `View#addObserver()`} method. You can also load the
 * {@link module:clipboard/clipboard~Clipboard} plugin which adds this observer automatically (because it uses it).
 *
 * @extends module:engine/view/observer/domeventobserver~DomEventObserver
 */
class ClipboardObserver extends _ckeditor_ckeditor5_engine_src_view_observer_domeventobserver__WEBPACK_IMPORTED_MODULE_0__["default"] {
	constructor( view ) {
		super( view );

		const viewDocument = this.document;

		this.domEventType = [ 'paste', 'copy', 'cut', 'drop', 'dragover' ];

		this.listenTo( viewDocument, 'paste', handleInput, { priority: 'low' } );
		this.listenTo( viewDocument, 'drop', handleInput, { priority: 'low' } );

		function handleInput( evt, data ) {
			data.preventDefault();

			const targetRanges = data.dropRange ? [ data.dropRange ] : Array.from( viewDocument.selection.getRanges() );

			const eventInfo = new _ckeditor_ckeditor5_utils_src_eventinfo__WEBPACK_IMPORTED_MODULE_1__["default"]( viewDocument, 'clipboardInput' );

			viewDocument.fire( eventInfo, {
				dataTransfer: data.dataTransfer,
				targetRanges
			} );

			// If CKEditor handled the input, do not bubble the original event any further.
			// This helps external integrations recognize that fact and act accordingly.
			// https://github.com/ckeditor/ckeditor5-upload/issues/92
			if ( eventInfo.stop.called ) {
				data.stopPropagation();
			}
		}
	}

	onDomEvent( domEvent ) {
		const evtData = {
			dataTransfer: new _datatransfer__WEBPACK_IMPORTED_MODULE_2__["default"]( domEvent.clipboardData ? domEvent.clipboardData : domEvent.dataTransfer )
		};

		if ( domEvent.type == 'drop' ) {
			evtData.dropRange = getDropViewRange( this.view, domEvent );
		}

		this.fire( domEvent.type, domEvent, evtData );
	}
}

function getDropViewRange( view, domEvent ) {
	const domDoc = domEvent.target.ownerDocument;
	const x = domEvent.clientX;
	const y = domEvent.clientY;
	let domRange;

	// Webkit & Blink.
	if ( domDoc.caretRangeFromPoint && domDoc.caretRangeFromPoint( x, y ) ) {
		domRange = domDoc.caretRangeFromPoint( x, y );
	}
	// FF.
	else if ( domEvent.rangeParent ) {
		domRange = domDoc.createRange();
		domRange.setStart( domEvent.rangeParent, domEvent.rangeOffset );
		domRange.collapse( true );
	}

	if ( domRange ) {
		return view.domConverter.domRangeToView( domRange );
	} else {
		return view.document.selection.getFirstRange();
	}
}

/**
 * Fired as a continuation of {@link #event:paste} and {@link #event:drop} events.
 *
 * It is a part of the {@glink framework/guides/deep-dive/clipboard#input-pipeline "clipboard input pipeline"}.
 *
 * Fired with a `dataTransfer` which comes from the clipboard and which content should be processed
 * and inserted into the editor.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:clipboard/clipboardobserver~ClipboardObserver
 * @see module:clipboard/clipboard~Clipboard
 * @event module:engine/view/document~Document#event:clipboardInput
 * @param {Object} data Event data.
 * @param {module:clipboard/datatransfer~DataTransfer} data.dataTransfer Data transfer instance.
 * @param {Array.<module:engine/view/range~Range>} data.targetRanges Ranges which are the target of the operation
 * (usually – into which the content should be inserted).
 * If clipboard input was triggered by a paste operation, then these are the selection ranges. If by a drop operation,
 * then it's the drop position (which can be different than the selection at the moment of drop).
 */

/**
 * Fired when user drags content over one of the editables.
 *
 * Introduced by {@link module:clipboard/clipboardobserver~ClipboardObserver}.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:engine/view/document~Document#event:clipboardInput
 * @event module:engine/view/document~Document#event:dragover
 * @param {module:clipboard/clipboardobserver~ClipboardEventData} data Event data.
 */

/**
 * Fired when user dropped content into one of the editables.
 *
 * Introduced by {@link module:clipboard/clipboardobserver~ClipboardObserver}.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:engine/view/document~Document#event:clipboardInput
 * @event module:engine/view/document~Document#event:drop
 * @param {module:clipboard/clipboardobserver~ClipboardEventData} data Event data.
 * @param {module:engine/view/range~Range} dropRange The position into which the content is dropped.
 */

/**
 * Fired when user pasted content into one of the editables.
 *
 * Introduced by {@link module:clipboard/clipboardobserver~ClipboardObserver}.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:engine/view/document~Document#event:clipboardInput
 * @event module:engine/view/document~Document#event:paste
 * @param {module:clipboard/clipboardobserver~ClipboardEventData} data Event data.
 */

/**
 * Fired when user copied content from one of the editables.
 *
 * Introduced by {@link module:clipboard/clipboardobserver~ClipboardObserver}.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:clipboard/clipboardobserver~ClipboardObserver
 * @event module:engine/view/document~Document#event:copy
 * @param {module:clipboard/clipboardobserver~ClipboardEventData} data Event data.
 */

/**
 * Fired when user cut content from one of the editables.
 *
 * Introduced by {@link module:clipboard/clipboardobserver~ClipboardObserver}.
 *
 * Note that this event is not available by default. To make it available {@link module:clipboard/clipboardobserver~ClipboardObserver}
 * needs to be added to {@link module:engine/view/document~Document} by the {@link module:engine/view/view~View#addObserver} method.
 * It's done by the {@link module:clipboard/clipboard~Clipboard} feature. If it's not loaded, it must be done manually.
 *
 * @see module:clipboard/clipboardobserver~ClipboardObserver
 * @event module:engine/view/document~Document#event:cut
 * @param {module:clipboard/clipboardobserver~ClipboardEventData} data Event data.
 */

/**
 * The value of the {@link module:engine/view/document~Document#event:paste},
 * {@link module:engine/view/document~Document#event:copy} and {@link module:engine/view/document~Document#event:cut} events.
 *
 * In order to access clipboard data use `dataTransfer` property.
 *
 * @class module:clipboard/clipboardobserver~ClipboardEventData
 * @extends module:engine/view/observer/domeventdata~DomEventData
 */

/**
 * Data transfer instance.
 *
 * @readonly
 * @member {module:clipboard/datatransfer~DataTransfer} module:clipboard/clipboardobserver~ClipboardEventData#dataTransfer
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/datatransfer.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/datatransfer.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DataTransfer; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/datatransfer
 */

/**
 * Facade over the native [`DataTransfer`](https://developer.mozilla.org/en-US/docs/Web/API/DataTransfer) object.
 */
class DataTransfer {
	constructor( nativeDataTransfer ) {
		/**
		 * The array of files created from the native `DataTransfer#files` or `DataTransfer#items`.
		 *
		 * @readonly
		 * @member {Array.<File>} #files
		 */
		this.files = getFiles( nativeDataTransfer );

		/**
		 * The native DataTransfer object.
		 *
		 * @private
		 * @member {DataTransfer} #_native
		 */
		this._native = nativeDataTransfer;
	}

	/**
	 * Returns an array of available native content types.
	 *
	 * @returns {Array.<String>}
	 */
	get types() {
		return this._native.types;
	}

	/**
	 * Gets data from the data transfer by its mime type.
	 *
	 *		dataTransfer.getData( 'text/plain' );
	 *
	 * @param {String} type The mime type. E.g. `text/html` or `text/plain`.
	 * @returns {String}
	 */
	getData( type ) {
		return this._native.getData( type );
	}

	/**
	 * Sets data in the data transfer.
	 *
	 * @param {String} type The mime type. E.g. `text/html` or `text/plain`.
	 * @param {String} data
	 */
	setData( type, data ) {
		this._native.setData( type, data );
	}
}

function getFiles( nativeDataTransfer ) {
	// DataTransfer.files and items are Array-like and might not have an iterable interface.
	const files = nativeDataTransfer.files ? Array.from( nativeDataTransfer.files ) : [];
	const items = nativeDataTransfer.items ? Array.from( nativeDataTransfer.items ) : [];

	if ( files.length ) {
		return files;
	}
	// Chrome have empty DataTransfer.files, but let get files through the items interface.
	return items
		.filter( item => item.kind === 'file' )
		.map( item => item.getAsFile() );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/normalizeclipboarddata.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/normalizeclipboarddata.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return normalizeClipboardData; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/utils/normalizeclipboarddata
 */

/**
 * Removes some popular browser quirks out of the clipboard data (HTML).
 *
 * @param {String} data The HTML data to normalize.
 * @returns {String} Normalized HTML.
 */
function normalizeClipboardData( data ) {
	return data
		.replace( /<span(?: class="Apple-converted-space"|)>(\s+)<\/span>/g, ( fullMatch, spaces ) => {
			// Handle the most popular and problematic case when even a single space becomes an nbsp;.
			// Decode those to normal spaces. Read more in https://github.com/ckeditor/ckeditor5-clipboard/issues/2.
			if ( spaces.length == 1 ) {
				return ' ';
			}

			return spaces;
		} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/plaintexttohtml.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/plaintexttohtml.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return plainTextToHtml; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/utils/plaintexttohtml
 */

/**
 * Converts plain text to its HTML-ized version.
 *
 * @param {String} text The plain text to convert.
 * @returns {String} HTML generated from the plain text.
 */
function plainTextToHtml( text ) {
	text = text
		// Encode <>.
		.replace( /</g, '&lt;' )
		.replace( />/g, '&gt;' )
		// Creates paragraphs for every line breaks.
		.replace( /\n/g, '</p><p>' )
		// Preserve trailing spaces (only the first and last one – the rest is handled below).
		.replace( /^\s/, '&nbsp;' )
		.replace( /\s$/, '&nbsp;' )
		// Preserve other subsequent spaces now.
		.replace( /\s\s/g, ' &nbsp;' );

	if ( text.indexOf( '</p><p>' ) > -1 ) {
		// If we created paragraphs above, add the trailing ones.
		text = `<p>${ text }</p>`;
	}

	// TODO:
	// * What about '\nfoo' vs ' foo'?

	return text;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/viewtoplaintext.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-clipboard/src/utils/viewtoplaintext.js ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return viewToPlainText; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module clipboard/utils/viewtoplaintext
 */

// Elements which should not have empty-line padding.
// Most `view.ContainerElement` want to be separate by new-line, but some are creating one structure
// together (like `<li>`) so it is better to separate them by only one "\n".
const smallPaddingElements = [ 'figcaption', 'li' ];

/**
 * Converts {@link module:engine/view/item~Item view item} and all of its children to plain text.
 *
 * @param {module:engine/view/item~Item} viewItem View item to convert.
 * @returns {String} Plain text representation of `viewItem`.
 */
function viewToPlainText( viewItem ) {
	let text = '';

	if ( viewItem.is( '$text' ) || viewItem.is( '$textProxy' ) ) {
		// If item is `Text` or `TextProxy` simple take its text data.
		text = viewItem.data;
	} else if ( viewItem.is( 'element', 'img' ) && viewItem.hasAttribute( 'alt' ) ) {
		// Special case for images - use alt attribute if it is provided.
		text = viewItem.getAttribute( 'alt' );
	} else {
		// Other elements are document fragments, attribute elements or container elements.
		// They don't have their own text value, so convert their children.
		let prev = null;

		for ( const child of viewItem.getChildren() ) {
			const childText = viewToPlainText( child );

			// Separate container element children with one or more new-line characters.
			if ( prev && ( prev.is( 'containerElement' ) || child.is( 'containerElement' ) ) ) {
				if ( smallPaddingElements.includes( prev.name ) || smallPaddingElements.includes( child.name ) ) {
					text += '\n';
				} else {
					text += '\n\n';
				}
			}

			text += childText;
			prev = child;
		}
	}

	return text;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-cloud-services/src/cloudservices.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-cloud-services/src/cloudservices.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CloudServices; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_contextplugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/contextplugin */ "./node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js");
/* harmony import */ var _ckeditor_ckeditor_cloud_services_core_src_token_token__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor-cloud-services-core/src/token/token */ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/token/token.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module cloud-services/cloudservices
 */




/**
 * Plugin introducing integration between CKEditor 5 and CKEditor Cloud Services .
 *
 * It initializes the token provider based on
 * the {@link module:cloud-services/cloudservices~CloudServicesConfig `config.cloudService`}.
 *
 * @extends module:core/plugin~Plugin
 */
class CloudServices extends _ckeditor_ckeditor5_core_src_contextplugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritdoc
	 */
	static get pluginName() {
		return 'CloudServices';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const config = this.context.config;

		const options = config.get( 'cloudServices' ) || {};

		for ( const optionName in options ) {
			this[ optionName ] = options[ optionName ];
		}

		/**
		 * The authentication token URL for CKEditor Cloud Services or a callback to the token value promise. See the
		 * {@link module:cloud-services/cloudservices~CloudServicesConfig#tokenUrl} for more details.
		 *
		 * @readonly
		 * @member {String|Function|undefined} #tokenUrl
		 */

		/**
		 * The URL to which the files should be uploaded.
		 *
		 * @readonly
		 * @member {String} #uploadUrl
		 */

		/**
		 * Other plugins use this token for the authorization process. It handles token requesting and refreshing.
		 * Its value is `null` when {@link module:cloud-services/cloudservices~CloudServicesConfig#tokenUrl} is not provided.
		 *
		 * @readonly
		 * @member {Object|null} #token
		 */

		if ( !this.tokenUrl ) {
			this.token = null;

			return;
		}

		this.token = new CloudServices.Token( this.tokenUrl );

		return this.token.init();
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		super.destroy();

		if ( this.token ) {
			this.token.destroy();
		}
	}
}

CloudServices.Token = _ckeditor_ckeditor_cloud_services_core_src_token_token__WEBPACK_IMPORTED_MODULE_1__["default"];

/**
 * The configuration of CKEditor Cloud Services. Introduced by the {@link module:cloud-services/cloudservices~CloudServices} plugin.
 *
 * Read more in {@link module:cloud-services/cloudservices~CloudServicesConfig}.
 *
 * @member {module:cloud-services/cloudservices~CloudServicesConfig} module:core/editor/editorconfig~EditorConfig#cloudServices
 */

/**
 * The configuration for all plugins using CKEditor Cloud Services.
 *
 *		ClassicEditor
 *			.create( document.querySelector( '#editor' ), {
 *				cloudServices: {
 *					tokenUrl: 'https://example.com/cs-token-endpoint',
 *					uploadUrl: 'https://your-organization-id.cke-cs.com/easyimage/upload/'
 *				}
 *			} )
 *			.then( ... )
 *			.catch( ... );
 *
 * See {@link module:core/editor/editorconfig~EditorConfig all editor options}.
 *
 * @interface CloudServicesConfig
 */

/**
 * A token URL or a token request function.
 *
 * As a string, it should be a URL to the security token endpoint in your application. The role of this endpoint is to securely authorize
 * the end users of your application to use [CKEditor Cloud Services](https://ckeditor.com/ckeditor-cloud-services) only
 * if they should have access e.g. to upload files with {@glink @cs guides/easy-image/quick-start Easy Image} or to use the
 * {@glink @cs guides/collaboration/quick-start Collaboration} service.
 *
 *		ClassicEditor
 *			.create( document.querySelector( '#editor' ), {
 *				cloudServices: {
 *					tokenUrl: 'https://example.com/cs-token-endpoint',
 *					...
 *				}
 *			} )
 *			.then( ... )
 *			.catch( ... );
 *
 * As a function, it should provide a promise to the token value, so you can highly customize the token and provide your token URL endpoint.
 * By using this approach you can set your own headers for the request.
 *
 * 		ClassicEditor
 *			.create( document.querySelector( '#editor' ), {
 *				cloudServices: {
 *					tokenUrl: () => new Promise( ( resolve, reject ) => {
 *						const xhr = new XMLHttpRequest();
 *
 *						xhr.open( 'GET', 'https://example.com/cs-token-endpoint' );
 *
 *						xhr.addEventListener( 'load', () => {
 *							const statusCode = xhr.status;
 *							const xhrResponse = xhr.response;
 *
 *							if ( statusCode < 200 || statusCode > 299 ) {
 *								return reject( new Error( 'Cannot download new token!' ) );
 *							}
 *
 *							return resolve( xhrResponse );
 *						} );
 *
 *						xhr.addEventListener( 'error', () => reject( new Error( 'Network Error' ) ) );
 *						xhr.addEventListener( 'abort', () => reject( new Error( 'Abort' ) ) );
 *
 *						xhr.setRequestHeader( customHeader, customValue );
 *
 *						xhr.send();
 *					} ),
 *					...
 *				}
 *			} )
 *
 * You can find more information about token endpoints in the
 * {@glink @cs guides/easy-image/quick-start#create-token-endpoint Cloud Services - Quick start}
 * and {@glink @cs guides/security/token-endpoint Cloud Services - Token endpoint} documentation.
 *
 * Without a properly working token endpoint (token URL) CKEditor plugins will not be able to connect to CKEditor Cloud Services.
 *
 * @member {String|Function} module:cloud-services/cloudservices~CloudServicesConfig#tokenUrl
 */

/**
 * The endpoint URL for [CKEditor Cloud Services](https://ckeditor.com/ckeditor-cloud-services) uploads.
 * This option must be set for Easy Image to work correctly.
 *
 * The upload URL is unique for each customer and can be found in the
 * [CKEditor Ecosystem customer dashboard](https://dashboard.ckeditor.com) after subscribing to the Easy Image service.
 * To learn how to start using Easy Image, check the {@glink @cs guides/easy-image/quick-start Easy Image - Quick start} documentation.
 *
 * Note: Make sure to also set the {@link module:cloud-services/cloudservices~CloudServicesConfig#tokenUrl} configuration option.
 *
 * @member {String} module:cloud-services/cloudservices~CloudServicesConfig#uploadUrl
 */

/**
 * The URL for web socket communication, used by the `RealTimeCollaborativeEditing` plugin. Every customer (organization in the CKEditor
 * Ecosystem dashboard) has their own, unique URLs to communicate with CKEditor Cloud Services. The URL can be found in the
 * CKEditor Ecosystem customer dashboard.
 *
 * Note: Unlike most plugins, `RealTimeCollaborativeEditing` is not included in any CKEditor 5 build and needs to be installed manually.
 * Check [Collaboration overview](https://ckeditor.com/docs/ckeditor5/latest/features/collaboration/overview.html) for more details.
 *
 * @member {String} module:cloud-services/cloudservices~CloudServicesConfig#webSocketUrl
 */

/**
 * An optional parameter used for integration with CKEditor Cloud Services when uploading the editor build to cloud services.
 *
 * Whenever the editor build or the configuration changes, this parameter should be set to a new, unique value to differentiate
 * the new bundle (build + configuration) from the old ones.
 *
 * @member {String} module:cloud-services/cloudservices~CloudServicesConfig#bundleVersion
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/command.js":
/*!**************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/command.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Command; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/command
 */




/**
 * The base class for CKEditor commands.
 *
 * Commands are the main way to manipulate editor contents and state. They are mostly used by UI elements (or by other
 * commands) to make changes in the model. Commands are available in every part of code that has access to
 * the {@link module:core/editor/editor~Editor editor} instance.
 *
 * Instances of registered commands can be retrieved from {@link module:core/editor/editor~Editor#commands `editor.commands`}.
 * The easiest way to execute a command is through {@link module:core/editor/editor~Editor#execute `editor.execute()`}.
 *
 * By default commands are disabled when the editor is in {@link module:core/editor/editor~Editor#isReadOnly read-only} mode.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Command {
	/**
	 * Creates a new `Command` instance.
	 *
	 * @param {module:core/editor/editor~Editor} editor Editor on which this command will be used.
	 */
	constructor( editor ) {
		/**
		 * The editor on which this command will be used.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor}
		 */
		this.editor = editor;

		/**
		 * The value of the command. A concrete command class should define what it represents for it.
		 *
		 * For example, the `'bold'` command's value indicates whether the selection starts in a bolded text.
		 * And the value of the `'link'` command may be an object with links details.
		 *
		 * It is possible for a command to have no value (e.g. for stateless actions such as `'imageUpload'`).
		 *
		 * A concrete command class should control this value by overriding the {@link #refresh `refresh()`} method.
		 *
		 * @observable
		 * @readonly
		 * @member #value
		 */
		this.set( 'value', undefined );

		/**
		 * Flag indicating whether a command is enabled or disabled.
		 * A disabled command will do nothing when executed.
		 *
		 * A concrete command class should control this value by overriding the {@link #refresh `refresh()`} method.
		 *
		 * It is possible to disable a command from "outside". For instance, in your integration you may want to disable
		 * a certain set of commands for the time being. To do that, you can use the fact that `isEnabled` is observable
		 * and it fires the `set:isEnabled` event every time anyone tries to modify its value:
		 *
		 *		function disableCommand( cmd ) {
		 *			cmd.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
		 *
		 *			cmd.isEnabled = false;
		 *
		 *			// Make it possible to enable the command again.
		 *			return () => {
		 *				cmd.off( 'set:isEnabled', forceDisable );
		 *				cmd.refresh();
		 *			};
		 *
		 *			function forceDisable( evt ) {
		 *				evt.return = false;
		 *				evt.stop();
		 *			}
		 *		}
		 *
		 *		// Usage:
		 *
		 *		// Disabling the command.
		 *		const enableBold = disableCommand( editor.commands.get( 'bold' ) );
		 *
		 *		// Enabling the command again.
		 *		enableBold();
		 *
		 * @observable
		 * @readonly
		 * @member {Boolean} #isEnabled
		 */
		this.set( 'isEnabled', false );

		/**
		 * Holds identifiers for {@link #forceDisabled} mechanism.
		 *
		 * @type {Set.<String>}
		 * @private
		 */
		this._disableStack = new Set();

		this.decorate( 'execute' );

		// By default every command is refreshed when changes are applied to the model.
		this.listenTo( this.editor.model.document, 'change', () => {
			this.refresh();
		} );

		this.on( 'execute', evt => {
			if ( !this.isEnabled ) {
				evt.stop();
			}
		}, { priority: 'high' } );

		// By default commands are disabled when the editor is in read-only mode.
		this.listenTo( editor, 'change:isReadOnly', ( evt, name, value ) => {
			if ( value ) {
				this.forceDisabled( 'readOnlyMode' );
			} else {
				this.clearForceDisabled( 'readOnlyMode' );
			}
		} );
	}

	/**
	 * Refreshes the command. The command should update its {@link #isEnabled} and {@link #value} properties
	 * in this method.
	 *
	 * This method is automatically called when
	 * {@link module:engine/model/document~Document#event:change any changes are applied to the document}.
	 */
	refresh() {
		this.isEnabled = true;
	}

	/**
	 * Disables the command.
	 *
	 * Command may be disabled by multiple features or algorithms (at once). When disabling a command, unique id should be passed
	 * (e.g. feature name). The same identifier should be used when {@link #clearForceDisabled enabling back} the command.
	 * The command becomes enabled only after all features {@link #clearForceDisabled enabled it back}.
	 *
	 * Disabling and enabling a command:
	 *
	 *		command.isEnabled; // -> true
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> false
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * Command disabled by multiple features:
	 *
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.forceDisabled( 'OtherFeature' );
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> false
	 *		command.clearForceDisabled( 'OtherFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * Multiple disabling with the same identifier is redundant:
	 *
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.forceDisabled( 'MyFeature' );
	 *		command.clearForceDisabled( 'MyFeature' );
	 *		command.isEnabled; // -> true
	 *
	 * **Note:** some commands or algorithms may have more complex logic when it comes to enabling or disabling certain commands,
	 * so the command might be still disabled after {@link #clearForceDisabled} was used.
	 *
	 * @param {String} id Unique identifier for disabling. Use the same id when {@link #clearForceDisabled enabling back} the command.
	 */
	forceDisabled( id ) {
		this._disableStack.add( id );

		if ( this._disableStack.size == 1 ) {
			this.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
			this.isEnabled = false;
		}
	}

	/**
	 * Clears forced disable previously set through {@link #forceDisabled}. See {@link #forceDisabled}.
	 *
	 * @param {String} id Unique identifier, equal to the one passed in {@link #forceDisabled} call.
	 */
	clearForceDisabled( id ) {
		this._disableStack.delete( id );

		if ( this._disableStack.size == 0 ) {
			this.off( 'set:isEnabled', forceDisable );
			this.refresh();
		}
	}

	/**
	 * Executes the command.
	 *
	 * A command may accept parameters. They will be passed from {@link module:core/editor/editor~Editor#execute `editor.execute()`}
	 * to the command.
	 *
	 * The `execute()` method will automatically abort when the command is disabled ({@link #isEnabled} is `false`).
	 * This behavior is implemented by a high priority listener to the {@link #event:execute} event.
	 *
	 * In order to see how to disable a command from "outside" see the {@link #isEnabled} documentation.
	 *
	 * This method may return a value, which would be forwarded all the way down to the
	 * {@link module:core/editor/editor~Editor#execute `editor.execute()`}.
	 *
	 * @fires execute
	 */
	execute() {}

	/**
	 * Destroys the command.
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * Event fired by the {@link #execute} method. The command action is a listener to this event so it's
	 * possible to change/cancel the behavior of the command by listening to this event.
	 *
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * **Note:** This event is fired even if command is disabled. However, it is automatically blocked
	 * by a high priority listener in order to prevent command execution.
	 *
	 * @event execute
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( Command, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );

// Helper function that forces command to be disabled.
function forceDisable( evt ) {
	evt.return = false;
	evt.stop();
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CommandCollection; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/commandcollection
 */



/**
 * Collection of commands. Its instance is available in {@link module:core/editor/editor~Editor#commands `editor.commands`}.
 */
class CommandCollection {
	/**
	 * Creates collection instance.
	 */
	constructor() {
		/**
		 * Command map.
		 *
		 * @private
		 * @member {Map}
		 */
		this._commands = new Map();
	}

	/**
	 * Registers a new command.
	 *
	 * @param {String} commandName The name of the command.
	 * @param {module:core/command~Command} command
	 */
	add( commandName, command ) {
		this._commands.set( commandName, command );
	}

	/**
	 * Retrieves a command from the collection.
	 *
	 * @param {String} commandName The name of the command.
	 * @returns {module:core/command~Command}
	 */
	get( commandName ) {
		return this._commands.get( commandName );
	}

	/**
	 * Executes a command.
	 *
	 * @param {String} commandName The name of the command.
	 * @param {*} [...commandParams] Command parameters.
	 * @returns {*} The value returned by the {@link module:core/command~Command#execute `command.execute()`}.
	 */
	execute( commandName, ...args ) {
		const command = this.get( commandName );

		if ( !command ) {
			/**
			 * Command does not exist.
			 *
			 * @error commandcollection-command-not-found
			 * @param {String} commandName Name of the command.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'commandcollection-command-not-found: Command does not exist.', this, { commandName } );
		}

		return command.execute( ...args );
	}

	/**
	 * Returns iterator of command names.
	 *
	 * @returns {Iterable.<String>}
	 */
	* names() {
		yield* this._commands.keys();
	}

	/**
	 * Returns iterator of command instances.
	 *
	 * @returns {Iterable.<module:core/command~Command>}
	 */
	* commands() {
		yield* this._commands.values();
	}

	/**
	 * Iterable interface.
	 *
	 * Returns `[ commandName, commandInstance ]` pairs.
	 *
	 * @returns {Iterable.<Array>}
	 */
	[ Symbol.iterator ]() {
		return this._commands[ Symbol.iterator ]();
	}

	/**
	 * Destroys all collection commands.
	 */
	destroy() {
		for ( const command of this.commands() ) {
			command.destroy();
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/context.js":
/*!**************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/context.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Context; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/config */ "./node_modules/@ckeditor/ckeditor5-utils/src/config.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _plugincollection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./plugincollection */ "./node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_locale__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/locale */ "./node_modules/@ckeditor/ckeditor5-utils/src/locale.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/context
 */







/**
 * Provides a common, higher-level environment for solutions that use multiple {@link module:core/editor/editor~Editor editors}
 * or plugins that work outside the editor. Use it instead of {@link module:core/editor/editor~Editor.create `Editor.create()`}
 * in advanced application integrations.
 *
 * All configuration options passed to a context will be used as default options for editor instances initialized in that context.
 *
 * {@link module:core/contextplugin~ContextPlugin Context plugins} passed to a context instance will be shared among all
 * editor instances initialized in this context. These will be the same plugin instances for all the editors.
 *
 * **Note:** The context can only be initialized with {@link module:core/contextplugin~ContextPlugin context plugins}
 * (e.g. [comments](https://ckeditor.com/collaboration/comments/)). Regular {@link module:core/plugin~Plugin plugins} require an
 * editor instance to work and cannot be added to a context.
 *
 * **Note:** You can add a context plugin to an editor instance, though.
 *
 * If you are using multiple editor instances on one page and use any context plugins, create a context to share the configuration and
 * plugins among these editors. Some plugins will use the information about all existing editors to better integrate between them.
 *
 * If you are using plugins that do not require an editor to work (e.g. [comments](https://ckeditor.com/collaboration/comments/)),
 * enable and configure them using the context.
 *
 * If you are using only a single editor on each page, use {@link module:core/editor/editor~Editor.create `Editor.create()`} instead.
 * In such case, a context instance will be created by the editor instance in a transparent way.
 *
 * See {@link module:core/context~Context.create `Context.create()`} for usage examples.
 */
class Context {
	/**
	 * Creates a context instance with a given configuration.
	 *
	 * Usually not to be used directly. See the static {@link module:core/context~Context.create `create()`} method.
	 *
	 * @param {Object} [config={}] The context configuration.
	 */
	constructor( config ) {
		/**
		 * Stores all the configurations specific to this context instance.
		 *
		 * @readonly
		 * @type {module:utils/config~Config}
		 */
		this.config = new _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_0__["default"]( config, this.constructor.defaultConfig );

		const availablePlugins = this.constructor.builtinPlugins;

		this.config.define( 'plugins', availablePlugins );

		/**
		 * The plugins loaded and in use by this context instance.
		 *
		 * @readonly
		 * @type {module:core/plugincollection~PluginCollection}
		 */
		this.plugins = new _plugincollection__WEBPACK_IMPORTED_MODULE_2__["default"]( this, availablePlugins );

		const languageConfig = this.config.get( 'language' ) || {};

		/**
		 * @readonly
		 * @type {module:utils/locale~Locale}
		 */
		this.locale = new _ckeditor_ckeditor5_utils_src_locale__WEBPACK_IMPORTED_MODULE_3__["default"]( {
			uiLanguage: typeof languageConfig === 'string' ? languageConfig : languageConfig.ui,
			contentLanguage: this.config.get( 'language.content' )
		} );

		/**
		 * Shorthand for {@link module:utils/locale~Locale#t}.
		 *
		 * @see module:utils/locale~Locale#t
		 * @method #t
		 */
		this.t = this.locale.t;

		/**
		 * A list of editors that this context instance is injected to.
		 *
		 * @readonly
		 * @type {module:utils/collection~Collection}
		 */
		this.editors = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_1__["default"]();

		/**
		 * Reference to the editor which created the context.
		 * Null when the context was created outside of the editor.
		 *
		 * It is used to destroy the context when removing the editor that has created the context.
		 *
		 * @private
		 * @type {module:core/editor/editor~Editor|null}
		 */
		this._contextOwner = null;
	}

	/**
	 * Loads and initializes plugins specified in the configuration.
	 *
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which resolves
	 * once the initialization is completed, providing an array of loaded plugins.
	 */
	initPlugins() {
		const plugins = this.config.get( 'plugins' ) || [];

		for ( const Plugin of plugins ) {
			if ( typeof Plugin != 'function' ) {
				/**
				 * Only a constructor function is allowed as a {@link module:core/contextplugin~ContextPlugin context plugin}.
				 *
				 * @error context-initplugins-constructor-only
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"](
					'context-initplugins-constructor-only: Only a constructor function is allowed as a context plugin.',
					null,
					{ Plugin }
				);
			}

			if ( Plugin.isContextPlugin !== true ) {
				/**
				 * Only a plugin marked as a {@link module:core/contextplugin~ContextPlugin.isContextPlugin context plugin}
				 * is allowed to be used with a context.
				 *
				 * @error context-initplugins-invalid-plugin
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"](
					'context-initplugins-invalid-plugin: Only a plugin marked as a context plugin is allowed to be used with a context.',
					null,
					{ Plugin }
				);
			}
		}

		return this.plugins.init( plugins );
	}

	/**
	 * Destroys the context instance and all editors used with the context,
	 * releasing all resources used by the context.
	 *
	 * @returns {Promise} A promise that resolves once the context instance is fully destroyed.
	 */
	destroy() {
		return Promise.all( Array.from( this.editors, editor => editor.destroy() ) )
			.then( () => this.plugins.destroy() );
	}

	/**
	 * Adds a reference to the editor which is used with this context.
	 *
	 * When the given editor has created the context, the reference to this editor will be stored
	 * as a {@link ~Context#_contextOwner}.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @param {module:core/editor/editor~Editor} editor
	 * @param {Boolean} isContextOwner Stores the given editor as a context owner.
	 */
	_addEditor( editor, isContextOwner ) {
		if ( this._contextOwner ) {
			/**
			 * Cannot add multiple editors to the context which is created by the editor.
			 *
			 * @error context-addEditor-private-context
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"](
				'context-addEditor-private-context: Cannot add multiple editors to the context which is created by the editor.'
			);
		}

		this.editors.add( editor );

		if ( isContextOwner ) {
			this._contextOwner = editor;
		}
	}

	/**
	 * Removes a reference to the editor which was used with this context.
	 * When the context was created by the given editor, the context will be destroyed.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @param {module:core/editor/editor~Editor} editor
	 * @return {Promise} A promise that resolves once the editor is removed from the context or when the context was destroyed.
	 */
	_removeEditor( editor ) {
		if ( this.editors.has( editor ) ) {
			this.editors.remove( editor );
		}

		if ( this._contextOwner === editor ) {
			return this.destroy();
		}

		return Promise.resolve();
	}

	/**
	 * Returns the context configuration which will be copied to the editors created using this context.
	 *
	 * The configuration returned by this method has the plugins configuration removed &mdash; plugins are shared with all editors
	 * through another mechanism.
	 *
	 * This method should only be used by the editor.
	 *
	 * @protected
	 * @returns {Object} Configuration as a plain object.
	 */
	_getEditorConfig() {
		const result = {};

		for ( const name of this.config.names() ) {
			if ( ![ 'plugins', 'removePlugins', 'extraPlugins' ].includes( name ) ) {
				result[ name ] = this.config.get( name );
			}
		}

		return result;
	}

	/**
	 * Creates and initializes a new context instance.
	 *
	 *		const commonConfig = { ... }; // Configuration for all the plugins and editors.
	 *		const editorPlugins = [ ... ]; // Regular plugins here.
	 *
	 *		Context
	 *			.create( {
	 *				// Only context plugins here.
	 *				plugins: [ ... ],
	 *
	 *				// Configure the language for all the editors (it cannot be overwritten).
	 *				language: { ... },
	 *
	 *				// Configuration for context plugins.
	 *				comments: { ... },
	 *				...
	 *
	 *				// Default configuration for editor plugins.
	 *				toolbar: { ... },
	 *				image: { ... },
	 *				...
	 *			} )
	 *			.then( context => {
	 *				const promises = [];
	 *
	 *				promises.push( ClassicEditor.create(
	 *					document.getElementById( 'editor1' ),
	 *					{
	 *						editorPlugins,
	 *						context
	 *					}
	 *				) );
	 *
	 *				promises.push( ClassicEditor.create(
	 *					document.getElementById( 'editor2' ),
	 *					{
	 *						editorPlugins,
	 *						context,
	 *						toolbar: { ... } // You can overwrite the configuration of the context.
	 *					}
	 *				) );
	 *
	 *				return Promise.all( promises );
	 *			} );
	 *
	 * @param {Object} [config] The context configuration.
	 * @returns {Promise} A promise resolved once the context is ready. The promise resolves with the created context instance.
	 */
	static create( config ) {
		return new Promise( resolve => {
			const context = new this( config );

			resolve( context.initPlugins().then( () => context ) );
		} );
	}
}

/**
 * An array of plugins built into the `Context` class.
 *
 * It is used in CKEditor 5 builds featuring `Context` to provide a list of context plugins which are later automatically initialized
 * during the context initialization.
 *
 * They will be automatically initialized by `Context` unless `config.plugins` is passed.
 *
 *		// Build some context plugins into the Context class first.
 *		Context.builtinPlugins = [ FooPlugin, BarPlugin ];
 *
 *		// Normally, you need to define config.plugins, but since Context.builtinPlugins was
 *		// defined, now you can call create() without any configuration.
 *		Context
 *			.create()
 *			.then( context => {
 *				context.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				context.plugins.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 * See also {@link module:core/context~Context.defaultConfig `Context.defaultConfig`}
 * and {@link module:core/editor/editor~Editor.builtinPlugins `Editor.builtinPlugins`}.
 *
 * @static
 * @member {Array.<Function>} module:core/context~Context.builtinPlugins
 */

/**
 * The default configuration which is built into the `Context` class.
 *
 * It is used in CKEditor 5 builds featuring `Context` to provide the default configuration options which are later used during the
 * context initialization.
 *
 *		Context.defaultConfig = {
 *			foo: 1,
 *			bar: 2
 *		};
 *
 *		Context
 *			.create()
 *			.then( context => {
 *				context.config.get( 'foo' ); // -> 1
 *				context.config.get( 'bar' ); // -> 2
 *			} );
 *
 *		// The default options can be overridden by the configuration passed to create().
 *		Context
 *			.create( { bar: 3 } )
 *			.then( context => {
 *				context.config.get( 'foo' ); // -> 1
 *				context.config.get( 'bar' ); // -> 3
 *			} );
 *
 * See also {@link module:core/context~Context.builtinPlugins `Context.builtinPlugins`}
 * and {@link module:core/editor/editor~Editor.defaultConfig `Editor.defaultConfig`}.
 *
 * @static
 * @member {Object} module:core/context~Context.defaultConfig
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ContextPlugin; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/contextplugin
 */




/**
 * The base class for {@link module:core/context~Context} plugin classes.
 *
 * A context plugin can either be initialized for an {@link module:core/editor/editor~Editor editor} or for
 * a {@link module:core/context~Context context}. In other words, it can either
 * work within one editor instance or with one or more editor instances that use a single context.
 * It is the context plugin's role to implement handling for both modes.
 *
 * There are a few rules for interaction between the editor plugins and context plugins:
 *
 * * A context plugin can require another context plugin.
 * * An {@link module:core/plugin~Plugin editor plugin} can require a context plugin.
 * * A context plugin MUST NOT require an {@link module:core/plugin~Plugin editor plugin}.
 *
 * @implements module:core/plugin~PluginInterface
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class ContextPlugin {
	/**
	 * Creates a new plugin instance.
	 *
	 * @param {module:core/context~Context|module:core/editor/editor~Editor} context
	 */
	constructor( context ) {
		/**
		 * The context instance.
		 *
		 * @readonly
		 * @type {module:core/context~Context|module:core/editor/editor~Editor}
		 */
		this.context = context;
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * @inheritDoc
	 */
	static get isContextPlugin() {
		return true;
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( ContextPlugin, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EditingKeystrokeHandler; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_keystrokehandler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/keystrokehandler */ "./node_modules/@ckeditor/ckeditor5-utils/src/keystrokehandler.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editingkeystrokehandler
 */



/**
 * A keystroke handler for editor editing. Its instance is available
 * in {@link module:core/editor/editor~Editor#keystrokes} so plugins
 * can register their keystrokes.
 *
 * E.g. an undo plugin would do this:
 *
 *		editor.keystrokes.set( 'Ctrl+Z', 'undo' );
 *		editor.keystrokes.set( 'Ctrl+Shift+Z', 'redo' );
 *		editor.keystrokes.set( 'Ctrl+Y', 'redo' );
 *
 * @extends module:utils/keystrokehandler~KeystrokeHandler
 */
class EditingKeystrokeHandler extends _ckeditor_ckeditor5_utils_src_keystrokehandler__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the keystroke handler.
	 *
	 * @param {module:core/editor/editor~Editor} editor
	 */
	constructor( editor ) {
		super();

		/**
		 * The editor instance.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor}
		 */
		this.editor = editor;
	}

	/**
	 * Registers a handler for the specified keystroke.
	 *
	 * The handler can be specified as a command name or a callback.
	 *
	 * @param {String|Array.<String|Number>} keystroke Keystroke defined in a format accepted by
	 * the {@link module:utils/keyboard~parseKeystroke} function.
	 * @param {Function|String} callback If a string is passed, then the keystroke will
	 * {@link module:core/editor/editor~Editor#execute execute a command}.
	 * If a function, then it will be called with the
	 * {@link module:engine/view/observer/keyobserver~KeyEventData key event data} object and
	 * a `cancel()` helper to both `preventDefault()` and `stopPropagation()` of the event.
	 * @param {Object} [options={}] Additional options.
	 * @param {module:utils/priorities~PriorityString|Number} [options.priority='normal'] The priority of the keystroke
	 * callback. The higher the priority value the sooner the callback will be executed. Keystrokes having the same priority
	 * are called in the order they were added.
	 */
	set( keystroke, callback, options = {} ) {
		if ( typeof callback == 'string' ) {
			const commandName = callback;

			callback = ( evtData, cancel ) => {
				this.editor.execute( commandName );
				cancel();
			};
		}

		super.set( keystroke, callback, options );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Editor; });
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../context */ "./node_modules/@ckeditor/ckeditor5-core/src/context.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/config */ "./node_modules/@ckeditor/ckeditor5-utils/src/config.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_controller_editingcontroller__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/controller/editingcontroller */ "./node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js");
/* harmony import */ var _plugincollection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../plugincollection */ "./node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js");
/* harmony import */ var _commandcollection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../commandcollection */ "./node_modules/@ckeditor/ckeditor5-core/src/commandcollection.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_controller_datacontroller__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/controller/datacontroller */ "./node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_conversion_conversion__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/conversion/conversion */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_model_model__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/model/model */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/model.js");
/* harmony import */ var _editingkeystrokehandler__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../editingkeystrokehandler */ "./node_modules/@ckeditor/ckeditor5-core/src/editingkeystrokehandler.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_stylesmap__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/stylesmap */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/stylesmap.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/editor
 */
















/**
 * The class representing a basic, generic editor.
 *
 * Check out the list of its subclasses to learn about specific editor implementations.
 *
 * All editor implementations (like {@link module:editor-classic/classiceditor~ClassicEditor} or
 * {@link module:editor-inline/inlineeditor~InlineEditor}) should extend this class. They can add their
 * own methods and properties.
 *
 * When you are implementing a plugin, this editor represents the API
 * which your plugin can expect to get when using its {@link module:core/plugin~Plugin#editor} property.
 *
 * This API should be sufficient in order to implement the "editing" part of your feature
 * (schema definition, conversion, commands, keystrokes, etc.).
 * It does not define the editor UI, which is available only if
 * the specific editor implements also the {@link module:core/editor/editorwithui~EditorWithUI} interface
 * (as most editor implementations do).
 *
 * @abstract
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Editor {
	/**
	 * Creates a new instance of the editor class.
	 *
	 * Usually, not to be used directly. See the static {@link module:core/editor/editor~Editor.create `create()`} method.
	 *
	 * @param {Object} [config={}] The editor configuration.
	 */
	constructor( config = {} ) {
		/**
		 * The editor context.
		 * When it is not provided through the configuration, the editor creates it.
		 *
		 * @protected
		 * @type {module:core/context~Context}
		 */
		this._context = config.context || new _context__WEBPACK_IMPORTED_MODULE_0__["default"]( { language: config.language } );
		this._context._addEditor( this, !config.context );

		// Clone the plugins to make sure that the plugin array will not be shared
		// between editors and make the watchdog feature work correctly.
		const availablePlugins = Array.from( this.constructor.builtinPlugins || [] );

		/**
		 * Stores all configurations specific to this editor instance.
		 *
		 *		editor.config.get( 'image.toolbar' );
		 *		// -> [ 'imageStyle:full', 'imageStyle:side', '|', 'imageTextAlternative' ]
		 *
		 * @readonly
		 * @member {module:utils/config~Config}
		 */
		this.config = new _ckeditor_ckeditor5_utils_src_config__WEBPACK_IMPORTED_MODULE_1__["default"]( config, this.constructor.defaultConfig );
		this.config.define( 'plugins', availablePlugins );
		this.config.define( this._context._getEditorConfig() );

		/**
		 * The plugins loaded and in use by this editor instance.
		 *
		 *		editor.plugins.get( 'Clipboard' ); // -> An instance of the clipboard plugin.
		 *
		 * @readonly
		 * @member {module:core/plugincollection~PluginCollection}
		 */
		this.plugins = new _plugincollection__WEBPACK_IMPORTED_MODULE_3__["default"]( this, availablePlugins, this._context.plugins );

		/**
		 * The locale instance.
		 *
		 * @readonly
		 * @type {module:utils/locale~Locale}
		 */
		this.locale = this._context.locale;

		/**
		 * Shorthand for {@link module:utils/locale~Locale#t}.
		 *
		 * @see module:utils/locale~Locale#t
		 * @method #t
		 */
		this.t = this.locale.t;

		/**
		 * Commands registered to the editor.
		 *
		 * Use the shorthand {@link #execute `editor.execute()`} method to execute commands:
		 *
		 *		// Execute the bold command:
		 *		editor.execute( 'bold' );
		 *
		 *		// Check the state of the bold command:
		 *		editor.commands.get( 'bold' ).value;
		 *
		 * @readonly
		 * @member {module:core/commandcollection~CommandCollection}
		 */
		this.commands = new _commandcollection__WEBPACK_IMPORTED_MODULE_4__["default"]();

		/**
		 * Indicates the editor life-cycle state.
		 *
		 * The editor is in one of the following states:
		 *
		 * * `initializing` &ndash; During the editor initialization (before
		 * {@link module:core/editor/editor~Editor.create `Editor.create()`}) finished its job.
		 * * `ready` &ndash; After the promise returned by the {@link module:core/editor/editor~Editor.create `Editor.create()`}
		 * method is resolved.
		 * * `destroyed` &ndash; Once the {@link #destroy `editor.destroy()`} method was called.
		 *
		 * @observable
		 * @member {'initializing'|'ready'|'destroyed'} #state
		 */
		this.set( 'state', 'initializing' );
		this.once( 'ready', () => ( this.state = 'ready' ), { priority: 'high' } );
		this.once( 'destroy', () => ( this.state = 'destroyed' ), { priority: 'high' } );

		/**
		 * Defines whether this editor is in read-only mode.
		 *
		 * In read-only mode the editor {@link #commands commands} are disabled so it is not possible
		 * to modify the document by using them. Also, the editable element(s) become non-editable.
		 *
		 * In order to make the editor read-only, you can set this value directly:
		 *
		 *		editor.isReadOnly = true;
		 *
		 * @observable
		 * @member {Boolean} #isReadOnly
		 */
		this.set( 'isReadOnly', false );

		/**
		 * The editor's model.
		 *
		 * The central point of the editor's abstract data model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = new _ckeditor_ckeditor5_engine_src_model_model__WEBPACK_IMPORTED_MODULE_7__["default"]();

		const stylesProcessor = new _ckeditor_ckeditor5_engine_src_view_stylesmap__WEBPACK_IMPORTED_MODULE_12__["StylesProcessor"]();

		/**
		 * The {@link module:engine/controller/datacontroller~DataController data controller}.
		 * Used e.g. for setting and retrieving the editor data.
		 *
		 * @readonly
		 * @member {module:engine/controller/datacontroller~DataController}
		 */
		this.data = new _ckeditor_ckeditor5_engine_src_controller_datacontroller__WEBPACK_IMPORTED_MODULE_5__["default"]( this.model, stylesProcessor );

		/**
		 * The {@link module:engine/controller/editingcontroller~EditingController editing controller}.
		 * Controls user input and rendering the content for editing.
		 *
		 * @readonly
		 * @member {module:engine/controller/editingcontroller~EditingController}
		 */
		this.editing = new _ckeditor_ckeditor5_engine_src_controller_editingcontroller__WEBPACK_IMPORTED_MODULE_2__["default"]( this.model, stylesProcessor );
		this.editing.view.document.bind( 'isReadOnly' ).to( this );

		/**
		 * Conversion manager through which you can register model-to-view and view-to-model converters.
		 *
		 * See the {@link module:engine/conversion/conversion~Conversion} documentation to learn how to add converters.
		 *
		 * @readonly
		 * @member {module:engine/conversion/conversion~Conversion}
		 */
		this.conversion = new _ckeditor_ckeditor5_engine_src_conversion_conversion__WEBPACK_IMPORTED_MODULE_6__["default"]( [ this.editing.downcastDispatcher, this.data.downcastDispatcher ], this.data.upcastDispatcher );
		this.conversion.addAlias( 'dataDowncast', this.data.downcastDispatcher );
		this.conversion.addAlias( 'editingDowncast', this.editing.downcastDispatcher );

		/**
		 * An instance of the {@link module:core/editingkeystrokehandler~EditingKeystrokeHandler}.
		 *
		 * It allows setting simple keystrokes:
		 *
		 *		// Execute the bold command on Ctrl+E:
		 *		editor.keystrokes.set( 'Ctrl+E', 'bold' );
		 *
		 *		// Execute your own callback:
		 *		editor.keystrokes.set( 'Ctrl+E', ( data, cancel ) => {
		 *			console.log( data.keyCode );
		 *
		 *			// Prevent the default (native) action and stop the underlying keydown event
		 *			// so no other editor feature will interfere.
		 *			cancel();
		 *		} );
		 *
		 * Note: Certain typing-oriented keystrokes (like <kbd>Backspace</kbd> or <kbd>Enter</kbd>) are handled
		 * by a low-level mechanism and trying to listen to them via the keystroke handler will not work reliably.
		 * To handle these specific keystrokes, see the events fired by the
		 * {@link module:engine/view/document~Document editing view document} (`editor.editing.view.document`).
		 *
		 * @readonly
		 * @member {module:core/editingkeystrokehandler~EditingKeystrokeHandler}
		 */
		this.keystrokes = new _editingkeystrokehandler__WEBPACK_IMPORTED_MODULE_8__["default"]( this );
		this.keystrokes.listenTo( this.editing.view.document );
	}

	/**
	 * Loads and initializes plugins specified in the configuration.
	 *
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which resolves
	 * once the initialization is completed, providing an array of loaded plugins.
	 */
	initPlugins() {
		const config = this.config;
		const plugins = config.get( 'plugins' );
		const removePlugins = config.get( 'removePlugins' ) || [];
		const extraPlugins = config.get( 'extraPlugins' ) || [];

		return this.plugins.init( plugins.concat( extraPlugins ), removePlugins );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * **Note** The editor cannot be destroyed during the initialization phase so if it is called
	 * while the editor {@link #state is being initialized}, it will wait for the editor initialization before destroying it.
	 *
	 * @fires destroy
	 * @returns {Promise} A promise that resolves once the editor instance is fully destroyed.
	 */
	destroy() {
		let readyPromise = Promise.resolve();

		if ( this.state == 'initializing' ) {
			readyPromise = new Promise( resolve => this.once( 'ready', resolve ) );
		}

		return readyPromise
			.then( () => {
				this.fire( 'destroy' );
				this.stopListening();
				this.commands.destroy();
			} )
			.then( () => this.plugins.destroy() )
			.then( () => {
				this.model.destroy();
				this.data.destroy();
				this.editing.destroy();
				this.keystrokes.destroy();
			} )
			// Remove the editor from the context.
			// When the context was created by this editor, the context will be destroyed.
			.then( () => this._context._removeEditor( this ) );
	}

	/**
	 * Executes the specified command with given parameters.
	 *
	 * Shorthand for:
	 *
	 *		editor.commands.get( commandName ).execute( ... );
	 *
	 * @param {String} commandName The name of the command to execute.
	 * @param {*} [...commandParams] Command parameters.
	 * @returns {*} The value returned by the {@link module:core/commandcollection~CommandCollection#execute `commands.execute()`}.
	 */
	execute( ...args ) {
		try {
			return this.commands.execute( ...args );
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * Creates and initializes a new editor instance.
	 *
	 * This is an abstract method. Every editor type needs to implement its own initialization logic.
	 *
	 * See the `create()` methods of the existing editor types to learn how to use them:
	 *
	 * * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`}
	 * * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`}
	 * * {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`}
	 * * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`}
	 *
	 * @abstract
	 * @method module:core/editor/editor~Editor.create
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__["default"])( Editor, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_9__["default"] );

/**
 * Fired when the {@link module:engine/controller/datacontroller~DataController#event:ready data} and all additional
 * editor components are ready.
 *
 * Note: This event is most useful for plugin developers. When integrating the editor with your website or
 * application, you do not have to listen to `editor#ready` because when the promise returned by the static
 * {@link module:core/editor/editor~Editor.create `Editor.create()`} event is resolved, the editor is already ready.
 * In fact, since the first moment when the editor instance is available to you is inside `then()`'s callback,
 * you cannot even add a listener to the `editor#ready` event.
 *
 * See also the {@link #state `editor.state`} property.
 *
 * @event ready
 */

/**
 * Fired when this editor instance is destroyed. The editor at this point is not usable and this event should be used to
 * perform the clean-up in any plugin.
 *
 *
 * See also the {@link #state `editor.state`} property.
 *
 * @event destroy
 */

/**
 * This error is thrown when trying to pass a `<textarea>` element to a `create()` function of an editor class.
 *
 * The only editor type which can be initialized on `<textarea>` elements is {@glink builds/guides/overview#classic-editor classic editor}.
 * This editor hides the passed element and inserts its own UI next to it. Other types of editors reuse the passed element as their root
 * editable element and therefore `<textarea>` is not appropriate for them. Use a `<div>` or another text container instead:
 *
 *		<div id="editor">
 *			<p>Initial content.</p>
 *		</div>
 *
 * @error editor-wrong-element
 */

/**
 * An array of plugins built into this editor class.
 *
 * It is used in CKEditor 5 builds to provide a list of plugins which are later automatically initialized
 * during the editor initialization.
 *
 * They will be automatically initialized by the editor, unless listed in `config.removePlugins` and
 * unless `config.plugins` is passed.
 *
 *		// Build some plugins into the editor class first.
 *		ClassicEditor.builtinPlugins = [ FooPlugin, BarPlugin ];
 *
 *		// Normally, you need to define config.plugins, but since ClassicEditor.builtinPlugins was
 *		// defined, now you can call create() without any configuration.
 *		ClassicEditor
 *			.create( sourceElement )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				editor.plugins.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 *		ClassicEditor
 *			.create( sourceElement, {
 *				// Do not initialize these plugins (note: it is defined by a string):
 *				removePlugins: [ 'Foo' ]
 *			} )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> Undefined.
 *				editor.config.get( BarPlugin ); // -> An instance of the Bar plugin.
 *			} );
 *
 *		ClassicEditor
 *			.create( sourceElement, {
 *				// Load only this plugin. It can also be defined by a string if
 *				// this plugin was built into the editor class.
 *				plugins: [ FooPlugin ]
 *			} )
 *			.then( editor => {
 *				editor.plugins.get( FooPlugin ); // -> An instance of the Foo plugin.
 *				editor.config.get( BarPlugin ); // -> Undefined.
 *			} );
 *
 * See also {@link module:core/editor/editor~Editor.defaultConfig}.
 *
 * @static
 * @member {Array.<Function>} module:core/editor/editor~Editor.builtinPlugins
 */

/**
 * The default configuration which is built into the editor class.
 *
 * It is used in CKEditor 5 builds to provide the default configuration options which are later used during the editor initialization.
 *
 *		ClassicEditor.defaultConfig = {
 *			foo: 1,
 *			bar: 2
 *		};
 *
 *		ClassicEditor
 *			.create( sourceElement )
 *			.then( editor => {
 *				editor.config.get( 'foo' ); // -> 1
 *				editor.config.get( 'bar' ); // -> 2
 *			} );
 *
 *		// The default options can be overridden by the configuration passed to create().
 *		ClassicEditor
 *			.create( sourceElement, { bar: 3 } )
 *			.then( editor => {
 *				editor.config.get( 'foo' ); // -> 1
 *				editor.config.get( 'bar' ); // -> 3
 *			} );
 *
 * See also {@link module:core/editor/editor~Editor.builtinPlugins}.
 *
 * @static
 * @member {Object} module:core/editor/editor~Editor.defaultConfig
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EditorUI; });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_componentfactory__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/componentfactory */ "./node_modules/@ckeditor/ckeditor5-ui/src/componentfactory.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_focustracker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/focustracker */ "./node_modules/@ckeditor/ckeditor5-utils/src/focustracker.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/editorui
 */

/* globals console */







/**
 * A class providing the minimal interface that is required to successfully bootstrap any editor UI.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class EditorUI {
	/**
	 * Creates an instance of the editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 */
	constructor( editor ) {
		/**
		 * The editor that the UI belongs to.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor} #editor
		 */
		this.editor = editor;

		/**
		 * An instance of the {@link module:ui/componentfactory~ComponentFactory}, a registry used by plugins
		 * to register factories of specific UI components.
		 *
		 * @readonly
		 * @member {module:ui/componentfactory~ComponentFactory} #componentFactory
		 */
		this.componentFactory = new _ckeditor_ckeditor5_ui_src_componentfactory__WEBPACK_IMPORTED_MODULE_0__["default"]( editor );

		/**
		 * Stores the information about the editor UI focus and propagates it so various plugins and components
		 * are unified as a focus group.
		 *
		 * @readonly
		 * @member {module:utils/focustracker~FocusTracker} #focusTracker
		 */
		this.focusTracker = new _ckeditor_ckeditor5_utils_src_focustracker__WEBPACK_IMPORTED_MODULE_1__["default"]();

		/**
		 * Stores all editable elements used by the editor instance.
		 *
		 * @private
		 * @member {Map.<String,HTMLElement>}
		 */
		this._editableElementsMap = new Map();

		// Informs UI components that should be refreshed after layout change.
		this.listenTo( editor.editing.view.document, 'layoutChanged', () => this.update() );
	}

	/**
	 * The main (outermost) DOM element of the editor UI.
	 *
	 * For example, in {@link module:editor-classic/classiceditor~ClassicEditor} it is a `<div>` which
	 * wraps the editable element and the toolbar. In {@link module:editor-inline/inlineeditor~InlineEditor}
	 * it is the editable element itself (as there is no other wrapper). However, in
	 * {@link module:editor-decoupled/decouplededitor~DecoupledEditor} it is set to `null` because this editor does not
	 * come with a single "main" HTML element (its editable element and toolbar are separate).
	 *
	 * This property can be understood as a shorthand for retrieving the element that a specific editor integration
	 * considers to be its main DOM element.
	 *
	 * @readonly
	 * @member {HTMLElement|null} #element
	 */
	get element() {
		return null;
	}

	/**
	 * Fires the {@link module:core/editor/editorui~EditorUI#event:update `update`} event.
	 *
	 * This method should be called when the editor UI (e.g. positions of its balloons) needs to be updated due to
	 * some environmental change which CKEditor 5 is not aware of (e.g. resize of a container in which it is used).
	 */
	update() {
		this.fire( 'update' );
	}

	/**
	 * Destroys the UI.
	 */
	destroy() {
		this.stopListening();

		this.focusTracker.destroy();

		// Clean–up the references to the CKEditor instance stored in the native editable DOM elements.
		for ( const domElement of this._editableElementsMap.values() ) {
			domElement.ckeditorInstance = null;
		}

		this._editableElementsMap = new Map();
	}

	/**
	 * Store the native DOM editable element used by the editor under
	 * a unique name.
	 *
	 * @param {String} rootName The unique name of the editable element.
	 * @param {HTMLElement} domElement The native DOM editable element.
	 */
	setEditableElement( rootName, domElement ) {
		this._editableElementsMap.set( rootName, domElement );

		// Put a reference to the CKEditor instance in the editable native DOM element.
		// It helps 3rd–party software (browser extensions, other libraries) access and recognize
		// CKEditor 5 instances (editing roots) and use their API (there is no global editor
		// instance registry).
		if ( !domElement.ckeditorInstance ) {
			domElement.ckeditorInstance = this.editor;
		}
	}

	/**
	 * Returns the editable editor element with the given name or null if editable does not exist.
	 *
	 * @param {String} [rootName=main] The editable name.
	 * @returns {HTMLElement|undefined}
	 */
	getEditableElement( rootName = 'main' ) {
		return this._editableElementsMap.get( rootName );
	}

	/**
	 * Returns array of names of all editor editable elements.
	 *
	 * @returns {Iterable.<String>}
	 */
	getEditableElementsNames() {
		return this._editableElementsMap.keys();
	}

	/**
	 * Stores all editable elements used by the editor instance.
	 *
	 * @protected
	 * @deprecated
	 * @member {Map.<String,HTMLElement>}
	 */
	get _editableElements() {
		/**
		 * The {@link module:core/editor/editorui~EditorUI#_editableElements `EditorUI#_editableElements`} property has been
		 * deprecated and will be removed in the near future. Please use {@link #setEditableElement `setEditableElement()`} and
		 * {@link #getEditableElement `getEditableElement()`} methods instead.
		 *
		 * @error editor-ui-deprecated-editable-elements
		 * @param {module:core/editor/editorui~EditorUI} editorUI Editor UI instance the deprecated property belongs to.
		 */
		console.warn(
			'editor-ui-deprecated-editable-elements: ' +
			'The EditorUI#_editableElements property has been deprecated and will be removed in the near future.',
			{ editorUI: this } );

		return this._editableElementsMap;
	}

	/**
	 * Fired when the editor UI is ready.
	 *
	 * Fired before {@link module:engine/controller/datacontroller~DataController#event:ready}.
	 *
	 * @event ready
	 */

	/**
	 * Fired whenever the UI (all related components) should be refreshed.
	 *
	 * **Note:**: The event is fired after each {@link module:engine/view/document~Document#event:layoutChanged}.
	 * It can also be fired manually via the {@link module:core/editor/editorui~EditorUI#update} method.
	 *
	 * @event update
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( EditorUI, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_2__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return attachToForm; });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */




/**
 * @module core/editor/utils/attachtoform
 */

/**
 * Checks if the editor is initialized on a `<textarea>` element that belongs to a form. If yes, it updates the editor's element
 * content before submitting the form.
 *
 * This helper requires the {@link module:core/editor/utils/elementapimixin~ElementApi ElementApi interface}.
 *
 * @param {module:core/editor/editor~Editor} editor Editor instance.
 */
function attachToForm( editor ) {
	if ( !Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isFunction"])( editor.updateSourceElement ) ) {
		/**
		 * The editor passed to `attachToForm()` must implement the
		 * {@link module:core/editor/utils/elementapimixin~ElementApi} interface.
		 *
		 * @error attachtoform-missing-elementapi-interface
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
			'attachtoform-missing-elementapi-interface: Editor passed to attachToForm() must implement ElementApi.',
			editor
		);
	}

	const sourceElement = editor.sourceElement;

	// Only when replacing a textarea which is inside of a form element.
	if ( sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.form ) {
		let originalSubmit;
		const form = sourceElement.form;
		const onSubmit = () => editor.updateSourceElement();

		// Replace the original form#submit() to call a custom submit function first.
		// Check if #submit is a function because the form might have an input named "submit".
		if ( Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isFunction"])( form.submit ) ) {
			originalSubmit = form.submit;

			form.submit = () => {
				onSubmit();
				originalSubmit.apply( form );
			};
		}

		// Update the replaced textarea with data before each form#submit event.
		form.addEventListener( 'submit', onSubmit );

		// Remove the submit listener and revert the original submit method on
		// editor#destroy.
		editor.on( 'destroy', () => {
			form.removeEventListener( 'submit', onSubmit );

			if ( originalSubmit ) {
				form.submit = originalSubmit;
			}
		} );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/editor/utils/dataapimixin
 */

/**
 * Implementation of the {@link module:core/editor/utils/dataapimixin~DataApi}.
 *
 * @mixin DataApiMixin
 * @implements module:core/editor/utils/dataapimixin~DataApi
 */
const DataApiMixin = {
	/**
	 * @inheritDoc
	 */
	setData( data ) {
		this.data.set( data );
	},

	/**
	 * @inheritDoc
	 */
	getData( options ) {
		return this.data.get( options );
	}
};

/* harmony default export */ __webpack_exports__["default"] = (DataApiMixin);

/**
 * Interface defining editor methods for setting and getting data to and from the editor's main root element
 * using the {@link module:core/editor/editor~Editor#data data pipeline}.
 *
 * This interface is not a part of the {@link module:core/editor/editor~Editor} class because one may want to implement
 * an editor with multiple root elements, in which case the methods for setting and getting data will need to be implemented
 * differently.
 *
 * @interface DataApi
 */

/**
 * Sets the data in the editor.
 *
 *		editor.setData( '<p>This is editor!</p>' );
 *
 * By default the editor accepts HTML. This can be controlled by injecting a different data processor.
 * See the {@glink features/markdown Markdown output} guide for more details.
 *
 * Note: Not only is the format of the data configurable, but the type of the `setData()`'s parameter does not
 * have to be a string either. You can e.g. accept an object or a DOM `DocumentFragment` if you consider this
 * the right format for you.
 *
 * @method #setData
 * @param {String} data Input data.
 */

/**
 * Gets the data from the editor.
 *
 *		editor.getData(); // -> '<p>This is editor!</p>'
 *
 * By default the editor outputs HTML. This can be controlled by injecting a different data processor.
 * See the {@glink features/markdown Markdown output} guide for more details.
 *
 * Note: Not only is the format of the data configurable, but the type of the `getData()`'s return value does not
 * have to be a string either. You can e.g. return an object or a DOM `DocumentFragment` if you consider this
 * the right format for you.
 *
 * @method #getData
 * @param {Object} [options]
 * @param {String} [options.rootName='main'] Root name.
 * @param {String} [options.trim='empty'] Whether returned data should be trimmed. This option is set to `'empty'` by default,
 * which means that whenever editor content is considered empty, an empty string is returned. To turn off trimming
 * use `'none'`. In such cases exact content will be returned (for example `'<p>&nbsp;</p>'` for an empty editor).
 * @returns {String} Output data.
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/setdatainelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/setdatainelement.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */




/**
 * @module core/editor/utils/elementapimixin
 */

/**
 * Implementation of the {@link module:core/editor/utils/elementapimixin~ElementApi}.
 *
 * @mixin ElementApiMixin
 * @implements module:core/editor/utils/elementapimixin~ElementApi
 */
const ElementApiMixin = {
	/**
	 * @inheritDoc
	 */
	updateSourceElement() {
		if ( !this.sourceElement ) {
			/**
			 * Cannot update the source element of a detached editor.
			 *
			 * The {@link ~ElementApi#updateSourceElement `updateSourceElement()`} method cannot be called if you did not
			 * pass an element to `Editor.create()`.
			 *
			 * @error editor-missing-sourceelement
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'editor-missing-sourceelement: Cannot update the source element of a detached editor.',
				this
			);
		}

		Object(_ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_1__["default"])( this.sourceElement, this.data.get() );
	}
};

/* harmony default export */ __webpack_exports__["default"] = (ElementApiMixin);

/**
 * Interface describing an editor that replaced a DOM element (was "initialized on an element").
 *
 * Such an editor should provide a method to
 * {@link module:core/editor/utils/elementapimixin~ElementApi#updateSourceElement update the replaced element with the current data}.
 *
 * @interface ElementApi
 */

/**
 * The element on which the editor has been initialized.
 *
 * @readonly
 * @member {HTMLElement} #sourceElement
 */

/**
 * Updates the {@link #sourceElement editor source element}'s content with the data.
 *
 * @method #updateSourceElement
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return secureSourceElement; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */



/**
 * @module core/editor/utils/securesourceelement
 */

/**
 * Marks the source element on which the editor was initialized. This prevents other editor instances from using this element.
 *
 * Running multiple editor instances on the same source element causes various issues and it is
 * crucial this helper is called as soon as the source element is known to prevent collisions.
 *
 * @param {module:core/editor/editor~Editor} editor Editor instance.
 */
function secureSourceElement( editor ) {
	const sourceElement = editor.sourceElement;

	// If the editor was initialized without specifying an element, we don't need to secure anything.
	if ( !sourceElement ) {
		return;
	}

	if ( sourceElement.ckeditorInstance ) {
		/**
		 * A DOM element used to create the editor (e.g.
		 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`})
		 * has already been used to create another editor instance. Make sure each editor is
		 * created with an unique DOM element.
		 *
		 * @error editor-source-element-already-used
		 * @param {HTMLElement} element DOM element that caused the collision.
		 */
		throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
			'editor-source-element-already-used: ' +
			'The DOM element cannot be used to create multiple editor instances.',
			editor
		);
	}

	sourceElement.ckeditorInstance = editor;

	editor.once( 'destroy', () => {
		delete sourceElement.ckeditorInstance;
	} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/pendingactions.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/pendingactions.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return PendingActions; });
/* harmony import */ var _contextplugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./contextplugin */ "./node_modules/@ckeditor/ckeditor5-core/src/contextplugin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/pendingactions
 */






/**
 * The list of pending editor actions.
 *
 * This plugin should be used to synchronise plugins that execute long-lasting actions
 * (e.g. file upload) with the editor integration. It gives the developer who integrates the editor
 * an easy way to check if there are any actions pending whenever such information is needed.
 * All plugins that register a pending action also provide a message about the action that is ongoing
 * which can be displayed to the user. This lets them decide if they want to interrupt the action or wait.
 *
 * Adding and updating a pending action:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 * 		const action = pendingActions.add( 'Upload in progress: 0%.' );
 *
 *		// You can update the message:
 * 		action.message = 'Upload in progress: 10%.';
 *
 * Removing a pending action:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 * 		const action = pendingActions.add( 'Unsaved changes.' );
 *
 * 		pendingActions.remove( action );
 *
 * Getting pending actions:
 *
 * 		const pendingActions = editor.plugins.get( 'PendingActions' );
 *
 * 		const action1 = pendingActions.add( 'Action 1' );
 * 		const action2 = pendingActions.add( 'Action 2' );
 *
 * 		pendingActions.first; // Returns action1
 * 		Array.from( pendingActions ); // Returns [ action1, action2 ]
 *
 * This plugin is used by features like {@link module:upload/filerepository~FileRepository} to register their ongoing actions
 * and by features like {@link module:autosave/autosave~Autosave} to detect whether there are any ongoing actions.
 * Read more about saving the data in the {@glink builds/guides/integration/saving-data Saving and getting data} guide.
 *
 * @extends module:core/contextplugin~ContextPlugin
 */
class PendingActions extends _contextplugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'PendingActions';
	}

	/**
	 * @inheritDoc
	 */
	init() {
		/**
		 * Defines whether there is any registered pending action.
		 *
		 * @readonly
		 * @observable
		 * @member {Boolean} #hasAny
		 */
		this.set( 'hasAny', false );

		/**
		 * A list of pending actions.
		 *
		 * @private
		 * @type {module:utils/collection~Collection}
		 */
		this._actions = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_2__["default"]( { idProperty: '_id' } );
		this._actions.delegate( 'add', 'remove' ).to( this );
	}

	/**
	 * Adds an action to the list of pending actions.
	 *
	 * This method returns an action object with an observable message property.
	 * The action object can be later used in the {@link #remove} method. It also allows you to change the message.
	 *
	 * @param {String} message The action message.
	 * @returns {Object} An observable object that represents a pending action.
	 */
	add( message ) {
		if ( typeof message !== 'string' ) {
			/**
			 * The message must be a string.
			 *
			 * @error pendingactions-add-invalid-message
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"]( 'pendingactions-add-invalid-message: The message must be a string.', this );
		}

		const action = Object.create( _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

		action.set( 'message', message );
		this._actions.add( action );
		this.hasAny = true;

		return action;
	}

	/**
	 * Removes an action from the list of pending actions.
	 *
	 * @param {Object} action An action object.
	 */
	remove( action ) {
		this._actions.remove( action );
		this.hasAny = !!this._actions.length;
	}

	/**
	 * Returns the first action from the list or null when list is empty
	 *
	 * returns {Object|null} The pending action object.
	 */
	get first() {
		return this._actions.get( 0 );
	}

	/**
	 * Iterable interface.
	 *
	 * @returns {Iterable.<*>}
	 */
	[ Symbol.iterator ]() {
		return this._actions[ Symbol.iterator ]();
	}

	/**
	 * Fired when an action is added to the list.
	 *
	 * @event add
	 * @param {Object} action The added action.
	 */

	/**
	 * Fired when an action is removed from the list.
	 *
	 * @event remove
	 * @param {Object} action The removed action.
	 */
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js":
/*!*************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/plugin.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Plugin; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/plugin
 */




/**
 * The base class for CKEditor plugin classes.
 *
 * @implements module:core/plugin~PluginInterface
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Plugin {
	/**
	 * @inheritDoc
	 */
	constructor( editor ) {
		/**
		 * The editor instance.
		 *
		 * Note that most editors implement the {@link module:core/editor/editorwithui~EditorWithUI} interface in addition
		 * to the base {@link module:core/editor/editor~Editor} interface. However, editors with an external UI
		 * (i.e. Bootstrap-based) or a headless editor may not implement the {@link module:core/editor/editorwithui~EditorWithUI}
		 * interface.
		 *
		 * Because of above, to make plugins more universal, it is recommended to split features into:
		 *  - The "editing" part that only uses the {@link module:core/editor/editor~Editor} interface.
		 *  - The "UI" part that uses both the {@link module:core/editor/editor~Editor} interface and
		 *  the {@link module:core/editor/editorwithui~EditorWithUI} interface.
		 *
		 * @readonly
		 * @member {module:core/editor/editor~Editor} #editor
		 */
		this.editor = editor;

		/**
		 * Flag indicating whether a plugin is enabled or disabled.
		 * A disabled plugin will not transform text.
		 *
		 * Plugin can be simply disabled like that:
		 *
		 *		// Disable the plugin so that no toolbars are visible.
		 *		editor.plugins.get( 'TextTransformation' ).isEnabled = false;
		 *
		 * You can also use {@link #forceDisabled} method.
		 *
		 * @observable
		 * @readonly
		 * @member {Boolean} #isEnabled
		 */
		this.set( 'isEnabled', true );

		/**
		 * Holds identifiers for {@link #forceDisabled} mechanism.
		 *
		 * @type {Set.<String>}
		 * @private
		 */
		this._disableStack = new Set();
	}

	/**
	 * Disables the plugin.
	 *
	 * Plugin may be disabled by multiple features or algorithms (at once). When disabling a plugin, unique id should be passed
	 * (e.g. feature name). The same identifier should be used when {@link #clearForceDisabled enabling back} the plugin.
	 * The plugin becomes enabled only after all features {@link #clearForceDisabled enabled it back}.
	 *
	 * Disabling and enabling a plugin:
	 *
	 *		plugin.isEnabled; // -> true
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> false
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * Plugin disabled by multiple features:
	 *
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.forceDisabled( 'OtherFeature' );
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> false
	 *		plugin.clearForceDisabled( 'OtherFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * Multiple disabling with the same identifier is redundant:
	 *
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.forceDisabled( 'MyFeature' );
	 *		plugin.clearForceDisabled( 'MyFeature' );
	 *		plugin.isEnabled; // -> true
	 *
	 * **Note:** some plugins or algorithms may have more complex logic when it comes to enabling or disabling certain plugins,
	 * so the plugin might be still disabled after {@link #clearForceDisabled} was used.
	 *
	 * @param {String} id Unique identifier for disabling. Use the same id when {@link #clearForceDisabled enabling back} the plugin.
	 */
	forceDisabled( id ) {
		this._disableStack.add( id );

		if ( this._disableStack.size == 1 ) {
			this.on( 'set:isEnabled', forceDisable, { priority: 'highest' } );
			this.isEnabled = false;
		}
	}

	/**
	 * Clears forced disable previously set through {@link #forceDisabled}. See {@link #forceDisabled}.
	 *
	 * @param {String} id Unique identifier, equal to the one passed in {@link #forceDisabled} call.
	 */
	clearForceDisabled( id ) {
		this._disableStack.delete( id );

		if ( this._disableStack.size == 0 ) {
			this.off( 'set:isEnabled', forceDisable );
			this.isEnabled = true;
		}
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * @inheritDoc
	 */
	static get isContextPlugin() {
		return false;
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_1__["default"])( Plugin, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_0__["default"] );

/**
 * The base interface for CKEditor plugins.
 *
 * In its minimal form a plugin can be a simple function that accepts {@link module:core/editor/editor~Editor the editor}
 * as a parameter:
 *
 *		// A simple plugin that enables a data processor.
 *		function MyPlugin( editor ) {
 *			editor.data.processor = new MyDataProcessor();
 *		}
 *
 * In most cases however, you will want to inherit from the {@link module:core/plugin~Plugin} class which implements the
 * {@link module:utils/observablemixin~ObservableMixin} and is, therefore, more convenient:
 *
 *		class MyPlugin extends Plugin {
 *			init() {
 *				// `listenTo()` and `editor` are available thanks to `Plugin`.
 *				// By using `listenTo()` you will ensure that the listener is removed when
 *				// the plugin is destroyed.
 *				this.listenTo( this.editor.data, 'ready', () => {
 *					// Do something when the data is ready.
 *				} );
 *			}
 *		}
 *
 * The plugin can also implement methods (e.g. {@link module:core/plugin~PluginInterface#init `init()`} or
 * {@link module:core/plugin~PluginInterface#destroy `destroy()`}) which, when present, will be used to properly
 * initialize and destroy the plugin.
 *
 * **Note:** When defined as a plain function, the plugin acts as a constructor and will be
 * called in parallel with other plugins' {@link module:core/plugin~PluginInterface#constructor constructors}.
 * This means the code of that plugin will be executed **before** {@link module:core/plugin~PluginInterface#init `init()`} and
 * {@link module:core/plugin~PluginInterface#afterInit `afterInit()`} methods of other plugins and, for instance,
 * you cannot use it to extend other plugins' {@glink framework/guides/architecture/editing-engine#schema schema}
 * rules as they are defined later on during the `init()` stage.
 *
 * @interface PluginInterface
 */

/**
 * Creates a new plugin instance. This is the first step of the plugin initialization.
 * See also {@link #init} and {@link #afterInit}.
 *
 * A plugin is always instantiated after its {@link module:core/plugin~PluginInterface.requires dependencies} and the
 * {@link #init} and {@link #afterInit} methods are called in the same order.
 *
 * Usually, you will want to put your plugin's initialization code in the {@link #init} method.
 * The constructor can be understood as "before init" and used in special cases, just like
 * {@link #afterInit} serves the special "after init" scenarios (e.g.the code which depends on other
 * plugins, but which does not {@link module:core/plugin~PluginInterface.requires explicitly require} them).
 *
 * @method #constructor
 * @param {module:core/editor/editor~Editor} editor
 */

/**
 * An array of plugins required by this plugin.
 *
 * To keep the plugin class definition tight it is recommended to define this property as a static getter:
 *
 *		import Image from './image.js';
 *
 *		export default class ImageCaption {
 *			static get requires() {
 *				return [ Image ];
 *			}
 *		}
 *
 * @static
 * @readonly
 * @member {Array.<Function>|undefined} module:core/plugin~PluginInterface.requires
 */

/**
 * An optional name of the plugin. If set, the plugin will be available in
 * {@link module:core/plugincollection~PluginCollection#get} by its
 * name and its constructor. If not, then only by its constructor.
 *
 * The name should reflect the constructor name.
 *
 * To keep the plugin class definition tight, it is recommended to define this property as a static getter:
 *
 *		export default class ImageCaption {
 *			static get pluginName() {
 *				return 'ImageCaption';
 *			}
 *		}
 *
 * Note: The native `Function.name` property could not be used to keep the plugin name because
 * it will be mangled during code minification.
 *
 * Naming a plugin is necessary to enable removing it through the
 * {@link module:core/editor/editorconfig~EditorConfig#removePlugins `config.removePlugins`} option.
 *
 * @static
 * @readonly
 * @member {String|undefined} module:core/plugin~PluginInterface.pluginName
 */

/**
 * The second stage (after plugin {@link #constructor}) of the plugin initialization.
 * Unlike the plugin constructor this method can be asynchronous.
 *
 * A plugin's `init()` method is called after its {@link module:core/plugin~PluginInterface.requires dependencies} are initialized,
 * so in the same order as the constructors of these plugins.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #init
 * @returns {null|Promise}
 */

/**
 * The third (and last) stage of the plugin initialization. See also {@link #constructor} and {@link #init}.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #afterInit
 * @returns {null|Promise}
 */

/**
 * Destroys the plugin.
 *
 * **Note:** This method is optional. A plugin instance does not need to have it defined.
 *
 * @method #destroy
 * @returns {null|Promise}
 */

/**
 * A flag which defines if a plugin is allowed or not allowed to be used directly by a {@link module:core/context~Context}.
 *
 * @static
 * @readonly
 * @member {Boolean} module:core/plugin~PluginInterface.isContextPlugin
 */

/**
 * An array of loaded plugins.
 *
 * @typedef {Array.<module:core/plugin~PluginInterface>} module:core/plugin~LoadedPlugins
 */

// Helper function that forces plugin to be disabled.
function forceDisable( evt ) {
	evt.return = false;
	evt.stop();
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/src/plugincollection.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return PluginCollection; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module core/plugincollection
 */

/* globals console */






/**
 * Manages a list of CKEditor plugins, including loading, resolving dependencies and initialization.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class PluginCollection {
	/**
	 * Creates an instance of the plugin collection class.
	 * Allows loading and initializing plugins and their dependencies.
	 * Allows to provide a list of already loaded plugins. These plugins will not be destroyed along with this collection.
	 *
	 * @param {module:core/editor/editor~Editor|module:core/context~Context} context
	 * @param {Array.<Function>} [availablePlugins] Plugins (constructors) which the collection will be able to use
	 * when {@link module:core/plugincollection~PluginCollection#init} is used with plugin names (strings, instead of constructors).
	 * Usually, the editor will pass its built-in plugins to the collection so they can later be
	 * used in `config.plugins` or `config.removePlugins` by names.
	 * @param {Iterable.<Array>} contextPlugins A list of already initialized plugins represented by a
	 * `[ PluginConstructor, pluginInstance ]` pair.
	 */
	constructor( context, availablePlugins = [], contextPlugins = [] ) {
		/**
		 * @protected
		 * @type {module:core/editor/editor~Editor|module:core/context~Context}
		 */
		this._context = context;

		/**
		 * @protected
		 * @type {Map}
		 */
		this._plugins = new Map();

		/**
		 * A map of plugin constructors that can be retrieved by their names.
		 *
		 * @protected
		 * @type {Map.<String|Function,Function>}
		 */
		this._availablePlugins = new Map();

		for ( const PluginConstructor of availablePlugins ) {
			if ( PluginConstructor.pluginName ) {
				this._availablePlugins.set( PluginConstructor.pluginName, PluginConstructor );
			}
		}

		/**
		 * Map of {@link module:core/contextplugin~ContextPlugin context plugins} which can be retrieved by their constructors or instances.
		 *
		 * @protected
		 * @type {Map<Function,Function>}
		 */
		this._contextPlugins = new Map();

		for ( const [ PluginConstructor, pluginInstance ] of contextPlugins ) {
			this._contextPlugins.set( PluginConstructor, pluginInstance );
			this._contextPlugins.set( pluginInstance, PluginConstructor );

			// To make it possible to require a plugin by its name.
			if ( PluginConstructor.pluginName ) {
				this._availablePlugins.set( PluginConstructor.pluginName, PluginConstructor );
			}
		}
	}

	/**
	 * Iterable interface.
	 *
	 * Returns `[ PluginConstructor, pluginInstance ]` pairs.
	 *
	 * @returns {Iterable.<Array>}
	 */
	* [ Symbol.iterator ]() {
		for ( const entry of this._plugins ) {
			if ( typeof entry[ 0 ] == 'function' ) {
				yield entry;
			}
		}
	}

	/**
	 * Gets the plugin instance by its constructor or name.
	 *
	 *		// Check if 'Clipboard' plugin was loaded.
	 *		if ( editor.plugins.has( 'Clipboard' ) ) {
	 *			// Get clipboard plugin instance
	 *			const clipboard = editor.plugins.get( 'Clipboard' );
	 *
	 *			this.listenTo( clipboard, 'inputTransformation', ( evt, data ) => {
	 *				// Do something on clipboard input.
	 *			} );
	 *		}
	 *
	 * **Note**: This method will throw error if plugin is not loaded. Use `{@link #has editor.plugins.has()}`
	 * to check if plugin is available.
	 *
	 * @param {Function|String} key The plugin constructor or {@link module:core/plugin~PluginInterface.pluginName name}.
	 * @returns {module:core/plugin~PluginInterface}
	 */
	get( key ) {
		const plugin = this._plugins.get( key );

		if ( !plugin ) {
			/**
			 * The plugin is not loaded and could not be obtained.
			 *
			 * Plugin classes (constructors) need to be provided to the editor and must be loaded before they can be obtained from
			 * the plugin collection.
			 * This is usually done in CKEditor 5 builds by setting the {@link module:core/editor/editor~Editor.builtinPlugins}
			 * property.
			 *
			 * **Note**: You can use `{@link module:core/plugincollection~PluginCollection#has editor.plugins.has()}`
			 * to check if plugin was loaded.
			 *
			 * @error plugincollection-plugin-not-loaded
			 * @param {String} plugin The name of the plugin which is not loaded.
			 */
			const errorMsg = 'plugincollection-plugin-not-loaded: The requested plugin is not loaded.';

			let pluginName = key;

			if ( typeof key == 'function' ) {
				pluginName = key.pluginName || key.name;
			}

			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( errorMsg, this._context, { plugin: pluginName } );
		}

		return plugin;
	}

	/**
	 * Checks if a plugin is loaded.
	 *
	 *		// Check if the 'Clipboard' plugin was loaded.
	 *		if ( editor.plugins.has( 'Clipboard' ) ) {
	 *			// Now use the clipboard plugin instance:
	 *			const clipboard = editor.plugins.get( 'Clipboard' );
	 *
	 *			// ...
	 *		}
	 *
	 * @param {Function|String} key The plugin constructor or {@link module:core/plugin~PluginInterface.pluginName name}.
	 * @returns {Boolean}
	 */
	has( key ) {
		return this._plugins.has( key );
	}

	/**
	 * Initializes a set of plugins and adds them to the collection.
	 *
	 * @param {Array.<Function|String>} plugins An array of {@link module:core/plugin~PluginInterface plugin constructors}
	 * or {@link module:core/plugin~PluginInterface.pluginName plugin names}. The second option (names) works only if
	 * `availablePlugins` were passed to the {@link #constructor}.
	 * @param {Array.<String|Function>} [removePlugins] Names of plugins or plugin constructors
	 * that should not be loaded (despite being specified in the `plugins` array).
	 * @returns {Promise.<module:core/plugin~LoadedPlugins>} A promise which gets resolved once all plugins are loaded
	 * and available in the collection.
	 */
	init( plugins, removePlugins = [] ) {
		const that = this;
		const context = this._context;
		const loading = new Set();
		const loaded = [];

		const pluginConstructors = mapToAvailableConstructors( plugins );
		const removePluginConstructors = mapToAvailableConstructors( removePlugins );
		const missingPlugins = getMissingPluginNames( plugins );

		if ( missingPlugins ) {
			/**
			 * Some plugins are not available and could not be loaded.
			 *
			 * Plugin classes (constructors) need to be provided to the editor before they can be loaded by name.
			 * This is usually done in CKEditor 5 builds by setting the {@link module:core/editor/editor~Editor.builtinPlugins}
			 * property.
			 *
			 * **If you see this warning when using one of the {@glink builds/index CKEditor 5 Builds}**, it means
			 * that you try to enable a plugin which was not included in that build. This may be due to a typo
			 * in the plugin name or simply because that plugin is not a part of this build. In the latter scenario,
			 * read more about {@glink builds/guides/development/custom-builds custom builds}.
			 *
			 * **If you see this warning when using one of the editor creators directly** (not a build), then it means
			 * that you tried loading plugins by name. However, unlike CKEditor 4, CKEditor 5 does not implement a "plugin loader".
			 * This means that CKEditor 5 does not know where to load the plugin modules from. Therefore, you need to
			 * provide each plugin through reference (as a constructor function). Check out the examples in
			 * {@glink builds/guides/integration/advanced-setup#scenario-2-building-from-source "Building from source"}.
			 *
			 * @error plugincollection-plugin-not-found
			 * @param {Array.<String>} plugins The name of the plugins which could not be loaded.
			 */
			const errorMsg = 'plugincollection-plugin-not-found: Some plugins are not available and could not be loaded.';

			// Log the error so it's more visible on the console. Hopefully, for better DX.
			console.error( Object(_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["attachLinkToDocumentation"])( errorMsg ), { plugins: missingPlugins } );

			return Promise.reject( new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( errorMsg, context, { plugins: missingPlugins } ) );
		}

		return Promise.all( pluginConstructors.map( loadPlugin ) )
			.then( () => initPlugins( loaded, 'init' ) )
			.then( () => initPlugins( loaded, 'afterInit' ) )
			.then( () => loaded );

		function loadPlugin( PluginConstructor ) {
			if ( removePluginConstructors.includes( PluginConstructor ) ) {
				return;
			}

			// The plugin is already loaded or being loaded - do nothing.
			if ( that._plugins.has( PluginConstructor ) || loading.has( PluginConstructor ) ) {
				return;
			}

			return instantiatePlugin( PluginConstructor )
				.catch( err => {
					/**
					 * It was not possible to load the plugin.
					 *
					 * This is a generic error logged to the console when a JavaSript error is thrown during the initialization
					 * of one of the plugins.
					 *
					 * If you correctly handled the promise returned by the editor's `create()` method (like shown below),
					 * you will find the original error logged to the console, too:
					 *
					 *		ClassicEditor.create( document.getElementById( 'editor' ) )
					 *			.then( editor => {
					 *				// ...
					 * 			} )
					 *			.catch( error => {
					 *				console.error( error );
					 *			} );
					 *
					 * @error plugincollection-load
					 * @param {String} plugin The name of the plugin that could not be loaded.
					 */
					console.error( Object(_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["attachLinkToDocumentation"])(
						'plugincollection-load: It was not possible to load the plugin.'
					), { plugin: PluginConstructor } );

					throw err;
				} );
		}

		function initPlugins( loadedPlugins, method ) {
			return loadedPlugins.reduce( ( promise, plugin ) => {
				if ( !plugin[ method ] ) {
					return promise;
				}

				if ( that._contextPlugins.has( plugin ) ) {
					return promise;
				}

				return promise.then( plugin[ method ].bind( plugin ) );
			}, Promise.resolve() );
		}

		function instantiatePlugin( PluginConstructor ) {
			return new Promise( resolve => {
				loading.add( PluginConstructor );

				if ( PluginConstructor.requires ) {
					PluginConstructor.requires.forEach( RequiredPluginConstructorOrName => {
						const RequiredPluginConstructor = getPluginConstructor( RequiredPluginConstructorOrName );

						if ( PluginConstructor.isContextPlugin && !RequiredPluginConstructor.isContextPlugin ) {
							/**
							 * If a plugin is a context plugin, all plugins it requires should also be context plugins
							 * instead of plugins. In other words, if one plugin can be used in the context,
							 * all its requirements should also be ready to be used in the context. Note that the context
							 * provides only a part of the API provided by the editor. If one plugin needs a full
							 * editor API, all plugins which require it are considered as plugins that need a full
							 * editor API.
							 *
							 * @error plugincollection-context-required
							 * @param {String} plugin The name of the required plugin.
							 * @param {String} requiredBy The name of the parent plugin.
							 */
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
								'plugincollection-context-required: Context plugin can not require plugin which is not a context plugin',
								null,
								{ plugin: RequiredPluginConstructor.name, requiredBy: PluginConstructor.name }
							);
						}

						if ( removePlugins.includes( RequiredPluginConstructor ) ) {
							/**
							 * Cannot load a plugin because one of its dependencies is listed in the `removePlugins` option.
							 *
							 * @error plugincollection-required
							 * @param {String} plugin The name of the required plugin.
							 * @param {String} requiredBy The name of the parent plugin.
							 */
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
								'plugincollection-required: Cannot load a plugin because one of its dependencies is listed in' +
								'the `removePlugins` option.',
								context,
								{ plugin: RequiredPluginConstructor.name, requiredBy: PluginConstructor.name }
							);
						}

						loadPlugin( RequiredPluginConstructor );
					} );
				}

				const plugin = that._contextPlugins.get( PluginConstructor ) || new PluginConstructor( context );
				that._add( PluginConstructor, plugin );
				loaded.push( plugin );

				resolve();
			} );
		}

		function getPluginConstructor( PluginConstructorOrName ) {
			if ( typeof PluginConstructorOrName == 'function' ) {
				return PluginConstructorOrName;
			}

			return that._availablePlugins.get( PluginConstructorOrName );
		}

		function getMissingPluginNames( plugins ) {
			const missingPlugins = [];

			for ( const pluginNameOrConstructor of plugins ) {
				if ( !getPluginConstructor( pluginNameOrConstructor ) ) {
					missingPlugins.push( pluginNameOrConstructor );
				}
			}

			return missingPlugins.length ? missingPlugins : null;
		}

		function mapToAvailableConstructors( plugins ) {
			return plugins
				.map( pluginNameOrConstructor => getPluginConstructor( pluginNameOrConstructor ) )
				.filter( PluginConstructor => !!PluginConstructor );
		}
	}

	/**
	 * Destroys all loaded plugins.
	 *
	 * @returns {Promise}
	 */
	destroy() {
		const promises = [];

		for ( const [ , pluginInstance ] of this ) {
			if ( typeof pluginInstance.destroy == 'function' && !this._contextPlugins.has( pluginInstance ) ) {
				promises.push( pluginInstance.destroy() );
			}
		}

		return Promise.all( promises );
	}

	/**
	 * Adds the plugin to the collection. Exposed mainly for testing purposes.
	 *
	 * @protected
	 * @param {Function} PluginConstructor The plugin constructor.
	 * @param {module:core/plugin~PluginInterface} plugin The instance of the plugin.
	 */
	_add( PluginConstructor, plugin ) {
		this._plugins.set( PluginConstructor, plugin );

		const pluginName = PluginConstructor.pluginName;

		if ( !pluginName ) {
			return;
		}

		if ( this._plugins.has( pluginName ) ) {
			/**
			 * Two plugins with the same {@link module:core/plugin~PluginInterface.pluginName} were loaded.
			 * This will lead to runtime conflicts between these plugins.
			 *
			 * In practice, this warning usually means that new plugins were added to an existing CKEditor 5 build.
			 * Plugins should always be added to a source version of the editor (`@ckeditor/ckeditor5-editor-*`),
			 * not to an editor imported from one of the `@ckeditor/ckeditor5-build-*` packages.
			 *
			 * Check your import paths and the list of plugins passed to
			 * {@link module:core/editor/editor~Editor.create `Editor.create()`}
			 * or specified in {@link module:core/editor/editor~Editor.builtinPlugins `Editor.builtinPlugins`}.
			 *
			 * The second option is that your `node_modules/` directory contains duplicated versions of the same
			 * CKEditor 5 packages. Normally, on clean installations, npm deduplicates packages in `node_modules/`, so
			 * it may be enough to call `rm -rf node_modules && npm i`. However, if you installed conflicting versions
			 * of packages, their dependencies may need to be installed in more than one version which may lead to this
			 * warning.
			 *
			 * Technically speaking, this error occurs because after adding a plugin to an existing editor build
			 * dependencies of this plugin are being duplicated.
			 * They are already built into that editor build and now get added for the second time as dependencies
			 * of the plugin you are installing.
			 *
			 * Read more about {@glink builds/guides/integration/installing-plugins installing plugins}.
			 *
			 * @error plugincollection-plugin-name-conflict
			 * @param {String} pluginName The duplicated plugin name.
			 * @param {Function} plugin1 The first plugin constructor.
			 * @param {Function} plugin2 The second plugin constructor.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'plugincollection-plugin-name-conflict: Two plugins with the same name were loaded.',
				null,
				{ pluginName, plugin1: this._plugins.get( pluginName ).constructor, plugin2: PluginConstructor }
			);
		}

		this._plugins.set( pluginName, plugin );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( PluginCollection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/cancel.svg":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/cancel.svg ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M11.591 10.177l4.243 4.242a1 1 0 0 1-1.415 1.415l-4.242-4.243-4.243 4.243a1 1 0 0 1-1.414-1.415l4.243-4.242L4.52 5.934A1 1 0 0 1 5.934 4.52l4.243 4.243 4.242-4.243a1 1 0 1 1 1.415 1.414l-4.243 4.243z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/check.svg":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/check.svg ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6.972 16.615a.997.997 0 0 1-.744-.292l-4.596-4.596a1 1 0 1 1 1.414-1.414l3.926 3.926 9.937-9.937a1 1 0 0 1 1.414 1.415L7.717 16.323a.997.997 0 0 1-.745.292z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/eraser.svg":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/eraser.svg ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M8.636 9.531l-2.758 3.94a.5.5 0 0 0 .122.696l3.224 2.284h1.314l2.636-3.736L8.636 9.53zm.288 8.451L5.14 15.396a2 2 0 0 1-.491-2.786l6.673-9.53a2 2 0 0 1 2.785-.49l3.742 2.62a2 2 0 0 1 .491 2.785l-7.269 10.053-2.147-.066z\"/><path d=\"M4 18h5.523v-1H4zm-2 0h1v-1H2z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/image.svg":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/image.svg ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M6.91 10.54c.26-.23.64-.21.88.03l3.36 3.14 2.23-2.06a.64.64 0 0 1 .87 0l2.52 2.97V4.5H3.2v10.12l3.71-4.08zm10.27-7.51c.6 0 1.09.47 1.09 1.05v11.84c0 .59-.49 1.06-1.09 1.06H2.79c-.6 0-1.09-.47-1.09-1.06V4.08c0-.58.49-1.05 1.1-1.05h14.38zm-5.22 5.56a1.96 1.96 0 1 1 3.4-1.96 1.96 1.96 0 0 1-3.4 1.96z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/low-vision.svg":
/*!**************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/low-vision.svg ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M5.085 6.22L2.943 4.078a.75.75 0 1 1 1.06-1.06l2.592 2.59A11.094 11.094 0 0 1 10 5.068c4.738 0 8.578 3.101 8.578 5.083 0 1.197-1.401 2.803-3.555 3.887l1.714 1.713a.75.75 0 0 1-.09 1.138.488.488 0 0 1-.15.084.75.75 0 0 1-.821-.16L6.17 7.304c-.258.11-.51.233-.757.365l6.239 6.24-.006.005.78.78c-.388.094-.78.166-1.174.215l-1.11-1.11h.011L4.55 8.197a7.2 7.2 0 0 0-.665.514l-.112.098 4.897 4.897-.005.006 1.276 1.276a10.164 10.164 0 0 1-1.477-.117l-.479-.479-.009.009-4.863-4.863-.022.031a2.563 2.563 0 0 0-.124.2c-.043.077-.08.158-.108.241a.534.534 0 0 0-.028.133.29.29 0 0 0 .008.072.927.927 0 0 0 .082.226c.067.133.145.26.234.379l3.242 3.365.025.01.59.623c-3.265-.918-5.59-3.155-5.59-4.668 0-1.194 1.448-2.838 3.663-3.93zm7.07.531a4.632 4.632 0 0 1 1.108 5.992l.345.344.046-.018a9.313 9.313 0 0 0 2-1.112c.256-.187.5-.392.727-.613.137-.134.27-.277.392-.431.072-.091.141-.185.203-.286.057-.093.107-.19.148-.292a.72.72 0 0 0 .036-.12.29.29 0 0 0 .008-.072.492.492 0 0 0-.028-.133.999.999 0 0 0-.036-.096 2.165 2.165 0 0 0-.071-.145 2.917 2.917 0 0 0-.125-.2 3.592 3.592 0 0 0-.263-.335 5.444 5.444 0 0 0-.53-.523 7.955 7.955 0 0 0-1.054-.768 9.766 9.766 0 0 0-1.879-.891c-.337-.118-.68-.219-1.027-.301zm-2.85.21l-.069.002a.508.508 0 0 0-.254.097.496.496 0 0 0-.104.679.498.498 0 0 0 .326.199l.045.005c.091.003.181.003.272.012a2.45 2.45 0 0 1 2.017 1.513c.024.061.043.125.069.185a.494.494 0 0 0 .45.287h.008a.496.496 0 0 0 .35-.158.482.482 0 0 0 .13-.335.638.638 0 0 0-.048-.219 3.379 3.379 0 0 0-.36-.723 3.438 3.438 0 0 0-2.791-1.543l-.028-.001h-.013z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/pencil.svg":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/pencil.svg ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M7.3 17.37l-.061.088a1.518 1.518 0 0 1-.934.535l-4.178.663-.806-4.153a1.495 1.495 0 0 1 .187-1.058l.056-.086L8.77 2.639c.958-1.351 2.803-1.076 4.296-.03 1.497 1.047 2.387 2.693 1.433 4.055L7.3 17.37zM9.14 4.728l-5.545 8.346 3.277 2.294 5.544-8.346L9.14 4.728zM6.07 16.512l-3.276-2.295.53 2.73 2.746-.435zM9.994 3.506L13.271 5.8c.316-.452-.16-1.333-1.065-1.966-.905-.634-1.895-.78-2.212-.328zM8 18.5L9.375 17H19v1.5H8z\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-core/theme/icons/three-vertical-dots.svg":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-core/theme/icons/three-vertical-dots.svg ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<svg viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"9.5\" cy=\"4.5\" r=\"1.5\"/><circle cx=\"9.5\" cy=\"10.5\" r=\"1.5\"/><circle cx=\"9.5\" cy=\"16.5\" r=\"1.5\"/></svg>");

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-easy-image/src/cloudservicesuploadadapter.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-easy-image/src/cloudservicesuploadadapter.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CloudServicesUploadAdapter; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _ckeditor_ckeditor5_upload_src_filerepository__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-upload/src/filerepository */ "./node_modules/@ckeditor/ckeditor5-upload/src/filerepository.js");
/* harmony import */ var _ckeditor_ckeditor_cloud_services_core_src_uploadgateway_uploadgateway__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor-cloud-services-core/src/uploadgateway/uploadgateway */ "./node_modules/@ckeditor/ckeditor-cloud-services-core/src/uploadgateway/uploadgateway.js");
/* harmony import */ var _ckeditor_ckeditor5_cloud_services_src_cloudservices__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-cloud-services/src/cloudservices */ "./node_modules/@ckeditor/ckeditor5-cloud-services/src/cloudservices.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
* @module easy-image/cloudservicesuploadadapter
*/






/**
 * A plugin that enables upload to [CKEditor Cloud Services](https://ckeditor.com/ckeditor-cloud-services/).
 *
 * It is mainly used by the {@link module:easy-image/easyimage~EasyImage} feature.
 *
 * After enabling this adapter you need to configure the CKEditor Cloud Services integration through
 * {@link module:cloud-services/cloudservices~CloudServicesConfig `config.cloudServices`}.
 *
 * @extends module:core/plugin~Plugin
 */
class CloudServicesUploadAdapter extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [ _ckeditor_ckeditor5_upload_src_filerepository__WEBPACK_IMPORTED_MODULE_1__["default"], _ckeditor_ckeditor5_cloud_services_src_cloudservices__WEBPACK_IMPORTED_MODULE_3__["default"] ];
	}

	/**
	 * @inheritDoc
	 */
	init() {
		const editor = this.editor;

		const cloudServices = editor.plugins.get( _ckeditor_ckeditor5_cloud_services_src_cloudservices__WEBPACK_IMPORTED_MODULE_3__["default"] );

		const token = cloudServices.token;
		const uploadUrl = cloudServices.uploadUrl;

		if ( !token ) {
			return;
		}

		this._uploadGateway = new CloudServicesUploadAdapter._UploadGateway( token, uploadUrl );

		editor.plugins.get( _ckeditor_ckeditor5_upload_src_filerepository__WEBPACK_IMPORTED_MODULE_1__["default"] ).createUploadAdapter = loader => {
			return new Adapter( this._uploadGateway, loader );
		};
	}
}

/**
 * @private
 */
class Adapter {
	constructor( uploadGateway, loader ) {
		this.uploadGateway = uploadGateway;

		this.loader = loader;
	}

	upload() {
		return this.loader.file.then( file => {
			this.fileUploader = this.uploadGateway.upload( file );

			this.fileUploader.on( 'progress', ( evt, data ) => {
				this.loader.uploadTotal = data.total;
				this.loader.uploaded = data.uploaded;
			} );

			return this.fileUploader.send();
		} );
	}

	abort() {
		this.fileUploader.abort();
	}
}

// Store the API in static property to easily overwrite it in tests.
// Too bad dependency injection does not work in Webpack + ES 6 (const) + Babel.
CloudServicesUploadAdapter._UploadGateway = _ckeditor_ckeditor_cloud_services_core_src_uploadgateway_uploadgateway__WEBPACK_IMPORTED_MODULE_2__["default"];


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-easy-image/src/easyimage.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-easy-image/src/easyimage.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EasyImage; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/plugin */ "./node_modules/@ckeditor/ckeditor5-core/src/plugin.js");
/* harmony import */ var _cloudservicesuploadadapter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cloudservicesuploadadapter */ "./node_modules/@ckeditor/ckeditor5-easy-image/src/cloudservicesuploadadapter.js");
/* harmony import */ var _ckeditor_ckeditor5_image_src_image__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-image/src/image */ "./node_modules/@ckeditor/ckeditor5-image/src/image.js");
/* harmony import */ var _ckeditor_ckeditor5_image_src_imageupload__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-image/src/imageupload */ "./node_modules/@ckeditor/ckeditor5-image/src/imageupload.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module easy-image/easyimage
 */






/**
 * The Easy Image feature, which makes the image upload in CKEditor 5 possible with virtually zero
 * server setup. A part of the [CKEditor Cloud Services](https://ckeditor.com/ckeditor-cloud-services/)
 * family.
 *
 * This is a "glue" plugin which enables:
 *
 * * {@link module:image/image~Image},
 * * {@link module:image/imageupload~ImageUpload},
 * * {@link module:easy-image/cloudservicesuploadadapter~CloudServicesUploadAdapter}.
 *
 * See the {@glink features/image-upload/easy-image "Easy Image integration" guide} to learn how to configure
 * and use this feature.
 *
 * Check out the {@glink features/image-upload/image-upload comprehensive "Image upload" guide} to learn about
 * other ways to upload images into CKEditor 5.
 *
 * **Note**: After enabling the Easy Image plugin you need to configure the
 * [CKEditor Cloud Services](https://ckeditor.com/ckeditor-cloud-services/)
 * integration through {@link module:cloud-services/cloudservices~CloudServicesConfig `config.cloudServices`}.
 *
 * @extends module:core/plugin~Plugin
 */
class EasyImage extends _ckeditor_ckeditor5_core_src_plugin__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @inheritDoc
	 */
	static get requires() {
		return [
			_cloudservicesuploadadapter__WEBPACK_IMPORTED_MODULE_1__["default"],
			_ckeditor_ckeditor5_image_src_image__WEBPACK_IMPORTED_MODULE_2__["default"],
			_ckeditor_ckeditor5_image_src_imageupload__WEBPACK_IMPORTED_MODULE_3__["default"]
		];
	}

	/**
	 * @inheritDoc
	 */
	static get pluginName() {
		return 'EasyImage';
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditor.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditor.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BalloonEditor; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editor */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_balloon_balloontoolbar__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/balloon/balloontoolbar */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/balloon/balloontoolbar.js");
/* harmony import */ var _ballooneditorui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ballooneditorui */ "./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditorui.js");
/* harmony import */ var _ballooneditoruiview__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ballooneditoruiview */ "./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/setdatainelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/setdatainelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/getdatafromelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/getdatafromelement.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/dataapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/elementapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/attachtoform */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/securesourceelement */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-balloon/ballooneditor
 */
















/**
 * The {@glink builds/guides/overview#balloon-editor balloon editor} implementation (Medium-like editor).
 * It uses an inline editable and a toolbar based on the {@link module:ui/toolbar/balloon/balloontoolbar~BalloonToolbar}.
 * See the {@glink examples/builds/balloon-editor demo}.
 *
 * In order to create a balloon editor instance, use the static
 * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`} method.
 *
 * # Balloon editor and balloon build
 *
 * The balloon editor can be used directly from source (if you installed the
 * [`@ckeditor/ckeditor5-editor-balloon`](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-balloon) package)
 * but it is also available in the {@glink builds/guides/overview#balloon-editor balloon build}.
 *
 * {@glink builds/guides/overview Builds} are ready-to-use editors with plugins bundled in. When using the editor from
 * source you need to take care of loading all plugins by yourself
 * (through the {@link module:core/editor/editorconfig~EditorConfig#plugins `config.plugins`} option).
 * Using the editor from source gives much better flexibility and allows easier customization.
 *
 * Read more about initializing the editor from source or as a build in
 * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`}.
 *
 * @mixes module:core/editor/utils/dataapimixin~DataApiMixin
 * @mixes module:core/editor/utils/elementapimixin~ElementApiMixin
 * @implements module:core/editor/editorwithui~EditorWithUI
 * @extends module:core/editor/editor~Editor
 */
class BalloonEditor extends _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the balloon editor.
	 *
	 * **Note:** do not use the constructor to create editor instances. Use the static
	 * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`} method instead.
	 *
	 * @protected
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * (on which the editor will be initialized) or initial data for the editor. For more information see
	 * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`}.
	 * @param {module:core/editor/editorconfig~EditorConfig} config The editor configuration.
	 */
	constructor( sourceElementOrData, config ) {
		super( config );

		if ( Object(lodash_es__WEBPACK_IMPORTED_MODULE_11__["isElement"])( sourceElementOrData ) ) {
			this.sourceElement = sourceElementOrData;
			Object(_ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_13__["default"])( this );
		}

		const plugins = this.config.get( 'plugins' );
		plugins.push( _ckeditor_ckeditor5_ui_src_toolbar_balloon_balloontoolbar__WEBPACK_IMPORTED_MODULE_2__["default"] );

		this.config.set( 'plugins', plugins );

		this.config.define( 'balloonToolbar', this.config.get( 'toolbar' ) );

		this.data.processor = new _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_1__["default"]( this.data.viewDocument );

		this.model.document.createRoot();

		const view = new _ballooneditoruiview__WEBPACK_IMPORTED_MODULE_4__["default"]( this.locale, this.editing.view, this.sourceElement );
		this.ui = new _ballooneditorui__WEBPACK_IMPORTED_MODULE_3__["default"]( this, view );

		Object(_ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_9__["default"])( this );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * Updates the original editor element with the data.
	 *
	 * @returns {Promise}
	 */
	destroy() {
		// Cache the data, then destroy.
		// It's safe to assume that the model->view conversion will not work after super.destroy().
		const data = this.getData();

		this.ui.destroy();

		return super.destroy()
			.then( () => {
				if ( this.sourceElement ) {
					Object(_ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_5__["default"])( this.sourceElement, data );
				}
			} );
	}

	/**
	 * Creates a new balloon editor instance.
	 *
	 * There are three general ways how the editor can be initialized.
	 *
	 * # Using an existing DOM element (and loading data from it)
	 *
	 * You can initialize the editor using an existing DOM element:
	 *
	 *		BalloonEditor
	 *			.create( document.querySelector( '#editor' ) )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * The element's content will be used as the editor data and the element will become the editable element.
	 *
	 * # Creating a detached editor
	 *
	 * Alternatively, you can initialize the editor by passing the initial data directly as a string.
	 * In this case, the editor will render an element that must be inserted into the DOM for the editor to work properly:
	 *
	 *		BalloonEditor
	 *			.create( '<p>Hello world!</p>' )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Initial data was provided so the editor UI element needs to be added manually to the DOM.
	 *				document.body.appendChild( editor.ui.element );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This lets you dynamically append the editor to your web page whenever it is convenient for you. You may use this method if your
	 * web page content is generated on the client side and the DOM structure is not ready at the moment when you initialize the editor.
	 *
	 * # Using an existing DOM element (and data provided in `config.initialData`)
	 *
	 * You can also mix these two ways by providing a DOM element to be used and passing the initial data through the configuration:
	 *
	 *		BalloonEditor
	 *			.create( document.querySelector( '#editor' ), {
	 *				initialData: '<h2>Initial data</h2><p>Foo bar.</p>'
	 *			} )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This method can be used to initialize the editor on an existing element with the specified content in case if your integration
	 * makes it difficult to set the content of the source element.
	 *
	 * Note that an error will be thrown if you pass the initial data both as the first parameter and also in the configuration.
	 *
	 * # Configuring the editor
	 *
	 * See the {@link module:core/editor/editorconfig~EditorConfig editor configuration documentation} to learn more about
	 * customizing plugins, toolbar and more.
	 *
	 * # Using the editor from source
	 *
	 * The code samples listed in the previous sections of this documentation assume that you are using an
	 * {@glink builds/guides/overview editor build} (for example – `@ckeditor/ckeditor5-build-balloon`).
	 *
	 * If you want to use the balloon editor from source (`@ckeditor/ckeditor5-editor-balloon/src/ballooneditor`),
	 * you need to define the list of
	 * {@link module:core/editor/editorconfig~EditorConfig#plugins plugins to be initialized} and
	 * {@link module:core/editor/editorconfig~EditorConfig#toolbar toolbar items}. Read more about using the editor from
	 * source in the {@glink builds/guides/integration/advanced-setup "Advanced setup" guide}.
	 *
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * or the editor's initial data.
	 *
	 * If a DOM element is passed, its content will be automatically loaded to the editor upon initialization.
	 * Moreover, the editor data will be set back to the original element once the editor is destroyed.
	 *
	 * If the initial data is passed, a detached editor will be created. In this case you need to insert it into the DOM manually.
	 * It is available under the {@link module:editor-balloon/ballooneditorui~BalloonEditorUI#element `editor.ui.element`} property.
	 *
	 * @param {module:core/editor/editorconfig~EditorConfig} [config] The editor configuration.
	 * @returns {Promise} A promise resolved once the editor is ready. The promise resolves with the created editor instance.
	 */
	static create( sourceElementOrData, config = {} ) {
		return new Promise( resolve => {
			const isHTMLElement = Object(lodash_es__WEBPACK_IMPORTED_MODULE_11__["isElement"])( sourceElementOrData );

			if ( isHTMLElement && sourceElementOrData.tagName === 'TEXTAREA' ) {
				// Documented in core/editor/editor.js
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_12__["default"](
					'editor-wrong-element: This type of editor cannot be initialized inside <textarea> element.',
					null
				);
			}

			const editor = new this( sourceElementOrData, config );

			resolve(
				editor.initPlugins()
					.then( () => {
						editor.ui.init();
					} )
					.then( () => {
						if ( !isHTMLElement && config.initialData ) {
							// Documented in core/editor/editorconfig.jdoc.
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_12__["default"](
								'editor-create-initial-data: ' +
								'The config.initialData option cannot be used together with initial data passed in Editor.create().',
								null
							);
						}

						const initialData = config.initialData || getInitialData( sourceElementOrData );

						return editor.data.init( initialData );
					} )
					.then( () => editor.fire( 'ready' ) )
					.then( () => editor )
			);
		} );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__["default"])( BalloonEditor, _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_7__["default"] );
Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_10__["default"])( BalloonEditor, _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_8__["default"] );

function getInitialData( sourceElementOrData ) {
	return Object(lodash_es__WEBPACK_IMPORTED_MODULE_11__["isElement"])( sourceElementOrData ) ? Object(_ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_6__["default"])( sourceElementOrData ) : sourceElementOrData;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditorui.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditorui.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BalloonEditorUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editorui */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/placeholder */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/placeholder.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-balloon/ballooneditorui
 */





/**
 * The balloon editor UI class.
 *
 * @extends module:core/editor/editorui~EditorUI
 */
class BalloonEditorUI extends _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the balloon editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 * @param {module:ui/editorui/editoruiview~EditorUIView} view The view of the UI.
	 */
	constructor( editor, view ) {
		super( editor );

		/**
		 * The main (top–most) view of the editor UI.
		 *
		 * @readonly
		 * @member {module:ui/editorui/editoruiview~EditorUIView} #view
		 */
		this.view = view;
	}

	/**
	 * @inheritDoc
	 */
	get element() {
		return this.view.editable.element;
	}

	/**
	 * Initializes the UI.
	 */
	init() {
		const editor = this.editor;
		const view = this.view;
		const balloonToolbar = editor.plugins.get( 'BalloonToolbar' );
		const editingView = editor.editing.view;
		const editable = view.editable;
		const editingRoot = editingView.document.getRoot();

		// The editable UI and editing root should share the same name. Then name is used
		// to recognize the particular editable, for instance in ARIA attributes.
		editable.name = editingRoot.rootName;

		view.render();

		// The editable UI element in DOM is available for sure only after the editor UI view has been rendered.
		// But it can be available earlier if a DOM element has been passed to BalloonEditor.create().
		const editableElement = editable.element;

		// Register the editable UI view in the editor. A single editor instance can aggregate multiple
		// editable areas (roots) but the balloon editor has only one.
		this.setEditableElement( editable.name, editableElement );

		// Let the global focus tracker know that the editable UI element is focusable and
		// belongs to the editor. From now on, the focus tracker will sustain the editor focus
		// as long as the editable is focused (e.g. the user is typing).
		this.focusTracker.add( editableElement );

		// Let the editable UI element respond to the changes in the global editor focus
		// tracker. It has been added to the same tracker a few lines above but, in reality, there are
		// many focusable areas in the editor, like balloons, toolbars or dropdowns and as long
		// as they have focus, the editable should act like it is focused too (although technically
		// it isn't), e.g. by setting the proper CSS class, visually announcing focus to the user.
		// Doing otherwise will result in editable focus styles disappearing, once e.g. the
		// toolbar gets focused.
		editable.bind( 'isFocused' ).to( this.focusTracker );

		// Bind the editable UI element to the editing view, making it an end– and entry–point
		// of the editor's engine. This is where the engine meets the UI.
		editingView.attachDomRoot( editableElement );

		Object(_ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__["default"])( {
			origin: editingView,
			originFocusTracker: this.focusTracker,
			originKeystrokeHandler: editor.keystrokes,
			toolbar: balloonToolbar.toolbarView,
			beforeFocus() {
				balloonToolbar.show();
			},
			afterBlur() {
				balloonToolbar.hide();
			}
		} );

		this._initPlaceholder();
		this.fire( 'ready' );
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		const view = this.view;
		const editingView = this.editor.editing.view;

		editingView.detachDomRoot( view.editable.name );
		view.destroy();

		super.destroy();
	}

	/**
	 * Enable the placeholder text on the editing root, if any was configured.
	 *
	 * @private
	 */
	_initPlaceholder() {
		const editor = this.editor;
		const editingView = editor.editing.view;
		const editingRoot = editingView.document.getRoot();
		const sourceElement = editor.sourceElement;

		const placeholderText = editor.config.get( 'placeholder' ) ||
			sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.getAttribute( 'placeholder' );

		if ( placeholderText ) {
			Object(_ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_2__["enablePlaceholder"])( {
				view: editingView,
				element: editingRoot,
				text: placeholderText,
				isDirectHost: false
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditoruiview.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-balloon/src/ballooneditoruiview.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BalloonEditorUIView; });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editorui/editoruiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editorui/editoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-balloon/ballooneditoruiview
 */




/**
 * Contextual editor UI view. Uses the {@link module:ui/editableui/inline/inlineeditableuiview~InlineEditableUIView}.
 *
 * @extends module:ui/editorui/editoruiview~EditorUIView
 */
class BalloonEditorUIView extends _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the balloon editor UI view.
	 *
	 * @param {module:utils/locale~Locale} locale The {@link module:core/editor/editor~Editor#locale} instance.
	 * @param {module:engine/view/view~View} editingView The editing view instance this view is related to.
	 * @param {HTMLElement} [editableElement] The editable element. If not specified, it will be automatically created by
	 * {@link module:ui/editableui/editableuiview~EditableUIView}. Otherwise, the given element will be used.
	 */
	constructor( locale, editingView, editableElement ) {
		super( locale );

		/**
		 * The editable UI view.
		 *
		 * @readonly
		 * @member {module:ui/editableui/inline/inlineeditableuiview~InlineEditableUIView}
		 */
		this.editable = new _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale, editingView, editableElement );
	}

	/**
	 * @inheritDoc
	 */
	render() {
		super.render();

		this.registerChild( this.editable );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditor.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditor.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ClassicEditor; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editor */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/dataapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/elementapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/attachtoform */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/* harmony import */ var _classiceditorui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./classiceditorui */ "./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditorui.js");
/* harmony import */ var _classiceditoruiview__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./classiceditoruiview */ "./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/getdatafromelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/getdatafromelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-classic/classiceditor
 */













/**
 * The {@glink builds/guides/overview#classic-editor classic editor} implementation.
 * It uses an inline editable and a sticky toolbar, all enclosed in a boxed UI.
 * See the {@glink examples/builds/classic-editor demo}.
 *
 * In order to create a classic editor instance, use the static
 * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`} method.
 *
 * # Classic editor and classic build
 *
 * The classic editor can be used directly from source (if you installed the
 * [`@ckeditor/ckeditor5-editor-classic`](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-classic) package)
 * but it is also available in the {@glink builds/guides/overview#classic-editor classic build}.
 *
 * {@glink builds/guides/overview Builds} are ready-to-use editors with plugins bundled in. When using the editor from
 * source you need to take care of loading all plugins by yourself
 * (through the {@link module:core/editor/editorconfig~EditorConfig#plugins `config.plugins`} option).
 * Using the editor from source gives much better flexibility and allows easier customization.
 *
 * Read more about initializing the editor from source or as a build in
 * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`}.
 *
 * @mixes module:core/editor/utils/dataapimixin~DataApiMixin
 * @mixes module:core/editor/utils/elementapimixin~ElementApiMixin
 * @implements module:core/editor/editorwithui~EditorWithUI
 * @extends module:core/editor/editor~Editor
 */
class ClassicEditor extends _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the classic editor.
	 *
	 * **Note:** do not use the constructor to create editor instances. Use the static
	 * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`} method instead.
	 *
	 * @protected
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * or the editor's initial data. For more information see
	 * {@link module:editor-classic/classiceditor~ClassicEditor.create `ClassicEditor.create()`}.
	 * @param {module:core/editor/editorconfig~EditorConfig} config The editor configuration.
	 */
	constructor( sourceElementOrData, config ) {
		super( config );

		if ( Object(lodash_es__WEBPACK_IMPORTED_MODULE_9__["isElement"])( sourceElementOrData ) ) {
			this.sourceElement = sourceElementOrData;
		}

		this.data.processor = new _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_4__["default"]( this.data.viewDocument );

		this.model.document.createRoot();

		const shouldToolbarGroupWhenFull = !this.config.get( 'toolbar.shouldNotGroupWhenFull' );
		const view = new _classiceditoruiview__WEBPACK_IMPORTED_MODULE_6__["default"]( this.locale, this.editing.view, {
			shouldToolbarGroupWhenFull
		} );

		this.ui = new _classiceditorui__WEBPACK_IMPORTED_MODULE_5__["default"]( this, view );

		Object(_ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_3__["default"])( this );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * Updates the editor's source element with the data.
	 *
	 * @returns {Promise}
	 */
	destroy() {
		if ( this.sourceElement ) {
			this.updateSourceElement();
		}

		this.ui.destroy();

		return super.destroy();
	}

	/**
	 * Creates a new classic editor instance.
	 *
	 * There are three ways how the editor can be initialized.
	 *
	 * # Replacing a DOM element (and loading data from it)
	 *
	 * You can initialize the editor using an existing DOM element:
	 *
	 *		ClassicEditor
	 *			.create( document.querySelector( '#editor' ) )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * The element's content will be used as the editor data and the element will be replaced by the editor UI.
	 *
	 * # Creating a detached editor
	 *
	 * Alternatively, you can initialize the editor by passing the initial data directly as a string.
	 * In this case, the editor will render an element that must be inserted into the DOM:
	 *
	 *		ClassicEditor
	 *			.create( '<p>Hello world!</p>' )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Initial data was provided so the editor UI element needs to be added manually to the DOM.
	 *				document.body.appendChild( editor.ui.element );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This lets you dynamically append the editor to your web page whenever it is convenient for you. You may use this method if your
	 * web page content is generated on the client side and the DOM structure is not ready at the moment when you initialize the editor.
	 *
	 * # Replacing a DOM element (and data provided in `config.initialData`)
	 *
	 * You can also mix these two ways by providing a DOM element to be used and passing the initial data through the configuration:
	 *
	 *		ClassicEditor
	 *			.create( document.querySelector( '#editor' ), {
	 *				initialData: '<h2>Initial data</h2><p>Foo bar.</p>'
	 *			} )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This method can be used to initialize the editor on an existing element with the specified content in case if your integration
	 * makes it difficult to set the content of the source element.
	 *
	 * Note that an error will be thrown if you pass the initial data both as the first parameter and also in the configuration.
	 *
	 * # Configuring the editor
	 *
	 * See the {@link module:core/editor/editorconfig~EditorConfig editor configuration documentation} to learn more about
	 * customizing plugins, toolbar and more.
	 *
	 * # Using the editor from source
	 *
	 * The code samples listed in the previous sections of this documentation assume that you are using an
	 * {@glink builds/guides/overview editor build} (for example – `@ckeditor/ckeditor5-build-classic`).
	 *
	 * If you want to use the classic editor from source (`@ckeditor/ckeditor5-editor-classic/src/classiceditor`),
	 * you need to define the list of
	 * {@link module:core/editor/editorconfig~EditorConfig#plugins plugins to be initialized} and
	 * {@link module:core/editor/editorconfig~EditorConfig#toolbar toolbar items}. Read more about using the editor from
	 * source in the {@glink builds/guides/integration/advanced-setup "Advanced setup" guide}.
	 *
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * or the editor's initial data.
	 *
	 * If a DOM element is passed, its content will be automatically loaded to the editor upon initialization
	 * and the {@link module:editor-classic/classiceditorui~ClassicEditorUI#element editor element} will replace the passed element
	 * in the DOM (the original one will be hidden and the editor will be injected next to it).
	 *
	 * Moreover, the editor data will be set back to the original element once the editor is destroyed and when a form, in which
	 * this element is contained, is submitted (if the original element is a `<textarea>`). This ensures seamless integration with native
	 * web forms.
	 *
	 * If the initial data is passed, a detached editor will be created. In this case you need to insert it into the DOM manually.
	 * It is available under the {@link module:editor-classic/classiceditorui~ClassicEditorUI#element `editor.ui.element`} property.
	 *
	 * @param {module:core/editor/editorconfig~EditorConfig} [config] The editor configuration.
	 * @returns {Promise} A promise resolved once the editor is ready. The promise resolves with the created editor instance.
	 */
	static create( sourceElementOrData, config = {} ) {
		return new Promise( resolve => {
			const editor = new this( sourceElementOrData, config );

			resolve(
				editor.initPlugins()
					.then( () => editor.ui.init( Object(lodash_es__WEBPACK_IMPORTED_MODULE_9__["isElement"])( sourceElementOrData ) ? sourceElementOrData : null ) )
					.then( () => {
						if ( !Object(lodash_es__WEBPACK_IMPORTED_MODULE_9__["isElement"])( sourceElementOrData ) && config.initialData ) {
							// Documented in core/editor/editorconfig.jdoc.
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_10__["default"](
								'editor-create-initial-data: ' +
								'The config.initialData option cannot be used together with initial data passed in Editor.create().',
								null
							);
						}

						const initialData = config.initialData || getInitialData( sourceElementOrData );

						return editor.data.init( initialData );
					} )
					.then( () => editor.fire( 'ready' ) )
					.then( () => editor )
			);
		} );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_8__["default"])( ClassicEditor, _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__["default"] );
Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_8__["default"])( ClassicEditor, _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_2__["default"] );

function getInitialData( sourceElementOrData ) {
	return Object(lodash_es__WEBPACK_IMPORTED_MODULE_9__["isElement"])( sourceElementOrData ) ? Object(_ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_7__["default"])( sourceElementOrData ) : sourceElementOrData;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditorui.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditorui.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ClassicEditorUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editorui */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/placeholder */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/placeholder.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_elementreplacer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/elementreplacer */ "./node_modules/@ckeditor/ckeditor5-utils/src/elementreplacer.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-classic/classiceditorui
 */







/**
 * The classic editor UI class.
 *
 * @extends module:core/editor/editorui~EditorUI
 */
class ClassicEditorUI extends _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the classic editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 * @param {module:ui/editorui/editoruiview~EditorUIView} view The view of the UI.
	 */
	constructor( editor, view ) {
		super( editor );

		/**
		 * The main (top–most) view of the editor UI.
		 *
		 * @readonly
		 * @member {module:ui/editorui/editoruiview~EditorUIView} #view
		 */
		this.view = view;

		/**
		 * A normalized `config.toolbar` object.
		 *
		 * @private
		 * @member {Object}
		 */
		this._toolbarConfig = Object(_ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__["default"])( editor.config.get( 'toolbar' ) );

		/**
		 * The element replacer instance used to hide the editor's source element.
		 *
		 * @protected
		 * @member {module:utils/elementreplacer~ElementReplacer}
		 */
		this._elementReplacer = new _ckeditor_ckeditor5_utils_src_elementreplacer__WEBPACK_IMPORTED_MODULE_4__["default"]();
	}

	/**
	 * @inheritDoc
	 */
	get element() {
		return this.view.element;
	}

	/**
	 * Initializes the UI.
	 *
	 * @param {HTMLElement|null} replacementElement The DOM element that will be the source for the created editor.
	 */
	init( replacementElement ) {
		const editor = this.editor;
		const view = this.view;
		const editingView = editor.editing.view;
		const editable = view.editable;
		const editingRoot = editingView.document.getRoot();

		// The editable UI and editing root should share the same name. Then name is used
		// to recognize the particular editable, for instance in ARIA attributes.
		editable.name = editingRoot.rootName;

		view.render();

		// The editable UI element in DOM is available for sure only after the editor UI view has been rendered.
		// But it can be available earlier if a DOM element has been passed to BalloonEditor.create().
		const editableElement = editable.element;

		// Register the editable UI view in the editor. A single editor instance can aggregate multiple
		// editable areas (roots) but the classic editor has only one.
		this.setEditableElement( editable.name, editableElement );

		// Let the global focus tracker know that the editable UI element is focusable and
		// belongs to the editor. From now on, the focus tracker will sustain the editor focus
		// as long as the editable is focused (e.g. the user is typing).
		this.focusTracker.add( editableElement );

		// Let the editable UI element respond to the changes in the global editor focus
		// tracker. It has been added to the same tracker a few lines above but, in reality, there are
		// many focusable areas in the editor, like balloons, toolbars or dropdowns and as long
		// as they have focus, the editable should act like it is focused too (although technically
		// it isn't), e.g. by setting the proper CSS class, visually announcing focus to the user.
		// Doing otherwise will result in editable focus styles disappearing, once e.g. the
		// toolbar gets focused.
		view.editable.bind( 'isFocused' ).to( this.focusTracker );

		// Bind the editable UI element to the editing view, making it an end– and entry–point
		// of the editor's engine. This is where the engine meets the UI.
		editingView.attachDomRoot( editableElement );

		// If an element containing the initial data of the editor was provided, replace it with
		// an editor instance's UI in DOM until the editor is destroyed. For instance, a <textarea>
		// can be such element.
		if ( replacementElement ) {
			this._elementReplacer.replace( replacementElement, this.element );
		}

		this._initPlaceholder();
		this._initToolbar();
		this.fire( 'ready' );
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		const view = this.view;
		const editingView = this.editor.editing.view;

		this._elementReplacer.restore();
		editingView.detachDomRoot( view.editable.name );
		view.destroy();

		super.destroy();
	}

	/**
	 * Initializes the editor toolbar.
	 *
	 * @private
	 */
	_initToolbar() {
		const editor = this.editor;
		const view = this.view;
		const editingView = editor.editing.view;

		// Set–up the sticky panel with toolbar.
		view.stickyPanel.bind( 'isActive' ).to( this.focusTracker, 'isFocused' );
		view.stickyPanel.limiterElement = view.element;

		if ( this._toolbarConfig.viewportTopOffset ) {
			view.stickyPanel.viewportTopOffset = this._toolbarConfig.viewportTopOffset;
		}

		view.toolbar.fillFromConfig( this._toolbarConfig.items, this.componentFactory );

		Object(_ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__["default"])( {
			origin: editingView,
			originFocusTracker: this.focusTracker,
			originKeystrokeHandler: editor.keystrokes,
			toolbar: view.toolbar
		} );
	}

	/**
	 * Enable the placeholder text on the editing root, if any was configured.
	 *
	 * @private
	 */
	_initPlaceholder() {
		const editor = this.editor;
		const editingView = editor.editing.view;
		const editingRoot = editingView.document.getRoot();
		const sourceElement = editor.sourceElement;

		const placeholderText = editor.config.get( 'placeholder' ) ||
			sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.getAttribute( 'placeholder' );

		if ( placeholderText ) {
			Object(_ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__["enablePlaceholder"])( {
				view: editingView,
				element: editingRoot,
				text: placeholderText,
				isDirectHost: false
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditoruiview.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-classic/src/classiceditoruiview.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ClassicEditorUIView; });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editorui_boxed_boxededitoruiview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editorui/boxed/boxededitoruiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editorui/boxed/boxededitoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_panel_sticky_stickypanelview__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/panel/sticky/stickypanelview */ "./node_modules/@ckeditor/ckeditor5-ui/src/panel/sticky/stickypanelview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/toolbarview */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/toolbarview.js");
/* harmony import */ var _theme_classiceditor_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../theme/classiceditor.css */ "./node_modules/@ckeditor/ckeditor5-editor-classic/theme/classiceditor.css");
/* harmony import */ var _theme_classiceditor_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_theme_classiceditor_css__WEBPACK_IMPORTED_MODULE_4__);
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-classic/classiceditoruiview
 */








/**
 * Classic editor UI view. Uses an inline editable and a sticky toolbar, all
 * enclosed in a boxed UI view.
 *
 * @extends module:ui/editorui/boxed/boxededitoruiview~BoxedEditorUIView
 */
class ClassicEditorUIView extends _ckeditor_ckeditor5_ui_src_editorui_boxed_boxededitoruiview__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the classic editor UI view.
	 *
	 * @param {module:utils/locale~Locale} locale The {@link module:core/editor/editor~Editor#locale} instance.
	 * @param {module:engine/view/view~View} editingView The editing view instance this view is related to.
	 * @param {Object} [options={}] Configuration options fo the view instance.
	 * @param {Boolean} [options.shouldToolbarGroupWhenFull] When set `true` enables automatic items grouping
	 * in the main {@link module:editor-classic/classiceditoruiview~ClassicEditorUIView#toolbar toolbar}.
	 * See {@link module:ui/toolbar/toolbarview~ToolbarOptions#shouldGroupWhenFull} to learn more.
	 */
	constructor( locale, editingView, options = {} ) {
		super( locale );

		/**
		 * Sticky panel view instance. This is a parent view of a {@link #toolbar}
		 * that makes toolbar sticky.
		 *
		 * @readonly
		 * @member {module:ui/panel/sticky/stickypanelview~StickyPanelView}
		 */
		this.stickyPanel = new _ckeditor_ckeditor5_ui_src_panel_sticky_stickypanelview__WEBPACK_IMPORTED_MODULE_2__["default"]( locale );

		/**
		 * Toolbar view instance.
		 *
		 * @readonly
		 * @member {module:ui/toolbar/toolbarview~ToolbarView}
		 */
		this.toolbar = new _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_3__["default"]( locale, {
			shouldGroupWhenFull: options.shouldToolbarGroupWhenFull
		} );

		/**
		 * Editable UI view.
		 *
		 * @readonly
		 * @member {module:ui/editableui/inline/inlineeditableuiview~InlineEditableUIView}
		 */
		this.editable = new _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale, editingView );
	}

	/**
	 * @inheritDoc
	 */
	render() {
		super.render();

		// Set toolbar as a child of a stickyPanel and makes toolbar sticky.
		this.stickyPanel.content.add( this.toolbar );

		this.top.add( this.stickyPanel );
		this.main.add( this.editable );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-classic/theme/classiceditor.css":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-classic/theme/classiceditor.css ***!
  \*********************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

var api = __webpack_require__(/*! ../../../style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !../../../postcss-loader/src??ref--12-1!./classiceditor.css */ "./node_modules/postcss-loader/src/index.js?!./node_modules/@ckeditor/ckeditor5-editor-classic/theme/classiceditor.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.i, content, '']];
            }

var options = {"injectType":"singletonStyleTag","attributes":{"data-cke":true}};

options.insert = "head";
options.singleton = true;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitor.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitor.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DecoupledEditor; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editor */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/dataapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/* harmony import */ var _decouplededitorui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./decouplededitorui */ "./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitorui.js");
/* harmony import */ var _decouplededitoruiview__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./decouplededitoruiview */ "./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/getdatafromelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/getdatafromelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/setdatainelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/setdatainelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/securesourceelement */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-decoupled/decouplededitor
 */













/**
 * The {@glink builds/guides/overview#document-editor decoupled editor} implementation.
 * It provides an inline editable and a toolbar. However, unlike other editors,
 * it does not render these components anywhere in the DOM unless configured.
 *
 * This type of an editor is dedicated to integrations which require a customized UI with an open
 * structure, allowing developers to specify the exact location of the interface.
 *
 * See the document editor {@glink examples/builds/document-editor demo} to learn about possible use cases
 * for the decoupled editor.
 *
 * In order to create a decoupled editor instance, use the static
 * {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`} method.
 *
 * # Decoupled editor and document editor build
 *
 * The decoupled editor can be used directly from source (if you installed the
 * [`@ckeditor/ckeditor5-editor-decoupled`](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-decoupled) package)
 * but it is also available in the {@glink builds/guides/overview#document-editor document editor build}.
 *
 * {@glink builds/guides/overview Builds} are ready-to-use editors with plugins bundled in. When using the editor from
 * source you need to take care of loading all plugins by yourself
 * (through the {@link module:core/editor/editorconfig~EditorConfig#plugins `config.plugins`} option).
 * Using the editor from source gives much better flexibility and allows for easier customization.
 *
 * Read more about initializing the editor from source or as a build in
 * {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`}.
 *
 * @mixes module:core/editor/utils/dataapimixin~DataApiMixin
 * @implements module:core/editor/editorwithui~EditorWithUI
 * @extends module:core/editor/editor~Editor
 */
class DecoupledEditor extends _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the decoupled editor.
	 *
	 * **Note:** Do not use the constructor to create editor instances. Use the static
	 * {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`} method instead.
	 *
	 * @protected
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * (on which the editor will be initialized) or initial data for the editor. For more information see
	 * {@link module:editor-balloon/ballooneditor~BalloonEditor.create `BalloonEditor.create()`}.
	 * @param {module:core/editor/editorconfig~EditorConfig} config The editor configuration.
	 */
	constructor( sourceElementOrData, config ) {
		super( config );

		if ( Object(lodash_es__WEBPACK_IMPORTED_MODULE_8__["isElement"])( sourceElementOrData ) ) {
			this.sourceElement = sourceElementOrData;
			Object(_ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_10__["default"])( this );
		}

		this.data.processor = new _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_2__["default"]( this.data.viewDocument );

		this.model.document.createRoot();

		const shouldToolbarGroupWhenFull = !this.config.get( 'toolbar.shouldNotGroupWhenFull' );
		const view = new _decouplededitoruiview__WEBPACK_IMPORTED_MODULE_4__["default"]( this.locale, this.editing.view, {
			editableElement: this.sourceElement,
			shouldToolbarGroupWhenFull
		} );

		this.ui = new _decouplededitorui__WEBPACK_IMPORTED_MODULE_3__["default"]( this, view );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * **Note**: The decoupled editor does not remove the toolbar and editable when destroyed. You can
	 * do that yourself in the destruction chain:
	 *
	 *		editor.destroy()
	 *			.then( () => {
	 *				// Remove the toolbar from DOM.
	 *				editor.ui.view.toolbar.element.remove();
	 *
	 *				// Remove the editable from DOM.
	 *				editor.ui.view.editable.element.remove();
	 *
	 *				console.log( 'Editor was destroyed' );
	 *			} );
	 *
	 * @returns {Promise}
	 */
	destroy() {
		// Cache the data, then destroy.
		// It's safe to assume that the model->view conversion will not work after super.destroy().
		const data = this.getData();

		this.ui.destroy();

		return super.destroy()
			.then( () => {
				if ( this.sourceElement ) {
					Object(_ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_6__["default"])( this.sourceElement, data );
				}
			} );
	}

	/**
	 * Creates a new decoupled editor instance.
	 *
	 * Remember that `DecoupledEditor` does not append the toolbar element to your web page so you have to do it manually after the editor
	 * has been initialized.
	 *
	 * There are two ways how the editor can be initialized.
	 *
	 * # Using an existing DOM element (and loading data from it)
	 *
	 * You can initialize the editor using an existing DOM element:
	 *
	 *		DecoupledEditor
	 *			.create( document.querySelector( '#editor' ) )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Append the toolbar to the <body> element.
	 *				document.body.appendChild( editor.ui.view.toolbar.element );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * The element's content will be used as the editor data and the element will become the editable element.
	 *
	 * # Creating a detached editor
	 *
	 * Alternatively, you can initialize the editor by passing the initial data directly as a string.
	 * In this case, you will have to manually append both the toolbar element and the editable element to your web page.
	 *
	 *		DecoupledEditor
	 *			.create( '<p>Hello world!</p>' )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Append the toolbar to the <body> element.
	 *				document.body.appendChild( editor.ui.view.toolbar.element );
	 *
	 *				// Initial data was provided so the editor UI element needs to be added manually to the DOM.
	 *				document.body.appendChild( editor.ui.getEditableElement() );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This lets you dynamically append the editor to your web page whenever it is convenient for you. You may use this method if your
	 * web page content is generated on the client side and the DOM structure is not ready at the moment when you initialize the editor.
	 *
	 * # Using an existing DOM element (and data provided in `config.initialData`)
	 *
	 * You can also mix these two ways by providing a DOM element to be used and passing the initial data through the configuration:
	 *
	 *		DecoupledEditor
	 *			.create( document.querySelector( '#editor' ), {
	 *				initialData: '<h2>Initial data</h2><p>Foo bar.</p>'
	 *			} )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Append the toolbar to the <body> element.
	 *				document.body.appendChild( editor.ui.view.toolbar.element );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This method can be used to initialize the editor on an existing element with the specified content in case if your integration
	 * makes it difficult to set the content of the source element.
	 *
	 * Note that an error will be thrown if you pass the initial data both as the first parameter and also in the configuration.
	 *
	 * # Configuring the editor
	 *
	 * See the {@link module:core/editor/editorconfig~EditorConfig editor configuration documentation} to learn more about
	 * customizing plugins, toolbar and more.
	 *
	 * # Using the editor from source
	 *
	 * The code samples listed in the previous sections of this documentation assume that you are using an
	 * {@glink builds/guides/overview editor build} (for example – `@ckeditor/ckeditor5-build-decoupled`).
	 *
	 * If you want to use the decoupled editor from source (`@ckeditor/ckeditor5-editor-decoupled/src/decouplededitor`),
	 * you need to define the list of
	 * {@link module:core/editor/editorconfig~EditorConfig#plugins plugins to be initialized} and
	 * {@link module:core/editor/editorconfig~EditorConfig#toolbar toolbar items}. Read more about using the editor from
	 * source in the {@glink builds/guides/integration/advanced-setup "Advanced setup" guide}.
	 *
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * or the editor's initial data.
	 *
	 * If a DOM element is passed, its content will be automatically loaded to the editor upon initialization.
	 * Moreover, the editor data will be set back to the original element once the editor is destroyed.
	 *
	 * If the initial data is passed, a detached editor will be created. In this case you need to insert it into the DOM manually.
	 * It is available via
	 * {@link module:editor-decoupled/decouplededitorui~DecoupledEditorUI#getEditableElement `editor.ui.getEditableElement()`}.
	 *
	 * @param {module:core/editor/editorconfig~EditorConfig} [config] The editor configuration.
	 * @returns {Promise} A promise resolved once the editor is ready. The promise resolves with the created editor instance.
	 */
	static create( sourceElementOrData, config = {} ) {
		return new Promise( resolve => {
			const isHTMLElement = Object(lodash_es__WEBPACK_IMPORTED_MODULE_8__["isElement"])( sourceElementOrData );

			if ( isHTMLElement && sourceElementOrData.tagName === 'TEXTAREA' ) {
				// Documented in core/editor/editor.js
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_9__["default"](
					'editor-wrong-element: This type of editor cannot be initialized inside <textarea> element.', null );
			}

			const editor = new this( sourceElementOrData, config );

			resolve(
				editor.initPlugins()
					.then( () => {
						editor.ui.init();
					} )
					.then( () => {
						if ( !isHTMLElement && config.initialData ) {
							// Documented in core/editor/editorconfig.jdoc.
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_9__["default"](
								'editor-create-initial-data: ' +
								'The config.initialData option cannot be used together with initial data passed in Editor.create().',
								null
							);
						}

						const initialData = config.initialData || getInitialData( sourceElementOrData );

						return editor.data.init( initialData );
					} )
					.then( () => editor.fire( 'ready' ) )
					.then( () => editor )
			);
		} );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__["default"])( DecoupledEditor, _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

function getInitialData( sourceElementOrData ) {
	return Object(lodash_es__WEBPACK_IMPORTED_MODULE_8__["isElement"])( sourceElementOrData ) ? Object(_ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_5__["default"])( sourceElementOrData ) : sourceElementOrData;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitorui.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitorui.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DecoupledEditorUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editorui */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/placeholder */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/placeholder.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-decoupled/decouplededitorui
 */






/**
 * The decoupled editor UI class.
 *
 * @extends module:core/editor/editorui~EditorUI
 */
class DecoupledEditorUI extends _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the decoupled editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 * @param {module:ui/editorui/editoruiview~EditorUIView} view The view of the UI.
	 */
	constructor( editor, view ) {
		super( editor );

		/**
		 * The main (top–most) view of the editor UI.
		 *
		 * @readonly
		 * @member {module:ui/editorui/editoruiview~EditorUIView} #view
		 */
		this.view = view;

		/**
		 * A normalized `config.toolbar` object.
		 *
		 * @type {Object}
		 * @private
		 */
		this._toolbarConfig = Object(_ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__["default"])( editor.config.get( 'toolbar' ) );
	}

	/**
	 * Initializes the UI.
	 */
	init() {
		const editor = this.editor;
		const view = this.view;
		const editingView = editor.editing.view;
		const editable = view.editable;
		const editingRoot = editingView.document.getRoot();

		// The editable UI and editing root should share the same name. Then name is used
		// to recognize the particular editable, for instance in ARIA attributes.
		view.editable.name = editingRoot.rootName;

		view.render();

		// The editable UI element in DOM is available for sure only after the editor UI view has been rendered.
		// But it can be available earlier if a DOM element has been passed to DecoupledEditor.create().
		const editableElement = editable.element;

		// Register the editable UI view in the editor. A single editor instance can aggregate multiple
		// editable areas (roots) but the decoupled editor has only one.
		this.setEditableElement( editable.name, editableElement );

		// Let the global focus tracker know that the editable UI element is focusable and
		// belongs to the editor. From now on, the focus tracker will sustain the editor focus
		// as long as the editable is focused (e.g. the user is typing).
		this.focusTracker.add( editableElement );

		// Let the editable UI element respond to the changes in the global editor focus
		// tracker. It has been added to the same tracker a few lines above but, in reality, there are
		// many focusable areas in the editor, like balloons, toolbars or dropdowns and as long
		// as they have focus, the editable should act like it is focused too (although technically
		// it isn't), e.g. by setting the proper CSS class, visually announcing focus to the user.
		// Doing otherwise will result in editable focus styles disappearing, once e.g. the
		// toolbar gets focused.
		view.editable.bind( 'isFocused' ).to( this.focusTracker );

		// Bind the editable UI element to the editing view, making it an end– and entry–point
		// of the editor's engine. This is where the engine meets the UI.
		editingView.attachDomRoot( editableElement );

		this._initPlaceholder();
		this._initToolbar();
		this.fire( 'ready' );
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		const view = this.view;
		const editingView = this.editor.editing.view;

		editingView.detachDomRoot( view.editable.name );
		view.destroy();

		super.destroy();
	}

	/**
	 * Initializes the inline editor toolbar and its panel.
	 *
	 * @private
	 */
	_initToolbar() {
		const editor = this.editor;
		const view = this.view;
		const toolbar = view.toolbar;

		toolbar.fillFromConfig( this._toolbarConfig.items, this.componentFactory );

		Object(_ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__["default"])( {
			origin: editor.editing.view,
			originFocusTracker: this.focusTracker,
			originKeystrokeHandler: editor.keystrokes,
			toolbar
		} );
	}

	/**
	 * Enable the placeholder text on the editing root, if any was configured.
	 *
	 * @private
	 */
	_initPlaceholder() {
		const editor = this.editor;
		const editingView = editor.editing.view;
		const editingRoot = editingView.document.getRoot();
		const sourceElement = editor.sourceElement;

		const placeholderText = editor.config.get( 'placeholder' ) ||
			sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.getAttribute( 'placeholder' );

		if ( placeholderText ) {
			Object(_ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__["enablePlaceholder"])( {
				view: editingView,
				element: editingRoot,
				text: placeholderText,
				isDirectHost: false
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitoruiview.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-decoupled/src/decouplededitoruiview.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DecoupledEditorUIView; });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editorui/editoruiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editorui/editoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/toolbarview */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/toolbarview.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-decoupled/decouplededitoruiview
 */





/**
 * The decoupled editor UI view. It is a virtual view providing an inline
 * {@link module:editor-decoupled/decouplededitoruiview~DecoupledEditorUIView#editable} and a
 * {@link module:editor-decoupled/decouplededitoruiview~DecoupledEditorUIView#toolbar}, but without any
 * specific arrangement of the components in the DOM.
 *
 * See {@link module:editor-decoupled/decouplededitor~DecoupledEditor.create `DecoupledEditor.create()`}
 * to learn more about this view.
 *
 * @extends module:ui/editorui/editoruiview~EditorUIView
 */
class DecoupledEditorUIView extends _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the decoupled editor UI view.
	 *
	 * @param {module:utils/locale~Locale} locale The {@link module:core/editor/editor~Editor#locale} instance.
	 * @param {module:engine/view/view~View} editingView The editing view instance this view is related to.
	 * @param {Object} [options={}] Configuration options fo the view instance.
	 * @param {HTMLElement} [options.editableElement] The editable element. If not specified, it will be automatically created by
	 * {@link module:ui/editableui/editableuiview~EditableUIView}. Otherwise, the given element will be used.
	 * @param {Boolean} [options.shouldToolbarGroupWhenFull] When set `true` enables automatic items grouping
	 * in the main {@link module:editor-decoupled/decouplededitoruiview~DecoupledEditorUIView#toolbar toolbar}.
	 * See {@link module:ui/toolbar/toolbarview~ToolbarOptions#shouldGroupWhenFull} to learn more.
	 */
	constructor( locale, editingView, options = {} ) {
		super( locale );

		/**
		 * The main toolbar of the decoupled editor UI.
		 *
		 * @readonly
		 * @member {module:ui/toolbar/toolbarview~ToolbarView}
		 */
		this.toolbar = new _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_2__["default"]( locale, {
			shouldGroupWhenFull: options.shouldToolbarGroupWhenFull
		} );

		/**
		 * The editable of the decoupled editor UI.
		 *
		 * @readonly
		 * @member {module:ui/editableui/inline/inlineeditableuiview~InlineEditableUIView}
		 */
		this.editable = new _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale, editingView, options.editableElement );

		// This toolbar may be placed anywhere in the page so things like font size need to be reset in it.
		// Because of the above, make sure the toolbar supports rounded corners.
		// Also, make sure the toolbar has the proper dir attribute because its ancestor may not have one
		// and some toolbar item styles depend on this attribute.
		this.toolbar.extendTemplate( {
			attributes: {
				class: [
					'ck-reset_all',
					'ck-rounded-corners'
				],
				dir: locale.uiLanguageDirection
			}
		} );
	}

	/**
	 * @inheritDoc
	 */
	render() {
		super.render();

		this.registerChild( [ this.toolbar, this.editable ] );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditor.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditor.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return InlineEditor; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editor */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editor.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/dataapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/dataapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/elementapimixin */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/elementapimixin.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/attachtoform */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/attachtoform.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js");
/* harmony import */ var _inlineeditorui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./inlineeditorui */ "./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditorui.js");
/* harmony import */ var _inlineeditoruiview__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./inlineeditoruiview */ "./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/setdatainelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/setdatainelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/getdatafromelement */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/getdatafromelement.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/utils/securesourceelement */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/utils/securesourceelement.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-inline/inlineeditor
 */















/**
 * The {@glink builds/guides/overview#inline-editor inline editor} implementation.
 * It uses an inline editable and a floating toolbar.
 * See the {@glink examples/builds/inline-editor demo}.
 *
 * In order to create a inline editor instance, use the static
 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`} method.
 *
 * # Inline editor and inline build
 *
 * The inline editor can be used directly from source (if you installed the
 * [`@ckeditor/ckeditor5-editor-inline`](https://www.npmjs.com/package/@ckeditor/ckeditor5-editor-inline) package)
 * but it is also available in the {@glink builds/guides/overview#inline-editor inline build}.
 *
 * {@glink builds/guides/overview Builds} are ready-to-use editors with plugins bundled in. When using the editor from
 * source you need to take care of loading all plugins by yourself
 * (through the {@link module:core/editor/editorconfig~EditorConfig#plugins `config.plugins`} option).
 * Using the editor from source gives much better flexibility and allows easier customization.
 *
 * Read more about initializing the editor from source or as a build in
 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`}.
 *
 * @mixes module:core/editor/utils/dataapimixin~DataApiMixin
 * @mixes module:core/editor/utils/elementapimixin~ElementApiMixin
 * @implements module:core/editor/editorwithui~EditorWithUI
 * @extends module:core/editor/editor~Editor
 */
class InlineEditor extends _ckeditor_ckeditor5_core_src_editor_editor__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the inline editor.
	 *
	 * **Note:** Do not use the constructor to create editor instances. Use the static
	 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`} method instead.
	 *
	 * @protected
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * (on which the editor will be initialized) or initial data for the editor. For more information see
	 * {@link module:editor-inline/inlineeditor~InlineEditor.create `InlineEditor.create()`}.
	 * @param {module:core/editor/editorconfig~EditorConfig} config The editor configuration.
	 */
	constructor( sourceElementOrData, config ) {
		super( config );

		this.data.processor = new _ckeditor_ckeditor5_engine_src_dataprocessor_htmldataprocessor__WEBPACK_IMPORTED_MODULE_4__["default"]( this.data.viewDocument );

		this.model.document.createRoot();

		if ( Object(lodash_es__WEBPACK_IMPORTED_MODULE_10__["isElement"])( sourceElementOrData ) ) {
			this.sourceElement = sourceElementOrData;
			Object(_ckeditor_ckeditor5_core_src_editor_utils_securesourceelement__WEBPACK_IMPORTED_MODULE_12__["default"])( this );
		}

		const shouldToolbarGroupWhenFull = !this.config.get( 'toolbar.shouldNotGroupWhenFull' );

		const view = new _inlineeditoruiview__WEBPACK_IMPORTED_MODULE_6__["default"]( this.locale, this.editing.view, this.sourceElement, {
			shouldToolbarGroupWhenFull
		} );
		this.ui = new _inlineeditorui__WEBPACK_IMPORTED_MODULE_5__["default"]( this, view );

		Object(_ckeditor_ckeditor5_core_src_editor_utils_attachtoform__WEBPACK_IMPORTED_MODULE_3__["default"])( this );
	}

	/**
	 * Destroys the editor instance, releasing all resources used by it.
	 *
	 * Updates the original editor element with the data.
	 *
	 * @returns {Promise}
	 */
	destroy() {
		// Cache the data, then destroy.
		// It's safe to assume that the model->view conversion will not work after super.destroy().
		const data = this.getData();

		this.ui.destroy();

		return super.destroy()
			.then( () => {
				if ( this.sourceElement ) {
					Object(_ckeditor_ckeditor5_utils_src_dom_setdatainelement__WEBPACK_IMPORTED_MODULE_7__["default"])( this.sourceElement, data );
				}
			} );
	}

	/**
	 * Creates a new inline editor instance.
	 *
	 * There are three general ways how the editor can be initialized.
	 *
	 * # Using an existing DOM element (and loading data from it)
	 *
	 * You can initialize the editor using an existing DOM element:
	 *
	 *		InlineEditor
	 *			.create( document.querySelector( '#editor' ) )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * The element's content will be used as the editor data and the element will become the editable element.
	 *
	 * # Creating a detached editor
	 *
	 * Alternatively, you can initialize the editor by passing the initial data directly as a `String`.
	 * In this case, the editor will render an element that must be inserted into the DOM for the editor to work properly:
	 *
	 *		InlineEditor
	 *			.create( '<p>Hello world!</p>' )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *
	 *				// Initial data was provided so the editor UI element needs to be added manually to the DOM.
	 *				document.body.appendChild( editor.ui.element );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This lets you dynamically append the editor to your web page whenever it is convenient for you. You may use this method if your
	 * web page content is generated on the client side and the DOM structure is not ready at the moment when you initialize the editor.
	 *
	 * # Using an existing DOM element (and data provided in `config.initialData`)
	 *
	 * You can also mix these two ways by providing a DOM element to be used and passing the initial data through the configuration:
	 *
	 *		InlineEditor
	 *			.create( document.querySelector( '#editor' ), {
	 *				initialData: '<h2>Initial data</h2><p>Foo bar.</p>'
	 *			} )
	 *			.then( editor => {
	 *				console.log( 'Editor was initialized', editor );
	 *			} )
	 *			.catch( err => {
	 *				console.error( err.stack );
	 *			} );
	 *
	 * This method can be used to initialize the editor on an existing element with the specified content in case if your integration
	 * makes it difficult to set the content of the source element.
	 *
	 * Note that an error will be thrown if you pass the initial data both as the first parameter and also in the configuration.
	 *
	 * # Configuring the editor
	 *
	 * See the {@link module:core/editor/editorconfig~EditorConfig editor configuration documentation} to learn more about
	 * customizing plugins, toolbar and more.
	 *
	 * # Using the editor from source
	 *
	 * The code samples listed in the previous sections of this documentation assume that you are using an
	 * {@glink builds/guides/overview editor build} (for example – `@ckeditor/ckeditor5-build-inline`).
	 *
	 * If you want to use the inline editor from source (`@ckeditor/ckeditor5-editor-inline/src/inlineeditor`),
	 * you need to define the list of
	 * {@link module:core/editor/editorconfig~EditorConfig#plugins plugins to be initialized} and
	 * {@link module:core/editor/editorconfig~EditorConfig#toolbar toolbar items}. Read more about using the editor from
	 * source in the {@glink builds/guides/integration/advanced-setup "Advanced setup" guide}.
	 *
	 * @param {HTMLElement|String} sourceElementOrData The DOM element that will be the source for the created editor
	 * or the editor's initial data.
	 *
	 * If a DOM element is passed, its content will be automatically loaded to the editor upon initialization.
	 * Moreover, the editor data will be set back to the original element once the editor is destroyed.
	 *
	 * If the initial data is passed, a detached editor will be created. In this case you need to insert it into the DOM manually.
	 * It is available under the {@link module:editor-inline/inlineeditorui~InlineEditorUI#element `editor.ui.element`} property.
	 *
	 * @param {module:core/editor/editorconfig~EditorConfig} [config] The editor configuration.
	 * @returns {Promise} A promise resolved once the editor is ready. The promise resolves with the created editor instance.
	 */
	static create( sourceElementOrData, config = {} ) {
		return new Promise( resolve => {
			const isHTMLElement = Object(lodash_es__WEBPACK_IMPORTED_MODULE_10__["isElement"])( sourceElementOrData );

			if ( isHTMLElement && sourceElementOrData.tagName === 'TEXTAREA' ) {
				// Documented in core/editor/editor.js
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__["default"](
					'editor-wrong-element: This type of editor cannot be initialized inside <textarea> element.', null );
			}

			const editor = new this( sourceElementOrData, config );

			resolve(
				editor.initPlugins()
					.then( () => {
						editor.ui.init();
					} )
					.then( () => {
						if ( !isHTMLElement && config.initialData ) {
							// Documented in core/editor/editorconfig.jdoc.
							throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_11__["default"](
								'editor-create-initial-data: ' +
								'The config.initialData option cannot be used together with initial data passed in Editor.create().',
								null
							);
						}

						const initialData = config.initialData || getInitialData( sourceElementOrData );

						return editor.data.init( initialData );
					} )
					.then( () => editor.fire( 'ready' ) )
					.then( () => editor )
			);
		} );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_9__["default"])( InlineEditor, _ckeditor_ckeditor5_core_src_editor_utils_dataapimixin__WEBPACK_IMPORTED_MODULE_1__["default"] );
Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_9__["default"])( InlineEditor, _ckeditor_ckeditor5_core_src_editor_utils_elementapimixin__WEBPACK_IMPORTED_MODULE_2__["default"] );

function getInitialData( sourceElementOrData ) {
	return Object(lodash_es__WEBPACK_IMPORTED_MODULE_10__["isElement"])( sourceElementOrData ) ? Object(_ckeditor_ckeditor5_utils_src_dom_getdatafromelement__WEBPACK_IMPORTED_MODULE_8__["default"])( sourceElementOrData ) : sourceElementOrData;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditorui.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditorui.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return InlineEditorUI; });
/* harmony import */ var _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-core/src/editor/editorui */ "./node_modules/@ckeditor/ckeditor5-core/src/editor/editorui.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/enabletoolbarkeyboardfocus.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/normalizetoolbarconfig.js");
/* harmony import */ var _ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-engine/src/view/placeholder */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/placeholder.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-inline/inlineeditorui
 */






/**
 * The inline editor UI class.
 *
 * @extends module:core/editor/editorui~EditorUI
 */
class InlineEditorUI extends _ckeditor_ckeditor5_core_src_editor_editorui__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the inline editor UI class.
	 *
	 * @param {module:core/editor/editor~Editor} editor The editor instance.
	 * @param {module:ui/editorui/editoruiview~EditorUIView} view The view of the UI.
	 */
	constructor( editor, view ) {
		super( editor );

		/**
		 * The main (top–most) view of the editor UI.
		 *
		 * @readonly
		 * @member {module:ui/editorui/editoruiview~EditorUIView} #view
		 */
		this.view = view;

		/**
		 * A normalized `config.toolbar` object.
		 *
		 * @type {Object}
		 * @private
		 */
		this._toolbarConfig = Object(_ckeditor_ckeditor5_ui_src_toolbar_normalizetoolbarconfig__WEBPACK_IMPORTED_MODULE_2__["default"])( editor.config.get( 'toolbar' ) );
	}

	/**
	 * @inheritDoc
	 */
	get element() {
		return this.view.editable.element;
	}

	/**
	 * Initializes the UI.
	 */
	init() {
		const editor = this.editor;
		const view = this.view;
		const editingView = editor.editing.view;
		const editable = view.editable;
		const editingRoot = editingView.document.getRoot();

		// The editable UI and editing root should share the same name. Then name is used
		// to recognize the particular editable, for instance in ARIA attributes.
		editable.name = editingRoot.rootName;

		view.render();

		// The editable UI element in DOM is available for sure only after the editor UI view has been rendered.
		// But it can be available earlier if a DOM element has been passed to InlineEditor.create().
		const editableElement = editable.element;

		// Register the editable UI view in the editor. A single editor instance can aggregate multiple
		// editable areas (roots) but the inline editor has only one.
		this.setEditableElement( editable.name, editableElement );

		// Let the global focus tracker know that the editable UI element is focusable and
		// belongs to the editor. From now on, the focus tracker will sustain the editor focus
		// as long as the editable is focused (e.g. the user is typing).
		this.focusTracker.add( editableElement );

		// Let the editable UI element respond to the changes in the global editor focus
		// tracker. It has been added to the same tracker a few lines above but, in reality, there are
		// many focusable areas in the editor, like balloons, toolbars or dropdowns and as long
		// as they have focus, the editable should act like it is focused too (although technically
		// it isn't), e.g. by setting the proper CSS class, visually announcing focus to the user.
		// Doing otherwise will result in editable focus styles disappearing, once e.g. the
		// toolbar gets focused.
		editable.bind( 'isFocused' ).to( this.focusTracker );

		// Bind the editable UI element to the editing view, making it an end– and entry–point
		// of the editor's engine. This is where the engine meets the UI.
		editingView.attachDomRoot( editableElement );

		this._initPlaceholder();
		this._initToolbar();
		this.fire( 'ready' );
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		const view = this.view;
		const editingView = this.editor.editing.view;

		editingView.detachDomRoot( view.editable.name );
		view.destroy();

		super.destroy();
	}

	/**
	 * Initializes the inline editor toolbar and its panel.
	 *
	 * @private
	 */
	_initToolbar() {
		const editor = this.editor;
		const view = this.view;
		const editableElement = view.editable.element;
		const editingView = editor.editing.view;
		const toolbar = view.toolbar;

		// Set–up the view#panel.
		view.panel.bind( 'isVisible' ).to( this.focusTracker, 'isFocused' );

		if ( this._toolbarConfig.viewportTopOffset ) {
			view.viewportTopOffset = this._toolbarConfig.viewportTopOffset;
		}

		// https://github.com/ckeditor/ckeditor5-editor-inline/issues/4
		view.listenTo( editor.ui, 'update', () => {
			// Don't pin if the panel is not already visible. It prevents the panel
			// showing up when there's no focus in the UI.
			if ( view.panel.isVisible ) {
				view.panel.pin( {
					target: editableElement,
					positions: view.panelPositions
				} );
			}
		} );

		toolbar.fillFromConfig( this._toolbarConfig.items, this.componentFactory );

		Object(_ckeditor_ckeditor5_ui_src_toolbar_enabletoolbarkeyboardfocus__WEBPACK_IMPORTED_MODULE_1__["default"])( {
			origin: editingView,
			originFocusTracker: this.focusTracker,
			originKeystrokeHandler: editor.keystrokes,
			toolbar
		} );
	}

	/**
	 * Enable the placeholder text on the editing root, if any was configured.
	 *
	 * @private
	 */
	_initPlaceholder() {
		const editor = this.editor;
		const editingView = editor.editing.view;
		const editingRoot = editingView.document.getRoot();
		const sourceElement = editor.sourceElement;

		const placeholderText = editor.config.get( 'placeholder' ) ||
			sourceElement && sourceElement.tagName.toLowerCase() === 'textarea' && sourceElement.getAttribute( 'placeholder' );

		if ( placeholderText ) {
			Object(_ckeditor_ckeditor5_engine_src_view_placeholder__WEBPACK_IMPORTED_MODULE_3__["enablePlaceholder"])( {
				view: editingView,
				element: editingRoot,
				text: placeholderText,
				isDirectHost: false
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditoruiview.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-editor-inline/src/inlineeditoruiview.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return InlineEditorUIView; });
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editorui/editoruiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editorui/editoruiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview */ "./node_modules/@ckeditor/ckeditor5-ui/src/editableui/inline/inlineeditableuiview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_panel_balloon_balloonpanelview__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/panel/balloon/balloonpanelview */ "./node_modules/@ckeditor/ckeditor5-ui/src/panel/balloon/balloonpanelview.js");
/* harmony import */ var _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-ui/src/toolbar/toolbarview */ "./node_modules/@ckeditor/ckeditor5-ui/src/toolbar/toolbarview.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_rect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/rect */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/rect.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_resizeobserver__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/resizeobserver */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/resizeobserver.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_dom_tounit__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/dom/tounit */ "./node_modules/@ckeditor/ckeditor5-utils/src/dom/tounit.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module editor-inline/inlineeditoruiview
 */









const toPx = Object(_ckeditor_ckeditor5_utils_src_dom_tounit__WEBPACK_IMPORTED_MODULE_6__["default"])( 'px' );

/**
 * Inline editor UI view. Uses an nline editable and a floating toolbar.
 *
 * @extends module:ui/editorui/editoruiview~EditorUIView
 */
class InlineEditorUIView extends _ckeditor_ckeditor5_ui_src_editorui_editoruiview__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an instance of the inline editor UI view.
	 *
	 * @param {module:utils/locale~Locale} locale The {@link module:core/editor/editor~Editor#locale} instance.
	 * @param {module:engine/view/view~View} editingView The editing view instance this view is related to.
	 * @param {HTMLElement} [editableElement] The editable element. If not specified, it will be automatically created by
	 * {@link module:ui/editableui/editableuiview~EditableUIView}. Otherwise, the given element will be used.
	 * @param {Object} [options={}] Configuration options for the view instance.
	 * @param {Boolean} [options.shouldToolbarGroupWhenFull] When set `true` enables automatic items grouping
	 * in the main {@link module:editor-inline/inlineeditoruiview~InlineEditorUIView#toolbar toolbar}.
	 * See {@link module:ui/toolbar/toolbarview~ToolbarOptions#shouldGroupWhenFull} to learn more.
	 */
	constructor( locale, editingView, editableElement, options = {} ) {
		super( locale );

		/**
		 * A floating toolbar view instance.
		 *
		 * @readonly
		 * @member {module:ui/toolbar/toolbarview~ToolbarView}
		 */
		this.toolbar = new _ckeditor_ckeditor5_ui_src_toolbar_toolbarview__WEBPACK_IMPORTED_MODULE_3__["default"]( locale, {
			shouldGroupWhenFull: options.shouldToolbarGroupWhenFull
		} );

		/**
		 * The offset from the top edge of the web browser's viewport which makes the
		 * UI become sticky. The default value is `0`, which means that the UI becomes
		 * sticky when its upper edge touches the top of the page viewport.
		 *
		 * This attribute is useful when the web page has UI elements positioned to the top
		 * either using `position: fixed` or `position: sticky`, which would cover the
		 * UI or vice–versa (depending on the `z-index` hierarchy).
		 *
		 * @readonly
		 * @observable
		 * @member {Number} #viewportTopOffset
		 */
		this.set( 'viewportTopOffset', 0 );

		this.toolbar.extendTemplate( {
			attributes: {
				class: [
					// https://github.com/ckeditor/ckeditor5-editor-inline/issues/11
					'ck-toolbar_floating'
				]
			}
		} );

		/**
		 * A balloon panel view instance.
		 *
		 * @readonly
		 * @member {module:ui/panel/balloon/balloonpanelview~BalloonPanelView}
		 */
		this.panel = new _ckeditor_ckeditor5_ui_src_panel_balloon_balloonpanelview__WEBPACK_IMPORTED_MODULE_2__["default"]( locale );

		this.panel.withArrow = false;

		/**
		 * A set of positioning functions used by the {@link #panel} to float around
		 * {@link #element editableElement}.
		 *
		 * The positioning functions are as follows:
		 *
		 * * West:
		 *
		 *		[ Panel ]
		 *		+------------------+
		 *		| #editableElement |
		 *		+------------------+
		 *
		 *		+------------------+
		 *		| #editableElement |
		 *		|[ Panel ]         |
		 *		|                  |
		 *		+------------------+
		 *
		 *		+------------------+
		 *		| #editableElement |
		 *		+------------------+
		 *		[ Panel ]
		 *
		 * * East:
		 *
		 *		           [ Panel ]
		 *		+------------------+
		 *		| #editableElement |
		 *		+------------------+
		 *
		 *		+------------------+
		 *		| #editableElement |
		 *		|         [ Panel ]|
		 *		|                  |
		 *		+------------------+
		 *
		 *		+------------------+
		 *		| #editableElement |
		 *		+------------------+
		 *		           [ Panel ]
		 *
		 * See: {@link module:utils/dom/position~Options#positions}.
		 *
		 * @readonly
		 * @type {Array.<Function>}
		 */
		this.panelPositions = this._getPanelPositions();

		this.panel.extendTemplate( {
			attributes: {
				class: 'ck-toolbar-container'
			}
		} );

		/**
		 * Editable UI view.
		 *
		 * @readonly
		 * @member {module:ui/editableui/inline/inlineeditableuiview~InlineEditableUIView}
		 */
		this.editable = new _ckeditor_ckeditor5_ui_src_editableui_inline_inlineeditableuiview__WEBPACK_IMPORTED_MODULE_1__["default"]( locale, editingView, editableElement );

		/**
		 * An instance of the resize observer that helps dynamically determine the geometry of the toolbar
		 * and manage items that do not fit into a single row.
		 *
		 * **Note:** Created in {@link #render}.
		 *
		 * @private
		 * @member {module:utils/dom/resizeobserver~ResizeObserver}
		 */
		this._resizeObserver = null;
	}

	/**
	 * @inheritDoc
	 */
	render() {
		super.render();

		this.body.add( this.panel );
		this.registerChild( this.editable );
		this.panel.content.add( this.toolbar );

		const options = this.toolbar.options;

		// Set toolbar's max-width on the initialization and update it on the editable resize,
		// if 'shouldToolbarGroupWhenFull' in config is set to 'true'.
		if ( options.shouldGroupWhenFull ) {
			const editableElement = this.editable.element;

			this._resizeObserver = new _ckeditor_ckeditor5_utils_src_dom_resizeobserver__WEBPACK_IMPORTED_MODULE_5__["default"]( editableElement, () => {
				this.toolbar.maxWidth = toPx( new _ckeditor_ckeditor5_utils_src_dom_rect__WEBPACK_IMPORTED_MODULE_4__["default"]( editableElement ).width );
			} );
		}
	}

	/**
	 * @inheritDoc
	 */
	destroy() {
		super.destroy();

		if ( this._resizeObserver ) {
			this._resizeObserver.destroy();
		}
	}

	/**
	 * Determines the panel top position of the {@link #panel} in {@link #panelPositions}.
	 *
	 * @private
	 * @param {module:utils/dom/rect~Rect} editableRect Rect of the {@link #element}.
	 * @param {module:utils/dom/rect~Rect} panelRect Rect of the {@link #panel}.
	 */
	_getPanelPositionTop( editableRect, panelRect ) {
		let top;

		if ( editableRect.top > panelRect.height + this.viewportTopOffset ) {
			top = editableRect.top - panelRect.height;
		} else if ( editableRect.bottom > panelRect.height + this.viewportTopOffset + 50 ) {
			top = this.viewportTopOffset;
		} else {
			top = editableRect.bottom;
		}

		return top;
	}

	/**
	 * Returns the positions for {@link #panelPositions}.
	 *
	 * See: {@link module:utils/dom/position~Options#positions}.
	 *
	 * @private
	 * @returns {Array.<Function>}
	 */
	_getPanelPositions() {
		const positions = [
			( editableRect, panelRect ) => {
				return {
					top: this._getPanelPositionTop( editableRect, panelRect ),
					left: editableRect.left,
					name: 'toolbar_west'
				};
			},
			( editableRect, panelRect ) => {
				return {
					top: this._getPanelPositionTop( editableRect, panelRect ),
					left: editableRect.left + editableRect.width - panelRect.width,
					name: 'toolbar_east'
				};
			}
		];

		if ( this.locale.uiLanguageDirection === 'ltr' ) {
			return positions;
		} else {
			return positions.reverse();
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/controller/datacontroller.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DataController; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _conversion_mapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../conversion/mapper */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js");
/* harmony import */ var _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../conversion/downcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js");
/* harmony import */ var _conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../conversion/downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/* harmony import */ var _conversion_upcastdispatcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../conversion/upcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js");
/* harmony import */ var _conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../conversion/upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/* harmony import */ var _view_documentfragment__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../view/documentfragment */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/documentfragment.js");
/* harmony import */ var _view_document__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../view/document */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/document.js");
/* harmony import */ var _view_downcastwriter__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../view/downcastwriter */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/downcastwriter.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/controller/datacontroller
 */



















/**
 * Controller for the data pipeline. The data pipeline controls how data is retrieved from the document
 * and set inside it. Hence, the controller features two methods which allow to {@link ~DataController#get get}
 * and {@link ~DataController#set set} data of the {@link ~DataController#model model}
 * using given:
 *
 * * {@link module:engine/dataprocessor/dataprocessor~DataProcessor data processor},
 * * downcast converters,
 * * upcast converters.
 *
 * An instance of the data controller is always available in the {@link module:core/editor/editor~Editor#data `editor.data`}
 * property:
 *
 *		editor.data.get( { rootName: 'customRoot' } ); // -> '<p>Hello!</p>'
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class DataController {
	/**
	 * Creates a data controller instance.
	 *
	 * @param {module:engine/model/model~Model} model Data model.
	 * @param {module:engine/view/stylesmap~StylesProcessor} stylesProcessor The styles processor instance.
	 */
	constructor( model, stylesProcessor ) {
		/**
		 * Data model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * Styles processor used during the conversion.
		 *
		 * @readonly
		 * @member {module:engine/view/stylesmap~StylesProcessor}
		 */
		this.stylesProcessor = stylesProcessor;

		/**
		 * Data processor used during the conversion.
		 *
		 * @member {module:engine/dataprocessor/dataprocessor~DataProcessor} #processor
		 */
		this.processor;

		/**
		 * Mapper used for the conversion. It has no permanent bindings, because they are created when getting data and
		 * cleared directly after the data are converted. However, the mapper is defined as a class property, because
		 * it needs to be passed to the `DowncastDispatcher` as a conversion API.
		 *
		 * @readonly
		 * @member {module:engine/conversion/mapper~Mapper}
		 */
		this.mapper = new _conversion_mapper__WEBPACK_IMPORTED_MODULE_3__["default"]();

		/**
		 * Downcast dispatcher used by the {@link #get get method}. Downcast converters should be attached to it.
		 *
		 * @readonly
		 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher}
		 */
		this.downcastDispatcher = new _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_4__["default"]( {
			mapper: this.mapper,
			schema: model.schema
		} );
		this.downcastDispatcher.on( 'insert:$text', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_5__["insertText"])(), { priority: 'lowest' } );

		/**
		 * Upcast dispatcher used by the {@link #set set method}. Upcast converters should be attached to it.
		 *
		 * @readonly
		 * @member {module:engine/conversion/upcastdispatcher~UpcastDispatcher}
		 */
		this.upcastDispatcher = new _conversion_upcastdispatcher__WEBPACK_IMPORTED_MODULE_6__["default"]( {
			schema: model.schema
		} );

		/**
		 * The view document used by the data controller.
		 *
		 * @readonly
		 * @member {module:engine/view/document~Document}
		 */
		this.viewDocument = new _view_document__WEBPACK_IMPORTED_MODULE_9__["default"]( stylesProcessor );

		/**
		 * The view downcast writer just for data conversion purposes, i.e. to modify
		 * the {@link #viewDocument}.
		 *
		 * @private
		 * @readonly
		 * @member {module:engine/view/downcastwriter~DowncastWriter}
		 */
		this._viewWriter = new _view_downcastwriter__WEBPACK_IMPORTED_MODULE_10__["default"]( this.viewDocument );

		// Define default converters for text and elements.
		//
		// Note that if there is no default converter for the element it will be skipped, for instance `<b>foo</b>` will be
		// converted to nothing. We add `convertToModelFragment` as a last converter so it converts children of that
		// element to the document fragment so `<b>foo</b>` will be converted to `foo` if there is no converter for `<b>`.
		this.upcastDispatcher.on( 'text', Object(_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__["convertText"])(), { priority: 'lowest' } );
		this.upcastDispatcher.on( 'element', Object(_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__["convertToModelFragment"])(), { priority: 'lowest' } );
		this.upcastDispatcher.on( 'documentFragment', Object(_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__["convertToModelFragment"])(), { priority: 'lowest' } );

		this.decorate( 'init' );
		this.decorate( 'set' );

		// Fire `ready` event when initialisation has completed. Such low level listener gives possibility
		// to plug into initialisation pipeline without interrupting the initialisation flow.
		this.on( 'init', () => {
			this.fire( 'ready' );
		}, { priority: 'lowest' } );
	}

	/**
	 * Returns the model's data converted by downcast dispatchers attached to {@link #downcastDispatcher} and
	 * formatted by the {@link #processor data processor}.
	 *
	 * @param {Object} [options]
	 * @param {String} [options.rootName='main'] Root name.
	 * @param {String} [options.trim='empty'] Whether returned data should be trimmed. This option is set to `empty` by default,
	 * which means whenever editor content is considered empty, an empty string will be returned. To turn off trimming completely
	 * use `'none'`. In such cases exact content will be returned (for example `<p>&nbsp;</p>` for an empty editor).
	 * @returns {String} Output data.
	 */
	get( options ) {
		const { rootName = 'main', trim = 'empty' } = options || {};

		if ( !this._checkIfRootsExists( [ rootName ] ) ) {
			/**
			 * Cannot get data from a non-existing root. This error is thrown when {@link #get DataController#get() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #get} like:
			 *
			 *		data.get( { rootName: 'root2' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-get-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-get-non-existent-root: Attempting to get data from a non-existing root.', this );
		}

		const root = this.model.document.getRoot( rootName );

		if ( trim === 'empty' && !this.model.hasContent( root, { ignoreWhitespaces: true } ) ) {
			return '';
		}

		return this.stringify( root );
	}

	/**
	 * Returns the content of the given {@link module:engine/model/element~Element model's element} or
	 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment} converted by the downcast converters
	 * attached to {@link #downcastDispatcher} and formatted by the {@link #processor data processor}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} modelElementOrFragment
	 * Element whose content will be stringified.
	 * @returns {String} Output data.
	 */
	stringify( modelElementOrFragment ) {
		// Model -> view.
		const viewDocumentFragment = this.toView( modelElementOrFragment );

		// View -> data.
		return this.processor.toData( viewDocumentFragment );
	}

	/**
	 * Returns the content of the given {@link module:engine/model/element~Element model element} or
	 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment} converted by the downcast
	 * converters attached to {@link #downcastDispatcher} to a
	 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} modelElementOrFragment
	 * Element or document fragment whose content will be converted.
	 * @returns {module:engine/view/documentfragment~DocumentFragment} Output view DocumentFragment.
	 */
	toView( modelElementOrFragment ) {
		const viewDocument = this.viewDocument;
		const viewWriter = this._viewWriter;

		// Clear bindings so the call to this method gives correct results.
		this.mapper.clearBindings();

		// First, convert elements.
		const modelRange = _model_range__WEBPACK_IMPORTED_MODULE_11__["default"]._createIn( modelElementOrFragment );
		const viewDocumentFragment = new _view_documentfragment__WEBPACK_IMPORTED_MODULE_8__["default"]( viewDocument );

		this.mapper.bindElements( modelElementOrFragment, viewDocumentFragment );

		// We have no view controller and rendering do DOM in DataController so view.change() block is not used here.
		this.downcastDispatcher.convertInsert( modelRange, viewWriter );

		if ( !modelElementOrFragment.is( 'documentFragment' ) ) {
			// Then, if a document element is converted, convert markers.
			// From all document markers, get those, which "intersect" with the converter element.
			const markers = _getMarkersRelativeToElement( modelElementOrFragment );

			for ( const [ name, range ] of markers ) {
				this.downcastDispatcher.convertMarkerAdd( name, range, viewWriter );
			}
		}

		return viewDocumentFragment;
	}

	/**
	 * Sets initial input data parsed by the {@link #processor data processor} and
	 * converted by the {@link #upcastDispatcher view-to-model converters}.
	 * Initial data can be set only to document that {@link module:engine/model/document~Document#version} is equal 0.
	 *
	 * **Note** This method is {@link module:utils/observablemixin~ObservableMixin#decorate decorated} which is
	 * used by e.g. collaborative editing plugin that syncs remote data on init.
	 *
	 * When data is passed as a string it is initialized on a default `main` root:
	 *
	 *		dataController.init( '<p>Foo</p>' ); // Initializes data on the `main` root.
	 *
	 * To initialize data on a different root or multiple roots at once, object containing `rootName` - `data` pairs should be passed:
	 *
	 *		dataController.init( { main: '<p>Foo</p>', title: '<h1>Bar</h1>' } ); // Initializes data on the `main` and `title` roots.
	 *
	 * @fires init
	 * @param {String|Object.<String,String>} data Input data as a string or an object containing `rootName` - `data`
	 * pairs to initialize data on multiple roots at once.
	 * @returns {Promise} Promise that is resolved after the data is set on the editor.
	 */
	init( data ) {
		if ( this.model.document.version ) {
			/**
			 * Cannot set initial data to not empty {@link module:engine/model/document~Document}.
			 * Initial data should be set once, during {@link module:core/editor/editor~Editor} initialization,
			 * when the {@link module:engine/model/document~Document#version} is equal 0.
			 *
			 * @error datacontroller-init-document-not-empty
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-init-document-not-empty: Trying to set initial data to not empty document.', this );
		}

		let initialData = {};
		if ( typeof data === 'string' ) {
			initialData.main = data; // Default root is 'main'. To initiate data on a different root, object should be passed.
		} else {
			initialData = data;
		}

		if ( !this._checkIfRootsExists( Object.keys( initialData ) ) ) {
			/**
			 * Cannot init data on a non-existing root. This error is thrown when {@link #init DataController#init() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #init} like:
			 *
			 * 		data.init( { main: '<p>Foo</p>', root2: '<p>Bar</p>' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-init-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-init-non-existent-root: Attempting to init data on a non-existing root.', this );
		}

		this.model.enqueueChange( 'transparent', writer => {
			for ( const rootName of Object.keys( initialData ) ) {
				const modelRoot = this.model.document.getRoot( rootName );
				writer.insert( this.parse( initialData[ rootName ], modelRoot ), modelRoot, 0 );
			}
		} );

		return Promise.resolve();
	}

	/**
	 * Sets input data parsed by the {@link #processor data processor} and
	 * converted by the {@link #upcastDispatcher view-to-model converters}.
	 * This method can be used any time to replace existing editor data by the new one without clearing the
	 * {@link module:engine/model/document~Document#history document history}.
	 *
	 * This method also creates a batch with all the changes applied. If all you need is to parse data, use
	 * the {@link #parse} method.
	 *
	 * When data is passed as a string it is set on a default `main` root:
	 *
	 *		dataController.set( '<p>Foo</p>' ); // Sets data on the `main` root.
	 *
	 * To set data on a different root or multiple roots at once, object containing `rootName` - `data` pairs should be passed:
	 *
	 *		dataController.set( { main: '<p>Foo</p>', title: '<h1>Bar</h1>' } ); // Sets data on the `main` and `title` roots.
	 *
	 * @fires set
	 * @param {String|Object.<String,String>} data Input data as a string or an object containing `rootName` - `data`
	 * pairs to set data on multiple roots at once.
	 */
	set( data ) {
		let newData = {};

		if ( typeof data === 'string' ) {
			newData.main = data; // Default root is 'main'. To set data on a different root, object should be passed.
		} else {
			newData = data;
		}

		if ( !this._checkIfRootsExists( Object.keys( newData ) ) ) {
			/**
			 * Cannot set data on a non-existing root. This error is thrown when {@link #set DataController#set() method}
			 * is called with non-existent root name. For example, if there is an editor instance with only `main` root,
			 * calling {@link #set} like:
			 *
			 * 		data.set( { main: '<p>Foo</p>', root2: '<p>Bar</p>' } );
			 *
			 * will throw this error.
			 *
			 * @error datacontroller-set-non-existent-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'datacontroller-set-non-existent-root: Attempting to set data on a non-existing root.', this );
		}

		this.model.enqueueChange( 'transparent', writer => {
			writer.setSelection( null );
			writer.removeSelectionAttribute( this.model.document.selection.getAttributeKeys() );

			for ( const rootName of Object.keys( newData ) ) {
				// Save to model.
				const modelRoot = this.model.document.getRoot( rootName );

				writer.remove( writer.createRangeIn( modelRoot ) );
				writer.insert( this.parse( newData[ rootName ], modelRoot ), modelRoot, 0 );
			}
		} );
	}

	/**
	 * Returns the data parsed by the {@link #processor data processor} and then converted by upcast converters
	 * attached to the {@link #upcastDispatcher}.
	 *
	 * @see #set
	 * @param {String} data Data to parse.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context='$root'] Base context in which the view will
	 * be converted to the model. See: {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#convert}.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Parsed data.
	 */
	parse( data, context = '$root' ) {
		// data -> view
		const viewDocumentFragment = this.processor.toView( data );

		// view -> model
		return this.toModel( viewDocumentFragment, context );
	}

	/**
	 * Returns the result of the given {@link module:engine/view/element~Element view element} or
	 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment} converted by the
	 * {@link #upcastDispatcher view-to-model converters}, wrapped by {@link module:engine/model/documentfragment~DocumentFragment}.
	 *
	 * When marker elements were converted during the conversion process, it will be set as a document fragment's
	 * {@link module:engine/model/documentfragment~DocumentFragment#markers static markers map}.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/documentfragment~DocumentFragment} viewElementOrFragment
	 * Element or document fragment whose content will be converted.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context='$root'] Base context in which the view will
	 * be converted to the model. See: {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#convert}.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Output document fragment.
	 */
	toModel( viewElementOrFragment, context = '$root' ) {
		return this.model.change( writer => {
			return this.upcastDispatcher.convert( viewElementOrFragment, writer, context );
		} );
	}

	/**
	 * Adds a style processor normalization rules.
	 *
	 * You can implement your own rules as well as use one of the available processor rules:
	 *
	 * * background: {@link module:engine/view/styles/background~addBackgroundRules}
	 * * border: {@link module:engine/view/styles/border~addBorderRules}
	 * * margin: {@link module:engine/view/styles/margin~addMarginRules}
	 * * padding: {@link module:engine/view/styles/padding~addPaddingRules}
	 *
	 * @param {Function} callback
	 */
	addStyleProcessorRules( callback ) {
		callback( this.stylesProcessor );
	}

	/**
	 * Removes all event listeners set by the DataController.
	 */
	destroy() {
		this.stopListening();
	}

	/**
	 * Checks if all provided root names are existing editor roots.
	 *
	 * @private
	 * @param {Array.<String>} rootNames Root names to check.
	 * @returns {Boolean} Whether all provided root names are existing editor roots.
	 */
	_checkIfRootsExists( rootNames ) {
		for ( const rootName of rootNames ) {
			if ( !this.model.document.getRootNames().includes( rootName ) ) {
				return false;
			}
		}

		return true;
	}

	/**
	 * Event fired once data initialisation has finished.
	 *
	 * @event ready
	 */

	/**
	 * Event fired after {@link #init init() method} has been run. It can be {@link #listenTo listened to} to adjust/modify
	 * the initialisation flow. However, if the `init` event is stopped or prevented, the {@link #event:ready ready event}
	 * should be fired manually.
	 *
	 * The `init` event is fired by decorated {@link #init} method.
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * @event init
	 */

	/**
	 * Event fired after {@link #set set() method} has been run.
	 *
	 * The `set` event is fired by decorated {@link #set} method.
	 * See {@link module:utils/observablemixin~ObservableMixin#decorate} for more information and samples.
	 *
	 * @event set
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( DataController, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

// Helper function for downcast conversion.
//
// Takes a document element (element that is added to a model document) and checks which markers are inside it
// and which markers are containing it. If the marker is intersecting with element, the intersection is returned.
function _getMarkersRelativeToElement( element ) {
	const result = [];
	const doc = element.root.document;

	if ( !doc ) {
		return [];
	}

	const elementRange = _model_range__WEBPACK_IMPORTED_MODULE_11__["default"]._createIn( element );

	for ( const marker of doc.model.markers ) {
		const intersection = elementRange.getIntersection( marker.getRange() );

		if ( intersection ) {
			result.push( [ marker.name, intersection ] );
		}
	}

	return result;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/controller/editingcontroller.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EditingController; });
/* harmony import */ var _view_rooteditableelement__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../view/rooteditableelement */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/rooteditableelement.js");
/* harmony import */ var _view_view__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../view/view */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/view.js");
/* harmony import */ var _conversion_mapper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../conversion/mapper */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js");
/* harmony import */ var _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../conversion/downcastdispatcher */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js");
/* harmony import */ var _conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../conversion/downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../conversion/upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/controller/editingcontroller
 */











// @if CK_DEBUG_ENGINE // const { dumpTrees, initDocumentDumping } = require( '../dev-utils/utils' );

/**
 * Controller for the editing pipeline. The editing pipeline controls {@link ~EditingController#model model} rendering,
 * including selection handling. It also creates the {@link ~EditingController#view view} which builds a
 * browser-independent virtualization over the DOM elements. The editing controller also attaches default converters.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class EditingController {
	/**
	 * Creates an editing controller instance.
	 *
	 * @param {module:engine/model/model~Model} model Editing model.
	 * @param {module:engine/view/stylesmap~StylesProcessor} stylesProcessor The styles processor instance.
	 */
	constructor( model, stylesProcessor ) {
		/**
		 * Editor model.
		 *
		 * @readonly
		 * @member {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * Editing view controller.
		 *
		 * @readonly
		 * @member {module:engine/view/view~View}
		 */
		this.view = new _view_view__WEBPACK_IMPORTED_MODULE_1__["default"]( stylesProcessor );

		/**
		 * Mapper which describes the model-view binding.
		 *
		 * @readonly
		 * @member {module:engine/conversion/mapper~Mapper}
		 */
		this.mapper = new _conversion_mapper__WEBPACK_IMPORTED_MODULE_2__["default"]();

		/**
		 * Downcast dispatcher that converts changes from the model to {@link #view the editing view}.
		 *
		 * @readonly
		 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher} #downcastDispatcher
		 */
		this.downcastDispatcher = new _conversion_downcastdispatcher__WEBPACK_IMPORTED_MODULE_3__["default"]( {
			mapper: this.mapper,
			schema: model.schema
		} );

		const doc = this.model.document;
		const selection = doc.selection;
		const markers = this.model.markers;

		// When plugins listen on model changes (on selection change, post fixers, etc) and change the view as a result of
		// model's change, they might trigger view rendering before the conversion is completed (e.g. before the selection
		// is converted). We disable rendering for the length of the outermost model change() block to prevent that.
		//
		// See https://github.com/ckeditor/ckeditor5-engine/issues/1528
		this.listenTo( this.model, '_beforeChanges', () => {
			this.view._disableRendering( true );
		}, { priority: 'highest' } );

		this.listenTo( this.model, '_afterChanges', () => {
			this.view._disableRendering( false );
		}, { priority: 'lowest' } );

		// Whenever model document is changed, convert those changes to the view (using model.Document#differ).
		// Do it on 'low' priority, so changes are converted after other listeners did their job.
		// Also convert model selection.
		this.listenTo( doc, 'change', () => {
			this.view.change( writer => {
				this.downcastDispatcher.convertChanges( doc.differ, markers, writer );
				this.downcastDispatcher.convertSelection( selection, markers, writer );
			} );
		}, { priority: 'low' } );

		// Convert selection from the view to the model when it changes in the view.
		this.listenTo( this.view.document, 'selectionChange', Object(_conversion_upcasthelpers__WEBPACK_IMPORTED_MODULE_7__["convertSelectionChange"])( this.model, this.mapper ) );

		// Attach default model converters.
		this.downcastDispatcher.on( 'insert:$text', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__["insertText"])(), { priority: 'lowest' } );
		this.downcastDispatcher.on( 'remove', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__["remove"])(), { priority: 'low' } );

		// Attach default model selection converters.
		this.downcastDispatcher.on( 'selection', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__["clearAttributes"])(), { priority: 'low' } );
		this.downcastDispatcher.on( 'selection', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__["convertRangeSelection"])(), { priority: 'low' } );
		this.downcastDispatcher.on( 'selection', Object(_conversion_downcasthelpers__WEBPACK_IMPORTED_MODULE_4__["convertCollapsedSelection"])(), { priority: 'low' } );

		// Binds {@link module:engine/view/document~Document#roots view roots collection} to
		// {@link module:engine/model/document~Document#roots model roots collection} so creating
		// model root automatically creates corresponding view root.
		this.view.document.roots.bindTo( this.model.document.roots ).using( root => {
			// $graveyard is a special root that has no reflection in the view.
			if ( root.rootName == '$graveyard' ) {
				return null;
			}

			const viewRoot = new _view_rooteditableelement__WEBPACK_IMPORTED_MODULE_0__["default"]( this.view.document, root.name );

			viewRoot.rootName = root.rootName;
			this.mapper.bindElements( root, viewRoot );

			return viewRoot;
		} );

		// @if CK_DEBUG_ENGINE // initDocumentDumping( this.model.document );
		// @if CK_DEBUG_ENGINE // initDocumentDumping( this.view.document );

		// @if CK_DEBUG_ENGINE // dumpTrees( this.model.document, this.model.document.version );
		// @if CK_DEBUG_ENGINE // dumpTrees( this.view.document, this.model.document.version );

		// @if CK_DEBUG_ENGINE // this.model.document.on( 'change', () => {
		// @if CK_DEBUG_ENGINE //	dumpTrees( this.view.document, this.model.document.version );
		// @if CK_DEBUG_ENGINE // }, { priority: 'lowest' } );
	}

	/**
	 * Removes all event listeners attached to the `EditingController`. Destroys all objects created
	 * by `EditingController` that need to be destroyed.
	 */
	destroy() {
		this.view.destroy();
		this.stopListening();
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( EditingController, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversion.js ***!
  \******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Conversion; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _upcasthelpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./upcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js");
/* harmony import */ var _downcasthelpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./downcasthelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/conversion
 */





/**
 * A utility class that helps add converters to upcast and downcast dispatchers.
 *
 * We recommend reading the {@glink framework/guides/architecture/editing-engine Editing engine architecture} guide first to
 * understand the core concepts of the conversion mechanisms.
 *
 * An instance of the conversion manager is available in the
 * {@link module:core/editor/editor~Editor#conversion `editor.conversion`} property
 * and by default has the following groups of dispatchers (i.e. directions of conversion):
 *
 * * `downcast` (editing and data downcasts)
 * * `editingDowncast`
 * * `dataDowncast`
 * * `upcast`
 *
 * # One-way converters
 *
 * To add a converter to a specific group, use the {@link module:engine/conversion/conversion~Conversion#for `for()`}
 * method:
 *
 *		// Add a converter to editing downcast and data downcast.
 *		editor.conversion.for( 'downcast' ).elementToElement( config ) );
 *
 *		// Add a converter to the data pipepline only:
 *		editor.conversion.for( 'dataDowncast' ).elementToElement( dataConversionConfig ) );
 *
 *		// And a slightly different one for the editing pipeline:
 *		editor.conversion.for( 'editingDowncast' ).elementToElement( editingConversionConfig ) );
 *
 * See {@link module:engine/conversion/conversion~Conversion#for `for()`} method documentation to learn more about
 * available conversion helpers and how to use your custom ones.
 *
 * # Two-way converters
 *
 * Besides using one-way converters via the `for()` method, you can also use other methods available in this
 * class to add two-way converters (upcast and downcast):
 *
 * * {@link module:engine/conversion/conversion~Conversion#elementToElement `elementToElement()`} &ndash;
 * Model element to view element and vice versa.
 * * {@link module:engine/conversion/conversion~Conversion#attributeToElement `attributeToElement()`} &ndash;
 * Model attribute to view element and vice versa.
 * * {@link module:engine/conversion/conversion~Conversion#attributeToAttribute `attributeToAttribute()`} &ndash;
 * Model attribute to view element and vice versa.
 */
class Conversion {
	/**
	 * Creates a new conversion instance.
	 *
	 * @param {module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher>} downcastDispatchers
	 * @param {module:engine/conversion/upcastdispatcher~UpcastDispatcher|
	 * Array.<module:engine/conversion/upcastdispatcher~UpcastDispatcher>} upcastDispatchers
	 */
	constructor( downcastDispatchers, upcastDispatchers ) {
		/**
		 * Maps dispatchers group name to ConversionHelpers instances.
		 *
		 * @private
		 * @member {Map.<String,module:engine/conversion/conversionhelpers~ConversionHelpers>}
		 */
		this._helpers = new Map();

		// Define default 'downcast' & 'upcast' dispatchers groups. Those groups are always available as two-way converters needs them.
		this._downcast = Array.isArray( downcastDispatchers ) ? downcastDispatchers : [ downcastDispatchers ];
		this._createConversionHelpers( { name: 'downcast', dispatchers: this._downcast, isDowncast: true } );

		this._upcast = Array.isArray( upcastDispatchers ) ? upcastDispatchers : [ upcastDispatchers ];
		this._createConversionHelpers( { name: 'upcast', dispatchers: this._upcast, isDowncast: false } );
	}

	/**
	 * Define an alias for registered dispatcher.
	 *
	 *		const conversion = new Conversion(
	 *			[ dataDowncastDispatcher, editingDowncastDispatcher ],
	 *			upcastDispatcher
	 *		);
	 *
	 *		conversion.addAlias( 'dataDowncast', dataDowncastDispatcher );
	 *
	 * @param {String} alias An alias of a dispatcher.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher} dispatcher Dispatcher which should have an alias.
	 */
	addAlias( alias, dispatcher ) {
		const isDowncast = this._downcast.includes( dispatcher );
		const isUpcast = this._upcast.includes( dispatcher );

		if ( !isUpcast && !isDowncast ) {
			/**
			 * Trying to register and alias for a dispatcher that nas not been registered.
			 *
			 * @error conversion-add-alias-dispatcher-not-registered
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"](
				'conversion-add-alias-dispatcher-not-registered: ' +
				'Trying to register and alias for a dispatcher that nas not been registered.',
				this
			);
		}

		this._createConversionHelpers( { name: alias, dispatchers: [ dispatcher ], isDowncast } );
	}

	/**
	 * Provides a chainable API to assign converters to conversion dispatchers group.
	 *
	 * If the given group name has not been registered, the
	 * {@link module:utils/ckeditorerror~CKEditorError `conversion-for-unknown-group` error} is thrown.
	 *
	 * You can use conversion helpers available directly in the `for()` chain or your custom ones via
	 * the {@link module:engine/conversion/conversionhelpers~ConversionHelpers#add `add()`} method.
	 *
	 * # Using bulit-in conversion helpers
	 *
	 * The `for()` chain comes with a set of conversion helpers which you can use like this:
	 *
	 *		editor.conversion.for( 'downcast' )
	 *			.elementToElement( config1 )        // Adds an element-to-element downcast converter.
	 *			.attributeToElement( config2 );     // Adds an attribute-to-element downcast converter.
	 *
	 *		editor.conversion.for( 'upcast' )
	 *			.elementToAttribute( config3 );     // Adds an element-to-attribute upcast converter.
	 *
	 * Refer to the documentation of built-in conversion helpers to learn about their configuration options.
	 *
	 * * downcast (model-to-view) conversion helpers:
	 *
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#elementToElement `elementToElement()`},
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#attributeToElement `attributeToElement()`},
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#attributeToAttribute `attributeToAttribute()`}.
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToElement `markerToElement()`}.
	 *	* {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToHighlight `markerToHighlight()`}.
	 *
	 * * upcast (view-to-model) conversion helpers:
	 *
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToElement `elementToElement()`},
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToAttribute `elementToAttribute()`},
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#attributeToAttribute `attributeToAttribute()`}.
	 *	* {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToMarker `elementToMarker()`}.
	 *
	 * # Using custom conversion helpers
	 *
	 * If you need to implement a nontypical converter, you can do so by calling:
	 *
	 *		editor.conversion.for( direction ).add( customHelper );
	 *
	 * The `.add()` method takes exactly one parameter, which is a function. This function should accept one parameter that
	 * is a dispatcher instance. The function should add an actual converter to the passed dispatcher instance.
	 *
	 * Example:
	 *
	 *		editor.conversion.for( 'upcast' ).add( dispatcher => {
	 *			dispatcher.on( 'element:a',  ( evt, data, conversionApi ) => {
	 *				// Do something with a view <a> element.
	 *			} );
	 *		} );
	 *
	 * Refer to the documentation of {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher}
	 * and {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} to learn how to write
	 * custom converters.
	 *
	 * @param {String} groupName The name of dispatchers group to add the converters to.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers|module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	for( groupName ) {
		if ( !this._helpers.has( groupName ) ) {
			/**
			 * Trying to add a converter to an unknown dispatchers group.
			 *
			 * @error conversion-for-unknown-group
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'conversion-for-unknown-group: Trying to add a converter to an unknown dispatchers group.', this );
		}

		return this._helpers.get( groupName );
	}

	/**
	 * Sets up converters between the model and the view that convert a model element to a view element (and vice versa).
	 * For example, the model `<paragraph>Foo</paragraph>` is `<p>Foo</p>` in the view.
	 *
	 *		// A simple conversion from the `paragraph` model element to the `<p>` view element (and vice versa).
	 *		editor.conversion.elementToElement( { model: 'paragraph', view: 'p' } );
	 *
	 *		// Override other converters by specifying a converter definition with a higher priority.
	 *		editor.conversion.elementToElement( { model: 'paragraph', view: 'div', converterPriority: 'high' } );
	 *
	 *		// View specified as an object instead of a string.
	 *		editor.conversion.elementToElement( {
	 *			model: 'fancyParagraph',
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			}
	 *		} );
	 *
	 *		// Use `upcastAlso` to define other view elements that should also be converted to a `paragraph` element.
	 *		editor.conversion.elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'p',
	 *			upcastAlso: [
	 *				'div',
	 *				{
	 *					// Any element with the `display: block` style.
	 *					styles: {
	 *						display: 'block'
	 *					}
	 *				}
	 *			]
	 *		} );
	 *
	 *		// `upcastAlso` set as callback enables a conversion of a wide range of different view elements.
	 *		editor.conversion.elementToElement( {
	 *			model: 'heading',
	 *			view: 'h2',
	 *			// Convert "headling-like" paragraphs to headings.
	 *			upcastAlso: viewElement => {
	 *				const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *				if ( !fontSize ) {
	 *					return null;
	 *				}
	 *
	 *				const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *				if ( !match ) {
	 *					return null;
	 *				}
	 *
	 *				const size = Number( match[ 1 ] );
	 *
	 *				if ( size > 26 ) {
	 *					// Returned value can be an object with the matched properties.
	 *					// These properties will be "consumed" during the conversion.
	 *					// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *					return { name: true, styles: [ 'font-size' ] };
	 *				}
	 *
	 *				return null;
	 *			}
	 *		} );
	 *
	 * `definition.model` is a `String` with a model element name to convert from or to.
	 * See {@link module:engine/conversion/conversion~ConverterDefinition} to learn about other parameters.
	 *
	 * @param {module:engine/conversion/conversion~ConverterDefinition} definition The converter definition.
	 */
	elementToElement( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).elementToElement( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.elementToElement( {
					model,
					view,
					converterPriority: definition.converterPriority
				} );
		}
	}

	/**
	 * Sets up converters between the model and the view that convert a model attribute to a view element (and vice versa).
	 * For example, a model text node with `"Foo"` as data and the `bold` attribute is `<strong>Foo</strong>` in the view.
	 *
	 *		// A simple conversion from the `bold=true` attribute to the `<strong>` view element (and vice versa).
	 *		editor.conversion.attributeToElement( { model: 'bold', view: 'strong' } );
	 *
	 *		// Override other converters by specifying a converter definition with a higher priority.
	 *		editor.conversion.attributeToElement( { model: 'bold', view: 'b', converterPriority: 'high' } );
	 *
	 *		// View specified as an object instead of a string.
	 *		editor.conversion.attributeToElement( {
	 *			model: 'bold',
	 *			view: {
	 *				name: 'span',
	 *				classes: 'bold'
	 *			}
	 *		} );
	 *
	 *		// Use `config.model.name` to define the conversion only from a given node type, `$text` in this case.
	 *		// The same attribute on different elements may then be handled by a different converter.
	 *		editor.conversion.attributeToElement( {
	 *			model: {
	 *				key: 'textDecoration',
	 *				values: [ 'underline', 'lineThrough' ],
	 *				name: '$text'
	 *			},
	 *			view: {
	 *				underline: {
	 *					name: 'span',
	 *					styles: {
	 *						'text-decoration': 'underline'
	 *					}
	 *				},
	 *				lineThrough: {
	 *					name: 'span',
	 *					styles: {
	 *						'text-decoration': 'line-through'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Use `upcastAlso` to define other view elements that should also be converted to the `bold` attribute.
	 *		editor.conversion.attributeToElement( {
	 *			model: 'bold',
	 *			view: 'strong',
	 *			upcastAlso: [
	 *				'b',
	 *				{
	 *					name: 'span',
	 *					classes: 'bold'
	 *				},
	 *				{
	 *					name: 'span',
	 *					styles: {
	 *						'font-weight': 'bold'
	 *					}
	 *				},
	 *				viewElement => {
	 *					const fontWeight = viewElement.getStyle( 'font-weight' );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && fontWeight && /\d+/.test() && Number( fontWeight ) > 500 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return {
	 *							name: true,
	 *							styles: [ 'font-weight' ]
	 *						};
	 *					}
	 *				}
	 *			]
	 *		} );
	 *
	 *		// Conversion from and to a model attribute key whose value is an enum (`fontSize=big|small`).
	 *		// `upcastAlso` set as callback enables a conversion of a wide range of different view elements.
	 *		editor.conversion.attributeToElement( {
	 *			model: {
	 *				key: 'fontSize',
	 *				values: [ 'big', 'small' ]
	 *			},
	 *			view: {
	 *				big: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '1.2em'
	 *					}
	 *				},
	 *				small: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '0.8em'
	 *					}
	 *				}
	 *			},
	 *			upcastAlso: {
	 *				big: viewElement => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *					if ( !fontSize ) {
	 *						return null;
	 *					}
	 *
	 *					const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *					if ( !match ) {
	 *						return null;
	 *					}
	 *
	 *					const size = Number( match[ 1 ] );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && size > 10 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return { name: true, styles: [ 'font-size' ] };
	 *					}
	 *
	 *					return null;
	 *				},
	 *				small: viewElement => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *
	 *					if ( !fontSize ) {
	 *						return null;
	 *					}
	 *
	 *					const match = fontSize.match( /(\d+)\s*px/ );
	 *
	 *					if ( !match ) {
	 *						return null;
	 *					}
	 *
	 *					const size = Number( match[ 1 ] );
	 *
	 *					if ( viewElement.is( 'element', 'span' ) && size < 10 ) {
	 *						// Returned value can be an object with the matched properties.
	 *						// These properties will be "consumed" during the conversion.
	 *						// See `engine.view.Matcher~MatcherPattern` and `engine.view.Matcher#match` for more details.
	 *
	 *						return { name: true, styles: [ 'font-size' ] };
	 *					}
	 *
	 *					return null;
	 *				}
	 *			}
	 *		} );
	 *
	 * The `definition.model` parameter specifies which model attribute should be converted from or to. It can be a `{ key, value }` object
	 * describing the attribute key and value to convert or a `String` specifying just the attribute key (then `value` is set to `true`).
	 * See {@link module:engine/conversion/conversion~ConverterDefinition} to learn about other parameters.
	 *
	 * @param {module:engine/conversion/conversion~ConverterDefinition} definition The converter definition.
	 */
	attributeToElement( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).attributeToElement( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.elementToAttribute( {
					view,
					model,
					converterPriority: definition.converterPriority
				} );
		}
	}

	/**
	 * Sets up converters between the model and the view that convert a model attribute to a view attribute (and vice versa).
	 * For example, `<image src='foo.jpg'></image>` is converted to `<img src='foo.jpg'></img>` (the same attribute key and value).
	 * This type of converters is intended to be used with {@link module:engine/model/element~Element model element} nodes.
	 * To convert text attributes {@link module:engine/conversion/conversion~Conversion#attributeToElement `attributeToElement converter`}
	 * should be set up.
	 *
	 *		// A simple conversion from the `source` model attribute to the `src` view attribute (and vice versa).
	 *		editor.conversion.attributeToAttribute( { model: 'source', view: 'src' } );
	 *
	 *		// Attribute values are strictly specified.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				name: 'image',
	 *				key: 'aside',
	 *				values: [ 'aside' ]
	 *			},
	 *			view: {
	 *				aside: {
	 *					name: 'img',
	 *					key: 'class',
	 *					value: [ 'aside', 'half-size' ]
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Set the style attribute.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				name: 'image',
	 *				key: 'aside',
	 *				values: [ 'aside' ]
	 *			},
	 *			view: {
	 *				aside: {
	 *					name: 'img',
	 *					key: 'style',
	 *					value: {
	 *						float: 'right',
	 *						width: '50%',
	 *						margin: '5px'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		// Conversion from and to a model attribute key whose value is an enum (`align=right|center`).
	 *		// Use `upcastAlso` to define other view elements that should also be converted to the `align=right` attribute.
	 *		editor.conversion.attributeToAttribute( {
	 *			model: {
	 *				key: 'align',
	 *				values: [ 'right', 'center' ]
	 *			},
	 *			view: {
	 *				right: {
	 *					key: 'class',
	 *					value: 'align-right'
	 *				},
	 *				center: {
	 *					key: 'class',
	 *					value: 'align-center'
	 *				}
	 *			},
	 *			upcastAlso: {
	 *				right: {
	 *					styles: {
	 *						'text-align': 'right'
	 *					}
	 *				},
	 *				center: {
	 *					styles: {
	 *						'text-align': 'center'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 * The `definition.model` parameter specifies which model attribute should be converted from and to.
	 * It can be a `{ key, [ values ], [ name ] }` object or a `String`, which will be treated like `{ key: definition.model }`.
	 * The `key` property is the model attribute key to convert from and to.
	 * The `values` are the possible model attribute values. If `values` is not set, the model attribute value will be the same as the
	 * view attribute value.
	 * If `name` is set, the conversion will be set up only for model elements with the given name.
	 *
	 * The `definition.view` parameter specifies which view attribute should be converted from and to.
	 * It can be a `{ key, value, [ name ] }` object or a `String`, which will be treated like `{ key: definition.view }`.
	 * The `key` property is the view attribute key to convert from and to.
	 * The `value` is the view attribute value to convert from and to. If `definition.value` is not set, the view attribute value will be
	 * the same as the model attribute value.
	 * If `key` is `'class'`, `value` can be a `String` or an array of `String`s.
	 * If `key` is `'style'`, `value` is an object with key-value pairs.
	 * In other cases, `value` is a `String`.
	 * If `name` is set, the conversion will be set up only for model elements with the given name.
	 * If `definition.model.values` is set, `definition.view` is an object that assigns values from `definition.model.values`
	 * to `{ key, value, [ name ] }` objects.
	 *
	 * `definition.upcastAlso` specifies which other matching view elements should also be upcast to the given model configuration.
	 * If `definition.model.values` is set, `definition.upcastAlso` should be an object assigning values from `definition.model.values`
	 * to {@link module:engine/view/matcher~MatcherPattern}s or arrays of {@link module:engine/view/matcher~MatcherPattern}s.
	 *
	 * **Note:** `definition.model` and `definition.view` form should be mirrored, so the same types of parameters should
	 * be given in both parameters.
	 *
	 * @param {Object} definition The converter definition.
	 * @param {String|Object} definition.model The model attribute to convert from and to.
	 * @param {String|Object} definition.view The view attribute to convert from and to.
	 * @param {module:engine/view/matcher~MatcherPattern|Array.<module:engine/view/matcher~MatcherPattern>} [definition.upcastAlso]
	 * Any view element matching `definition.upcastAlso` will also be converted to the given model attribute. `definition.upcastAlso`
	 * is used only if `config.model.values` is specified.
	 */
	attributeToAttribute( definition ) {
		// Set up downcast converter.
		this.for( 'downcast' ).attributeToAttribute( definition );

		// Set up upcast converter.
		for ( const { model, view } of _getAllUpcastDefinitions( definition ) ) {
			this.for( 'upcast' )
				.attributeToAttribute( {
					view,
					model
				} );
		}
	}

	/**
	 * Creates and caches conversion helpers for given dispatchers group.
	 *
	 * @private
	 * @param {Object} options
	 * @param {String} options.name Group name.
	 * @param {Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher>} options.dispatchers
	 * @param {Boolean} options.isDowncast
	 */
	_createConversionHelpers( { name, dispatchers, isDowncast } ) {
		if ( this._helpers.has( name ) ) {
			/**
			 * Trying to register a group name that has already been registered.
			 *
			 * @error conversion-group-exists
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_0__["default"]( 'conversion-group-exists: Trying to register a group name that has already been registered.', this );
		}

		const helpers = isDowncast ? new _downcasthelpers__WEBPACK_IMPORTED_MODULE_2__["default"]( dispatchers ) : new _upcasthelpers__WEBPACK_IMPORTED_MODULE_1__["default"]( dispatchers );

		this._helpers.set( name, helpers );
	}
}

/**
 * Defines how the model should be converted from and to the view.
 *
 * @typedef {Object} module:engine/conversion/conversion~ConverterDefinition
 *
 * @property {*} [model] The model conversion definition. Describes the model element or model attribute to convert. This parameter differs
 * for different functions that accept `ConverterDefinition`. See the description of the function to learn how to set it.
 * @property {module:engine/view/elementdefinition~ElementDefinition|Object} view The definition of the view element to convert from and
 * to. If `model` describes multiple values, `view` is an object that assigns these values (`view` object keys) to view element definitions
 * (`view` object values).
 * @property {module:engine/view/matcher~MatcherPattern|Array.<module:engine/view/matcher~MatcherPattern>} [upcastAlso]
 * Any view element matching `upcastAlso` will also be converted to the model. If `model` describes multiple values, `upcastAlso`
 * is an object that assigns these values (`upcastAlso` object keys) to {@link module:engine/view/matcher~MatcherPattern}s
 * (`upcastAlso` object values).
 * @property {module:utils/priorities~PriorityString} [converterPriority] The converter priority.
 */

// Helper function that creates a joint array out of an item passed in `definition.view` and items passed in
// `definition.upcastAlso`.
//
// @param {module:engine/conversion/conversion~ConverterDefinition} definition
// @returns {Array} Array containing view definitions.
function* _getAllUpcastDefinitions( definition ) {
	if ( definition.model.values ) {
		for ( const value of definition.model.values ) {
			const model = { key: definition.model.key, value };
			const view = definition.view[ value ];
			const upcastAlso = definition.upcastAlso ? definition.upcastAlso[ value ] : undefined;

			yield* _getUpcastDefinition( model, view, upcastAlso );
		}
	} else {
		yield* _getUpcastDefinition( definition.model, definition.view, definition.upcastAlso );
	}
}

function* _getUpcastDefinition( model, view, upcastAlso ) {
	yield { model, view };

	if ( upcastAlso ) {
		upcastAlso = Array.isArray( upcastAlso ) ? upcastAlso : [ upcastAlso ];

		for ( const upcastAlsoItem of upcastAlso ) {
			yield { model, view: upcastAlsoItem };
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js ***!
  \*************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ConversionHelpers; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/conversionhelpers
 */

/**
 * Base class for conversion helpers.
 */
class ConversionHelpers {
	/**
	 * Creates a conversion helpers instance.
	 *
	 * @param {Array.<module:engine/conversion/downcastdispatcher~DowncastDispatcher|
	 * module:engine/conversion/upcastdispatcher~UpcastDispatcher>} dispatchers
	 */
	constructor( dispatchers ) {
		this._dispatchers = dispatchers;
	}

	/**
	 * Registers a conversion helper.
	 *
	 * **Note**: See full usage example in the `{@link module:engine/conversion/conversion~Conversion#for conversion.for()}`
	 * method description.
	 *
	 * @param {Function} conversionHelper The function to be called on event.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers|module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	add( conversionHelper ) {
		for ( const dispatcher of this._dispatchers ) {
			conversionHelper( dispatcher );
		}

		return this;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcastdispatcher.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DowncastDispatcher; });
/* harmony import */ var _modelconsumable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./modelconsumable */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/downcastdispatcher
 */







/**
 * `DowncastDispatcher` is a central point of downcasting (conversion from model to view), which is a process of reacting to changes
 * in the model and firing a set of events. Callbacks listening to those events are called converters. Those
 * converters role is to convert the model changes to changes in view (for example, adding view nodes or
 * changing attributes on view elements).
 *
 * During conversion process, `DowncastDispatcher` fires events, basing on state of the model and prepares
 * data for those events. It is important to understand that those events are connected with changes done on model,
 * for example: "node has been inserted" or "attribute has changed". This is in a contrary to upcasting (view to model conversion),
 * where we convert view state (view nodes) to a model tree.
 *
 * The events are prepared basing on a diff created by {@link module:engine/model/differ~Differ Differ}, which buffers them
 * and then passes to `DowncastDispatcher` as a diff between old model state and new model state.
 *
 * Note, that because changes are converted there is a need to have a mapping between model structure and view structure.
 * To map positions and elements during downcast (model to view conversion) use {@link module:engine/conversion/mapper~Mapper}.
 *
 * `DowncastDispatcher` fires following events for model tree changes:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert insert}
 * if a range of nodes has been inserted to the model tree,
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:remove remove}
 * if a range of nodes has been removed from the model tree,
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute attribute}
 * if attribute has been added, changed or removed from a model node.
 *
 * For {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert insert}
 * and {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute attribute},
 * `DowncastDispatcher` generates {@link module:engine/conversion/modelconsumable~ModelConsumable consumables}.
 * These are used to have a control over which changes has been already consumed. It is useful when some converters
 * overwrite other or converts multiple changes (for example converts insertion of an element and also converts that
 * element's attributes during insertion).
 *
 * Additionally, `DowncastDispatcher` fires events for {@link module:engine/model/markercollection~Marker marker} changes:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker} if a marker has been added,
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:removeMarker} if a marker has been removed.
 *
 * Note, that changing a marker is done through removing the marker from the old range, and adding on the new range,
 * so both those events are fired.
 *
 * Finally, `DowncastDispatcher` also handles firing events for {@link module:engine/model/selection model selection}
 * conversion:
 *
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:selection}
 * which converts selection from model to view,
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute}
 * which is fired for every selection attribute,
 * * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}
 * which is fired for every marker which contains selection.
 *
 * Unlike model tree and markers, events for selection are not fired for changes but for selection state.
 *
 * When providing custom listeners for `DowncastDispatcher` remember to check whether given change has not been
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed} yet.
 *
 * When providing custom listeners for `DowncastDispatcher` keep in mind that any callback that had
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed} a value from a consumable and
 * converted the change should also stop the event (for efficiency purposes).
 *
 * When providing custom listeners for `DowncastDispatcher` remember to use provided
 * {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer} to apply changes to the view document.
 *
 * Example of a custom converter for `DowncastDispatcher`:
 *
 *		// We will convert inserting "paragraph" model element into the model.
 *		downcastDispatcher.on( 'insert:paragraph', ( evt, data, conversionApi ) => {
 *			// Remember to check whether the change has not been consumed yet and consume it.
 *			if ( conversionApi.consumable.consume( data.item, 'insert' ) ) {
 *				return;
 *			}
 *
 *			// Translate position in model to position in view.
 *			const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );
 *
 *			// Create <p> element that will be inserted in view at `viewPosition`.
 *			const viewElement = conversionApi.writer.createContainerElement( 'p' );
 *
 *			// Bind the newly created view element to model element so positions will map accordingly in future.
 *			conversionApi.mapper.bindElements( data.item, viewElement );
 *
 *			// Add the newly created view element to the view.
 *			conversionApi.writer.insert( viewPosition, viewElement );
 *
 *			// Remember to stop the event propagation.
 *			evt.stop();
 *		} );
 */
class DowncastDispatcher {
	/**
	 * Creates a `DowncastDispatcher` instance.
	 *
	 * @see module:engine/conversion/downcastdispatcher~DowncastConversionApi
	 * @param {Object} conversionApi Additional properties for interface that will be passed to events fired
	 * by `DowncastDispatcher`.
	 */
	constructor( conversionApi ) {
		/**
		 * Interface passed by dispatcher to the events callbacks.
		 *
		 * @member {module:engine/conversion/downcastdispatcher~DowncastConversionApi}
		 */
		this.conversionApi = Object(lodash_es__WEBPACK_IMPORTED_MODULE_4__["extend"])( { dispatcher: this }, conversionApi );
	}

	/**
	 * Takes {@link module:engine/model/differ~Differ model differ} object with buffered changes and fires conversion basing on it.
	 *
	 * @param {module:engine/model/differ~Differ} differ Differ object with buffered changes.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Markers connected with converted model.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertChanges( differ, markers, writer ) {
		// Before the view is updated, remove markers which have changed.
		for ( const change of differ.getMarkersToRemove() ) {
			this.convertMarkerRemove( change.name, change.range, writer );
		}

		// Convert changes that happened on model tree.
		for ( const entry of differ.getChanges() ) {
			if ( entry.type == 'insert' ) {
				this.convertInsert( _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( entry.position, entry.length ), writer );
			} else if ( entry.type == 'remove' ) {
				this.convertRemove( entry.position, entry.length, entry.name, writer );
			} else {
				// entry.type == 'attribute'.
				this.convertAttribute( entry.range, entry.attributeKey, entry.attributeOldValue, entry.attributeNewValue, writer );
			}
		}

		for ( const markerName of this.conversionApi.mapper.flushUnboundMarkerNames() ) {
			const markerRange = markers.get( markerName ).getRange();

			this.convertMarkerRemove( markerName, markerRange, writer );
			this.convertMarkerAdd( markerName, markerRange, writer );
		}

		// After the view is updated, convert markers which have changed.
		for ( const change of differ.getMarkersToAdd() ) {
			this.convertMarkerAdd( change.name, change.range, writer );
		}
	}

	/**
	 * Starts conversion of a range insertion.
	 *
	 * For each node in the range, {@link #event:insert insert event is fired}. For each attribute on each node,
	 * {@link #event:attribute attribute event is fired}.
	 *
	 * @fires insert
	 * @fires attribute
	 * @param {module:engine/model/range~Range} range Inserted range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertInsert( range, writer ) {
		this.conversionApi.writer = writer;

		// Create a list of things that can be consumed, consisting of nodes and their attributes.
		this.conversionApi.consumable = this._createInsertConsumable( range );

		// Fire a separate insert event for each node and text fragment contained in the range.
		for ( const value of range ) {
			const item = value.item;
			const itemRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( value.previousPosition, value.length );
			const data = {
				item,
				range: itemRange
			};

			this._testAndFire( 'insert', data );

			// Fire a separate addAttribute event for each attribute that was set on inserted items.
			// This is important because most attributes converters will listen only to add/change/removeAttribute events.
			// If we would not add this part, attributes on inserted nodes would not be converted.
			for ( const key of item.getAttributeKeys() ) {
				data.attributeKey = key;
				data.attributeOldValue = null;
				data.attributeNewValue = item.getAttribute( key );

				this._testAndFire( `attribute:${ key }`, data );
			}
		}

		this._clearConversionApi();
	}

	/**
	 * Fires conversion of a single node removal. Fires {@link #event:remove remove event} with provided data.
	 *
	 * @param {module:engine/model/position~Position} position Position from which node was removed.
	 * @param {Number} length Offset size of removed node.
	 * @param {String} name Name of removed node.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertRemove( position, length, name, writer ) {
		this.conversionApi.writer = writer;

		this.fire( 'remove:' + name, { position, length }, this.conversionApi );

		this._clearConversionApi();
	}

	/**
	 * Starts conversion of attribute change on given `range`.
	 *
	 * For each node in the given `range`, {@link #event:attribute attribute event} is fired with the passed data.
	 *
	 * @fires attribute
	 * @param {module:engine/model/range~Range} range Changed range.
	 * @param {String} key Key of the attribute that has changed.
	 * @param {*} oldValue Attribute value before the change or `null` if the attribute has not been set before.
	 * @param {*} newValue New attribute value or `null` if the attribute has been removed.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertAttribute( range, key, oldValue, newValue, writer ) {
		this.conversionApi.writer = writer;

		// Create a list with attributes to consume.
		this.conversionApi.consumable = this._createConsumableForRange( range, `attribute:${ key }` );

		// Create a separate attribute event for each node in the range.
		for ( const value of range ) {
			const item = value.item;
			const itemRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( value.previousPosition, value.length );
			const data = {
				item,
				range: itemRange,
				attributeKey: key,
				attributeOldValue: oldValue,
				attributeNewValue: newValue
			};

			this._testAndFire( `attribute:${ key }`, data );
		}

		this._clearConversionApi();
	}

	/**
	 * Starts model selection conversion.
	 *
	 * Fires events for given {@link module:engine/model/selection~Selection selection} to start selection conversion.
	 *
	 * @fires selection
	 * @fires addMarker
	 * @fires attribute
	 * @param {module:engine/model/selection~Selection} selection Selection to convert.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Markers connected with converted model.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertSelection( selection, markers, writer ) {
		const markersAtSelection = Array.from( markers.getMarkersAtPosition( selection.getFirstPosition() ) );

		this.conversionApi.writer = writer;
		this.conversionApi.consumable = this._createSelectionConsumable( selection, markersAtSelection );

		this.fire( 'selection', { selection }, this.conversionApi );

		if ( !selection.isCollapsed ) {
			return;
		}

		for ( const marker of markersAtSelection ) {
			const markerRange = marker.getRange();

			if ( !shouldMarkerChangeBeConverted( selection.getFirstPosition(), marker, this.conversionApi.mapper ) ) {
				continue;
			}

			const data = {
				item: selection,
				markerName: marker.name,
				markerRange
			};

			if ( this.conversionApi.consumable.test( selection, 'addMarker:' + marker.name ) ) {
				this.fire( 'addMarker:' + marker.name, data, this.conversionApi );
			}
		}

		for ( const key of selection.getAttributeKeys() ) {
			const data = {
				item: selection,
				range: selection.getFirstRange(),
				attributeKey: key,
				attributeOldValue: null,
				attributeNewValue: selection.getAttribute( key )
			};

			// Do not fire event if the attribute has been consumed.
			if ( this.conversionApi.consumable.test( selection, 'attribute:' + data.attributeKey ) ) {
				this.fire( 'attribute:' + data.attributeKey + ':$text', data, this.conversionApi );
			}
		}

		this._clearConversionApi();
	}

	/**
	 * Converts added marker. Fires {@link #event:addMarker addMarker} event for each item
	 * in marker's range. If range is collapsed single event is dispatched. See event description for more details.
	 *
	 * @fires addMarker
	 * @param {String} markerName Marker name.
	 * @param {module:engine/model/range~Range} markerRange Marker range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertMarkerAdd( markerName, markerRange, writer ) {
		// Do not convert if range is in graveyard or not in the document (e.g. in DocumentFragment).
		if ( !markerRange.root.document || markerRange.root.rootName == '$graveyard' ) {
			return;
		}

		this.conversionApi.writer = writer;

		// In markers' case, event name == consumable name.
		const eventName = 'addMarker:' + markerName;

		//
		// First, fire an event for the whole marker.
		//
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();
		consumable.add( markerRange, eventName );

		this.conversionApi.consumable = consumable;

		this.fire( eventName, { markerName, markerRange }, this.conversionApi );

		//
		// Do not fire events for each item inside the range if the range got consumed.
		//
		if ( !consumable.test( markerRange, eventName ) ) {
			return;
		}

		//
		// Then, fire an event for each item inside the marker range.
		//
		this.conversionApi.consumable = this._createConsumableForRange( markerRange, eventName );

		for ( const item of markerRange.getItems() ) {
			// Do not fire event for already consumed items.
			if ( !this.conversionApi.consumable.test( item, eventName ) ) {
				continue;
			}

			const data = { item, range: _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createOn( item ), markerName, markerRange };

			this.fire( eventName, data, this.conversionApi );
		}

		this._clearConversionApi();
	}

	/**
	 * Fires conversion of marker removal. Fires {@link #event:removeMarker removeMarker} event with provided data.
	 *
	 * @fires removeMarker
	 * @param {String} markerName Marker name.
	 * @param {module:engine/model/range~Range} markerRange Marker range.
	 * @param {module:engine/view/downcastwriter~DowncastWriter} writer View writer that should be used to modify view document.
	 */
	convertMarkerRemove( markerName, markerRange, writer ) {
		// Do not convert if range is in graveyard or not in the document (e.g. in DocumentFragment).
		if ( !markerRange.root.document || markerRange.root.rootName == '$graveyard' ) {
			return;
		}

		this.conversionApi.writer = writer;

		this.fire( 'removeMarker:' + markerName, { markerName, markerRange }, this.conversionApi );

		this._clearConversionApi();
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with values to consume from given range,
	 * assuming that the range has just been inserted to the model.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range Inserted range.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} Values to consume.
	 */
	_createInsertConsumable( range ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		for ( const value of range ) {
			const item = value.item;

			consumable.add( item, 'insert' );

			for ( const key of item.getAttributeKeys() ) {
				consumable.add( item, 'attribute:' + key );
			}
		}

		return consumable;
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with values to consume for given range.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range Affected range.
	 * @param {String} type Consumable type.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} Values to consume.
	 */
	_createConsumableForRange( range, type ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		for ( const item of range.getItems() ) {
			consumable.add( item, type );
		}

		return consumable;
	}

	/**
	 * Creates {@link module:engine/conversion/modelconsumable~ModelConsumable} with selection consumable values.
	 *
	 * @private
	 * @param {module:engine/model/selection~Selection} selection Selection to create consumable from.
	 * @param {Iterable.<module:engine/model/markercollection~Marker>} markers Markers which contains selection.
	 * @returns {module:engine/conversion/modelconsumable~ModelConsumable} Values to consume.
	 */
	_createSelectionConsumable( selection, markers ) {
		const consumable = new _modelconsumable__WEBPACK_IMPORTED_MODULE_0__["default"]();

		consumable.add( selection, 'selection' );

		for ( const marker of markers ) {
			consumable.add( selection, 'addMarker:' + marker.name );
		}

		for ( const key of selection.getAttributeKeys() ) {
			consumable.add( selection, 'attribute:' + key );
		}

		return consumable;
	}

	/**
	 * Tests passed `consumable` to check whether given event can be fired and if so, fires it.
	 *
	 * @private
	 * @fires insert
	 * @fires attribute
	 * @param {String} type Event type.
	 * @param {Object} data Event data.
	 */
	_testAndFire( type, data ) {
		if ( !this.conversionApi.consumable.test( data.item, type ) ) {
			// Do not fire event if the item was consumed.
			return;
		}

		const name = data.item.name || '$text';

		this.fire( type + ':' + name, data, this.conversionApi );
	}

	/**
	 * Clears conversion API object.
	 *
	 * @private
	 */
	_clearConversionApi() {
		delete this.conversionApi.writer;
		delete this.conversionApi.consumable;
	}

	/**
	 * Fired for inserted nodes.
	 *
	 * `insert` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `insert:name`. `name` is either `'$text'`, when {@link module:engine/model/text~Text a text node} has been inserted,
	 * or {@link module:engine/model/element~Element#name name} of inserted element.
	 *
	 * This way listeners can either listen to a general `insert` event or specific event (for example `insert:paragraph`).
	 *
	 * @event insert
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item} data.item Inserted item.
	 * @param {module:engine/model/range~Range} data.range Range spanning over inserted item.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired for removed nodes.
	 *
	 * `remove` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `remove:name`. `name` is either `'$text'`, when {@link module:engine/model/text~Text a text node} has been removed,
	 * or the {@link module:engine/model/element~Element#name name} of removed element.
	 *
	 * This way listeners can either listen to a general `remove` event or specific event (for example `remove:paragraph`).
	 *
	 * @event remove
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/position~Position} data.position Position from which the node has been removed.
	 * @param {Number} data.length Offset size of the removed node.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired in the following cases:
	 *
	 * * when an attribute has been added, changed, or removed from a node,
	 * * when a node with an attribute is inserted,
	 * * when collapsed model selection attribute is converted.
	 *
	 * `attribute` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `attribute:attributeKey:name`. `attributeKey` is the key of added/changed/removed attribute.
	 * `name` is either `'$text'` if change was on {@link module:engine/model/text~Text a text node},
	 * or the {@link module:engine/model/element~Element#name name} of element which attribute has changed.
	 *
	 * This way listeners can either listen to a general `attribute:bold` event or specific event (for example `attribute:src:image`).
	 *
	 * @event attribute
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item|module:engine/model/documentselection~DocumentSelection} data.item Changed item
	 * or converted selection.
	 * @param {module:engine/model/range~Range} data.range Range spanning over changed item or selection range.
	 * @param {String} data.attributeKey Attribute key.
	 * @param {*} data.attributeOldValue Attribute value before the change. This is `null` when selection attribute is converted.
	 * @param {*} data.attributeNewValue New attribute value.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired for {@link module:engine/model/selection~Selection selection} changes.
	 *
	 * @event selection
	 * @param {module:engine/model/selection~Selection} selection Selection that is converted.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired when a new marker is added to the model. Also fired when collapsed model selection that is inside marker is converted.
	 *
	 * `addMarker` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `addMarker:markerName`. By specifying certain marker names, you can make the events even more gradual. For example,
	 * if markers are named `foo:abc`, `foo:bar`, then it is possible to listen to `addMarker:foo` or `addMarker:foo:abc` and
	 * `addMarker:foo:bar` events.
	 *
	 * If the marker range is not collapsed:
	 *
	 * * the event is fired for each item in the marker range one by one,
	 * * `conversionApi.consumable` includes each item of the marker range and the consumable value is same as event name.
	 *
	 * If the marker range is collapsed:
	 *
	 * * there is only one event,
	 * * `conversionApi.consumable` includes marker range with event name.
	 *
	 * If selection inside a marker is converted:
	 *
	 * * there is only one event,
	 * * `conversionApi.consumable` includes selection instance with event name.
	 *
	 * @event addMarker
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection} data.item Item inside the new marker or
	 * the selection that is being converted.
	 * @param {module:engine/model/range~Range} [data.range] Range spanning over converted item. Available only in marker conversion, if
	 * the marker range was not collapsed.
	 * @param {module:engine/model/range~Range} data.markerRange Marker range.
	 * @param {String} data.markerName Marker name.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */

	/**
	 * Fired when marker is removed from the model.
	 *
	 * `removeMarker` is a namespace for a class of events. Names of actually called events follow this pattern:
	 * `removeMarker:markerName`. By specifying certain marker names, you can make the events even more gradual. For example,
	 * if markers are named `foo:abc`, `foo:bar`, then it is possible to listen to `removeMarker:foo` or `removeMarker:foo:abc` and
	 * `removeMarker:foo:bar` events.
	 *
	 * @event removeMarker
	 * @param {Object} data Additional information about the change.
	 * @param {module:engine/model/range~Range} data.markerRange Marker range.
	 * @param {String} data.markerName Marker name.
	 * @param {module:engine/conversion/downcastdispatcher~DowncastConversionApi} conversionApi Conversion interface
	 * to be used by callback, passed in `DowncastDispatcher` constructor.
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( DowncastDispatcher, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_2__["default"] );

// Helper function, checks whether change of `marker` at `modelPosition` should be converted. Marker changes are not
// converted if they happen inside an element with custom conversion method.
//
// @param {module:engine/model/position~Position} modelPosition
// @param {module:engine/model/markercollection~Marker} marker
// @param {module:engine/conversion/mapper~Mapper} mapper
// @returns {Boolean}
function shouldMarkerChangeBeConverted( modelPosition, marker, mapper ) {
	const range = marker.getRange();
	const ancestors = Array.from( modelPosition.getAncestors() );
	ancestors.shift(); // Remove root element. It cannot be passed to `model.Range#containsItem`.
	ancestors.reverse();

	const hasCustomHandling = ancestors.some( element => {
		if ( range.containsItem( element ) ) {
			const viewElement = mapper.toViewElement( element );

			return !!viewElement.getCustomProperty( 'addHighlight' );
		}
	} );

	return !hasCustomHandling;
}

/**
 * Conversion interface that is registered for given {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}
 * and is passed as one of parameters when {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher dispatcher}
 * fires it's events.
 *
 * @interface module:engine/conversion/downcastdispatcher~DowncastConversionApi
 */

/**
 * The {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} instance.
 *
 * @member {module:engine/conversion/downcastdispatcher~DowncastDispatcher} #dispatcher
 */

/**
 * Stores information about what parts of processed model item are still waiting to be handled. After a piece of model item
 * was converted, appropriate consumable value should be {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed}.
 *
 * @member {module:engine/conversion/modelconsumable~ModelConsumable} #consumable
 */

/**
 * The {@link module:engine/conversion/mapper~Mapper} instance.
 *
 * @member {module:engine/conversion/mapper~Mapper} #mapper
 */

/**
 * The {@link module:engine/model/schema~Schema} instance set for the model that is downcast.
 *
 * @member {module:engine/model/schema~Schema} #schema
 */

/**
 * The {@link module:engine/view/downcastwriter~DowncastWriter} instance used to manipulate data during conversion.
 *
 * @member {module:engine/view/downcastwriter~DowncastWriter} #writer
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/downcasthelpers.js ***!
  \***********************************************************************************/
/*! exports provided: default, insertText, remove, createViewElementFromHighlightDescriptor, convertRangeSelection, convertCollapsedSelection, clearAttributes, wrap, insertElement, insertUIElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DowncastHelpers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertText", function() { return insertText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "remove", function() { return remove; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createViewElementFromHighlightDescriptor", function() { return createViewElementFromHighlightDescriptor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertRangeSelection", function() { return convertRangeSelection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertCollapsedSelection", function() { return convertCollapsedSelection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "clearAttributes", function() { return clearAttributes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "wrap", function() { return wrap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertElement", function() { return insertElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertUIElement", function() { return insertUIElement; });
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_selection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/selection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _model_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/element */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _view_attributeelement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../view/attributeelement */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/attributeelement.js");
/* harmony import */ var _model_documentselection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/documentselection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js");
/* harmony import */ var _conversionhelpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./conversionhelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * Contains downcast (model-to-view) converters for {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}.
 *
 * @module engine/conversion/downcasthelpers
 */












/**
 * Downcast conversion helper functions.
 *
 * @extends module:engine/conversion/conversionhelpers~ConversionHelpers
 */
class DowncastHelpers extends _conversionhelpers__WEBPACK_IMPORTED_MODULE_5__["default"] {
	/**
	 * Model element to view element conversion helper.
	 *
	 * This conversion results in creating a view element. For example, model `<paragraph>Foo</paragraph>` becomes `<p>Foo</p>` in the view.
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'p'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'paragraph',
	 *			view: 'div',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'fancyParagraph',
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).elementToElement( {
	 *			model: 'heading',
	 *			view: ( modelElement, viewWriter ) => {
	 *				return viewWriter.createContainerElement( 'h' + modelElement.getAttribute( 'level' ) )
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model element to convert.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
	 * that takes the model element and {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer}
	 * as parameters and returns a view container element.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	elementToElement( config ) {
		return this.add( downcastElementToElement( config ) );
	}

	/**
	 * Model attribute to view element conversion helper.
	 *
	 * This conversion results in wrapping view nodes with a view attribute element. For example, a model text node with
	 * `"Foo"` as data and the `bold` attribute becomes `<strong>Foo</strong>` in the view.
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: 'strong'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: 'b',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'invert',
	 *			view: {
	 *				name: 'span',
	 *				classes: [ 'font-light', 'bg-dark' ]
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: {
	 *				key: 'fontSize',
	 *				values: [ 'big', 'small' ]
	 *			},
	 *			view: {
	 *				big: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '1.2em'
	 *					}
	 *				},
	 *				small: {
	 *					name: 'span',
	 *					styles: {
	 *						'font-size': '0.8em'
	 *					}
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: 'bold',
	 *			view: ( modelAttributeValue, viewWriter ) => {
	 *				return viewWriter.createAttributeElement( 'span', {
	 *					style: 'font-weight:' + modelAttributeValue
	 *				} );
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToElement( {
	 *			model: {
	 *				key: 'color',
	 *				name: '$text'
	 *			},
	 *			view: ( modelAttributeValue, viewWriter ) => {
	 *				return viewWriter.createAttributeElement( 'span', {
	 *					style: 'color:' + modelAttributeValue
	 *				} );
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values }` object. `values` is an array
	 * of `String`s with possible values if the model attribute is an enumerable.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function|Object} config.view A view element definition or a function
	 * that takes the model attribute value and {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer}
	 * as parameters and returns a view attribute element. If `config.model.values` is
	 * given, `config.view` should be an object assigning values from `config.model.values` to view element definitions or functions.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	attributeToElement( config ) {
		return this.add( downcastAttributeToElement( config ) );
	}

	/**
	 * Model attribute to view attribute conversion helper.
	 *
	 * This conversion results in adding an attribute to a view node, basing on an attribute from a model node. For example,
	 * `<image src='foo.jpg'></image>` is converted to `<img src='foo.jpg'></img>`.
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'source',
	 *			view: 'src'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'source',
	 *			view: 'href',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: {
	 *				name: 'image',
	 *				key: 'source'
	 *			},
	 *			view: 'src'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: {
	 *				name: 'styled',
	 *				values: [ 'dark', 'light' ]
	 *			},
	 *			view: {
	 *				dark: {
	 *					key: 'class',
	 *					value: [ 'styled', 'styled-dark' ]
	 *				},
	 *				light: {
	 *					key: 'class',
	 *					value: [ 'styled', 'styled-light' ]
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'styled',
	 *			view: modelAttributeValue => ( { key: 'class', value: 'styled-' + modelAttributeValue } )
	 *		} );
	 *
	 * **Note**: Downcasting to a style property requires providing `value` as an object:
	 *
	 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
	 *			model: 'lineHeight',
	 *			view: modelAttributeValue => ( {
	 *				key: 'style',
	 *				value: {
	 *					'line-height': modelAttributeValue,
	 *					'border-bottom': '1px dotted #ba2'
	 *				}
	 *			} )
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values, [ name ] }` object describing
	 * the attribute key, possible values and, optionally, an element name to convert from.
	 * @param {String|Object|Function} config.view A view attribute key, or a `{ key, value }` object or a function that takes
	 * the model attribute value and returns a `{ key, value }` object. If `key` is `'class'`, `value` can be a `String` or an
	 * array of `String`s. If `key` is `'style'`, `value` is an object with key-value pairs. In other cases, `value` is a `String`.
	 * If `config.model.values` is set, `config.view` should be an object assigning values from `config.model.values` to
	 * `{ key, value }` objects or a functions.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	attributeToAttribute( config ) {
		return this.add( downcastAttributeToAttribute( config ) );
	}

	/**
	 * Model marker to view element conversion helper.
	 *
	 * **Note**: This method should be used only for editing downcast. For data downcast, use
	 * {@link #markerToData `#markerToData()`} that produces valid HTML data.
	 *
	 * This conversion results in creating a view element on the boundaries of the converted marker. If the converted marker
	 * is collapsed, only one element is created. For example, model marker set like this: `<paragraph>F[oo b]ar</paragraph>`
	 * becomes `<p>F<span data-marker="search"></span>oo b<span data-marker="search"></span>ar</p>` in the view.
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: 'marker-search'
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: 'search-result',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: {
	 *				name: 'span',
	 *				attributes: {
	 *					'data-marker': 'search'
	 *				}
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'editingDowncast' ).markerToElement( {
	 *			model: 'search',
	 *			view: ( markerData, viewWriter ) => {
	 *				return viewWriter.createUIElement( 'span', {
	 *					'data-marker': 'search',
	 *					'data-start': markerData.isOpening
	 *				} );
	 *			}
	 *		} );
	 *
	 * If a function is passed as the `config.view` parameter, it will be used to generate both boundary elements. The function
	 * receives the `data` object as a parameter and should return an instance of the
	 * {@link module:engine/view/uielement~UIElement view UI element}. The `data` object and
	 * {@link module:engine/conversion/downcastdispatcher~DowncastConversionApi `conversionApi`} are passed from
	 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}. Additionally,
	 * the `data.isOpening` parameter is passed, which is set to `true` for the marker start boundary element, and `false` to
	 * the marker end boundary element.
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #markerToElement
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or model marker group) to convert.
	 * @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
	 * that takes the model marker data as a parameter and returns a view UI element.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToElement( config ) {
		return this.add( downcastMarkerToElement( config ) );
	}

	/**
	 * Model marker to highlight conversion helper.
	 *
	 * This conversion results in creating a highlight on view nodes. For this kind of conversion,
	 * {@link module:engine/conversion/downcasthelpers~HighlightDescriptor} should be provided.
	 *
	 * For text nodes, a `<span>` {@link module:engine/view/attributeelement~AttributeElement} is created and it wraps all text nodes
	 * in the converted marker range. For example, a model marker set like this: `<paragraph>F[oo b]ar</paragraph>` becomes
	 * `<p>F<span class="comment">oo b</span>ar</p>` in the view.
	 *
	 * {@link module:engine/view/containerelement~ContainerElement} may provide a custom way of handling highlight. Most often,
	 * the element itself is given classes and attributes described in the highlight descriptor (instead of being wrapped in `<span>`).
	 * For example, a model marker set like this: `[<image src="foo.jpg"></image>]` becomes `<img src="foo.jpg" class="comment"></img>`
	 * in the view.
	 *
	 * For container elements, the conversion is two-step. While the converter processes the highlight descriptor and passes it
	 * to a container element, it is the container element instance itself that applies values from the highlight descriptor.
	 * So, in a sense, the converter takes care of stating what should be applied on what, while the element decides how to apply that.
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( { model: 'comment', view: { classes: 'comment' } } );
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( {
	 *			model: 'comment',
	 *			view: { classes: 'new-comment' },
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'downcast' ).markerToHighlight( {
	 *			model: 'comment',
	 *			view: data => {
	 *				// Assuming that the marker name is in a form of comment:commentType.
	 *				const commentType = data.markerName.split( ':' )[ 1 ];
	 *
	 *				return {
	 *					classes: [ 'comment', 'comment-' + commentType ]
	 *				};
	 *			}
	 *		} );
	 *
	 * If a function is passed as the `config.view` parameter, it will be used to generate the highlight descriptor. The function
	 * receives the `data` object as a parameter and should return a
	 * {@link module:engine/conversion/downcasthelpers~HighlightDescriptor highlight descriptor}.
	 * The `data` object properties are passed from {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker}.
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #markerToHighlight
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or model marker group) to convert.
	 * @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} config.view A highlight descriptor
	 * that will be used for highlighting or a function that takes the model marker data as a parameter and returns a highlight descriptor.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToHighlight( config ) {
		return this.add( downcastMarkerToHighlight( config ) );
	}

	/**
	 * Model marker converter for data downcast.
	 *
	 * This conversion creates a representation for model marker boundaries in the view:
	 *
	 * * if the marker boundary is at a position where text nodes are allowed, then a view element with specified tag name
	 * and `name` attribute is added at that position,
	 * * in other cases, a specified attribute is set on a view element that is before/after marker boundary.
	 *
	 * Typically, the marker names use `group:uniqueId:otherData` convention. For example: `comment:e34zfk9k2n459df53sjl34:zx32c`.
	 * The default configuration for this conversion is that the first part is `group` part and the rest of
	 * the marker name becomes `name` part.
	 *
	 * Tag and attribute names and values are generated from the marker name:
	 *
	 * * templates for attributes are `data-[group]-start-before="[name]"`, `data-[group]-start-after="[name]"`,
	 * `data-[group]-end-before="[name]"` and `data-[group]-end-after="[name]"`,
	 * * templates for view elements are `<[group]-start name="[name]">` and `<[group]-end name="[name]">`.
	 *
	 * Attributes mark whether given marker start or end boundary is before or after given element.
	 * Attributes `data-[group]-start-before` and `data-[group]-end-after` are favored.
	 * The other two are used when the former two cannot be used.
	 *
	 * The conversion configuration can take a function that will generate different group and name parts.
	 * If such function is set as the `config.view` parameter, it is passed a marker name and it is expected to return an object with two
	 * properties: `group` and `name`. If the function returns falsy value, the conversion will not take place.
	 *
	 * Basic usage:
	 *
	 *		// Using the default conversion.
	 *		// In this case, all markers which name starts with 'comment:' will be converted.
	 *		// The `group` parameter will be set to `comment`.
	 *		// The `name` parameter will be the rest of the marker name (without `:`).
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *		} );
	 *
	 * An example of a view that may be generated by this conversion (assuming a marker with name `comment:commentId:uid` marked by `[]`):
	 *
	 *		// Model:
	 *		<paragraph>Foo[bar</paragraph>
	 *		<image src="abc.jpg"></image>]
	 *
	 *		// View:
	 *		<p>Foo<comment-start name="commentId:uid"></comment-start>bar</p>
	 *		<figure data-comment-end-after="commentId:uid" class="image"><img src="abc.jpg" /></figure>
	 *
	 * In the example above, the comment starts before "bar" and ends after the image.
	 *
	 * If `name` part is empty, following view may be generated:
	 *
	 *		<p>Foo <myMarker-start></myMarker-start>bar</p>
	 *		<figure data-myMarker-end-after="" class="image"><img src="abc.jpg" /></figure>
	 *
	 * **Note:** situation when some markers have `name` part and some don't is incorrect and should be avoided.
	 *
	 * Examples where `data-group-start-after` and `data-group-end-before` are used:
	 *
	 *		// Model:
	 *		<blockQuote>[]<paragraph>Foo</paragraph></blockQuote>
	 *
	 * 		// View:
	 *		<blockquote><p data-group-end-before="name" data-group-start-before="name">Foo</p></blockquote>
	 *
	 * Similarly, when marker is collapsed after the last element:
	 *
	 *		// Model:
	 *		<blockQuote><paragraph>Foo</paragraph>[]</blockQuote>
	 *
	 *		// View:
	 *		<blockquote><p data-group-end-after="name" data-group-start-after="name">Foo</p></blockquote>
	 *
	 * When there are multiple markers from the same group stored in the same attribute of the same element, their
	 * name parts are put together in the attribute value, for example: `data-group-start-before="name1,name2,name3"`.
	 *
	 * Other examples of usage:
	 *
	 *		// Using custom function which is the same as the default conversion:
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *			view: markerName => ( {
	 *				group: 'comment',
	 *				name: markerName.substr( 8 ) // Removes 'comment:' part.
	 *			} )
	 *		} );
	 *
	 *		// Using converter priority:
	 *		editor.conversion.for( 'dataDowncast' ).markerToData( {
	 *			model: 'comment'
	 *			view: markerName => ( {
	 *				group: 'comment',
	 *				name: markerName.substr( 8 ) // Removes 'comment:' part.
	 *			} ),
	 *			converterPriority: 'high'
	 *		} );
	 *
	 * This kind of conversion is useful for saving data into the database, so it should be used in the data conversion pipeline.
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #markerToData
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.model The name of the model marker (or model marker group) to convert.
	 * @param {Function} [config.view] Function that takes the model marker name as a parameter and returns an object with `group`
	 * and `name` properties.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/downcasthelpers~DowncastHelpers}
	 */
	markerToData( config ) {
		return this.add( downcastMarkerToData( config ) );
	}
}

/**
 * Function factory that creates a default downcast converter for text insertion changes.
 *
 * The converter automatically consumes the corresponding value from the consumables list and stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
 *
 *		modelDispatcher.on( 'insert:$text', insertText() );
 *
 * @returns {Function} Insert text event converter.
 */
function insertText() {
	return ( evt, data, conversionApi ) => {
		if ( !conversionApi.consumable.consume( data.item, 'insert' ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );
		const viewText = viewWriter.createText( data.item.data );

		viewWriter.insert( viewPosition, viewText );
	};
}

/**
 * Function factory that creates a default downcast converter for node remove changes.
 *
 *		modelDispatcher.on( 'remove', remove() );
 *
 * @returns {Function} Remove event converter.
 */
function remove() {
	return ( evt, data, conversionApi ) => {
		// Find view range start position by mapping model position at which the remove happened.
		const viewStart = conversionApi.mapper.toViewPosition( data.position );

		const modelEnd = data.position.getShiftedBy( data.length );
		const viewEnd = conversionApi.mapper.toViewPosition( modelEnd, { isPhantom: true } );

		const viewRange = conversionApi.writer.createRange( viewStart, viewEnd );

		// Trim the range to remove in case some UI elements are on the view range boundaries.
		const removed = conversionApi.writer.remove( viewRange.getTrimmed() );

		// After the range is removed, unbind all view elements from the model.
		// Range inside view document fragment is used to unbind deeply.
		for ( const child of conversionApi.writer.createRangeIn( removed ).getItems() ) {
			conversionApi.mapper.unbindViewElement( child );
		}
	};
}

/**
 * Creates a `<span>` {@link module:engine/view/attributeelement~AttributeElement view attribute element} from the information
 * provided by the {@link module:engine/conversion/downcasthelpers~HighlightDescriptor highlight descriptor} object. If a priority
 * is not provided in the descriptor, the default priority will be used.
 *
 * @param {module:engine/view/downcastwriter~DowncastWriter} writer
 * @param {module:engine/conversion/downcasthelpers~HighlightDescriptor} descriptor
 * @returns {module:engine/view/attributeelement~AttributeElement}
 */
function createViewElementFromHighlightDescriptor( writer, descriptor ) {
	const viewElement = writer.createAttributeElement( 'span', descriptor.attributes );

	if ( descriptor.classes ) {
		viewElement._addClass( descriptor.classes );
	}

	if ( descriptor.priority ) {
		viewElement._priority = descriptor.priority;
	}

	viewElement._id = descriptor.id;

	return viewElement;
}

/**
 * Function factory that creates a converter which converts a non-collapsed {@link module:engine/model/selection~Selection model selection}
 * to a {@link module:engine/view/documentselection~DocumentSelection view selection}. The converter consumes appropriate
 * value from the `consumable` object and maps model positions from the selection to view positions.
 *
 *		modelDispatcher.on( 'selection', convertRangeSelection() );
 *
 * @returns {Function} Selection converter.
 */
function convertRangeSelection() {
	return ( evt, data, conversionApi ) => {
		const selection = data.selection;

		if ( selection.isCollapsed ) {
			return;
		}

		if ( !conversionApi.consumable.consume( selection, 'selection' ) ) {
			return;
		}

		const viewRanges = [];

		for ( const range of selection.getRanges() ) {
			const viewRange = conversionApi.mapper.toViewRange( range );
			viewRanges.push( viewRange );
		}

		conversionApi.writer.setSelection( viewRanges, { backward: selection.isBackward } );
	};
}

/**
 * Function factory that creates a converter which converts a collapsed {@link module:engine/model/selection~Selection model selection} to
 * a {@link module:engine/view/documentselection~DocumentSelection view selection}. The converter consumes appropriate
 * value from the `consumable` object, maps the model selection position to the view position and breaks
 * {@link module:engine/view/attributeelement~AttributeElement attribute elements} at the selection position.
 *
 *		modelDispatcher.on( 'selection', convertCollapsedSelection() );
 *
 * An example of the view state before and after converting the collapsed selection:
 *
 *		   <p><strong>f^oo<strong>bar</p>
 *		-> <p><strong>f</strong>^<strong>oo</strong>bar</p>
 *
 * By breaking attribute elements like `<strong>`, the selection is in a correct element. Then, when the selection attribute is
 * converted, broken attributes might be merged again, or the position where the selection is may be wrapped
 * with different, appropriate attribute elements.
 *
 * See also {@link module:engine/conversion/downcasthelpers~clearAttributes} which does a clean-up
 * by merging attributes.
 *
 * @returns {Function} Selection converter.
 */
function convertCollapsedSelection() {
	return ( evt, data, conversionApi ) => {
		const selection = data.selection;

		if ( !selection.isCollapsed ) {
			return;
		}

		if ( !conversionApi.consumable.consume( selection, 'selection' ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const modelPosition = selection.getFirstPosition();
		const viewPosition = conversionApi.mapper.toViewPosition( modelPosition );
		const brokenPosition = viewWriter.breakAttributes( viewPosition );

		viewWriter.setSelection( brokenPosition );
	};
}

/**
 * Function factory that creates a converter which clears artifacts after the previous
 * {@link module:engine/model/selection~Selection model selection} conversion. It removes all empty
 * {@link module:engine/view/attributeelement~AttributeElement view attribute elements} and merges sibling attributes at all start and end
 * positions of all ranges.
 *
 *		   <p><strong>^</strong></p>
 *		-> <p>^</p>
 *
 *		   <p><strong>foo</strong>^<strong>bar</strong>bar</p>
 *		-> <p><strong>foo^bar<strong>bar</p>
 *
 *		   <p><strong>foo</strong><em>^</em><strong>bar</strong>bar</p>
 *		-> <p><strong>foo^bar<strong>bar</p>
 *
 * This listener should be assigned before any converter for the new selection:
 *
 *		modelDispatcher.on( 'selection', clearAttributes() );
 *
 * See {@link module:engine/conversion/downcasthelpers~convertCollapsedSelection}
 * which does the opposite by breaking attributes in the selection position.
 *
 * @returns {Function} Selection converter.
 */
function clearAttributes() {
	return ( evt, data, conversionApi ) => {
		const viewWriter = conversionApi.writer;
		const viewSelection = viewWriter.document.selection;

		for ( const range of viewSelection.getRanges() ) {
			// Not collapsed selection should not have artifacts.
			if ( range.isCollapsed ) {
				// Position might be in the node removed by the view writer.
				if ( range.end.parent.isAttached() ) {
					conversionApi.writer.mergeAttributes( range.start );
				}
			}
		}
		viewWriter.setSelection( null );
	};
}

/**
 * Function factory that creates a converter which converts set/change/remove attribute changes from the model to the view.
 * It can also be used to convert selection attributes. In that case, an empty attribute element will be created and the
 * selection will be put inside it.
 *
 * Attributes from the model are converted to a view element that will be wrapping these view nodes that are bound to
 * model elements having the given attribute. This is useful for attributes like `bold` that may be set on text nodes in the model
 * but are represented as an element in the view:
 *
 *		[paragraph]              MODEL ====> VIEW        <p>
 *			|- a {bold: true}                             |- <b>
 *			|- b {bold: true}                             |   |- ab
 *			|- c                                          |- c
 *
 * Passed `Function` will be provided with the attribute value and then all the parameters of the
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:attribute `attribute` event}.
 * It is expected that the function returns an {@link module:engine/view/element~Element}.
 * The result of the function will be the wrapping element.
 * When the provided `Function` does not return any element, no conversion will take place.
 *
 * The converter automatically consumes the corresponding value from the consumables list and stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
 *
 *		modelDispatcher.on( 'attribute:bold', wrap( ( modelAttributeValue, viewWriter ) => {
 *			return viewWriter.createAttributeElement( 'strong' );
 *		} );
 *
 * @protected
 * @param {Function} elementCreator Function returning a view element that will be used for wrapping.
 * @returns {Function} Set/change attribute converter.
 */
function wrap( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		// Recreate current wrapping node. It will be used to unwrap view range if the attribute value has changed
		// or the attribute was removed.
		const oldViewElement = elementCreator( data.attributeOldValue, conversionApi.writer );

		// Create node to wrap with.
		const newViewElement = elementCreator( data.attributeNewValue, conversionApi.writer );

		if ( !oldViewElement && !newViewElement ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewSelection = viewWriter.document.selection;

		if ( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			// Selection attribute conversion.
			viewWriter.wrap( viewSelection.getFirstRange(), newViewElement );
		} else {
			// Node attribute conversion.
			let viewRange = conversionApi.mapper.toViewRange( data.range );

			// First, unwrap the range from current wrapper.
			if ( data.attributeOldValue !== null && oldViewElement ) {
				viewRange = viewWriter.unwrap( viewRange, oldViewElement );
			}

			if ( data.attributeNewValue !== null && newViewElement ) {
				viewWriter.wrap( viewRange, newViewElement );
			}
		}
	};
}

/**
 * Function factory that creates a converter which converts node insertion changes from the model to the view.
 * The function passed will be provided with all the parameters of the dispatcher's
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:insert `insert` event}.
 * It is expected that the function returns an {@link module:engine/view/element~Element}.
 * The result of the function will be inserted into the view.
 *
 * The converter automatically consumes the corresponding value from the consumables list, stops the event (see
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}) and binds the model and view elements.
 *
 *		downcastDispatcher.on(
 *			'insert:myElem',
 *			insertElement( ( modelItem, viewWriter ) => {
 *				const text = viewWriter.createText( 'myText' );
 *				const myElem = viewWriter.createElement( 'myElem', { myAttr: 'my-' + modelItem.getAttribute( 'myAttr' ) }, text );
 *
 *				// Do something fancy with `myElem` using `modelItem` or other parameters.
 *
 *				return myElem;
 *			}
 *		) );
 *
 * @protected
 * @param {Function} elementCreator Function returning a view element, which will be inserted.
 * @returns {Function} Insert element event converter.
 */
function insertElement( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewElement = elementCreator( data.item, conversionApi.writer );

		if ( !viewElement ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, 'insert' ) ) {
			return;
		}

		const viewPosition = conversionApi.mapper.toViewPosition( data.range.start );

		conversionApi.mapper.bindElements( data.item, viewElement );
		conversionApi.writer.insert( viewPosition, viewElement );
	};
}

/**
 * Function factory that creates a converter which converts marker adding change to the
 * {@link module:engine/view/uielement~UIElement view UI element}.
 *
 * The view UI element that will be added to the view depends on the passed parameter. See {@link ~insertElement}.
 * In case of a non-collapsed range, the UI element will not wrap nodes but separate elements will be placed at the beginning
 * and at the end of the range.
 *
 * This converter binds created UI elements with the marker name using {@link module:engine/conversion/mapper~Mapper#bindElementToMarker}.
 *
 * @protected
 * @param {module:engine/view/uielement~UIElement|Function} elementCreator A view UI element or a function returning the view element
 * that will be inserted.
 * @returns {Function} Insert element event converter.
 */
function insertUIElement( elementCreator ) {
	return ( evt, data, conversionApi ) => {
		// Create two view elements. One will be inserted at the beginning of marker, one at the end.
		// If marker is collapsed, only "opening" element will be inserted.
		data.isOpening = true;
		const viewStartElement = elementCreator( data, conversionApi.writer );

		data.isOpening = false;
		const viewEndElement = elementCreator( data, conversionApi.writer );

		if ( !viewStartElement || !viewEndElement ) {
			return;
		}

		const markerRange = data.markerRange;

		// Marker that is collapsed has consumable build differently that non-collapsed one.
		// For more information see `addMarker` event description.
		// If marker's range is collapsed - check if it can be consumed.
		if ( markerRange.isCollapsed && !conversionApi.consumable.consume( markerRange, evt.name ) ) {
			return;
		}

		// If marker's range is not collapsed - consume all items inside.
		for ( const value of markerRange ) {
			if ( !conversionApi.consumable.consume( value.item, evt.name ) ) {
				return;
			}
		}

		const mapper = conversionApi.mapper;
		const viewWriter = conversionApi.writer;

		// Add "opening" element.
		viewWriter.insert( mapper.toViewPosition( markerRange.start ), viewStartElement );
		conversionApi.mapper.bindElementToMarker( viewStartElement, data.markerName );

		// Add "closing" element only if range is not collapsed.
		if ( !markerRange.isCollapsed ) {
			viewWriter.insert( mapper.toViewPosition( markerRange.end ), viewEndElement );
			conversionApi.mapper.bindElementToMarker( viewEndElement, data.markerName );
		}

		evt.stop();
	};
}

// Function factory that returns a default downcast converter for removing a {@link module:engine/view/uielement~UIElement UI element}
// basing on marker remove change.
//
// This converter unbinds elements from the marker name.
//
// @returns {Function} Removed UI element converter.
function removeUIElement() {
	return ( evt, data, conversionApi ) => {
		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );
			conversionApi.writer.clear( conversionApi.writer.createRangeOn( element ), element );
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();
	};
}

// Function factory that creates a default converter for model markers.
//
// See {@link DowncastHelpers#markerToData} for more information what type of view is generated.
//
// This converter binds created UI elements and affected view elements with the marker name
// using {@link module:engine/conversion/mapper~Mapper#bindElementToMarker}.
//
// @returns {Function} Add marker converter.
function insertMarkerData( viewCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewMarkerData = viewCreator( data.markerName );

		if ( !viewMarkerData ) {
			return;
		}

		const markerRange = data.markerRange;

		if ( !conversionApi.consumable.consume( markerRange, evt.name ) ) {
			return;
		}

		// Adding closing data first to keep the proper order in the view.
		handleMarkerBoundary( markerRange, false, conversionApi, data, viewMarkerData );
		handleMarkerBoundary( markerRange, true, conversionApi, data, viewMarkerData );

		evt.stop();
	};
}

// Helper function for `insertMarkerData()` that marks a marker boundary at the beginning or end of given `range`.
function handleMarkerBoundary( range, isStart, conversionApi, data, viewMarkerData ) {
	const modelPosition = isStart ? range.start : range.end;
	const canInsertElement = conversionApi.schema.checkChild( modelPosition, '$text' );

	if ( canInsertElement ) {
		const viewPosition = conversionApi.mapper.toViewPosition( modelPosition );

		insertMarkerAsElement( viewPosition, isStart, conversionApi, data, viewMarkerData );
	} else {
		let modelElement;
		let isBefore;

		// If possible, we want to add `data-group-start-before` and `data-group-end-after` attributes.
		// Below `if` is constructed in a way that will favor adding these attributes.
		//
		// Also, I assume that there will be always an element either after or before the position.
		// If not, then it is a case when we are not in a position where text is allowed and also there are no elements around...
		if ( isStart && modelPosition.nodeAfter || !isStart && !modelPosition.nodeBefore ) {
			modelElement = modelPosition.nodeAfter;
			isBefore = true;
		} else {
			modelElement = modelPosition.nodeBefore;
			isBefore = false;
		}

		const viewElement = conversionApi.mapper.toViewElement( modelElement );

		insertMarkerAsAttribute( viewElement, isStart, isBefore, conversionApi, data, viewMarkerData );
	}
}

// Helper function for `insertMarkerData()` that marks a marker boundary in the view as an attribute on a view element.
function insertMarkerAsAttribute( viewElement, isStart, isBefore, conversionApi, data, viewMarkerData ) {
	const attributeName = `data-${ viewMarkerData.group }-${ isStart ? 'start' : 'end' }-${ isBefore ? 'before' : 'after' }`;

	const markerNames = viewElement.hasAttribute( attributeName ) ? viewElement.getAttribute( attributeName ).split( ',' ) : [];

	// Adding marker name at the beginning to have the same order in the attribute as there is with marker elements.
	markerNames.unshift( viewMarkerData.name );

	conversionApi.writer.setAttribute( attributeName, markerNames.join( ',' ), viewElement );
	conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
}

// Helper function for `insertMarkerData()` that marks a marker boundary in the view as a separate view ui element.
function insertMarkerAsElement( position, isStart, conversionApi, data, viewMarkerData ) {
	const viewElementName = `${ viewMarkerData.group }-${ isStart ? 'start' : 'end' }`;

	const attrs = viewMarkerData.name ? { 'name': viewMarkerData.name } : null;
	const viewElement = conversionApi.writer.createUIElement( viewElementName, attrs );

	conversionApi.writer.insert( position, viewElement );
	conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
}

// Function factory that creates a converter for removing a model marker data added by the {@link #insertMarkerData} converter.
//
// @returns {Function} Remove marker converter.
function removeMarkerData( viewCreator ) {
	return ( evt, data, conversionApi ) => {
		const viewData = viewCreator( data.markerName );

		if ( !viewData ) {
			return;
		}

		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );

			if ( element.is( 'containerElement' ) ) {
				removeMarkerFromAttribute( `data-${ viewData.group }-start-before`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-start-after`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-end-before`, element );
				removeMarkerFromAttribute( `data-${ viewData.group }-end-after`, element );
			} else {
				conversionApi.writer.clear( conversionApi.writer.createRangeOn( element ), element );
			}
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();

		function removeMarkerFromAttribute( attributeName, element ) {
			if ( element.hasAttribute( attributeName ) ) {
				const markerNames = new Set( element.getAttribute( attributeName ).split( ',' ) );
				markerNames.delete( viewData.name );

				if ( markerNames.size == 0 ) {
					conversionApi.writer.removeAttribute( attributeName, element );
				} else {
					conversionApi.writer.setAttribute( attributeName, Array.from( markerNames ).join( ',' ), element );
				}
			}
		}
	};
}

// Function factory that creates a converter which converts set/change/remove attribute changes from the model to the view.
//
// Attributes from the model are converted to the view element attributes in the view. You may provide a custom function to generate
// a key-value attribute pair to add/change/remove. If not provided, model attributes will be converted to view element
// attributes on a one-to-one basis.
//
// *Note:** The provided attribute creator should always return the same `key` for a given attribute from the model.
//
// The converter automatically consumes the corresponding value from the consumables list and stops the event (see
// {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}).
//
//		modelDispatcher.on( 'attribute:customAttr:myElem', changeAttribute( ( value, data ) => {
//			// Change attribute key from `customAttr` to `class` in the view.
//			const key = 'class';
//			let value = data.attributeNewValue;
//
//			// Force attribute value to 'empty' if the model element is empty.
//			if ( data.item.childCount === 0 ) {
//				value = 'empty';
//			}
//
//			// Return the key-value pair.
//			return { key, value };
//		} ) );
//
// @param {Function} [attributeCreator] Function returning an object with two properties: `key` and `value`, which
// represent the attribute key and attribute value to be set on a {@link module:engine/view/element~Element view element}.
// The function is passed the model attribute value as the first parameter and additional data about the change as the second parameter.
// @returns {Function} Set/change attribute converter.
function changeAttribute( attributeCreator ) {
	return ( evt, data, conversionApi ) => {
		const oldAttribute = attributeCreator( data.attributeOldValue, data );
		const newAttribute = attributeCreator( data.attributeNewValue, data );

		if ( !oldAttribute && !newAttribute ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewElement = conversionApi.mapper.toViewElement( data.item );
		const viewWriter = conversionApi.writer;

		// If model item cannot be mapped to a view element, it means item is not an `Element` instance but a `TextProxy` node.
		// Only elements can have attributes in a view so do not proceed for anything else (#1587).
		if ( !viewElement ) {
			/**
			 * This error occurs when a {@link module:engine/model/textproxy~TextProxy text node's} attribute is to be downcasted
			 * by {@link module:engine/conversion/conversion~Conversion#attributeToAttribute `Attribute to Attribute converter`}.
			 * In most cases it is caused by converters misconfiguration when only "generic" converter is defined:
			 *
			 *		editor.conversion.for( 'downcast' ).attributeToAttribute( {
			 *			model: 'attribute-name',
			 *			view: 'attribute-name'
			 *		} ) );
			 *
			 * and given attribute is used on text node, for example:
			 *
			 *		model.change( writer => {
			 *			writer.insertText( 'Foo', { 'attribute-name': 'bar' }, parent, 0 );
			 *		} );
			 *
			 * In such cases, to convert the same attribute for both {@link module:engine/model/element~Element}
			 * and {@link module:engine/model/textproxy~TextProxy `Text`} nodes, text specific
			 * {@link module:engine/conversion/conversion~Conversion#attributeToElement `Attribute to Element converter`}
			 * with higher {@link module:utils/priorities~PriorityString priority} must also be defined:
			 *
			 *		editor.conversion.for( 'downcast' ).attributeToElement( {
			 *			model: {
			 *				key: 'attribute-name',
			 *				name: '$text'
			 *			},
			 *			view: ( value, writer ) => {
			 *				return writer.createAttributeElement( 'span', { 'attribute-name': value } );
			 *			},
			 *			converterPriority: 'high'
			 *		} ) );
			 *
			 * @error conversion-attribute-to-attribute-on-text
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__["default"](
				'conversion-attribute-to-attribute-on-text: ' +
				'Trying to convert text node\'s attribute with attribute-to-attribute converter.',
				[ data, conversionApi ]
			);
		}

		// First remove the old attribute if there was one.
		if ( data.attributeOldValue !== null && oldAttribute ) {
			if ( oldAttribute.key == 'class' ) {
				const classes = Array.isArray( oldAttribute.value ) ? oldAttribute.value : [ oldAttribute.value ];

				for ( const className of classes ) {
					viewWriter.removeClass( className, viewElement );
				}
			} else if ( oldAttribute.key == 'style' ) {
				const keys = Object.keys( oldAttribute.value );

				for ( const key of keys ) {
					viewWriter.removeStyle( key, viewElement );
				}
			} else {
				viewWriter.removeAttribute( oldAttribute.key, viewElement );
			}
		}

		// Then set the new attribute.
		if ( data.attributeNewValue !== null && newAttribute ) {
			if ( newAttribute.key == 'class' ) {
				const classes = Array.isArray( newAttribute.value ) ? newAttribute.value : [ newAttribute.value ];

				for ( const className of classes ) {
					viewWriter.addClass( className, viewElement );
				}
			} else if ( newAttribute.key == 'style' ) {
				const keys = Object.keys( newAttribute.value );

				for ( const key of keys ) {
					viewWriter.setStyle( key, newAttribute.value[ key ], viewElement );
				}
			} else {
				viewWriter.setAttribute( newAttribute.key, newAttribute.value, viewElement );
			}
		}
	};
}

// Function factory that creates a converter which converts the text inside marker's range. The converter wraps the text with
// {@link module:engine/view/attributeelement~AttributeElement} created from the provided descriptor.
// See {link module:engine/conversion/downcasthelpers~createViewElementFromHighlightDescriptor}.
//
// It can also be used to convert the selection that is inside a marker. In that case, an empty attribute element will be
// created and the selection will be put inside it.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter binds the created {@link module:engine/view/attributeelement~AttributeElement attribute elemens} with the marker name
// using the {@link module:engine/conversion/mapper~Mapper#bindElementToMarker} method.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function highlightText( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		if ( !data.item ) {
			return;
		}

		if ( !( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) && !data.item.is( '$textProxy' ) ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		if ( !conversionApi.consumable.consume( data.item, evt.name ) ) {
			return;
		}

		const viewWriter = conversionApi.writer;
		const viewElement = createViewElementFromHighlightDescriptor( viewWriter, descriptor );
		const viewSelection = viewWriter.document.selection;

		if ( data.item instanceof _model_selection__WEBPACK_IMPORTED_MODULE_1__["default"] || data.item instanceof _model_documentselection__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			viewWriter.wrap( viewSelection.getFirstRange(), viewElement, viewSelection );
		} else {
			const viewRange = conversionApi.mapper.toViewRange( data.range );
			const rangeAfterWrap = viewWriter.wrap( viewRange, viewElement );

			for ( const element of rangeAfterWrap.getItems() ) {
				if ( element.is( 'attributeElement' ) && element.isSimilar( viewElement ) ) {
					conversionApi.mapper.bindElementToMarker( element, data.markerName );

					// One attribute element is enough, because all of them are bound together by the view writer.
					// Mapper uses this binding to get all the elements no matter how many of them are registered in the mapper.
					break;
				}
			}
		}
	};
}

// Converter function factory. It creates a function which applies the marker's highlight to an element inside the marker's range.
//
// The converter checks if an element has the `addHighlight` function stored as a
// {@link module:engine/view/element~Element#_setCustomProperty custom property} and, if so, uses it to apply the highlight.
// In such case the converter will consume all element's children, assuming that they were handled by the element itself.
//
// When the `addHighlight` custom property is not present, the element is not converted in any special way.
// This means that converters will proceed to convert the element's child nodes.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter binds altered {@link module:engine/view/containerelement~ContainerElement container elements} with the marker name using
// the {@link module:engine/conversion/mapper~Mapper#bindElementToMarker} method.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function highlightElement( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		if ( !data.item ) {
			return;
		}

		if ( !( data.item instanceof _model_element__WEBPACK_IMPORTED_MODULE_2__["default"] ) ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		if ( !conversionApi.consumable.test( data.item, evt.name ) ) {
			return;
		}

		const viewElement = conversionApi.mapper.toViewElement( data.item );

		if ( viewElement && viewElement.getCustomProperty( 'addHighlight' ) ) {
			// Consume element itself.
			conversionApi.consumable.consume( data.item, evt.name );

			// Consume all children nodes.
			for ( const value of _model_range__WEBPACK_IMPORTED_MODULE_0__["default"]._createIn( data.item ) ) {
				conversionApi.consumable.consume( value.item, evt.name );
			}

			viewElement.getCustomProperty( 'addHighlight' )( viewElement, descriptor, conversionApi.writer );

			conversionApi.mapper.bindElementToMarker( viewElement, data.markerName );
		}
	};
}

// Function factory that creates a converter which converts the removing model marker to the view.
//
// Both text nodes and elements are handled by this converter but they are handled a bit differently.
//
// Text nodes are unwrapped using the {@link module:engine/view/attributeelement~AttributeElement attribute element} created from the
// provided highlight descriptor. See {link module:engine/conversion/downcasthelpers~HighlightDescriptor}.
//
// For elements, the converter checks if an element has the `removeHighlight` function stored as a
// {@link module:engine/view/element~Element#_setCustomProperty custom property}. If so, it uses it to remove the highlight.
// In such case, the children of that element will not be converted.
//
// When `removeHighlight` is not present, the element is not converted in any special way.
// The converter will proceed to convert the element's child nodes instead.
//
// If the highlight descriptor does not provide the `priority` property, `10` will be used.
//
// If the highlight descriptor does not provide the `id` property, the name of the marker will be used.
//
// This converter unbinds elements from the marker name.
//
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} highlightDescriptor
// @returns {Function}
function removeHighlight( highlightDescriptor ) {
	return ( evt, data, conversionApi ) => {
		// This conversion makes sense only for non-collapsed range.
		if ( data.markerRange.isCollapsed ) {
			return;
		}

		const descriptor = prepareDescriptor( highlightDescriptor, data, conversionApi );

		if ( !descriptor ) {
			return;
		}

		// View element that will be used to unwrap `AttributeElement`s.
		const viewHighlightElement = createViewElementFromHighlightDescriptor( conversionApi.writer, descriptor );

		// Get all elements bound with given marker name.
		const elements = conversionApi.mapper.markerNameToElements( data.markerName );

		if ( !elements ) {
			return;
		}

		for ( const element of elements ) {
			conversionApi.mapper.unbindElementFromMarkerName( element, data.markerName );

			if ( element.is( 'attributeElement' ) ) {
				conversionApi.writer.unwrap( conversionApi.writer.createRangeOn( element ), viewHighlightElement );
			} else {
				// if element.is( 'containerElement' ).
				element.getCustomProperty( 'removeHighlight' )( element, descriptor.id, conversionApi.writer );
			}
		}

		conversionApi.writer.clearClonedElementsGroup( data.markerName );

		evt.stop();
	};
}

// Model element to view element conversion helper.
//
// See {@link ~DowncastHelpers#elementToElement `.elementToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model The name of the model element to convert.
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
// that takes the model element and {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer}
// as parameters and returns a view container element.
// @returns {Function} Conversion helper.
function downcastElementToElement( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"])( config );

	config.view = normalizeToElementConfig( config.view, 'container' );

	return dispatcher => {
		dispatcher.on( 'insert:' + config.model, insertElement( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model attribute to view element conversion helper.
//
// See {@link ~DowncastHelpers#attributeToElement `.attributeToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values }` object. `values` is an array
// of `String`s with possible values if the model attribute is an enumerable.
// @param {module:engine/view/elementdefinition~ElementDefinition|Function|Object} config.view A view element definition or a function
// that takes the model attribute value and {@link module:engine/view/downcastwriter~DowncastWriter view downcast writer}
// as parameters and returns a view attribute element. If `config.model.values` is
// given, `config.view` should be an object assigning values from `config.model.values` to view element definitions or functions.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastAttributeToElement( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"])( config );

	const modelKey = config.model.key ? config.model.key : config.model;
	let eventName = 'attribute:' + modelKey;

	if ( config.model.name ) {
		eventName += ':' + config.model.name;
	}

	if ( config.model.values ) {
		for ( const modelValue of config.model.values ) {
			config.view[ modelValue ] = normalizeToElementConfig( config.view[ modelValue ], 'attribute' );
		}
	} else {
		config.view = normalizeToElementConfig( config.view, 'attribute' );
	}

	const elementCreator = getFromAttributeCreator( config );

	return dispatcher => {
		dispatcher.on( eventName, wrap( elementCreator ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model attribute to view attribute conversion helper.
//
// See {@link ~DowncastHelpers#attributeToAttribute `.attributeToAttribute()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.model The key of the attribute to convert from or a `{ key, values, [ name ] }` object describing
// the attribute key, possible values and, optionally, an element name to convert from.
// @param {String|Object|Function} config.view A view attribute key, or a `{ key, value }` object or a function that takes
// the model attribute value and returns a `{ key, value }` object. If `key` is `'class'`, `value` can be a `String` or an
// array of `String`s. If `key` is `'style'`, `value` is an object with key-value pairs. In other cases, `value` is a `String`.
// If `config.model.values` is set, `config.view` should be an object assigning values from `config.model.values` to
// `{ key, value }` objects or a functions.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastAttributeToAttribute( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"])( config );

	const modelKey = config.model.key ? config.model.key : config.model;
	let eventName = 'attribute:' + modelKey;

	if ( config.model.name ) {
		eventName += ':' + config.model.name;
	}

	if ( config.model.values ) {
		for ( const modelValue of config.model.values ) {
			config.view[ modelValue ] = normalizeToAttributeConfig( config.view[ modelValue ] );
		}
	} else {
		config.view = normalizeToAttributeConfig( config.view );
	}

	const elementCreator = getFromAttributeCreator( config );

	return dispatcher => {
		dispatcher.on( eventName, changeAttribute( elementCreator ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to view element conversion helper.
//
// See {@link ~DowncastHelpers#markerToElement `.markerToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model The name of the model marker (or model marker group) to convert.
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} config.view A view element definition or a function
// that takes the model marker data as a parameter and returns a view UI element.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastMarkerToElement( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"])( config );

	config.view = normalizeToElementConfig( config.view, 'ui' );

	return dispatcher => {
		dispatcher.on( 'addMarker:' + config.model, insertUIElement( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + config.model, removeUIElement( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to view data conversion helper.
//
// See {@link ~DowncastHelpers#markerToData `markerToData()` downcast helper} to learn more.
//
// @param {Object} config
// @param {String} config.model
// @param {Function} [config.view]
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal']
// @returns {Function} Conversion helper.
function downcastMarkerToData( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_6__["cloneDeep"])( config );

	const group = config.model;

	// Default conversion.
	if ( !config.view ) {
		config.view = markerName => ( {
			group,
			name: markerName.substr( config.model.length + 1 )
		} );
	}

	return dispatcher => {
		dispatcher.on( 'addMarker:' + group, insertMarkerData( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + group, removeMarkerData( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Model marker to highlight conversion helper.
//
// See {@link ~DowncastHelpers#markerToElement `.markerToElement()` downcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String} config.model The name of the model marker (or model marker group) to convert.
// @param {module:engine/conversion/downcasthelpers~HighlightDescriptor|Function} config.view A highlight descriptor
// that will be used for highlighting or a function that takes the model marker data as a parameter and returns a highlight descriptor.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function downcastMarkerToHighlight( config ) {
	return dispatcher => {
		dispatcher.on( 'addMarker:' + config.model, highlightText( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'addMarker:' + config.model, highlightElement( config.view ), { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'removeMarker:' + config.model, removeHighlight( config.view ), { priority: config.converterPriority || 'normal' } );
	};
}

// Takes `config.view`, and if it is an {@link module:engine/view/elementdefinition~ElementDefinition}, converts it
// to a function (because lower level converters accept only element creator functions).
//
// @param {module:engine/view/elementdefinition~ElementDefinition|Function} view View configuration.
// @param {'container'|'attribute'|'ui'} viewElementType View element type to create.
// @returns {Function} Element creator function to use in lower level converters.
function normalizeToElementConfig( view, viewElementType ) {
	if ( typeof view == 'function' ) {
		// If `view` is already a function, don't do anything.
		return view;
	}

	return ( modelData, viewWriter ) => createViewElementFromDefinition( view, viewWriter, viewElementType );
}

// Creates a view element instance from the provided {@link module:engine/view/elementdefinition~ElementDefinition} and class.
//
// @param {module:engine/view/elementdefinition~ElementDefinition} viewElementDefinition
// @param {module:engine/view/downcastwriter~DowncastWriter} viewWriter
// @param {'container'|'attribute'|'ui'} viewElementType
// @returns {module:engine/view/element~Element}
function createViewElementFromDefinition( viewElementDefinition, viewWriter, viewElementType ) {
	if ( typeof viewElementDefinition == 'string' ) {
		// If `viewElementDefinition` is given as a `String`, normalize it to an object with `name` property.
		viewElementDefinition = { name: viewElementDefinition };
	}

	let element;
	const attributes = Object.assign( {}, viewElementDefinition.attributes );

	if ( viewElementType == 'container' ) {
		element = viewWriter.createContainerElement( viewElementDefinition.name, attributes );
	} else if ( viewElementType == 'attribute' ) {
		const options = {
			priority: viewElementDefinition.priority || _view_attributeelement__WEBPACK_IMPORTED_MODULE_3__["default"].DEFAULT_PRIORITY
		};

		element = viewWriter.createAttributeElement( viewElementDefinition.name, attributes, options );
	} else {
		// 'ui'.
		element = viewWriter.createUIElement( viewElementDefinition.name, attributes );
	}

	if ( viewElementDefinition.styles ) {
		const keys = Object.keys( viewElementDefinition.styles );

		for ( const key of keys ) {
			viewWriter.setStyle( key, viewElementDefinition.styles[ key ], element );
		}
	}

	if ( viewElementDefinition.classes ) {
		const classes = viewElementDefinition.classes;

		if ( typeof classes == 'string' ) {
			viewWriter.addClass( classes, element );
		} else {
			for ( const className of classes ) {
				viewWriter.addClass( className, element );
			}
		}
	}

	return element;
}

function getFromAttributeCreator( config ) {
	if ( config.model.values ) {
		return ( modelAttributeValue, viewWriter ) => {
			const view = config.view[ modelAttributeValue ];

			if ( view ) {
				return view( modelAttributeValue, viewWriter );
			}

			return null;
		};
	} else {
		return config.view;
	}
}

// Takes the configuration, adds default parameters if they do not exist and normalizes other parameters to be used in downcast converters
// for generating a view attribute.
//
// @param {Object} view View configuration.
function normalizeToAttributeConfig( view ) {
	if ( typeof view == 'string' ) {
		return modelAttributeValue => ( { key: view, value: modelAttributeValue } );
	} else if ( typeof view == 'object' ) {
		// { key, value, ... }
		if ( view.value ) {
			return () => view;
		}
		// { key, ... }
		else {
			return modelAttributeValue => ( { key: view.key, value: modelAttributeValue } );
		}
	} else {
		// function.
		return view;
	}
}

// Helper function for `highlight`. Prepares the actual descriptor object using value passed to the converter.
function prepareDescriptor( highlightDescriptor, data, conversionApi ) {
	// If passed descriptor is a creator function, call it. If not, just use passed value.
	const descriptor = typeof highlightDescriptor == 'function' ?
		highlightDescriptor( data, conversionApi ) :
		highlightDescriptor;

	if ( !descriptor ) {
		return null;
	}

	// Apply default descriptor priority.
	if ( !descriptor.priority ) {
		descriptor.priority = 10;
	}

	// Default descriptor id is marker name.
	if ( !descriptor.id ) {
		descriptor.id = data.markerName;
	}

	return descriptor;
}

/**
 * An object describing how the marker highlight should be represented in the view.
 *
 * Each text node contained in a highlighted range will be wrapped in a `<span>`
 * {@link module:engine/view/attributeelement~AttributeElement view attribute element} with CSS class(es), attributes and a priority
 * described by this object.
 *
 * Additionally, each {@link module:engine/view/containerelement~ContainerElement container element} can handle displaying the highlight
 * separately by providing the `addHighlight` and `removeHighlight` custom properties. In this case:
 *
 *  * The `HighlightDescriptor` object is passed to the `addHighlight` function upon conversion and should be used to apply the highlight to
 *  the element.
 *  * The descriptor `id` is passed to the `removeHighlight` function upon conversion and should be used to remove the highlight with the
 *  given ID from the element.
 *
 * @typedef {Object} module:engine/conversion/downcasthelpers~HighlightDescriptor
 *
 * @property {String|Array.<String>} classes A CSS class or an array of classes to set. If the descriptor is used to
 * create an {@link module:engine/view/attributeelement~AttributeElement attribute element} over text nodes, these classes will be set
 * on that attribute element. If the descriptor is applied to an element, usually these classes will be set on that element, however,
 * this depends on how the element converts the descriptor.
 *
 * @property {String} [id] Descriptor identifier. If not provided, it defaults to the converted marker's name.
 *
 * @property {Number} [priority] Descriptor priority. If not provided, it defaults to `10`. If the descriptor is used to create
 * an {@link module:engine/view/attributeelement~AttributeElement attribute element}, it will be that element's
 * {@link module:engine/view/attributeelement~AttributeElement#priority priority}. If the descriptor is applied to an element,
 * the priority will be used to determine which descriptor is more important.
 *
 * @property {Object} [attributes] Attributes to set. If the descriptor is used to create
 * an {@link module:engine/view/attributeelement~AttributeElement attribute element} over text nodes, these attributes will be set on that
 * attribute element. If the descriptor is applied to an element, usually these attributes will be set on that element, however,
 * this depends on how the element converts the descriptor.
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/mapper.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Mapper; });
/* harmony import */ var _model_position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _view_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../view/position */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/position.js");
/* harmony import */ var _view_range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../view/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/range.js");
/* harmony import */ var _view_text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../view/text */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/text.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/mapper
 */











/**
 * Maps elements, positions and markers between {@link module:engine/view/document~Document the view} and
 * {@link module:engine/model/model the model}.
 *
 * The instance of the Mapper used for the editing pipeline is available in
 * {@link module:engine/controller/editingcontroller~EditingController#mapper `editor.editing.mapper`}.
 *
 * Mapper uses bound elements to find corresponding elements and positions, so, to get proper results,
 * all model elements should be {@link module:engine/conversion/mapper~Mapper#bindElements bound}.
 *
 * To map complex model to/from view relations, you may provide custom callbacks for
 * {@link module:engine/conversion/mapper~Mapper#event:modelToViewPosition modelToViewPosition event} and
 * {@link module:engine/conversion/mapper~Mapper#event:viewToModelPosition viewToModelPosition event} that are fired whenever
 * a position mapping request occurs.
 * Those events are fired by {@link module:engine/conversion/mapper~Mapper#toViewPosition toViewPosition}
 * and {@link module:engine/conversion/mapper~Mapper#toModelPosition toModelPosition} methods. `Mapper` adds it's own default callbacks
 * with `'lowest'` priority. To override default `Mapper` mapping, add custom callback with higher priority and
 * stop the event.
 */
class Mapper {
	/**
	 * Creates an instance of the mapper.
	 */
	constructor() {
		/**
		 * Model element to view element mapping.
		 *
		 * @private
		 * @member {WeakMap}
		 */
		this._modelToViewMapping = new WeakMap();

		/**
		 * View element to model element mapping.
		 *
		 * @private
		 * @member {WeakMap}
		 */
		this._viewToModelMapping = new WeakMap();

		/**
		 * A map containing callbacks between view element names and functions evaluating length of view elements
		 * in model.
		 *
		 * @private
		 * @member {Map}
		 */
		this._viewToModelLengthCallbacks = new Map();

		/**
		 * Model marker name to view elements mapping.
		 *
		 * Keys are `String`s while values are `Set`s with {@link module:engine/view/element~Element view elements}.
		 * One marker (name) can be mapped to multiple elements.
		 *
		 * @private
		 * @member {Map}
		 */
		this._markerNameToElements = new Map();

		/**
		 * View element to model marker names mapping.
		 *
		 * This is reverse to {@link ~Mapper#_markerNameToElements} map.
		 *
		 * @private
		 * @member {Map}
		 */
		this._elementToMarkerNames = new Map();

		/**
		 * Stores marker names of markers which has changed due to unbinding a view element (so it is assumed that the view element
		 * has been removed, moved or renamed).
		 *
		 * @private
		 * @member {Set.<module:engine/model/markercollection~Marker>}
		 */
		this._unboundMarkerNames = new Set();

		// Default mapper algorithm for mapping model position to view position.
		this.on( 'modelToViewPosition', ( evt, data ) => {
			if ( data.viewPosition ) {
				return;
			}

			const viewContainer = this._modelToViewMapping.get( data.modelPosition.parent );

			data.viewPosition = this.findPositionIn( viewContainer, data.modelPosition.offset );
		}, { priority: 'low' } );

		// Default mapper algorithm for mapping view position to model position.
		this.on( 'viewToModelPosition', ( evt, data ) => {
			if ( data.modelPosition ) {
				return;
			}

			const viewBlock = this.findMappedViewAncestor( data.viewPosition );
			const modelParent = this._viewToModelMapping.get( viewBlock );
			const modelOffset = this._toModelOffset( data.viewPosition.parent, data.viewPosition.offset, viewBlock );

			data.modelPosition = _model_position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( modelParent, modelOffset );
		}, { priority: 'low' } );
	}

	/**
	 * Marks model and view elements as corresponding. Corresponding elements can be retrieved by using
	 * the {@link module:engine/conversion/mapper~Mapper#toModelElement toModelElement} and
	 * {@link module:engine/conversion/mapper~Mapper#toViewElement toViewElement} methods.
	 * The information that elements are bound is also used to translate positions.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element.
	 * @param {module:engine/view/element~Element} viewElement View element.
	 */
	bindElements( modelElement, viewElement ) {
		this._modelToViewMapping.set( modelElement, viewElement );
		this._viewToModelMapping.set( viewElement, modelElement );
	}

	/**
	 * Unbinds given {@link module:engine/view/element~Element view element} from the map.
	 *
	 * **Note:** view-to-model binding will be removed, if it existed. However, corresponding model-to-view binding
	 * will be removed only if model element is still bound to passed `viewElement`.
	 *
	 * This behavior lets for re-binding model element to another view element without fear of losing the new binding
	 * when the previously bound view element is unbound.
	 *
	 * @param {module:engine/view/element~Element} viewElement View element to unbind.
	 */
	unbindViewElement( viewElement ) {
		const modelElement = this.toModelElement( viewElement );

		this._viewToModelMapping.delete( viewElement );

		if ( this._elementToMarkerNames.has( viewElement ) ) {
			for ( const markerName of this._elementToMarkerNames.get( viewElement ) ) {
				this._unboundMarkerNames.add( markerName );
			}
		}

		if ( this._modelToViewMapping.get( modelElement ) == viewElement ) {
			this._modelToViewMapping.delete( modelElement );
		}
	}

	/**
	 * Unbinds given {@link module:engine/model/element~Element model element} from the map.
	 *
	 * **Note:** model-to-view binding will be removed, if it existed. However, corresponding view-to-model binding
	 * will be removed only if view element is still bound to passed `modelElement`.
	 *
	 * This behavior lets for re-binding view element to another model element without fear of losing the new binding
	 * when the previously bound model element is unbound.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element to unbind.
	 */
	unbindModelElement( modelElement ) {
		const viewElement = this.toViewElement( modelElement );

		this._modelToViewMapping.delete( modelElement );

		if ( this._viewToModelMapping.get( viewElement ) == modelElement ) {
			this._viewToModelMapping.delete( viewElement );
		}
	}

	/**
	 * Binds given marker name with given {@link module:engine/view/element~Element view element}. The element
	 * will be added to the current set of elements bound with given marker name.
	 *
	 * @param {module:engine/view/element~Element} element Element to bind.
	 * @param {String} name Marker name.
	 */
	bindElementToMarker( element, name ) {
		const elements = this._markerNameToElements.get( name ) || new Set();
		elements.add( element );

		const names = this._elementToMarkerNames.get( element ) || new Set();
		names.add( name );

		this._markerNameToElements.set( name, elements );
		this._elementToMarkerNames.set( element, names );
	}

	/**
	 * Unbinds an element from given marker name.
	 *
	 * @param {module:engine/view/element~Element} element Element to unbind.
	 * @param {String} name Marker name.
	 */
	unbindElementFromMarkerName( element, name ) {
		const nameToElements = this._markerNameToElements.get( name );

		if ( nameToElements ) {
			nameToElements.delete( element );

			if ( nameToElements.size == 0 ) {
				this._markerNameToElements.delete( name );
			}
		}

		const elementToNames = this._elementToMarkerNames.get( element );

		if ( elementToNames ) {
			elementToNames.delete( name );

			if ( elementToNames.size == 0 ) {
				this._elementToMarkerNames.delete( element );
			}
		}
	}

	/**
	 * Returns all marker names of markers which has changed due to unbinding a view element (so it is assumed that the view element
	 * has been removed, moved or renamed) since the last flush. After returning, the marker names list is cleared.
	 *
	 * @returns {Array.<String>}
	 */
	flushUnboundMarkerNames() {
		const markerNames = Array.from( this._unboundMarkerNames );

		this._unboundMarkerNames.clear();

		return markerNames;
	}

	/**
	 * Removes all model to view and view to model bindings.
	 */
	clearBindings() {
		this._modelToViewMapping = new WeakMap();
		this._viewToModelMapping = new WeakMap();
		this._markerNameToElements = new Map();
		this._elementToMarkerNames = new Map();
		this._unboundMarkerNames = new Set();
	}

	/**
	 * Gets the corresponding model element.
	 *
	 * **Note:** {@link module:engine/view/uielement~UIElement} does not have corresponding element in model.
	 *
	 * @param {module:engine/view/element~Element} viewElement View element.
	 * @returns {module:engine/model/element~Element|undefined} Corresponding model element or `undefined` if not found.
	 */
	toModelElement( viewElement ) {
		return this._viewToModelMapping.get( viewElement );
	}

	/**
	 * Gets the corresponding view element.
	 *
	 * @param {module:engine/model/element~Element} modelElement Model element.
	 * @returns {module:engine/view/element~Element|undefined} Corresponding view element or `undefined` if not found.
	 */
	toViewElement( modelElement ) {
		return this._modelToViewMapping.get( modelElement );
	}

	/**
	 * Gets the corresponding model range.
	 *
	 * @param {module:engine/view/range~Range} viewRange View range.
	 * @returns {module:engine/model/range~Range} Corresponding model range.
	 */
	toModelRange( viewRange ) {
		return new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( this.toModelPosition( viewRange.start ), this.toModelPosition( viewRange.end ) );
	}

	/**
	 * Gets the corresponding view range.
	 *
	 * @param {module:engine/model/range~Range} modelRange Model range.
	 * @returns {module:engine/view/range~Range} Corresponding view range.
	 */
	toViewRange( modelRange ) {
		return new _view_range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.toViewPosition( modelRange.start ), this.toViewPosition( modelRange.end ) );
	}

	/**
	 * Gets the corresponding model position.
	 *
	 * @fires viewToModelPosition
	 * @param {module:engine/view/position~Position} viewPosition View position.
	 * @returns {module:engine/model/position~Position} Corresponding model position.
	 */
	toModelPosition( viewPosition ) {
		const data = {
			viewPosition,
			mapper: this
		};

		this.fire( 'viewToModelPosition', data );

		return data.modelPosition;
	}

	/**
	 * Gets the corresponding view position.
	 *
	 * @fires modelToViewPosition
	 * @param {module:engine/model/position~Position} modelPosition Model position.
	 * @param {Object} [options] Additional options for position mapping process.
	 * @param {Boolean} [options.isPhantom=false] Should be set to `true` if the model position to map is pointing to a place
	 * in model tree which no longer exists. For example, it could be an end of a removed model range.
	 * @returns {module:engine/view/position~Position} Corresponding view position.
	 */
	toViewPosition( modelPosition, options = { isPhantom: false } ) {
		const data = {
			modelPosition,
			mapper: this,
			isPhantom: options.isPhantom
		};

		this.fire( 'modelToViewPosition', data );

		return data.viewPosition;
	}

	/**
	 * Gets all view elements bound to the given marker name.
	 *
	 * @param {String} name Marker name.
	 * @returns {Set.<module:engine/view/element~Element>|null} View elements bound with given marker name or `null`
	 * if no elements are bound to given marker name.
	 */
	markerNameToElements( name ) {
		const boundElements = this._markerNameToElements.get( name );

		if ( !boundElements ) {
			return null;
		}

		const elements = new Set();

		for ( const element of boundElements ) {
			if ( element.is( 'attributeElement' ) ) {
				for ( const clone of element.getElementsWithSameId() ) {
					elements.add( clone );
				}
			} else {
				elements.add( element );
			}
		}

		return elements;
	}

	/**
	 * Registers a callback that evaluates the length in the model of a view element with given name.
	 *
	 * The callback is fired with one argument, which is a view element instance. The callback is expected to return
	 * a number representing the length of view element in model.
	 *
	 *		// List item in view may contain nested list, which have other list items. In model though,
	 *		// the lists are represented by flat structure. Because of those differences, length of list view element
	 *		// may be greater than one. In the callback it's checked how many nested list items are in evaluated list item.
	 *
	 *		function getViewListItemLength( element ) {
	 *			let length = 1;
	 *
	 *			for ( let child of element.getChildren() ) {
	 *				if ( child.name == 'ul' || child.name == 'ol' ) {
	 *					for ( let item of child.getChildren() ) {
	 *						length += getViewListItemLength( item );
	 *					}
	 *				}
	 *			}
	 *
	 *			return length;
	 *		}
	 *
	 *		mapper.registerViewToModelLength( 'li', getViewListItemLength );
	 *
	 * @param {String} viewElementName Name of view element for which callback is registered.
	 * @param {Function} lengthCallback Function return a length of view element instance in model.
	 */
	registerViewToModelLength( viewElementName, lengthCallback ) {
		this._viewToModelLengthCallbacks.set( viewElementName, lengthCallback );
	}

	/**
	 * For given `viewPosition`, finds and returns the closest ancestor of this position that has a mapping to
	 * the model.
	 *
	 * @param {module:engine/view/position~Position} viewPosition Position for which mapped ancestor should be found.
	 * @returns {module:engine/view/element~Element}
	 */
	findMappedViewAncestor( viewPosition ) {
		let parent = viewPosition.parent;

		while ( !this._viewToModelMapping.has( parent ) ) {
			parent = parent.parent;
		}

		return parent;
	}

	/**
	 * Calculates model offset based on the view position and the block element.
	 *
	 * Example:
	 *
	 *		<p>foo<b>ba|r</b></p> // _toModelOffset( b, 2, p ) -> 5
	 *
	 * Is a sum of:
	 *
	 *		<p>foo|<b>bar</b></p> // _toModelOffset( p, 3, p ) -> 3
	 *		<p>foo<b>ba|r</b></p> // _toModelOffset( b, 2, b ) -> 2
	 *
	 * @private
	 * @param {module:engine/view/element~Element} viewParent Position parent.
	 * @param {Number} viewOffset Position offset.
	 * @param {module:engine/view/element~Element} viewBlock Block used as a base to calculate offset.
	 * @returns {Number} Offset in the model.
	 */
	_toModelOffset( viewParent, viewOffset, viewBlock ) {
		if ( viewBlock != viewParent ) {
			// See example.
			const offsetToParentStart = this._toModelOffset( viewParent.parent, viewParent.index, viewBlock );
			const offsetInParent = this._toModelOffset( viewParent, viewOffset, viewParent );

			return offsetToParentStart + offsetInParent;
		}

		// viewBlock == viewParent, so we need to calculate the offset in the parent element.

		// If the position is a text it is simple ("ba|r" -> 2).
		if ( viewParent.is( '$text' ) ) {
			return viewOffset;
		}

		// If the position is in an element we need to sum lengths of siblings ( <b> bar </b> foo | -> 3 + 3 = 6 ).
		let modelOffset = 0;

		for ( let i = 0; i < viewOffset; i++ ) {
			modelOffset += this.getModelLength( viewParent.getChild( i ) );
		}

		return modelOffset;
	}

	/**
	 * Gets the length of the view element in the model.
	 *
	 * The length is calculated as follows:
	 * * if {@link #registerViewToModelLength length mapping callback} is provided for given `viewNode` it is used to
	 * evaluate model length (`viewNode` is used as first and only parameter passed to the callback),
	 * * length of a {@link module:engine/view/text~Text text node} is equal to the length of it's
	 * {@link module:engine/view/text~Text#data data},
	 * * length of a {@link module:engine/view/uielement~UIElement ui element} is equal to 0,
	 * * length of a mapped {@link module:engine/view/element~Element element} is equal to 1,
	 * * length of a not-mapped {@link module:engine/view/element~Element element} is equal to the length of it's children.
	 *
	 * Examples:
	 *
	 *		foo                          -> 3 // Text length is equal to it's data length.
	 *		<p>foo</p>                   -> 1 // Length of an element which is mapped is by default equal to 1.
	 *		<b>foo</b>                   -> 3 // Length of an element which is not mapped is a length of its children.
	 *		<div><p>x</p><p>y</p></div>  -> 2 // Assuming that <div> is not mapped and <p> are mapped.
	 *
	 * @param {module:engine/view/element~Element} viewNode View node.
	 * @returns {Number} Length of the node in the tree model.
	 */
	getModelLength( viewNode ) {
		if ( this._viewToModelLengthCallbacks.get( viewNode.name ) ) {
			const callback = this._viewToModelLengthCallbacks.get( viewNode.name );

			return callback( viewNode );
		} else if ( this._viewToModelMapping.has( viewNode ) ) {
			return 1;
		} else if ( viewNode.is( '$text' ) ) {
			return viewNode.data.length;
		} else if ( viewNode.is( 'uiElement' ) ) {
			return 0;
		} else {
			let len = 0;

			for ( const child of viewNode.getChildren() ) {
				len += this.getModelLength( child );
			}

			return len;
		}
	}

	/**
	 * Finds the position in the view node (or its children) with the expected model offset.
	 *
	 * Example:
	 *
	 *		<p>fo<b>bar</b>bom</p> -> expected offset: 4
	 *
	 *		findPositionIn( p, 4 ):
	 *		<p>|fo<b>bar</b>bom</p> -> expected offset: 4, actual offset: 0
	 *		<p>fo|<b>bar</b>bom</p> -> expected offset: 4, actual offset: 2
	 *		<p>fo<b>bar</b>|bom</p> -> expected offset: 4, actual offset: 5 -> we are too far
	 *
	 *		findPositionIn( b, 4 - ( 5 - 3 ) ):
	 *		<p>fo<b>|bar</b>bom</p> -> expected offset: 2, actual offset: 0
	 *		<p>fo<b>bar|</b>bom</p> -> expected offset: 2, actual offset: 3 -> we are too far
	 *
	 *		findPositionIn( bar, 2 - ( 3 - 3 ) ):
	 *		We are in the text node so we can simple find the offset.
	 *		<p>fo<b>ba|r</b>bom</p> -> expected offset: 2, actual offset: 2 -> position found
	 *
	 * @param {module:engine/view/element~Element} viewParent Tree view element in which we are looking for the position.
	 * @param {Number} expectedOffset Expected offset.
	 * @returns {module:engine/view/position~Position} Found position.
	 */
	findPositionIn( viewParent, expectedOffset ) {
		// Last scanned view node.
		let viewNode;
		// Length of the last scanned view node.
		let lastLength = 0;

		let modelOffset = 0;
		let viewOffset = 0;

		// In the text node it is simple: offset in the model equals offset in the text.
		if ( viewParent.is( '$text' ) ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( viewParent, expectedOffset );
		}

		// In other cases we add lengths of child nodes to find the proper offset.

		// If it is smaller we add the length.
		while ( modelOffset < expectedOffset ) {
			viewNode = viewParent.getChild( viewOffset );
			lastLength = this.getModelLength( viewNode );
			modelOffset += lastLength;
			viewOffset++;
		}

		// If it equals we found the position.
		if ( modelOffset == expectedOffset ) {
			return this._moveViewPositionToTextNode( new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( viewParent, viewOffset ) );
		}
		// If it is higher we need to enter last child.
		else {
			// ( modelOffset - lastLength ) is the offset to the child we enter,
			// so we subtract it from the expected offset to fine the offset in the child.
			return this.findPositionIn( viewNode, expectedOffset - ( modelOffset - lastLength ) );
		}
	}

	/**
	 * Because we prefer positions in text nodes over positions next to text node moves view position to the text node
	 * if it was next to it.
	 *
	 *		<p>[]<b>foo</b></p> -> <p>[]<b>foo</b></p> // do not touch if position is not directly next to text
	 *		<p>foo[]<b>foo</b></p> -> <p>foo{}<b>foo</b></p> // move to text node
	 *		<p><b>[]foo</b></p> -> <p><b>{}foo</b></p> // move to text node
	 *
	 * @private
	 * @param {module:engine/view/position~Position} viewPosition Position potentially next to text node.
	 * @returns {module:engine/view/position~Position} Position in text node if possible.
	 */
	_moveViewPositionToTextNode( viewPosition ) {
		// If the position is just after text node, put it at the end of that text node.
		// If the position is just before text node, put it at the beginning of that text node.
		const nodeBefore = viewPosition.nodeBefore;
		const nodeAfter = viewPosition.nodeAfter;

		if ( nodeBefore instanceof _view_text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( nodeBefore, nodeBefore.data.length );
		} else if ( nodeAfter instanceof _view_text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
			return new _view_position__WEBPACK_IMPORTED_MODULE_2__["default"]( nodeAfter, 0 );
		}

		// Otherwise, just return the given position.
		return viewPosition;
	}

	/**
	 * Fired for each model-to-view position mapping request. The purpose of this event is to enable custom model-to-view position
	 * mapping. Callbacks added to this event take {@link module:engine/model/position~Position model position} and are expected to
	 * calculate {@link module:engine/view/position~Position view position}. Calculated view position should be added as `viewPosition`
	 * value in `data` object that is passed as one of parameters to the event callback.
	 *
	 * 		// Assume that "captionedImage" model element is converted to <img> and following <span> elements in view,
	 * 		// and the model element is bound to <img> element. Force mapping model positions inside "captionedImage" to that
	 * 		// <span> element.
	 *		mapper.on( 'modelToViewPosition', ( evt, data ) => {
	 *			const positionParent = modelPosition.parent;
	 *
	 *			if ( positionParent.name == 'captionedImage' ) {
	 *				const viewImg = data.mapper.toViewElement( positionParent );
	 *				const viewCaption = viewImg.nextSibling; // The <span> element.
	 *
	 *				data.viewPosition = new ViewPosition( viewCaption, modelPosition.offset );
	 *
	 *				// Stop the event if other callbacks should not modify calculated value.
	 *				evt.stop();
	 *			}
	 *		} );
	 *
	 * **Note:** keep in mind that sometimes a "phantom" model position is being converted. "Phantom" model position is
	 * a position that points to a non-existing place in model. Such position might still be valid for conversion, though
	 * (it would point to a correct place in view when converted). One example of such situation is when a range is
	 * removed from model, there may be a need to map the range's end (which is no longer valid model position). To
	 * handle such situation, check `data.isPhantom` flag:
	 *
	 * 		// Assume that there is "customElement" model element and whenever position is before it, we want to move it
	 * 		// to the inside of the view element bound to "customElement".
	 *		mapper.on( 'modelToViewPosition', ( evt, data ) => {
	 *			if ( data.isPhantom ) {
	 *				return;
	 *			}
	 *
	 *			// Below line might crash for phantom position that does not exist in model.
	 *			const sibling = data.modelPosition.nodeBefore;
	 *
	 *			// Check if this is the element we are interested in.
	 *			if ( !sibling.is( 'element', 'customElement' ) ) {
	 *				return;
	 *			}
	 *
	 *			const viewElement = data.mapper.toViewElement( sibling );
	 *
	 *			data.viewPosition = new ViewPosition( sibling, 0 );
	 *
	 *			evt.stop();
	 *		} );
	 *
	 * **Note:** default mapping callback is provided with `low` priority setting and does not cancel the event, so it is possible to
	 * attach a custom callback after default callback and also use `data.viewPosition` calculated by default callback
	 * (for example to fix it).
	 *
	 * **Note:** default mapping callback will not fire if `data.viewPosition` is already set.
	 *
	 * **Note:** these callbacks are called **very often**. For efficiency reasons, it is advised to use them only when position
	 * mapping between given model and view elements is unsolvable using just elements mapping and default algorithm. Also,
	 * the condition that checks if special case scenario happened should be as simple as possible.
	 *
	 * @event modelToViewPosition
	 * @param {Object} data Data pipeline object that can store and pass data between callbacks. The callback should add
	 * `viewPosition` value to that object with calculated {@link module:engine/view/position~Position view position}.
	 * @param {module:engine/conversion/mapper~Mapper} data.mapper Mapper instance that fired the event.
	 */

	/**
	 * Fired for each view-to-model position mapping request. See {@link module:engine/conversion/mapper~Mapper#event:modelToViewPosition}.
	 *
	 * 		// See example in `modelToViewPosition` event description.
	 * 		// This custom mapping will map positions from <span> element next to <img> to the "captionedImage" element.
	 *		mapper.on( 'viewToModelPosition', ( evt, data ) => {
	 *			const positionParent = viewPosition.parent;
	 *
	 *			if ( positionParent.hasClass( 'image-caption' ) ) {
	 *				const viewImg = positionParent.previousSibling;
	 *				const modelImg = data.mapper.toModelElement( viewImg );
	 *
	 *				data.modelPosition = new ModelPosition( modelImg, viewPosition.offset );
	 *				evt.stop();
	 *			}
	 *		} );
	 *
	 * **Note:** default mapping callback is provided with `low` priority setting and does not cancel the event, so it is possible to
	 * attach a custom callback after default callback and also use `data.modelPosition` calculated by default callback
	 * (for example to fix it).
	 *
	 * **Note:** default mapping callback will not fire if `data.modelPosition` is already set.
	 *
	 * **Note:** these callbacks are called **very often**. For efficiency reasons, it is advised to use them only when position
	 * mapping between given model and view elements is unsolvable using just elements mapping and default algorithm. Also,
	 * the condition that checks if special case scenario happened should be as simple as possible.
	 *
	 * @event viewToModelPosition
	 * @param {Object} data Data pipeline object that can store and pass data between callbacks. The callback should add
	 * `modelPosition` value to that object with calculated {@link module:engine/model/position~Position model position}.
	 * @param {module:engine/conversion/mapper~Mapper} data.mapper Mapper instance that fired the event.
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( Mapper, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/modelconsumable.js ***!
  \***********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ModelConsumable; });
/* harmony import */ var _model_textproxy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../model/textproxy */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/modelconsumable
 */



/**
 * Manages a list of consumable values for {@link module:engine/model/item~Item model items}.
 *
 * Consumables are various aspects of the model. A model item can be broken down into singular properties that might be
 * taken into consideration when converting that item.
 *
 * `ModelConsumable` is used by {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher} while analyzing changed
 * parts of {@link module:engine/model/document~Document the document}. The added / changed / removed model items are broken down
 * into singular properties (the item itself and it's attributes). All those parts are saved in `ModelConsumable`. Then,
 * during conversion, when given part of model item is converted (i.e. the view element has been inserted into the view,
 * but without attributes), consumable value is removed from `ModelConsumable`.
 *
 * For model items, `ModelConsumable` stores consumable values of one of following types: `insert`, `addattribute:<attributeKey>`,
 * `changeattributes:<attributeKey>`, `removeattributes:<attributeKey>`.
 *
 * In most cases, it is enough to let {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher}
 * gather consumable values, so there is no need to use
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#add add method} directly.
 * However, it is important to understand how consumable values can be
 * {@link module:engine/conversion/modelconsumable~ModelConsumable#consume consumed}.
 * See {@link module:engine/conversion/downcasthelpers default downcast converters} for more information.
 *
 * Keep in mind, that one conversion event may have multiple callbacks (converters) attached to it. Each of those is
 * able to convert one or more parts of the model. However, when one of those callbacks actually converts
 * something, other should not, because they would duplicate the results. Using `ModelConsumable` helps avoiding
 * this situation, because callbacks should only convert those values, which were not yet consumed from `ModelConsumable`.
 *
 * Consuming multiple values in a single callback:
 *
 *		// Converter for custom `image` element that might have a `caption` element inside which changes
 *		// how the image is displayed in the view:
 *		//
 *		// Model:
 *		//
 *		// [image]
 *		//   └─ [caption]
 *		//       └─ foo
 *		//
 *		// View:
 *		//
 *		// <figure>
 *		//   ├─ <img />
 *		//   └─ <caption>
 *		//       └─ foo
 *		modelConversionDispatcher.on( 'insert:image', ( evt, data, conversionApi ) => {
 *			// First, consume the `image` element.
 *			conversionApi.consumable.consume( data.item, 'insert' );
 *
 *			// Just create normal image element for the view.
 *			// Maybe it will be "decorated" later.
 *			const viewImage = new ViewElement( 'img' );
 *			const insertPosition = conversionApi.mapper.toViewPosition( data.range.start );
 *			const viewWriter = conversionApi.writer;
 *
 *			// Check if the `image` element has children.
 *			if ( data.item.childCount > 0 ) {
 *				const modelCaption = data.item.getChild( 0 );
 *
 *				// `modelCaption` insertion change is consumed from consumable values.
 *				// It will not be converted by other converters, but it's children (probably some text) will be.
 *				// Through mapping, converters for text will know where to insert contents of `modelCaption`.
 *				if ( conversionApi.consumable.consume( modelCaption, 'insert' ) ) {
 *					const viewCaption = new ViewElement( 'figcaption' );
 *
 *					const viewImageHolder = new ViewElement( 'figure', null, [ viewImage, viewCaption ] );
 *
 *					conversionApi.mapper.bindElements( modelCaption, viewCaption );
 *					conversionApi.mapper.bindElements( data.item, viewImageHolder );
 *					viewWriter.insert( insertPosition, viewImageHolder );
 *				}
 *			} else {
 *				conversionApi.mapper.bindElements( data.item, viewImage );
 *				viewWriter.insert( insertPosition, viewImage );
 *			}
 *
 *			evt.stop();
 *		} );
 */
class ModelConsumable {
	/**
	 * Creates an empty consumables list.
	 */
	constructor() {
		/**
		 * Contains list of consumable values.
		 *
		 * @private
		 * @member {Map} module:engine/conversion/modelconsumable~ModelConsumable#_consumable
		 */
		this._consumable = new Map();

		/**
		 * For each {@link module:engine/model/textproxy~TextProxy} added to `ModelConsumable`, this registry holds parent
		 * of that `TextProxy` and start and end indices of that `TextProxy`. This allows identification of `TextProxy`
		 * instances that points to the same part of the model but are different instances. Each distinct `TextProxy`
		 * is given unique `Symbol` which is then registered as consumable. This process is transparent for `ModelConsumable`
		 * API user because whenever `TextProxy` is added, tested, consumed or reverted, internal mechanisms of
		 * `ModelConsumable` translates `TextProxy` to that unique `Symbol`.
		 *
		 * @private
		 * @member {Map} module:engine/conversion/modelconsumable~ModelConsumable#_textProxyRegistry
		 */
		this._textProxyRegistry = new Map();
	}

	/**
	 * Adds a consumable value to the consumables list and links it with given model item.
	 *
	 *		modelConsumable.add( modelElement, 'insert' ); // Add `modelElement` insertion change to consumable values.
	 *		modelConsumable.add( modelElement, 'addAttribute:bold' ); // Add `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.add( modelElement, 'removeAttribute:bold' ); // Add `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.add( modelSelection, 'selection' ); // Add `modelSelection` to consumable values.
	 *		modelConsumable.add( modelRange, 'range' ); // Add `modelRange` to consumable values.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection that has the consumable.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 */
	add( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		if ( !this._consumable.has( item ) ) {
			this._consumable.set( item, new Map() );
		}

		this._consumable.get( item ).set( type, true );
	}

	/**
	 * Removes given consumable value from given model item.
	 *
	 *		modelConsumable.consume( modelElement, 'insert' ); // Remove `modelElement` insertion change from consumable values.
	 *		modelConsumable.consume( modelElement, 'addAttribute:bold' ); // Remove `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.consume( modelElement, 'removeAttribute:bold' ); // Remove `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.consume( modelSelection, 'selection' ); // Remove `modelSelection` from consumable values.
	 *		modelConsumable.consume( modelRange, 'range' ); // Remove 'modelRange' from consumable values.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection from which consumable will be consumed.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 * @returns {Boolean} `true` if consumable value was available and was consumed, `false` otherwise.
	 */
	consume( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		if ( this.test( item, type ) ) {
			this._consumable.get( item ).set( type, false );

			return true;
		} else {
			return false;
		}
	}

	/**
	 * Tests whether there is a consumable value of given type connected with given model item.
	 *
	 *		modelConsumable.test( modelElement, 'insert' ); // Check for `modelElement` insertion change.
	 *		modelConsumable.test( modelElement, 'addAttribute:bold' ); // Check for `bold` attribute insertion on `modelElement` change.
	 *		modelConsumable.test( modelElement, 'removeAttribute:bold' ); // Check for `bold` attribute removal on `modelElement` change.
	 *		modelConsumable.test( modelSelection, 'selection' ); // Check if `modelSelection` is consumable.
	 *		modelConsumable.test( modelRange, 'range' ); // Check if `modelRange` is consumable.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection to be tested.
	 * @param {String} type Consumable type. Will be normalized to a proper form, that is either `<word>` or `<part>:<part>`.
	 * Second colon and everything after will be cut. Passing event name is a safe and good practice.
	 * @returns {null|Boolean} `null` if such consumable was never added, `false` if the consumable values was
	 * already consumed or `true` if it was added and not consumed yet.
	 */
	test( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		const itemConsumables = this._consumable.get( item );

		if ( itemConsumables === undefined ) {
			return null;
		}

		const value = itemConsumables.get( type );

		if ( value === undefined ) {
			return null;
		}

		return value;
	}

	/**
	 * Reverts consuming of consumable value.
	 *
	 *		modelConsumable.revert( modelElement, 'insert' ); // Revert consuming `modelElement` insertion change.
	 *		modelConsumable.revert( modelElement, 'addAttribute:bold' ); // Revert consuming `bold` attribute insert from `modelElement`.
	 *		modelConsumable.revert( modelElement, 'removeAttribute:bold' ); // Revert consuming `bold` attribute remove from `modelElement`.
	 *		modelConsumable.revert( modelSelection, 'selection' ); // Revert consuming `modelSelection`.
	 *		modelConsumable.revert( modelRange, 'range' ); // Revert consuming `modelRange`.
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/selection~Selection|module:engine/model/range~Range} item
	 * Model item, range or selection to be reverted.
	 * @param {String} type Consumable type.
	 * @returns {null|Boolean} `true` if consumable has been reversed, `false` otherwise. `null` if the consumable has
	 * never been added.
	 */
	revert( item, type ) {
		type = _normalizeConsumableType( type );

		if ( item instanceof _model_textproxy__WEBPACK_IMPORTED_MODULE_0__["default"] ) {
			item = this._getSymbolForTextProxy( item );
		}

		const test = this.test( item, type );

		if ( test === false ) {
			this._consumable.get( item ).set( type, true );

			return true;
		} else if ( test === true ) {
			return false;
		}

		return null;
	}

	/**
	 * Gets a unique symbol for passed {@link module:engine/model/textproxy~TextProxy} instance. All `TextProxy` instances that
	 * have same parent, same start index and same end index will get the same symbol.
	 *
	 * Used internally to correctly consume `TextProxy` instances.
	 *
	 * @private
	 * @param {module:engine/model/textproxy~TextProxy} textProxy `TextProxy` instance to get a symbol for.
	 * @returns {Symbol} Symbol representing all equal instances of `TextProxy`.
	 */
	_getSymbolForTextProxy( textProxy ) {
		let symbol = null;

		const startMap = this._textProxyRegistry.get( textProxy.startOffset );

		if ( startMap ) {
			const endMap = startMap.get( textProxy.endOffset );

			if ( endMap ) {
				symbol = endMap.get( textProxy.parent );
			}
		}

		if ( !symbol ) {
			symbol = this._addSymbolForTextProxy( textProxy.startOffset, textProxy.endOffset, textProxy.parent );
		}

		return symbol;
	}

	/**
	 * Adds a symbol for given properties that characterizes a {@link module:engine/model/textproxy~TextProxy} instance.
	 *
	 * Used internally to correctly consume `TextProxy` instances.
	 *
	 * @private
	 * @param {Number} startIndex Text proxy start index in it's parent.
	 * @param {Number} endIndex Text proxy end index in it's parent.
	 * @param {module:engine/model/element~Element} parent Text proxy parent.
	 * @returns {Symbol} Symbol generated for given properties.
	 */
	_addSymbolForTextProxy( start, end, parent ) {
		const symbol = Symbol( 'textProxySymbol' );
		let startMap, endMap;

		startMap = this._textProxyRegistry.get( start );

		if ( !startMap ) {
			startMap = new Map();
			this._textProxyRegistry.set( start, startMap );
		}

		endMap = startMap.get( end );

		if ( !endMap ) {
			endMap = new Map();
			startMap.set( end, endMap );
		}

		endMap.set( parent, symbol );

		return symbol;
	}
}

// Returns a normalized consumable type name from given string. A normalized consumable type name is a string that has
// at most one colon, for example: `insert` or `addMarker:highlight`. If string to normalize has more "parts" (more colons),
// the other parts are dropped, for example: `addattribute:bold:$text` -> `addattributes:bold`.
//
// @param {String} type Consumable type.
// @returns {String} Normalized consumable type.
function _normalizeConsumableType( type ) {
	const parts = type.split( ':' );

	return parts.length > 1 ? parts[ 0 ] + ':' + parts[ 1 ] : parts[ 0 ];
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcastdispatcher.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UpcastDispatcher; });
/* harmony import */ var _viewconsumable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./viewconsumable */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _model_position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../model/position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _model_schema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../model/schema */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/upcastdispatcher
 */










/**
 * `UpcastDispatcher` is a central point of {@link module:engine/view/view view} conversion, which is a process of
 * converting given {@link module:engine/view/documentfragment~DocumentFragment view document fragment} or
 * {@link module:engine/view/element~Element} into another structure.
 * In default application, {@link module:engine/view/view view} is converted to {@link module:engine/model/model}.
 *
 * During conversion process, for all {@link module:engine/view/node~Node view nodes} from the converted view document fragment,
 * `UpcastDispatcher` fires corresponding events. Special callbacks called "converters" should listen to
 * `UpcastDispatcher` for those events.
 *
 * Each callback, as the second argument, is passed a special object `data` that has `viewItem`, `modelCursor` and
 * `modelRange` properties. `viewItem` property contains {@link module:engine/view/node~Node view node} or
 * {@link module:engine/view/documentfragment~DocumentFragment view document fragment}
 * that is converted at the moment and might be handled by the callback. `modelRange` property should be used to save the result
 * of conversion and is always a {@link module:engine/model/range~Range} when conversion result is correct.
 * `modelCursor` property is a {@link module:engine/model/position~Position position} on which conversion result will be inserted
 * and is a context according to {@link module:engine/model/schema~Schema schema} will be checked before the conversion.
 * See also {@link ~UpcastDispatcher#convert}. It is also shared by reference by all callbacks listening to given event.
 *
 * The third parameter passed to a callback is an instance of {@link ~UpcastDispatcher}
 * which provides additional tools for converters.
 *
 * Examples of providing callbacks for `UpcastDispatcher`:
 *
 *		// Converter for links (<a>).
 *		editor.data.upcastDispatcher.on( 'element:a', ( evt, data, conversionApi ) => {
 *			if ( conversionApi.consumable.consume( data.viewItem, { name: true, attributes: [ 'href' ] } ) ) {
 *				// <a> element is inline and is represented by an attribute in the model.
 *				// This is why we need to convert only children.
 *				const { modelRange } = conversionApi.convertChildren( data.viewItem, data.modelCursor );
 *
 *				for ( let item of modelRange.getItems() ) {
 *					if ( conversionApi.schema.checkAttribute( item, 'linkHref' ) ) {
 *						conversionApi.writer.setAttribute( 'linkHref', data.viewItem.getAttribute( 'href' ), item );
 *					}
 *				}
 *			}
 *		} );
 *
 *		// Convert <p>'s font-size style.
 *		// Note: You should use a low-priority observer in order to ensure that
 *		// it's executed after the element-to-element converter.
 *		editor.data.upcastDispatcher.on( 'element:p', ( evt, data, conversionApi ) => {
 *			const { consumable, schema, writer } = conversionApi;
 *
 *			if ( !consumable.consume( data.viewItem, { style: 'font-size' } ) ) {
 *				return;
 *			}
 *
 *			const fontSize = data.viewItem.getStyle( 'font-size' );
 *
 *			// Don't go for the model element after data.modelCursor because it might happen
 *			// that a single view element was converted to multiple model elements. Get all of them.
 *			for ( const item of data.modelRange.getItems( { shallow: true } ) ) {
 *				if ( schema.checkAttribute( item, 'fontSize' ) ) {
 *					writer.setAttribute( 'fontSize', fontSize, item );
 *				}
 *			}
 *		}, { priority: 'low' } );
 *
 *		// Convert all elements which have no custom converter into paragraph (autoparagraphing).
 *  	editor.data.upcastDispatcher.on( 'element', ( evt, data, conversionApi ) => {
 *  	 	// When element is already consumed by higher priority converters then do nothing.
 *  	 	if ( conversionApi.consumable.test( data.viewItem, { name: data.viewItem.name } ) ) {
 *  	 			const paragraph = conversionApi.writer.createElement( 'paragraph' );
 *
 *  	 			// Find allowed parent for paragraph that we are going to insert. If current parent does not allow
 *  	 			// to insert paragraph but one of the ancestors does then split nodes to allowed parent.
 *  	 			const splitResult = conversionApi.splitToAllowedParent( paragraph, data.modelCursor );
 *
 *  	 			// When there is no split result it means that we can't insert paragraph in this position.
 *  	 			if ( splitResult ) {
 *  	 				// Insert paragraph in allowed position.
 *  	 				conversionApi.writer.insert( paragraph, splitResult.position );
 *
 *  	 				// Convert children to paragraph.
 *  	 				const { modelRange } = conversionApi.convertChildren(
 *  	 					data.viewItem,
 *  	 					conversionApi.writer.createPositionAt( paragraph, 0 )
 *  	 				);
 *
 * 						// Set as conversion result, attribute converters may use this property.
 *  	 				data.modelRange = conversionApi.writer.createRange(
 *  	 					conversionApi.writer.createPositionBefore( paragraph ),
 *  	 					modelRange.end
 *  	 				);
 *
 *  	 				// Continue conversion inside paragraph.
 *  	 				data.modelCursor = data.modelRange.end;
 *  	 			}
 *  	 		}
 *  	 	}
 *  	 }, { priority: 'low' } );
 *
 * Before each conversion process, `UpcastDispatcher` fires {@link ~UpcastDispatcher#event:viewCleanup}
 * event which can be used to prepare tree view for conversion.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 * @fires viewCleanup
 * @fires element
 * @fires text
 * @fires documentFragment
 */
class UpcastDispatcher {
	/**
	 * Creates a `UpcastDispatcher` that operates using passed API.
	 *
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi
	 * @param {Object} [conversionApi] Additional properties for interface that will be passed to events fired
	 * by `UpcastDispatcher`.
	 */
	constructor( conversionApi = {} ) {
		/**
		 * List of the elements that were created during splitting.
		 *
		 * After conversion process the list is cleared.
		 *
		 * @private
		 * @type {Map.<module:engine/model/element~Element,Array.<module:engine/model/element~Element>>}
		 */
		this._splitParts = new Map();

		/**
		 * Position in the temporary structure where the converted content is inserted. The structure reflect the context of
		 * the target position where the content will be inserted. This property is build based on the context parameter of the
		 * convert method.
		 *
		 * @private
		 * @type {module:engine/model/position~Position|null}
		 */
		this._modelCursor = null;

		/**
		 * Interface passed by dispatcher to the events callbacks.
		 *
		 * @member {module:engine/conversion/upcastdispatcher~UpcastConversionApi}
		 */
		this.conversionApi = Object.assign( {}, conversionApi );

		// `convertItem`, `convertChildren` and `splitToAllowedParent` are bound to this `UpcastDispatcher`
		// instance and set on `conversionApi`. This way only a part of `UpcastDispatcher` API is exposed.
		this.conversionApi.convertItem = this._convertItem.bind( this );
		this.conversionApi.convertChildren = this._convertChildren.bind( this );
		this.conversionApi.splitToAllowedParent = this._splitToAllowedParent.bind( this );
		this.conversionApi.getSplitParts = this._getSplitParts.bind( this );
	}

	/**
	 * Starts the conversion process. The entry point for the conversion.
	 *
	 * @fires element
	 * @fires text
	 * @fires documentFragment
	 * @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/element~Element} viewItem
	 * Part of the view to be converted.
	 * @param {module:engine/model/writer~Writer} writer Instance of model writer.
	 * @param {module:engine/model/schema~SchemaContextDefinition} [context=['$root']] Elements will be converted according to this context.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} Model data that is a result of the conversion process
	 * wrapped in `DocumentFragment`. Converted marker elements will be set as that document fragment's
	 * {@link module:engine/model/documentfragment~DocumentFragment#markers static markers map}.
	 */
	convert( viewItem, writer, context = [ '$root' ] ) {
		this.fire( 'viewCleanup', viewItem );

		// Create context tree and set position in the top element.
		// Items will be converted according to this position.
		this._modelCursor = createContextTree( context, writer );

		// Store writer in conversion as a conversion API
		// to be sure that conversion process will use the same batch.
		this.conversionApi.writer = writer;

		// Create consumable values list for conversion process.
		this.conversionApi.consumable = _viewconsumable__WEBPACK_IMPORTED_MODULE_0__["default"].createFrom( viewItem );

		// Custom data stored by converter for conversion process.
		this.conversionApi.store = {};

		// Do the conversion.
		const { modelRange } = this._convertItem( viewItem, this._modelCursor );

		// Conversion result is always a document fragment so let's create it.
		const documentFragment = writer.createDocumentFragment();

		// When there is a conversion result.
		if ( modelRange ) {
			// Remove all empty elements that were create while splitting.
			this._removeEmptyElements();

			// Move all items that were converted in context tree to the document fragment.
			for ( const item of Array.from( this._modelCursor.parent.getChildren() ) ) {
				writer.append( item, documentFragment );
			}

			// Extract temporary markers elements from model and set as static markers collection.
			documentFragment.markers = extractMarkersFromModelFragment( documentFragment, writer );
		}

		// Clear context position.
		this._modelCursor = null;

		// Clear split elements lists.
		this._splitParts.clear();

		// Clear conversion API.
		this.conversionApi.writer = null;
		this.conversionApi.store = null;

		// Return fragment as conversion result.
		return documentFragment;
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#convertItem
	 */
	_convertItem( viewItem, modelCursor ) {
		const data = Object.assign( { viewItem, modelCursor, modelRange: null } );

		if ( viewItem.is( 'element' ) ) {
			this.fire( 'element:' + viewItem.name, data, this.conversionApi );
		} else if ( viewItem.is( '$text' ) ) {
			this.fire( 'text', data, this.conversionApi );
		} else {
			this.fire( 'documentFragment', data, this.conversionApi );
		}

		// Handle incorrect conversion result.
		if ( data.modelRange && !( data.modelRange instanceof _model_range__WEBPACK_IMPORTED_MODULE_1__["default"] ) ) {
			/**
			 * Incorrect conversion result was dropped.
			 *
			 * {@link module:engine/model/range~Range Model range} should be a conversion result.
			 *
			 * @error view-conversion-dispatcher-incorrect-result
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_4__["default"]( 'view-conversion-dispatcher-incorrect-result: Incorrect conversion result was dropped.', this );
		}

		return { modelRange: data.modelRange, modelCursor: data.modelCursor };
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#convertChildren
	 */
	_convertChildren( viewItem, modelCursor ) {
		const modelRange = new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( modelCursor );
		let nextModelCursor = modelCursor;

		for ( const viewChild of Array.from( viewItem.getChildren() ) ) {
			const result = this._convertItem( viewChild, nextModelCursor );

			if ( result.modelRange instanceof _model_range__WEBPACK_IMPORTED_MODULE_1__["default"] ) {
				modelRange.end = result.modelRange.end;
				nextModelCursor = result.modelCursor;
			}
		}

		return { modelRange, modelCursor: nextModelCursor };
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#splitToAllowedParent
	 */
	_splitToAllowedParent( node, modelCursor ) {
		// Try to find allowed parent.
		const allowedParent = this.conversionApi.schema.findAllowedParent( modelCursor, node );

		// When there is no parent that allows to insert node then return `null`.
		if ( !allowedParent ) {
			return null;
		}

		// When current position parent allows to insert node then return this position.
		if ( allowedParent === modelCursor.parent ) {
			return { position: modelCursor };
		}

		// When allowed parent is in context tree.
		if ( this._modelCursor.parent.getAncestors().includes( allowedParent ) ) {
			return null;
		}

		// Split element to allowed parent.
		const splitResult = this.conversionApi.writer.split( modelCursor, allowedParent );

		// Using the range returned by `model.Writer#split`, we will pair original elements with their split parts.
		//
		// The range returned from the writer spans "over the split" or, precisely saying, from the end of the original element (the one
		// that got split) to the beginning of the other part of that element:
		//
		// <limit><a><b><c>X[]Y</c></b><a></limit> ->
		// <limit><a><b><c>X[</c></b></a><a><b><c>]Y</c></b></a>
		//
		// After the split there cannot be any full node between the positions in `splitRange`. The positions are touching.
		// Also, because of how splitting works, it is easy to notice, that "closing tags" are in the reverse order than "opening tags".
		// Also, since we split all those elements, each of them has to have the other part.
		//
		// With those observations in mind, we will pair the original elements with their split parts by saving "closing tags" and matching
		// them with "opening tags" in the reverse order. For that we can use a stack.
		const stack = [];

		for ( const treeWalkerValue of splitResult.range.getWalker() ) {
			if ( treeWalkerValue.type == 'elementEnd' ) {
				stack.push( treeWalkerValue.item );
			} else {
				// There should not be any text nodes after the element is split, so the only other value is `elementStart`.
				const originalPart = stack.pop();
				const splitPart = treeWalkerValue.item;

				this._registerSplitPair( originalPart, splitPart );
			}
		}

		return {
			position: splitResult.position,
			cursorParent: splitResult.range.end.parent
		};
	}

	/**
	 * Registers that `splitPart` element is a split part of the `originalPart` element.
	 *
	 * Data set by this method is used by {@link #_getSplitParts} and {@link #_removeEmptyElements}.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} originalPart
	 * @param {module:engine/model/element~Element} splitPart
	 */
	_registerSplitPair( originalPart, splitPart ) {
		if ( !this._splitParts.has( originalPart ) ) {
			this._splitParts.set( originalPart, [ originalPart ] );
		}

		const list = this._splitParts.get( originalPart );

		this._splitParts.set( splitPart, list );
		list.push( splitPart );
	}

	/**
	 * @private
	 * @see module:engine/conversion/upcastdispatcher~UpcastConversionApi#getSplitParts
	 */
	_getSplitParts( element ) {
		let parts;

		if ( !this._splitParts.has( element ) ) {
			parts = [ element ];
		} else {
			parts = this._splitParts.get( element );
		}

		return parts;
	}

	/**
	 * Checks if there are any empty elements created while splitting and removes them.
	 *
	 * This method works recursively to re-check empty elements again after at least one element was removed in the initial call,
	 * as some elements might have become empty after other empty elements were removed from them.
	 *
	 * @private
	 */
	_removeEmptyElements() {
		let anyRemoved = false;

		for ( const element of this._splitParts.keys() ) {
			if ( element.isEmpty ) {
				this.conversionApi.writer.remove( element );
				this._splitParts.delete( element );

				anyRemoved = true;
			}
		}

		if ( anyRemoved ) {
			this._removeEmptyElements();
		}
	}

	/**
	 * Fired before the first conversion event, at the beginning of upcast (view to model conversion) process.
	 *
	 * @event viewCleanup
	 * @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/element~Element}
	 * viewItem Part of the view to be converted.
	 */

	/**
	 * Fired when {@link module:engine/view/element~Element} is converted.
	 *
	 * `element` is a namespace event for a class of events. Names of actually called events follow this pattern:
	 * `element:<elementName>` where `elementName` is the name of converted element. This way listeners may listen to
	 * all elements conversion or to conversion of specific elements.
	 *
	 * @event element
	 * @param {Object} data Conversion data. Keep in mind that this object is shared by reference between all
	 * callbacks that will be called. This means that callbacks can override values if needed, and those values will
	 * be available in other callbacks.
	 * @param {module:engine/view/item~Item} data.viewItem Converted item.
	 * @param {module:engine/model/position~Position} data.modelCursor Position where a converter should start changes.
	 * Change this value for the next converter to tell where the conversion should continue.
	 * @param {module:engine/model/range~Range} data.modelRange The current state of conversion result. Every change to
	 * converted element should be reflected by setting or modifying this property.
	 * @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi Conversion utilities to be used by callback.
	 */

	/**
	 * Fired when {@link module:engine/view/text~Text} is converted.
	 *
	 * @event text
	 * @see #event:element
	 */

	/**
	 * Fired when {@link module:engine/view/documentfragment~DocumentFragment} is converted.
	 *
	 * @event documentFragment
	 * @see #event:element
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( UpcastDispatcher, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__["default"] );

// Traverses given model item and searches elements which marks marker range. Found element is removed from
// DocumentFragment but path of this element is stored in a Map which is then returned.
//
// @param {module:engine/view/documentfragment~DocumentFragment|module:engine/view/node~Node} modelItem Fragment of model.
// @returns {Map<String, module:engine/model/range~Range>} List of static markers.
function extractMarkersFromModelFragment( modelItem, writer ) {
	const markerElements = new Set();
	const markers = new Map();

	// Create ModelTreeWalker.
	const range = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createIn( modelItem ).getItems();

	// Walk through DocumentFragment and collect marker elements.
	for ( const item of range ) {
		// Check if current element is a marker.
		if ( item.name == '$marker' ) {
			markerElements.add( item );
		}
	}

	// Walk through collected marker elements store its path and remove its from the DocumentFragment.
	for ( const markerElement of markerElements ) {
		const markerName = markerElement.getAttribute( 'data-name' );
		const currentPosition = writer.createPositionBefore( markerElement );

		// When marker of given name is not stored it means that we have found the beginning of the range.
		if ( !markers.has( markerName ) ) {
			markers.set( markerName, new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]( currentPosition.clone() ) );
		// Otherwise is means that we have found end of the marker range.
		} else {
			markers.get( markerName ).end = currentPosition.clone();
		}

		// Remove marker element from DocumentFragment.
		writer.remove( markerElement );
	}

	return markers;
}

// Creates model fragment according to given context and returns position in the bottom (the deepest) element.
function createContextTree( contextDefinition, writer ) {
	let position;

	for ( const item of new _model_schema__WEBPACK_IMPORTED_MODULE_3__["SchemaContext"]( contextDefinition ) ) {
		const attributes = {};

		for ( const key of item.getAttributeKeys() ) {
			attributes[ key ] = item.getAttribute( key );
		}

		const current = writer.createElement( item.name, attributes );

		if ( position ) {
			writer.append( current, position );
		}

		position = _model_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( current, 0 );
	}

	return position;
}

/**
 * Conversion interface that is registered for given {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher}
 * and is passed as one of parameters when {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher dispatcher}
 * fires it's events.
 *
 * @interface module:engine/conversion/upcastdispatcher~UpcastConversionApi
 */

/**
 * Starts conversion of given item by firing an appropriate event.
 *
 * Every fired event is passed (as first parameter) an object with `modelRange` property. Every event may set and/or
 * modify that property. When all callbacks are done, the final value of `modelRange` property is returned by this method.
 * The `modelRange` must be {@link module:engine/model/range~Range model range} or `null` (as set by default).
 *
 * @method #convertItem
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:text
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:documentFragment
 * @param {module:engine/view/item~Item} viewItem Item to convert.
 * @param {module:engine/model/position~Position} modelCursor Position of conversion.
 * @returns {Object} result Conversion result.
 * @returns {module:engine/model/range~Range|null} result.modelRange Model range containing result of item conversion,
 * created and modified by callbacks attached to fired event, or `null` if the conversion result was incorrect.
 * @returns {module:engine/model/position~Position} result.modelCursor Position where conversion should be continued.
 */

/**
 * Starts conversion of all children of given item by firing appropriate events for all those children.
 *
 * @method #convertChildren
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:text
 * @fires module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:documentFragment
 * @param {module:engine/view/item~Item} viewItem Element which children should be converted.
 * @param {module:engine/model/position~Position} modelCursor Position of conversion.
 * @returns {Object} result Conversion result.
 * @returns {module:engine/model/range~Range} result.modelRange Model range containing results of conversion of all children of given item.
 * When no children was converted then range is collapsed.
 * @returns {module:engine/model/position~Position} result.modelCursor Position where conversion should be continued.
 */

/**
 * Checks {@link module:engine/model/schema~Schema schema} to find allowed parent for element that we are going to insert
 * starting from given position. If current parent does not allow to insert element but one of the ancestors does then
 * split nodes to allowed parent.
 *
 * If schema allows to insert node in given position, nothing is split and object with that position is returned.
 *
 * If it was not possible to find allowed parent, `null` is returned, nothing is split.
 *
 * Otherwise, ancestors are split and object with position and the copy of the split element is returned.
 *
 * For instance, if `<image>` is not allowed in `<paragraph>` but is allowed in `$root`:
 *
 *		<paragraph>foo[]bar</paragraph>
 *
 *  	-> split for `<image>` ->
 *
 *  	<paragraph>foo</paragraph>[]<paragraph>bar</paragraph>
 *
 * In the sample above position between `<paragraph>` elements will be returned as `position` and the second `paragraph`
 * as `cursorParent`.
 *
 * @method #splitToAllowedParent
 * @param {module:engine/model/position~Position} position Position on which element is going to be inserted.
 * @param {module:engine/model/node~Node} node Node to insert.
 * @returns {Object|null} Split result. If it was not possible to find allowed position `null` is returned.
 * @returns {module:engine/model/position~Position} position between split elements.
 * @returns {module:engine/model/element~Element} [cursorParent] Element inside which cursor should be placed to
 * continue conversion. When element is not defined it means that there was no split.
 */

/**
 * Returns all the split parts of given `element` that were created during upcasting through using {@link #splitToAllowedParent}.
 * It enables you to easily track those elements and continue processing them after they are split during their children conversion.
 *
 *		<paragraph>Foo<image />bar<image />baz</paragraph> ->
 *		<paragraph>Foo</paragraph><image /><paragraph>bar</paragraph><image /><paragraph>baz</paragraph>
 *
 * For a reference to any of above paragraphs, the function will return all three paragraphs (the original element included),
 * sorted in the order of their creation (the original element is the first one).
 *
 * If given `element` was not split, an array with single element is returned.
 *
 * Example of a usage in a converter code:
 *
 *		const myElement = conversionApi.writer.createElement( 'myElement' );
 *
 *		// Children conversion may split `myElement`.
 *		conversionApi.convertChildren( myElement, modelCursor );
 *
 *		const splitParts = conversionApi.getSplitParts( myElement );
 *		const lastSplitPart = splitParts[ splitParts.length - 1 ];
 *
 *		// Setting `data.modelRange` basing on split parts:
 *		data.modelRange = conversionApi.writer.createRange(
 *			conversionApi.writer.createPositionBefore( myElement ),
 *			conversionApi.writer.createPositionAfter( lastSplitPart )
 *		);
 *
 *		// Setting `data.modelCursor` to continue after the last split element:
 *		data.modelCursor = conversionApi.writer.createPositionAfter( lastSplitPart );
 *
 * **Tip:** if you are unable to get a reference to the original element (for example because the code is split into multiple converters
 * or even classes) but it was already converted, you might want to check first element in `data.modelRange`. This is a common situation
 * if an attribute converter is separated from an element converter.
 *
 * @method #getSplitParts
 * @param {module:engine/model/element~Element} element
 * @returns {Array.<module:engine/model/element~Element>}
 */

/**
 * Stores information about what parts of processed view item are still waiting to be handled. After a piece of view item
 * was converted, appropriate consumable value should be {@link module:engine/conversion/viewconsumable~ViewConsumable#consume consumed}.
 *
 * @member {module:engine/conversion/viewconsumable~ViewConsumable} #consumable
 */

/**
 * Custom data stored by converters for conversion process. Custom properties of this object can be defined and use to
 * pass parameters between converters.
 *
 * The difference between this property and `data` parameter of
 * {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element} is that `data` parameters allows you
 * to pass parameters within a single event and `store` within the whole conversion.
 *
 * @member {Object} #store
 */

/**
 * The model's schema instance.
 *
 * @member {module:engine/model/schema~Schema} #schema
 */

/**
 * The {@link module:engine/model/writer~Writer} instance used to manipulate data during conversion.
 *
 * @member {module:engine/model/writer~Writer} #writer
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/upcasthelpers.js ***!
  \*********************************************************************************/
/*! exports provided: default, convertToModelFragment, convertText, convertSelectionChange */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return UpcastHelpers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertToModelFragment", function() { return convertToModelFragment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertText", function() { return convertText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "convertSelectionChange", function() { return convertSelectionChange; });
/* harmony import */ var _view_matcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../view/matcher */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/matcher.js");
/* harmony import */ var _model_range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../model/range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _conversionhelpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conversionhelpers */ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/conversionhelpers.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _model_selection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../model/selection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/priorities */ "./node_modules/@ckeditor/ckeditor5-utils/src/priorities.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */











/* global console */

/**
 * Contains {@link module:engine/view/view view} to {@link module:engine/model/model model} converters for
 * {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher}.
 *
 * @module engine/conversion/upcasthelpers
 */

/**
 * Upcast conversion helper functions.
 *
 * @extends module:engine/conversion/conversionhelpers~ConversionHelpers
 */
class UpcastHelpers extends _conversionhelpers__WEBPACK_IMPORTED_MODULE_2__["default"] {
	/**
	 * View element to model element conversion helper.
	 *
	 * This conversion results in creating a model element. For example,
	 * view `<p>Foo</p>` becomes `<paragraph>Foo</paragraph>` in the model.
	 *
	 * Keep in mind that the element will be inserted only if it is allowed
	 * by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: 'p',
	 *			model: 'paragraph'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: 'p',
	 *			model: 'paragraph',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 *			view: {
	 *				name: 'p',
	 *				classes: 'fancy'
	 *			},
	 *			model: 'fancyParagraph'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToElement( {
	 * 			view: {
	 *				name: 'p',
	 *				classes: 'heading'
	 * 			},
	 * 			model: ( viewElement, modelWriter ) => {
	 * 				return modelWriter.createElement( 'heading', { level: viewElement.getAttribute( 'data-level' ) } );
	 * 			}
	 * 		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToElement
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} [config.view] Pattern matching all view elements which should be converted. If not
	 * set, the converter will fire for every view element.
	 * @param {String|module:engine/model/element~Element|Function} config.model Name of the model element, a model element
	 * instance or a function that takes a view element and returns a model element. The model element will be inserted in the model.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToElement( config ) {
		return this.add( upcastElementToElement( config ) );
	}

	/**
	 * View element to model attribute conversion helper.
	 *
	 * This conversion results in setting an attribute on a model node. For example, view `<strong>Foo</strong>` becomes
	 * `Foo` {@link module:engine/model/text~Text model text node} with `bold` attribute set to `true`.
	 *
	 * This helper is meant to set a model attribute on all the elements that are inside the converted element:
	 *
	 *		<strong>Foo</strong>   -->   <strong><p>Foo</p></strong>   -->   <paragraph><$text bold="true">Foo</$text></paragraph>
	 *
	 * Above is a sample of HTML code, that goes through autoparagraphing (first step) and then is converted (second step).
	 * Even though `<strong>` is over `<p>` element, `bold="true"` was added to the text. See
	 * {@link module:engine/conversion/upcasthelpers~UpcastHelpers#attributeToAttribute} for comparison.
	 *
	 * Keep in mind that the attribute will be set only if it is allowed by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: 'strong',
	 *			model: 'bold'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: 'strong',
	 *			model: 'bold',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				classes: 'bold'
	 *			},
	 *			model: 'bold'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				classes: [ 'styled', 'styled-dark' ]
	 *			},
	 *			model: {
	 *				key: 'styled',
	 *				value: 'dark'
	 *			}
	 *		} );
	 *
	 * 		editor.conversion.for( 'upcast' ).elementToAttribute( {
	 *			view: {
	 *				name: 'span',
	 *				styles: {
	 *					'font-size': /[\s\S]+/
	 *				}
	 *			},
	 *			model: {
	 *				key: 'fontSize',
	 *				value: viewElement => {
	 *					const fontSize = viewElement.getStyle( 'font-size' );
	 *					const value = fontSize.substr( 0, fontSize.length - 2 );
	 *
	 *					if ( value <= 10 ) {
	 *						return 'small';
	 *					} else if ( value > 12 ) {
	 *						return 'big';
	 *					}
	 *
	 *					return null;
	 *				}
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #elementToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
	 * @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
	 * the model attribute. `value` property may be set as a function that takes a view element and returns the value.
	 * If `String` is given, the model attribute value will be set to `true`.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToAttribute( config ) {
		return this.add( upcastElementToAttribute( config ) );
	}

	/**
	 * View attribute to model attribute conversion helper.
	 *
	 * This conversion results in setting an attribute on a model node. For example, view `<img src="foo.jpg"></img>` becomes
	 * `<image source="foo.jpg"></image>` in the model.
	 *
	 * This helper is meant to convert view attributes from view elements which got converted to the model, so the view attribute
	 * is set only on the corresponding model node:
	 *
	 *		<div class="dark"><div>foo</div></div>    -->    <div dark="true"><div>foo</div></div>
	 *
	 * Above, `class="dark"` attribute is added only to the `<div>` elements that has it. This is in contrary to
	 * {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToAttribute} which sets attributes for
	 * all the children in the model:
	 *
	 *		<strong>Foo</strong>   -->   <strong><p>Foo</p></strong>   -->   <paragraph><$text bold="true">Foo</$text></paragraph>
	 *
	 * Above is a sample of HTML code, that goes through autoparagraphing (first step) and then is converted (second step).
	 * Even though `<strong>` is over `<p>` element, `bold="true"` was added to the text.
	 *
	 * Keep in mind that the attribute will be set only if it is allowed by {@link module:engine/model/schema~Schema schema} configuration.
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: 'src',
	 *			model: 'source'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: { key: 'src' },
	 *			model: 'source'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: { key: 'src' },
	 *			model: 'source',
	 *			converterPriority: 'normal'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				key: 'data-style',
	 *				value: /[\s\S]+/
	 *			},
	 *			model: 'styled'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				name: 'img',
	 *				key: 'class',
	 *				value: 'styled-dark'
	 *			},
	 *			model: {
	 *				key: 'styled',
	 *				value: 'dark'
	 *			}
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				key: 'class',
	 *				value: /styled-[\S]+/
	 *			},
	 *			model: {
	 *				key: 'styled'
	 *				value: viewElement => {
	 *					const regexp = /styled-([\S]+)/;
	 *					const match = viewElement.getAttribute( 'class' ).match( regexp );
	 *
	 *					return match[ 1 ];
	 *				}
	 *			}
	 *		} );
	 *
	 * Converting styles works a bit differently as it requires `view.styles` to be an object and by default
	 * a model attribute will be set to `true` by such a converter. You can set the model attribute to any value by providing the `value`
	 * callback that returns the desired value.
	 *
	 *		// Default conversion of font-weight style will result in setting bold attribute to true.
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				styles: {
	 *					'font-weight': 'bold'
	 *				}
	 *			},
	 *			model: 'bold'
	 *		} );
	 *
	 *		// This converter will pass any style value to the `lineHeight` model attribute.
	 *		editor.conversion.for( 'upcast' ).attributeToAttribute( {
	 *			view: {
	 *				styles: {
	 *					'line-height': /[\s\S]+/
	 *				}
	 *			},
	 *			model: {
	 *				key: 'lineHeight',
	 *				value: viewElement => viewElement.getStyle( 'line-height' )
	 *			}
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #attributeToAttribute
	 * @param {Object} config Conversion configuration.
	 * @param {String|Object} config.view Specifies which view attribute will be converted. If a `String` is passed,
	 * attributes with given key will be converted. If an `Object` is passed, it must have a required `key` property,
	 * specifying view attribute key, and may have an optional `value` property, specifying view attribute value and optional `name`
	 * property specifying a view element name from/on which the attribute should be converted. `value` can be given as a `String`,
	 * a `RegExp` or a function callback, that takes view attribute value as the only parameter and returns `Boolean`.
	 * @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
	 * the model attribute. `value` property may be set as a function that takes a view element and returns the value.
	 * If `String` is given, the model attribute value will be same as view attribute value.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	attributeToAttribute( config ) {
		return this.add( upcastAttributeToAttribute( config ) );
	}

	/**
	 * View element to model marker conversion helper.
	 *
	 * **Note**: This method was deprecated. Please use {@link #dataToMarker} instead.
	 *
	 * This conversion results in creating a model marker. For example, if the marker was stored in a view as an element:
	 * `<p>Fo<span data-marker="comment" data-comment-id="7"></span>o</p><p>B<span data-marker="comment" data-comment-id="7"></span>ar</p>`,
	 * after the conversion is done, the marker will be available in
	 * {@link module:engine/model/model~Model#markers model document markers}.
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: 'search'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: 'search',
	 *			converterPriority: 'high'
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: 'marker-search',
	 *			model: viewElement => 'comment:' + viewElement.getAttribute( 'data-comment-id' )
	 *		} );
	 *
	 *		editor.conversion.for( 'upcast' ).elementToMarker( {
	 *			view: {
	 *				name: 'span',
	 *				attributes: {
	 *					'data-marker': 'search'
	 *				}
	 *			},
	 *			model: 'search'
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @deprecated
	 * @method #elementToMarker
	 * @param {Object} config Conversion configuration.
	 * @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
	 * @param {String|Function} config.model Name of the model marker, or a function that takes a view element and returns
	 * a model marker name.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	elementToMarker( config ) {
		/**
		 * The {@link module:engine/conversion/upcasthelpers~UpcastHelpers#elementToMarker `UpcastHelpers#elementToMarker()`}
		 * method has been deprecated and will be removed in the near future.
		 * Please use {@link module:engine/conversion/upcasthelpers~UpcastHelpers#dataToMarker `UpcastHelpers#dataToMarker()`} instead.
		 *
		 * @error upcast-helpers-element-to-marker-deprecated
		 */
		console.warn(
			Object(_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["attachLinkToDocumentation"])(
				'upcast-helpers-element-to-marker-deprecated: ' +
				'The UpcastHelpers#elementToMarker() method has been deprecated and will be removed in the near future. ' +
				'Please use UpcastHelpers#dataToMarker() instead.'
			)
		);

		return this.add( upcastElementToMarker( config ) );
	}

	/**
	 * View to model marker conversion helper.
	 *
	 * Converts view data created by {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToData `#markerToData()`}
	 * back to a model marker.
	 *
	 * This converter looks for specific view elements and view attributes that mark marker boundaries. See
	 * {@link module:engine/conversion/downcasthelpers~DowncastHelpers#markerToData `#markerToData()`} to learn what view data
	 * is expected by this converter.
	 *
	 * The `config.view` property is equal to the marker group name to convert.
	 *
	 * By default, this converter creates markers with `group:name` name convention (to match the default `markerToData` conversion).
	 *
	 * The conversion configuration can take a function that will generate a marker name.
	 * If such function is set as the `config.model` parameter, it is passed the `name` part from the view element or attribute and it is
	 * expected to return a string with the marker name.
	 *
	 * Basic usage:
	 *
	 *		// Using the default conversion.
	 *		// In this case, all markers from `comment` group will be converted.
	 *		// The conversion will look for `<comment-start>` and `<comment-end>` tags and
	 *		// `data-comment-start-before`, `data-comment-start-after`,
	 *		// `data-comment-end-before` and `data-comment-end-after` attributes.
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment'
	 *		} );
	 *
	 * An example of a model that may be generated by this conversion:
	 *
	 *		// View:
	 *		<p>Foo<comment-start name="commentId:uid"></comment-start>bar</p>
	 *		<figure data-comment-end-after="commentId:uid" class="image"><img src="abc.jpg" /></figure>
	 *
	 *		// Model:
	 *		<paragraph>Foo[bar</paragraph>
	 *		<image src="abc.jpg"></image>]
	 *
	 * Where `[]` are boundaries of a marker that will receive `comment:commentId:uid` name.
	 *
	 * Other examples of usage:
	 *
	 *		// Using custom function which is the same as the default conversion:
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment',
	 *			model: name => 'comment:' + name,
	 *		} );
	 *
	 *		// Using converter priority:
	 *		editor.conversion.for( 'upcast' ).dataToMarker( {
	 *			view: 'comment',
	 *			model: name => 'comment:' + name,
	 *			converterPriority: 'high'
	 *		} );
	 *
	 * See {@link module:engine/conversion/conversion~Conversion#for `conversion.for()`} to learn how to add a converter
	 * to the conversion process.
	 *
	 * @method #dataToMarker
	 * @param {Object} config Conversion configuration.
	 * @param {String} config.view Marker group name to convert.
	 * @param {Function} [config.model] Function that takes `name` part from the view element or attribute and returns the marker name.
	 * @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
	 * @returns {module:engine/conversion/upcasthelpers~UpcastHelpers}
	 */
	dataToMarker( config ) {
		return this.add( upcastDataToMarker( config ) );
	}
}

/**
 * Function factory, creates a converter that converts {@link module:engine/view/documentfragment~DocumentFragment view document fragment}
 * or all children of {@link module:engine/view/element~Element} into
 * {@link module:engine/model/documentfragment~DocumentFragment model document fragment}.
 * This is the "entry-point" converter for upcast (view to model conversion). This converter starts the conversion of all children
 * of passed view document fragment. Those children {@link module:engine/view/node~Node view nodes} are then handled by other converters.
 *
 * This also a "default", last resort converter for all view elements that has not been converted by other converters.
 * When a view element is being converted to the model but it does not have converter specified, that view element
 * will be converted to {@link module:engine/model/documentfragment~DocumentFragment model document fragment} and returned.
 *
 * @returns {Function} Universal converter for view {@link module:engine/view/documentfragment~DocumentFragment fragments} and
 * {@link module:engine/view/element~Element elements} that returns
 * {@link module:engine/model/documentfragment~DocumentFragment model fragment} with children of converted view item.
 */
function convertToModelFragment() {
	return ( evt, data, conversionApi ) => {
		// Second argument in `consumable.consume` is discarded for ViewDocumentFragment but is needed for ViewElement.
		if ( !data.modelRange && conversionApi.consumable.consume( data.viewItem, { name: true } ) ) {
			const { modelRange, modelCursor } = conversionApi.convertChildren( data.viewItem, data.modelCursor );

			data.modelRange = modelRange;
			data.modelCursor = modelCursor;
		}
	};
}

/**
 * Function factory, creates a converter that converts {@link module:engine/view/text~Text} to {@link module:engine/model/text~Text}.
 *
 * @returns {Function} {@link module:engine/view/text~Text View text} converter.
 */
function convertText() {
	return ( evt, data, conversionApi ) => {
		if ( conversionApi.schema.checkChild( data.modelCursor, '$text' ) ) {
			if ( conversionApi.consumable.consume( data.viewItem ) ) {
				const text = conversionApi.writer.createText( data.viewItem.data );

				conversionApi.writer.insert( text, data.modelCursor );

				data.modelRange = _model_range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( data.modelCursor, text.offsetSize );
				data.modelCursor = data.modelRange.end;
			}
		}
	};
}

/**
 * Function factory, creates a callback function which converts a {@link module:engine/view/selection~Selection
 * view selection} taken from the {@link module:engine/view/document~Document#event:selectionChange} event
 * and sets in on the {@link module:engine/model/document~Document#selection model}.
 *
 * **Note**: because there is no view selection change dispatcher nor any other advanced view selection to model
 * conversion mechanism, the callback should be set directly on view document.
 *
 *		view.document.on( 'selectionChange', convertSelectionChange( modelDocument, mapper ) );
 *
 * @param {module:engine/model/model~Model} model Data model.
 * @param {module:engine/conversion/mapper~Mapper} mapper Conversion mapper.
 * @returns {Function} {@link module:engine/view/document~Document#event:selectionChange} callback function.
 */
function convertSelectionChange( model, mapper ) {
	return ( evt, data ) => {
		const viewSelection = data.newSelection;
		const modelSelection = new _model_selection__WEBPACK_IMPORTED_MODULE_4__["default"]();

		const ranges = [];

		for ( const viewRange of viewSelection.getRanges() ) {
			ranges.push( mapper.toModelRange( viewRange ) );
		}

		modelSelection.setTo( ranges, { backward: viewSelection.isBackward } );

		if ( !modelSelection.isEqual( model.document.selection ) ) {
			model.change( writer => {
				writer.setSelection( modelSelection );
			} );
		}
	};
}

// View element to model element conversion helper.
//
// See {@link ~UpcastHelpers#elementToElement `.elementToElement()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} [config.view] Pattern matching all view elements which should be converted. If not
// set, the converter will fire for every view element.
// @param {String|module:engine/model/element~Element|Function} config.model Name of the model element, a model element
// instance or a function that takes a view element and returns a model element. The model element will be inserted in the model.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToElement( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])( config );

	const converter = prepareToElementConverter( config );

	const elementName = getViewElementNameFromConfig( config.view );
	const eventName = elementName ? 'element:' + elementName : 'element';

	return dispatcher => {
		dispatcher.on( eventName, converter, { priority: config.converterPriority || 'normal' } );
	};
}

// View element to model attribute conversion helper.
//
// See {@link ~UpcastHelpers#elementToAttribute `.elementToAttribute()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
// @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
// the model attribute. `value` property may be set as a function that takes a view element and returns the value.
// If `String` is given, the model attribute value will be set to `true`.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToAttribute( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])( config );

	normalizeModelAttributeConfig( config );

	const converter = prepareToAttributeConverter( config, false );

	const elementName = getViewElementNameFromConfig( config.view );
	const eventName = elementName ? 'element:' + elementName : 'element';

	return dispatcher => {
		dispatcher.on( eventName, converter, { priority: config.converterPriority || 'low' } );
	};
}

// View attribute to model attribute conversion helper.
//
// See {@link ~UpcastHelpers#attributeToAttribute `.attributeToAttribute()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {String|Object} config.view Specifies which view attribute will be converted. If a `String` is passed,
// attributes with given key will be converted. If an `Object` is passed, it must have a required `key` property,
// specifying view attribute key, and may have an optional `value` property, specifying view attribute value and optional `name`
// property specifying a view element name from/on which the attribute should be converted. `value` can be given as a `String`,
// a `RegExp` or a function callback, that takes view attribute value as the only parameter and returns `Boolean`.
// @param {String|Object} config.model Model attribute key or an object with `key` and `value` properties, describing
// the model attribute. `value` property may be set as a function that takes a view element and returns the value.
// If `String` is given, the model attribute value will be same as view attribute value.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='low'] Converter priority.
// @returns {Function} Conversion helper.
function upcastAttributeToAttribute( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])( config );

	let viewKey = null;

	if ( typeof config.view == 'string' || config.view.key ) {
		viewKey = normalizeViewAttributeKeyValueConfig( config );
	}

	normalizeModelAttributeConfig( config, viewKey );

	const converter = prepareToAttributeConverter( config, true );

	return dispatcher => {
		dispatcher.on( 'element', converter, { priority: config.converterPriority || 'low' } );
	};
}

// View element to model marker conversion helper.
//
// See {@link ~UpcastHelpers#elementToMarker `.elementToMarker()` upcast helper} for examples.
//
// @param {Object} config Conversion configuration.
// @param {module:engine/view/matcher~MatcherPattern} config.view Pattern matching all view elements which should be converted.
// @param {String|Function} config.model Name of the model marker, or a function that takes a view element and returns
// a model marker name.
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal'] Converter priority.
// @returns {Function} Conversion helper.
function upcastElementToMarker( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])( config );

	normalizeElementToMarkerConfig( config );

	return upcastElementToElement( config );
}

// View data to model marker conversion helper.
//
// See {@link ~UpcastHelpers#dataToMarker} to learn more.
//
// @param {Object} config
// @param {String} config.view
// @param {Function} [config.model]
// @param {module:utils/priorities~PriorityString} [config.converterPriority='normal']
// @returns {Function} Conversion helper.
function upcastDataToMarker( config ) {
	config = Object(lodash_es__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])( config );

	// Default conversion.
	if ( !config.model ) {
		config.model = name => {
			return name ? config.view + ':' + name : config.view;
		};
	}

	const converterStart = prepareToElementConverter( normalizeDataToMarkerConfig( config, 'start' ) );
	const converterEnd = prepareToElementConverter( normalizeDataToMarkerConfig( config, 'end' ) );

	return dispatcher => {
		dispatcher.on( 'element:' + config.view + '-start', converterStart, { priority: config.converterPriority || 'normal' } );
		dispatcher.on( 'element:' + config.view + '-end', converterEnd, { priority: config.converterPriority || 'normal' } );

		// Below is a hack that is needed to properly handle `converterPriority` for both elements and attributes.
		// Attribute conversion needs to be performed *after* element conversion.
		// This converter handles both element conversion and attribute conversion, which means that if a single
		// `config.converterPriority` is used, it will lead to problems. For example, if `'high'` priority is used,
		// then attribute conversion will be performed before a lot of element upcast converters.
		// On the other hand we want to support `config.converterPriority` and overwriting conveters.
		//
		// To have it work, we need to do some extra processing for priority for attribute converter.
		// Priority `'low'` value should be the base value and then we will change it depending on `config.converterPriority` value.
		//
		// This hack probably would not be needed if attributes are upcasted separately.
		//
		const basePriority = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_6__["default"].get( 'low' );
		const maxPriority = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_6__["default"].get( 'highest' );
		const priorityFactor = _ckeditor_ckeditor5_utils_src_priorities__WEBPACK_IMPORTED_MODULE_6__["default"].get( config.converterPriority ) / maxPriority; // Number in range [ -1, 1 ].

		dispatcher.on( 'element', upcastAttributeToMarker( config ), { priority: basePriority + priorityFactor } );
	};
}

// Function factory, returns a callback function which converts view attributes to a model marker.
//
// The converter looks for elements with `data-group-start-before`, `data-group-start-after`, `data-group-end-before`
// and `data-group-end-after` attributes and inserts `$marker` model elements before/after those elements.
// `group` part is specified in `config.view`.
//
// @param {Object} config
// @param {String} config.view
// @param {Function} [config.model]
// @returns {Function} Marker converter.
function upcastAttributeToMarker( config ) {
	return ( evt, data, conversionApi ) => {
		const attrName = `data-${ config.view }`;

		// This converter wants to add a model element, marking a marker, before/after an element (or maybe even group of elements).
		// To do that, we can use `data.modelRange` which is set on an element (or a group of elements) that has been upcasted.
		// But, if the processed view element has not been upcasted yet (it does not have been converted), we need to
		// fire conversion for its children first, then we will have `data.modelRange` available.
		if ( !data.modelRange ) {
			data = Object.assign( data, conversionApi.convertChildren( data.viewItem, data.modelCursor ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-end-after' } ) ) {
			addMarkerElements( data.modelRange.end, data.viewItem.getAttribute( attrName + '-end-after' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-start-after' } ) ) {
			addMarkerElements( data.modelRange.end, data.viewItem.getAttribute( attrName + '-start-after' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-end-before' } ) ) {
			addMarkerElements( data.modelRange.start, data.viewItem.getAttribute( attrName + '-end-before' ).split( ',' ) );
		}

		if ( conversionApi.consumable.consume( data.viewItem, { attributes: attrName + '-start-before' } ) ) {
			addMarkerElements( data.modelRange.start, data.viewItem.getAttribute( attrName + '-start-before' ).split( ',' ) );
		}

		function addMarkerElements( position, markerViewNames ) {
			for ( const markerViewName of markerViewNames ) {
				const markerName = config.model( markerViewName );
				const element = conversionApi.writer.createElement( '$marker', { 'data-name': markerName } );

				conversionApi.writer.insert( element, position );

				if ( data.modelCursor.isEqual( position ) ) {
					data.modelCursor = data.modelCursor.getShiftedBy( 1 );
				} else {
					data.modelCursor = data.modelCursor._getTransformedByInsertion( position, 1 );
				}

				data.modelRange = data.modelRange._getTransformedByInsertion( position, 1 )[ 0 ];
			}
		}
	};
}

// Helper function for from-view-element conversion. Checks if `config.view` directly specifies converted view element's name
// and if so, returns it.
//
// @param {Object} config Conversion view config.
// @returns {String|null} View element name or `null` if name is not directly set.
function getViewElementNameFromConfig( viewConfig ) {
	if ( typeof viewConfig == 'string' ) {
		return viewConfig;
	}

	if ( typeof viewConfig == 'object' && typeof viewConfig.name == 'string' ) {
		return viewConfig.name;
	}

	return null;
}

// Helper for to-model-element conversion. Takes a config object and returns a proper converter function.
//
// @param {Object} config Conversion configuration.
// @returns {Function} View to model converter.
function prepareToElementConverter( config ) {
	const matcher = config.view ? new _view_matcher__WEBPACK_IMPORTED_MODULE_0__["default"]( config.view ) : null;

	return ( evt, data, conversionApi ) => {
		let match = {};

		// If `config.view` has not been passed do not try matching. In this case, the converter should fire for all elements.
		if ( matcher ) {
			// This will be usually just one pattern but we support matchers with many patterns too.
			const matcherResult = matcher.match( data.viewItem );

			// If there is no match, this callback should not do anything.
			if ( !matcherResult ) {
				return;
			}

			match = matcherResult.match;
		}

		// Force consuming element's name.
		match.name = true;

		// Create model element basing on config.
		const modelElement = getModelElement( config.model, data.viewItem, conversionApi.writer );

		// Do not convert if element building function returned falsy value.
		if ( !modelElement ) {
			return;
		}

		// When element was already consumed then skip it.
		if ( !conversionApi.consumable.test( data.viewItem, match ) ) {
			return;
		}

		// Find allowed parent for element that we are going to insert.
		// If current parent does not allow to insert element but one of the ancestors does
		// then split nodes to allowed parent.
		const splitResult = conversionApi.splitToAllowedParent( modelElement, data.modelCursor );

		// When there is no split result it means that we can't insert element to model tree, so let's skip it.
		if ( !splitResult ) {
			return;
		}

		// Insert element on allowed position.
		conversionApi.writer.insert( modelElement, splitResult.position );

		// Convert children and insert to element.
		conversionApi.convertChildren( data.viewItem, conversionApi.writer.createPositionAt( modelElement, 0 ) );

		// Consume appropriate value from consumable values list.
		conversionApi.consumable.consume( data.viewItem, match );

		const parts = conversionApi.getSplitParts( modelElement );

		// Set conversion result range.
		data.modelRange = new _model_range__WEBPACK_IMPORTED_MODULE_1__["default"](
			conversionApi.writer.createPositionBefore( modelElement ),
			conversionApi.writer.createPositionAfter( parts[ parts.length - 1 ] )
		);

		// Now we need to check where the `modelCursor` should be.
		if ( splitResult.cursorParent ) {
			// If we split parent to insert our element then we want to continue conversion in the new part of the split parent.
			//
			// before: <allowed><notAllowed>foo[]</notAllowed></allowed>
			// after:  <allowed><notAllowed>foo</notAllowed><converted></converted><notAllowed>[]</notAllowed></allowed>

			data.modelCursor = conversionApi.writer.createPositionAt( splitResult.cursorParent, 0 );
		} else {
			// Otherwise just continue after inserted element.

			data.modelCursor = data.modelRange.end;
		}
	};
}

// Helper function for upcasting-to-element converter. Takes the model configuration, the converted view element
// and a writer instance and returns a model element instance to be inserted in the model.
//
// @param {String|Function|module:engine/model/element~Element} model Model conversion configuration.
// @param {module:engine/view/node~Node} input The converted view node.
// @param {module:engine/model/writer~Writer} writer A writer instance to use to create the model element.
function getModelElement( model, input, writer ) {
	if ( model instanceof Function ) {
		return model( input, writer );
	} else {
		return writer.createElement( model );
	}
}

// Helper function view-attribute-to-model-attribute helper. Normalizes `config.view` which was set as `String` or
// as an `Object` with `key`, `value` and `name` properties. Normalized `config.view` has is compatible with
// {@link module:engine/view/matcher~MatcherPattern}.
//
// @param {Object} config Conversion config.
// @returns {String} Key of the converted view attribute.
function normalizeViewAttributeKeyValueConfig( config ) {
	if ( typeof config.view == 'string' ) {
		config.view = { key: config.view };
	}

	const key = config.view.key;
	let normalized;

	if ( key == 'class' || key == 'style' ) {
		const keyName = key == 'class' ? 'classes' : 'styles';

		normalized = {
			[ keyName ]: config.view.value
		};
	} else {
		const value = typeof config.view.value == 'undefined' ? /[\s\S]*/ : config.view.value;

		normalized = {
			attributes: {
				[ key ]: value
			}
		};
	}

	if ( config.view.name ) {
		normalized.name = config.view.name;
	}

	config.view = normalized;

	return key;
}

// Helper function that normalizes `config.model` in from-model-attribute conversion. `config.model` can be set
// as a `String`, an `Object` with only `key` property or an `Object` with `key` and `value` properties. Normalized
// `config.model` is an `Object` with `key` and `value` properties.
//
// @param {Object} config Conversion config.
// @param {String} viewAttributeKeyToCopy Key of the converted view attribute. If it is set, model attribute value
// will be equal to view attribute value.
function normalizeModelAttributeConfig( config, viewAttributeKeyToCopy = null ) {
	const defaultModelValue = viewAttributeKeyToCopy === null ? true : viewElement => viewElement.getAttribute( viewAttributeKeyToCopy );

	const key = typeof config.model != 'object' ? config.model : config.model.key;
	const value = typeof config.model != 'object' || typeof config.model.value == 'undefined' ? defaultModelValue : config.model.value;

	config.model = { key, value };
}

// Helper for to-model-attribute conversion. Takes the model attribute name and conversion configuration and returns
// a proper converter function.
//
// @param {String} modelAttributeKey The key of the model attribute to set on a model node.
// @param {Object|Array.<Object>} config Conversion configuration. It is possible to provide multiple configurations in an array.
// @param {Boolean} shallow If set to `true` the attribute will be set only on top-level nodes. Otherwise, it will be set
// on all elements in the range.
function prepareToAttributeConverter( config, shallow ) {
	const matcher = new _view_matcher__WEBPACK_IMPORTED_MODULE_0__["default"]( config.view );

	return ( evt, data, conversionApi ) => {
		const match = matcher.match( data.viewItem );

		// If there is no match, this callback should not do anything.
		if ( !match ) {
			return;
		}

		const modelKey = config.model.key;
		const modelValue = typeof config.model.value == 'function' ? config.model.value( data.viewItem ) : config.model.value;

		// Do not convert if attribute building function returned falsy value.
		if ( modelValue === null ) {
			return;
		}

		if ( onlyViewNameIsDefined( config.view, data.viewItem ) ) {
			match.match.name = true;
		} else {
			// Do not test or consume `name` consumable.
			delete match.match.name;
		}

		// Try to consume appropriate values from consumable values list.
		if ( !conversionApi.consumable.test( data.viewItem, match.match ) ) {
			return;
		}

		// Since we are converting to attribute we need an range on which we will set the attribute.
		// If the range is not created yet, we will create it.
		if ( !data.modelRange ) {
			// Convert children and set conversion result as a current data.
			data = Object.assign( data, conversionApi.convertChildren( data.viewItem, data.modelCursor ) );
		}

		// Set attribute on current `output`. `Schema` is checked inside this helper function.
		const attributeWasSet = setAttributeOn( data.modelRange, { key: modelKey, value: modelValue }, shallow, conversionApi );

		if ( attributeWasSet ) {
			conversionApi.consumable.consume( data.viewItem, match.match );
		}
	};
}

// Helper function that checks if element name should be consumed in attribute converters.
//
// @param {Object} config Conversion view config.
// @returns {Boolean}
function onlyViewNameIsDefined( viewConfig, viewItem ) {
	// https://github.com/ckeditor/ckeditor5-engine/issues/1786
	const configToTest = typeof viewConfig == 'function' ? viewConfig( viewItem ) : viewConfig;

	if ( typeof configToTest == 'object' && !getViewElementNameFromConfig( configToTest ) ) {
		return false;
	}

	return !configToTest.classes && !configToTest.attributes && !configToTest.styles;
}

// Helper function for to-model-attribute converter. Sets model attribute on given range. Checks {@link module:engine/model/schema~Schema}
// to ensure proper model structure.
//
// @param {module:engine/model/range~Range} modelRange Model range on which attribute should be set.
// @param {Object} modelAttribute Model attribute to set.
// @param {module:engine/conversion/upcastdispatcher~UpcastConversionApi} conversionApi Conversion API.
// @param {Boolean} shallow If set to `true` the attribute will be set only on top-level nodes. Otherwise, it will be set
// on all elements in the range.
// @returns {Boolean} `true` if attribute was set on at least one node from given `modelRange`.
function setAttributeOn( modelRange, modelAttribute, shallow, conversionApi ) {
	let result = false;

	// Set attribute on each item in range according to Schema.
	for ( const node of Array.from( modelRange.getItems( { shallow } ) ) ) {
		if ( conversionApi.schema.checkAttribute( node, modelAttribute.key ) ) {
			conversionApi.writer.setAttribute( modelAttribute.key, modelAttribute.value, node );

			result = true;
		}
	}

	return result;
}

// Helper function for upcasting-to-marker conversion. Takes the config in a format requested by `upcastElementToMarker()`
// function and converts it to a format that is supported by `upcastElementToElement()` function.
//
// @param {Object} config Conversion configuration.
function normalizeElementToMarkerConfig( config ) {
	const oldModel = config.model;

	config.model = ( viewElement, modelWriter ) => {
		const markerName = typeof oldModel == 'string' ? oldModel : oldModel( viewElement );

		return modelWriter.createElement( '$marker', { 'data-name': markerName } );
	};
}

// Helper function for upcasting-to-marker conversion. Takes the config in a format requested by `upcastDataToMarker()`
// function and converts it to a format that is supported by `upcastElementToElement()` function.
//
// @param {Object} config Conversion configuration.
function normalizeDataToMarkerConfig( config, type ) {
	const configForElements = {};

	// Upcast <markerGroup-start> and <markerGroup-end> elements.
	configForElements.view = config.view + '-' + type;

	configForElements.model = ( viewElement, modelWriter ) => {
		const viewName = viewElement.getAttribute( 'name' );
		const markerName = config.model( viewName );

		return modelWriter.createElement( '$marker', { 'data-name': markerName } );
	};

	return configForElements;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/conversion/viewconsumable.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ViewConsumable; });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/conversion/viewconsumable
 */




/**
 * Class used for handling consumption of view {@link module:engine/view/element~Element elements},
 * {@link module:engine/view/text~Text text nodes} and {@link module:engine/view/documentfragment~DocumentFragment document fragments}.
 * Element's name and its parts (attributes, classes and styles) can be consumed separately. Consuming an element's name
 * does not consume its attributes, classes and styles.
 * To add items for consumption use {@link module:engine/conversion/viewconsumable~ViewConsumable#add add method}.
 * To test items use {@link module:engine/conversion/viewconsumable~ViewConsumable#test test method}.
 * To consume items use {@link module:engine/conversion/viewconsumable~ViewConsumable#consume consume method}.
 * To revert already consumed items use {@link module:engine/conversion/viewconsumable~ViewConsumable#revert revert method}.
 *
 *		viewConsumable.add( element, { name: true } ); // Adds element's name as ready to be consumed.
 *		viewConsumable.add( textNode ); // Adds text node for consumption.
 *		viewConsumable.add( docFragment ); // Adds document fragment for consumption.
 *		viewConsumable.test( element, { name: true }  ); // Tests if element's name can be consumed.
 *		viewConsumable.test( textNode ); // Tests if text node can be consumed.
 *		viewConsumable.test( docFragment ); // Tests if document fragment can be consumed.
 *		viewConsumable.consume( element, { name: true }  ); // Consume element's name.
 *		viewConsumable.consume( textNode ); // Consume text node.
 *		viewConsumable.consume( docFragment ); // Consume document fragment.
 *		viewConsumable.revert( element, { name: true }  ); // Revert already consumed element's name.
 *		viewConsumable.revert( textNode ); // Revert already consumed text node.
 *		viewConsumable.revert( docFragment ); // Revert already consumed document fragment.
 */
class ViewConsumable {
	/**
	 * Creates new ViewConsumable.
	 */
	constructor() {
		/**
		 * Map of consumable elements. If {@link module:engine/view/element~Element element} is used as a key,
		 * {@link module:engine/conversion/viewconsumable~ViewElementConsumables ViewElementConsumables} instance is stored as value.
		 * For {@link module:engine/view/text~Text text nodes} and
		 * {@link module:engine/view/documentfragment~DocumentFragment document fragments} boolean value is stored as value.
		 *
		 * @protected
		 * @member {Map.<module:engine/conversion/viewconsumable~ViewElementConsumables|Boolean>}
		*/
		this._consumables = new Map();
	}

	/**
	 * Adds {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} as ready to be consumed.
	 *
	 *		viewConsumable.add( p, { name: true } ); // Adds element's name to consume.
	 *		viewConsumable.add( p, { attributes: 'name' } ); // Adds element's attribute.
	 *		viewConsumable.add( p, { classes: 'foobar' } ); // Adds element's class.
	 *		viewConsumable.add( p, { styles: 'color' } ); // Adds element's style
	 *		viewConsumable.add( p, { attributes: 'name', styles: 'color' } ); // Adds attribute and style.
	 *		viewConsumable.add( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be provided.
	 *		viewConsumable.add( textNode ); // Adds text node to consume.
	 *		viewConsumable.add( docFragment ); // Adds document fragment to consume.
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * attribute is provided - it should be handled separately by providing actual style/class.
	 *
	 *		viewConsumable.add( p, { attributes: 'style' } ); // This call will throw an exception.
	 *		viewConsumable.add( p, { styles: 'color' } ); // This is properly handled style.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 */
	add( element, consumables ) {
		let elementConsumables;

		// For text nodes and document fragments just mark them as consumable.
		if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
			this._consumables.set( element, true );

			return;
		}

		// For elements create new ViewElementConsumables or update already existing one.
		if ( !this._consumables.has( element ) ) {
			elementConsumables = new ViewElementConsumables( element );
			this._consumables.set( element, elementConsumables );
		} else {
			elementConsumables = this._consumables.get( element );
		}

		elementConsumables.add( consumables );
	}

	/**
	 * Tests if {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} can be consumed.
	 * It returns `true` when all items included in method's call can be consumed. Returns `false` when
	 * first already consumed item is found and `null` when first non-consumable item is found.
	 *
	 *		viewConsumable.test( p, { name: true } ); // Tests element's name.
	 *		viewConsumable.test( p, { attributes: 'name' } ); // Tests attribute.
	 *		viewConsumable.test( p, { classes: 'foobar' } ); // Tests class.
	 *		viewConsumable.test( p, { styles: 'color' } ); // Tests style.
	 *		viewConsumable.test( p, { attributes: 'name', styles: 'color' } ); // Tests attribute and style.
	 *		viewConsumable.test( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be tested.
	 *		viewConsumable.test( textNode ); // Tests text node.
	 *		viewConsumable.test( docFragment ); // Tests document fragment.
	 *
	 * Testing classes and styles as attribute will test if all added classes/styles can be consumed.
	 *
	 *		viewConsumable.test( p, { attributes: 'class' } ); // Tests if all added classes can be consumed.
	 *		viewConsumable.test( p, { attributes: 'style' } ); // Tests if all added styles can be consumed.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 * @returns {Boolean|null} Returns `true` when all items included in method's call can be consumed. Returns `false`
	 * when first already consumed item is found and `null` when first non-consumable item is found.
	 */
	test( element, consumables ) {
		const elementConsumables = this._consumables.get( element );

		if ( elementConsumables === undefined ) {
			return null;
		}

		// For text nodes and document fragments return stored boolean value.
		if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
			return elementConsumables;
		}

		// For elements test consumables object.
		return elementConsumables.test( consumables );
	}

	/**
	 * Consumes {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment}.
	 * It returns `true` when all items included in method's call can be consumed, otherwise returns `false`.
	 *
	 *		viewConsumable.consume( p, { name: true } ); // Consumes element's name.
	 *		viewConsumable.consume( p, { attributes: 'name' } ); // Consumes element's attribute.
	 *		viewConsumable.consume( p, { classes: 'foobar' } ); // Consumes element's class.
	 *		viewConsumable.consume( p, { styles: 'color' } ); // Consumes element's style.
	 *		viewConsumable.consume( p, { attributes: 'name', styles: 'color' } ); // Consumes attribute and style.
	 *		viewConsumable.consume( p, { classes: [ 'baz', 'bar' ] } ); // Multiple consumables can be consumed.
	 *		viewConsumable.consume( textNode ); // Consumes text node.
	 *		viewConsumable.consume( docFragment ); // Consumes document fragment.
	 *
	 * Consuming classes and styles as attribute will test if all added classes/styles can be consumed.
	 *
	 *		viewConsumable.consume( p, { attributes: 'class' } ); // Consume only if all added classes can be consumed.
	 *		viewConsumable.consume( p, { attributes: 'style' } ); // Consume only if all added styles can be consumed.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 * @returns {Boolean} Returns `true` when all items included in method's call can be consumed,
	 * otherwise returns `false`.
	 */
	consume( element, consumables ) {
		if ( this.test( element, consumables ) ) {
			if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
				// For text nodes and document fragments set value to false.
				this._consumables.set( element, false );
			} else {
				// For elements - consume consumables object.
				this._consumables.get( element ).consume( consumables );
			}

			return true;
		}

		return false;
	}

	/**
	 * Reverts {@link module:engine/view/element~Element view element}, {@link module:engine/view/text~Text text node} or
	 * {@link module:engine/view/documentfragment~DocumentFragment document fragment} so they can be consumed once again.
	 * Method does not revert items that were never previously added for consumption, even if they are included in
	 * method's call.
	 *
	 *		viewConsumable.revert( p, { name: true } ); // Reverts element's name.
	 *		viewConsumable.revert( p, { attributes: 'name' } ); // Reverts element's attribute.
	 *		viewConsumable.revert( p, { classes: 'foobar' } ); // Reverts element's class.
	 *		viewConsumable.revert( p, { styles: 'color' } ); // Reverts element's style.
	 *		viewConsumable.revert( p, { attributes: 'name', styles: 'color' } ); // Reverts attribute and style.
	 *		viewConsumable.revert( p, { classes: [ 'baz', 'bar' ] } ); // Multiple names can be reverted.
	 *		viewConsumable.revert( textNode ); // Reverts text node.
	 *		viewConsumable.revert( docFragment ); // Reverts document fragment.
	 *
	 * Reverting classes and styles as attribute will revert all classes/styles that were previously added for
	 * consumption.
	 *
	 *		viewConsumable.revert( p, { attributes: 'class' } ); // Reverts all classes added for consumption.
	 *		viewConsumable.revert( p, { attributes: 'style' } ); // Reverts all styles added for consumption.
	 *
	 * @param {module:engine/view/element~Element|module:engine/view/text~Text|module:engine/view/documentfragment~DocumentFragment} element
	 * @param {Object} [consumables] Used only if first parameter is {@link module:engine/view/element~Element view element} instance.
	 * @param {Boolean} consumables.name If set to true element's name will be included.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names.
	 */
	revert( element, consumables ) {
		const elementConsumables = this._consumables.get( element );

		if ( elementConsumables !== undefined ) {
			if ( element.is( '$text' ) || element.is( 'documentFragment' ) ) {
				// For text nodes and document fragments - set consumable to true.
				this._consumables.set( element, true );
			} else {
				// For elements - revert items from consumables object.
				elementConsumables.revert( consumables );
			}
		}
	}

	/**
	 * Creates consumable object from {@link module:engine/view/element~Element view element}. Consumable object will include
	 * element's name and all its attributes, classes and styles.
	 *
	 * @static
	 * @param {module:engine/view/element~Element} element
	 * @returns {Object} consumables
	 */
	static consumablesFromElement( element ) {
		const consumables = {
			element,
			name: true,
			attributes: [],
			classes: [],
			styles: []
		};

		const attributes = element.getAttributeKeys();

		for ( const attribute of attributes ) {
			// Skip classes and styles - will be added separately.
			if ( attribute == 'style' || attribute == 'class' ) {
				continue;
			}

			consumables.attributes.push( attribute );
		}

		const classes = element.getClassNames();

		for ( const className of classes ) {
			consumables.classes.push( className );
		}

		const styles = element.getStyleNames();

		for ( const style of styles ) {
			consumables.styles.push( style );
		}

		return consumables;
	}

	/**
	 * Creates {@link module:engine/conversion/viewconsumable~ViewConsumable ViewConsumable} instance from
	 * {@link module:engine/view/node~Node node} or {@link module:engine/view/documentfragment~DocumentFragment document fragment}.
	 * Instance will contain all elements, child nodes, attributes, styles and classes added for consumption.
	 *
	 * @static
	 * @param {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment} from View node or document fragment
	 * from which `ViewConsumable` will be created.
	 * @param {module:engine/conversion/viewconsumable~ViewConsumable} [instance] If provided, given `ViewConsumable` instance will be used
	 * to add all consumables. It will be returned instead of a new instance.
	 */
	static createFrom( from, instance ) {
		if ( !instance ) {
			instance = new ViewConsumable( from );
		}

		if ( from.is( '$text' ) ) {
			instance.add( from );

			return instance;
		}

		// Add `from` itself, if it is an element.
		if ( from.is( 'element' ) ) {
			instance.add( from, ViewConsumable.consumablesFromElement( from ) );
		}

		if ( from.is( 'documentFragment' ) ) {
			instance.add( from );
		}

		for ( const child of from.getChildren() ) {
			instance = ViewConsumable.createFrom( child, instance );
		}

		return instance;
	}
}

/**
 * This is a private helper-class for {@link module:engine/conversion/viewconsumable~ViewConsumable}.
 * It represents and manipulates consumable parts of a single {@link module:engine/view/element~Element}.
 *
 * @private
 */
class ViewElementConsumables {
	/**
	 * Creates ViewElementConsumables instance.
	 *
	 * @param {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment} from View node or document fragment
	 * from which `ViewElementConsumables` is being created.
	 */
	constructor( from ) {
		/**
		 * @readonly
		 * @member {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment}
		 */
		this.element = from;

		/**
		 * Flag indicating if name of the element can be consumed.
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._canConsumeName = null;

		/**
		 * Contains maps of element's consumables: attributes, classes and styles.
		 *
		 * @private
		 * @member {Object}
		 */
		this._consumables = {
			attributes: new Map(),
			styles: new Map(),
			classes: new Map()
		};
	}

	/**
	 * Adds consumable parts of the {@link module:engine/view/element~Element view element}.
	 * Element's name itself can be marked to be consumed (when element's name is consumed its attributes, classes and
	 * styles still could be consumed):
	 *
	 *		consumables.add( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.add( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.add( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * attribute is provided - it should be handled separately by providing `style` and `class` in consumables object.
	 *
	 * @param {Object} consumables Object describing which parts of the element can be consumed.
	 * @param {Boolean} consumables.name If set to `true` element's name will be added as consumable.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to add as consumable.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to add as consumable.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to add as consumable.
	 */
	add( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = true;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._add( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Tests if parts of the {@link module:engine/view/node~Node view node} can be consumed.
	 *
	 * Element's name can be tested:
	 *
	 *		consumables.test( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.test( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.test( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be tested.
	 * @param {Boolean} consumables.name If set to `true` element's name will be tested.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to test.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to test.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to test.
	 * @returns {Boolean|null} `true` when all tested items can be consumed, `null` when even one of the items
	 * was never marked for consumption and `false` when even one of the items was already consumed.
	 */
	test( consumables ) {
		// Check if name can be consumed.
		if ( consumables.name && !this._canConsumeName ) {
			return this._canConsumeName;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				const value = this._test( type, consumables[ type ] );

				if ( value !== true ) {
					return value;
				}
			}
		}

		// Return true only if all can be consumed.
		return true;
	}

	/**
	 * Consumes parts of {@link module:engine/view/element~Element view element}. This function does not check if consumable item
	 * is already consumed - it consumes all consumable items provided.
	 * Element's name can be consumed:
	 *
	 *		consumables.consume( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.consume( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.consume( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be consumed.
	 * @param {Boolean} consumables.name If set to `true` element's name will be consumed.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to consume.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to consume.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to consume.
	 */
	consume( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = false;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._consume( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Revert already consumed parts of {@link module:engine/view/element~Element view Element}, so they can be consumed once again.
	 * Element's name can be reverted:
	 *
	 *		consumables.revert( { name: true } );
	 *
	 * Attributes classes and styles:
	 *
	 *		consumables.revert( { attributes: 'title', classes: 'foo', styles: 'color' } );
	 *		consumables.revert( { attributes: [ 'title', 'name' ], classes: [ 'foo', 'bar' ] );
	 *
	 * @param {Object} consumables Object describing which parts of the element should be reverted.
	 * @param {Boolean} consumables.name If set to `true` element's name will be reverted.
	 * @param {String|Array.<String>} consumables.attributes Attribute name or array of attribute names to revert.
	 * @param {String|Array.<String>} consumables.classes Class name or array of class names to revert.
	 * @param {String|Array.<String>} consumables.styles Style name or array of style names to revert.
	 */
	revert( consumables ) {
		if ( consumables.name ) {
			this._canConsumeName = true;
		}

		for ( const type in this._consumables ) {
			if ( type in consumables ) {
				this._revert( type, consumables[ type ] );
			}
		}
	}

	/**
	 * Helper method that adds consumables of a given type: attribute, class or style.
	 *
	 * Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError} `viewconsumable-invalid-attribute` when `class` or `style`
	 * type is provided - it should be handled separately by providing actual style/class type.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_add( type, item ) {
		const items = Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isArray"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				/**
				 * Class and style attributes should be handled separately in
				 * {@link module:engine/conversion/viewconsumable~ViewConsumable#add `ViewConsumable#add()`}.
				 *
				 * What you have done is trying to use:
				 *
				 *		consumables.add( { attributes: [ 'class', 'style' ] } );
				 *
				 * While each class and style should be registered separately:
				 *
				 *		consumables.add( { classes: 'some-class', styles: 'font-weight' } );
				 *
				 * @error viewconsumable-invalid-attribute
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'viewconsumable-invalid-attribute: Classes and styles should be handled separately.', this );
			}

			consumables.set( name, true );

			if ( type === 'styles' ) {
				for ( const alsoName of this.element.document.stylesProcessor.getRelatedStyles( name ) ) {
					consumables.set( alsoName, true );
				}
			}
		}
	}

	/**
	 * Helper method that tests consumables of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 * @returns {Boolean|null} Returns `true` if all items can be consumed, `null` when one of the items cannot be
	 * consumed and `false` when one of the items is already consumed.
	 */
	_test( type, item ) {
		const items = Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isArray"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// Check all classes/styles if class/style attribute is tested.
				const value = this._test( consumableName, [ ...this._consumables[ consumableName ].keys() ] );

				if ( value !== true ) {
					return value;
				}
			} else {
				const value = consumables.get( name );
				// Return null if attribute is not found.
				if ( value === undefined ) {
					return null;
				}

				if ( !value ) {
					return false;
				}
			}
		}

		return true;
	}

	/**
	 * Helper method that consumes items of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_consume( type, item ) {
		const items = Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isArray"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// If class or style is provided for consumption - consume them all.
				this._consume( consumableName, [ ...this._consumables[ consumableName ].keys() ] );
			} else {
				consumables.set( name, false );

				if ( type == 'styles' ) {
					for ( const toConsume of this.element.document.stylesProcessor.getRelatedStyles( name ) ) {
						consumables.set( toConsume, false );
					}
				}
			}
		}
	}

	/**
	 * Helper method that reverts items of a given type: attribute, class or style.
	 *
	 * @private
	 * @param {String} type Type of the consumable item: `attributes`, `classes` or , `styles`.
	 * @param {String|Array.<String>} item Consumable item or array of items.
	 */
	_revert( type, item ) {
		const items = Object(lodash_es__WEBPACK_IMPORTED_MODULE_0__["isArray"])( item ) ? item : [ item ];
		const consumables = this._consumables[ type ];

		for ( const name of items ) {
			if ( type === 'attributes' && ( name === 'class' || name === 'style' ) ) {
				const consumableName = name == 'class' ? 'classes' : 'styles';

				// If class or style is provided for reverting - revert them all.
				this._revert( consumableName, [ ...this._consumables[ consumableName ].keys() ] );
			} else {
				const value = consumables.get( name );

				if ( value === false ) {
					consumables.set( name, true );
				}
			}
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return BasicHtmlWriter; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/dataprocessor/basichtmlwriter
 */

/* globals document */

/**
 * Basic HTML writer. It uses the native `innerHTML` property for basic conversion
 * from a document fragment to an HTML string.
 *
 * @implements module:engine/dataprocessor/htmlwriter~HtmlWriter
 */
class BasicHtmlWriter {
	/**
	 * Returns an HTML string created from the document fragment.
	 *
	 * @param {DocumentFragment} fragment
	 * @returns {String}
	 */
	getHtml( fragment ) {
		const doc = document.implementation.createHTMLDocument( '' );
		const container = doc.createElement( 'div' );
		container.appendChild( fragment );

		return container.innerHTML;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/htmldataprocessor.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return HtmlDataProcessor; });
/* harmony import */ var _basichtmlwriter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./basichtmlwriter */ "./node_modules/@ckeditor/ckeditor5-engine/src/dataprocessor/basichtmlwriter.js");
/* harmony import */ var _view_domconverter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../view/domconverter */ "./node_modules/@ckeditor/ckeditor5-engine/src/view/domconverter.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/dataprocessor/htmldataprocessor
 */

/* globals document, DOMParser */




/**
 * The HTML data processor class.
 * This data processor implementation uses HTML as input and output data.
 *
 * @implements module:engine/dataprocessor/dataprocessor~DataProcessor
 */
class HtmlDataProcessor {
	/**
	 * Creates a new instance of the HTML data processor class.
	 *
	 * @param {module:engine/view/document~Document} document The view document instance.
	 */
	constructor( document ) {
		/**
		 * A DOM parser instance used to parse an HTML string to an HTML document.
		 *
		 * @private
		 * @member {DOMParser}
		 */
		this._domParser = new DOMParser();

		/**
		 * A DOM converter used to convert DOM elements to view elements.
		 *
		 * @private
		 * @member {module:engine/view/domconverter~DomConverter}
		 */
		this._domConverter = new _view_domconverter__WEBPACK_IMPORTED_MODULE_1__["default"]( document, { blockFillerMode: 'nbsp' } );

		/**
		 * A basic HTML writer instance used to convert DOM elements to an HTML string.
		 *
		 * @private
		 * @member {module:engine/dataprocessor/basichtmlwriter~BasicHtmlWriter}
		 */
		this._htmlWriter = new _basichtmlwriter__WEBPACK_IMPORTED_MODULE_0__["default"]();
	}

	/**
	 * Converts a provided {@link module:engine/view/documentfragment~DocumentFragment document fragment}
	 * to data format &mdash; in this case to an HTML string.
	 *
	 * @param {module:engine/view/documentfragment~DocumentFragment} viewFragment
	 * @returns {String} HTML string.
	 */
	toData( viewFragment ) {
		// Convert view DocumentFragment to DOM DocumentFragment.
		const domFragment = this._domConverter.viewToDom( viewFragment, document );

		// Convert DOM DocumentFragment to HTML output.
		return this._htmlWriter.getHtml( domFragment );
	}

	/**
	 * Converts the provided HTML string to a view tree.
	 *
	 * @param {String} data An HTML string.
	 * @returns {module:engine/view/node~Node|module:engine/view/documentfragment~DocumentFragment|null} A converted view element.
	 */
	toView( data ) {
		// Convert input HTML data to DOM DocumentFragment.
		const domFragment = this._toDom( data );

		// Convert DOM DocumentFragment to view DocumentFragment.
		return this._domConverter.domToView( domFragment );
	}

	/**
	 * Converts an HTML string to its DOM representation. Returns a document fragment containing nodes parsed from
	 * the provided data.
	 *
	 * @private
	 * @param {String} data
	 * @returns {DocumentFragment}
	 */
	_toDom( data ) {
		const document = this._domParser.parseFromString( data, 'text/html' );
		const fragment = document.createDocumentFragment();
		const nodes = document.body.childNodes;

		while ( nodes.length > 0 ) {
			fragment.appendChild( nodes[ 0 ] );
		}

		return fragment;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Batch; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/batch
 */

/**
 * A batch instance groups model changes ({@link module:engine/model/operation/operation~Operation operations}). All operations
 * grouped in a single batch can be reverted together, so you can also think about a batch as of a single undo step. If you want
 * to extend a given undo step, you can add more changes to the batch using {@link module:engine/model/model~Model#enqueueChange}:
 *
 *		model.enqueueChange( batch, writer => {
 *			writer.insertText( 'foo', paragraph, 'end' );
 *		} );
 *
 * @see module:engine/model/model~Model#enqueueChange
 * @see module:engine/model/model~Model#change
 */
class Batch {
	/**
	 * Creates a batch instance.
	 *
	 * @see module:engine/model/model~Model#enqueueChange
	 * @see module:engine/model/model~Model#change
	 * @param {'transparent'|'default'} [type='default'] The type of the batch.
	 */
	constructor( type = 'default' ) {
		/**
		 * An array of operations that compose this batch.
		 *
		 * @readonly
		 * @type {Array.<module:engine/model/operation/operation~Operation>}
		 */
		this.operations = [];

		/**
		 * The type of the batch.
		 *
		 * It can be one of the following values:
		 * * `'default'` &ndash; All "normal" batches. This is the most commonly used type.
		 * * `'transparent'` &ndash; A batch that should be ignored by other features, i.e. an initial batch or collaborative editing
		 * changes.
		 *
		 * @readonly
		 * @type {'transparent'|'default'}
		 */
		this.type = type;
	}

	/**
	 * Returns the base version of this batch, which is equal to the base version of the first operation in the batch.
	 * If there are no operations in the batch or neither operation has the base version set, it returns `null`.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get baseVersion() {
		for ( const op of this.operations ) {
			if ( op.baseVersion !== null ) {
				return op.baseVersion;
			}
		}

		return null;
	}

	/**
	 * Adds an operation to the batch instance.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation An operation to add.
	 * @returns {module:engine/model/operation/operation~Operation} The added operation.
	 */
	addOperation( operation ) {
		operation.batch = this;
		this.operations.push( operation );

		return operation;
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Differ; });
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/differ
 */




/**
 * Calculates the difference between two model states.
 *
 * Receives operations that are to be applied on the model document. Marks parts of the model document tree which
 * are changed and saves the state of these elements before the change. Then, it compares saved elements with the
 * changed elements, after all changes are applied on the model document. Calculates the diff between saved
 * elements and new ones and returns a change set.
 */
class Differ {
	/**
	 * Creates a `Differ` instance.
	 *
	 * @param {module:engine/model/markercollection~MarkerCollection} markerCollection Model's marker collection.
	 */
	constructor( markerCollection ) {
		/**
		 * Reference to the model's marker collection.
		 *
		 * @private
		 * @type {module:engine/model/markercollection~MarkerCollection}
		 */
		this._markerCollection = markerCollection;

		/**
		 * A map that stores changes that happened in a given element.
		 *
		 * The keys of the map are references to the model elements.
		 * The values of the map are arrays with changes that were done on this element.
		 *
		 * @private
		 * @type {Map}
		 */
		this._changesInElement = new Map();

		/**
		 * A map that stores "element's children snapshots". A snapshot is representing children of a given element before
		 * the first change was applied on that element. Snapshot items are objects with two properties: `name`,
		 * containing the element name (or `'$text'` for a text node) and `attributes` which is a map of the node's attributes.
		 *
		 * @private
		 * @type {Map}
		 */
		this._elementSnapshots = new Map();

		/**
		 * A map that stores all changed markers.
		 *
		 * The keys of the map are marker names.
		 * The values of the map are objects with the `oldRange` and `newRange` properties. They store the marker range
		 * state before and after the change.
		 *
		 * @private
		 * @type {Map}
		 */
		this._changedMarkers = new Map();

		/**
		 * Stores the number of changes that were processed. Used to order the changes chronologically. It is important
		 * when changes are sorted.
		 *
		 * @private
		 * @type {Number}
		 */
		this._changeCount = 0;

		/**
		 * For efficiency purposes, `Differ` stores the change set returned by the differ after {@link #getChanges} call.
		 * Cache is reset each time a new operation is buffered. If the cache has not been reset, {@link #getChanges} will
		 * return the cached value instead of calculating it again.
		 *
		 * This property stores those changes that did not take place in graveyard root.
		 *
		 * @private
		 * @type {Array.<Object>|null}
		 */
		this._cachedChanges = null;

		/**
		 * For efficiency purposes, `Differ` stores the change set returned by the differ after the {@link #getChanges} call.
		 * The cache is reset each time a new operation is buffered. If the cache has not been reset, {@link #getChanges} will
		 * return the cached value instead of calculating it again.
		 *
		 * This property stores all changes evaluated by `Differ`, including those that took place in the graveyard.
		 *
		 * @private
		 * @type {Array.<Object>|null}
		 */
		this._cachedChangesWithGraveyard = null;
	}

	/**
	 * Informs whether there are any changes buffered in `Differ`.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this._changesInElement.size == 0 && this._changedMarkers.size == 0;
	}

	/**
	 * Marks given `item` in differ to be "refreshed". It means that the item will be marked as removed and inserted in the differ changes
	 * set, so it will be effectively re-converted when differ changes will be handled by a dispatcher.
	 *
	 * @param {module:engine/model/item~Item} item Item to refresh.
	 */
	refreshItem( item ) {
		if ( this._isInInsertedElement( item.parent ) ) {
			return;
		}

		this._markRemove( item.parent, item.startOffset, item.offsetSize );
		this._markInsert( item.parent, item.startOffset, item.offsetSize );

		const range = _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createOn( item );

		for ( const marker of this._markerCollection.getMarkersIntersectingRange( range ) ) {
			const markerRange = marker.getRange();

			this.bufferMarkerChange( marker.name, markerRange, markerRange, marker.affectsData );
		}

		// Clear cache after each buffered operation as it is no longer valid.
		this._cachedChanges = null;
	}

	/**
	 * Buffers the given operation. An operation has to be buffered before it is executed.
	 *
	 * Operation type is checked and it is checked which nodes it will affect. These nodes are then stored in `Differ`
	 * in the state before the operation is executed.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation An operation to buffer.
	 */
	bufferOperation( operation ) {
		// Below we take an operation, check its type, then use its parameters in marking (private) methods.
		// The general rule is to not mark elements inside inserted element. All inserted elements are re-rendered.
		// Marking changes in them would cause a "double" changing then.
		//
		switch ( operation.type ) {
			case 'insert': {
				if ( this._isInInsertedElement( operation.position.parent ) ) {
					return;
				}

				this._markInsert( operation.position.parent, operation.position.offset, operation.nodes.maxOffset );

				break;
			}
			case 'addAttribute':
			case 'removeAttribute':
			case 'changeAttribute': {
				for ( const item of operation.range.getItems( { shallow: true } ) ) {
					if ( this._isInInsertedElement( item.parent ) ) {
						continue;
					}

					this._markAttribute( item );
				}

				break;
			}
			case 'remove':
			case 'move':
			case 'reinsert': {
				// When range is moved to the same position then not mark it as a change.
				// See: https://github.com/ckeditor/ckeditor5-engine/issues/1664.
				if (
					operation.sourcePosition.isEqual( operation.targetPosition ) ||
					operation.sourcePosition.getShiftedBy( operation.howMany ).isEqual( operation.targetPosition )
				) {
					return;
				}

				const sourceParentInserted = this._isInInsertedElement( operation.sourcePosition.parent );
				const targetParentInserted = this._isInInsertedElement( operation.targetPosition.parent );

				if ( !sourceParentInserted ) {
					this._markRemove( operation.sourcePosition.parent, operation.sourcePosition.offset, operation.howMany );
				}

				if ( !targetParentInserted ) {
					this._markInsert( operation.targetPosition.parent, operation.getMovedRangeStart().offset, operation.howMany );
				}

				break;
			}
			case 'rename': {
				if ( this._isInInsertedElement( operation.position.parent ) ) {
					return;
				}

				this._markRemove( operation.position.parent, operation.position.offset, 1 );
				this._markInsert( operation.position.parent, operation.position.offset, 1 );

				const range = _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( operation.position, 1 );

				for ( const marker of this._markerCollection.getMarkersIntersectingRange( range ) ) {
					const markerRange = marker.getRange();

					this.bufferMarkerChange( marker.name, markerRange, markerRange, marker.affectsData );
				}

				break;
			}
			case 'split': {
				const splitElement = operation.splitPosition.parent;

				// Mark that children of the split element were removed.
				if ( !this._isInInsertedElement( splitElement ) ) {
					this._markRemove( splitElement, operation.splitPosition.offset, operation.howMany );
				}

				// Mark that the new element (split copy) was inserted.
				if ( !this._isInInsertedElement( operation.insertionPosition.parent ) ) {
					this._markInsert( operation.insertionPosition.parent, operation.insertionPosition.offset, 1 );
				}

				// If the split took the element from the graveyard, mark that the element from the graveyard was removed.
				if ( operation.graveyardPosition ) {
					this._markRemove( operation.graveyardPosition.parent, operation.graveyardPosition.offset, 1 );
				}

				break;
			}
			case 'merge': {
				// Mark that the merged element was removed.
				const mergedElement = operation.sourcePosition.parent;

				if ( !this._isInInsertedElement( mergedElement.parent ) ) {
					this._markRemove( mergedElement.parent, mergedElement.startOffset, 1 );
				}

				// Mark that the merged element was inserted into graveyard.
				const graveyardParent = operation.graveyardPosition.parent;

				this._markInsert( graveyardParent, operation.graveyardPosition.offset, 1 );

				// Mark that children of merged element were inserted at new parent.
				const mergedIntoElement = operation.targetPosition.parent;

				if ( !this._isInInsertedElement( mergedIntoElement ) ) {
					this._markInsert( mergedIntoElement, operation.targetPosition.offset, mergedElement.maxOffset );
				}

				break;
			}
		}

		// Clear cache after each buffered operation as it is no longer valid.
		this._cachedChanges = null;
	}

	/**
	 * Buffers a marker change.
	 *
	 * @param {String} markerName The name of the marker that changed.
	 * @param {module:engine/model/range~Range|null} oldRange Marker range before the change or `null` if the marker has just
	 * been created.
	 * @param {module:engine/model/range~Range|null} newRange Marker range after the change or `null` if the marker was removed.
	 * @param {Boolean} affectsData Flag indicating whether marker affects the editor data.
	 */
	bufferMarkerChange( markerName, oldRange, newRange, affectsData ) {
		const buffered = this._changedMarkers.get( markerName );

		if ( !buffered ) {
			this._changedMarkers.set( markerName, {
				oldRange,
				newRange,
				affectsData
			} );
		} else {
			buffered.newRange = newRange;
			buffered.affectsData = affectsData;

			if ( buffered.oldRange == null && buffered.newRange == null ) {
				// The marker is going to be removed (`newRange == null`) but it did not exist before the first buffered change
				// (`buffered.oldRange == null`). In this case, do not keep the marker in buffer at all.
				this._changedMarkers.delete( markerName );
			}
		}
	}

	/**
	 * Returns all markers that should be removed as a result of buffered changes.
	 *
	 * @returns {Array.<Object>} Markers to remove. Each array item is an object containing the `name` and `range` properties.
	 */
	getMarkersToRemove() {
		const result = [];

		for ( const [ name, change ] of this._changedMarkers ) {
			if ( change.oldRange != null ) {
				result.push( { name, range: change.oldRange } );
			}
		}

		return result;
	}

	/**
	 * Returns all markers which should be added as a result of buffered changes.
	 *
	 * @returns {Array.<Object>} Markers to add. Each array item is an object containing the `name` and `range` properties.
	 */
	getMarkersToAdd() {
		const result = [];

		for ( const [ name, change ] of this._changedMarkers ) {
			if ( change.newRange != null ) {
				result.push( { name, range: change.newRange } );
			}
		}

		return result;
	}

	/**
	 * Returns all markers which changed.
	 *
	 * @returns {Array.<Object>}
	 */
	getChangedMarkers() {
		return Array.from( this._changedMarkers ).map( item => (
			{
				name: item[ 0 ],
				data: {
					oldRange: item[ 1 ].oldRange,
					newRange: item[ 1 ].newRange
				}
			}
		) );
	}

	/**
	 * Checks whether some of the buffered changes affect the editor data.
	 *
	 * Types of changes which affect the editor data:
	 *
	 * * model structure changes,
	 * * attribute changes,
	 * * changes of markers which were defined as `affectingData`.
	 *
	 * @returns {Boolean}
	 */
	hasDataChanges() {
		for ( const [ , change ] of this._changedMarkers ) {
			if ( change.affectsData ) {
				return true;
			}
		}

		// If markers do not affect the data, check whether there are some changes in elements.
		return this._changesInElement.size > 0;
	}

	/**
	 * Calculates the diff between the old model tree state (the state before the first buffered operations since the last {@link #reset}
	 * call) and the new model tree state (actual one). It should be called after all buffered operations are executed.
	 *
	 * The diff set is returned as an array of diff items, each describing a change done on the model. The items are sorted by
	 * the position on which the change happened. If a position {@link module:engine/model/position~Position#isBefore is before}
	 * another one, it will be on an earlier index in the diff set.
	 *
	 * Because calculating the diff is a costly operation, the result is cached. If no new operation was buffered since the
	 * previous {@link #getChanges} call, the next call will return the cached value.
	 *
	 * @param {Object} options Additional options.
	 * @param {Boolean} [options.includeChangesInGraveyard=false] If set to `true`, also changes that happened
	 * in the graveyard root will be returned. By default, changes in the graveyard root are not returned.
	 * @returns {Array.<Object>} Diff between the old and the new model tree state.
	 */
	getChanges( options = { includeChangesInGraveyard: false } ) {
		// If there are cached changes, just return them instead of calculating changes again.
		if ( this._cachedChanges ) {
			if ( options.includeChangesInGraveyard ) {
				return this._cachedChangesWithGraveyard.slice();
			} else {
				return this._cachedChanges.slice();
			}
		}

		// Will contain returned results.
		const diffSet = [];

		// Check all changed elements.
		for ( const element of this._changesInElement.keys() ) {
			// Get changes for this element and sort them.
			const changes = this._changesInElement.get( element ).sort( ( a, b ) => {
				if ( a.offset === b.offset ) {
					if ( a.type != b.type ) {
						// If there are multiple changes at the same position, "remove" change should be first.
						// If the order is different, for example, we would first add some nodes and then removed them
						// (instead of the nodes that we should remove).
						return a.type == 'remove' ? -1 : 1;
					}

					return 0;
				}

				return a.offset < b.offset ? -1 : 1;
			} );

			// Get children of this element before any change was applied on it.
			const snapshotChildren = this._elementSnapshots.get( element );
			// Get snapshot of current element's children.
			const elementChildren = _getChildrenSnapshot( element.getChildren() );

			// Generate actions basing on changes done on element.
			const actions = _generateActionsFromChanges( snapshotChildren.length, changes );

			let i = 0; // Iterator in `elementChildren` array -- iterates through current children of element.
			let j = 0; // Iterator in `snapshotChildren` array -- iterates through old children of element.

			// Process every action.
			for ( const action of actions ) {
				if ( action === 'i' ) {
					// Generate diff item for this element and insert it into the diff set.
					diffSet.push( this._getInsertDiff( element, i, elementChildren[ i ].name ) );

					i++;
				} else if ( action === 'r' ) {
					// Generate diff item for this element and insert it into the diff set.
					diffSet.push( this._getRemoveDiff( element, i, snapshotChildren[ j ].name ) );

					j++;
				} else if ( action === 'a' ) {
					// Take attributes from saved and current children.
					const elementAttributes = elementChildren[ i ].attributes;
					const snapshotAttributes = snapshotChildren[ j ].attributes;
					let range;

					if ( elementChildren[ i ].name == '$text' ) {
						range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i + 1 ) );
					} else {
						const index = element.offsetToIndex( i );
						range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element, i ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( element.getChild( index ), 0 ) );
					}

					// Generate diff items for this change (there might be multiple attributes changed and
					// there is a single diff for each of them) and insert them into the diff set.
					diffSet.push( ...this._getAttributesDiff( range, snapshotAttributes, elementAttributes ) );

					i++;
					j++;
				} else {
					// `action` is 'equal'. Child not changed.
					i++;
					j++;
				}
			}
		}

		// Then, sort the changes by the position (change at position before other changes is first).
		diffSet.sort( ( a, b ) => {
			// If the change is in different root, we don't care much, but we'd like to have all changes in given
			// root "together" in the array. So let's just sort them by the root name. It does not matter which root
			// will be processed first.
			if ( a.position.root != b.position.root ) {
				return a.position.root.rootName < b.position.root.rootName ? -1 : 1;
			}

			// If change happens at the same position...
			if ( a.position.isEqual( b.position ) ) {
				// Keep chronological order of operations.
				return a.changeCount - b.changeCount;
			}

			// If positions differ, position "on the left" should be earlier in the result.
			return a.position.isBefore( b.position ) ? -1 : 1;
		} );

		// Glue together multiple changes (mostly on text nodes).
		for ( let i = 1; i < diffSet.length; i++ ) {
			const prevDiff = diffSet[ i - 1 ];
			const thisDiff = diffSet[ i ];

			// Glue remove changes if they happen on text on same position.
			const isConsecutiveTextRemove =
				prevDiff.type == 'remove' && thisDiff.type == 'remove' &&
				prevDiff.name == '$text' && thisDiff.name == '$text' &&
				prevDiff.position.isEqual( thisDiff.position );

			// Glue insert changes if they happen on text on consecutive fragments.
			const isConsecutiveTextAdd =
				prevDiff.type == 'insert' && thisDiff.type == 'insert' &&
				prevDiff.name == '$text' && thisDiff.name == '$text' &&
				prevDiff.position.parent == thisDiff.position.parent &&
				prevDiff.position.offset + prevDiff.length == thisDiff.position.offset;

			// Glue attribute changes if they happen on consecutive fragments and have same key, old value and new value.
			const isConsecutiveAttributeChange =
				prevDiff.type == 'attribute' && thisDiff.type == 'attribute' &&
				prevDiff.position.parent == thisDiff.position.parent &&
				prevDiff.range.isFlat && thisDiff.range.isFlat &&
				prevDiff.position.offset + prevDiff.length == thisDiff.position.offset &&
				prevDiff.attributeKey == thisDiff.attributeKey &&
				prevDiff.attributeOldValue == thisDiff.attributeOldValue &&
				prevDiff.attributeNewValue == thisDiff.attributeNewValue;

			if ( isConsecutiveTextRemove || isConsecutiveTextAdd || isConsecutiveAttributeChange ) {
				diffSet[ i - 1 ].length++;

				if ( isConsecutiveAttributeChange ) {
					diffSet[ i - 1 ].range.end = diffSet[ i - 1 ].range.end.getShiftedBy( 1 );
				}

				diffSet.splice( i, 1 );
				i--;
			}
		}

		// Remove `changeCount` property from diff items. It is used only for sorting and is internal thing.
		for ( const item of diffSet ) {
			delete item.changeCount;

			if ( item.type == 'attribute' ) {
				delete item.position;
				delete item.length;
			}
		}

		this._changeCount = 0;

		// Cache changes.
		this._cachedChangesWithGraveyard = diffSet.slice();
		this._cachedChanges = diffSet.slice().filter( _changesInGraveyardFilter );

		if ( options.includeChangesInGraveyard ) {
			return this._cachedChangesWithGraveyard;
		} else {
			return this._cachedChanges;
		}
	}

	/**
	 * Resets `Differ`. Removes all buffered changes.
	 */
	reset() {
		this._changesInElement.clear();
		this._elementSnapshots.clear();
		this._changedMarkers.clear();
		this._cachedChanges = null;
	}

	/**
	 * Saves and handles an insert change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_markInsert( parent, offset, howMany ) {
		const changeItem = { type: 'insert', offset, howMany, count: this._changeCount++ };

		this._markChange( parent, changeItem );
	}

	/**
	 * Saves and handles a remove change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_markRemove( parent, offset, howMany ) {
		const changeItem = { type: 'remove', offset, howMany, count: this._changeCount++ };

		this._markChange( parent, changeItem );

		this._removeAllNestedChanges( parent, offset, howMany );
	}

	/**
	 * Saves and handles an attribute change.
	 *
	 * @private
	 * @param {module:engine/model/item~Item} item
	 */
	_markAttribute( item ) {
		const changeItem = { type: 'attribute', offset: item.startOffset, howMany: item.offsetSize, count: this._changeCount++ };

		this._markChange( item.parent, changeItem );
	}

	/**
	 * Saves and handles a model change.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Object} changeItem
	 */
	_markChange( parent, changeItem ) {
		// First, make a snapshot of this parent's children (it will be made only if it was not made before).
		this._makeSnapshot( parent );

		// Then, get all changes that already were done on the element (empty array if this is the first change).
		const changes = this._getChangesForElement( parent );

		// Then, look through all the changes, and transform them or the new change.
		this._handleChange( changeItem, changes );

		// Add the new change.
		changes.push( changeItem );

		// Remove incorrect changes. During transformation some change might be, for example, included in another.
		// In that case, the change will have `howMany` property set to `0` or less. We need to remove those changes.
		for ( let i = 0; i < changes.length; i++ ) {
			if ( changes[ i ].howMany < 1 ) {
				changes.splice( i, 1 );

				i--;
			}
		}
	}

	/**
	 * Gets an array of changes that have already been saved for a given element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element
	 * @returns {Array.<Object>}
	 */
	_getChangesForElement( element ) {
		let changes;

		if ( this._changesInElement.has( element ) ) {
			changes = this._changesInElement.get( element );
		} else {
			changes = [];

			this._changesInElement.set( element, changes );
		}

		return changes;
	}

	/**
	 * Saves a children snapshot for a given element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element
	 */
	_makeSnapshot( element ) {
		if ( !this._elementSnapshots.has( element ) ) {
			this._elementSnapshots.set( element, _getChildrenSnapshot( element.getChildren() ) );
		}
	}

	/**
	 * For a given newly saved change, compares it with a change already done on the element and modifies the incoming
	 * change and/or the old change.
	 *
	 * @private
	 * @param {Object} inc Incoming (new) change.
	 * @param {Array.<Object>} changes An array containing all the changes done on that element.
	 */
	_handleChange( inc, changes ) {
		// We need a helper variable that will store how many nodes are to be still handled for this change item.
		// `nodesToHandle` (how many nodes still need to be handled) and `howMany` (how many nodes were affected)
		// needs to be differentiated.
		//
		// This comes up when there are multiple changes that are affected by `inc` change item.
		//
		// For example: assume two insert changes: `{ offset: 2, howMany: 1 }` and `{ offset: 5, howMany: 1 }`.
		// Assume that `inc` change is remove `{ offset: 2, howMany: 2, nodesToHandle: 2 }`.
		//
		// Then, we:
		// - "forget" about first insert change (it is "eaten" by remove),
		// - because of that, at the end we will want to remove only one node (`nodesToHandle = 1`),
		// - but still we have to change offset of the second insert change from `5` to `3`!
		//
		// So, `howMany` does not change throughout items transformation and keeps information about how many nodes were affected,
		// while `nodesToHandle` means how many nodes need to be handled after the change item is transformed by other changes.
		inc.nodesToHandle = inc.howMany;

		for ( const old of changes ) {
			const incEnd = inc.offset + inc.howMany;
			const oldEnd = old.offset + old.howMany;

			if ( inc.type == 'insert' ) {
				if ( old.type == 'insert' ) {
					if ( inc.offset <= old.offset ) {
						old.offset += inc.howMany;
					} else if ( inc.offset < oldEnd ) {
						old.howMany += inc.nodesToHandle;
						inc.nodesToHandle = 0;
					}
				}

				if ( old.type == 'remove' ) {
					if ( inc.offset < old.offset ) {
						old.offset += inc.howMany;
					}
				}

				if ( old.type == 'attribute' ) {
					if ( inc.offset <= old.offset ) {
						old.offset += inc.howMany;
					} else if ( inc.offset < oldEnd ) {
						// This case is more complicated, because attribute change has to be split into two.
						// Example (assume that uppercase and lowercase letters mean different attributes):
						//
						// initial state:		abcxyz
						// attribute change:	aBCXYz
						// incoming insert:		aBCfooXYz
						//
						// Change ranges cannot intersect because each item has to be described exactly (it was either
						// not changed, inserted, removed, or its attribute was changed). That's why old attribute
						// change has to be split and both parts has to be handled separately from now on.
						const howMany = old.howMany;

						old.howMany = inc.offset - old.offset;

						// Add the second part of attribute change to the beginning of processed array so it won't
						// be processed again in this loop.
						changes.unshift( {
							type: 'attribute',
							offset: incEnd,
							howMany: howMany - old.howMany,
							count: this._changeCount++
						} );
					}
				}
			}

			if ( inc.type == 'remove' ) {
				if ( old.type == 'insert' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( incEnd <= oldEnd ) {
						if ( inc.offset < old.offset ) {
							const intersectionLength = incEnd - old.offset;

							old.offset = inc.offset;

							old.howMany -= intersectionLength;
							inc.nodesToHandle -= intersectionLength;
						} else {
							old.howMany -= inc.nodesToHandle;
							inc.nodesToHandle = 0;
						}
					} else {
						if ( inc.offset <= old.offset ) {
							inc.nodesToHandle -= old.howMany;
							old.howMany = 0;
						} else if ( inc.offset < oldEnd ) {
							const intersectionLength = oldEnd - inc.offset;

							old.howMany -= intersectionLength;
							inc.nodesToHandle -= intersectionLength;
						}
					}
				}

				if ( old.type == 'remove' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( inc.offset < old.offset ) {
						inc.nodesToHandle += old.howMany;
						old.howMany = 0;
					}
				}

				if ( old.type == 'attribute' ) {
					if ( incEnd <= old.offset ) {
						old.offset -= inc.howMany;
					} else if ( inc.offset < old.offset ) {
						const intersectionLength = incEnd - old.offset;

						old.offset = inc.offset;
						old.howMany -= intersectionLength;
					} else if ( inc.offset < oldEnd ) {
						if ( incEnd <= oldEnd ) {
							// On first sight in this case we don't need to split attribute operation into two.
							// However the changes set is later converted to actions (see `_generateActionsFromChanges`).
							// For that reason, no two changes may intersect.
							// So we cannot have an attribute change that "contains" remove change.
							// Attribute change needs to be split.
							const howMany = old.howMany;

							old.howMany = inc.offset - old.offset;

							const howManyAfter = howMany - old.howMany - inc.nodesToHandle;

							// Add the second part of attribute change to the beginning of processed array so it won't
							// be processed again in this loop.
							changes.unshift( {
								type: 'attribute',
								offset: inc.offset,
								howMany: howManyAfter,
								count: this._changeCount++
							} );
						} else {
							old.howMany -= oldEnd - inc.offset;
						}
					}
				}
			}

			if ( inc.type == 'attribute' ) {
				// In case of attribute change, `howMany` should be kept same as `nodesToHandle`. It's not an error.
				if ( old.type == 'insert' ) {
					if ( inc.offset < old.offset && incEnd > old.offset ) {
						if ( incEnd > oldEnd ) {
							// This case is similar to a case described when incoming change was insert and old change was attribute.
							// See comment above.
							//
							// This time incoming change is attribute. We need to split incoming change in this case too.
							// However this time, the second part of the attribute change needs to be processed further
							// because there might be other changes that it collides with.
							const attributePart = {
								type: 'attribute',
								offset: oldEnd,
								howMany: incEnd - oldEnd,
								count: this._changeCount++
							};

							this._handleChange( attributePart, changes );

							changes.push( attributePart );
						}

						inc.nodesToHandle = old.offset - inc.offset;
						inc.howMany = inc.nodesToHandle;
					} else if ( inc.offset >= old.offset && inc.offset < oldEnd ) {
						if ( incEnd > oldEnd ) {
							inc.nodesToHandle = incEnd - oldEnd;
							inc.offset = oldEnd;
						} else {
							inc.nodesToHandle = 0;
						}
					}
				}

				if ( old.type == 'remove' ) {
					// This is a case when attribute change "contains" remove change.
					// The attribute change needs to be split into two because changes cannot intersect.
					if ( inc.offset < old.offset && incEnd > old.offset ) {
						const attributePart = {
							type: 'attribute',
							offset: old.offset,
							howMany: incEnd - old.offset,
							count: this._changeCount++
						};

						this._handleChange( attributePart, changes );

						changes.push( attributePart );

						inc.nodesToHandle = old.offset - inc.offset;
						inc.howMany = inc.nodesToHandle;
					}
				}

				if ( old.type == 'attribute' ) {
					// There are only two conflicting scenarios possible here:
					if ( inc.offset >= old.offset && incEnd <= oldEnd ) {
						// `old` change includes `inc` change, or they are the same.
						inc.nodesToHandle = 0;
						inc.howMany = 0;
						inc.offset = 0;
					} else if ( inc.offset <= old.offset && incEnd >= oldEnd ) {
						// `inc` change includes `old` change.
						old.howMany = 0;
					}
				}
			}
		}

		inc.howMany = inc.nodesToHandle;
		delete inc.nodesToHandle;
	}

	/**
	 * Returns an object with a single insert change description.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent The element in which the change happened.
	 * @param {Number} offset The offset at which change happened.
	 * @param {String} name The name of the removed element or `'$text'` for a character.
	 * @returns {Object} The diff item.
	 */
	_getInsertDiff( parent, offset, name ) {
		return {
			type: 'insert',
			position: _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ),
			name,
			length: 1,
			changeCount: this._changeCount++
		};
	}

	/**
	 * Returns an object with a single remove change description.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent The element in which change happened.
	 * @param {Number} offset The offset at which change happened.
	 * @param {String} name The name of the removed element or `'$text'` for a character.
	 * @returns {Object} The diff item.
	 */
	_getRemoveDiff( parent, offset, name ) {
		return {
			type: 'remove',
			position: _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ),
			name,
			length: 1,
			changeCount: this._changeCount++
		};
	}

	/**
	 * Returns an array of objects where each one is a single attribute change description.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range The range where the change happened.
	 * @param {Map} oldAttributes A map, map iterator or compatible object that contains attributes before the change.
	 * @param {Map} newAttributes A map, map iterator or compatible object that contains attributes after the change.
	 * @returns {Array.<Object>} An array containing one or more diff items.
	 */
	_getAttributesDiff( range, oldAttributes, newAttributes ) {
		// Results holder.
		const diffs = [];

		// Clone new attributes as we will be performing changes on this object.
		newAttributes = new Map( newAttributes );

		// Look through old attributes.
		for ( const [ key, oldValue ] of oldAttributes ) {
			// Check what is the new value of the attribute (or if it was removed).
			const newValue = newAttributes.has( key ) ? newAttributes.get( key ) : null;

			// If values are different (or attribute was removed)...
			if ( newValue !== oldValue ) {
				// Add diff item.
				diffs.push( {
					type: 'attribute',
					position: range.start,
					range: range.clone(),
					length: 1,
					attributeKey: key,
					attributeOldValue: oldValue,
					attributeNewValue: newValue,
					changeCount: this._changeCount++
				} );
			}

			// Prevent returning two diff items for the same change.
			newAttributes.delete( key );
		}

		// Look through new attributes that weren't handled above.
		for ( const [ key, newValue ] of newAttributes ) {
			// Each of them is a new attribute. Add diff item.
			diffs.push( {
				type: 'attribute',
				position: range.start,
				range: range.clone(),
				length: 1,
				attributeKey: key,
				attributeOldValue: null,
				attributeNewValue: newValue,
				changeCount: this._changeCount++
			} );
		}

		return diffs;
	}

	/**
	 * Checks whether given element or any of its parents is an element that is buffered as an inserted element.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} element Element to check.
	 * @returns {Boolean}
	 */
	_isInInsertedElement( element ) {
		const parent = element.parent;

		if ( !parent ) {
			return false;
		}

		const changes = this._changesInElement.get( parent );
		const offset = element.startOffset;

		if ( changes ) {
			for ( const change of changes ) {
				if ( change.type == 'insert' && offset >= change.offset && offset < change.offset + change.howMany ) {
					return true;
				}
			}
		}

		return this._isInInsertedElement( parent );
	}

	/**
	 * Removes deeply all buffered changes that are registered in elements from range specified by `parent`, `offset`
	 * and `howMany`.
	 *
	 * @private
	 * @param {module:engine/model/element~Element} parent
	 * @param {Number} offset
	 * @param {Number} howMany
	 */
	_removeAllNestedChanges( parent, offset, howMany ) {
		const range = new _range__WEBPACK_IMPORTED_MODULE_1__["default"]( _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset ), _position__WEBPACK_IMPORTED_MODULE_0__["default"]._createAt( parent, offset + howMany ) );

		for ( const item of range.getItems( { shallow: true } ) ) {
			if ( item.is( 'element' ) ) {
				this._elementSnapshots.delete( item );
				this._changesInElement.delete( item );

				this._removeAllNestedChanges( item, 0, item.maxOffset );
			}
		}
	}
}

// Returns an array that is a copy of passed child list with the exception that text nodes are split to one or more
// objects, each representing one character and attributes set on that character.
function _getChildrenSnapshot( children ) {
	const snapshot = [];

	for ( const child of children ) {
		if ( child.is( '$text' ) ) {
			for ( let i = 0; i < child.data.length; i++ ) {
				snapshot.push( {
					name: '$text',
					attributes: new Map( child.getAttributes() )
				} );
			}
		} else {
			snapshot.push( {
				name: child.name,
				attributes: new Map( child.getAttributes() )
			} );
		}
	}

	return snapshot;
}

// Generates array of actions for given changes set.
// It simulates what `diff` function does.
// Generated actions are:
// - 'e' for 'equal' - when item at that position did not change,
// - 'i' for 'insert' - when item at that position was inserted,
// - 'r' for 'remove' - when item at that position was removed,
// - 'a' for 'attribute' - when item at that position has it attributes changed.
//
// Example (assume that uppercase letters have bold attribute, compare with function code):
//
// children before:	fooBAR
// children after:	foxybAR
//
// changes: type: remove, offset: 1, howMany: 1
//			type: insert, offset: 2, howMany: 2
//			type: attribute, offset: 4, howMany: 1
//
// expected actions: equal (f), remove (o), equal (o), insert (x), insert (y), attribute (b), equal (A), equal (R)
//
// steps taken by th script:
//
// 1. change = "type: remove, offset: 1, howMany: 1"; offset = 0; oldChildrenHandled = 0
//    1.1 between this change and the beginning is one not-changed node, fill with one equal action, one old child has been handled
//    1.2 this change removes one node, add one remove action
//    1.3 change last visited `offset` to 1
//    1.4 since an old child has been removed, one more old child has been handled
//    1.5 actions at this point are: equal, remove
//
// 2. change = "type: insert, offset: 2, howMany: 2"; offset = 1; oldChildrenHandled = 2
//    2.1 between this change and previous change is one not-changed node, add equal action, another one old children has been handled
//    2.2 this change inserts two nodes, add two insert actions
//    2.3 change last visited offset to the end of the inserted range, that is 4
//    2.4 actions at this point are: equal, remove, equal, insert, insert
//
// 3. change = "type: attribute, offset: 4, howMany: 1"; offset = 4, oldChildrenHandled = 3
//    3.1 between this change and previous change are no not-changed nodes
//    3.2 this change changes one node, add one attribute action
//    3.3 change last visited `offset` to the end of change range, that is 5
//    3.4 since an old child has been changed, one more old child has been handled
//    3.5 actions at this point are: equal, remove, equal, insert, insert, attribute
//
// 4. after loop oldChildrenHandled = 4, oldChildrenLength = 6 (fooBAR is 6 characters)
//    4.1 fill up with two equal actions
//
// The result actions are: equal, remove, equal, insert, insert, attribute, equal, equal.
function _generateActionsFromChanges( oldChildrenLength, changes ) {
	const actions = [];

	let offset = 0;
	let oldChildrenHandled = 0;

	// Go through all buffered changes.
	for ( const change of changes ) {
		// First, fill "holes" between changes with "equal" actions.
		if ( change.offset > offset ) {
			for ( let i = 0; i < change.offset - offset; i++ ) {
				actions.push( 'e' );
			}

			oldChildrenHandled += change.offset - offset;
		}

		// Then, fill up actions accordingly to change type.
		if ( change.type == 'insert' ) {
			for ( let i = 0; i < change.howMany; i++ ) {
				actions.push( 'i' );
			}

			// The last handled offset is after inserted range.
			offset = change.offset + change.howMany;
		} else if ( change.type == 'remove' ) {
			for ( let i = 0; i < change.howMany; i++ ) {
				actions.push( 'r' );
			}

			// The last handled offset is at the position where the nodes were removed.
			offset = change.offset;
			// We removed `howMany` old nodes, update `oldChildrenHandled`.
			oldChildrenHandled += change.howMany;
		} else {
			actions.push( ...'a'.repeat( change.howMany ).split( '' ) );

			// The last handled offset is at the position after the changed range.
			offset = change.offset + change.howMany;
			// We changed `howMany` old nodes, update `oldChildrenHandled`.
			oldChildrenHandled += change.howMany;
		}
	}

	// Fill "equal" actions at the end of actions set. Use `oldChildrenHandled` to see how many children
	// has not been changed / removed at the end of their parent.
	if ( oldChildrenHandled < oldChildrenLength ) {
		for ( let i = 0; i < oldChildrenLength - oldChildrenHandled - offset; i++ ) {
			actions.push( 'e' );
		}
	}

	return actions;
}

// Filter callback for Array.filter that filters out change entries that are in graveyard.
function _changesInGraveyardFilter( entry ) {
	const posInGy = entry.position && entry.position.root.rootName == '$graveyard';
	const rangeInGy = entry.range && entry.range.root.rootName == '$graveyard';

	return !posInGy && !rangeInGy;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/document.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/document.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Document; });
/* harmony import */ var _differ__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./differ */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/differ.js");
/* harmony import */ var _rootelement__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rootelement */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/rootelement.js");
/* harmony import */ var _history__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./history */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/history.js");
/* harmony import */ var _documentselection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./documentselection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/unicode */ "./node_modules/@ckeditor/ckeditor5-utils/src/unicode.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/document
 */












// @if CK_DEBUG_ENGINE // const { logDocument } = require( '../dev-utils/utils' );

const graveyardName = '$graveyard';

/**
 * Data model's document. It contains the model's structure, its selection and the history of changes.
 *
 * Read more about working with the model in
 * {@glink framework/guides/architecture/editing-engine#model introduction to the the editing engine's architecture}.
 *
 * Usually, the document contains just one {@link module:engine/model/document~Document#roots root element}, so
 * you can retrieve it by just calling {@link module:engine/model/document~Document#getRoot} without specifying its name:
 *
 *		model.document.getRoot(); // -> returns the main root
 *
 * However, the document may contain multiple roots – e.g. when the editor has multiple editable areas
 * (e.g. a title and a body of a message).
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class Document {
	/**
	 * Creates an empty document instance with no {@link #roots} (other than
	 * the {@link #graveyard graveyard root}).
	 */
	constructor( model ) {
		/**
		 * The {@link module:engine/model/model~Model model} that the document is a part of.
		 *
		 * @readonly
		 * @type {module:engine/model/model~Model}
		 */
		this.model = model;

		/**
		 * The document version. It starts from `0` and every operation increases the version number. It is used to ensure that
		 * operations are applied on a proper document version.
		 *
		 * If the {@link module:engine/model/operation/operation~Operation#baseVersion base version} does not match the document version,
		 * a {@link module:utils/ckeditorerror~CKEditorError model-document-applyOperation-wrong-version} error is thrown.
		 *
		 * @type {Number}
		 */
		this.version = 0;

		/**
		 * The document's history.
		 *
		 * @readonly
		 * @type {module:engine/model/history~History}
		 */
		this.history = new _history__WEBPACK_IMPORTED_MODULE_2__["default"]( this );

		/**
		 * The selection in this document.
		 *
		 * @readonly
		 * @type {module:engine/model/documentselection~DocumentSelection}
		 */
		this.selection = new _documentselection__WEBPACK_IMPORTED_MODULE_3__["default"]( this );

		/**
		 * A list of roots that are owned and managed by this document. Use {@link #createRoot} and
		 * {@link #getRoot} to manipulate it.
		 *
		 * @readonly
		 * @type {module:utils/collection~Collection}
		 */
		this.roots = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_4__["default"]( { idProperty: 'rootName' } );

		/**
		 * The model differ object. Its role is to buffer changes done on the model document and then calculate a diff of those changes.
		 *
		 * @readonly
		 * @type {module:engine/model/differ~Differ}
		 */
		this.differ = new _differ__WEBPACK_IMPORTED_MODULE_0__["default"]( model.markers );

		/**
		 * Post-fixer callbacks registered to the model document.
		 *
		 * @private
		 * @type {Set.<Function>}
		 */
		this._postFixers = new Set();

		/**
		 * A boolean indicates whether the selection has changed until
		 *
		 * @private
		 * @type {Boolean}
		 */
		this._hasSelectionChangedFromTheLastChangeBlock = false;

		// Graveyard tree root. Document always have a graveyard root, which stores removed nodes.
		this.createRoot( '$root', graveyardName );

		// First, if the operation is a document operation check if it's base version is correct.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation && operation.baseVersion !== this.version ) {
				/**
				 * Only operations with matching versions can be applied.
				 *
				 * @error document-applyOperation-wrong-version
				 * @param {module:engine/model/operation/operation~Operation} operation
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"](
					'model-document-applyOperation-wrong-version: Only operations with matching versions can be applied.',
					this,
					{ operation }
				);
			}
		}, { priority: 'highest' } );

		// Then, still before an operation is applied on model, buffer the change in differ.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation ) {
				this.differ.bufferOperation( operation );
			}
		}, { priority: 'high' } );

		// After the operation is applied, bump document's version and add the operation to the history.
		this.listenTo( model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( operation.isDocumentOperation ) {
				this.version++;
				this.history.addOperation( operation );
			}
		}, { priority: 'low' } );

		// Listen to selection changes. If selection changed, mark it.
		this.listenTo( this.selection, 'change', () => {
			this._hasSelectionChangedFromTheLastChangeBlock = true;
		} );

		// Buffer marker changes.
		// This is not covered in buffering operations because markers may change outside of them (when they
		// are modified using `model.markers` collection, not through `MarkerOperation`).
		this.listenTo( model.markers, 'update', ( evt, marker, oldRange, newRange ) => {
			// Whenever marker is updated, buffer that change.
			this.differ.bufferMarkerChange( marker.name, oldRange, newRange, marker.affectsData );

			if ( oldRange === null ) {
				// If this is a new marker, add a listener that will buffer change whenever marker changes.
				marker.on( 'change', ( evt, oldRange ) => {
					this.differ.bufferMarkerChange( marker.name, oldRange, marker.getRange(), marker.affectsData );
				} );
			}
		} );
	}

	/**
	 * The graveyard tree root. A document always has a graveyard root that stores removed nodes.
	 *
	 * @readonly
	 * @member {module:engine/model/rootelement~RootElement}
	 */
	get graveyard() {
		return this.getRoot( graveyardName );
	}

	/**
	 * Creates a new root.
	 *
	 * @param {String} [elementName='$root'] The element name. Defaults to `'$root'` which also has some basic schema defined
	 * (`$block`s are allowed inside the `$root`). Make sure to define a proper schema if you use a different name.
	 * @param {String} [rootName='main'] A unique root name.
	 * @returns {module:engine/model/rootelement~RootElement} The created root.
	 */
	createRoot( elementName = '$root', rootName = 'main' ) {
		if ( this.roots.get( rootName ) ) {
			/**
			 * A root with the specified name already exists.
			 *
			 * @error model-document-createRoot-name-exists
			 * @param {module:engine/model/document~Document} doc
			 * @param {String} name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_6__["default"](
				'model-document-createRoot-name-exists: Root with specified name already exists.',
				this,
				{ name: rootName }
			);
		}

		const root = new _rootelement__WEBPACK_IMPORTED_MODULE_1__["default"]( this, elementName, rootName );
		this.roots.add( root );

		return root;
	}

	/**
	 * Removes all event listeners set by the document instance.
	 */
	destroy() {
		this.selection.destroy();
		this.stopListening();
	}

	/**
	 * Returns a root by its name.
	 *
	 * @param {String} [name='main'] A unique root name.
	 * @returns {module:engine/model/rootelement~RootElement|null} The root registered under a given name or `null` when
	 * there is no root with the given name.
	 */
	getRoot( name = 'main' ) {
		return this.roots.get( name );
	}

	/**
	 * Returns an array with names of all roots (without the {@link #graveyard}) added to the document.
	 *
	 * @returns {Array.<String>} Roots names.
	 */
	getRootNames() {
		return Array.from( this.roots, root => root.rootName ).filter( name => name != graveyardName );
	}

	/**
	 * Used to register a post-fixer callback. A post-fixer mechanism guarantees that the features
	 * will operate on a correct model state.
	 *
	 * An execution of a feature may lead to an incorrect document tree state. The callbacks are used to fix the document tree after
	 * it has changed. Post-fixers are fired just after all changes from the outermost change block were applied but
	 * before the {@link module:engine/model/document~Document#event:change change event} is fired. If a post-fixer callback made
	 * a change, it should return `true`. When this happens, all post-fixers are fired again to check if something else should
	 * not be fixed in the new document tree state.
	 *
	 * As a parameter, a post-fixer callback receives a {@link module:engine/model/writer~Writer writer} instance connected with the
	 * executed changes block. Thanks to that, all changes done by the callback will be added to the same
	 * {@link module:engine/model/batch~Batch batch} (and undo step) as the original changes. This makes post-fixer changes transparent
	 * for the user.
	 *
	 * An example of a post-fixer is a callback that checks if all the data were removed from the editor. If so, the
	 * callback should add an empty paragraph so that the editor is never empty:
	 *
	 *		document.registerPostFixer( writer => {
	 *			const changes = document.differ.getChanges();
	 *
	 *			// Check if the changes lead to an empty root in the editor.
	 *			for ( const entry of changes ) {
	 *				if ( entry.type == 'remove' && entry.position.root.isEmpty ) {
	 *					writer.insertElement( 'paragraph', entry.position.root, 0 );
	 *
	 *					// It is fine to return early, even if multiple roots would need to be fixed.
	 *					// All post-fixers will be fired again, so if there are more empty roots, those will be fixed, too.
	 *					return true;
	 *				}
	 *			}
	 *		} );
	 *
	 * @param {Function} postFixer
	 */
	registerPostFixer( postFixer ) {
		this._postFixers.add( postFixer );
	}

	/**
	 * A custom `toJSON()` method to solve child-parent circular dependencies.
	 *
	 * @returns {Object} A clone of this object with the document property changed to a string.
	 */
	toJSON() {
		const json = Object(lodash_es__WEBPACK_IMPORTED_MODULE_9__["clone"])( this );

		// Due to circular references we need to remove parent reference.
		json.selection = '[engine.model.DocumentSelection]';
		json.model = '[engine.model.Model]';

		return json;
	}

	/**
	 * Check if there were any changes done on document, and if so, call post-fixers,
	 * fire `change` event for features and conversion and then reset the differ.
	 * Fire `change:data` event when at least one operation or buffered marker changes the data.
	 *
	 * @protected
	 * @fires change
	 * @fires change:data
	 * @param {module:engine/model/writer~Writer} writer The writer on which post-fixers will be called.
	 */
	_handleChangeBlock( writer ) {
		if ( this._hasDocumentChangedFromTheLastChangeBlock() ) {
			this._callPostFixers( writer );

			// Refresh selection attributes according to the final position in the model after the change.
			this.selection.refresh();

			if ( this.differ.hasDataChanges() ) {
				this.fire( 'change:data', writer.batch );
			} else {
				this.fire( 'change', writer.batch );
			}

			// Theoretically, it is not necessary to refresh selection after change event because
			// post-fixers are the last who should change the model, but just in case...
			this.selection.refresh();

			this.differ.reset();
		}

		this._hasSelectionChangedFromTheLastChangeBlock = false;
	}

	/**
	 * Returns whether there is a buffered change or if the selection has changed from the last
	 * {@link module:engine/model/model~Model#enqueueChange `enqueueChange()` block}
	 * or {@link module:engine/model/model~Model#change `change()` block}.
	 *
	 * @protected
	 * @returns {Boolean} Returns `true` if document has changed from the last `change()` or `enqueueChange()` block.
	 */
	_hasDocumentChangedFromTheLastChangeBlock() {
		return !this.differ.isEmpty || this._hasSelectionChangedFromTheLastChangeBlock;
	}

	/**
	 * Returns the default root for this document which is either the first root that was added to the document using
	 * {@link #createRoot} or the {@link #graveyard graveyard root} if no other roots were created.
	 *
	 * @protected
	 * @returns {module:engine/model/rootelement~RootElement} The default root for this document.
	 */
	_getDefaultRoot() {
		for ( const root of this.roots ) {
			if ( root !== this.graveyard ) {
				return root;
			}
		}

		return this.graveyard;
	}

	/**
	 * Returns the default range for this selection. The default range is a collapsed range that starts and ends
	 * at the beginning of this selection's document {@link #_getDefaultRoot default root}.
	 *
	 * @protected
	 * @returns {module:engine/model/range~Range}
	 */
	_getDefaultRange() {
		const defaultRoot = this._getDefaultRoot();
		const model = this.model;
		const schema = model.schema;

		// Find the first position where the selection can be put.
		const position = model.createPositionFromPath( defaultRoot, [ 0 ] );
		const nearestRange = schema.getNearestSelectionRange( position );

		// If valid selection range is not found - return range collapsed at the beginning of the root.
		return nearestRange || model.createRange( position );
	}

	/**
	 * Checks whether a given {@link module:engine/model/range~Range range} is a valid range for
	 * the {@link #selection document's selection}.
	 *
	 * @private
	 * @param {module:engine/model/range~Range} range A range to check.
	 * @returns {Boolean} `true` if `range` is valid, `false` otherwise.
	 */
	_validateSelectionRange( range ) {
		return validateTextNodePosition( range.start ) && validateTextNodePosition( range.end );
	}

	/**
	 * Performs post-fixer loops. Executes post-fixer callbacks as long as none of them has done any changes to the model.
	 *
	 * @private
	 * @param {module:engine/model/writer~Writer} writer The writer on which post-fixer callbacks will be called.
	 */
	_callPostFixers( writer ) {
		let wasFixed = false;

		do {
			for ( const callback of this._postFixers ) {
				// Ensure selection attributes are up to date before each post-fixer.
				// https://github.com/ckeditor/ckeditor5-engine/issues/1673.
				//
				// It might be good to refresh the selection after each operation but at the moment it leads
				// to losing attributes for composition or and spell checking
				// https://github.com/ckeditor/ckeditor5-typing/issues/188
				this.selection.refresh();

				wasFixed = callback( writer );

				if ( wasFixed ) {
					break;
				}
			}
		} while ( wasFixed );
	}

	/**
	 * Fired after each {@link module:engine/model/model~Model#enqueueChange `enqueueChange()` block} or the outermost
	 * {@link module:engine/model/model~Model#change `change()` block} was executed and the document was changed
	 * during that block's execution.
	 *
	 * The changes which this event will cover include:
	 *
	 * * document structure changes,
	 * * selection changes,
	 * * marker changes.
	 *
	 * If you want to be notified about all these changes, then simply listen to this event like this:
	 *
	 *		model.document.on( 'change', () => {
	 *			console.log( 'The document has changed!' );
	 *		} );
	 *
	 * If, however, you only want to be notified about the data changes, then use the
	 * {@link module:engine/model/document~Document#event:change:data change:data} event,
	 * which is fired for document structure changes and marker changes (which affects the data).
	 *
	 *		model.document.on( 'change:data', () => {
	 *			console.log( 'The data has changed!' );
	 *		} );
	 *
	 * @event change
	 * @param {module:engine/model/batch~Batch} batch The batch that was used in the executed changes block.
	 */

	/**
	 * It is a narrower version of the {@link #event:change} event. It is fired for changes which
	 * affect the editor data. This is:
	 *
	 * * document structure changes,
	 * * marker changes (which affects the data).
	 *
	 * If you want to be notified about the data changes, then listen to this event:
	 *
	 *		model.document.on( 'change:data', () => {
	 *			console.log( 'The data has changed!' );
	 *		} );
	 *
	 * If you would like to listen to all document changes, then check out the
	 * {@link module:engine/model/document~Document#event:change change} event.
	 *
	 * @event change:data
	 * @param {module:engine/model/batch~Batch} batch The batch that was used in the executed changes block.
	 */

	// @if CK_DEBUG_ENGINE // log( version = null ) {
	// @if CK_DEBUG_ENGINE // 	version = version === null ? this.version : version;
	// @if CK_DEBUG_ENGINE // 	logDocument( this, version );
	// @if CK_DEBUG_ENGINE // }
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_7__["default"])( Document, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_5__["default"] );

// Checks whether given range boundary position is valid for document selection, meaning that is not between
// unicode surrogate pairs or base character and combining marks.
function validateTextNodePosition( rangeBoundary ) {
	const textNode = rangeBoundary.textNode;

	if ( textNode ) {
		const data = textNode.data;
		const offset = rangeBoundary.offset - textNode.startOffset;

		return !Object(_ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__["isInsideSurrogatePair"])( data, offset ) && !Object(_ckeditor_ckeditor5_utils_src_unicode__WEBPACK_IMPORTED_MODULE_8__["isInsideCombinedSymbol"])( data, offset );
	}

	return true;
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/documentfragment.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/documentfragment.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DocumentFragment; });
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./nodelist */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/isiterable */ "./node_modules/@ckeditor/ckeditor5-utils/src/isiterable.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module module:engine/model/documentfragment
 */







// @if CK_DEBUG_ENGINE // const { stringifyMap } = require( '../dev-utils/utils' );

/**
 * DocumentFragment represents a part of model which does not have a common root but it's top-level nodes
 * can be seen as siblings. In other words, it is a detached part of model tree, without a root.
 *
 * DocumentFragment has own {@link module:engine/model/markercollection~MarkerCollection}. Markers from this collection
 * will be set to the {@link module:engine/model/model~Model#markers model markers} by a
 * {@link module:engine/model/writer~Writer#insert} function.
 */
class DocumentFragment {
	/**
	 * Creates an empty `DocumentFragment`.
	 *
	 * **Note:** Constructor of this class shouldn't be used directly in the code.
	 * Use the {@link module:engine/model/writer~Writer#createDocumentFragment} method instead.
	 *
	 * @protected
	 * @param {module:engine/model/node~Node|Iterable.<module:engine/model/node~Node>} [children]
	 * Nodes to be contained inside the `DocumentFragment`.
	 */
	constructor( children ) {
		/**
		 * DocumentFragment static markers map. This is a list of names and {@link module:engine/model/range~Range ranges}
		 * which will be set as Markers to {@link module:engine/model/model~Model#markers model markers collection}
		 * when DocumentFragment will be inserted to the document.
		 *
		 * @readonly
		 * @member {Map<String,module:engine/model/range~Range>} module:engine/model/documentfragment~DocumentFragment#markers
		 */
		this.markers = new Map();

		/**
		 * List of nodes contained inside the document fragment.
		 *
		 * @private
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/documentfragment~DocumentFragment#_children
		 */
		this._children = new _nodelist__WEBPACK_IMPORTED_MODULE_0__["default"]();

		if ( children ) {
			this._insertChild( 0, children );
		}
	}

	/**
	 * Returns an iterator that iterates over all nodes contained inside this document fragment.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	[ Symbol.iterator ]() {
		return this.getChildren();
	}

	/**
	 * Number of this document fragment's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get childCount() {
		return this._children.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all of this document fragment's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._children.maxOffset;
	}

	/**
	 * Is `true` if there are no nodes inside this document fragment, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this.childCount === 0;
	}

	/**
	 * Artificial root of `DocumentFragment`. Returns itself. Added for compatibility reasons.
	 *
	 * @readonly
	 * @type {module:engine/model/documentfragment~DocumentFragment}
	 */
	get root() {
		return this;
	}

	/**
	 * Artificial parent of `DocumentFragment`. Returns `null`. Added for compatibility reasons.
	 *
	 * @readonly
	 * @type {null}
	 */
	get parent() {
		return null;
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 *		docFrag.is( 'documentFragment' ); // -> true
	 *		docFrag.is( 'model:documentFragment' ); // -> true
	 *
	 *		docFrag.is( 'view:documentFragment' ); // -> false
	 *		docFrag.is( 'element' ); // -> false
	 *		docFrag.is( 'node' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'documentFragment' || type === 'model:documentFragment';
	}

	/**
	 * Gets the child at the given index. Returns `null` if incorrect index was passed.
	 *
	 * @param {Number} index Index of child.
	 * @returns {module:engine/model/node~Node|null} Child node.
	 */
	getChild( index ) {
		return this._children.getNode( index );
	}

	/**
	 * Returns an iterator that iterates over all of this document fragment's children.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	getChildren() {
		return this._children[ Symbol.iterator ]();
	}

	/**
	 * Returns an index of the given child node. Returns `null` if given node is not a child of this document fragment.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's index.
	 */
	getChildIndex( node ) {
		return this._children.getNodeIndex( node );
	}

	/**
	 * Returns the starting offset of given child. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all node's siblings that are before it. Returns `null` if
	 * given node is not a child of this document fragment.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's starting offset.
	 */
	getChildStartOffset( node ) {
		return this._children.getNodeStartOffset( node );
	}

	/**
	 * Returns path to a `DocumentFragment`, which is an empty array. Added for compatibility reasons.
	 *
	 * @returns {Array}
	 */
	getPath() {
		return [];
	}

	/**
	 * Returns a descendant node by its path relative to this element.
	 *
	 *		// <this>a<b>c</b></this>
	 *		this.getNodeByPath( [ 0 ] );     // -> "a"
	 *		this.getNodeByPath( [ 1 ] );     // -> <b>
	 *		this.getNodeByPath( [ 1, 0 ] );  // -> "c"
	 *
	 * @param {Array.<Number>} relativePath Path of the node to find, relative to this element.
	 * @returns {module:engine/model/node~Node|module:engine/model/documentfragment~DocumentFragment}
	 */
	getNodeByPath( relativePath ) {
		let node = this; // eslint-disable-line consistent-this

		for ( const index of relativePath ) {
			node = node.getChild( node.offsetToIndex( index ) );
		}

		return node;
	}

	/**
	 * Converts offset "position" to index "position".
	 *
	 * Returns index of a node that occupies given offset. If given offset is too low, returns `0`. If given offset is
	 * too high, returns index after last child}.
	 *
	 *		const textNode = new Text( 'foo' );
	 *		const pElement = new Element( 'p' );
	 *		const docFrag = new DocumentFragment( [ textNode, pElement ] );
	 *		docFrag.offsetToIndex( -1 ); // Returns 0, because offset is too low.
	 *		docFrag.offsetToIndex( 0 ); // Returns 0, because offset 0 is taken by `textNode` which is at index 0.
	 *		docFrag.offsetToIndex( 1 ); // Returns 0, because `textNode` has `offsetSize` equal to 3, so it occupies offset 1 too.
	 *		docFrag.offsetToIndex( 2 ); // Returns 0.
	 *		docFrag.offsetToIndex( 3 ); // Returns 1.
	 *		docFrag.offsetToIndex( 4 ); // Returns 2. There are no nodes at offset 4, so last available index is returned.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number} Index of a node that occupies given offset.
	 */
	offsetToIndex( offset ) {
		return this._children.offsetToIndex( offset );
	}

	/**
	 * Converts `DocumentFragment` instance to plain object and returns it.
	 * Takes care of converting all of this document fragment's children.
	 *
	 * @returns {Object} `DocumentFragment` instance converted to plain object.
	 */
	toJSON() {
		const json = [];

		for ( const node of this._children ) {
			json.push( node.toJSON() );
		}

		return json;
	}

	/**
	 * Creates a `DocumentFragment` instance from given plain object (i.e. parsed JSON string).
	 * Converts `DocumentFragment` children to proper nodes.
	 *
	 * @param {Object} json Plain object to be converted to `DocumentFragment`.
	 * @returns {module:engine/model/documentfragment~DocumentFragment} `DocumentFragment` instance created using given plain object.
	 */
	static fromJSON( json ) {
		const children = [];

		for ( const child of json ) {
			if ( child.name ) {
				// If child has name property, it is an Element.
				children.push( _element__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( child ) );
			} else {
				// Otherwise, it is a Text node.
				children.push( _text__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( child ) );
			}
		}

		return new DocumentFragment( children );
	}

	/**
	 * {@link #_insertChild Inserts} one or more nodes at the end of this document fragment.
	 *
	 * @protected
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_appendChild( items ) {
		this._insertChild( this.childCount, items );
	}

	/**
	 * Inserts one or more nodes at the given index and sets {@link module:engine/model/node~Node#parent parent} of these nodes
	 * to this document fragment.
	 *
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_insertChild( index, items ) {
		const nodes = normalize( items );

		for ( const node of nodes ) {
			// If node that is being added to this element is already inside another element, first remove it from the old parent.
			if ( node.parent !== null ) {
				node._remove();
			}

			node.parent = this;
		}

		this._children._insertNodes( index, nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index
	 * and sets {@link module:engine/model/node~Node#parent parent} of these nodes to `null`.
	 *
	 * @protected
	 * @param {Number} index Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeChildren( index, howMany = 1 ) {
		const nodes = this._children._removeNodes( index, howMany );

		for ( const node of nodes ) {
			node.parent = null;
		}

		return nodes;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return 'documentFragment';
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelDocumentFragment: ' + this );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // printTree() {
	// @if CK_DEBUG_ENGINE //	let string = 'ModelDocumentFragment: [';

	// @if CK_DEBUG_ENGINE //	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE //		string += '\n';

	// @if CK_DEBUG_ENGINE //		if ( child.is( '$text' ) ) {
	// @if CK_DEBUG_ENGINE //			const textAttrs = stringifyMap( child._attrs );

	// @if CK_DEBUG_ENGINE //			string += '\t'.repeat( 1 );

	// @if CK_DEBUG_ENGINE //			if ( textAttrs !== '' ) {
	// @if CK_DEBUG_ENGINE //				string += `<$text${ textAttrs }>` + child.data + '</$text>';
	// @if CK_DEBUG_ENGINE //			} else {
	// @if CK_DEBUG_ENGINE //				string += child.data;
	// @if CK_DEBUG_ENGINE //			}
	// @if CK_DEBUG_ENGINE //		} else {
	// @if CK_DEBUG_ENGINE //			string += child.printTree( 1 );
	// @if CK_DEBUG_ENGINE //		}
	// @if CK_DEBUG_ENGINE //	}

	// @if CK_DEBUG_ENGINE //	string += '\n]';

	// @if CK_DEBUG_ENGINE //	return string;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logTree() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.printTree() );
	// @if CK_DEBUG_ENGINE // }
}

// Converts strings to Text and non-iterables to arrays.
//
// @param {String|module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>}
// @returns {Iterable.<module:engine/model/node~Node>}
function normalize( nodes ) {
	// Separate condition because string is iterable.
	if ( typeof nodes == 'string' ) {
		return [ new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( nodes ) ];
	}

	if ( !Object(_ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__["default"])( nodes ) ) {
		nodes = [ nodes ];
	}

	// Array.from to enable .map() on non-arrays.
	return Array.from( nodes )
		.map( node => {
			if ( typeof node == 'string' ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node );
			}

			if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_3__["default"] ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node.data, node.getAttributes() );
			}

			return node;
		} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/documentselection.js ***!
  \********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DocumentSelection; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./selection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _liverange__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./liverange */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/tomap */ "./node_modules/@ckeditor/ckeditor5-utils/src/tomap.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/collection */ "./node_modules/@ckeditor/ckeditor5-utils/src/collection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_uid__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/uid */ "./node_modules/@ckeditor/ckeditor5-utils/src/uid.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/documentselection
 */













const storePrefix = 'selection:';

/**
 * `DocumentSelection` is a special selection which is used as the
 * {@link module:engine/model/document~Document#selection document's selection}.
 * There can be only one instance of `DocumentSelection` per document.
 *
 * Document selection can only be changed by using the {@link module:engine/model/writer~Writer} instance
 * inside the {@link module:engine/model/model~Model#change `change()`} block, as it provides a secure way to modify model.
 *
 * `DocumentSelection` is automatically updated upon changes in the {@link module:engine/model/document~Document document}
 * to always contain valid ranges. Its attributes are inherited from the text unless set explicitly.
 *
 * Differences between {@link module:engine/model/selection~Selection} and `DocumentSelection` are:
 * * there is always a range in `DocumentSelection` - even if no ranges were added there is a "default range"
 * present in the selection,
 * * ranges added to this selection updates automatically when the document changes,
 * * attributes of `DocumentSelection` are updated automatically according to selection ranges.
 *
 * Since `DocumentSelection` uses {@link module:engine/model/liverange~LiveRange live ranges}
 * and is updated when {@link module:engine/model/document~Document document}
 * changes, it cannot be set on {@link module:engine/model/node~Node nodes}
 * that are inside {@link module:engine/model/documentfragment~DocumentFragment document fragment}.
 * If you need to represent a selection in document fragment,
 * use {@link module:engine/model/selection~Selection Selection class} instead.
 *
 * @mixes module:utils/emittermixin~EmitterMixin
 */
class DocumentSelection {
	/**
	 * Creates an empty live selection for given {@link module:engine/model/document~Document}.
	 *
	 * @param {module:engine/model/document~Document} doc Document which owns this selection.
	 */
	constructor( doc ) {
		/**
		 * Selection used internally by that class (`DocumentSelection` is a proxy to that selection).
		 *
		 * @protected
		 */
		this._selection = new LiveSelection( doc );

		this._selection.delegate( 'change:range' ).to( this );
		this._selection.delegate( 'change:attribute' ).to( this );
		this._selection.delegate( 'change:marker' ).to( this );
	}

	/**
	 * Returns whether the selection is collapsed. Selection is collapsed when there is exactly one range which is
	 * collapsed.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isCollapsed() {
		return this._selection.isCollapsed;
	}

	/**
	 * Selection anchor. Anchor may be described as a position where the most recent part of the selection starts.
	 * Together with {@link #focus} they define the direction of selection, which is important
	 * when expanding/shrinking selection. Anchor is always {@link module:engine/model/range~Range#start start} or
	 * {@link module:engine/model/range~Range#end end} position of the most recently added range.
	 *
	 * Is set to `null` if there are no ranges in selection.
	 *
	 * @see #focus
	 * @readonly
	 * @type {module:engine/model/position~Position|null}
	 */
	get anchor() {
		return this._selection.anchor;
	}

	/**
	 * Selection focus. Focus is a position where the selection ends.
	 *
	 * Is set to `null` if there are no ranges in selection.
	 *
	 * @see #anchor
	 * @readonly
	 * @type {module:engine/model/position~Position|null}
	 */
	get focus() {
		return this._selection.focus;
	}

	/**
	 * Returns number of ranges in selection.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get rangeCount() {
		return this._selection.rangeCount;
	}

	/**
	 * Describes whether `Documentselection` has own range(s) set, or if it is defaulted to
	 * {@link module:engine/model/document~Document#_getDefaultRange document's default range}.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get hasOwnRange() {
		return this._selection.hasOwnRange;
	}

	/**
	 * Specifies whether the {@link #focus}
	 * precedes {@link #anchor}.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isBackward() {
		return this._selection.isBackward;
	}

	/**
	 * Describes whether the gravity is overridden (using {@link module:engine/model/writer~Writer#overrideSelectionGravity}) or not.
	 *
	 * Note that the gravity remains overridden as long as will not be restored the same number of times as it was overridden.
	 *
	 * @readonly
	 * @returns {Boolean}
	 */
	get isGravityOverridden() {
		return this._selection.isGravityOverridden;
	}

	/**
	 * A collection of selection markers.
	 * Marker is a selection marker when selection range is inside the marker range.
	 *
	 * @readonly
	 * @type {module:utils/collection~Collection.<module:engine/model/markercollection~Marker>}
	 */
	get markers() {
		return this._selection.markers;
	}

	/**
	 * Used for the compatibility with the {@link module:engine/model/selection~Selection#isEqual} method.
	 *
	 * @protected
	 */
	get _ranges() {
		return this._selection._ranges;
	}

	/**
	 * Returns an iterable that iterates over copies of selection ranges.
	 *
	 * @returns {Iterable.<module:engine/model/range~Range>}
	 */
	getRanges() {
		return this._selection.getRanges();
	}

	/**
	 * Returns the first position in the selection.
	 * First position is the position that {@link module:engine/model/position~Position#isBefore is before}
	 * any other position in the selection.
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/position~Position|null}
	 */
	getFirstPosition() {
		return this._selection.getFirstPosition();
	}

	/**
	 * Returns the last position in the selection.
	 * Last position is the position that {@link module:engine/model/position~Position#isAfter is after}
	 * any other position in the selection.
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/position~Position|null}
	 */
	getLastPosition() {
		return this._selection.getLastPosition();
	}

	/**
	 * Returns a copy of the first range in the selection.
	 * First range is the one which {@link module:engine/model/range~Range#start start} position
	 * {@link module:engine/model/position~Position#isBefore is before} start position of all other ranges
	 * (not to confuse with the first range added to the selection).
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/range~Range|null}
	 */
	getFirstRange() {
		return this._selection.getFirstRange();
	}

	/**
	 * Returns a copy of the last range in the selection.
	 * Last range is the one which {@link module:engine/model/range~Range#end end} position
	 * {@link module:engine/model/position~Position#isAfter is after} end position of all other ranges (not to confuse with the range most
	 * recently added to the selection).
	 *
	 * Returns `null` if there are no ranges in selection.
	 *
	 * @returns {module:engine/model/range~Range|null}
	 */
	getLastRange() {
		return this._selection.getLastRange();
	}

	/**
	 * Gets elements of type {@link module:engine/model/schema~Schema#isBlock "block"} touched by the selection.
	 *
	 * This method's result can be used for example to apply block styling to all blocks covered by this selection.
	 *
	 * **Note:** `getSelectedBlocks()` returns blocks that are nested in other non-block elements
	 * but will not return blocks nested in other blocks.
	 *
	 * In this case the function will return exactly all 3 paragraphs (note: `<blockQuote>` is not a block itself):
	 *
	 *		<paragraph>[a</paragraph>
	 *		<blockQuote>
	 *			<paragraph>b</paragraph>
	 *		</blockQuote>
	 *		<paragraph>c]d</paragraph>
	 *
	 * In this case the paragraph will also be returned, despite the collapsed selection:
	 *
	 *		<paragraph>[]a</paragraph>
	 *
	 * In such a scenario, however, only blocks A, B & E will be returned as blocks C & D are nested in block B:
	 *
	 *		[<blockA></blockA>
	 *		<blockB>
	 *			<blockC></blockC>
	 *			<blockD></blockD>
	 *		</blockB>
	 *		<blockE></blockE>]
	 *
	 * If the selection is inside a block all the inner blocks (A & B) are returned:
	 *
	 * 		<block>
	 *			<blockA>[a</blockA>
	 * 			<blockB>b]</blockB>
	 * 		</block>
	 *
	 * **Special case**: If a selection ends at the beginning of a block, that block is not returned as from user perspective
	 * this block wasn't selected. See [#984](https://github.com/ckeditor/ckeditor5-engine/issues/984) for more details.
	 *
	 *		<paragraph>[a</paragraph>
	 *		<paragraph>b</paragraph>
	 *		<paragraph>]c</paragraph> // this block will not be returned
	 *
	 * @returns {Iterable.<module:engine/model/element~Element>}
	 */
	getSelectedBlocks() {
		return this._selection.getSelectedBlocks();
	}

	/**
	 * Returns the selected element. {@link module:engine/model/element~Element Element} is considered as selected if there is only
	 * one range in the selection, and that range contains exactly one element.
	 * Returns `null` if there is no selected element.
	 *
	 * @returns {module:engine/model/element~Element|null}
	 */
	getSelectedElement() {
		return this._selection.getSelectedElement();
	}

	/**
	 * Checks whether the selection contains the entire content of the given element. This means that selection must start
	 * at a position {@link module:engine/model/position~Position#isTouching touching} the element's start and ends at position
	 * touching the element's end.
	 *
	 * By default, this method will check whether the entire content of the selection's current root is selected.
	 * Useful to check if e.g. the user has just pressed <kbd>Ctrl</kbd> + <kbd>A</kbd>.
	 *
	 * @param {module:engine/model/element~Element} [element=this.anchor.root]
	 * @returns {Boolean}
	 */
	containsEntireContent( element ) {
		return this._selection.containsEntireContent( element );
	}

	/**
	 * Unbinds all events previously bound by document selection.
	 */
	destroy() {
		this._selection.destroy();
	}

	/**
	 * Returns iterable that iterates over this selection's attribute keys.
	 *
	 * @returns {Iterable.<String>}
	 */
	getAttributeKeys() {
		return this._selection.getAttributeKeys();
	}

	/**
	 * Returns iterable that iterates over this selection's attributes.
	 *
	 * Attributes are returned as arrays containing two items. First one is attribute key and second is attribute value.
	 * This format is accepted by native `Map` object and also can be passed in `Node` constructor.
	 *
	 * @returns {Iterable.<*>}
	 */
	getAttributes() {
		return this._selection.getAttributes();
	}

	/**
	 * Gets an attribute value for given key or `undefined` if that attribute is not set on the selection.
	 *
	 * @param {String} key Key of attribute to look for.
	 * @returns {*} Attribute value or `undefined`.
	 */
	getAttribute( key ) {
		return this._selection.getAttribute( key );
	}

	/**
	 * Checks if the selection has an attribute for given key.
	 *
	 * @param {String} key Key of attribute to check.
	 * @returns {Boolean} `true` if attribute with given key is set on selection, `false` otherwise.
	 */
	hasAttribute( key ) {
		return this._selection.hasAttribute( key );
	}

	/**
	 * Refreshes selection attributes and markers according to the current position in the model.
	 */
	refresh() {
		this._selection._updateMarkers();
		this._selection._updateAttributes( false );
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 *		selection.is( 'selection' ); // -> true
	 *		selection.is( 'documentSelection' ); // -> true
	 *		selection.is( 'model:selection' ); // -> true
	 *		selection.is( 'model:documentSelection' ); // -> true
	 *
	 *		selection.is( 'view:selection' ); // -> false
	 *		selection.is( 'element' ); // -> false
	 *		selection.is( 'node' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'selection' ||
			type == 'model:selection' ||
			type == 'documentSelection' ||
			type == 'model:documentSelection';
	}

	/**
	 * Moves {@link module:engine/model/documentselection~DocumentSelection#focus} to the specified location.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelectionFocus} method.
	 *
	 * The location can be specified in the same form as
	 * {@link module:engine/model/writer~Writer#createPositionAt writer.createPositionAt()} parameters.
	 *
	 * @see module:engine/model/writer~Writer#setSelectionFocus
	 * @protected
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset] Offset or one of the flags. Used only when
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 */
	_setFocus( itemOrPosition, offset ) {
		this._selection.setFocus( itemOrPosition, offset );
	}

	/**
	 * Sets this selection's ranges and direction to the specified location based on the given
	 * {@link module:engine/model/selection~Selectable selectable}.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelection} method.
	 *
	 * @see module:engine/model/writer~Writer#setSelection
	 * @protected
	 * @param {module:engine/model/selection~Selectable} selectable
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] Sets place or offset of the selection.
	 * @param {Object} [options]
	 * @param {Boolean} [options.backward] Sets this selection instance to be backward.
	 */
	_setTo( selectable, placeOrOffset, options ) {
		this._selection.setTo( selectable, placeOrOffset, options );
	}

	/**
	 * Sets attribute on the selection. If attribute with the same key already is set, it's value is overwritten.
	 * Should be used only within the {@link module:engine/model/writer~Writer#setSelectionAttribute} method.
	 *
	 * @see module:engine/model/writer~Writer#setSelectionAttribute
	 * @protected
	 * @param {String} key Key of the attribute to set.
	 * @param {*} value Attribute value.
	 */
	_setAttribute( key, value ) {
		this._selection.setAttribute( key, value );
	}

	/**
	 * Removes an attribute with given key from the selection.
	 * If the given attribute was set on the selection, fires the {@link module:engine/model/selection~Selection#event:change:range}
	 * event with removed attribute key.
	 * Should be used only within the {@link module:engine/model/writer~Writer#removeSelectionAttribute} method.
	 *
	 * @see module:engine/model/writer~Writer#removeSelectionAttribute
	 * @protected
	 * @param {String} key Key of the attribute to remove.
	 */
	_removeAttribute( key ) {
		this._selection.removeAttribute( key );
	}

	/**
	 * Returns an iterable that iterates through all selection attributes stored in current selection's parent.
	 *
	 * @protected
	 * @returns {Iterable.<*>}
	 */
	_getStoredAttributes() {
		return this._selection._getStoredAttributes();
	}

	/**
	 * Temporarily changes the gravity of the selection from the left to the right.
	 *
	 * The gravity defines from which direction the selection inherits its attributes. If it's the default left
	 * gravity, the selection (after being moved by the the user) inherits attributes from its left hand side.
	 * This method allows to temporarily override this behavior by forcing the gravity to the right.
	 *
	 * It returns an unique identifier which is required to restore the gravity. It guarantees the symmetry
	 * of the process.
	 *
	 * @see module:engine/model/writer~Writer#overrideSelectionGravity
	 * @protected
	 * @returns {String} The unique id which allows restoring the gravity.
	 */
	_overrideGravity() {
		return this._selection.overrideGravity();
	}

	/**
	 * Restores the {@link ~DocumentSelection#_overrideGravity overridden gravity}.
	 *
	 * Restoring the gravity is only possible using the unique identifier returned by
	 * {@link ~DocumentSelection#_overrideGravity}. Note that the gravity remains overridden as long as won't be restored
	 * the same number of times it was overridden.
	 *
	 * @see module:engine/model/writer~Writer#restoreSelectionGravity
	 * @protected
	 * @param {String} uid The unique id returned by {@link #_overrideGravity}.
	 */
	_restoreGravity( uid ) {
		this._selection.restoreGravity( uid );
	}

	/**
	 * Generates and returns an attribute key for selection attributes store, basing on original attribute key.
	 *
	 * @protected
	 * @param {String} key Attribute key to convert.
	 * @returns {String} Converted attribute key, applicable for selection store.
	 */
	static _getStoreAttributeKey( key ) {
		return storePrefix + key;
	}

	/**
	 * Checks whether the given attribute key is an attribute stored on an element.
	 *
	 * @protected
	 * @param {String} key
	 * @returns {Boolean}
	 */
	static _isStoreAttributeKey( key ) {
		return key.startsWith( storePrefix );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_0__["default"])( DocumentSelection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Fired when selection range(s) changed.
 *
 * @event change:range
 * @param {Boolean} directChange In case of {@link module:engine/model/selection~Selection} class it is always set
 * to `true` which indicates that the selection change was caused by a direct use of selection's API.
 * The {@link module:engine/model/documentselection~DocumentSelection}, however, may change because its position
 * was directly changed through the {@link module:engine/model/writer~Writer writer} or because its position was
 * changed because the structure of the model has been changed (which means an indirect change).
 * The indirect change does not occur in case of normal (detached) selections because they are "static" (as "not live")
 * which mean that they are not updated once the document changes.
 */

/**
 * Fired when selection attribute changed.
 *
 * @event change:attribute
 * @param {Boolean} directChange In case of {@link module:engine/model/selection~Selection} class it is always set
 * to `true` which indicates that the selection change was caused by a direct use of selection's API.
 * The {@link module:engine/model/documentselection~DocumentSelection}, however, may change because its attributes
 * were directly changed through the {@link module:engine/model/writer~Writer writer} or because its position was
 * changed in the model and its attributes were refreshed (which means an indirect change).
 * The indirect change does not occur in case of normal (detached) selections because they are "static" (as "not live")
 * which mean that they are not updated once the document changes.
 * @param {Array.<String>} attributeKeys Array containing keys of attributes that changed.
 */

/**
 * Fired when selection marker(s) changed.
 *
 * @event change:marker
 * @param {Boolean} directChange This is always set to `false` in case of `change:marker` event as there is no possibility
 * to change markers directly through {@link module:engine/model/documentselection~DocumentSelection} API.
 * See also {@link module:engine/model/documentselection~DocumentSelection#event:change:range} and
 * {@link module:engine/model/documentselection~DocumentSelection#event:change:attribute}.
 * @param {Array.<module:engine/model/markercollection~Marker>} oldMarkers Markers in which the selection was before the change.
 */

// `LiveSelection` is used internally by {@link module:engine/model/documentselection~DocumentSelection} and shouldn't be used directly.
//
// LiveSelection` is automatically updated upon changes in the {@link module:engine/model/document~Document document}
// to always contain valid ranges. Its attributes are inherited from the text unless set explicitly.
//
// Differences between {@link module:engine/model/selection~Selection} and `LiveSelection` are:
// * there is always a range in `LiveSelection` - even if no ranges were added there is a "default range"
// present in the selection,
// * ranges added to this selection updates automatically when the document changes,
// * attributes of `LiveSelection` are updated automatically according to selection ranges.
//
// @extends module:engine/model/selection~Selection
//
class LiveSelection extends _selection__WEBPACK_IMPORTED_MODULE_2__["default"] {
	// Creates an empty live selection for given {@link module:engine/model/document~Document}.
	// @param {module:engine/model/document~Document} doc Document which owns this selection.
	constructor( doc ) {
		super();

		// List of selection markers.
		// Marker is a selection marker when selection range is inside the marker range.
		//
		// @type {module:utils/collection~Collection}
		this.markers = new _ckeditor_ckeditor5_utils_src_collection__WEBPACK_IMPORTED_MODULE_7__["default"]( { idProperty: 'name' } );

		// Document which owns this selection.
		//
		// @protected
		// @member {module:engine/model/model~Model}
		this._model = doc.model;

		// Document which owns this selection.
		//
		// @protected
		// @member {module:engine/model/document~Document}
		this._document = doc;

		// Keeps mapping of attribute name to priority with which the attribute got modified (added/changed/removed)
		// last time. Possible values of priority are: `'low'` and `'normal'`.
		//
		// Priorities are used by internal `LiveSelection` mechanisms. All attributes set using `LiveSelection`
		// attributes API are set with `'normal'` priority.
		//
		// @private
		// @member {Map} module:engine/model/liveselection~LiveSelection#_attributePriority
		this._attributePriority = new Map();

		// Position to which the selection should be set if the last selection range was moved to the graveyard.
		// @private
		// @member {module:engine/model/position~Position} module:engine/model/liveselection~LiveSelection#_selectionRestorePosition
		this._selectionRestorePosition = null;

		// Flag that informs whether the selection ranges have changed. It is changed on true when `LiveRange#change:range` event is fired.
		// @private
		// @member {Array} module:engine/model/liveselection~LiveSelection#_hasChangedRange
		this._hasChangedRange = false;

		// Each overriding gravity adds an UID to the set and each removal removes it.
		// Gravity is overridden when there's at least one UID in the set.
		// Gravity is restored when the set is empty.
		// This is to prevent conflicts when gravity is overridden by more than one feature at the same time.
		// @private
		// @type {Set}
		this._overriddenGravityRegister = new Set();

		// Ensure selection is correct after each operation.
		this.listenTo( this._model, 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation || operation.type == 'marker' || operation.type == 'rename' || operation.type == 'noop' ) {
				return;
			}

			// Fix selection if the last range was removed from it and we have a position to which we can restore the selection.
			if ( this._ranges.length == 0 && this._selectionRestorePosition ) {
				this._fixGraveyardSelection( this._selectionRestorePosition );
			}

			// "Forget" the restore position even if it was not "used".
			this._selectionRestorePosition = null;

			if ( this._hasChangedRange ) {
				this._hasChangedRange = false;
				this.fire( 'change:range', { directChange: false } );
			}
		}, { priority: 'lowest' } );

		// Ensure selection is correct and up to date after each range change.
		this.on( 'change:range', () => {
			for ( const range of this.getRanges() ) {
				if ( !this._document._validateSelectionRange( range ) ) {
					/**
					 * Range from {@link module:engine/model/documentselection~DocumentSelection document selection}
					 * starts or ends at incorrect position.
					 *
					 * @error document-selection-wrong-position
					 * @param {module:engine/model/range~Range} range
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__["default"](
						'document-selection-wrong-position: Range from document selection starts or ends at incorrect position.',
						this,
						{ range }
					);
				}
			}
		} );

		// Update markers data stored by the selection after each marker change.
		this.listenTo( this._model.markers, 'update', () => this._updateMarkers() );

		// Ensure selection is up to date after each change block.
		this.listenTo( this._document, 'change', ( evt, batch ) => {
			clearAttributesStoredInElement( this._model, batch );
		} );
	}

	get isCollapsed() {
		const length = this._ranges.length;

		return length === 0 ? this._document._getDefaultRange().isCollapsed : super.isCollapsed;
	}

	get anchor() {
		return super.anchor || this._document._getDefaultRange().start;
	}

	get focus() {
		return super.focus || this._document._getDefaultRange().end;
	}

	get rangeCount() {
		return this._ranges.length ? this._ranges.length : 1;
	}

	// Describes whether `LiveSelection` has own range(s) set, or if it is defaulted to
	// {@link module:engine/model/document~Document#_getDefaultRange document's default range}.
	//
	// @readonly
	// @type {Boolean}
	get hasOwnRange() {
		return this._ranges.length > 0;
	}

	// When set to `true` then selection attributes on node before the caret won't be taken
	// into consideration while updating selection attributes.
	//
	// @protected
	// @type {Boolean}
	get isGravityOverridden() {
		return !!this._overriddenGravityRegister.size;
	}

	// Unbinds all events previously bound by live selection.
	destroy() {
		for ( let i = 0; i < this._ranges.length; i++ ) {
			this._ranges[ i ].detach();
		}

		this.stopListening();
	}

	* getRanges() {
		if ( this._ranges.length ) {
			yield* super.getRanges();
		} else {
			yield this._document._getDefaultRange();
		}
	}

	getFirstRange() {
		return super.getFirstRange() || this._document._getDefaultRange();
	}

	getLastRange() {
		return super.getLastRange() || this._document._getDefaultRange();
	}

	setTo( selectable, optionsOrPlaceOrOffset, options ) {
		super.setTo( selectable, optionsOrPlaceOrOffset, options );
		this._updateAttributes( true );
		this._updateMarkers();
	}

	setFocus( itemOrPosition, offset ) {
		super.setFocus( itemOrPosition, offset );
		this._updateAttributes( true );
		this._updateMarkers();
	}

	setAttribute( key, value ) {
		if ( this._setAttribute( key, value ) ) {
			// Fire event with exact data.
			const attributeKeys = [ key ];
			this.fire( 'change:attribute', { attributeKeys, directChange: true } );
		}
	}

	removeAttribute( key ) {
		if ( this._removeAttribute( key ) ) {
			// Fire event with exact data.
			const attributeKeys = [ key ];
			this.fire( 'change:attribute', { attributeKeys, directChange: true } );
		}
	}

	overrideGravity() {
		const overrideUid = Object(_ckeditor_ckeditor5_utils_src_uid__WEBPACK_IMPORTED_MODULE_9__["default"])();

		// Remember that another overriding has been requested. It will need to be removed
		// before the gravity is to be restored.
		this._overriddenGravityRegister.add( overrideUid );

		if ( this._overriddenGravityRegister.size === 1 ) {
			this._updateAttributes( true );
		}

		return overrideUid;
	}

	restoreGravity( uid ) {
		if ( !this._overriddenGravityRegister.has( uid ) ) {
			/**
			 * Restoring gravity for an unknown UID is not possible. Make sure you are using a correct
			 * UID obtained from the {@link module:engine/model/writer~Writer#overrideSelectionGravity} to restore.
			 *
			 * @error document-selection-gravity-wrong-restore
			 * @param {String} uid The unique identifier returned by
			 * {@link module:engine/model/documentselection~DocumentSelection#_overrideGravity}.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_8__["default"](
				'document-selection-gravity-wrong-restore: Attempting to restore the selection gravity for an unknown UID.',
				this,
				{ uid }
			);
		}

		this._overriddenGravityRegister.delete( uid );

		// Restore gravity only when all overriding have been restored.
		if ( !this.isGravityOverridden ) {
			this._updateAttributes( true );
		}
	}

	_popRange() {
		this._ranges.pop().detach();
	}

	_pushRange( range ) {
		const liveRange = this._prepareRange( range );

		// `undefined` is returned when given `range` is in graveyard root.
		if ( liveRange ) {
			this._ranges.push( liveRange );
		}
	}

	// Prepares given range to be added to selection. Checks if it is correct,
	// converts it to {@link module:engine/model/liverange~LiveRange LiveRange}
	// and sets listeners listening to the range's change event.
	//
	// @private
	// @param {module:engine/model/range~Range} range
	_prepareRange( range ) {
		this._checkRange( range );

		if ( range.root == this._document.graveyard ) {
			// @if CK_DEBUG // console.warn( 'Trying to add a Range that is in the graveyard root. Range rejected.' );

			return;
		}

		const liveRange = _liverange__WEBPACK_IMPORTED_MODULE_3__["default"].fromRange( range );

		// If selection range is moved to the graveyard remove it from the selection object.
		// Also, save some data that can be used to restore selection later, on `Model#applyOperation` event.
		liveRange.on( 'change:range', ( evt, oldRange, data ) => {
			this._hasChangedRange = true;

			if ( liveRange.root == this._document.graveyard ) {
				this._selectionRestorePosition = data.deletionPosition;

				const index = this._ranges.indexOf( liveRange );
				this._ranges.splice( index, 1 );
				liveRange.detach();
			}
		} );

		return liveRange;
	}

	_updateMarkers() {
		const markers = [];
		let changed = false;

		for ( const marker of this._model.markers ) {
			const markerRange = marker.getRange();

			for ( const selectionRange of this.getRanges() ) {
				if ( markerRange.containsRange( selectionRange, !selectionRange.isCollapsed ) ) {
					markers.push( marker );
				}
			}
		}

		const oldMarkers = Array.from( this.markers );

		for ( const marker of markers ) {
			if ( !this.markers.has( marker ) ) {
				this.markers.add( marker );

				changed = true;
			}
		}

		for ( const marker of Array.from( this.markers ) ) {
			if ( !markers.includes( marker ) ) {
				this.markers.remove( marker );

				changed = true;
			}
		}

		if ( changed ) {
			this.fire( 'change:marker', { oldMarkers, directChange: false } );
		}
	}

	// Updates this selection attributes according to its ranges and the {@link module:engine/model/document~Document model document}.
	//
	// @protected
	// @param {Boolean} clearAll
	// @fires change:attribute
	_updateAttributes( clearAll ) {
		const newAttributes = Object(_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__["default"])( this._getSurroundingAttributes() );
		const oldAttributes = Object(_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_6__["default"])( this.getAttributes() );

		if ( clearAll ) {
			// If `clearAll` remove all attributes and reset priorities.
			this._attributePriority = new Map();
			this._attrs = new Map();
		} else {
			// If not, remove only attributes added with `low` priority.
			for ( const [ key, priority ] of this._attributePriority ) {
				if ( priority == 'low' ) {
					this._attrs.delete( key );
					this._attributePriority.delete( key );
				}
			}
		}

		this._setAttributesTo( newAttributes );

		// Let's evaluate which attributes really changed.
		const changed = [];

		// First, loop through all attributes that are set on selection right now.
		// Check which of them are different than old attributes.
		for ( const [ newKey, newValue ] of this.getAttributes() ) {
			if ( !oldAttributes.has( newKey ) || oldAttributes.get( newKey ) !== newValue ) {
				changed.push( newKey );
			}
		}

		// Then, check which of old attributes got removed.
		for ( const [ oldKey ] of oldAttributes ) {
			if ( !this.hasAttribute( oldKey ) ) {
				changed.push( oldKey );
			}
		}

		// Fire event with exact data (fire only if anything changed).
		if ( changed.length > 0 ) {
			this.fire( 'change:attribute', { attributeKeys: changed, directChange: false } );
		}
	}

	// Internal method for setting `LiveSelection` attribute. Supports attribute priorities (through `directChange`
	// parameter).
	//
	// @private
	// @param {String} key Attribute key.
	// @param {*} value Attribute value.
	// @param {Boolean} [directChange=true] `true` if the change is caused by `Selection` API, `false` if change
	// is caused by `Batch` API.
	// @returns {Boolean} Whether value has changed.
	_setAttribute( key, value, directChange = true ) {
		const priority = directChange ? 'normal' : 'low';

		if ( priority == 'low' && this._attributePriority.get( key ) == 'normal' ) {
			// Priority too low.
			return false;
		}

		const oldValue = super.getAttribute( key );

		// Don't do anything if value has not changed.
		if ( oldValue === value ) {
			return false;
		}

		this._attrs.set( key, value );

		// Update priorities map.
		this._attributePriority.set( key, priority );

		return true;
	}

	// Internal method for removing `LiveSelection` attribute. Supports attribute priorities (through `directChange`
	// parameter).
	//
	// NOTE: Even if attribute is not present in the selection but is provided to this method, it's priority will
	// be changed according to `directChange` parameter.
	//
	// @private
	// @param {String} key Attribute key.
	// @param {Boolean} [directChange=true] `true` if the change is caused by `Selection` API, `false` if change
	// is caused by `Batch` API.
	// @returns {Boolean} Whether attribute was removed. May not be true if such attributes didn't exist or the
	// existing attribute had higher priority.
	_removeAttribute( key, directChange = true ) {
		const priority = directChange ? 'normal' : 'low';

		if ( priority == 'low' && this._attributePriority.get( key ) == 'normal' ) {
			// Priority too low.
			return false;
		}

		// Update priorities map.
		this._attributePriority.set( key, priority );

		// Don't do anything if value has not changed.
		if ( !super.hasAttribute( key ) ) {
			return false;
		}

		this._attrs.delete( key );

		return true;
	}

	// Internal method for setting multiple `LiveSelection` attributes. Supports attribute priorities (through
	// `directChange` parameter).
	//
	// @private
	// @param {Map.<String,*>} attrs Iterable object containing attributes to be set.
	// @returns {Set.<String>} Changed attribute keys.
	_setAttributesTo( attrs ) {
		const changed = new Set();

		for ( const [ oldKey, oldValue ] of this.getAttributes() ) {
			// Do not remove attribute if attribute with same key and value is about to be set.
			if ( attrs.get( oldKey ) === oldValue ) {
				continue;
			}

			// All rest attributes will be removed so changed attributes won't change .
			this._removeAttribute( oldKey, false );
		}

		for ( const [ key, value ] of attrs ) {
			// Attribute may not be set because of attributes or because same key/value is already added.
			const gotAdded = this._setAttribute( key, value, false );

			if ( gotAdded ) {
				changed.add( key );
			}
		}

		return changed;
	}

	// Returns an iterable that iterates through all selection attributes stored in current selection's parent.
	//
	// @protected
	// @returns {Iterable.<*>}
	* _getStoredAttributes() {
		const selectionParent = this.getFirstPosition().parent;

		if ( this.isCollapsed && selectionParent.isEmpty ) {
			for ( const key of selectionParent.getAttributeKeys() ) {
				if ( key.startsWith( storePrefix ) ) {
					const realKey = key.substr( storePrefix.length );

					yield [ realKey, selectionParent.getAttribute( key ) ];
				}
			}
		}
	}

	// Checks model text nodes that are closest to the selection's first position and returns attributes of first
	// found element. If there are no text nodes in selection's first position parent, it returns selection
	// attributes stored in that parent.
	//
	// @private
	// @returns {Iterable.<*>} Collection of attributes.
	_getSurroundingAttributes() {
		const position = this.getFirstPosition();
		const schema = this._model.schema;

		let attrs = null;

		if ( !this.isCollapsed ) {
			// 1. If selection is a range...
			const range = this.getFirstRange();

			// ...look for a first character node in that range and take attributes from it.
			for ( const value of range ) {
				// If the item is an object, we don't want to get attributes from its children.
				if ( value.item.is( 'element' ) && schema.isObject( value.item ) ) {
					break;
				}

				if ( value.type == 'text' ) {
					attrs = value.item.getAttributes();
					break;
				}
			}
		} else {
			// 2. If the selection is a caret or the range does not contain a character node...

			const nodeBefore = position.textNode ? position.textNode : position.nodeBefore;
			const nodeAfter = position.textNode ? position.textNode : position.nodeAfter;

			// When gravity is overridden then don't take node before into consideration.
			if ( !this.isGravityOverridden ) {
				// ...look at the node before caret and take attributes from it if it is a character node.
				attrs = getAttrsIfCharacter( nodeBefore );
			}

			// 3. If not, look at the node after caret...
			if ( !attrs ) {
				attrs = getAttrsIfCharacter( nodeAfter );
			}

			// 4. If not, try to find the first character on the left, that is in the same node.
			// When gravity is overridden then don't take node before into consideration.
			if ( !this.isGravityOverridden && !attrs ) {
				let node = nodeBefore;

				while ( node && !attrs ) {
					node = node.previousSibling;
					attrs = getAttrsIfCharacter( node );
				}
			}

			// 5. If not found, try to find the first character on the right, that is in the same node.
			if ( !attrs ) {
				let node = nodeAfter;

				while ( node && !attrs ) {
					node = node.nextSibling;
					attrs = getAttrsIfCharacter( node );
				}
			}

			// 6. If not found, selection should retrieve attributes from parent.
			if ( !attrs ) {
				attrs = this._getStoredAttributes();
			}
		}

		return attrs;
	}

	// Fixes the selection after all its ranges got removed.
	//
	// @private
	// @param {module:engine/model/position~Position} deletionPosition Position where the deletion happened.
	_fixGraveyardSelection( deletionPosition ) {
		// Find a range that is a correct selection range and is closest to the position where the deletion happened.
		const selectionRange = this._model.schema.getNearestSelectionRange( deletionPosition );

		// If nearest valid selection range has been found - add it in the place of old range.
		if ( selectionRange ) {
			// Check the range, convert it to live range, bind events, etc.
			this._pushRange( selectionRange );
		}
		// If nearest valid selection range cannot be found don't add any range. Selection will be set to the default range.
	}
}

// Helper function for {@link module:engine/model/liveselection~LiveSelection#_updateAttributes}.
//
// It takes model item, checks whether it is a text node (or text proxy) and, if so, returns it's attributes. If not, returns `null`.
//
// @param {module:engine/model/item~Item|null}  node
// @returns {Boolean}
function getAttrsIfCharacter( node ) {
	if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_5__["default"] || node instanceof _text__WEBPACK_IMPORTED_MODULE_4__["default"] ) {
		return node.getAttributes();
	}

	return null;
}

// Removes selection attributes from element which is not empty anymore.
//
// @param {module:engine/model/model~Model} model
// @param {module:engine/model/batch~Batch} batch
function clearAttributesStoredInElement( model, batch ) {
	const differ = model.document.differ;

	for ( const entry of differ.getChanges() ) {
		if ( entry.type != 'insert' ) {
			continue;
		}

		const changeParent = entry.position.parent;
		const isNoLongerEmpty = entry.length === changeParent.maxOffset;

		if ( isNoLongerEmpty ) {
			model.enqueueChange( batch, writer => {
				const storedAttributes = Array.from( changeParent.getAttributeKeys() )
					.filter( key => key.startsWith( storePrefix ) );

				for ( const key of storedAttributes ) {
					writer.removeAttribute( key, changeParent );
				}
			} );
		}
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Element; });
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/node.js");
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./nodelist */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./text */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _textproxy__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./textproxy */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/textproxy.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/isiterable */ "./node_modules/@ckeditor/ckeditor5-utils/src/isiterable.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/element
 */







// @if CK_DEBUG_ENGINE // const { stringifyMap, convertMapToStringifiedObject, convertMapToTags } = require( '../dev-utils/utils' );

/**
 * Model element. Type of {@link module:engine/model/node~Node node} that has a {@link module:engine/model/element~Element#name name} and
 * {@link module:engine/model/element~Element#getChildren child nodes}.
 *
 * **Important**: see {@link module:engine/model/node~Node} to read about restrictions using `Element` and `Node` API.
 *
 * @extends module:engine/model/node~Node
 */
class Element extends _node__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a model element.
	 *
	 * **Note:** Constructor of this class shouldn't be used directly in the code.
	 * Use the {@link module:engine/model/writer~Writer#createElement} method instead.
	 *
	 * @protected
	 * @param {String} name Element's name.
	 * @param {Object} [attrs] Element's attributes. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 * @param {module:engine/model/node~Node|Iterable.<module:engine/model/node~Node>} [children]
	 * One or more nodes to be inserted as children of created element.
	 */
	constructor( name, attrs, children ) {
		super( attrs );

		/**
		 * Element name.
		 *
		 * @readonly
		 * @member {String} module:engine/model/element~Element#name
		 */
		this.name = name;

		/**
		 * List of children nodes.
		 *
		 * @private
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/element~Element#_children
		 */
		this._children = new _nodelist__WEBPACK_IMPORTED_MODULE_1__["default"]();

		if ( children ) {
			this._insertChild( 0, children );
		}
	}

	/**
	 * Number of this element's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get childCount() {
		return this._children.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all of this element's children.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._children.maxOffset;
	}

	/**
	 * Is `true` if there are no nodes inside this element, `false` otherwise.
	 *
	 * @readonly
	 * @type {Boolean}
	 */
	get isEmpty() {
		return this.childCount === 0;
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		element.is( 'element' ); // -> true
	 *		element.is( 'node' ); // -> true
	 *		element.is( 'model:element' ); // -> true
	 *		element.is( 'model:node' ); // -> true
	 *
	 *		element.is( 'view:element' ); // -> false
	 *		element.is( 'documentSelection' ); // -> false
	 *
	 * Assuming that the object being checked is an element, you can also check its
	 * {@link module:engine/model/element~Element#name name}:
	 *
	 *		element.is( 'element', 'image' ); // -> true if this is an <image> element
	 *		element.is( 'element', 'image' ); // -> same as above
	 *		text.is( 'element', 'image' ); -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type Type to check.
	 * @param {String} [name] Element name.
	 * @returns {Boolean}
	 */
	is( type, name = null ) {
		if ( !name ) {
			return type === 'element' || type === 'model:element' ||
				// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
				type === 'node' || type === 'model:node';
		}

		return name === this.name && ( type === 'element' || type === 'model:element' );
	}

	/**
	 * Gets the child at the given index.
	 *
	 * @param {Number} index Index of child.
	 * @returns {module:engine/model/node~Node} Child node.
	 */
	getChild( index ) {
		return this._children.getNode( index );
	}

	/**
	 * Returns an iterator that iterates over all of this element's children.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	getChildren() {
		return this._children[ Symbol.iterator ]();
	}

	/**
	 * Returns an index of the given child node. Returns `null` if given node is not a child of this element.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number} Child node's index in this element.
	 */
	getChildIndex( node ) {
		return this._children.getNodeIndex( node );
	}

	/**
	 * Returns the starting offset of given child. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all node's siblings that are before it. Returns `null` if
	 * given node is not a child of this element.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number} Child node's starting offset.
	 */
	getChildStartOffset( node ) {
		return this._children.getNodeStartOffset( node );
	}

	/**
	 * Returns index of a node that occupies given offset. If given offset is too low, returns `0`. If given offset is
	 * too high, returns {@link module:engine/model/element~Element#getChildIndex index after last child}.
	 *
	 *		const textNode = new Text( 'foo' );
	 *		const pElement = new Element( 'p' );
	 *		const divElement = new Element( [ textNode, pElement ] );
	 *		divElement.offsetToIndex( -1 ); // Returns 0, because offset is too low.
	 *		divElement.offsetToIndex( 0 ); // Returns 0, because offset 0 is taken by `textNode` which is at index 0.
	 *		divElement.offsetToIndex( 1 ); // Returns 0, because `textNode` has `offsetSize` equal to 3, so it occupies offset 1 too.
	 *		divElement.offsetToIndex( 2 ); // Returns 0.
	 *		divElement.offsetToIndex( 3 ); // Returns 1.
	 *		divElement.offsetToIndex( 4 ); // Returns 2. There are no nodes at offset 4, so last available index is returned.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number}
	 */
	offsetToIndex( offset ) {
		return this._children.offsetToIndex( offset );
	}

	/**
	 * Returns a descendant node by its path relative to this element.
	 *
	 *		// <this>a<b>c</b></this>
	 *		this.getNodeByPath( [ 0 ] );     // -> "a"
	 *		this.getNodeByPath( [ 1 ] );     // -> <b>
	 *		this.getNodeByPath( [ 1, 0 ] );  // -> "c"
	 *
	 * @param {Array.<Number>} relativePath Path of the node to find, relative to this element.
	 * @returns {module:engine/model/node~Node}
	 */
	getNodeByPath( relativePath ) {
		let node = this; // eslint-disable-line consistent-this

		for ( const index of relativePath ) {
			node = node.getChild( node.offsetToIndex( index ) );
		}

		return node;
	}

	/**
	 * Returns the parent element of the given name. Returns null if the element is not inside the desired parent.
	 *
	 * @param {String} parentName The name of the parent element to find.
	 * @param {Object} [options] Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` this node will be also included while searching.
	 * @returns {module:engine/model/element~Element|null}
	 */
	findAncestor( parentName, options = { includeSelf: false } ) {
		let parent = options.includeSelf ? this : this.parent;

		while ( parent ) {
			if ( parent.name === parentName ) {
				return parent;
			}

			parent = parent.parent;
		}

		return null;
	}

	/**
	 * Converts `Element` instance to plain object and returns it. Takes care of converting all of this element's children.
	 *
	 * @returns {Object} `Element` instance converted to plain object.
	 */
	toJSON() {
		const json = super.toJSON();

		json.name = this.name;

		if ( this._children.length > 0 ) {
			json.children = [];

			for ( const node of this._children ) {
				json.children.push( node.toJSON() );
			}
		}

		return json;
	}

	/**
	 * Creates a copy of this element and returns it. Created element has the same name and attributes as the original element.
	 * If clone is deep, the original element's children are also cloned. If not, then empty element is returned.
	 *
	 * @protected
	 * @param {Boolean} [deep=false] If set to `true` clones element and all its children recursively. When set to `false`,
	 * element will be cloned without any child.
	 */
	_clone( deep = false ) {
		const children = deep ? Array.from( this._children ).map( node => node._clone( true ) ) : null;

		return new Element( this.name, this.getAttributes(), children );
	}

	/**
	 * {@link module:engine/model/element~Element#_insertChild Inserts} one or more nodes at the end of this element.
	 *
	 * @see module:engine/model/writer~Writer#append
	 * @protected
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} nodes Nodes to be inserted.
	 */
	_appendChild( nodes ) {
		this._insertChild( this.childCount, nodes );
	}

	/**
	 * Inserts one or more nodes at the given index and sets {@link module:engine/model/node~Node#parent parent} of these nodes
	 * to this element.
	 *
	 * @see module:engine/model/writer~Writer#insert
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {module:engine/model/item~Item|Iterable.<module:engine/model/item~Item>} items Items to be inserted.
	 */
	_insertChild( index, items ) {
		const nodes = normalize( items );

		for ( const node of nodes ) {
			// If node that is being added to this element is already inside another element, first remove it from the old parent.
			if ( node.parent !== null ) {
				node._remove();
			}

			node.parent = this;
		}

		this._children._insertNodes( index, nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index and sets
	 * {@link module:engine/model/node~Node#parent parent} of these nodes to `null`.
	 *
	 * @see module:engine/model/writer~Writer#remove
	 * @protected
	 * @param {Number} index Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeChildren( index, howMany = 1 ) {
		const nodes = this._children._removeNodes( index, howMany );

		for ( const node of nodes ) {
			node.parent = null;
		}

		return nodes;
	}

	/**
	 * Creates an `Element` instance from given plain object (i.e. parsed JSON string).
	 * Converts `Element` children to proper nodes.
	 *
	 * @param {Object} json Plain object to be converted to `Element`.
	 * @returns {module:engine/model/element~Element} `Element` instance created using given plain object.
	 */
	static fromJSON( json ) {
		let children = null;

		if ( json.children ) {
			children = [];

			for ( const child of json.children ) {
				if ( child.name ) {
					// If child has name property, it is an Element.
					children.push( Element.fromJSON( child ) );
				} else {
					// Otherwise, it is a Text node.
					children.push( _text__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( child ) );
				}
			}
		}

		return new Element( json.name, json.attributes, children );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `<${ this.rootName || this.name }>`;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( 'ModelElement: ' + this );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logExtended() {
	// @if CK_DEBUG_ENGINE // 	console.log( `ModelElement: ${ this }, ${ this.childCount } children,
	// @if CK_DEBUG_ENGINE //		attrs: ${ convertMapToStringifiedObject( this.getAttributes() ) }` );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logAll() {
	// @if CK_DEBUG_ENGINE // 	console.log( '--------------------' );
	// @if CK_DEBUG_ENGINE //
	// @if CK_DEBUG_ENGINE // 	this.logExtended();
	// @if CK_DEBUG_ENGINE //	console.log( 'List of children:' );
	// @if CK_DEBUG_ENGINE //
	// @if CK_DEBUG_ENGINE // 	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE // 		child.log();
	// @if CK_DEBUG_ENGINE // 	}
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // printTree( level = 0) {
	// @if CK_DEBUG_ENGINE // 	let string = '';

	// @if CK_DEBUG_ENGINE // 	string += '\t'.repeat( level );
	// @if CK_DEBUG_ENGINE // 	string += `<${ this.rootName || this.name }${ convertMapToTags( this.getAttributes() ) }>`;

	// @if CK_DEBUG_ENGINE // 	for ( const child of this.getChildren() ) {
	// @if CK_DEBUG_ENGINE // 		string += '\n';

	// @if CK_DEBUG_ENGINE // 		if ( child.is( '$text' ) ) {
	// @if CK_DEBUG_ENGINE // 			const textAttrs = convertMapToTags( child._attrs );

	// @if CK_DEBUG_ENGINE // 			string += '\t'.repeat( level + 1 );

	// @if CK_DEBUG_ENGINE // 			if ( textAttrs !== '' ) {
	// @if CK_DEBUG_ENGINE // 				string += `<$text${ textAttrs }>` + child.data + '</$text>';
	// @if CK_DEBUG_ENGINE // 			} else {
	// @if CK_DEBUG_ENGINE // 				string += child.data;
	// @if CK_DEBUG_ENGINE // 			}
	// @if CK_DEBUG_ENGINE // 		} else {
	// @if CK_DEBUG_ENGINE // 			string += child.printTree( level + 1 );
	// @if CK_DEBUG_ENGINE // 		}
	// @if CK_DEBUG_ENGINE // 	}

	// @if CK_DEBUG_ENGINE // 	if ( this.childCount ) {
	// @if CK_DEBUG_ENGINE // 		string += '\n' + '\t'.repeat( level );
	// @if CK_DEBUG_ENGINE // 	}

	// @if CK_DEBUG_ENGINE // 	string += `</${ this.rootName || this.name }>`;

	// @if CK_DEBUG_ENGINE // 	return string;
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // logTree() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.printTree() );
	// @if CK_DEBUG_ENGINE // }
}

// Converts strings to Text and non-iterables to arrays.
//
// @param {String|module:engine/model/item~Item|Iterable.<String|module:engine/model/item~Item>}
// @returns {Iterable.<module:engine/model/node~Node>}
function normalize( nodes ) {
	// Separate condition because string is iterable.
	if ( typeof nodes == 'string' ) {
		return [ new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( nodes ) ];
	}

	if ( !Object(_ckeditor_ckeditor5_utils_src_isiterable__WEBPACK_IMPORTED_MODULE_4__["default"])( nodes ) ) {
		nodes = [ nodes ];
	}

	// Array.from to enable .map() on non-arrays.
	return Array.from( nodes )
		.map( node => {
			if ( typeof node == 'string' ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node );
			}

			if ( node instanceof _textproxy__WEBPACK_IMPORTED_MODULE_3__["default"] ) {
				return new _text__WEBPACK_IMPORTED_MODULE_2__["default"]( node.data, node.getAttributes() );
			}

			return node;
		} );
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/history.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/history.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return History; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/history
 */

/**
 * `History` keeps the track of all the operations applied to the {@link module:engine/model/document~Document document}.
 */
class History {
	/**
	 * Creates an empty History instance.
	 */
	constructor() {
		/**
		 * Operations added to the history.
		 *
		 * @protected
		 * @member {Array.<module:engine/model/operation/operation~Operation>} module:engine/model/history~History#_operations
		 */
		this._operations = [];

		/**
		 * Holds an information which {@link module:engine/model/operation/operation~Operation operation} undoes which
		 * {@link module:engine/model/operation/operation~Operation operation}.
		 *
		 * Keys of the map are "undoing operations", that is operations that undone some other operations. For each key, the
		 * value is an operation that has been undone by the "undoing operation".
		 *
		 * @private
		 * @member {Map} module:engine/model/history~History#_undoPairs
		 */
		this._undoPairs = new Map();

		/**
		 * Holds all undone operations.
		 *
		 * @private
		 * @member {Set.<module:engine/model/operation/operation~Operation>} module:engine/model/history~History#_undoneOperations
		 */
		this._undoneOperations = new Set();
	}

	/**
	 * Adds an operation to the history.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to add.
	 */
	addOperation( operation ) {
		if ( this._operations.includes( operation ) ) {
			return;
		}

		this._operations.push( operation );
	}

	/**
	 * Returns operations added to the history.
	 *
	 * @param {Number} [from=0] Base version from which operations should be returned (inclusive). Defaults to `0`, which means
	 * that operations from the first one will be returned.
	 * @param {Number} [to=Number.POSITIVE_INFINITY] Base version up to which operations should be returned (exclusive).
	 * Defaults to `Number.POSITIVE_INFINITY` which means that operations up to the last one will be returned.
	 * @returns {Iterable.<module:engine/model/operation/operation~Operation>} Operations added to the history.
	 */
	getOperations( from = 0, to = Number.POSITIVE_INFINITY ) {
		if ( from < 0 ) {
			return [];
		}

		return this._operations.slice( from, to );
	}

	/**
	 * Returns operation from the history that bases on given `baseVersion`.
	 *
	 * @param {Number} baseVersion Base version of the operation to get.
	 * @returns {module:engine/model/operation/operation~Operation|null} Operation with given base version or `null` if
	 * there is no such operation in history.
	 */
	getOperation( baseVersion ) {
		return this._operations[ baseVersion ];
	}

	/**
	 * Marks in history that one operation is an operation that is undoing the other operation. By marking operation this way,
	 * history is keeping more context information about operations, which helps in operational transformation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} undoneOperation Operation which is undone by `undoingOperation`.
	 * @param {module:engine/model/operation/operation~Operation} undoingOperation Operation which undoes `undoneOperation`.
	 */
	setOperationAsUndone( undoneOperation, undoingOperation ) {
		this._undoPairs.set( undoingOperation, undoneOperation );
		this._undoneOperations.add( undoneOperation );
	}

	/**
	 * Checks whether given `operation` is undoing any other operation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to check.
	 * @returns {Boolean} `true` if given `operation` is undoing any other operation, `false` otherwise.
	 */
	isUndoingOperation( operation ) {
		return this._undoPairs.has( operation );
	}

	/**
	 * Checks whether given `operation` has been undone by any other operation.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation Operation to check.
	 * @returns {Boolean} `true` if given `operation` has been undone any other operation, `false` otherwise.
	 */
	isUndoneOperation( operation ) {
		return this._undoneOperations.has( operation );
	}

	/**
	 * For given `undoingOperation`, returns the operation which has been undone by it.
	 *
	 * @param {module:engine/model/operation/operation~Operation} undoingOperation
	 * @returns {module:engine/model/operation/operation~Operation|undefined} Operation that has been undone by given
	 * `undoingOperation` or `undefined` if given `undoingOperation` is not undoing any other operation.
	 */
	getUndoneOperation( undoingOperation ) {
		return this._undoPairs.get( undoingOperation );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/liveposition.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/liveposition.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return LivePosition; });
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/liveposition
 */






/**
 * `LivePosition` is a type of {@link module:engine/model/position~Position Position}
 * that updates itself as {@link module:engine/model/document~Document document}
 * is changed through operations. It may be used as a bookmark.
 *
 * **Note:** Contrary to {@link module:engine/model/position~Position}, `LivePosition` works only in roots that are
 * {@link module:engine/model/rootelement~RootElement}.
 * If {@link module:engine/model/documentfragment~DocumentFragment} is passed, error will be thrown.
 *
 * **Note:** Be very careful when dealing with `LivePosition`. Each `LivePosition` instance bind events that might
 * have to be unbound.
 * Use {@link module:engine/model/liveposition~LivePosition#detach} whenever you don't need `LivePosition` anymore.
 *
 * @extends module:engine/model/position~Position
 */
class LivePosition extends _position__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a live position.
	 *
	 * @see module:engine/model/position~Position
	 * @param {module:engine/model/rootelement~RootElement} root
	 * @param {Array.<Number>} path
	 * @param {module:engine/model/position~PositionStickiness} [stickiness]
	 */
	constructor( root, path, stickiness = 'toNone' ) {
		super( root, path, stickiness );

		if ( !this.root.is( 'rootElement' ) ) {
			/**
			 * LivePosition's root has to be an instance of RootElement.
			 *
			 * @error liveposition-root-not-rootelement
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
				'model-liveposition-root-not-rootelement: LivePosition\'s root has to be an instance of RootElement.',
				root
			);
		}

		bindWithDocument.call( this );
	}

	/**
	 * Unbinds all events previously bound by `LivePosition`. Use it whenever you don't need `LivePosition` instance
	 * anymore (i.e. when leaving scope in which it was declared or before re-assigning variable that was
	 * referring to it).
	 */
	detach() {
		this.stopListening();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		livePosition.is( 'position' ); // -> true
	 *		livePosition.is( 'model:position' ); // -> true
	 *		livePosition.is( 'liveposition' ); // -> true
	 *		livePosition.is( 'model:livePosition' ); // -> true
	 *
	 *		livePosition.is( 'view:position' ); // -> false
	 *		livePosition.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'livePosition' || type === 'model:livePosition' ||
			// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
			type == 'position' || type === 'model:position';
	}

	/**
	 * Creates a {@link module:engine/model/position~Position position instance}, which is equal to this live position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	toPosition() {
		return new _position__WEBPACK_IMPORTED_MODULE_0__["default"]( this.root, this.path.slice(), this.stickiness );
	}

	/**
	 * Creates a `LivePosition` instance that is equal to position.
	 *
	 * @param {module:engine/model/position~Position} position
	 * @param {module:engine/model/position~PositionStickiness} [stickiness]
	 * @returns {module:engine/model/position~Position}
	 */
	static fromPosition( position, stickiness ) {
		return new this( position.root, position.path.slice(), stickiness ? stickiness : position.stickiness );
	}

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createAfter
	 * @see module:engine/model/position~Position._createAfter
	 * @param {module:engine/model/node~Node} node
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createBefore
	 * @see module:engine/model/position~Position._createBefore
	 * @param {module:engine/model/node~Node} node
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * @static
	 * @protected
	 * @method module:engine/model/liveposition~LivePosition._createAt
	 * @see module:engine/model/position~Position._createAt
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset]
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone']
	 * @returns {module:engine/model/liveposition~LivePosition}
	 */

	/**
	 * Fired when `LivePosition` instance is changed due to changes on {@link module:engine/model/document~Document}.
	 *
	 * @event module:engine/model/liveposition~LivePosition#change
	 * @param {module:engine/model/position~Position} oldPosition Position equal to this live position before it got changed.
	 */
}

// Binds this `LivePosition` to the {@link module:engine/model/document~Document document} that owns
// this position's {@link module:engine/model/position~Position#root root}.
//
// @private
function bindWithDocument() {
	this.listenTo(
		this.root.document.model,
		'applyOperation',
		( event, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation ) {
				return;
			}

			transform.call( this, operation );
		},
		{ priority: 'low' }
	);
}

// Updates this position accordingly to the updates applied to the model. Bases on change events.
//
// @private
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
function transform( operation ) {
	const result = this.getTransformedByOperation( operation );

	if ( !this.isEqual( result ) ) {
		const oldPosition = this.toPosition();

		this.path = result.path;
		this.root = result.root;

		this.fire( 'change', oldPosition );
	}
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( LivePosition, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js":
/*!************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js ***!
  \************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return LiveRange; });
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/liverange
 */





/**
 * `LiveRange` is a type of {@link module:engine/model/range~Range Range}
 * that updates itself as {@link module:engine/model/document~Document document}
 * is changed through operations. It may be used as a bookmark.
 *
 * **Note:** Be very careful when dealing with `LiveRange`. Each `LiveRange` instance bind events that might
 * have to be unbound. Use {@link module:engine/model/liverange~LiveRange#detach detach} whenever you don't need `LiveRange` anymore.
 */
class LiveRange extends _range__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a live range.
	 *
	 * @see module:engine/model/range~Range
	 */
	constructor( start, end ) {
		super( start, end );

		bindWithDocument.call( this );
	}

	/**
	 * Unbinds all events previously bound by `LiveRange`. Use it whenever you don't need `LiveRange` instance
	 * anymore (i.e. when leaving scope in which it was declared or before re-assigning variable that was
	 * referring to it).
	 */
	detach() {
		this.stopListening();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		liveRange.is( 'range' ); // -> true
	 *		liveRange.is( 'model:range' ); // -> true
	 *		liveRange.is( 'liveRange' ); // -> true
	 *		liveRange.is( 'model:liveRange' ); // -> true
	 *
	 *		liveRange.is( 'view:range' ); // -> false
	 *		liveRange.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'liveRange' || type === 'model:liveRange' ||
			// From super.is(). This is highly utilised method and cannot call super. See ckeditor/ckeditor5#6529.
			type == 'range' || type === 'model:range';
	}

	/**
	 * Creates a {@link module:engine/model/range~Range range instance} that is equal to this live range.
	 *
	 * @returns {module:engine/model/range~Range}
	 */
	toRange() {
		return new _range__WEBPACK_IMPORTED_MODULE_0__["default"]( this.start, this.end );
	}

	/**
	 * Creates a `LiveRange` instance that is equal to the given range.
	 *
	 * @param {module:engine/model/range~Range} range
	 * @returns {module:engine/model/liverange~LiveRange}
	 */
	static fromRange( range ) {
		return new LiveRange( range.start, range.end );
	}

	/**
	 * @see module:engine/model/range~Range._createIn
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createIn
	 * @param {module:engine/model/element~Element} element
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * @see module:engine/model/range~Range._createOn
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createOn
	 * @param {module:engine/model/element~Element} element
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * @see module:engine/model/range~Range._createFromPositionAndShift
	 * @static
	 * @protected
	 * @method module:engine/model/liverange~LiveRange._createFromPositionAndShift
	 * @param {module:engine/model/position~Position} position
	 * @param {Number} shift
	 * @returns {module:engine/model/liverange~LiveRange}
	 */

	/**
	 * Fired when `LiveRange` instance boundaries have changed due to changes in the
	 * {@link module:engine/model/document~Document document}.
	 *
	 * @event change:range
	 * @param {module:engine/model/range~Range} oldRange Range with start and end position equal to start and end position of this live
	 * range before it got changed.
	 * @param {Object} data Object with additional information about the change.
	 * @param {module:engine/model/position~Position|null} data.deletionPosition Source position for remove and merge changes.
	 * Available if the range was moved to the graveyard root, `null` otherwise.
	 */

	/**
	 * Fired when `LiveRange` instance boundaries have not changed after a change in {@link module:engine/model/document~Document document}
	 * but the change took place inside the range, effectively changing its content.
	 *
	 * @event change:content
	 * @param {module:engine/model/range~Range} range Range with start and end position equal to start and end position of
	 * change range.
	 * @param {Object} data Object with additional information about the change.
	 * @param {null} data.deletionPosition Due to the nature of this event, this property is always set to `null`. It is passed
	 * for compatibility with the {@link module:engine/model/liverange~LiveRange#event:change:range} event.
	 */
}

// Binds this `LiveRange` to the {@link module:engine/model/document~Document document}
// that owns this range's {@link module:engine/model/range~Range#root root}.
//
// @private
function bindWithDocument() {
	this.listenTo(
		this.root.document.model,
		'applyOperation',
		( event, args ) => {
			const operation = args[ 0 ];

			if ( !operation.isDocumentOperation ) {
				return;
			}

			transform.call( this, operation );
		},
		{ priority: 'low' }
	);
}

// Updates this range accordingly to the updates applied to the model. Bases on change events.
//
// @private
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
function transform( operation ) {
	// Transform the range by the operation. Join the result ranges if needed.
	const ranges = this.getTransformedByOperation( operation );
	const result = _range__WEBPACK_IMPORTED_MODULE_0__["default"]._createFromRanges( ranges );

	const boundariesChanged = !result.isEqual( this );
	const contentChanged = doesOperationChangeRangeContent( this, operation );

	let deletionPosition = null;

	if ( boundariesChanged ) {
		// If range boundaries have changed, fire `change:range` event.
		//
		if ( result.root.rootName == '$graveyard' ) {
			// If the range was moved to the graveyard root, set `deletionPosition`.
			if ( operation.type == 'remove' ) {
				deletionPosition = operation.sourcePosition;
			} else {
				// Merge operation.
				deletionPosition = operation.deletionPosition;
			}
		}

		const oldRange = this.toRange();

		this.start = result.start;
		this.end = result.end;

		this.fire( 'change:range', oldRange, { deletionPosition } );
	} else if ( contentChanged ) {
		// If range boundaries have not changed, but there was change inside the range, fire `change:content` event.
		this.fire( 'change:content', this.toRange(), { deletionPosition } );
	}
}

// Checks whether given operation changes something inside the range (even if it does not change boundaries).
//
// @private
// @param {module:engine/model/range~Range} range Range to check.
// @param {module:engine/model/operation/operation~Operation} operation Executed operation.
// @returns {Boolean}
function doesOperationChangeRangeContent( range, operation ) {
	switch ( operation.type ) {
		case 'insert':
			return range.containsPosition( operation.position );
		case 'move':
		case 'remove':
		case 'reinsert':
		case 'merge':
			return range.containsPosition( operation.sourcePosition ) ||
				range.start.isEqual( operation.sourcePosition ) ||
				range.containsPosition( operation.targetPosition );
		case 'split':
			return range.containsPosition( operation.splitPosition ) || range.containsPosition( operation.insertionPosition );
	}

	return false;
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_2__["default"])( LiveRange, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MarkerCollection; });
/* harmony import */ var _liverange__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./liverange */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/liverange.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/emittermixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/emittermixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/markercollection
 */






/**
 * The collection of all {@link module:engine/model/markercollection~Marker markers} attached to the document.
 * It lets you {@link module:engine/model/markercollection~MarkerCollection#get get} markers or track them using
 * {@link module:engine/model/markercollection~MarkerCollection#event:update} event.
 *
 * To create, change or remove makers use {@link module:engine/model/writer~Writer model writers'} methods:
 * {@link module:engine/model/writer~Writer#addMarker} or {@link module:engine/model/writer~Writer#removeMarker}. Since
 * the writer is the only proper way to change the data model it is not possible to change markers directly using this
 * collection. All markers created by the writer will be automatically added to this collection.
 *
 * By default there is one marker collection available as {@link module:engine/model/model~Model#markers model property}.
 *
 * @see module:engine/model/markercollection~Marker
 */
class MarkerCollection {
	/**
	 * Creates a markers collection.
	 */
	constructor() {
		/**
		 * Stores {@link ~Marker markers} added to the collection.
		 *
		 * @private
		 * @member {Map} #_markers
		 */
		this._markers = new Map();
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all {@link ~Marker markers} added to the collection.
	 *
	 * @returns {Iterable}
	 */
	[ Symbol.iterator ]() {
		return this._markers.values();
	}

	/**
	 * Checks if marker with given `markerName` is in the collection.
	 *
	 * @param {String} markerName Marker name.
	 * @returns {Boolean} `true` if marker with given `markerName` is in the collection, `false` otherwise.
	 */
	has( markerName ) {
		return this._markers.has( markerName );
	}

	/**
	 * Returns {@link ~Marker marker} with given `markerName`.
	 *
	 * @param {String} markerName Name of marker to get.
	 * @returns {module:engine/model/markercollection~Marker|null} Marker with given name or `null` if such marker was
	 * not added to the collection.
	 */
	get( markerName ) {
		return this._markers.get( markerName ) || null;
	}

	/**
	 * Creates and adds a {@link ~Marker marker} to the `MarkerCollection` with given name on given
	 * {@link module:engine/model/range~Range range}.
	 *
	 * If `MarkerCollection` already had a marker with given name (or {@link ~Marker marker} was passed), the marker in
	 * collection is updated and {@link module:engine/model/markercollection~MarkerCollection#event:update} event is fired
	 * but only if there was a change (marker range or {@link module:engine/model/markercollection~Marker#managedUsingOperations}
	 * flag has changed.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String|module:engine/model/markercollection~Marker} markerOrName Name of marker to set or marker instance to update.
	 * @param {module:engine/model/range~Range} range Marker range.
	 * @param {Boolean} [managedUsingOperations=false] Specifies whether the marker is managed using operations.
	 * @param {Boolean} [affectsData=false] Specifies whether the marker affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 * @returns {module:engine/model/markercollection~Marker} `Marker` instance which was added or updated.
	 */
	_set( markerOrName, range, managedUsingOperations = false, affectsData = false ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;

		if ( markerName.includes( ',' ) ) {
			/**
			 * Marker name cannot contain the "," character.
			 *
			 * @error markercollection-incorrect-marker-name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'markercollection-incorrect-marker-name: Marker name cannot contain "," character.', this );
		}

		const oldMarker = this._markers.get( markerName );

		if ( oldMarker ) {
			const oldRange = oldMarker.getRange();
			let hasChanged = false;

			if ( !oldRange.isEqual( range ) ) {
				oldMarker._attachLiveRange( _liverange__WEBPACK_IMPORTED_MODULE_0__["default"].fromRange( range ) );
				hasChanged = true;
			}

			if ( managedUsingOperations != oldMarker.managedUsingOperations ) {
				oldMarker._managedUsingOperations = managedUsingOperations;
				hasChanged = true;
			}

			if ( typeof affectsData === 'boolean' && affectsData != oldMarker.affectsData ) {
				oldMarker._affectsData = affectsData;
				hasChanged = true;
			}

			if ( hasChanged ) {
				this.fire( 'update:' + markerName, oldMarker, oldRange, range );
			}

			return oldMarker;
		}

		const liveRange = _liverange__WEBPACK_IMPORTED_MODULE_0__["default"].fromRange( range );
		const marker = new Marker( markerName, liveRange, managedUsingOperations, affectsData );

		this._markers.set( markerName, marker );
		this.fire( 'update:' + markerName, marker, null, range );

		return marker;
	}

	/**
	 * Removes given {@link ~Marker marker} or a marker with given name from the `MarkerCollection`.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String} markerOrName Marker or name of a marker to remove.
	 * @returns {Boolean} `true` if marker was found and removed, `false` otherwise.
	 */
	_remove( markerOrName ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;
		const oldMarker = this._markers.get( markerName );

		if ( oldMarker ) {
			this._markers.delete( markerName );
			this.fire( 'update:' + markerName, oldMarker, oldMarker.getRange(), null );

			this._destroyMarker( oldMarker );

			return true;
		}

		return false;
	}

	/**
	 * Fires an {@link module:engine/model/markercollection~MarkerCollection#event:update} event for the given {@link ~Marker marker}
	 * but does not change the marker. Useful to force {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher downcast
	 * conversion} for the marker.
	 *
	 * @protected
	 * @fires module:engine/model/markercollection~MarkerCollection#event:update
	 * @param {String} markerOrName Marker or name of a marker to refresh.
	 */
	_refresh( markerOrName ) {
		const markerName = markerOrName instanceof Marker ? markerOrName.name : markerOrName;
		const marker = this._markers.get( markerName );

		if ( !marker ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'markercollection-refresh-marker-not-exists: Marker with provided name does not exists.', this );
		}

		const range = marker.getRange();

		this.fire( 'update:' + markerName, marker, range, range, marker.managedUsingOperations, marker.affectsData );
	}

	/**
	 * Returns iterator that iterates over all markers, which ranges contain given {@link module:engine/model/position~Position position}.
	 *
	 * @param {module:engine/model/position~Position} position
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersAtPosition( position ) {
		for ( const marker of this ) {
			if ( marker.getRange().containsPosition( position ) ) {
				yield marker;
			}
		}
	}

	/**
	 * Returns iterator that iterates over all markers, which intersects with given {@link module:engine/model/range~Range range}.
	 *
	 * @param {module:engine/model/range~Range} range
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersIntersectingRange( range ) {
		for ( const marker of this ) {
			if ( marker.getRange().getIntersection( range ) !== null ) {
				yield marker;
			}
		}
	}

	/**
	 * Destroys marker collection and all markers inside it.
	 */
	destroy() {
		for ( const marker of this._markers.values() ) {
			this._destroyMarker( marker );
		}

		this._markers = null;

		this.stopListening();
	}

	/**
	 * Iterates over all markers that starts with given `prefix`.
	 *
	 *		const markerFooA = markersCollection.set( 'foo:a', rangeFooA );
	 *		const markerFooB = markersCollection.set( 'foo:b', rangeFooB );
	 *		const markerBarA = markersCollection.set( 'bar:a', rangeBarA );
	 *		const markerFooBarA = markersCollection.set( 'foobar:a', rangeFooBarA );
	 *		Array.from( markersCollection.getMarkersGroup( 'foo' ) ); // [ markerFooA, markerFooB ]
	 *		Array.from( markersCollection.getMarkersGroup( 'a' ) ); // []
	 *
	 * @param prefix
	 * @returns {Iterable.<module:engine/model/markercollection~Marker>}
	 */
	* getMarkersGroup( prefix ) {
		for ( const marker of this._markers.values() ) {
			if ( marker.name.startsWith( prefix + ':' ) ) {
				yield marker;
			}
		}
	}

	/**
	 * Destroys the marker.
	 *
	 * @private
	 * @param {module:engine/model/markercollection~Marker} marker Marker to destroy.
	 */
	_destroyMarker( marker ) {
		marker.stopListening();
		marker._detachLiveRange();
	}

	/**
	 * Fired whenever marker is added, updated or removed from `MarkerCollection`.
	 *
	 * @event update
	 * @param {module:engine/model/markercollection~Marker} marker Updated Marker.
	 * @param {module:engine/model/range~Range|null} oldRange Marker range before the update. When is not defined it
	 * means that marker is just added.
	 * @param {module:engine/model/range~Range|null} newRange Marker range after update. When is not defined it
	 * means that marker is just removed.
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( MarkerCollection, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * `Marker` is a continuous parts of model (like a range), is named and represent some kind of information about marked
 * part of model document. In contrary to {@link module:engine/model/node~Node nodes}, which are building blocks of
 * model document tree, markers are not stored directly in document tree but in
 * {@link module:engine/model/model~Model#markers model markers' collection}. Still, they are document data, by giving
 * additional meaning to the part of a model document between marker start and marker end.
 *
 * In this sense, markers are similar to adding and converting attributes on nodes. The difference is that attribute is
 * connected with a given node (e.g. a character is bold no matter if it gets moved or content around it changes).
 * Markers on the other hand are continuous ranges and are characterized by their start and end position. This means that
 * any character in the marker is marked by the marker. For example, if a character is moved outside of marker it stops being
 * "special" and the marker is shrunk. Similarly, when a character is moved into the marker from other place in document
 * model, it starts being "special" and the marker is enlarged.
 *
 * Another upside of markers is that finding marked part of document is fast and easy. Using attributes to mark some nodes
 * and then trying to find that part of document would require traversing whole document tree. Marker gives instant access
 * to the range which it is marking at the moment.
 *
 * Markers are built from a name and a range.
 *
 * Range of the marker is updated automatically when document changes, using
 * {@link module:engine/model/liverange~LiveRange live range} mechanism.
 *
 * Name is used to group and identify markers. Names have to be unique, but markers can be grouped by
 * using common prefixes, separated with `:`, for example: `user:john` or `search:3`. That's useful in term of creating
 * namespaces for custom elements (e.g. comments, highlights). You can use this prefixes in
 * {@link module:engine/model/markercollection~MarkerCollection#event:update} listeners to listen on changes in a group of markers.
 * For instance: `model.markers.on( 'update:user', callback );` will be called whenever any `user:*` markers changes.
 *
 * There are two types of markers.
 *
 * 1. Markers managed directly, without using operations. They are added directly by {@link module:engine/model/writer~Writer}
 * to the {@link module:engine/model/markercollection~MarkerCollection} without any additional mechanism. They can be used
 * as bookmarks or visual markers. They are great for showing results of the find, or select link when the focus is in the input.
 *
 * 1. Markers managed using operations. These markers are also stored in {@link module:engine/model/markercollection~MarkerCollection}
 * but changes in these markers is managed the same way all other changes in the model structure - using operations.
 * Therefore, they are handled in the undo stack and synchronized between clients if the collaboration plugin is enabled.
 * This type of markers is useful for solutions like spell checking or comments.
 *
 * Both type of them should be added / updated by {@link module:engine/model/writer~Writer#addMarker}
 * and removed by {@link module:engine/model/writer~Writer#removeMarker} methods.
 *
 *		model.change( ( writer ) => {
 * 			const marker = writer.addMarker( name, { range, usingOperation: true } );
 *
 * 			// ...
 *
 * 			writer.removeMarker( marker );
 *		} );
 *
 * See {@link module:engine/model/writer~Writer} to find more examples.
 *
 * Since markers need to track change in the document, for efficiency reasons, it is best to create and keep as little
 * markers as possible and remove them as soon as they are not needed anymore.
 *
 * Markers can be downcasted and upcasted.
 *
 * Markers downcast happens on {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:addMarker} and
 * {@link module:engine/conversion/downcastdispatcher~DowncastDispatcher#event:removeMarker} events.
 * Use {@link module:engine/conversion/downcasthelpers downcast converters} or attach a custom converter to mentioned events.
 * For {@link module:engine/controller/datacontroller~DataController data pipeline}, marker should be downcasted to an element.
 * Then, it can be upcasted back to a marker. Again, use {@link module:engine/conversion/upcasthelpers upcast converters} or
 * attach a custom converter to {@link module:engine/conversion/upcastdispatcher~UpcastDispatcher#event:element}.
 *
 * `Marker` instances are created and destroyed only by {@link ~MarkerCollection MarkerCollection}.
 */
class Marker {
	/**
	 * Creates a marker instance.
	 *
	 * @param {String} name Marker name.
	 * @param {module:engine/model/liverange~LiveRange} liveRange Range marked by the marker.
	 * @param {Boolean} managedUsingOperations Specifies whether the marker is managed using operations.
	 * @param {Boolean} affectsData Specifies whether the marker affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 */
	constructor( name, liveRange, managedUsingOperations, affectsData ) {
		/**
		 * Marker's name.
		 *
		 * @readonly
		 * @type {String}
		 */
		this.name = name;

		/**
		 * Range marked by the marker.
		 *
		 * @protected
		 * @member {module:engine/model/liverange~LiveRange}
		 */
		this._liveRange = this._attachLiveRange( liveRange );

		/**
		 * Flag indicates if the marker is managed using operations or not.
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._managedUsingOperations = managedUsingOperations;

		/**
		 * Specifies whether the marker affects the data produced by the data pipeline
		 * (is persisted in the editor's data).
		 *
		 * @private
		 * @member {Boolean}
		 */
		this._affectsData = affectsData;
	}

	/**
	 * A value indicating if the marker is managed using operations.
	 * See {@link ~Marker marker class description} to learn more about marker types.
	 * See {@link module:engine/model/writer~Writer#addMarker}.
	 *
	 * @returns {Boolean}
	 */
	get managedUsingOperations() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed: Cannot use a destroyed marker instance.', this );
		}

		return this._managedUsingOperations;
	}

	/**
	 * A value indicating if the marker changes the data.
	 *
	 * @returns {Boolean}
	 */
	get affectsData() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed: Cannot use a destroyed marker instance.', this );
		}

		return this._affectsData;
	}

	/**
	 * Returns current marker start position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getStart() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed: Cannot use a destroyed marker instance.', this );
		}

		return this._liveRange.start.clone();
	}

	/**
	 * Returns current marker end position.
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getEnd() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed: Cannot use a destroyed marker instance.', this );
		}

		return this._liveRange.end.clone();
	}

	/**
	 * Returns a range that represents the current state of the marker.
	 *
	 * Keep in mind that returned value is a {@link module:engine/model/range~Range Range}, not a
	 * {@link module:engine/model/liverange~LiveRange LiveRange}. This means that it is up-to-date and relevant only
	 * until next model document change. Do not store values returned by this method. Instead, store {@link ~Marker#name}
	 * and get `Marker` instance from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection} every
	 * time there is a need to read marker properties. This will guarantee that the marker has not been removed and
	 * that it's data is up-to-date.
	 *
	 * @returns {module:engine/model/range~Range}
	 */
	getRange() {
		if ( !this._liveRange ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'marker-destroyed: Cannot use a destroyed marker instance.', this );
		}

		return this._liveRange.toRange();
	}

	/**
	 * Checks whether this object is of the given.
	 *
	 *		marker.is( 'marker' ); // -> true
	 *		marker.is( 'model:marker' ); // -> true
	 *
	 *		marker.is( 'view:element' ); // -> false
	 *		marker.is( 'documentSelection' ); // -> false
	 *
	 * {@link module:engine/model/node~Node#is Check the entire list of model objects} which implement the `is()` method.
	 *
	 * @param {String} type
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'marker' || type === 'model:marker';
	}

	/**
	 * Binds new live range to the marker and detach the old one if is attached.
	 *
	 * @protected
	 * @param {module:engine/model/liverange~LiveRange} liveRange Live range to attach
	 * @returns {module:engine/model/liverange~LiveRange} Attached live range.
	 */
	_attachLiveRange( liveRange ) {
		if ( this._liveRange ) {
			this._detachLiveRange();
		}

		// Delegating does not work with namespaces. Alternatively, we could delegate all events (using `*`).
		liveRange.delegate( 'change:range' ).to( this );
		liveRange.delegate( 'change:content' ).to( this );

		this._liveRange = liveRange;

		return liveRange;
	}

	/**
	 * Unbinds and destroys currently attached live range.
	 *
	 * @protected
	 */
	_detachLiveRange() {
		this._liveRange.stopDelegating( 'change:range', this );
		this._liveRange.stopDelegating( 'change:content', this );
		this._liveRange.detach();
		this._liveRange = null;
	}

	/**
	 * Fired whenever {@link ~Marker#_liveRange marker range} is changed due to changes on {@link module:engine/model/document~Document}.
	 * This is a delegated {@link module:engine/model/liverange~LiveRange#event:change:range LiveRange change:range event}.
	 *
	 * When marker is removed from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection},
	 * all event listeners listening to it should be removed. It is best to do it on
	 * {@link module:engine/model/markercollection~MarkerCollection#event:update MarkerCollection update event}.
	 *
	 * @see module:engine/model/liverange~LiveRange#event:change:range
	 * @event change:range
	 * @param {module:engine/model/range~Range} oldRange
	 * @param {Object} data
	 */

	/**
	 * Fired whenever change on {@link module:engine/model/document~Document} is done inside {@link ~Marker#_liveRange marker range}.
	 * This is a delegated {@link module:engine/model/liverange~LiveRange#event:change:content LiveRange change:content event}.
	 *
	 * When marker is removed from {@link module:engine/model/markercollection~MarkerCollection MarkerCollection},
	 * all event listeners listening to it should be removed. It is best to do it on
	 * {@link module:engine/model/markercollection~MarkerCollection#event:update MarkerCollection update event}.
	 *
	 * @see module:engine/model/liverange~LiveRange#event:change:content
	 * @event change:content
	 * @param {module:engine/model/range~Range} oldRange
	 * @param {Object} data
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_3__["default"])( Marker, _ckeditor_ckeditor5_utils_src_emittermixin__WEBPACK_IMPORTED_MODULE_1__["default"] );

/**
 * Cannot use a {@link module:engine/model/markercollection~MarkerCollection#destroy destroyed marker} instance.
 *
 * @error marker-destroyed
 */


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/model.js":
/*!********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/model.js ***!
  \********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Model; });
/* harmony import */ var _batch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./batch */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/batch.js");
/* harmony import */ var _writer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./writer */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/writer.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./schema */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/schema.js");
/* harmony import */ var _document__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./document */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/document.js");
/* harmony import */ var _markercollection__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./markercollection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/markercollection.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/observablemixin */ "./node_modules/@ckeditor/ckeditor5-utils/src/observablemixin.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/mix */ "./node_modules/@ckeditor/ckeditor5-utils/src/mix.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./element */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _selection__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./selection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/selection.js");
/* harmony import */ var _operation_operationfactory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./operation/operationfactory */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js");
/* harmony import */ var _utils_insertcontent__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/insertcontent */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/utils/insertcontent.js");
/* harmony import */ var _utils_deletecontent__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/deletecontent */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/utils/deletecontent.js");
/* harmony import */ var _utils_modifyselection__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./utils/modifyselection */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/utils/modifyselection.js");
/* harmony import */ var _utils_getselectedcontent__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils/getselectedcontent */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/utils/getselectedcontent.js");
/* harmony import */ var _utils_selection_post_fixer__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./utils/selection-post-fixer */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/utils/selection-post-fixer.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/model
 */





















// @if CK_DEBUG_ENGINE // const { dumpTrees } = require( '../dev-utils/utils' );
// @if CK_DEBUG_ENGINE // const { OperationReplayer } = require( '../dev-utils/operationreplayer' ).default;

/**
 * Editor's data model. Read about the model in the
 * {@glink framework/guides/architecture/editing-engine engine architecture guide}.
 *
 * @mixes module:utils/observablemixin~ObservableMixin
 */
class Model {
	constructor() {
		/**
		 * Model's marker collection.
		 *
		 * @readonly
		 * @member {module:engine/model/markercollection~MarkerCollection}
		 */
		this.markers = new _markercollection__WEBPACK_IMPORTED_MODULE_4__["default"]();

		/**
		 * Model's document.
		 *
		 * @readonly
		 * @member {module:engine/model/document~Document}
		 */
		this.document = new _document__WEBPACK_IMPORTED_MODULE_3__["default"]( this );

		/**
		 * Model's schema.
		 *
		 * @readonly
		 * @member {module:engine/model/schema~Schema}
		 */
		this.schema = new _schema__WEBPACK_IMPORTED_MODULE_2__["default"]();

		/**
		 * All callbacks added by {@link module:engine/model/model~Model#change} or
		 * {@link module:engine/model/model~Model#enqueueChange} methods waiting to be executed.
		 *
		 * @private
		 * @type {Array.<Function>}
		 */
		this._pendingChanges = [];

		/**
		 * The last created and currently used writer instance.
		 *
		 * @private
		 * @member {module:engine/model/writer~Writer}
		 */
		this._currentWriter = null;

		[ 'insertContent', 'deleteContent', 'modifySelection', 'getSelectedContent', 'applyOperation' ]
			.forEach( methodName => this.decorate( methodName ) );

		// Adding operation validation with `highest` priority, so it is called before any other feature would like
		// to do anything with the operation. If the operation has incorrect parameters it should throw on the earliest occasion.
		this.on( 'applyOperation', ( evt, args ) => {
			const operation = args[ 0 ];

			operation._validate();
		}, { priority: 'highest' } );

		// Register some default abstract entities.
		this.schema.register( '$root', {
			isLimit: true
		} );
		this.schema.register( '$block', {
			allowIn: '$root',
			isBlock: true
		} );
		this.schema.register( '$text', {
			allowIn: '$block',
			isInline: true
		} );
		this.schema.register( '$clipboardHolder', {
			allowContentOf: '$root',
			isLimit: true
		} );
		this.schema.extend( '$text', { allowIn: '$clipboardHolder' } );

		// An element needed by the `upcastElementToMarker` converter.
		// This element temporarily represents a marker boundary during the conversion process and is removed
		// at the end of the conversion. `UpcastDispatcher` or at least `Conversion` class looks like a
		// better place for this registration but both know nothing about `Schema`.
		this.schema.register( '$marker' );
		this.schema.addChildCheck( ( context, childDefinition ) => {
			if ( childDefinition.name === '$marker' ) {
				return true;
			}
		} );

		Object(_utils_selection_post_fixer__WEBPACK_IMPORTED_MODULE_16__["injectSelectionPostFixer"])( this );

		// @if CK_DEBUG_ENGINE // this.on( 'applyOperation', () => {
		// @if CK_DEBUG_ENGINE // 	dumpTrees( this.document, this.document.version );
		// @if CK_DEBUG_ENGINE // }, { priority: 'lowest' } );
	}

	/**
	 * The `change()` method is the primary way of changing the model. You should use it to modify all document nodes
	 * (including detached nodes – i.e. nodes not added to the {@link module:engine/model/model~Model#document model document}),
	 * the {@link module:engine/model/document~Document#selection document's selection}, and
	 * {@link module:engine/model/model~Model#markers model markers}.
	 *
	 *		model.change( writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' );
	 *		} );
	 *
	 * All changes inside the change block use the same {@link module:engine/model/batch~Batch} so they are combined
	 * into a single undo step.
	 *
	 *		model.change( writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' ); // foo.
	 *
	 *			model.change( writer => {
	 *				writer.insertText( 'bar', paragraph, 'end' ); // foobar.
	 *			} );
	 *
	 * 			writer.insertText( 'bom', paragraph, 'end' ); // foobarbom.
	 *		} );
	 *
	 * The callback of the `change()` block is executed synchronously.
	 *
	 * You can also return a value from the change block.
	 *
	 *		const img = model.change( writer => {
	 *			return writer.createElement( 'img' );
	 *		} );
	 *
	 * @see #enqueueChange
	 * @param {Function} callback Callback function which may modify the model.
	 * @returns {*} Value returned by the callback.
	 */
	change( callback ) {
		try {
			if ( this._pendingChanges.length === 0 ) {
				// If this is the outermost block, create a new batch and start `_runPendingChanges` execution flow.
				this._pendingChanges.push( { batch: new _batch__WEBPACK_IMPORTED_MODULE_0__["default"](), callback } );

				return this._runPendingChanges()[ 0 ];
			} else {
				// If this is not the outermost block, just execute the callback.
				return callback( this._currentWriter );
			}
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_17__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * The `enqueueChange()` method performs similar task as the {@link #change `change()` method}, with two major differences.
	 *
	 * First, the callback of `enqueueChange()` is executed when all other enqueued changes are done. It might be executed
	 * immediately if it is not nested in any other change block, but if it is nested in another (enqueue)change block,
	 * it will be delayed and executed after the outermost block.
	 *
	 *		model.change( writer => {
	 *			console.log( 1 );
	 *
	 *			model.enqueueChange( writer => {
	 *				console.log( 2 );
	 *			} );
	 *
	 * 			console.log( 3 );
	 *		} ); // Will log: 1, 3, 2.
	 *
	 * In addition to that, the changes enqueued with `enqueueChange()` will be converted separately from the changes
	 * done in the outer `change()` block.
	 *
	 * Second, it lets you define the {@link module:engine/model/batch~Batch} into which you want to add your changes.
	 * By default, a new batch is created. In the sample above, `change` and `enqueueChange` blocks use a different
	 * batch (and different {@link module:engine/model/writer~Writer} since each of them operates on the separate batch).
	 *
	 * When using the `enqueueChange()` block you can also add some changes to the batch you used before.
	 *
	 *		model.enqueueChange( batch, writer => {
	 *			writer.insertText( 'foo', paragraph, 'end' );
	 *		} );
	 *
	 * In order to make a nested `enqueueChange()` create a single undo step together with the changes done in the outer `change()`
	 * block, you can obtain the batch instance from the  {@link module:engine/model/writer~Writer#batch writer} of the outer block.
	 *
	 * @param {module:engine/model/batch~Batch|'transparent'|'default'} batchOrType Batch or batch type should be used in the callback.
	 * If not defined, a new batch will be created.
	 * @param {Function} callback Callback function which may modify the model.
	 */
	enqueueChange( batchOrType, callback ) {
		try {
			if ( typeof batchOrType === 'string' ) {
				batchOrType = new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]( batchOrType );
			} else if ( typeof batchOrType == 'function' ) {
				callback = batchOrType;
				batchOrType = new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]();
			}

			this._pendingChanges.push( { batch: batchOrType, callback } );

			if ( this._pendingChanges.length == 1 ) {
				this._runPendingChanges();
			}
		} catch ( err ) {
			// @if CK_DEBUG // throw err;
			/* istanbul ignore next */
			_ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_17__["default"].rethrowUnexpectedError( err, this );
		}
	}

	/**
	 * {@link module:utils/observablemixin~ObservableMixin#decorate Decorated} function for applying
	 * {@link module:engine/model/operation/operation~Operation operations} to the model.
	 *
	 * This is a low-level way of changing the model. It is exposed for very specific use cases (like the undo feature).
	 * Normally, to modify the model, you will want to use {@link module:engine/model/writer~Writer `Writer`}.
	 * See also {@glink framework/guides/architecture/editing-engine#changing-the-model Changing the model} section
	 * of the {@glink framework/guides/architecture/editing-engine Editing architecture} guide.
	 *
	 * @param {module:engine/model/operation/operation~Operation} operation The operation to apply.
	 */
	applyOperation( operation ) {
		// @if CK_DEBUG_ENGINE // console.log( 'Applying ' + operation );

		// @if CK_DEBUG_ENGINE // if ( !this._operationLogs ) {
		// @if CK_DEBUG_ENGINE //	this._operationLogs = [];
		// @if CK_DEBUG_ENGINE // }

		// @if CK_DEBUG_ENGINE // this._operationLogs.push( JSON.stringify( operation ) );

		// @if CK_DEBUG_ENGINE //if ( !this._appliedOperations ) {
		// @if CK_DEBUG_ENGINE //	this._appliedOperations = [];
		// @if CK_DEBUG_ENGINE //}

		// @if CK_DEBUG_ENGINE //this._appliedOperations.push( operation );

		operation._execute();
	}

	// @if CK_DEBUG_ENGINE // getAppliedOperation() {
	// @if CK_DEBUG_ENGINE //	if ( !this._appliedOperations ) {
	// @if CK_DEBUG_ENGINE //		return '';
	// @if CK_DEBUG_ENGINE //	}

	// @if CK_DEBUG_ENGINE //	return this._appliedOperations.map( JSON.stringify ).join( '-------' );
	// @if CK_DEBUG_ENGINE // }

	// @if CK_DEBUG_ENGINE // createReplayer( stringifiedOperations ) {
	// @if CK_DEBUG_ENGINE //	return new OperationReplayer( this, '-------', stringifiedOperations );
	// @if CK_DEBUG_ENGINE // }

	/**
	 * Inserts content at the position in the editor specified by the selection, as one would expect the paste
	 * functionality to work.
	 *
	 * This is a high-level method. It takes the {@link #schema schema} into consideration when inserting
	 * the content, clears the given selection's content before inserting nodes and moves the selection
	 * to its target position at the end of the process.
	 * It can split elements, merge them, wrap bare text nodes with paragraphs, etc. &mdash; just like the
	 * pasting feature should do.
	 *
	 * For lower-level methods see {@link module:engine/model/writer~Writer `Writer`}.
	 *
	 * This method, unlike {@link module:engine/model/writer~Writer `Writer`}'s methods, does not have to be used
	 * inside a {@link #change `change()` block}.
	 *
	 * # Conversion and schema
	 *
	 * Inserting elements and text nodes into the model is not enough to make CKEditor 5 render that content
	 * to the user. CKEditor 5 implements a model-view-controller architecture and what `model.insertContent()` does
	 * is only adding nodes to the model. Additionally, you need to define
	 * {@glink framework/guides/architecture/editing-engine#conversion converters} between the model and view
	 * and define those nodes in the {@glink framework/guides/architecture/editing-engine#schema schema}.
	 *
	 * So, while this method may seem similar to CKEditor 4 `editor.insertHtml()` (in fact, both methods
	 * are used for paste-like content insertion), the CKEditor 5 method cannot be use to insert arbitrary HTML
	 * unless converters are defined for all elements and attributes in that HTML.
	 *
	 * # Examples
	 *
	 * Using `insertContent()` with a manually created model structure:
	 *
	 *		// Let's create a document fragment containing such content as:
	 *		//
	 *		// <paragraph>foo</paragraph>
	 *		// <blockQuote>
	 *		//    <paragraph>bar</paragraph>
	 *		// </blockQuote>
	 *		const docFrag = editor.model.change( writer => {
	 *			const p1 = writer.createElement( 'paragraph' );
	 *			const p2 = writer.createElement( 'paragraph' );
	 *			const blockQuote = writer.createElement( 'blockQuote' );
	 *			const docFrag = writer.createDocumentFragment();
	 *
	 *			writer.append( p1, docFrag );
	 *			writer.append( blockQuote, docFrag );
	 *			writer.append( p2, blockQuote );
	 *			writer.insertText( 'foo', p1 );
	 *			writer.insertText( 'bar', p2 );
	 *
	 *			return docFrag;
	 *		} );
	 *
	 *		// insertContent() does not have to be used in a change() block. It can, though,
	 *		// so this code could be moved to the callback defined above.
	 *		editor.model.insertContent( docFrag );
	 *
	 * Using `insertContent()` with an HTML string converted to a model document fragment (similar to the pasting mechanism):
	 *
	 *		// You can create your own HtmlDataProcessor instance or use editor.data.processor
	 *		// if you have not overridden the default one (which is the HtmlDataProcessor instance).
	 *		const htmlDP = new HtmlDataProcessor( viewDocument );
	 *
	 *		// Convert an HTML string to a view document fragment:
	 *		const viewFragment = htmlDP.toView( htmlString );
	 *
	 *		// Convert the view document fragment to a model document fragment
	 *		// in the context of $root. This conversion takes the schema into
	 *		// account so if, for example, the view document fragment contained a bare text node,
	 *		// this text node cannot be a child of $root, so it will be automatically
	 *		// wrapped with a <paragraph>. You can define the context yourself (in the second parameter),
	 *		// and e.g. convert the content like it would happen in a <paragraph>.
	 *		// Note: The clipboard feature uses a custom context called $clipboardHolder
	 *		// which has a loosened schema.
	 *		const modelFragment = editor.data.toModel( viewFragment );
	 *
	 *		editor.model.insertContent( modelFragment );
	 *
	 * By default this method will use the document selection but it can also be used with a position, range or selection instance.
	 *
	 *		// Insert text at the current document selection position.
	 *		editor.model.change( writer => {
	 *			editor.model.insertContent( writer.createText( 'x' ) );
	 *		} );
	 *
	 *		// Insert text at a given position - the document selection will not be modified.
	 *		editor.model.change( writer => {
	 *			editor.model.insertContent( writer.createText( 'x' ), doc.getRoot(), 2 );
	 *
	 *			// Which is a shorthand for:
	 *			editor.model.insertContent( writer.createText( 'x' ), writer.createPositionAt( doc.getRoot(), 2 ) );
	 *		} );
	 *
	 * If you want the document selection to be moved to the inserted content, use the
	 * {@link module:engine/model/writer~Writer#setSelection `setSelection()`} method of the writer after inserting
	 * the content:
	 *
	 *		editor.model.change( writer => {
	 *			const paragraph = writer.createElement( 'paragraph' );
	 *
	 *			// Insert an empty paragraph at the beginning of the root.
	 *			editor.model.insertContent( paragraph, writer.createPositionAt( editor.model.document.getRoot(), 0 ) );
	 *
	 *			// Move the document selection to the inserted paragraph.
	 *			writer.setSelection( paragraph, 'in' );
	 *		} );
	 *
	 * If an instance of the {@link module:engine/model/selection~Selection model selection} is passed as `selectable`,
	 * the new content will be inserted at the passed selection (instead of document selection):
	 *
	 *		editor.model.change( writer => {
	 *			// Create a selection in a paragraph that will be used as a place of insertion.
	 *			const selection = writer.createSelection( paragraph, 'in' );
	 *
	 *			// Insert the new text at the created selection.
	 *			editor.model.insertContent( writer.createText( 'x' ), selection );
	 *
	 *			// insertContent() modifies the passed selection instance so it can be used to set the document selection.
	 *			// Note: This is not necessary when you passed the document selection to insertContent().
	 *			writer.setSelection( selection );
	 *		} );
	 *
	 * @fires insertContent
	 * @param {module:engine/model/documentfragment~DocumentFragment|module:engine/model/item~Item} content The content to insert.
	 * @param {module:engine/model/selection~Selectable} [selectable=model.document.selection]
	 * The selection into which the content should be inserted. If not provided the current model document selection will be used.
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] To be used when a model item was passed as `selectable`.
	 * This param defines a position in relation to that item.
	 * @returns {module:engine/model/range~Range} Range which contains all the performed changes. This is a range that, if removed,
	 * would return the model to the state before the insertion. If no changes were preformed by `insertContent`, returns a range collapsed
	 * at the insertion position.
	 */
	insertContent( content, selectable, placeOrOffset ) {
		return Object(_utils_insertcontent__WEBPACK_IMPORTED_MODULE_12__["default"])( this, content, selectable, placeOrOffset );
	}

	/**
	 * Deletes content of the selection and merge siblings. The resulting selection is always collapsed.
	 *
	 * **Note:** For the sake of predictability, the resulting selection should always be collapsed.
	 * In cases where a feature wants to modify deleting behavior so selection isn't collapsed
	 * (e.g. a table feature may want to keep row selection after pressing <kbd>Backspace</kbd>),
	 * then that behavior should be implemented in the view's listener. At the same time, the table feature
	 * will need to modify this method's behavior too, e.g. to "delete contents and then collapse
	 * the selection inside the last selected cell" or "delete the row and collapse selection somewhere near".
	 * That needs to be done in order to ensure that other features which use `deleteContent()` will work well with tables.
	 *
	 * @fires deleteContent
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * Selection of which the content should be deleted.
	 * @param {Object} [options]
	 * @param {Boolean} [options.leaveUnmerged=false] Whether to merge elements after removing the content of the selection.
	 *
	 * For example `<heading1>x[x</heading1><paragraph>y]y</paragraph>` will become:
	 *
	 * * `<heading1>x^y</heading1>` with the option disabled (`leaveUnmerged == false`)
	 * * `<heading1>x^</heading1><paragraph>y</paragraph>` with enabled (`leaveUnmerged == true`).
	 *
	 * Note: {@link module:engine/model/schema~Schema#isObject object} and {@link module:engine/model/schema~Schema#isLimit limit}
	 * elements will not be merged.
	 *
	 * @param {Boolean} [options.doNotResetEntireContent=false] Whether to skip replacing the entire content with a
	 * paragraph when the entire content was selected.
	 *
	 * For example `<heading1>[x</heading1><paragraph>y]</paragraph>` will become:
	 *
	 * * `<paragraph>^</paragraph>` with the option disabled (`doNotResetEntireContent == false`)
	 * * `<heading1>^</heading1>` with enabled (`doNotResetEntireContent == true`)
	 *
	 * @param {Boolean} [options.doNotAutoparagraph=false] Whether to create a paragraph if after content deletion selection is moved
	 * to a place where text cannot be inserted.
	 *
	 * For example `<paragraph>x</paragraph>[<image src="foo.jpg"></image>]` will become:
	 *
	 * * `<paragraph>x</paragraph><paragraph>[]</paragraph>` with the option disabled (`doNotAutoparagraph == false`)
	 * * `<paragraph>x[]</paragraph>` with the option enabled (`doNotAutoparagraph == true`).
	 *
	 * **Note:** if there is no valid position for the selection, the paragraph will always be created:
	 *
	 * `[<image src="foo.jpg"></image>]` -> `<paragraph>[]</paragraph>`.
	 *
	 * @param {'forward'|'backward'} [options.direction='backward'] The direction in which the content is being consumed.
	 * Deleting backward corresponds to using the <kbd>Backspace</kbd> key, while deleting content forward corresponds to
	 * the <kbd>Shift</kbd>+<kbd>Backspace</kbd> keystroke.
	 */
	deleteContent( selection, options ) {
		Object(_utils_deletecontent__WEBPACK_IMPORTED_MODULE_13__["default"])( this, selection, options );
	}

	/**
	 * Modifies the selection. Currently, the supported modifications are:
	 *
	 * * Extending. The selection focus is moved in the specified `options.direction` with a step specified in `options.unit`.
	 * Possible values for `unit` are:
	 *  * `'character'` (default) - moves selection by one user-perceived character. In most cases this means moving by one
	 *  character in `String` sense. However, unicode also defines "combing marks". These are special symbols, that combines
	 *  with a symbol before it ("base character") to create one user-perceived character. For example, `q̣̇` is a normal
	 *  letter `q` with two "combining marks": upper dot (`Ux0307`) and lower dot (`Ux0323`). For most actions, i.e. extending
	 *  selection by one position, it is correct to include both "base character" and all of it's "combining marks". That is
	 *  why `'character'` value is most natural and common method of modifying selection.
	 *  * `'codePoint'` - moves selection by one unicode code point. In contrary to, `'character'` unit, this will insert
	 *  selection between "base character" and "combining mark", because "combining marks" have their own unicode code points.
	 *  However, for technical reasons, unicode code points with values above `UxFFFF` are represented in native `String` by
	 *  two characters, called "surrogate pairs". Halves of "surrogate pairs" have a meaning only when placed next to each other.
	 *  For example `𨭎` is represented in `String` by `\uD862\uDF4E`. Both `\uD862` and `\uDF4E` do not have any meaning
	 *  outside the pair (are rendered as ? when alone). Position between them would be incorrect. In this case, selection
	 *  extension will include whole "surrogate pair".
	 *  * `'word'` - moves selection by a whole word.
	 *
	 * **Note:** if you extend a forward selection in a backward direction you will in fact shrink it.
	 *
	 * @fires modifySelection
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * The selection to modify.
	 * @param {Object} [options]
	 * @param {'forward'|'backward'} [options.direction='forward'] The direction in which the selection should be modified.
	 * @param {'character'|'codePoint'|'word'} [options.unit='character'] The unit by which selection should be modified.
	 */
	modifySelection( selection, options ) {
		Object(_utils_modifyselection__WEBPACK_IMPORTED_MODULE_14__["default"])( this, selection, options );
	}

	/**
	 * Gets a clone of the selected content.
	 *
	 * For example, for the following selection:
	 *
	 * ```html
	 * <paragraph>x</paragraph>
	 * <blockQuote>
	 *	<paragraph>y</paragraph>
	 *	<heading1>fir[st</heading1>
	 * </blockQuote>
	 * <paragraph>se]cond</paragraph>
	 * <paragraph>z</paragraph>
	 * ```
	 *
	 * It will return a document fragment with such a content:
	 *
	 * ```html
	 * <blockQuote>
	 *	<heading1>st</heading1>
	 * </blockQuote>
	 * <paragraph>se</paragraph>
	 * ```
	 *
	 * @fires getSelectedContent
	 * @param {module:engine/model/selection~Selection|module:engine/model/documentselection~DocumentSelection} selection
	 * The selection of which content will be returned.
	 * @returns {module:engine/model/documentfragment~DocumentFragment}
	 */
	getSelectedContent( selection ) {
		return Object(_utils_getselectedcontent__WEBPACK_IMPORTED_MODULE_15__["default"])( this, selection );
	}

	/**
	 * Checks whether the given {@link module:engine/model/range~Range range} or
	 * {@link module:engine/model/element~Element element} has any meaningful content.
	 *
	 * Meaningful content is:
	 *
	 * * any text node (`options.ignoreWhitespaces` allows controlling whether this text node must also contain
	 * any non-whitespace characters),
	 * * or any {@link module:engine/model/schema~Schema#isObject object element},
	 * * or any {@link module:engine/model/markercollection~Marker marker} which
	 * {@link module:engine/model/markercollection~Marker#_affectsData affects data}.
	 *
	 * This means that a range containing an empty `<paragraph></paragraph>` is not considered to have a meaningful content.
	 * However, a range containing an `<image></image>` (which would normally be marked in the schema as an object element)
	 * is considered non-empty.
	 *
	 * @param {module:engine/model/range~Range|module:engine/model/element~Element} rangeOrElement Range or element to check.
	 * @param {Object} [options]
	 * @param {Boolean} [options.ignoreWhitespaces] Whether text node with whitespaces only should be considered empty.
	 * @param {Boolean} [options.ignoreMarkers] Whether markers should be ignored.
	 * @returns {Boolean}
	 */
	hasContent( rangeOrElement, options = {} ) {
		const range = rangeOrElement instanceof _element__WEBPACK_IMPORTED_MODULE_7__["default"] ? _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createIn( rangeOrElement ) : rangeOrElement;

		if ( range.isCollapsed ) {
			return false;
		}

		const { ignoreWhitespaces = false, ignoreMarkers = false } = options;

		// Check if there are any markers which affects data in this given range.
		if ( !ignoreMarkers ) {
			for ( const intersectingMarker of this.markers.getMarkersIntersectingRange( range ) ) {
				if ( intersectingMarker.affectsData ) {
					return true;
				}
			}
		}

		for ( const item of range.getItems() ) {
			if ( item.is( '$textProxy' ) ) {
				if ( !ignoreWhitespaces ) {
					return true;
				} else if ( item.data.search( /\S/ ) !== -1 ) {
					return true;
				}
			} else if ( this.schema.isObject( item ) ) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Creates a position from the given root and path in that root.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionFromPath `Writer#createPositionFromPath()`}.
	 *
	 * @param {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment} root Root of the position.
	 * @param {Array.<Number>} path Position path. See {@link module:engine/model/position~Position#path}.
	 * @param {module:engine/model/position~PositionStickiness} [stickiness='toNone'] Position stickiness.
	 * See {@link module:engine/model/position~PositionStickiness}.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionFromPath( root, path, stickiness ) {
		return new _position__WEBPACK_IMPORTED_MODULE_9__["default"]( root, path, stickiness );
	}

	/**
	 * Creates position at the given location. The location can be specified as:
	 *
	 * * a {@link module:engine/model/position~Position position},
	 * * a parent element and offset in that element,
	 * * a parent element and `'end'` (the position will be set at the end of that element),
	 * * a {@link module:engine/model/item~Item model item} and `'before'` or `'after'`
	 * (the position will be set before or after the given model item).
	 *
	 * This method is a shortcut to other factory methods such as:
	 *
	 * * {@link module:engine/model/model~Model#createPositionBefore `createPositionBefore()`},
	 * * {@link module:engine/model/model~Model#createPositionAfter `createPositionAfter()`}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionAt `Writer#createPositionAt()`},
	 *
	 * @param {module:engine/model/item~Item|module:engine/model/position~Position} itemOrPosition
	 * @param {Number|'end'|'before'|'after'} [offset] Offset or one of the flags. Used only when
	 * first parameter is a {@link module:engine/model/item~Item model item}.
	 */
	createPositionAt( itemOrPosition, offset ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createAt( itemOrPosition, offset );
	}

	/**
	 * Creates a new position after the given {@link module:engine/model/item~Item model item}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionAfter `Writer#createPositionAfter()`}.
	 *
	 * @param {module:engine/model/item~Item} item Item after which the position should be placed.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionAfter( item ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createAfter( item );
	}

	/**
	 * Creates a new position before the given {@link module:engine/model/item~Item model item}.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createPositionBefore `Writer#createPositionBefore()`}.
	 *
	 * @param {module:engine/model/item~Item} item Item before which the position should be placed.
	 * @returns {module:engine/model/position~Position}
	 */
	createPositionBefore( item ) {
		return _position__WEBPACK_IMPORTED_MODULE_9__["default"]._createBefore( item );
	}

	/**
	 * Creates a range spanning from the `start` position to the `end` position.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createRange `Writer#createRange()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRange( start, end );
	 *		} );
	 *
	 * @param {module:engine/model/position~Position} start Start position.
	 * @param {module:engine/model/position~Position} [end] End position. If not set, the range will be collapsed
	 * to the `start` position.
	 * @returns {module:engine/model/range~Range}
	 */
	createRange( start, end ) {
		return new _range__WEBPACK_IMPORTED_MODULE_8__["default"]( start, end );
	}

	/**
	 * Creates a range inside the given element which starts before the first child of
	 * that element and ends after the last child of that element.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createRangeIn `Writer#createRangeIn()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRangeIn( paragraph );
	 *		} );
	 *
	 * @param {module:engine/model/element~Element} element Element which is a parent for the range.
	 * @returns {module:engine/model/range~Range}
	 */
	createRangeIn( element ) {
		return _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createIn( element );
	}

	/**
	 * Creates a range that starts before the given {@link module:engine/model/item~Item model item} and ends after it.
	 *
	 * Note: This method is also available on `writer` instance as
	 * {@link module:engine/model/writer~Writer#createRangeOn `Writer.createRangeOn()`}:
	 *
	 *		model.change( writer => {
	 *			const range = writer.createRangeOn( paragraph );
	 *		} );
	 *
	 * @param {module:engine/model/item~Item} item
	 * @returns {module:engine/model/range~Range}
	 */
	createRangeOn( item ) {
		return _range__WEBPACK_IMPORTED_MODULE_8__["default"]._createOn( item );
	}

	/**
	 * Creates a new selection instance based on the given {@link module:engine/model/selection~Selectable selectable}
	 * or creates an empty selection if no arguments were passed.
	 *
	 * Note: This method is also available as
	 * {@link module:engine/model/writer~Writer#createSelection `Writer#createSelection()`}.
	 *
	 *		// Creates empty selection without ranges.
	 *		const selection = writer.createSelection();
	 *
	 *		// Creates selection at the given range.
	 *		const range = writer.createRange( start, end );
	 *		const selection = writer.createSelection( range );
	 *
	 *		// Creates selection at the given ranges
	 *		const ranges = [ writer.createRange( start1, end2 ), writer.createRange( star2, end2 ) ];
	 *		const selection = writer.createSelection( ranges );
	 *
	 *		// Creates selection from the other selection.
	 *		// Note: It doesn't copies selection attributes.
	 *		const otherSelection = writer.createSelection();
	 *		const selection = writer.createSelection( otherSelection );
	 *
	 *		// Creates selection from the given document selection.
	 *		// Note: It doesn't copies selection attributes.
	 *		const documentSelection = model.document.selection;
	 *		const selection = writer.createSelection( documentSelection );
	 *
	 *		// Creates selection at the given position.
	 *		const position = writer.createPositionFromPath( root, path );
	 *		const selection = writer.createSelection( position );
	 *
	 *		// Creates selection at the given offset in the given element.
	 *		const paragraph = writer.createElement( 'paragraph' );
	 *		const selection = writer.createSelection( paragraph, offset );
	 *
	 *		// Creates a range inside an {@link module:engine/model/element~Element element} which starts before the
	 *		// first child of that element and ends after the last child of that element.
	 *		const selection = writer.createSelection( paragraph, 'in' );
	 *
	 *		// Creates a range on an {@link module:engine/model/item~Item item} which starts before the item and ends
	 *		// just after the item.
	 *		const selection = writer.createSelection( paragraph, 'on' );
	 *
	 *		// Additional options (`'backward'`) can be specified as the last argument.
	 *
	 *		// Creates backward selection.
	 *		const selection = writer.createSelection( range, { backward: true } );
	 *
	 * @param {module:engine/model/selection~Selectable} selectable
	 * @param {Number|'before'|'end'|'after'|'on'|'in'} [placeOrOffset] Sets place or offset of the selection.
	 * @param {Object} [options]
	 * @param {Boolean} [options.backward] Sets this selection instance to be backward.
	 * @returns {module:engine/model/selection~Selection}
	 */
	createSelection( selectable, placeOrOffset, options ) {
		return new _selection__WEBPACK_IMPORTED_MODULE_10__["default"]( selectable, placeOrOffset, options );
	}

	/**
	 * Creates a {@link module:engine/model/batch~Batch} instance.
	 *
	 * **Note:** In most cases creating a batch instance is not necessary as they are created when using:
	 *
	 * * {@link #change `change()`},
	 * * {@link #enqueueChange `enqueueChange()`}.
	 *
	 * @param {'transparent'|'default'} [type='default'] The type of the batch.
	 * @returns {module:engine/model/batch~Batch}
	 */
	createBatch( type ) {
		return new _batch__WEBPACK_IMPORTED_MODULE_0__["default"]( type );
	}

	/**
	 * Creates an operation instance from a JSON object (parsed JSON string).
	 *
	 * This is an alias for {@link module:engine/model/operation/operationfactory~OperationFactory.fromJSON `OperationFactory.fromJSON()`}.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	createOperationFromJSON( json ) {
		return _operation_operationfactory__WEBPACK_IMPORTED_MODULE_11__["default"].fromJSON( json, this.document );
	}

	/**
	 * Removes all events listeners set by model instance and destroys {@link module:engine/model/document~Document}.
	 */
	destroy() {
		this.document.destroy();
		this.stopListening();
	}

	/**
	 * Common part of {@link module:engine/model/model~Model#change} and {@link module:engine/model/model~Model#enqueueChange}
	 * which calls callbacks and returns array of values returned by these callbacks.
	 *
	 * @private
	 * @returns {Array.<*>} Array of values returned by callbacks.
	 */
	_runPendingChanges() {
		const ret = [];

		this.fire( '_beforeChanges' );

		while ( this._pendingChanges.length ) {
			// Create a new writer using batch instance created for this chain of changes.
			const currentBatch = this._pendingChanges[ 0 ].batch;
			this._currentWriter = new _writer__WEBPACK_IMPORTED_MODULE_1__["default"]( this, currentBatch );

			// Execute changes callback and gather the returned value.
			const callbackReturnValue = this._pendingChanges[ 0 ].callback( this._currentWriter );
			ret.push( callbackReturnValue );

			this.document._handleChangeBlock( this._currentWriter );

			this._pendingChanges.shift();
			this._currentWriter = null;
		}

		this.fire( '_afterChanges' );

		return ret;
	}

	/**
	 * Fired when entering the outermost {@link module:engine/model/model~Model#enqueueChange} or
	 * {@link module:engine/model/model~Model#change} block.
	 *
	 * @protected
	 * @event _beforeChanges
	 */

	/**
	 * Fired when leaving the outermost {@link module:engine/model/model~Model#enqueueChange} or
	 * {@link module:engine/model/model~Model#change} block.
	 *
	 * @protected
	 * @event _afterChanges
	 */

	/**
	 * Fired every time any {@link module:engine/model/operation/operation~Operation operation} is applied on the model
	 * using {@link #applyOperation}.
	 *
	 * Note that this event is suitable only for very specific use-cases. Use it if you need to listen to every single operation
	 * applied on the document. However, in most cases {@link module:engine/model/document~Document#event:change} should
	 * be used.
	 *
	 * A few callbacks are already added to this event by engine internal classes:
	 *
	 * * with `highest` priority operation is validated,
	 * * with `normal` priority operation is executed,
	 * * with `low` priority the {@link module:engine/model/document~Document} updates its version,
	 * * with `low` priority {@link module:engine/model/liveposition~LivePosition} and {@link module:engine/model/liverange~LiveRange}
	 * update themselves.
	 *
	 * @event applyOperation
	 * @param {Array} args Arguments of the `applyOperation` which is an array with a single element - applied
	 * {@link module:engine/model/operation/operation~Operation operation}.
	 */

	/**
	 * Event fired when {@link #insertContent} method is called.
	 *
	 * The {@link #insertContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * **Note** The `selectable` parameter for the {@link #insertContent} is optional. When `undefined` value is passed the method uses
	 * `model.document.selection`.
	 *
	 * @event insertContent
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #deleteContent} method is called.
	 *
	 * The {@link #deleteContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event deleteContent
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #modifySelection} method is called.
	 *
	 * The {@link #modifySelection default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event modifySelection
	 * @param {Array} args The arguments passed to the original method.
	 */

	/**
	 * Event fired when {@link #getSelectedContent} method is called.
	 *
	 * The {@link #getSelectedContent default action of that method} is implemented as a
	 * listener to this event so it can be fully customized by the features.
	 *
	 * @event getSelectedContent
	 * @param {Array} args The arguments passed to the original method.
	 */
}

Object(_ckeditor_ckeditor5_utils_src_mix__WEBPACK_IMPORTED_MODULE_6__["default"])( Model, _ckeditor_ckeditor5_utils_src_observablemixin__WEBPACK_IMPORTED_MODULE_5__["default"] );


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/node.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/node.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Node; });
/* harmony import */ var _ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/tomap */ "./node_modules/@ckeditor/ckeditor5-utils/src/tomap.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/version */ "./node_modules/@ckeditor/ckeditor5-utils/src/version.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/node
 */




// To check if component is loaded more than once.


/**
 * Model node. Most basic structure of model tree.
 *
 * This is an abstract class that is a base for other classes representing different nodes in model.
 *
 * **Note:** If a node is detached from the model tree, you can manipulate it using it's API.
 * However, it is **very important** that nodes already attached to model tree should be only changed through
 * {@link module:engine/model/writer~Writer Writer API}.
 *
 * Changes done by `Node` methods, like {@link module:engine/model/element~Element#_insertChild _insertChild} or
 * {@link module:engine/model/node~Node#_setAttribute _setAttribute}
 * do not generate {@link module:engine/model/operation/operation~Operation operations}
 * which are essential for correct editor work if you modify nodes in {@link module:engine/model/document~Document document} root.
 *
 * The flow of working on `Node` (and classes that inherits from it) is as such:
 * 1. You can create a `Node` instance, modify it using it's API.
 * 2. Add `Node` to the model using `Batch` API.
 * 3. Change `Node` that was already added to the model using `Batch` API.
 *
 * Similarly, you cannot use `Batch` API on a node that has not been added to the model tree, with the exception
 * of {@link module:engine/model/writer~Writer#insert inserting} that node to the model tree.
 *
 * Be aware that using {@link module:engine/model/writer~Writer#remove remove from Batch API} does not allow to use `Node` API because
 * the information about `Node` is still kept in model document.
 *
 * In case of {@link module:engine/model/element~Element element node}, adding and removing children also counts as changing a node and
 * follows same rules.
 */
class Node {
	/**
	 * Creates a model node.
	 *
	 * This is an abstract class, so this constructor should not be used directly.
	 *
	 * @abstract
	 * @param {Object} [attrs] Node's attributes. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 */
	constructor( attrs ) {
		/**
		 * Parent of this node. It could be {@link module:engine/model/element~Element}
		 * or {@link module:engine/model/documentfragment~DocumentFragment}.
		 * Equals to `null` if the node has no parent.
		 *
		 * @readonly
		 * @member {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
		 */
		this.parent = null;

		/**
		 * Attributes set on this node.
		 *
		 * @private
		 * @member {Map} module:engine/model/node~Node#_attrs
		 */
		this._attrs = Object(_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__["default"])( attrs );
	}

	/**
	 * Index of this node in it's parent or `null` if the node has no parent.
	 *
	 * Accessing this property throws an error if this node's parent element does not contain it.
	 * This means that model tree got broken.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get index() {
		let pos;

		if ( !this.parent ) {
			return null;
		}

		if ( ( pos = this.parent.getChildIndex( this ) ) === null ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-node-not-found-in-parent: The node\'s parent does not contain this node.', this );
		}

		return pos;
	}

	/**
	 * Offset at which this node starts in it's parent. It is equal to the sum of {@link #offsetSize offsetSize}
	 * of all it's previous siblings. Equals to `null` if node has no parent.
	 *
	 * Accessing this property throws an error if this node's parent element does not contain it.
	 * This means that model tree got broken.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get startOffset() {
		let pos;

		if ( !this.parent ) {
			return null;
		}

		if ( ( pos = this.parent.getChildStartOffset( this ) ) === null ) {
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-node-not-found-in-parent: The node\'s parent does not contain this node.', this );
		}

		return pos;
	}

	/**
	 * Offset size of this node. Represents how much "offset space" is occupied by the node in it's parent.
	 * It is important for {@link module:engine/model/position~Position position}. When node has `offsetSize` greater than `1`, position
	 * can be placed between that node start and end. `offsetSize` greater than `1` is for nodes that represents more
	 * than one entity, i.e. {@link module:engine/model/text~Text text node}.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get offsetSize() {
		return 1;
	}

	/**
	 * Offset at which this node ends in it's parent. It is equal to the sum of this node's
	 * {@link module:engine/model/node~Node#startOffset start offset} and {@link #offsetSize offset size}.
	 * Equals to `null` if the node has no parent.
	 *
	 * @readonly
	 * @type {Number|null}
	 */
	get endOffset() {
		if ( !this.parent ) {
			return null;
		}

		return this.startOffset + this.offsetSize;
	}

	/**
	 * Node's next sibling or `null` if the node is a last child of it's parent or if the node has no parent.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get nextSibling() {
		const index = this.index;

		return ( index !== null && this.parent.getChild( index + 1 ) ) || null;
	}

	/**
	 * Node's previous sibling or `null` if the node is a first child of it's parent or if the node has no parent.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|null}
	 */
	get previousSibling() {
		const index = this.index;

		return ( index !== null && this.parent.getChild( index - 1 ) ) || null;
	}

	/**
	 * The top-most ancestor of the node. If node has no parent it is the root itself. If the node is a part
	 * of {@link module:engine/model/documentfragment~DocumentFragment}, it's `root` is equal to that `DocumentFragment`.
	 *
	 * @readonly
	 * @type {module:engine/model/node~Node|module:engine/model/documentfragment~DocumentFragment}
	 */
	get root() {
		let root = this; // eslint-disable-line consistent-this

		while ( root.parent ) {
			root = root.parent;
		}

		return root;
	}

	/**
	 * Returns true if the node is in a tree rooted in the document (is a descendant of one of its roots).
	 *
	 * @returns {Boolean}
	 */
	isAttached() {
		return this.root.is( 'rootElement' );
	}

	/**
	 * Gets path to the node. The path is an array containing starting offsets of consecutive ancestors of this node,
	 * beginning from {@link module:engine/model/node~Node#root root}, down to this node's starting offset. The path can be used to
	 * create {@link module:engine/model/position~Position Position} instance.
	 *
	 *		const abc = new Text( 'abc' );
	 *		const foo = new Text( 'foo' );
	 *		const h1 = new Element( 'h1', null, new Text( 'header' ) );
	 *		const p = new Element( 'p', null, [ abc, foo ] );
	 *		const div = new Element( 'div', null, [ h1, p ] );
	 *		foo.getPath(); // Returns [ 1, 3 ]. `foo` is in `p` which is in `div`. `p` starts at offset 1, while `foo` at 3.
	 *		h1.getPath(); // Returns [ 0 ].
	 *		div.getPath(); // Returns [].
	 *
	 * @returns {Array.<Number>} The path.
	 */
	getPath() {
		const path = [];
		let node = this; // eslint-disable-line consistent-this

		while ( node.parent ) {
			path.unshift( node.startOffset );
			node = node.parent;
		}

		return path;
	}

	/**
	 * Returns ancestors array of this node.
	 *
	 * @param {Object} options Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` this node will be also included in parent's array.
	 * @param {Boolean} [options.parentFirst=false] When set to `true`, array will be sorted from node's parent to root element,
	 * otherwise root element will be the first item in the array.
	 * @returns {Array} Array with ancestors.
	 */
	getAncestors( options = { includeSelf: false, parentFirst: false } ) {
		const ancestors = [];
		let parent = options.includeSelf ? this : this.parent;

		while ( parent ) {
			ancestors[ options.parentFirst ? 'push' : 'unshift' ]( parent );
			parent = parent.parent;
		}

		return ancestors;
	}

	/**
	 * Returns a {@link module:engine/model/element~Element} or {@link module:engine/model/documentfragment~DocumentFragment}
	 * which is a common ancestor of both nodes.
	 *
	 * @param {module:engine/model/node~Node} node The second node.
	 * @param {Object} options Options object.
	 * @param {Boolean} [options.includeSelf=false] When set to `true` both nodes will be considered "ancestors" too.
	 * Which means that if e.g. node A is inside B, then their common ancestor will be B.
	 * @returns {module:engine/model/element~Element|module:engine/model/documentfragment~DocumentFragment|null}
	 */
	getCommonAncestor( node, options = {} ) {
		const ancestorsA = this.getAncestors( options );
		const ancestorsB = node.getAncestors( options );

		let i = 0;

		while ( ancestorsA[ i ] == ancestorsB[ i ] && ancestorsA[ i ] ) {
			i++;
		}

		return i === 0 ? null : ancestorsA[ i - 1 ];
	}

	/**
	 * Returns whether this node is before given node. `false` is returned if nodes are in different trees (for example,
	 * in different {@link module:engine/model/documentfragment~DocumentFragment}s).
	 *
	 * @param {module:engine/model/node~Node} node Node to compare with.
	 * @returns {Boolean}
	 */
	isBefore( node ) {
		// Given node is not before this node if they are same.
		if ( this == node ) {
			return false;
		}

		// Return `false` if it is impossible to compare nodes.
		if ( this.root !== node.root ) {
			return false;
		}

		const thisPath = this.getPath();
		const nodePath = node.getPath();

		const result = Object(_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_2__["default"])( thisPath, nodePath );

		switch ( result ) {
			case 'prefix':
				return true;

			case 'extension':
				return false;

			default:
				return thisPath[ result ] < nodePath[ result ];
		}
	}

	/**
	 * Returns whether this node is after given node. `false` is returned if nodes are in different trees (for example,
	 * in different {@link module:engine/model/documentfragment~DocumentFragment}s).
	 *
	 * @param {module:engine/model/node~Node} node Node to compare with.
	 * @returns {Boolean}
	 */
	isAfter( node ) {
		// Given node is not before this node if they are same.
		if ( this == node ) {
			return false;
		}

		// Return `false` if it is impossible to compare nodes.
		if ( this.root !== node.root ) {
			return false;
		}

		// In other cases, just check if the `node` is before, and return the opposite.
		return !this.isBefore( node );
	}

	/**
	 * Checks if the node has an attribute with given key.
	 *
	 * @param {String} key Key of attribute to check.
	 * @returns {Boolean} `true` if attribute with given key is set on node, `false` otherwise.
	 */
	hasAttribute( key ) {
		return this._attrs.has( key );
	}

	/**
	 * Gets an attribute value for given key or `undefined` if that attribute is not set on node.
	 *
	 * @param {String} key Key of attribute to look for.
	 * @returns {*} Attribute value or `undefined`.
	 */
	getAttribute( key ) {
		return this._attrs.get( key );
	}

	/**
	 * Returns iterator that iterates over this node's attributes.
	 *
	 * Attributes are returned as arrays containing two items. First one is attribute key and second is attribute value.
	 * This format is accepted by native `Map` object and also can be passed in `Node` constructor.
	 *
	 * @returns {Iterable.<*>}
	 */
	getAttributes() {
		return this._attrs.entries();
	}

	/**
	 * Returns iterator that iterates over this node's attribute keys.
	 *
	 * @returns {Iterable.<String>}
	 */
	getAttributeKeys() {
		return this._attrs.keys();
	}

	/**
	 * Converts `Node` to plain object and returns it.
	 *
	 * @returns {Object} `Node` converted to plain object.
	 */
	toJSON() {
		const json = {};

		// Serializes attributes to the object.
		// attributes = { a: 'foo', b: 1, c: true }.
		if ( this._attrs.size ) {
			json.attributes = Array.from( this._attrs ).reduce( ( result, attr ) => {
				result[ attr[ 0 ] ] = attr[ 1 ];

				return result;
			}, {} );
		}

		return json;
	}

	/**
	 * Checks whether this object is of the given type.
	 *
	 * This method is useful when processing model objects that are of unknown type. For example, a function
	 * may return a {@link module:engine/model/documentfragment~DocumentFragment} or a {@link module:engine/model/node~Node}
	 * that can be either a text node or an element. This method can be used to check what kind of object is returned.
	 *
	 *		someObject.is( 'element' ); // -> true if this is an element
	 *		someObject.is( 'node' ); // -> true if this is a node (a text node or an element)
	 *		someObject.is( 'documentFragment' ); // -> true if this is a document fragment
	 *
	 * Since this method is also available on a range of view objects, you can prefix the type of the object with
	 * `model:` or `view:` to check, for example, if this is the model's or view's element:
	 *
	 *		modelElement.is( 'model:element' ); // -> true
	 *		modelElement.is( 'view:element' ); // -> false
	 *
	 * By using this method it is also possible to check a name of an element:
	 *
	 *		imageElement.is( 'element', 'image' ); // -> true
	 *		imageElement.is( 'element', 'image' ); // -> same as above
	 *		imageElement.is( 'model:element', 'image' ); // -> same as above, but more precise
	 *
	 * The list of model objects which implement the `is()` method:
	 *
	 * * {@link module:engine/model/node~Node#is `Node#is()`}
	 * * {@link module:engine/model/text~Text#is `Text#is()`}
	 * * {@link module:engine/model/element~Element#is `Element#is()`}
	 * * {@link module:engine/model/rootelement~RootElement#is `RootElement#is()`}
	 * * {@link module:engine/model/position~Position#is `Position#is()`}
	 * * {@link module:engine/model/liveposition~LivePosition#is `LivePosition#is()`}
	 * * {@link module:engine/model/range~Range#is `Range#is()`}
	 * * {@link module:engine/model/liverange~LiveRange#is `LiveRange#is()`}
	 * * {@link module:engine/model/documentfragment~DocumentFragment#is `DocumentFragment#is()`}
	 * * {@link module:engine/model/selection~Selection#is `Selection#is()`}
	 * * {@link module:engine/model/documentselection~DocumentSelection#is `DocumentSelection#is()`}
	 * * {@link module:engine/model/markercollection~Marker#is `Marker#is()`}
	 * * {@link module:engine/model/textproxy~TextProxy#is `TextProxy#is()`}
	 *
	 * @method #is
	 * @param {String} type Type to check.
	 * @returns {Boolean}
	 */
	is( type ) {
		return type === 'node' || type === 'model:node';
	}

	/**
	 * Creates a copy of this node, that is a node with exactly same attributes, and returns it.
	 *
	 * @protected
	 * @returns {module:engine/model/node~Node} Node with same attributes as this node.
	 */
	_clone() {
		return new Node( this._attrs );
	}

	/**
	 * Removes this node from it's parent.
	 *
	 * @see module:engine/model/writer~Writer#remove
	 * @protected
	 */
	_remove() {
		this.parent._removeChildren( this.index );
	}

	/**
	 * Sets attribute on the node. If attribute with the same key already is set, it's value is overwritten.
	 *
	 * @see module:engine/model/writer~Writer#setAttribute
	 * @protected
	 * @param {String} key Key of attribute to set.
	 * @param {*} value Attribute value.
	 */
	_setAttribute( key, value ) {
		this._attrs.set( key, value );
	}

	/**
	 * Removes all attributes from the node and sets given attributes.
	 *
	 * @see module:engine/model/writer~Writer#setAttributes
	 * @protected
	 * @param {Object} [attrs] Attributes to set. See {@link module:utils/tomap~toMap} for a list of accepted values.
	 */
	_setAttributesTo( attrs ) {
		this._attrs = Object(_ckeditor_ckeditor5_utils_src_tomap__WEBPACK_IMPORTED_MODULE_0__["default"])( attrs );
	}

	/**
	 * Removes an attribute with given key from the node.
	 *
	 * @see module:engine/model/writer~Writer#removeAttribute
	 * @protected
	 * @param {String} key Key of attribute to remove.
	 * @returns {Boolean} `true` if the attribute was set on the element, `false` otherwise.
	 */
	_removeAttribute( key ) {
		return this._attrs.delete( key );
	}

	/**
	 * Removes all attributes from the node.
	 *
	 * @see module:engine/model/writer~Writer#clearAttributes
	 * @protected
	 */
	_clearAttributes() {
		this._attrs.clear();
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return NodeList; });
/* harmony import */ var _node__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/node.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/nodelist
 */




/**
 * Provides an interface to operate on a list of {@link module:engine/model/node~Node nodes}. `NodeList` is used internally
 * in classes like {@link module:engine/model/element~Element Element}
 * or {@link module:engine/model/documentfragment~DocumentFragment DocumentFragment}.
 */
class NodeList {
	/**
	 * Creates an empty node list.
	 *
	 * @protected
	 * @param {Iterable.<module:engine/model/node~Node>} nodes Nodes contained in this node list.
	 */
	constructor( nodes ) {
		/**
		 * Nodes contained in this node list.
		 *
		 * @private
		 * @member {Array.<module:engine/model/node~Node>}
		 */
		this._nodes = [];

		if ( nodes ) {
			this._insertNodes( 0, nodes );
		}
	}

	/**
	 * Iterable interface.
	 *
	 * Iterates over all nodes contained inside this node list.
	 *
	 * @returns {Iterable.<module:engine/model/node~Node>}
	 */
	[ Symbol.iterator ]() {
		return this._nodes[ Symbol.iterator ]();
	}

	/**
	 * Number of nodes contained inside this node list.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get length() {
		return this._nodes.length;
	}

	/**
	 * Sum of {@link module:engine/model/node~Node#offsetSize offset sizes} of all nodes contained inside this node list.
	 *
	 * @readonly
	 * @type {Number}
	 */
	get maxOffset() {
		return this._nodes.reduce( ( sum, node ) => sum + node.offsetSize, 0 );
	}

	/**
	 * Gets the node at the given index. Returns `null` if incorrect index was passed.
	 *
	 * @param {Number} index Index of node.
	 * @returns {module:engine/model/node~Node|null} Node at given index.
	 */
	getNode( index ) {
		return this._nodes[ index ] || null;
	}

	/**
	 * Returns an index of the given node. Returns `null` if given node is not inside this node list.
	 *
	 * @param {module:engine/model/node~Node} node Child node to look for.
	 * @returns {Number|null} Child node's index.
	 */
	getNodeIndex( node ) {
		const index = this._nodes.indexOf( node );

		return index == -1 ? null : index;
	}

	/**
	 * Returns the starting offset of given node. Starting offset is equal to the sum of
	 * {@link module:engine/model/node~Node#offsetSize offset sizes} of all nodes that are before this node in this node list.
	 *
	 * @param {module:engine/model/node~Node} node Node to look for.
	 * @returns {Number|null} Node's starting offset.
	 */
	getNodeStartOffset( node ) {
		const index = this.getNodeIndex( node );

		return index === null ? null : this._nodes.slice( 0, index ).reduce( ( sum, node ) => sum + node.offsetSize, 0 );
	}

	/**
	 * Converts index to offset in node list.
	 *
	 * Returns starting offset of a node that is at given index. Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError}
	 * `model-nodelist-index-out-of-bounds` if given index is less than `0` or more than {@link #length}.
	 *
	 * @param {Number} index Node's index.
	 * @returns {Number} Node's starting offset.
	 */
	indexToOffset( index ) {
		if ( index == this._nodes.length ) {
			return this.maxOffset;
		}

		const node = this._nodes[ index ];

		if ( !node ) {
			/**
			 * Given index cannot be found in the node list.
			 *
			 * @error nodelist-index-out-of-bounds
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-nodelist-index-out-of-bounds: Given index cannot be found in the node list.', this );
		}

		return this.getNodeStartOffset( node );
	}

	/**
	 * Converts offset in node list to index.
	 *
	 * Returns index of a node that occupies given offset. Throws {@link module:utils/ckeditorerror~CKEditorError CKEditorError}
	 * `model-nodelist-offset-out-of-bounds` if given offset is less than `0` or more than {@link #maxOffset}.
	 *
	 * @param {Number} offset Offset to look for.
	 * @returns {Number} Index of a node that occupies given offset.
	 */
	offsetToIndex( offset ) {
		let totalOffset = 0;

		for ( const node of this._nodes ) {
			if ( offset >= totalOffset && offset < totalOffset + node.offsetSize ) {
				return this.getNodeIndex( node );
			}

			totalOffset += node.offsetSize;
		}

		if ( totalOffset != offset ) {
			/**
			 * Given offset cannot be found in the node list.
			 *
			 * @error model-nodelist-offset-out-of-bounds
			 * @param {Number} offset
			 * @param {module:engine/model/nodelist~NodeList} nodeList Stringified node list.
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"]( 'model-nodelist-offset-out-of-bounds: Given offset cannot be found in the node list.',
				this,
				{
					offset,
					nodeList: this
				}
			);
		}

		return this.length;
	}

	/**
	 * Inserts given nodes at given index.
	 *
	 * @protected
	 * @param {Number} index Index at which nodes should be inserted.
	 * @param {Iterable.<module:engine/model/node~Node>} nodes Nodes to be inserted.
	 */
	_insertNodes( index, nodes ) {
		// Validation.
		for ( const node of nodes ) {
			if ( !( node instanceof _node__WEBPACK_IMPORTED_MODULE_0__["default"] ) ) {
				/**
				 * Trying to insert an object which is not a Node instance.
				 *
				 * @error nodelist-insertNodes-not-node
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
					'model-nodelist-insertNodes-not-node: Trying to insert an object which is not a Node instance.',
					this
				);
			}
		}

		this._nodes.splice( index, 0, ...nodes );
	}

	/**
	 * Removes one or more nodes starting at the given index.
	 *
	 * @protected
	 * @param {Number} indexStart Index of the first node to remove.
	 * @param {Number} [howMany=1] Number of nodes to remove.
	 * @returns {Array.<module:engine/model/node~Node>} Array containing removed nodes.
	 */
	_removeNodes( indexStart, howMany = 1 ) {
		return this._nodes.splice( indexStart, howMany );
	}

	/**
	 * Converts `NodeList` instance to an array containing nodes that were inserted in the node list. Nodes
	 * are also converted to their plain object representation.
	 *
	 * @returns {Array.<module:engine/model/node~Node>} `NodeList` instance converted to `Array`.
	 */
	toJSON() {
		return this._nodes.map( node => node.toJSON() );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js ***!
  \*******************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return AttributeOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/lodash.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/attributeoperation
 */







/**
 * Operation to change nodes' attribute.
 *
 * Using this class you can add, remove or change value of the attribute.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class AttributeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes, removes or adds attributes.
	 *
	 * If only `newValue` is set, attribute will be added on a node. Note that all nodes in operation's range must not
	 * have an attribute with the same key as the added attribute.
	 *
	 * If only `oldValue` is set, then attribute with given key will be removed. Note that all nodes in operation's range
	 * must have an attribute with that key added.
	 *
	 * If both `newValue` and `oldValue` are set, then the operation will change the attribute value. Note that all nodes in
	 * operation's ranges must already have an attribute with given key and `oldValue` as value
	 *
	 * @param {module:engine/model/range~Range} range Range on which the operation should be applied. Must be a flat range.
	 * @param {String} key Key of an attribute to change or remove.
	 * @param {*} oldValue Old value of the attribute with given key or `null`, if attribute was not set before.
	 * @param {*} newValue New value of the attribute with given key or `null`, if operation should remove attribute.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( range, key, oldValue, newValue, baseVersion ) {
		super( baseVersion );

		/**
		 * Range on which operation should be applied.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.range = range.clone();

		/**
		 * Key of an attribute to change or remove.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.key = key;

		/**
		 * Old value of the attribute with given key or `null`, if attribute was not set before.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.oldValue = oldValue === undefined ? null : oldValue;

		/**
		 * New value of the attribute with given key or `null`, if operation should remove attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.newValue = newValue === undefined ? null : newValue;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.oldValue === null ) {
			return 'addAttribute';
		} else if ( this.newValue === null ) {
			return 'removeAttribute';
		} else {
			return 'changeAttribute';
		}
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation} Clone of this operation.
	 */
	clone() {
		return new AttributeOperation( this.range, this.key, this.oldValue, this.newValue, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	getReversed() {
		return new AttributeOperation( this.range, this.key, this.newValue, this.oldValue, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.range = this.range.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( !this.range.isFlat ) {
			/**
			 * The range to change is not flat.
			 *
			 * @error attribute-operation-range-not-flat
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"]( 'attribute-operation-range-not-flat: The range to change is not flat.', this );
		}

		for ( const item of this.range.getItems( { shallow: true } ) ) {
			if ( this.oldValue !== null && !Object(lodash_es__WEBPACK_IMPORTED_MODULE_4__["isEqual"])( item.getAttribute( this.key ), this.oldValue ) ) {
				/**
				 * Changed node has different attribute value than operation's old attribute value.
				 *
				 * @error attribute-operation-wrong-old-value
				 * @param {module:engine/model/item~Item} item
				 * @param {String} key
				 * @param {*} value
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
					'attribute-operation-wrong-old-value: Changed node has different attribute value than operation\'s ' +
					'old attribute value.',
					this,
					{ item, key: this.key, value: this.oldValue }
				);
			}

			if ( this.oldValue === null && this.newValue !== null && item.hasAttribute( this.key ) ) {
				/**
				 * The attribute with given key already exists for the given node.
				 *
				 * @error attribute-operation-attribute-exists
				 * @param {module:engine/model/node~Node} node
				 * @param {String} key
				 */
				throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
					'attribute-operation-attribute-exists: The attribute with given key already exists.',
					this,
					{ node: item, key: this.key }
				);
			}
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		// If value to set is same as old value, don't do anything.
		if ( !Object(lodash_es__WEBPACK_IMPORTED_MODULE_4__["isEqual"])( this.oldValue, this.newValue ) ) {
			// Execution.
			Object(_utils__WEBPACK_IMPORTED_MODULE_3__["_setAttribute"])( this.range, this.key, this.newValue );
		}
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'AttributeOperation';
	}

	/**
	 * Creates `AttributeOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	static fromJSON( json, document ) {
		return new AttributeOperation( _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.range, document ), json.key, json.oldValue, json.newValue, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `AttributeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.key }": ${ JSON.stringify( this.oldValue ) }` +
	// @if CK_DEBUG_ENGINE //		` -> ${ JSON.stringify( this.newValue ) }, ${ this.range }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/detachoperation.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/detachoperation.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DetachOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/detachoperation
 */






// @if CK_DEBUG_ENGINE // const ModelRange = require( '../range' ).default;

/**
 * Operation to permanently remove node from detached root.
 * Note this operation is only a local operation and won't be send to the other clients.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class DetachOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an insert operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition
	 * Position before the first {@link module:engine/model/item~Item model item} to move.
	 * @param {Number} howMany Offset size of moved range. Moved range will start from `sourcePosition` and end at
	 * `sourcePosition` with offset shifted by `howMany`.
	 */
	constructor( sourcePosition, howMany ) {
		super( null );

		/**
		 * Position before the first {@link module:engine/model/item~Item model item} to detach.
		 *
		 * @member {module:engine/model/position~Position} #sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();

		/**
		 * Offset size of moved range.
		 *
		 * @member {Number} #howMany
		 */
		this.howMany = howMany;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'detach';
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = this.sourcePosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( this.sourcePosition.root.document ) {
			/**
			 * Cannot detach document node.
			 *
			 * @error detach-operation-on-document-node
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"]( 'detach-operation-on-document-node: Cannot detach document node.', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		Object(_utils__WEBPACK_IMPORTED_MODULE_2__["_remove"])( _range__WEBPACK_IMPORTED_MODULE_1__["default"]._createFromPositionAndShift( this.sourcePosition, this.howMany ) );
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'DetachOperation';
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // const range = ModelRange._createFromPositionAndShift( this.sourcePosition, this.howMany );
	// @if CK_DEBUG_ENGINE //	const nodes = Array.from( range.getItems() );
	// @if CK_DEBUG_ENGINE //	const nodeString = nodes.length > 1 ? `[ ${ nodes.length } ]` : nodes[ 0 ];

	// @if CK_DEBUG_ENGINE //	return `DetachOperation( ${ this.baseVersion } ): ${ nodeString } -> ${ range }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return InsertOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _nodelist__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../nodelist */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/nodelist.js");
/* harmony import */ var _moveoperation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./moveoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../text */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/text.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../element */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/insertoperation
 */










/**
 * Operation to insert one or more nodes at given position in the model.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class InsertOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an insert operation.
	 *
	 * @param {module:engine/model/position~Position} position Position of insertion.
	 * @param {module:engine/model/node~NodeSet} nodes The list of nodes to be inserted.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( position, nodes, baseVersion ) {
		super( baseVersion );

		/**
		 * Position of insertion.
		 *
		 * @readonly
		 * @member {module:engine/model/position~Position} module:engine/model/operation/insertoperation~InsertOperation#position
		 */
		this.position = position.clone();
		this.position.stickiness = 'toNone';

		/**
		 * List of nodes to insert.
		 *
		 * @readonly
		 * @member {module:engine/model/nodelist~NodeList} module:engine/model/operation/insertoperation~InsertOperation#nodeList
		 */
		this.nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_normalizeNodes"])( nodes ) );

		/**
		 * Flag deciding how the operation should be transformed. If set to `true`, nodes might get additional attributes
		 * during operational transformation. This happens when the operation insertion position is inside of a range
		 * where attributes have changed.
		 *
		 * @member {Boolean} module:engine/model/operation/insertoperation~InsertOperation#shouldReceiveAttributes
		 */
		this.shouldReceiveAttributes = false;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'insert';
	}

	/**
	 * Total offset size of inserted nodes.
	 *
	 * @returns {Number}
	 */
	get howMany() {
		return this.nodes.maxOffset;
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/insertoperation~InsertOperation} Clone of this operation.
	 */
	clone() {
		const nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( [ ...this.nodes ].map( node => node._clone( true ) ) );
		const insert = new InsertOperation( this.position, nodes, this.baseVersion );

		insert.shouldReceiveAttributes = this.shouldReceiveAttributes;

		return insert;
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	getReversed() {
		const graveyard = this.position.root.document.graveyard;
		const gyPosition = new _position__WEBPACK_IMPORTED_MODULE_1__["default"]( graveyard, [ 0 ] );

		return new _moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"]( this.position, this.nodes.maxOffset, gyPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const targetElement = this.position.parent;

		if ( !targetElement || targetElement.maxOffset < this.position.offset ) {
			/**
			 * Insertion position is invalid.
			 *
			 * @error insert-operation-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_7__["default"](
				'insert-operation-position-invalid: Insertion position is invalid.',
				this
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		// What happens here is that we want original nodes be passed to writer because we want original nodes
		// to be inserted to the model. But in InsertOperation, we want to keep those nodes as they were added
		// to the operation, not modified. For example, text nodes can get merged or cropped while Elements can
		// get children. It is important that InsertOperation has the copy of original nodes in intact state.
		const originalNodes = this.nodes;
		this.nodes = new _nodelist__WEBPACK_IMPORTED_MODULE_2__["default"]( [ ...originalNodes ].map( node => node._clone( true ) ) );

		Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_insert"])( this.position, originalNodes );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.position = this.position.toJSON();
		json.nodes = this.nodes.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'InsertOperation';
	}

	/**
	 * Creates `InsertOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/insertoperation~InsertOperation}
	 */
	static fromJSON( json, document ) {
		const children = [];

		for ( const child of json.nodes ) {
			if ( child.name ) {
				// If child has name property, it is an Element.
				children.push( _element__WEBPACK_IMPORTED_MODULE_6__["default"].fromJSON( child ) );
			} else {
				// Otherwise, it is a Text node.
				children.push( _text__WEBPACK_IMPORTED_MODULE_5__["default"].fromJSON( child ) );
			}
		}

		const insert = new InsertOperation( _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.position, document ), children, json.baseVersion );
		insert.shouldReceiveAttributes = json.shouldReceiveAttributes;

		return insert;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	const nodeString = this.nodes.length > 1 ? `[ ${ this.nodes.length } ]` : this.nodes.getNode( 0 );

	// @if CK_DEBUG_ENGINE //	return `InsertOperation( ${ this.baseVersion } ): ${ nodeString } -> ${ this.position }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MarkerOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/markeroperation
 */




/**
 * @extends module:engine/model/operation/operation~Operation
 */
class MarkerOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * @param {String} name Marker name.
	 * @param {module:engine/model/range~Range} oldRange Marker range before the change.
	 * @param {module:engine/model/range~Range} newRange Marker range after the change.
	 * @param {module:engine/model/markercollection~MarkerCollection} markers Marker collection on which change should be executed.
	 * @param {Boolean} affectsData Specifies whether the marker operation affects the data produced by the data pipeline
	 * (is persisted in the editor's data).
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( name, oldRange, newRange, markers, affectsData, baseVersion ) {
		super( baseVersion );

		/**
		 * Marker name.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.name = name;

		/**
		 * Marker range before the change.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.oldRange = oldRange ? oldRange.clone() : null;

		/**
		 * Marker range after the change.
		 *
		 * @readonly
		 * @member {module:engine/model/range~Range}
		 */
		this.newRange = newRange ? newRange.clone() : null;

		/**
		 * Specifies whether the marker operation affects the data produced by the data pipeline
		 * (is persisted in the editor's data).
		 *
		 * @readonly
		 * @member {Boolean}
		 */
		this.affectsData = affectsData;

		/**
		 * Marker collection on which change should be executed.
		 *
		 * @private
		 * @member {module:engine/model/markercollection~MarkerCollection}
		 */
		this._markers = markers;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'marker';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation} Clone of this operation.
	 */
	clone() {
		return new MarkerOperation( this.name, this.oldRange, this.newRange, this._markers, this.affectsData, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation}
	 */
	getReversed() {
		return new MarkerOperation( this.name, this.newRange, this.oldRange, this._markers, this.affectsData, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const type = this.newRange ? '_set' : '_remove';

		this._markers[ type ]( this.name, this.newRange, true, this.affectsData );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		if ( this.oldRange ) {
			json.oldRange = this.oldRange.toJSON();
		}

		if ( this.newRange ) {
			json.newRange = this.newRange.toJSON();
		}

		delete json._markers;

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MarkerOperation';
	}

	/**
	 * Creates `MarkerOperation` object from deserialized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/markeroperation~MarkerOperation}
	 */
	static fromJSON( json, document ) {
		return new MarkerOperation(
			json.name,
			json.oldRange ? _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.oldRange, document ) : null,
			json.newRange ? _range__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.newRange, document ) : null,
			document.model.markers,
			json.affectsData,
			json.baseVersion
		);
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `MarkerOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.name }": ${ this.oldRange } -> ${ this.newRange }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MergeOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _splitoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./splitoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/mergeoperation
 */









/**
 * Operation to merge two {@link module:engine/model/element~Element elements}.
 *
 * The merged element is the parent of {@link ~MergeOperation#sourcePosition} and it is merged into the parent of
 * {@link ~MergeOperation#targetPosition}. All nodes from the merged element are moved to {@link ~MergeOperation#targetPosition}.
 *
 * The merged element is moved to the graveyard at {@link ~MergeOperation#graveyardPosition}.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class MergeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a merge operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition Position inside the merged element. All nodes from that
	 * element after that position will be moved to {@link ~#targetPosition}.
	 * @param {Number} howMany Summary offset size of nodes which will be moved from the merged element to the new parent.
	 * @param {module:engine/model/position~Position} targetPosition Position which the nodes from the merged elements will be moved to.
	 * @param {module:engine/model/position~Position} graveyardPosition Position in graveyard to which the merged element will be moved.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( sourcePosition, howMany, targetPosition, graveyardPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position inside the merged element. All nodes from that element after that position will be moved to {@link ~#targetPosition}.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();
		// This is, and should always remain, the first position in its parent.
		this.sourcePosition.stickiness = 'toPrevious';

		/**
		 * Summary offset size of nodes which will be moved from the merged element to the new parent.
		 *
		 * @member {Number} module:engine/model/operation/mergeoperation~MergeOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position which the nodes from the merged elements will be moved to.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#targetPosition
		 */
		this.targetPosition = targetPosition.clone();
		// Except of a rare scenario in `MergeOperation` x `MergeOperation` transformation,
		// this is, and should always remain, the last position in its parent.
		this.targetPosition.stickiness = 'toNext';

		/**
		 * Position in graveyard to which the merged element will be moved.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/mergeoperation~MergeOperation#graveyardPosition
		 */
		this.graveyardPosition = graveyardPosition.clone();
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'merge';
	}

	/**
	 * Position before the merged element (which will be deleted).
	 *
	 * @readonly
	 * @type {module:engine/model/position~Position}
	 */
	get deletionPosition() {
		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.sourcePosition.root, this.sourcePosition.path.slice( 0, -1 ) );
	}

	/**
	 * Artificial range that contains all the nodes from the merged element that will be moved to {@link ~MergeOperation#sourcePosition}.
	 * The range starts at {@link ~MergeOperation#sourcePosition} and ends in the same parent, at `POSITIVE_INFINITY` offset.
	 *
	 * @readonly
	 * @type {module:engine/model/range~Range}
	 */
	get movedRange() {
		const end = this.sourcePosition.getShiftedBy( Number.POSITIVE_INFINITY );

		return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.sourcePosition, end );
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation} Clone of this operation.
	 */
	clone() {
		return new this.constructor( this.sourcePosition, this.howMany, this.targetPosition, this.graveyardPosition, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation}
	 */
	getReversed() {
		// Positions in this method are transformed by this merge operation because the split operation bases on
		// the context after this merge operation happened (because split operation reverses it).
		// So we need to acknowledge that the merge operation happened and those positions changed a little.
		const targetPosition = this.targetPosition._getTransformedByMergeOperation( this );

		const path = this.sourcePosition.path.slice( 0, -1 );
		const insertionPosition = new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.sourcePosition.root, path )._getTransformedByMergeOperation( this );

		const split = new _splitoperation__WEBPACK_IMPORTED_MODULE_1__["default"]( targetPosition, this.howMany, this.graveyardPosition, this.baseVersion + 1 );
		split.insertionPosition = insertionPosition;

		return split;
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const sourceElement = this.sourcePosition.parent;
		const targetElement = this.targetPosition.parent;

		// Validate whether merge operation has correct parameters.
		if ( !sourceElement.parent ) {
			/**
			 * Merge source position is invalid. The element to be merged must have a parent node.
			 *
			 * @error merge-operation-source-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-source-position-invalid: Merge source position is invalid.', this );
		} else if ( !targetElement.parent ) {
			/**
			 * Merge target position is invalid. The element to be merged must have a parent node.
			 *
			 * @error merge-operation-target-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-target-position-invalid: Merge target position is invalid.', this );
		} else if ( this.howMany != sourceElement.maxOffset ) {
			/**
			 * Merge operation specifies wrong number of nodes to move.
			 *
			 * @error merge-operation-how-many-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'merge-operation-how-many-invalid: Merge operation specifies wrong number of nodes to move.', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const mergedElement = this.sourcePosition.parent;
		const sourceRange = _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createIn( mergedElement );

		Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_move"])( sourceRange, this.targetPosition );
		Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_move"])( _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createOn( mergedElement ), this.graveyardPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = json.sourcePosition.toJSON();
		json.targetPosition = json.targetPosition.toJSON();
		json.graveyardPosition = json.graveyardPosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MergeOperation';
	}

	/**
	 * Creates `MergeOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation}
	 */
	static fromJSON( json, document ) {
		const sourcePosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.sourcePosition, document );
		const targetPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.targetPosition, document );
		const graveyardPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.graveyardPosition, document );

		return new this( sourcePosition, json.howMany, targetPosition, graveyardPosition, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `MergeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`${ this.sourcePosition } -> ${ this.targetPosition }` +
	// @if CK_DEBUG_ENGINE //		` ( ${ this.howMany } ), ${ this.graveyardPosition }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js ***!
  \**************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return MoveOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/comparearrays */ "./node_modules/@ckeditor/ckeditor5-utils/src/comparearrays.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/moveoperation
 */








// @if CK_DEBUG_ENGINE // const ModelRange = require( '../range' ).default;

/**
 * Operation to move a range of {@link module:engine/model/item~Item model items}
 * to given {@link module:engine/model/position~Position target position}.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class MoveOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a move operation.
	 *
	 * @param {module:engine/model/position~Position} sourcePosition
	 * Position before the first {@link module:engine/model/item~Item model item} to move.
	 * @param {Number} howMany Offset size of moved range. Moved range will start from `sourcePosition` and end at
	 * `sourcePosition` with offset shifted by `howMany`.
	 * @param {module:engine/model/position~Position} targetPosition Position at which moved nodes will be inserted.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( sourcePosition, howMany, targetPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position before the first {@link module:engine/model/item~Item model item} to move.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/moveoperation~MoveOperation#sourcePosition
		 */
		this.sourcePosition = sourcePosition.clone();
		// `'toNext'` because `sourcePosition` is a bit like a start of the moved range.
		this.sourcePosition.stickiness = 'toNext';

		/**
		 * Offset size of moved range.
		 *
		 * @member {Number} module:engine/model/operation/moveoperation~MoveOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position at which moved nodes will be inserted.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/moveoperation~MoveOperation#targetPosition
		 */
		this.targetPosition = targetPosition.clone();
		this.targetPosition.stickiness = 'toNone';
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.targetPosition.root.rootName == '$graveyard' ) {
			return 'remove';
		} else if ( this.sourcePosition.root.rootName == '$graveyard' ) {
			return 'reinsert';
		}

		return 'move';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation} Clone of this operation.
	 */
	clone() {
		return new this.constructor( this.sourcePosition, this.howMany, this.targetPosition, this.baseVersion );
	}

	/**
	 * Returns the start position of the moved range after it got moved. This may be different than
	 * {@link module:engine/model/operation/moveoperation~MoveOperation#targetPosition} in some cases, i.e. when a range is moved
	 * inside the same parent but {@link module:engine/model/operation/moveoperation~MoveOperation#targetPosition targetPosition}
	 * is after {@link module:engine/model/operation/moveoperation~MoveOperation#sourcePosition sourcePosition}.
	 *
	 *		 vv              vv
	 *		abcdefg ===> adefbcg
	 *		     ^          ^
	 *		     targetPos	movedRangeStart
	 *		     offset 6	offset 4
	 *
	 * @returns {module:engine/model/position~Position}
	 */
	getMovedRangeStart() {
		return this.targetPosition._getTransformedByDeletion( this.sourcePosition, this.howMany );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	getReversed() {
		const newTargetPosition = this.sourcePosition._getTransformedByInsertion( this.targetPosition, this.howMany );

		return new this.constructor( this.getMovedRangeStart(), this.howMany, newTargetPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const sourceElement = this.sourcePosition.parent;
		const targetElement = this.targetPosition.parent;
		const sourceOffset = this.sourcePosition.offset;
		const targetOffset = this.targetPosition.offset;

		// Validate whether move operation has correct parameters.
		// Validation is pretty complex but move operation is one of the core ways to manipulate the document state.
		// We expect that many errors might be connected with one of scenarios described below.
		if ( sourceOffset + this.howMany > sourceElement.maxOffset ) {
			/**
			 * The nodes which should be moved do not exist.
			 *
			 * @error move-operation-nodes-do-not-exist
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
				'move-operation-nodes-do-not-exist: The nodes which should be moved do not exist.', this
			);
		} else if ( sourceElement === targetElement && sourceOffset < targetOffset && targetOffset < sourceOffset + this.howMany ) {
			/**
			 * Trying to move a range of nodes into the middle of that range.
			 *
			 * @error move-operation-range-into-itself
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
				'move-operation-range-into-itself: Trying to move a range of nodes to the inside of that range.', this
			);
		} else if ( this.sourcePosition.root == this.targetPosition.root ) {
			if ( Object(_ckeditor_ckeditor5_utils_src_comparearrays__WEBPACK_IMPORTED_MODULE_4__["default"])( this.sourcePosition.getParentPath(), this.targetPosition.getParentPath() ) == 'prefix' ) {
				const i = this.sourcePosition.path.length - 1;

				if ( this.targetPosition.path[ i ] >= sourceOffset && this.targetPosition.path[ i ] < sourceOffset + this.howMany ) {
					/**
					 * Trying to move a range of nodes into one of nodes from that range.
					 *
					 * @error move-operation-node-into-itself
					 */
					throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_3__["default"](
						'move-operation-node-into-itself: Trying to move a range of nodes into one of nodes from that range.', this
					);
				}
			}
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		Object(_utils__WEBPACK_IMPORTED_MODULE_5__["_move"])( _range__WEBPACK_IMPORTED_MODULE_2__["default"]._createFromPositionAndShift( this.sourcePosition, this.howMany ), this.targetPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.sourcePosition = this.sourcePosition.toJSON();
		json.targetPosition = this.targetPosition.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'MoveOperation';
	}

	/**
	 * Creates `MoveOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/moveoperation~MoveOperation}
	 */
	static fromJSON( json, document ) {
		const sourcePosition = _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.sourcePosition, document );
		const targetPosition = _position__WEBPACK_IMPORTED_MODULE_1__["default"].fromJSON( json.targetPosition, document );

		return new this( sourcePosition, json.howMany, targetPosition, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	const range = ModelRange._createFromPositionAndShift( this.sourcePosition, this.howMany );

	// @if CK_DEBUG_ENGINE //	return `MoveOperation( ${ this.baseVersion } ): ${ range } -> ${ this.targetPosition }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js ***!
  \************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return NoOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/nooperation
 */



/**
 * Operation which is doing nothing ("empty operation", "do-nothing operation", "noop"). This is an operation,
 * which when executed does not change the tree model. It still has some parameters defined for transformation purposes.
 *
 * In most cases this operation is a result of transforming operations. When transformation returns
 * {@link module:engine/model/operation/nooperation~NoOperation} it means that changes done by the transformed operation
 * have already been applied.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class NoOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	get type() {
		return 'noop';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/nooperation~NoOperation} Clone of this operation.
	 */
	clone() {
		return new NoOperation( this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/nooperation~NoOperation}
	 */
	getReversed() {
		return new NoOperation( this.baseVersion + 1 );
	}

	_execute() {
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'NoOperation';
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `NoOperation( ${ this.baseVersion } )`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js ***!
  \**********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Operation; });
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/operation
 */

/**
 * Abstract base operation class.
 *
 * @abstract
 */
class Operation {
	/**
	 * Base operation constructor.
	 *
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( baseVersion ) {
		/**
		 * {@link module:engine/model/document~Document#version} on which operation can be applied. If you try to
		 * {@link module:engine/model/model~Model#applyOperation apply} operation with different base version than the
		 * {@link module:engine/model/document~Document#version document version} the
		 * {@link module:utils/ckeditorerror~CKEditorError model-document-applyOperation-wrong-version} error is thrown.
		 *
		 * @member {Number}
		 */
		this.baseVersion = baseVersion;

		/**
		 * Defines whether operation is executed on attached or detached {@link module:engine/model/item~Item items}.
		 *
		 * @readonly
		 * @member {Boolean} #isDocumentOperation
		 */
		this.isDocumentOperation = this.baseVersion !== null;

		/**
		 * {@link module:engine/model/batch~Batch Batch} to which the operation is added or `null` if the operation is not
		 * added to any batch yet.
		 *
		 * @member {module:engine/model/batch~Batch|null} #batch
		 */
		this.batch = null;

		/**
		 * Operation type.
		 *
		 * @readonly
		 * @member {String} #type
		 */

		/**
		 * Creates and returns an operation that has the same parameters as this operation.
		 *
		 * @method #clone
		 * @returns {module:engine/model/operation/operation~Operation} Clone of this operation.
		 */

		/**
		 * Creates and returns a reverse operation. Reverse operation when executed right after
		 * the original operation will bring back tree model state to the point before the original
		 * operation execution. In other words, it reverses changes done by the original operation.
		 *
		 * Keep in mind that tree model state may change since executing the original operation,
		 * so reverse operation will be "outdated". In that case you will need to transform it by
		 * all operations that were executed after the original operation.
		 *
		 * @method #getReversed
		 * @returns {module:engine/model/operation/operation~Operation} Reversed operation.
		 */

		/**
		 * Executes the operation - modifications described by the operation properties will be applied to the model tree.
		 *
		 * @protected
		 * @method #_execute
		 */
	}

	/**
	 * Checks whether the operation's parameters are correct and the operation can be correctly executed. Throws
	 * an error if operation is not valid.
	 *
	 * @protected
	 * @method #_validate
	 */
	_validate() {
	}

	/**
	 * Custom toJSON method to solve child-parent circular dependencies.
	 *
	 * @method #toJSON
	 * @returns {Object} Clone of this object with the operation property replaced with string.
	 */
	toJSON() {
		// This method creates only a shallow copy, all nested objects should be defined separately.
		// See https://github.com/ckeditor/ckeditor5-engine/issues/1477.
		const json = Object.assign( {}, this );

		json.__className = this.constructor.className;

		// Remove reference to the parent `Batch` to avoid circular dependencies.
		delete json.batch;

		// Only document operations are shared with other clients so it is not necessary to keep this information.
		delete json.isDocumentOperation;

		return json;
	}

	/**
	 * Name of the operation class used for serialization.
	 *
	 * @type {String}
	 */
	static get className() {
		return 'Operation';
	}

	/**
	 * Creates Operation object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} doc Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	static fromJSON( json ) {
		return new this( json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // log() {
	// @if CK_DEBUG_ENGINE // 	console.log( this.toString() );
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operationfactory.js ***!
  \*****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return OperationFactory; });
/* harmony import */ var _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../operation/attributeoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/attributeoperation.js");
/* harmony import */ var _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../operation/insertoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/insertoperation.js");
/* harmony import */ var _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../operation/markeroperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/markeroperation.js");
/* harmony import */ var _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../operation/moveoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/moveoperation.js");
/* harmony import */ var _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../operation/nooperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/nooperation.js");
/* harmony import */ var _operation_operation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../operation/operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../operation/renameoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js");
/* harmony import */ var _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../operation/rootattributeoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js");
/* harmony import */ var _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../operation/splitoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js");
/* harmony import */ var _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../operation/mergeoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/operationfactory
 */












const operations = {};
operations[ _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__["default"].className ] = _operation_attributeoperation__WEBPACK_IMPORTED_MODULE_0__["default"];
operations[ _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__["default"].className ] = _operation_insertoperation__WEBPACK_IMPORTED_MODULE_1__["default"];
operations[ _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__["default"].className ] = _operation_markeroperation__WEBPACK_IMPORTED_MODULE_2__["default"];
operations[ _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"].className ] = _operation_moveoperation__WEBPACK_IMPORTED_MODULE_3__["default"];
operations[ _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__["default"].className ] = _operation_nooperation__WEBPACK_IMPORTED_MODULE_4__["default"];
operations[ _operation_operation__WEBPACK_IMPORTED_MODULE_5__["default"].className ] = _operation_operation__WEBPACK_IMPORTED_MODULE_5__["default"];
operations[ _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__["default"].className ] = _operation_renameoperation__WEBPACK_IMPORTED_MODULE_6__["default"];
operations[ _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__["default"].className ] = _operation_rootattributeoperation__WEBPACK_IMPORTED_MODULE_7__["default"];
operations[ _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__["default"].className ] = _operation_splitoperation__WEBPACK_IMPORTED_MODULE_8__["default"];
operations[ _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__["default"].className ] = _operation_mergeoperation__WEBPACK_IMPORTED_MODULE_9__["default"];

/**
 * A factory class for creating operations.
 *
 * @abstract
 */
class OperationFactory {
	/**
	 * Creates an operation instance from a JSON object (parsed JSON string).
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/operation~Operation}
	 */
	static fromJSON( json, document ) {
		return operations[ json.__className ].fromJSON( json, document );
	}
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/renameoperation.js ***!
  \****************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return RenameOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../element */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/element.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/renameoperation
 */






/**
 * Operation to change element's name.
 *
 * Using this class you can change element's name.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class RenameOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes element's name.
	 *
	 * @param {module:engine/model/position~Position} position Position before an element to change.
	 * @param {String} oldName Current name of the element.
	 * @param {String} newName New name for the element.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( position, oldName, newName, baseVersion ) {
		super( baseVersion );

		/**
		 * Position before an element to change.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/renameoperation~RenameOperation#position
		 */
		this.position = position;
		// This position sticks to the next node because it is a position before the node that we want to change.
		this.position.stickiness = 'toNext';

		/**
		 * Current name of the element.
		 *
		 * @member {String} module:engine/model/operation/renameoperation~RenameOperation#oldName
		 */
		this.oldName = oldName;

		/**
		 * New name for the element.
		 *
		 * @member {String} module:engine/model/operation/renameoperation~RenameOperation#newName
		 */
		this.newName = newName;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'rename';
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/renameoperation~RenameOperation} Clone of this operation.
	 */
	clone() {
		return new RenameOperation( this.position.clone(), this.oldName, this.newName, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/renameoperation~RenameOperation}
	 */
	getReversed() {
		return new RenameOperation( this.position.clone(), this.newName, this.oldName, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const element = this.position.nodeAfter;

		if ( !( element instanceof _element__WEBPACK_IMPORTED_MODULE_1__["default"] ) ) {
			/**
			 * Given position is invalid or node after it is not instance of Element.
			 *
			 * @error rename-operation-wrong-position
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'rename-operation-wrong-position: Given position is invalid or node after it is not an instance of Element.',
				this
			);
		} else if ( element.name !== this.oldName ) {
			/**
			 * Element to change has different name than operation's old name.
			 *
			 * @error rename-operation-wrong-name
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_2__["default"](
				'rename-operation-wrong-name: Element to change has different name than operation\'s old name.',
				this
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const element = this.position.nodeAfter;

		element.name = this.newName;
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.position = this.position.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'RenameOperation';
	}

	/**
	 * Creates `RenameOperation` object from deserialized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/attributeoperation~AttributeOperation}
	 */
	static fromJSON( json, document ) {
		return new RenameOperation( _position__WEBPACK_IMPORTED_MODULE_3__["default"].fromJSON( json.position, document ), json.oldName, json.newName, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `RenameOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`${ this.position }: "${ this.oldName }" -> "${ this.newName }"`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/rootattributeoperation.js ***!
  \***********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return RootAttributeOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/rootattributeoperation
 */




/**
 * Operation to change root element's attribute. Using this class you can add, remove or change value of the attribute.
 *
 * This operation is needed, because root elements can't be changed through
 * @link module:engine/model/operation/attributeoperation~AttributeOperation}.
 * It is because {@link module:engine/model/operation/attributeoperation~AttributeOperation}
 * requires a range to change and root element can't
 * be a part of range because every {@link module:engine/model/position~Position} has to be inside a root.
 * {@link module:engine/model/position~Position} can't be created before a root element.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class RootAttributeOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates an operation that changes, removes or adds attributes on root element.
	 *
	 * @see module:engine/model/operation/attributeoperation~AttributeOperation
	 * @param {module:engine/model/rootelement~RootElement} root Root element to change.
	 * @param {String} key Key of an attribute to change or remove.
	 * @param {*} oldValue Old value of the attribute with given key or `null` if adding a new attribute.
	 * @param {*} newValue New value to set for the attribute. If `null`, then the operation just removes the attribute.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( root, key, oldValue, newValue, baseVersion ) {
		super( baseVersion );

		/**
		 * Root element to change.
		 *
		 * @readonly
		 * @member {module:engine/model/rootelement~RootElement}
		 */
		this.root = root;

		/**
		 * Key of an attribute to change or remove.
		 *
		 * @readonly
		 * @member {String}
		 */
		this.key = key;

		/**
		 * Old value of the attribute with given key or `null` if adding a new attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.oldValue = oldValue;

		/**
		 * New value to set for the attribute. If `null`, then the operation just removes the attribute.
		 *
		 * @readonly
		 * @member {*}
		 */
		this.newValue = newValue;
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		if ( this.oldValue === null ) {
			return 'addRootAttribute';
		} else if ( this.newValue === null ) {
			return 'removeRootAttribute';
		} else {
			return 'changeRootAttribute';
		}
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation} Clone of this operation.
	 */
	clone() {
		return new RootAttributeOperation( this.root, this.key, this.oldValue, this.newValue, this.baseVersion );
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation}
	 */
	getReversed() {
		return new RootAttributeOperation( this.root, this.key, this.newValue, this.oldValue, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		if ( this.root != this.root.root || this.root.is( 'documentFragment' ) ) {
			/**
			 * The element to change is not a root element.
			 *
			 * @error rootattribute-operation-not-a-root
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 * @param {*} value
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-not-a-root: The element to change is not a root element.',
				this,
				{ root: this.root, key: this.key }
			);
		}

		if ( this.oldValue !== null && this.root.getAttribute( this.key ) !== this.oldValue ) {
			/**
			 * The attribute which should be removed does not exists for the given node.
			 *
			 * @error rootattribute-operation-wrong-old-value
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 * @param {*} value
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-wrong-old-value: Changed node has different attribute value than operation\'s ' +
				'old attribute value.',
				this,
				{ root: this.root, key: this.key }
			);
		}

		if ( this.oldValue === null && this.newValue !== null && this.root.hasAttribute( this.key ) ) {
			/**
			 * The attribute with given key already exists for the given node.
			 *
			 * @error rootattribute-operation-attribute-exists
			 * @param {module:engine/model/rootelement~RootElement} root
			 * @param {String} key
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-attribute-exists: The attribute with given key already exists.',
				this,
				{ root: this.root, key: this.key }
			);
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		if ( this.newValue !== null ) {
			this.root._setAttribute( this.key, this.newValue );
		} else {
			this.root._removeAttribute( this.key );
		}
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.root = this.root.toJSON();

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'RootAttributeOperation';
	}

	/**
	 * Creates RootAttributeOperation object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/rootattributeoperation~RootAttributeOperation}
	 */
	static fromJSON( json, document ) {
		if ( !document.getRoot( json.root ) ) {
			/**
			 * Cannot create RootAttributeOperation for document. Root with specified name does not exist.
			 *
			 * @error rootattributeoperation-fromjson-no-root
			 * @param {String} rootName
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_1__["default"](
				'rootattribute-operation-fromjson-no-root: Cannot create RootAttributeOperation. Root with specified name does not exist.',
				this,
				{ rootName: json.root }
			);
		}

		return new RootAttributeOperation( document.getRoot( json.root ), json.key, json.oldValue, json.newValue, json.baseVersion );
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `RootAttributeOperation( ${ this.baseVersion } ): ` +
	// @if CK_DEBUG_ENGINE //		`"${ this.key }": ${ JSON.stringify( this.oldValue ) }` +
	// @if CK_DEBUG_ENGINE //		` -> ${ JSON.stringify( this.newValue ) }, ${ this.root.rootName }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/splitoperation.js ***!
  \***************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return SplitOperation; });
/* harmony import */ var _operation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./operation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/operation.js");
/* harmony import */ var _mergeoperation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergeoperation */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/mergeoperation.js");
/* harmony import */ var _position__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../position */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/position.js");
/* harmony import */ var _range__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../range */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/range.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils */ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/utils.js");
/* harmony import */ var _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ckeditor/ckeditor5-utils/src/ckeditorerror */ "./node_modules/@ckeditor/ckeditor5-utils/src/ckeditorerror.js");
/**
 * @license Copyright (c) 2003-2020, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see LICENSE.md or https://ckeditor.com/legal/ckeditor-oss-license
 */

/**
 * @module engine/model/operation/splitoperation
 */









/**
 * Operation to split {@link module:engine/model/element~Element an element} at given
 * {@link module:engine/model/operation/splitoperation~SplitOperation#splitPosition split position} into two elements,
 * both containing a part of the element's original content.
 *
 * @extends module:engine/model/operation/operation~Operation
 */
class SplitOperation extends _operation__WEBPACK_IMPORTED_MODULE_0__["default"] {
	/**
	 * Creates a split operation.
	 *
	 * @param {module:engine/model/position~Position} splitPosition Position at which an element should be split.
	 * @param {Number} howMany Total offset size of elements that are in the split element after `position`.
	 * @param {module:engine/model/position~Position|null} graveyardPosition Position in the graveyard root before the element which
	 * should be used as a parent of the nodes after `position`. If it is not set, a copy of the the `position` parent will be used.
	 * @param {Number|null} baseVersion Document {@link module:engine/model/document~Document#version} on which operation
	 * can be applied or `null` if the operation operates on detached (non-document) tree.
	 */
	constructor( splitPosition, howMany, graveyardPosition, baseVersion ) {
		super( baseVersion );

		/**
		 * Position at which an element should be split.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/splitoperation~SplitOperation#splitPosition
		 */
		this.splitPosition = splitPosition.clone();
		// Keep position sticking to the next node. This way any new content added at the place where the element is split
		// will be left in the original element.
		this.splitPosition.stickiness = 'toNext';

		/**
		 * Total offset size of elements that are in the split element after `position`.
		 *
		 * @member {Number} module:engine/model/operation/splitoperation~SplitOperation#howMany
		 */
		this.howMany = howMany;

		/**
		 * Position at which the clone of split element (or element from graveyard) will be inserted.
		 *
		 * @member {module:engine/model/position~Position} module:engine/model/operation/splitoperation~SplitOperation#insertionPosition
		 */
		this.insertionPosition = SplitOperation.getInsertionPosition( splitPosition );
		this.insertionPosition.stickiness = 'toNone';

		/**
		 * Position in the graveyard root before the element which should be used as a parent of the nodes after `position`.
		 * If it is not set, a copy of the the `position` parent will be used.
		 *
		 * The default behavior is to clone the split element. Element from graveyard is used during undo.
		 *
		 * @member {module:engine/model/position~Position|null} #graveyardPosition
		 */
		this.graveyardPosition = graveyardPosition ? graveyardPosition.clone() : null;

		if ( this.graveyardPosition ) {
			this.graveyardPosition.stickiness = 'toNext';
		}
	}

	/**
	 * @inheritDoc
	 */
	get type() {
		return 'split';
	}

	/**
	 * Position inside the new clone of a split element.
	 *
	 * This is a position where nodes that are after the split position will be moved to.
	 *
	 * @readonly
	 * @type {module:engine/model/position~Position}
	 */
	get moveTargetPosition() {
		const path = this.insertionPosition.path.slice();
		path.push( 0 );

		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( this.insertionPosition.root, path );
	}

	/**
	 * Artificial range that contains all the nodes from the split element that will be moved to the new element.
	 * The range starts at {@link ~#splitPosition} and ends in the same parent, at `POSITIVE_INFINITY` offset.
	 *
	 * @readonly
	 * @type {module:engine/model/range~Range}
	 */
	get movedRange() {
		const end = this.splitPosition.getShiftedBy( Number.POSITIVE_INFINITY );

		return new _range__WEBPACK_IMPORTED_MODULE_3__["default"]( this.splitPosition, end );
	}

	/**
	 * Creates and returns an operation that has the same parameters as this operation.
	 *
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation} Clone of this operation.
	 */
	clone() {
		const split = new this.constructor( this.splitPosition, this.howMany, this.graveyardPosition, this.baseVersion );
		split.insertionPosition = this.insertionPosition;

		return split;
	}

	/**
	 * See {@link module:engine/model/operation/operation~Operation#getReversed `Operation#getReversed()`}.
	 *
	 * @returns {module:engine/model/operation/mergeoperation~MergeOperation}
	 */
	getReversed() {
		const graveyard = this.splitPosition.root.document.graveyard;
		const graveyardPosition = new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( graveyard, [ 0 ] );

		return new _mergeoperation__WEBPACK_IMPORTED_MODULE_1__["default"]( this.moveTargetPosition, this.howMany, this.splitPosition, graveyardPosition, this.baseVersion + 1 );
	}

	/**
	 * @inheritDoc
	 */
	_validate() {
		const element = this.splitPosition.parent;
		const offset = this.splitPosition.offset;

		// Validate whether split operation has correct parameters.
		if ( !element || element.maxOffset < offset ) {
			/**
			 * Split position is invalid.
			 *
			 * @error split-operation-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-position-invalid: Split position is invalid.', this );
		} else if ( !element.parent ) {
			/**
			 * Cannot split root element.
			 *
			 * @error split-operation-split-in-root
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-split-in-root: Cannot split root element.', this );
		} else if ( this.howMany != element.maxOffset - this.splitPosition.offset ) {
			/**
			 * Split operation specifies wrong number of nodes to move.
			 *
			 * @error split-operation-how-many-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-how-many-invalid: Split operation specifies wrong number of nodes to move.', this );
		} else if ( this.graveyardPosition && !this.graveyardPosition.nodeAfter ) {
			/**
			 * Graveyard position invalid.
			 *
			 * @error split-operation-graveyard-position-invalid
			 */
			throw new _ckeditor_ckeditor5_utils_src_ckeditorerror__WEBPACK_IMPORTED_MODULE_5__["default"]( 'split-operation-graveyard-position-invalid: Graveyard position invalid.', this );
		}
	}

	/**
	 * @inheritDoc
	 */
	_execute() {
		const splitElement = this.splitPosition.parent;

		if ( this.graveyardPosition ) {
			Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_move"])( _range__WEBPACK_IMPORTED_MODULE_3__["default"]._createFromPositionAndShift( this.graveyardPosition, 1 ), this.insertionPosition );
		} else {
			const newElement = splitElement._clone();

			Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_insert"])( this.insertionPosition, newElement );
		}

		const sourceRange = new _range__WEBPACK_IMPORTED_MODULE_3__["default"](
			_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( splitElement, this.splitPosition.offset ),
			_position__WEBPACK_IMPORTED_MODULE_2__["default"]._createAt( splitElement, splitElement.maxOffset )
		);

		Object(_utils__WEBPACK_IMPORTED_MODULE_4__["_move"])( sourceRange, this.moveTargetPosition );
	}

	/**
	 * @inheritDoc
	 */
	toJSON() {
		const json = super.toJSON();

		json.splitPosition = this.splitPosition.toJSON();
		json.insertionPosition = this.insertionPosition.toJSON();

		if ( this.graveyardPosition ) {
			json.graveyardPosition = this.graveyardPosition.toJSON();
		}

		return json;
	}

	/**
	 * @inheritDoc
	 */
	static get className() {
		return 'SplitOperation';
	}

	/**
	 * Helper function that returns a default insertion position basing on given `splitPosition`. The default insertion
	 * position is after the split element.
	 *
	 * @param {module:engine/model/position~Position} splitPosition
	 * @returns {module:engine/model/position~Position}
	 */
	static getInsertionPosition( splitPosition ) {
		const path = splitPosition.path.slice( 0, -1 );
		path[ path.length - 1 ]++;

		return new _position__WEBPACK_IMPORTED_MODULE_2__["default"]( splitPosition.root, path );
	}

	/**
	 * Creates `SplitOperation` object from deserilized object, i.e. from parsed JSON string.
	 *
	 * @param {Object} json Deserialized JSON object.
	 * @param {module:engine/model/document~Document} document Document on which this operation will be applied.
	 * @returns {module:engine/model/operation/splitoperation~SplitOperation}
	 */
	static fromJSON( json, document ) {
		const splitPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.splitPosition, document );
		const insertionPosition = _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.insertionPosition, document );
		const graveyardPosition = json.graveyardPosition ? _position__WEBPACK_IMPORTED_MODULE_2__["default"].fromJSON( json.graveyardPosition, document ) : null;

		const split = new this( splitPosition, json.howMany, graveyardPosition, json.baseVersion );
		split.insertionPosition = insertionPosition;

		return split;
	}

	// @if CK_DEBUG_ENGINE // toString() {
	// @if CK_DEBUG_ENGINE // 	return `SplitOperation( ${ this.baseVersion } ): ${ this.splitPosition } ` +
	// @if CK_DEBUG_ENGINE //		`( ${ this.howMany } ) -> ${ this.insertionPosition }` +
	// @if CK_DEBUG_ENGINE //		`${ this.graveyardPosition ? ' with ' + this.graveyardPosition : '' }`;
	// @if CK_DEBUG_ENGINE // }
}


/***/ }),

/***/ "./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/transform.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@ckeditor/ckeditor5-engine/src/model/operation/transform.js ***!
  \********************************************************************