$(document).ready(function () {
    const csrfToken = $('meta[name="csrf-token"]').attr("content");

    const table = new Tabulator("#donor-table", {
        ajaxURL: getDonorRoute,
        ajaxConfig: {
            method: "POST",
            headers: {
                "X-CSRF-TOKEN": csrfToken,
            },
        },
        ajaxParams: function () {
            return {
                search: $("#search-string").val(),
                organisation_id: $("#org-size").val(),
                amount_flag: $("#defaulter_mem").val(),
            };
        },
        layout: "fitColumns",
        theme: "bootstrap5",
        paginationMode: "remote",
        pagination: true,
        paginationSize: 10,
        paginationSizeSelector: [10, 25, 50],
        movableRows: true,
        movableColumns: true,
        ajaxLoaderLoading: `
                <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data...</div>
            `,
        columns: [
            {
                title: "SL",
                field: "sl",
                width: 10,
                maxWidth: 15,
                hozAlign: "left",
                headerHozAlign: "left",
                formatter: function (cell) {
                    const row = cell.getRow();
                    const page = table.getPage() || 1;
                    const perPage = table.getPageSize() || 10;
                    return row.getPosition(true) + 1 + (page - 1) * perPage - 1;
                },
            },
            {
                title: "Name",
                field: "donor_name",
                headerHozAlign: "left",
                hozAlign: "left",
                width: 150,
                maxWidth: 200,
            },
            {
                title: "Type",
                field: "donor_type",
                headerHozAlign: "left",
                hozAlign: "left",
                minWidth: 150,
                maxWidth: 200,
                formatter: function (cell) {
                    const value = cell.getValue();
                    switch (value) {
                        case "members":
                            return "Member";
                        case "foreign_members":
                            return "Family Member";
                        case "non_members":
                            return "Non-Member";
                        default:
                            return value ?? "-";
                    }
                },
            },
            {
                title: "Folio No.",
                field: "donor_folio_no",
                headerHozAlign: "left",
                hozAlign: "left",
                minWidth: 120,
                maxWidth: 180,
            },
            {
                title: "Phone No.",
                field: "donor_phone_number",
                headerHozAlign: "left",
                hozAlign: "left",
                width: 140,
                maxWidth: 140,
            },
            {
                title: "Address",
                field: "donor_address",
                headerHozAlign: "left",
                hozAlign: "left",
                width: 140,
                // maxWidth: 140,
            },
            {
                title: "Plan",
                headerHozAlign: "center",
                hozAlign: "center",
                width: 140,
                maxWidth: 140,
                formatter: function (cell) {
                    let row_val = cell.getRow().getData().amount_flag;
                    console.log(row_val);
                    if (row_val === "paid") {
                        return `<button class="status-true" disabled>Paid</button>`;
                    } else {
                        return `<button class="status-false" disabled>Not Paid</button>`;
                    }
                },
            },
            {
                title: "Actions",
                headerSort: false,
                headerHozAlign: "left",
                hozAlign: "left",
                minWidth: 120,

                formatter: function (cell) {
                    const row = cell.getRow().getData();
                    if (!canAddDonation) return "";

                    const encodedId = btoa(row.donor_id);

                    return `
            <div style="display:flex; gap:8px; align-items:center;">
                <a href="javascript:void(0);"
                   class="editDonor"
                   data-id="${encodedId}"
                   title="Edit Donor">
                    <svg xmlns="http://www.w3.org/2000/svg"
                        width="18" height="18" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor"
                        stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path d="M12 20h9"></path>
                        <path d="M16.5 3.5a2.1 2.1 0 0 1 3 3L7 19l-4 1 1-4Z"></path>
                    </svg>
                </a>
          
                <a href="javascript:void(0);"
                   class="addDonation"
                   data-id="${encodedId}"
                   title="Add Donation">
                    <svg xmlns="http://www.w3.org/2000/svg"
                        width="18" height="18" viewBox="0 0 24 24"
                        fill="none" stroke="currentColor"
                        stroke-width="1.5" stroke-linecap="round"
                        stroke-linejoin="round">
                        <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                        <line x1="12" y1="8" x2="12" y2="16"></line>
                        <line x1="8" y1="12" x2="16" y2="12"></line>
                    </svg>
                </a>              
            </div>
        `;
                },

                cellClick: function (e, cell) {
                    const $target = $(e.target).closest("a");
                    const encodedId = $target.data("id");

                    if (!encodedId) return;

                    if ($target.hasClass("addDonation")) {
                        window.location.href = `/member/donation/create/${encodedId}`;
                    }

                    if ($target.hasClass("editDonor")) {
                        window.location.href = `/donor/edit/${encodedId}`;
                    }
                },
            },
        ],
        ajaxResponse: function (url, params, response) {
            return {
                data: response.data,
                last_page: response.last_page,
                current_page: response.current_page,
                total: response.total,
            };
        },
    });
    $("#org-size, #defaulter_mem").change(function () {
        table.setData();
    });
    $("#search-string").on("input", function () {
        table.setData();
    });
    $("#page-size").on("change", function () {
        table.setPageSize(Number(this.value));
    });
});
