$(document).ready(function () {
    var isSubscription = false;
    var remainingBalance = 0;
    let form = initFormValidation('#modalTransactionForm');

    $(form).find('#submitTransaction').on('click', function (e) {
        $('.amount-error').html('');
        let submitButton = $('#submitTransaction');
        e.preventDefault();

        if (isAllFieldValidated(form) && customValidateAmount($("#remaining_amount_value").val())) {
            submitButton.prop('disabled', true).text('Submitting...');
            form_submit();
        }
    });

    function form_submit() {

        var fd = new FormData();
        fd.append('isSubscription', isSubscription);
        fd.append('donorId', $("#donor_id").val().trim());
        fd.append('accountTypeId', $("#account_type_id").val().trim());
        fd.append('headId', $("#head_id").val());
        fd.append('headName', $("#head_name").val());
        fd.append('headGroupId', $("#head_group_id").val());
        fd.append('date', $("#transaction_date").val());
        fd.append('paymentType', $("#payment_type_id").val());
        fd.append('amount', $("#remaining_amount_value").val());
        fd.append('receiptNo', $("#money_receipt_no").val());
        fd.append('narration', $('#transaction_narration').val().trim());
        fd.append('_token', $('input[name="_token"]').val());

        let submitButton = $('#submitTransaction');
        $.ajax({
            type: "POST",
            url: storeTransactionRoute,
            dataType: 'json',
            data: fd,
            processData: false,
            contentType: false,

            success: function (response) {
                if (response.status == true) {
                    toastr.success(response.msg, "Success", toastrProperties);
                    submitButton.prop('disabled', false).text('Save');
                    closeModal();
                    location.reload();
                } else {
                    toastr.error(response.msg, "Error", toastrProperties);
                    submitButton.prop('disabled', false).text('Save');
                }
            },
            error: function (xhr, status, errorThrown) {
                toastr.error("Some error Occurred. Please try again later. Error : " + errorThrown, "Error", toastrProperties);
                submitButton.prop('disabled', false).text('Save');
                closeModal();
            }
        });
    }

    $(document).on('click', '.add-subscription-btn, .add-donation-btn', function () {
        isSubscription = $(this).hasClass('add-subscription-btn') ? true : false;
        remainingBalance = $(this).data('remaining-value');
        const data = {
            isSubscription: isSubscription,
            donorId: $(this).data('donor-id'),
            accountTypeId: $(this).data('account-type-id'),
            headId: $(this).data('head-id'),
            headName: $(this).data('head-name'),
            headGroupId: $(this).data('head-group-id'),
            donorName: $(this).data('member')
        };
        if (isSubscription) {
            data.remainingBalance = remainingBalance;
        }
        openTransactionModal(data);
    });

    $(document).on('click', '#closeTransactionModal, .close-btn', function (e) {
        closeModal();
    });



    function openTransactionModal(data) {
        let heading = data.isSubscription ? "Add Subscription" : "Add Donation";
        $('#modalHeading').html(heading);
        $('#donor_id').val(data.donorId);
        $('#account_type_id').val(data.accountTypeId);
        $('#head_id').val(data.headId);
        $('#head_name').val(data.headName);
        $('#head_group_id').val(data.headGroupId);
        $('#member_name').val(data.donorName);

        if (data.isSubscription) {
            $('#remaining_amount_value').val(data.remainingBalance);
        }
        openModal();
    }

    function openModal() {
        $(`#transactionModal`).css('display', 'flex');
    }

    function closeModal() {
        $(`#transactionModal`).hide();
        $('#modalTransactionForm')[0].reset();
    }

    function customValidateAmount(amount) {
        if (amount != null && remainingBalance != null) {
            if (amount < 100 || amount > 500) {
                $('.amount-error').html(`Amount must be between ₹100 - ₹500`);
                return false;
            }
            if (amount > remainingBalance) {
                $('.amount-error').html(`Amount cannot be greater than remaining balance ₹${remainingBalance}`);
                return false;
            }
        }
        return true;
    }
});
function openModalTable(name, amnt, data) {
    if (typeof data === 'string') data = JSON.parse(data);
    let html = '';
    $.each(data, function (_, item) {
        html += `<tr>
                    <td style="text-align:left;">${item.date}</td>
                    <td style="text-align:right;">${item.amount}</td>
                </tr>`;
    });
    $('#open-modal .modal_body').html(html);
    $('#open-modal .modal_name').html(name);
    $('#open-modal .modal_total_amount').html(amnt);
    $('#open-modal').show();
};

function closeModalTable() {
    $('#open-modal').hide();
};