function validateDepreciation() {
    const $rate = $('#depriciation_rate');
    const $ext = $('#rte_extention');
    const rateVal = $.trim($rate.val());
    const extVal = $ext.val();

    // Remove previous error messages
    $rate.parent().find('._error_msg').remove();
    $ext.parent().find('._error_msg').remove();

    let isValid = true;

    // Validate rate number (integer or float)
    if (isNaN(rateVal)) {
        $rate.parent().append(
            $('<span>', {
                class: '_error_msg',
                text: 'Enter a valid number for depreciation rate.',
                css: { color: 'red', margin: '5px 0px', display: 'block', 'font-size': '12px' }
            })
        );
        isValid = false;
    } else {
        const number = parseFloat(rateVal);
        if (number < 0) {
            $rate.parent().append(
                $('<span>', {
                    class: '_error_msg',
                    text: 'Rate cannot be negative.',
                    css: { color: 'red', margin: '5px 0px', display: 'block', 'font-size': '12px' }
                })
            );
            isValid = false;
        }
    }

    // Validate dropdown selection
    if (rateVal !== '' && extVal === '') {
        $ext.parent().append(
            $('<span>', {
                class: '_error_msg',
                text: 'Please select Amount or Percentage.',
                css: { color: 'red', margin: '5px 0px', display: 'block', 'font-size': '12px' }
            })
        );
        isValid = false;
    }

    return isValid;
}
