const REG_NO_MAX_LENGTH = 10;
const MAX_FILE_SIZE = 1 * 250 * 250;
const MAX_FILE_SIZE_2 = 1 * 512 * 512;
const MAX_FILE_SIZE_3 = 1 * 1024 * 1024;
const MAX_FILE_SIZE_4 = 1 * 2048 * 2048;
const MAX_ICON_SIZE = 1 * 100 * 100;
const MAX_ICON_SIZE_2 = 1 * 250 * 250;
const MAX_IMAGE_SIZE = 1 * 150 * 150;
const MAX_IMAGE_SIZE_2 = 1 * 512 * 512;
function initFormValidation(formSelector) {
  const form = document.querySelector(formSelector);
  if (!form) return;
  nameFieldInput(form);
  phoneFieldInput(form);
  ageFieldInput(form);
  numbersOnlyInput(form);
  textOnlyInput(form);
  infoFieldInput(form);
  specialCharsOnlyInput(form);
  hideErrorsOnInputInput(form);
  return form;
}
function isAllFieldValidated(form) {
  removeAllMessageWarnings(form);
  const elements = form.querySelectorAll("*");
  for (let element of elements) {
    if (element.matches("input, select, textarea")) {
      if (element.classList.contains("_required") && !requiredField(element))
        return false;
      if (element.classList.contains("_name") && !nameField(element))
        return false;
      if (element.classList.contains("_email") && !emailField(element))
        return false;
      if (element.classList.contains("_password") && !passwordField(element))
        return false;
      if (
        element.classList.contains("_cpassword") &&
        !confirmPasswordField(element, form)
      )
        return false;
      if (element.classList.contains("_phone") && !phoneField(element))
        return false;
      if (element.classList.contains("_dob") && !dobField(element))
        return false;
      if (element.classList.contains("_url") && !urlField(element))
        return false;
      if (element.classList.contains("_path") && !pathField(element))
        return false;
      if (element.classList.contains("_age") && !ageField(element))
        return false;
      if (element.classList.contains("_amount") && !amountField(element))
        return false;
      if (element.classList.contains("_image") && !imageField(element))
        return false;
      if (element.classList.contains("_image2") && !imageField2(element))
        return false;
      if (element.classList.contains("_icon") && !iconField(element))
        return false;
      if (element.classList.contains("_icon2") && !iconField2(element))
        return false;
      if (element.classList.contains("_file") && !fileField(element))
        return false;
      if (element.classList.contains("_file2") && !fileField2(element))
        return false;
      if (element.classList.contains("_file3") && !fileField3(element))
        return false;
      if (element.classList.contains("_file4") && !fileField4(element))
        return false;
      if (element.classList.contains("_heading") && !headingField(element))
        return false;
      if (element.classList.contains("_nohtml") && !noHTML(element))
        return false;
      if (element.classList.contains("_nocss") && !noCSS(element)) return false;
      if (element.classList.contains("_noJS") && !noJS(element)) return false;
      if (element.classList.contains("_noSpecialChars") && !noSpecialChars(element)) return false;
    }
  }
  return true;
}

function msgHTML(msg) {
  const span = document.createElement("span");
  span.className = "_error_msg";
  span.style.color = "red";
  span.style.margin = "5px 10px";
  span.style.display = "block";
  span.innerText = msg;
  return span;
}
function removeAllMessageWarnings(form) {
  const warningMessages = form.getElementsByClassName("_error_msg");
  Array.from(warningMessages).forEach((el) => el.remove());
}
function requiredField(element) {
  if (element.value.trim() === "") {
    element.parentNode.appendChild(msgHTML("This is a required field."));
    element.focus();
    return false;
  }
  return true;
}
function nameField(element) {
  const nameRegex = /^[A-Za-z\s.]+$/;
  if (element.value.trim() !== "" && !nameRegex.test(element.value.trim())) {
    element.parentNode.appendChild(msgHTML("It must be a valid name."));
    element.focus();
    return false;
  }
  return true;
}
function headingField(element) {
  const value = element.value.trimStart();
  if (/^\s/.test(element.value)) {
    element.parentNode.appendChild(
      msgHTML("Heading cannot start with a space.")
    );
    element.focus();
    return false;
  }
  // Regex explanation:
  // ^[A-Za-z'"\$&] -> first character must be a letter or allowed symbol
  // [A-Za-z0-9\s'"\$&/.,:?!#*()\-]* -> remaining characters can include digits, spaces, slashes, and other allowed symbols
  const headingRegex = /^[A-Za-z'"\$&][A-Za-z0-9\s'"\$&/.,:?!#*()\-]*$/;
  if (value !== "" && !headingRegex.test(value)) {
    element.parentNode.appendChild(
      msgHTML(
        "Heading can't start with a number or unusual symbol. Allowed symbols: ' \"$&/.,:?!#*()-"
      )
    );
    element.focus();
    return false;
  }
  return true;
}
function fileField(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_FILE_SIZE) {
    element.parentNode.appendChild(
      msgHTML("File size must be less than 250 KB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function fileField2(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_FILE_SIZE_2) {
    element.parentNode.appendChild(
      msgHTML("File size must be less than 512 KB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function fileField3(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_FILE_SIZE_3) {
    element.parentNode.appendChild(
      msgHTML("File size must be less than 1 MB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function fileField4(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_FILE_SIZE_4) {
    element.parentNode.appendChild(
      msgHTML("File size must be less than 2 MB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function iconField(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_ICON_SIZE) {
    element.parentNode.appendChild(
      msgHTML("Icon size must be less than 100 KB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function iconField2(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_ICON_SIZE_2) {
    element.parentNode.appendChild(
      msgHTML("Icon size must be less than 250 KB.")
    );
    element.value = ""; // clear invalid input
    element.focus();
    return false;
  }
  return true;
}
function imageField(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_IMAGE_SIZE) {
    element.parentNode.appendChild(
      msgHTML("Image size must be less than 150 KB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function imageField2(element) {
  const file = element.files[0];
  if (!file) return true;
  if (file.size > MAX_IMAGE_SIZE_2) {
    element.parentNode.appendChild(
      msgHTML("Image size must be less than 512 KB.")
    );
    element.value = "";
    element.focus();
    return false;
  }
  return true;
}
function emailField(element) {
  const emailRegex = /^[a-zA-Z0-9._%+-]+@([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}$/;
  const value = element.value.trim();

  if (value !== "" && !emailRegex.test(value)) {
    element.parentNode.appendChild(msgHTML("It must be a valid email."));
    element.focus();
    return false;
  }

  return true;
}
function passwordField(element) {
  const passwordRegex =
    /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]{8,}$/;
  if (!passwordRegex.test(element.value.trim())) {
    element.parentNode.appendChild(
      msgHTML(
        "Password must be at least 8 characters long and include uppercase, lowercase, number, and special character."
      )
    );
    element.focus();
    return false;
  }
  return true;
}
function confirmPasswordField(element, form) {
  const passwordInput = form.querySelector("._password");
  if (!passwordInput) return true;
  if (element.value.trim() !== passwordInput.value.trim()) {
    element.parentNode.appendChild(msgHTML("Passwords do not match."));
    element.focus();
    return false;
  }
  return true;
}
function phoneField(element) {
  const phoneRegex = /^(?:\+?\d{1,4}[-.\s]?)?(?:\d{2,5}[-.\s]?)?\d{6,10}$/;
  const value = element.value.trim();

  if (value !== "" && !phoneRegex.test(value)) {
    element.parentNode.appendChild(
      msgHTML(
        "Enter a valid phone number (e.g., +91 9876543210 or 022-40779110)."
      )
    );
    element.focus();
    return false;
  }

  return true;
}
function dobField(element) {
  const value = element.value.trim();

  if (element.value.trim() === "") {
    return true;
  }

  const dobDate = new Date(value);
  const today = new Date();
  today.setHours(0, 0, 0, 0);
  dobDate.setHours(0, 0, 0, 0);

  if (dobDate > today) {
    element.parentNode.appendChild(msgHTML("DOB cannot be a future date."));
    element.focus();
    return false;
  }

  let age = today.getFullYear() - dobDate.getFullYear();
  const m = today.getMonth() - dobDate.getMonth();
  if (m < 0 || (m === 0 && today.getDate() < dobDate.getDate())) {
    age--;
  }

  if (age < 5) {
    element.parentNode.appendChild(msgHTML("One must be of at least 5 years."));
    element.focus();
    return false;
  }
  return true;
}
function ageField(element) {
  const value = element.value.trim();
  const age = parseInt(value, 10);

  if (element.value.trim() === "") {
    return true;
  }
  if (isNaN(age) || age < 5 || age > 120) {
    element.parentNode.appendChild(
      msgHTML("Enter a valid age (must be at least 5 years and realistic).")
    );
    element.focus();
    return false;
  }

  return true;
}
function urlField(element) {
  const urlRegex = /^(https?:\/\/)?([\w-]+\.)+[\w-]{2,}(\/[^\s]*)?$/i;
  if (element.value.trim() !== "" && !urlRegex.test(element.value.trim())) {
    element.parentNode.appendChild(
      msgHTML("Enter a valid URL (e.g., https://example.com).")
    );
    element.focus();
    return false;
  }
  return true;
}
function pathField(element) {
  const pathRegex = /^(\/[A-Za-z0-9._~-]+(?:\/[A-Za-z0-9._~-]+)*)$/;

  if (element.value.trim() !== "" && !pathRegex.test(element.value.trim())) {
    element.parentNode.appendChild(
      msgHTML("Enter a valid path (e.g., /home/products/item-1).")
    );
    element.focus();
    return false;
  }
  return true;
}

function noHTML(form) {
  const elements = form.getElementsByClassName("_nohtml");
  const htmlRegex = /<[^>]*>/; // detects any HTML tags
  for (let el of elements) {
    if (htmlRegex.test(el.value.trim())) {
      el.parentNode.appendChild(msgHTML("HTML is not allowed."));
      el.focus();
      return false;
    }
  }
  return true;
}
function noCSS(form) {
  const elements = form.getElementsByClassName("_nocss");
  const cssRegex = /<style[\s\S]*?>[\s\S]*?<\/style>|style\s*=/i;
  for (let el of elements) {
    if (cssRegex.test(el.value.trim())) {
      el.parentNode.appendChild(msgHTML("CSS is not allowed."));
      el.focus();
      return false;
    }
  }
  return true;
}
function noJS(form) {
  const elements = form.getElementsByClassName("_nojs");
  const jsRegex =
    /<script[\s\S]*?>[\s\S]*?<\/script>|function\s*\(|console\.|document\.|window\./i;
  for (let el of elements) {
    if (jsRegex.test(el.value.trim())) {
      el.parentNode.appendChild(msgHTML("JavaScript is not allowed."));
      el.focus();
      return false;
    }
  }
  return true;
}
function amountField(element) {
  const amountRegex = /^(?:\d+|\d*\.\d{1,2})$/;
  const value = element.value.trim();

  if (value !== "" && (!amountRegex.test(value) || parseFloat(value) <= 0)) {
    element.parentNode.appendChild(
      msgHTML("It must be a valid amount greater than 0.")
    );
    element.focus();
    return false;
  }

  return true;
}
function nameFieldInput(form) {
  const nameElements = form.getElementsByClassName("_name");
  for (let element of nameElements) {
    element.addEventListener("input", function () {
      element.value = element.value
        .split("")
        .filter((char) => /^[A-Za-z\s.]$/.test(char))
        .join("");
    });
  }
}
function phoneFieldInput(form) {
  const phoneElements = form.getElementsByClassName("_phone");
  for (let element of phoneElements) {
    element.addEventListener("input", function () {
      element.value = element.value.replace(/[^0-9+\-.\s]/g, "");
    });
  }
}
function numbersOnlyInput(form) {
  const numberElements = form.getElementsByClassName("_numbersOnly");
  for (let element of numberElements) {
    element.addEventListener("input", function () {
      element.value = element.value.replace(/[^0-9]/g, "");
    });
  }
}
function ageFieldInput(form) {
  const ageElements = form.getElementsByClassName("_age");
  for (let element of ageElements) {
    element.addEventListener("input", function () {
      element.value = element.value
        .split("")
        .filter((char) => /^[0-9]$/.test(char))
        .join("");
    });
  }
}
function textOnlyInput(form) {
  const textElements = form.getElementsByClassName("_textOnly");
  for (let element of textElements) {
    element.addEventListener("input", function () {
      element.value = element.value.replace(/[^A-Za-z\s]/g, "");
    });
  }
}
function infoFieldInput(form) {
  const infoElements = form.getElementsByClassName("_info");
  for (let element of infoElements) {
    element.addEventListener("input", function () {
      element.value = element.value.replace(/[^A-Za-z0-9\s,.\-\/|()]/g, "");
    });
  }
}
function specialCharsOnlyInput(form) {
  const elements = form.getElementsByClassName("_specialCharsOnly");
  for (let element of elements) {
    element.addEventListener("input", function () {
      element.value = element.value.replace(/[^A-Za-z0-9\s]/g, "");
    });
  }
}
function noSpecialChars(element) {
  maxLength = REG_NO_MAX_LENGTH;
  const value = element.value;

  if (/^\s/.test(value)) {
    element.parentNode.appendChild(msgHTML("Field cannot start with a space."));
    element.focus();
    return false;
  }

  const regex = /^[A-Za-z0-9\s]+$/;
  if (value !== "" && !regex.test(value)) {
    element.parentNode.appendChild(
      msgHTML("Only letters, numbers, and spaces are allowed.")
    );
    element.focus();
    return false;
  }

  if (REG_NO_MAX_LENGTH && value.length > REG_NO_MAX_LENGTH) {
    element.parentNode.appendChild(
      msgHTML(`Maximum ${REG_NO_MAX_LENGTH} characters allowed.`)
    );
    element.focus();
    return false;
  }
  return true;
}

function hideErrorsOnInputInput(form) {
  const inputs = form.querySelectorAll("input, textarea, select"); // all input fields
  inputs.forEach((input) => {
    input.addEventListener("input", () => {
      const errorElements = form.getElementsByClassName("_error_msg");
      for (let el of errorElements) {
        el.style.display = "none";
      }
    });
  });
}
