@extends('master.authMaster')


@section('content')
    {{-- Form --}}

    <div class="intro-y col-span-12 lg:col-span-12">
        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5">
            <!-- BEGIN: Horizontal Form -->
            <div class="intro-y box mt-5">
                <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                    <h2 class="font-medium text-base mr-auto">
                        Assets
                    </h2>
                </div>
                <div class="p-5" id="horizontal-form">
                    <form id="assetForm" method="POST">
                        @csrf
                        <div class="preview">
                            {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                            <div class="intro-y col-span-12 lg:col-span-12">
                                <!-- BEGIN: Input -->
                                <div class="intro-y">
                                    <div class="p-5" id="input">
                                        <div class="preview">
                                            @php
                                                use Carbon\Carbon;
                                                $financialYear = \App\Models\AccountingYear::current();
                                                $orgId = \App\Models\Organisation::current()->organisation_id;

                                                [$startDate, $endDate] = explode(
                                                    ' to ',
                                                    $financialYear->accounting_year_financial,
                                                );

                                                $startDate = Carbon::createFromFormat('d-m-Y', trim($startDate));
                                                $endDate = Carbon::createFromFormat('d-m-Y', trim($endDate));

                                                $today = Carbon::today();

                                                if ($today->between($startDate, $endDate)) {
                                                    $maxDate = $today->toDateString();
                                                } else {
                                                    $maxDate = $endDate->toDateString();
                                                }

                                                $minDate = $startDate->toDateString();
                                            @endphp
                                            <div class="w-full -ml-4 -mr-4 flex flex-wrap">

                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Organisation <span style="color: red">*</span></label>
                                                        <select id="organisation_id" name="organisation_id"
                                                            class="input w-full border mt-2" disabled>
                                                            <option value="">-- Select Organisation --</option>
                                                            @foreach ($organisations as $organisation)
                                                                <option value="{{ $organisation->organisation_id }}"
                                                                    {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                                                    {{ $organisation->organisation_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-organisation"></div>
                                                    </div>
                                                </div>
                                                <input type="hidden" value="{{ $orgId }}" id="organisation_id"
                                                    name="organisation_id">
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3" id="accountTypeWrapper">
                                                        <label>Division<span style="color: red">*</span></label>
                                                        <select id="account_type_id" name="account_type_id"
                                                            class="input w-full border mt-2" disabled>
                                                            <option value="">-- Select Account Type --</option>
                                                        </select>
                                                        <small id="accountTypeMsg" class="text-red-500"
                                                            style="display:none;">
                                                            Please select organisation first
                                                        </small>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-account-type"></div>
                                                    </div>
                                                </div>

                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Head</label>
                                                        <select id="head_id" name="head_id"
                                                            class="input w-full border mt-2">
                                                            <option value="">-- Select Head --</option>
                                                            @foreach ($heads as $head)
                                                                <option value="{{ $head->id }}"
                                                                    {{ old('head_id') == $head->id ? 'selected' : '' }}>
                                                                    {{ $head->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-head-id"></div>
                                                    </div>
                                                </div>

                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Asset Name<span style="color: red">*</span></label>
                                                        <input id="asset_name" type="text"
                                                            class="input w-full border mt-2" name="asset_name"
                                                            value="{{ old('asset_name') }}" placeholder="Enter Asset Name">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-name"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Banks</label>
                                                        <select id="bank_id" name="bank_id"
                                                            class="input w-full border mt-2">
                                                            <option value="">-- Select Bank --</option>
                                                            @foreach ($banks as $bank)
                                                                <option value="{{ $bank->id }}"
                                                                    {{ old('bank_id') == $bank->id ? 'selected' : '' }}>
                                                                    {{ $bank->name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-bank-id"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Opening Balance</label>
                                                        <input id="asset_opening_balance" type="text"
                                                            class="input w-full border mt-2" name="asset_opening_balance"
                                                            value="{{ old('asset_opening_balance') }}"
                                                            placeholder="Enter Opening Balance" maxlength="20">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-opening-balance"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Asset Purchase Date<span style="color: red">*</span></label>
                                                        <input type="date" class="input w-full border mt-2"
                                                            name="purchase_date" min="{{ $minDate }}"
                                                            max="{{ $maxDate }}"
                                                            value="{{ old('purchase_date', now()->toDateString()) }}"
                                                            onfocus="this.showPicker()" />
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-date">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Asset Purchase Cost (₹) <span
                                                                style="color: red">*</span></label>
                                                        <input type="text" class="input w-full border mt-2"
                                                            name="purchase_cost" value="{{ old('purchase_cost') }}"
                                                            placeholder="Enter Purchase Cost">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-cost"></div>
                                                    </div>
                                                </div>


                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Asset Useful Life (Years)</label>
                                                        <select name="asset_useful_life" class="input w-full border mt-2">
                                                            <option value="">-- Select Useful Life --</option>
                                                            @for ($i = 1; $i <= 50; $i++)
                                                                <option value="{{ $i }}"
                                                                    {{ old('asset_useful_life') == $i ? 'selected' : '' }}>
                                                                    {{ $i }} Year{{ $i > 1 ? 's' : '' }}
                                                                </option>
                                                            @endfor
                                                        </select>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-useful-life"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- </div> --}}

                            </div>
                            <div class="sm:pl-5 mt-5">

                                <a href="{{ route('asset.index') }}"><button type="button"
                                        class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">
                                        ← Back
                                    </button></a>
                                <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <!-- END: Horizontal Form -->
        </div>
        <!-- END: Select Options -->
    </div>
    {{-- <div class="intro-y col-span-12 lg:col-span-6">
    </div> --}}
    <script>
        // fields validations : starts
        $("#asset_name").on("change", function() {
            let value = $(this).val().trim();

            if (!/^[A-Za-z\s]+$/.test(value)) {
                $("#error-asset-name").text("Asset Name must contain only letters and spaces");
                $(this).addClass("border-red-500");
            } else if (value.length > 60) {
                $("#error-asset-name").text("Asset Name cannot exceed 255 characters");
                $(this).addClass("border-red-500");
            } else {
                $("#error-asset-name").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#asset_name").on("input", function() {
            this.value = this.value.replace(/[^A-Za-z\s]/g, "");
            if (this.value.length > 60) {
                this.value = this.value.substring(0, 60);
            }
        });
        $("input[name='asset_opening_balance'], input[name='purchase_cost']").on("input", function() {
            let val = this.value;
            val = val.replace(/[^0-9.]/g, "");
            let parts = val.split(".");
            if (parts.length > 2) {
                val = parts[0] + "." + parts.slice(1).join("");
            }
            if (/^0[0-9]/.test(val)) {
                val = val.replace(/^0+/, "");
            }
            if (val.startsWith("0.") || val === "0") {
                val = val.replace(/^0+/, "");
            }

            this.value = val;
        });
        // fields validation : ends
        //organisation and accountype checking start.
        let accountTypes = @json($accountTypes);
        let orgSelect = document.getElementById('organisation_id');
        let accSelect = document.getElementById('account_type_id');
        let msg = document.getElementById('accountTypeMsg');


        let oldOrg = "{{ old('organisation_id', $orgId) }}";
        let oldAcc = "{{ old('account_type_id') }}";

        function populateAccountTypes(oldOrg) {
            accSelect.innerHTML = '<option value="">-- Select Account Type --</option>';

            if (oldOrg) {
                let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

                if (filtered.length > 0) {
                    document.getElementById("accountTypeWrapper").style.display = "block";
                    filtered.forEach(at => {
                        let option = document.createElement('option');
                        option.value = at.account_type_id;
                        option.textContent = at.account_type_Name;

                        if (oldAcc == at.account_type_id) {
                            option.selected = true;
                        }
                        accSelect.appendChild(option);
                    });

                    accSelect.disabled = false;
                    msg.style.display = "none";
                } else {
                    accSelect.disabled = true;
                    msg.textContent = "No account types found for this organisation.";
                    msg.style.display = "block";
                    document.getElementById("accountTypeWrapper").style.display = "none";
                }
            } else {
                accSelect.disabled = true;
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
            }
        }

        orgSelect.addEventListener('change', function() {
            populateAccountTypes(this.value);
        });

        accSelect.addEventListener('focus', function() {
            if (!orgSelect.value) {
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
                setTimeout(() => msg.style.display = "none", 2000);
            }
        });

        if (oldOrg) {
            populateAccountTypes(oldOrg);
        }
        //organisation and accountype checking end.


        $(document).ready(function() {



            $("#assetForm").on("submit", function(e) {
                e.preventDefault();

                $(".error-message").text("");
                $("input, select, textarea").removeClass("border-red-500");

                let isValid = true;

                if ($.trim($("#organisation_id").val()) === "") {
                    $("#error-organisation").text("Organisation is required");
                    $("#organisation").addClass("border-red-500");
                    isValid = false;
                }

                let orgId = $("#organisation_id").val();
                let filtered = accountTypes.filter(at => at.organisation_id == orgId);

                if (filtered.length > 0) {
                    if ($.trim($("#account_type_id").val()) === "") {
                        $("#error-account-type").text("Account Type is required");
                        $("#account_type_id").addClass("border-red-500");
                        isValid = false;
                    }
                }

                if ($.trim($("#asset_name").val()) === "") {
                    $("#error-asset-name").text("Asset Name is required");
                    $("#asset_name").addClass("border-red-500");
                    isValid = false;
                }

                if ($.trim($("input[name='purchase_cost']").val()) === "") {
                    $("#error-cost").text("Purchase Cost is required");
                    $("input[name='purchase_cost']").addClass("border-red-500");
                    isValid = false;
                }

                if ($.trim($("input[name='purchase_date']").val()) === "") {
                    $("#error-date").text("Purchase Date is required");
                    $("input[name='purchase_date']").addClass("border-red-500");
                    isValid = false;
                }


                if (!isValid) {
                    return;
                }

                $.ajax({
                    url: "{{ route('asset.store') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    success: function(response) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: 'Asset saved successfully!',
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = "{{ route('asset.index') }}";
                        });
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let messages = [];
                            for (let key in errors) {
                                messages.push(errors[key][0]);
                            }
                            alert(messages.join("\n"));
                        } else {
                            alert("Something went wrong. Please try again.");
                        }
                    }
                });
            });

            $("#organisation_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-organisation").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#asset_name").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-asset-name").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#purchase_cost").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-cost").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#purchase_date").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-date").text("");
                    $(this).removeClass("border-red-500");
                }
            });
            $("#account_type_id").on("change", function() {
                if ($(this).val().trim() !== "") {
                    $("#error-account-type").text("");
                    $(this).removeClass("border-red-500");
                }
            });

        });
    </script>
@endsection
