@extends('master.authMaster')


@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">
        {{-- Form --}}
        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5">
            <!-- BEGIN: Horizontal Form -->
            <div class="intro-y box mt-5">
                <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                    <h2 class="font-medium text-base mr-auto">
                        Accounting Years
                    </h2>

                </div>
                <div class="p-5" id="horizontal-form">

                    <form method="POST" action="{{ route('accounting_years.store') }}">
                        @csrf
                        <div class="preview">
                            {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                            <div class="intro-y col-span-12 lg:col-span-12">
                                <!-- BEGIN: Input -->
                                <div class="intro-y">

                                    <div class="p-5" id="input">
                                        <div class="preview">
                                            <div class="w-full -ml-4 -mr-4 flex flex-wrap">
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Organisation <span style="color: red">*</span></label>
                                                        <select id="organisation_id" name="organisation_id"
                                                            class="input w-full border mt-2 custm-drpdwn" required>
                                                            <option value="">-- Select Organisation --</option>
                                                            @foreach ($organisations as $organisation)
                                                                <option value="{{ $organisation->organisation_id }}"
                                                                    {{ old('organisation_id', $organisation->is_current == 1) == $organisation->organisation_id ? 'selected' : '' }}>
                                                                    {{ $organisation->organisation_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-organisation"></div>
                                                    </div>
                                                </div>
                                                <div class="w-6/12 px-4">
                                                    <div class="mt-3">
                                                        <label>Accounting Year <span style="color: red">*</span></label>
                                                        <select class="input w-full border mt-2"
                                                            name="accounting_year_financial" id="accounting_year_financial">
                                                            <option value="">Select Financial Year</option>
                                                            @php
                                                                $currentYear = date('Y');
                                                                $startYear = 2016;
                                                            @endphp
                                                            @for ($year = $startYear; $year <= $currentYear; $year++)
                                                                @php
                                                                    $start = \Carbon\Carbon::createFromDate(
                                                                        $year,
                                                                        4,
                                                                        1,
                                                                    )->format('d-m-Y');
                                                                    $end = \Carbon\Carbon::createFromDate(
                                                                        $year + 1,
                                                                        3,
                                                                        31,
                                                                    )->format('d-m-Y');
                                                                    $range = $start . ' to ' . $end;
                                                                @endphp
                                                            @if (!in_array($range, $inactiveYears))
                                                                    <option value="{{ $range }}"
                                                                        {{ in_array($range, $activeYears) ? 'selected' : '' }}>
                                                                        {{ $range }}
                                                                    </option>
                                                                @endif
                                                            @endfor
                                                        </select>

                                                        @error('accounting_year_financial')
                                                            <div class="text-theme-6 mt-2 text-sm">{{ $message }}</div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                {{-- </div> --}}

                            </div>
                            <div class="sm:pl-5 mt-5 flex items-center space-x-3">
                                <a href="{{ route('accounting_years.index') }}" class="mr-2"><span
                                        class="inline-flex items-center px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white">
                                        ← Back
                                    </span></a>
                                <button type="submit"
                                    class="inline-flex items-center justify-center w-24 px-4 py-2 rounded bg-theme-1 text-white">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END: Horizontal Form -->
        </div>
        <!-- END: Select Options -->
    </div>
    {{-- <div class="intro-y col-span-12 lg:col-span-6">



    </div> --}}
@endsection
