@extends('master.authMaster')

@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
            <h2 class="text-xl font-bold mb-6">Add New Income Head</h2>
            @php
                $orgId = \App\Models\Organisation::current()->organisation_id;
            @endphp


            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <div class="mt-3">
                        <label>Organisation <span style="color: red">*</span></label>
                        <select id="organisation_id" name="organisation_id" class="input w-full border mt-2" disabled>
                            <option value="">-- Select Organisation --</option>
                            @foreach ($organisations as $organisation)
                                <option value="{{ $organisation->organisation_id }}"
                                    {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                    {{ $organisation->organisation_name }}
                                </option>
                            @endforeach
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-organisation"></div>
                    </div>
                </div>

                <input type="hidden" value="{{ $orgId }}" id="organisation_id" name="organisation_id">
                <div>
                    <div class="mt-3" id="accountTypeWrapper">
                        <label>Division </label>
                        <select id="account_type_id" name="account_type_id" class="input w-full border mt-2">
                            <option value="">-- Select Account Type --</option>
                        </select>
                        <small id="accountTypeMsg" class="text-red-500" style="display:none;">
                            Please select organisation first
                        </small>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                    </div>
                </div>

                <div>
                    <label class="block font-medium">Income Head Group </label>
                    <select id="income_head_group_id" name="income_head_group_id"
                        class="w-full border p-2 rounded custm-drpdwn">
                        <option value="">-- Select Income Head Group --</option>
                        @foreach ($incomeHeadGroups as $group)
                            <option value="{{ $group->income_head_group_ID }}">
                                {{ $group->income_head_group_Name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="text-red-500 text-sm mt-1 error-message" id="error-income-head-group"></div>
                </div>

                <div>
                    <label class="block font-medium">Income Head Name <span class="text-red-500">*</span></label>
                    <input type="text" id="income_head_name" name="income_head_name" class="w-full border p-2 rounded">
                    <div class="text-red-500 text-sm mt-1 error-message" id="error-income-head-name"></div>
                </div>

                <div>
                    <div class="flex space-x-6 mt-2">
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" name="head_type" value="recipt" id="head_type" class="w-4 h-4"><label class="block font-medium text-gray-700">This income mark as <b>recipt</b></label>
                        </label>
                    </div>
                </div>
            </div>

            <div class="sm:pl-5 mt-5">
                <a href="{{ route('incomehead.index') }}"
                    class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                <button type="button" id="saveIncomeHead" class="button w-24 bg-theme-1 text-white">Save</button>
            </div>
        </div>
    </div>

    {{-- SweetAlert2 --}}
   <script src="{{ asset('js/skj-validations@v1.js')}}"></script>

    <script>
        //organisation and accountype checking start.
        let accountTypes = @json($accountTypes);
        let orgSelect = document.getElementById('organisation_id');
        let accSelect = document.getElementById('account_type_id');
        let msg = document.getElementById('accountTypeMsg');


        let oldOrg = "{{ old('organisation_id', $orgId) }}";
        let oldAcc = "{{ old('account_type_id') }}";

        function populateAccountTypes(oldOrg) {
            accSelect.innerHTML = '<option value="">-- Select Account Type --</option>';

            if (oldOrg) {
                let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

                if (filtered.length > 0) {
                    document.getElementById("accountTypeWrapper").style.display = "block";
                    filtered.forEach(at => {
                        let option = document.createElement('option');
                        option.value = at.account_type_id;
                        option.textContent = at.account_type_Name;

                        if (oldAcc == at.account_type_id) {
                            option.selected = true;
                        }
                        accSelect.appendChild(option);
                    });

                    accSelect.disabled = false;
                    msg.style.display = "none";
                } else {
                    accSelect.disabled = true;
                    msg.textContent = "No account types found for this organisation.";
                    msg.style.display = "block";
                    document.getElementById("accountTypeWrapper").style.display = "none";
                }
            } else {
                accSelect.disabled = true;
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
            }
        }

        orgSelect.addEventListener('change', function() {
            populateAccountTypes(this.value);
        });

        accSelect.addEventListener('focus', function() {
            if (!orgSelect.value) {
                msg.textContent = "Please select organisation first.";
                msg.style.display = "block";
                setTimeout(() => msg.style.display = "none", 2000);
            }
        });

        if (oldOrg) {
            populateAccountTypes(oldOrg);
        }
        //organisation and accountype checking end.
        document.addEventListener("DOMContentLoaded", function() {
            document.getElementById("saveIncomeHead").addEventListener("click", function() {
                document.querySelectorAll('.error-message').forEach(el => el.innerText = '');

                let formData = {
                    organisation_id: document.getElementById("organisation_id").value,
                    account_type_id: document.getElementById("account_type_id").value,
                    income_head_group_id: document.getElementById("income_head_group_id").value,
                    income_head_name: document.getElementById("income_head_name").value ?? null,
                    head_type: document.getElementById("head_type").value ?? null,
                    _token: "{{ csrf_token() }}"
                };

                fetch("{{ route('incomehead.store') }}", {
                        method: "POST",
                        headers: {
                            "Accept": "application/json",
                            "X-Requested-With": "XMLHttpRequest",
                            "Content-Type": "application/json",
                            "X-CSRF-TOKEN": "{{ csrf_token() }}"
                        },
                        body: JSON.stringify(formData)
                    })
                    .then(async response => {
                        let data = await response.json();

                        if (response.ok) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: data.message,
                                timer: 2000,
                                showConfirmButton: false
                            }).then(() => {
                                window.location.href = "{{ route('incomehead.index') }}";
                            });
                        } else if (response.status === 422) {

                            if (data.errors.income_head_name) {
                                document.getElementById("error-income-head-name").innerText = data
                                    .errors.income_head_name[0];
                            }
                            if (data.errors.income_head_group_id) {
                                document.getElementById("error-income-head-group").innerText = data
                                    .errors.income_head_group_id[0];
                            }
                            if (data.errors.organisation_id) {
                                document.getElementById("error-organisation").innerText = data
                                    .errors.organisation_id[0];
                            }
                        } else {
                            Swal.fire('Error', data.message || 'Something went wrong!', 'error');
                        }
                    })
                    .catch(error => {
                        console.error(error);
                        Swal.fire('Error', 'An error occurred!', 'error');
                    });
            });
        });
        $("#income_head_name").on("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        });

         $(document).ready(function() {
            //  Correct: just assign the template string to the variable
            let libilities_html = `
                <div>
                    <label class="block font-medium text-gray-700">Choose Asset Type</label>
                    <div class="flex space-x-6 mt-2">
                        <label class="flex items-center space-x-2">
                            <input type="radio" name="liabilities_type" value="fixed_liabilities" id="liabilitiesType" class="w-4 h-4" >
                            <span>Fixed Liabilities</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="radio" name="liabilities_type" value="current_libilities" id="liabilitiesType" class="w-4 h-4" checked>
                            <span>Current Libilities</span>
                        </label>
                    </div>
                </div>

                <div>
                    <label class="block font-medium">Asset Opening Balance</label>
                    <input type="text" id="asset_opening_balance" name="asset_opening_balance" class="w-full border p-2 rounded mt-2">
                </div>
            `;
            let payment_html = `<div class="flex space-x-6 mt-2">
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" name="payment_type" value="payment" id="paymentType" class="w-4 h-4"><label class="block font-medium text-gray-700">This expense mark as <b>Payment</b></label>
                        </label>
                    </div>`;

            $('#expense_head_group_id').on('change', function() {
                let expense_head_group = $(this).val();

                if (expense_head_group != '' && expense_head_group == 3) {
                    $('#asset_type').html(asset_html);

                } else {
                    // ❌ .html() with no arguments does nothing
                    // ✅ Use .empty() or .html('') to clear content
                    $('#asset_type').html(payment_html);
                }
            });

            // Handle the Clear button click dynamically (since button is added after change)



        });
    </script>
@endsection
