@extends('master.authMaster')
@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5 income-head-top-sec">
            <h2 class="text-lg font-medium mr-auto">
                Income Heads </h2>

            @php
                $menuId = \App\Models\Menu::where('route', 'incomehead.index')->value('id');
                $permissionService = app(\App\Services\PermissionService::class);
                $canWrite = $permissionService->hasPermission($menuId, 'x');
            @endphp

            @if ($permissionService->hasPermission($menuId, 'w'))
                <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                    <a href="{{ route('incomehead.create') }}">
                        <button class="button text-white bg-theme-1 shadow-md">
                            Add Income Head
                        </button>
                    </a>
                </div>
            @endif
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">

        @if (session('success'))
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-9 text-theme-9 dark:border-theme-9">
                {{ session('success') }}
            </div>
        @elseif (session('error'))
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
                {{ session('error') }}
            </div>
        @endif

        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">

                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                {{-- <option value="5">5</option> --}}
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center flex-wrap">
                            <label for="org-size" class="form-label mb-0">Income Heads as per Organisation:</label>
                            <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                <option value="">All Income Heads</option>
                                @foreach ($organisations as $organisation)
                                    <option value="{{ $organisation->organisation_id }}">
                                        {{ $organisation->organisation_name }}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>
                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>

            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="accounting-year-table"></div>
        </div>
    </div>
    <!-- END: HTML Table Data -->

    <link href="{{ asset('build/assets/css/tabulator.min.css') }}" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tabulator/6.3.1/css/tabulator_materialize.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://unpkg.com/tabulator-tables@6.3.1/dist/js/tabulator.min.js"></script>


    <script>
        var canWrite = @json($canWrite); //execute
        var canRead = @json($permissionService->hasPermission($menuId, 'r')); //read
        var canExecute = @json($permissionService->hasPermission($menuId, 'w')); //write

        var currentYearRange =
            "{{ \Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y') }}";
        var table = new Tabulator("#accounting-year-table", {
            ajaxURL: "{{ route('incomehead.details') }}",
            ajaxParams: function() {
                return {
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                    search: document.querySelector("#search-string").value,
                    organisation_id: document.querySelector("#org-size").value,

                };
            },
            ajaxConfig: "POST",
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: false,
            layout: "fitColumns",
            search: true,
            movableRows: true,
            movableColumns: true,
            // 🔹 Custom loader spinner
            ajaxLoaderLoading: `
                   <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>Loading Data</div>
                `,

            // placeholder: "<span style='color: red; font-size: 16px; font-weight: bold;'>No Data Available</span>",

            columnDefaults: {
                tooltip: true,
            },
            columns: [{
                    title: "SL",
                    hozAlign: "center",
                    formatter: function(cell, formatterParams, onRendered) {
                        let row = cell.getRow();
                        let data = row.getData();
                        let page = table.getPage();
                        let perPage = table.getPageSize();

                        if (!page) page = 0;
                        if (!perPage) perPage = 10;

                        return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                    },
                    // maxWidth: 200
                },
                {
                    title: "Income Head Name",
                    field: "income_head_name",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },
                {
                    title: " Grp. Head Name",
                    field: "group_name",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },

                // {
                //     title: "Status",
                //     field: "status",
                //     headerSort: false,
                //     hozAlign: "center",
                //     visible: canWrite,
                //     formatter: function(cell) {
                //         const rowData = cell.getRow().getData();

                //         let badgeClass = "badge bg-secondary";
                //         if (rowData.status === "active") {
                //             badgeClass =
                //                 "rounded-md flex items-center justify-center px-5 py-1 mb-1 border border-theme-9 text-theme-9 dark:border-theme-9 w-20 h-6";
                //         } else if (rowData.status === "inactive") {
                //             badgeClass =
                //                 "rounded-md flex items-center justify-center px-5 py-1 mb-1 border border-theme-6 text-theme-6 dark:border-theme-6 w-20 h-6";
                //         }

                //         return `
            //            <div class="flex justify-center">
            //             <span class="status-toggle ${badgeClass}" 
            //                 data-id="${rowData.accounting_year_id}" 
            //                 style="cursor:pointer;">
            //                 ${rowData.status}
            //             </span>
            //             </div>
            //         `;
                //     },
                //     cellClick: function(e, cell) {
                //         if (!canWrite) return;

                //         const rowData = cell.getRow().getData();
                //         const id = rowData.accounting_year_id;
                //         const currentStatus = rowData.status;
                //         const newStatus = currentStatus === "active" ? "inactive" : "active";

                //         Swal.fire({
                //             title: "Are you sure?",
                //             text: `You are about to change status to "${newStatus}".`,
                //             icon: "warning",
                //             showCancelButton: true,
                //             confirmButtonText: "Yes",
                //             cancelButtonText: "No",
                //             customClass: {
                //                 confirmButton: "btn btn-success",
                //                 cancelButton: "btn btn-danger"
                //             },
                //             buttonsStyling: true
                //         }).then((result) => {
                //             if (result.isConfirmed) {
                //                 fetch(`/accounting-years/${id}/status`, {
                //                         method: "POST",
                //                         headers: {
                //                             "X-CSRF-TOKEN": document.querySelector(
                //                                 'meta[name="csrf-token"]').content,
                //                             "Content-Type": "application/json",
                //                         }
                //                     })
                //                     .then(res => res.json())
                //                     .then(data => {
                //                         if (data.success) {
                //                             cell.getRow().update({
                //                                 status: data.status
                //                             });

                //                             Swal.fire({
                //                                 title: "Updated!",
                //                                 text: `Status changed to "${data.status}".`,
                //                                 icon: "success",
                //                                 timer: 1500,
                //                                 showConfirmButton: false
                //                             });
                //                         } else {
                //                             Swal.fire({
                //                                 title: "Error!",
                //                                 text: data.message ||
                //                                     "Something went wrong.",
                //                                 icon: "error",
                //                             });
                //                         }
                //                     });
                //             }
                //         });
                //     }

                //     // cellClick: function(e, cell) {
                //     //     if (!canWrite) return;
                //     //     const id = cell.getRow().getData().accounting_year_id;

                //     //     fetch(`/accounting-years/${id}/status`, {
                //     //             method: "POST",
                //     //             headers: {
                //     //                 "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]')
                //     //                     .content,
                //     //                 "Content-Type": "application/json",
                //     //             }
                //     //         })
                //     //         .then(res => res.json())
                //     //         .then(data => {
                //     //             if (data.success) {
                //     //                 cell.getRow().update({
                //     //                     status: data.status
                //     //                 });
                //     //             }
                //     //         });
                //     // }
                // }

            ],
            rowFormatter: function(row) {
                const data = row.getData();
                if (data.is_current === 1) {
                    row.getElement().style.backgroundColor = "lightblue";
                    row.getElement().style.color = "black";
                }
            },

            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total
                };
            }
        });
        document.getElementById("page-size").addEventListener("change", function() {
            table.setPageSize(Number(this.value));
        });
        document.getElementById("org-size").addEventListener("change", function() {
            table.setData();
        });
        document.getElementById("search-string").addEventListener("input", function() {
            table.setData();
        });
    </script>
    <style>
        #accounting-year-table {
            position: relative;
        }

        #accounting-year-table .tabulator-loader {
            position: absolute !important;
            inset: 0 !important;
            display: flex !important;
            align-items: center;
            justify-content: center;
            background: rgba(255, 255, 255, 0.7) !important;
            z-index: 9999 !important;
        }

        #accounting-year-table .tabulator-loader-msg {
            background: transparent !important;
            border: none !important;
            box-shadow: none !important;
            padding: 0 !important;
        }
    </style>
@endsection
