@extends('master.authMaster')

@section('content')
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Date Filter -->
                    <div class="flex justify-between items-center mb-4">

                        <div>
                            <h3 class="text-base font-medium text-black">
                                <u>{{ ucfirst($donor->donor_name) }}</u>
                            </h3>
                        </div>

                        {{-- <div class="flex gap-4 items-end">
                            <div>
                                <label for="from_date" class="text-sm">From Date</label>
                                <input type="date" id="from_date" class="border rounded p-2">
                            </div>
                            <div>
                                <label for="to_date" class="text-sm">To Date</label>
                                <input type="date" id="to_date" class="border rounded p-2">
                            </div>
                            <div class="flex items-end gap-2">
                                <button type="button" id="filterBtn"
                                    class="bg-blue-600 text-white px-4 py-2 rounded shadow">Filter</button>
                                <button type="button" id="clearBtn"
                                    class="bg-gray-500 text-white px-4 py-2 rounded shadow">Clear</button>
                            </div>
                        </div> --}}

                    </div>

                    <div class="sngl-box">
                        <!-- Cash Payments -->
                        <div>
                            <h3 class="text-base font-medium mb-2 text-black mb-4">Transaction History</h3>
                            @php
                                $totalPaid = 0;

                            @endphp
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                                <thead>
                                    <tr>
                                        <th class="p-3 text-left">Date</th>
                                        <th class="p-3 text-left">Income Head Name</th>
                                        <th class="p-3 text-left">Narration</th>
                                        <th class="p-3 text-right">Received Amount</th>
                                        {{-- <th class="p-3 text-center">Type</th> --}}
                                    </tr>
                                </thead>
                                <tbody id="cashTable" class="divide-y"></tbody>
                                <tfoot>
                                    @forelse($donorRecords as $record)
                                        @php $totalPaid += $record->paid_amount; @endphp
                                        <tr class="hover:bg-gray-50">
                                            <td class="p-3">
                                                {{ \Carbon\Carbon::parse($record->created_at)->format('d-m-Y') }}</td>
                                            <td class="p-3">
                                                {{ $record->income_head_name }}</td>
                                            <td class="p-3">
                                                {{ $record->transaction_narration }}</td>

                                            <td class="p-3 text-right font-medium text-blue-600">
                                                ₹ {{ number_format($record->paid_amount, 2) }}
                                            </td>
                                            {{-- <td class="p-3 text-center">
                                                {{ ucfirst($record->income_expense) }}
                                            </td> --}}

                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="5" class="p-3 text-center text-gray-500">No records found</td>
                                        </tr>
                                    @endforelse

                                </tfoot>
                            </table>
                        </div>


                        <!-- Grand Total -->
                        <div class="mt-4">
                            <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden">
                                <tfoot>

                                    <tr class="bg-gray-200 font-bold">
                                        <td colspan="2" class="p-3 text-right">Grand Total</td>
                                        <td class="p-3 text-right text-black">
                                            ₹ {{ number_format($totalPaid, 2) }}
                                        </td>
                                        <td colspan="2"></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                    </div>
                    <div class="mt-6">
                        <button onclick="history.back()"
                            class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                            ← Back
                        </button>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
